/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.report.tplop;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import org.apache.commons.lang.StringUtils;

public class MftorderRptUnBackFlushOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(MftorderRptUnBackFlushOp.class);
    public static Map<String, String> entityMap = new HashMap<String, String>();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("sumentry");
        fieldKeys.add("sumentry.mftentryid");
        fieldKeys.add("sumentry.completbsqty");
        fieldKeys.add("sumentry.seq");
        fieldKeys.add("sumentry.manufactureentryid");
        fieldKeys.add("sumentry.backflushstatus");
        fieldKeys.add("billno");
        fieldKeys.add("bookdate");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String unBackFlushEntryPks;
        super.beginOperationTransaction(e);
        String entityName = this.billEntityType.getName();
        if (entityMap.containsKey(entityName) && StringUtils.isNotBlank((String)(unBackFlushEntryPks = this.getOption().getVariableValue("unBackFlushEntryPks")))) {
            logger.info(String.format("MftorderRptUnBackFlushOp\uff1abeginOperationTransaction->start:[unBackFlushEntryPks:%s]", unBackFlushEntryPks));
            List mftOrderRptEntryPkValues = JSONArray.parseArray((String)unBackFlushEntryPks, Long.class);
            QFilter qfilter = new QFilter("billentry.srcbillentryid", "in", (Object)mftOrderRptEntryPkValues);
            DynamicObject[] mftProOrders = BusinessDataServiceHelper.load((String)"im_mdc_mftproorder", (String)"id,billno,billentry.srcbillid,billentry.srcbillentryid", (QFilter[])new QFilter[]{qfilter});
            if (null != mftProOrders && mftProOrders.length > 0) {
                this.delBackFlush(entityName, mftProOrders, e.getDataEntities());
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u6570\u636e\u884c\u90fd\u672a\u5012\u51b2\uff0c\u4e0d\u652f\u6301\u53cd\u5012\u51b2\u3002", (String)"MftorderRptUnBackFlushOp_0", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private void delBackFlush(String entityName, DynamicObject[] mftProOrders, DynamicObject[] mftOrderReportBills) {
        HashMap<Long, Long> bfParam = new HashMap<Long, Long>(16);
        String sourcebillentry = "B";
        for (DynamicObject mftProOrder : mftProOrders) {
            String errInfo;
            long mftOrderEntryId = 0L;
            int seq = 0;
            String billNo = "";
            long mftOrderRptEntryIdInProOrder = 0L;
            DynamicObjectCollection mftProOrderEntrys = mftProOrder.getDynamicObjectCollection("billentry");
            if (null != mftProOrderEntrys && mftProOrderEntrys.size() > 0) {
                DynamicObject mftProOrderEntry = (DynamicObject)mftProOrderEntrys.get(0);
                mftOrderRptEntryIdInProOrder = mftProOrderEntry.getLong("srcbillentryid");
                block3: for (DynamicObject mftOrderReportBill : mftOrderReportBills) {
                    DynamicObjectCollection mftOrderReportEntrys = mftOrderReportBill.getDynamicObjectCollection("sumentry");
                    for (DynamicObject mftOrderReportEntry : mftOrderReportEntrys) {
                        long mftOrderRptEntryIdTemp = Long.parseLong(mftOrderReportEntry.getPkValue().toString());
                        if (mftOrderRptEntryIdTemp != mftOrderRptEntryIdInProOrder) continue;
                        if (StringUtils.equals((String)entityName, (String)"pom_mftorderreport") || StringUtils.equals((String)entityName, (String)"prop_mftorderreport")) {
                            mftOrderEntryId = mftOrderReportEntry.getLong("mftentryid");
                        } else {
                            sourcebillentry = "C";
                            mftOrderEntryId = mftOrderReportEntry.getDynamicObject("manufactureentryid").getLong("id");
                        }
                        seq = mftOrderReportEntry.getInt("seq");
                        billNo = mftOrderReportBill.getString("billno");
                        continue block3;
                    }
                }
            }
            if (!"".equals(errInfo = this.unBackFlush(mftProOrder.getLong("id"), mftProOrder.getString("billno")))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s:\u7b2c%2$s\u884c\u5206\u5f55\u53cd\u5012\u51b2\u5931\u8d25\uff1a%3$s", (String)"MftorderRptUnBackFlushOp_5", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), billNo, seq, errInfo));
            }
            ArrayList orderReportBillEntryIds = new ArrayList(16);
            for (DynamicObject mftOrderReportBill : mftOrderReportBills) {
                DynamicObjectCollection coll = mftOrderReportBill.getDynamicObjectCollection("sumentry");
                coll.forEach(a -> orderReportBillEntryIds.add(a.getLong("id")));
            }
            if (!orderReportBillEntryIds.isEmpty()) {
                DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"MdcBackFlushUpdateBFStatusService", (String)"updateBFStatusByEntryId", (Object[])new Object[]{orderReportBillEntryIds, this.billEntityType.getName()});
            }
            bfParam.put(mftOrderRptEntryIdInProOrder, mftOrderEntryId);
        }
        if (bfParam.size() > 0) {
            try {
                logger.info(String.format("MftorderRptUnBackFlushOp\uff1aunBackFlush->invokeBizService->start:[bfParam:%s]", ((Object)bfParam).toString()));
                String stockentity = "pom_mftstock";
                if ("prop_mftorderreport".equals(this.billEntityType.getName())) {
                    stockentity = "prop_mftstock";
                }
                DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"MdcCheckMftorderService", (String)"batchBackFlushClose", (Object[])new Object[]{bfParam, sourcebillentry, stockentity});
                logger.info("MftorderRptUnBackFlushOp\uff1aunBackFlush->invokeBizService->end:");
            }
            catch (Exception ex) {
                throw new KDBizException(new ErrorCode("MftorderRptUnBackFlushOp", String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u751f\u6210\u5012\u51b2\u5173\u95ed\u65b9\u6cd5\u63a5\u53e3[scmc.im.MdcCheckMftorderService->batchBackFlushClose]\u8c03\u7528\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s", (String)"MftorderRptUnBackFlushOp_6", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), ex.getMessage() != null ? ex.getMessage() : ex.toString())), new Object[]{ex});
            }
        }
    }

    private String unBackFlush(Long id, String billno) {
        String result = "";
        ArrayList<Long> mftProOrderPKList = new ArrayList<Long>();
        mftProOrderPKList.add(id);
        OperateOption auditOption = OperateOption.create();
        auditOption.setVariableValue("ignorewarn", String.valueOf(true));
        auditOption.setVariableValue("ignoreinteraction", String.valueOf(true));
        auditOption.setVariableValue("strictvalidation", String.valueOf(true));
        logger.info(String.format("MftorderRptUnBackFlushOp\uff1aunBackFlush->unAudit->start:[mftProOrderPKList:%s;billno:%s]", id, billno));
        OperationResult unAuditResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"im_mdc_mftproorder", (Object[])mftProOrderPKList.toArray(), (OperateOption)auditOption);
        if (!unAuditResult.isSuccess()) {
            result = String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5012\u51b2\u9886\u6599\u5355%1$s\u5931\u8d25\uff1a%2$s", (String)"MftorderRptUnBackFlushOp_7", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), billno, this.getErrDetail(unAuditResult));
        } else {
            logger.info(String.format("MftorderRptUnBackFlushOp\uff1aunBackFlush->delete->start:[mftProOrderPKList:%s]", id));
            OperationResult delResult = OperationServiceHelper.executeOperate((String)"delete", (String)"im_mdc_mftproorder", (Object[])mftProOrderPKList.toArray(), (OperateOption)OperateOption.create());
            if (delResult.getSuccessPkIds().size() < mftProOrderPKList.size()) {
                result = String.format(ResManager.loadKDString((String)"\u5220\u9664\u5012\u51b2\u9886\u6599\u5355%1$s\u5931\u8d25\u3002", (String)"MftorderRptUnBackFlushOp_8", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), billno);
            }
        }
        return result;
    }

    private String getErrDetail(OperationResult optResult) {
        StringBuilder errDetail = new StringBuilder();
        errDetail.append(optResult.getMessage());
        for (IOperateInfo errInfo : optResult.getAllErrorOrValidateInfo()) {
            errDetail.append(errInfo.getMessage());
        }
        return errDetail.toString();
    }

    static {
        entityMap.put("sfc_processreportbill", "sfc_processreportbill");
        entityMap.put("pom_mftorderreport", "pom_mftorderreport");
        entityMap.put("prop_mftorderreport", "prop_mftorderreport");
        entityMap.put("prop_processreportbill", "prop_processreportbill");
    }
}

