/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.report.validator;

import java.util.Date;
import java.util.HashMap;
import kd.bd.mpdm.business.helper.SystemCallParamHelper;
import kd.bd.mpdm.common.enums.OperateEnum;
import kd.bd.mpdm.common.utils.AcctOrgCloseDateUtil;
import kd.bd.mpdm.common.utils.DateUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.AbstractValidator;

public class ReportBookDateValidator
extends AbstractValidator {
    public void validate() {
        String operate = this.getOperateKey();
        HashMap<Long, Date> closeDateMap = new HashMap<Long, Date>(16);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            Date reportDate;
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            Date closeDate = (Date)closeDateMap.get(obj.getDynamicObject("org").getLong("id"));
            if (closeDate == null) {
                closeDate = AcctOrgCloseDateUtil.getAcctOrgCloseDate((Long)obj.getDynamicObject("org").getLong("id"));
                closeDateMap.put(obj.getDynamicObject("org").getLong("id"), closeDate);
            }
            if ("submit".equals(operate)) {
                this.autoSetBookDate(obj, closeDate);
            }
            Date bookDate = obj.getDate("bookdate");
            String name = ResManager.loadKDString((String)"\u6c47\u62a5", (String)"ReportBookDateValidator_4", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
            if ("sfc_reportresource_adjust".equals(this.entityKey)) {
                reportDate = obj.getDate("adjustdate");
                name = ResManager.loadKDString((String)"\u8c03\u6574", (String)"ReportBookDateValidator_5", (String)"bd-mpdm-opplugin", (Object[])new Object[0]);
            } else {
                reportDate = obj.getDate("reportdate");
            }
            if (bookDate == null || reportDate == null) continue;
            if (bookDate.compareTo(DateUtils.getShortDate((Date)reportDate)) < 0) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u8d26\u65e5\u671f\uff08%1$s\uff09\u5c0f\u4e8e%2$s\u65e5\u671f\uff08%2$s\uff09\uff0c%4$s\u5931\u8d25\uff0c\u8bf7\u4fee\u6539\u8bb0\u8d26\u65e5\u671f\u3002", (String)"ReportBookDateValidator_6", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), DateUtils.transDate((Object)bookDate), name, DateUtils.transDate((Object)reportDate), OperateEnum.getValue((String)operate)));
            }
            if (closeDate == null || bookDate.compareTo(closeDate) > 0) continue;
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u8d26\u65e5\u671f\uff08%1$s\uff09\u5c0f\u4e8e\u7b49\u4e8e\u5173\u8d26\u65e5\u671f\uff08%2$s\uff09\uff0c%3$s\u5931\u8d25\uff0c\u8bf7\u4fee\u6539\u8bb0\u8d26\u65e5\u671f\u3002", (String)"ReportBookDateValidator_7", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), DateUtils.transDate((Object)bookDate), DateUtils.transDate((Object)closeDate), OperateEnum.getValue((String)operate)));
        }
    }

    private void autoSetBookDate(DynamicObject bill, Date closeDate) {
        String entityTypeName = bill.getDataEntityType().getName();
        Date bookDate = bill.getDate("bookdate");
        if (closeDate != null) {
            boolean bizDateEqualsBookDate = SystemCallParamHelper.isEnable((String)"sbs_scmcapplevelparam", (String)"INV0004");
            boolean autoCalBookDateByCloseDate = SystemCallParamHelper.isEnable((String)"sbs_scmcapplevelparam", (String)"INV0008");
            closeDate = DateUtils.getAddDate((Date)closeDate, (int)1);
            if (autoCalBookDateByCloseDate && bookDate.before(closeDate)) {
                bill.set("bookdate", (Object)DateUtils.getShortDate((Date)closeDate));
                if (bizDateEqualsBookDate) {
                    String bizDate = "sfc_reportresource_adjust".equals(entityTypeName) ? "adjustdate" : "reportdate";
                    bill.set(bizDate, (Object)closeDate);
                }
            }
        }
    }
}

