/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.routebasedata;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public abstract class BaseTplOp
extends AbstractOperationServicePlugIn {
    public abstract String getEntityKeyImpl();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("enable");
        e.getFieldKeys().add("disableor");
        e.getFieldKeys().add("disabletime");
        e.getFieldKeys().add("enableor");
        e.getFieldKeys().add("enabletime");
        e.getFieldKeys().add("status");
        e.getFieldKeys().add("auditor");
        e.getFieldKeys().add("audittime");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String key = e.getOperationKey();
        DynamicObject[] objs = e.getDataEntities();
        if (objs == null || objs.length == 0) {
            return;
        }
        List list = objs[0].getDataEntityType().getJsonSerializerProperties();
        String string = list.toString();
        if ("save".equals(key) || "submit".equals(key) || "enable".equals(key)) {
            this.saveOperation(string, objs);
        } else if ("audit".equals(key)) {
            this.auditOperation(string, objs);
        } else if ("disable".equals(key)) {
            this.disableOperation(string, objs);
        } else if ("unaudit".equals(key)) {
            this.unauditOperation(string, objs);
        }
    }

    private void saveOperation(String string, DynamicObject[] objs) {
        if (string == null || !string.contains("enableor") || !string.contains("enabletime")) {
            return;
        }
        List<Object> updateList = new ArrayList();
        ArrayList<Long> changePkList = new ArrayList<Long>(4);
        for (int n = 0; n < objs.length; ++n) {
            DynamicObject changeObj = objs[n];
            if (!"1".equals(changeObj.getString("enable"))) continue;
            changePkList.add(changeObj.getLong("id"));
        }
        updateList = this.getUpdataList(changePkList, "save");
        if (updateList.isEmpty()) {
            return;
        }
        SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
    }

    private void auditOperation(String string, DynamicObject[] objs) {
        if (string == null || !string.contains("auditor") || !string.contains("audittime")) {
            return;
        }
        List<Object> updateList = new ArrayList();
        ArrayList<Long> changePkList = new ArrayList<Long>(4);
        for (int n = 0; n < objs.length; ++n) {
            DynamicObject changeObj = objs[n];
            if (!"C".equals(changeObj.getString("status"))) continue;
            changePkList.add(changeObj.getLong("id"));
        }
        updateList = this.getUpdataList(changePkList, "audit");
        if (updateList.isEmpty()) {
            return;
        }
        SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
    }

    private void unauditOperation(String string, DynamicObject[] objs) {
        if (string == null || !string.contains("auditor") || !string.contains("audittime")) {
            return;
        }
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(2);
        for (int n = 0; n < objs.length; ++n) {
            DynamicObject changeObj = objs[n];
            changeObj.set("auditor", null);
            changeObj.set("audittime", null);
            updateList.add(changeObj);
        }
        SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
    }

    private void disableOperation(String string, DynamicObject[] objs) {
        if (string == null || !string.contains("disableor") || !string.contains("disabletime")) {
            return;
        }
        List<Object> updateList = new ArrayList();
        ArrayList<Long> changePkList = new ArrayList<Long>(4);
        for (int n = 0; n < objs.length; ++n) {
            DynamicObject changeObj = objs[n];
            if (!"0".equals(changeObj.getString("enable"))) continue;
            changePkList.add(changeObj.getLong("id"));
        }
        updateList = this.getUpdataList(changePkList, "disable");
        if (updateList.isEmpty()) {
            return;
        }
        SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
    }

    private List<DynamicObject> getUpdataList(List<Long> changePkList, String type) {
        String timeFiled;
        String userFiled;
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(2);
        if (changePkList == null) {
            return updateList;
        }
        switch (type) {
            case "save": 
            case "submit": 
            case "enable": {
                userFiled = "enableor";
                timeFiled = "enabletime";
                break;
            }
            case "audit": {
                userFiled = "auditor";
                timeFiled = "audittime";
                break;
            }
            case "disable": {
                userFiled = "disableor";
                timeFiled = "disabletime";
                break;
            }
            default: {
                userFiled = "";
                timeFiled = "";
            }
        }
        DynamicObject entityDO = ORM.create().newDynamicObject(this.getEntityKeyImpl());
        DynamicObject[] objArray = BusinessDataServiceHelper.load((Object[])changePkList.toArray(new Object[changePkList.size()]), (DynamicObjectType)entityDO.getDynamicObjectType());
        Long userId = UserServiceHelper.getCurrentUserId();
        DynamicObject userObj = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user", (String)"id,number,name");
        if (objArray != null) {
            for (int i = 0; i < objArray.length; ++i) {
                if (StringUtils.isNotEmpty((CharSequence)userFiled)) {
                    objArray[i].set(userFiled, (Object)userObj);
                }
                if (StringUtils.isNotEmpty((CharSequence)timeFiled)) {
                    objArray[i].set(timeFiled, (Object)new Date());
                }
                updateList.add(objArray[i]);
            }
        }
        return updateList;
    }
}

