/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.routebasedata;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.AbstractValidator;

public class ClassSystemValidator
extends AbstractValidator {
    public void validate() {
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObjectCollection col;
            DynamicObject classsystem = this.dataEntities[i].getDataEntity();
            BigDecimal workShiftTIme = new BigDecimal(classsystem.get("classsystemtime").toString());
            if (workShiftTIme.compareTo(new BigDecimal(24)) > 0) {
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u73ed\u5236\u603b\u65f6\u957f\u4e0d\u80fd\u8d85\u8fc724\u5c0f\u65f6\uff01", (String)"ClassSystemValidator_0", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
            }
            if ((col = classsystem.getDynamicObjectCollection("entryentity")).size() == 1) continue;
            this.getRepeatRow(col, i);
        }
    }

    private void getRepeatRow(DynamicObjectCollection col, int row) {
        ArrayList<Integer> repectList = new ArrayList<Integer>();
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject entry = (DynamicObject)col.get(i);
            int workStartTime = Integer.parseInt(entry.get("workstarttime").toString());
            int workEndTime = Integer.parseInt(entry.get("workendtime").toString());
            boolean isCrossDay = entry.getBoolean("iscrossday");
            repectList.addAll(this.compareDay(col, workStartTime, workEndTime, isCrossDay, i));
        }
        HashSet set = new HashSet(repectList);
        if (!(repectList = new ArrayList(set)).isEmpty()) {
            this.addErrorMessage(this.dataEntities[row], String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u65f6\u95f4\u6bb5\u6709\u91cd\u53e0\uff01", (String)"ClassSystemValidator_2", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), ((Object)repectList).toString()));
        }
    }

    private List<Integer> compareDay(DynamicObjectCollection col, int workStartTime, int workEndTime, boolean isCrossDay, int i) {
        ArrayList<Integer> repectList = new ArrayList<Integer>();
        for (int j = i + 1; j < col.size(); ++j) {
            DynamicObject obj = (DynamicObject)col.get(j);
            int start = Integer.parseInt(obj.get("workstarttime").toString());
            int end = Integer.parseInt(obj.get("workendtime").toString());
            boolean cross = obj.getBoolean("iscrossday");
            boolean flag = this.compareDay1(workStartTime, workEndTime, isCrossDay, cross, start, end);
            if (flag) {
                repectList.add(i + 1);
                repectList.add(j + 1);
            }
            if (isCrossDay && cross) {
                repectList.add(i + 1);
                repectList.add(j + 1);
            }
            if (flag = this.compareDay2(workStartTime, workEndTime, isCrossDay, cross, start, end)) {
                repectList.add(i + 1);
                repectList.add(j + 1);
            }
            if (isCrossDay || !cross || workEndTime < start && workStartTime > end) continue;
            repectList.add(i + 1);
            repectList.add(j + 1);
        }
        return repectList;
    }

    private boolean compareDay1(int workStartTime, int workEndTime, boolean isCrossDay, boolean cross, int start, int end) {
        boolean flag = isCrossDay && !cross && (workStartTime <= end || workEndTime >= start);
        return flag;
    }

    private boolean compareDay2(int workStartTime, int workEndTime, boolean isCrossDay, boolean cross, int start, int end) {
        boolean flag = !isCrossDay && !cross && Math.max(workStartTime, start) <= Math.min(workEndTime, end);
        return flag;
    }
}

