/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.routebasedata;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.route.ProcessRouteVersionUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class ProcessRouteSetVersionValueValidator
extends AbstractValidator {
    public static final DBRoute scmDBRoute = new DBRoute("scm");
    private static final String ENTITY_PARAM = "pdm_routeversioninitset";
    private static final Log log = LogFactory.getLog(ProcessRouteSetVersionValueValidator.class);

    public void validate() {
        String operate = this.getOperateKey();
        ExtendedDataEntity[] objs = this.getDataEntities();
        if (objs == null || objs.length <= 0) {
            return;
        }
        if ("submit".equalsIgnoreCase(operate)) {
            HashMap<Long, String> orgParamMap = new HashMap<Long, String>(16);
            HashSet<Long> unVersionIdSet = new HashSet<Long>(16);
            for (ExtendedDataEntity obj : objs) {
                String msg = "";
                try {
                    msg = this.createRouteVersion(obj.getDataEntity(), orgParamMap, unVersionIdSet);
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    msg = e.getMessage();
                }
                if (msg == null || "".equals(msg)) continue;
                this.addErrorMessage(obj, msg);
            }
        }
    }

    public boolean isEcoRoute(DynamicObject route) {
        return "pdm_ecoroute".equals(route.getDataEntityType().getName());
    }

    public boolean isPdmRoute(DynamicObject route) {
        return "pdm_route".equals(route.getDataEntityType().getName());
    }

    public void initRouteId(DynamicObject obj) {
        Object pk = obj.getPkValue();
        if (pk == null || ((Long)pk).equals(0L)) {
            obj.set("id", (Object)ORM.create().genLongId(obj.getDynamicObjectType().getName()));
        }
    }

    public boolean checkRtIsMulVersion(Long orgId) {
        boolean isExists = false;
        StringBuilder sb = new StringBuilder();
        sb.append(" select ");
        sb.append(" a.fprocesstype, a.fmaterialid ,a.fmaterialgroupid ");
        sb.append(" from t_pdm_route a ");
        sb.append(" where a.fcreateorgid  = ? and fversionid <> 0 ");
        sb.append(" group by a.fprocesstype,a.fmaterialid,a.fmaterialgroupid ");
        sb.append(" having count(distinct a.fversionid) > 1 ");
        try (DataSet ds = DB.queryDataSet((String)(ProcessRouteSetVersionValueValidator.class.getName() + "_rt02"), (DBRoute)scmDBRoute, (String)sb.toString(), (Object[])new Object[]{orgId}).top(1);){
            for (Row arow : ds) {
                isExists = true;
            }
        }
        return isExists;
    }

    public String checkIsEndInit(DynamicObject route) {
        if (this.isPdmRoute(route)) {
            String value;
            DynamicObject createOrg = route.getDynamicObject("createorg");
            String number = createOrg.getPkValue() + "_initend";
            DynamicObject dy = QueryServiceHelper.queryOne((String)ENTITY_PARAM, (String)"value", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
            String string = value = dy == null ? "" : dy.getString("value");
            if (!"true".equals(value)) {
                if (this.checkRtIsMulVersion((Long)createOrg.getPkValue())) {
                    return String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u8fd8\u672a\u5b8c\u6210\u7248\u672c\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u5728\u5de5\u827a\u8def\u7ebf\u7ef4\u62a4\u5217\u8868\u8fdb\u884c\u201c\u7248\u672c\u521d\u59cb\u5316\u201d\u64cd\u4f5c\u3002", (String)"ProcessRouteSetVersionValueValidator_01", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), createOrg.getString("name"));
                }
                DynamicObject paramObjA = QueryServiceHelper.queryOne((String)ENTITY_PARAM, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
                Long paramId = paramObjA == null ? 0L : paramObjA.getLong("id");
                DynamicObject paramObj = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_PARAM);
                if (paramId != null && !paramId.equals(0L)) {
                    paramObj = BusinessDataServiceHelper.loadSingle((Object)paramId, (DynamicObjectType)paramObj.getDynamicObjectType());
                }
                String name = String.format(ResManager.loadKDString((String)"%1$s\u65b0\u65e7\u7248\u672c\u521d\u59cb\u5316_\u63d0\u4ea4", (String)"ProcessRouteSetVersionValueValidator_02", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), createOrg.getString("name"));
                paramObj.set("number", (Object)number);
                paramObj.set("name", (Object)name);
                paramObj.set("value", (Object)"true");
                paramObj.set("enable", (Object)"1");
                paramObj.set("status", (Object)"C");
                paramObj.set("creator", (Object)RequestContext.get().getCurrUserId());
                paramObj.set("createtime", (Object)new Date());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{paramObj});
            }
        }
        return "";
    }

    public String createRouteVersion(DynamicObject obj, Map<Long, String> orgParamMap, Set<Long> unVersionIdSet) {
        String initCheck;
        if (this.isEcoRoute(obj)) {
            return "";
        }
        DynamicObject material = obj.getDynamicObject("material");
        DynamicObject createOrg = obj.getDynamicObject("createorg");
        DynamicObject routeVersion = obj.getDynamicObject("routeversion");
        if (createOrg == null) {
            return "";
        }
        if (ProcessRouteVersionUtils.isExistsHisRtByParam((Long)((Long)createOrg.getPkValue())) && (initCheck = this.checkIsEndInit(obj)) != null && !"".equals(initCheck)) {
            return initCheck;
        }
        if (routeVersion != null) {
            return ProcessRouteVersionUtils.syncOldVersion((DynamicObject)obj);
        }
        boolean isMaterialVersion = ProcessRouteVersionUtils.isMaterialVsersion((DynamicObject)material);
        Long orgId = (Long)createOrg.getPkValue();
        String isOpenVersionS = orgParamMap.get(orgId);
        if (StringUtils.isEmpty((String)isOpenVersionS)) {
            boolean isOpenVersion = ProcessRouteVersionUtils.isRouteVsersion((Long)orgId);
            isOpenVersionS = isOpenVersion ? "true" : "false";
            orgParamMap.put(orgId, isOpenVersionS);
        }
        if (!isMaterialVersion && !"true".equalsIgnoreCase(isOpenVersionS)) {
            return "";
        }
        this.initRouteId(obj);
        DynamicObject newRouteVersion = ProcessRouteVersionUtils.createAndGetRouteVersion((DynamicObject)obj, (boolean)true, unVersionIdSet);
        obj.set("routeversion", (Object)newRouteVersion);
        if (newRouteVersion != null) {
            unVersionIdSet.add((Long)newRouteVersion.getPkValue());
        }
        return ProcessRouteVersionUtils.syncOldVersion((DynamicObject)obj);
    }
}

