/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.routebasedata;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.bomcache.BomUtils;
import kd.bd.mpdm.common.consts.ExistRouteEntity;
import kd.bd.mpdm.common.utils.PdmParamSetHelper;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class ProcessRouteValidator
extends AbstractValidator {
    private Set<String> aMainSet = new HashSet<String>();
    private Set<String> bMainSet = new HashSet<String>();
    private Set<String> cMainSet = new HashSet<String>();
    private Set<String> aReplaceSet = new HashSet<String>();
    private Set<String> bReplaceSet = new HashSet<String>();
    private Set<String> cReplaceSet = new HashSet<String>();
    private Map<Object, Map<Object, Boolean>> workCenterMap = new HashMap<Object, Map<Object, Boolean>>();

    public void validate() {
        String operate;
        switch (operate = this.getOperateKey()) {
            case "save": {
                this.checkSaveData();
                break;
            }
            case "submitandnew": {
                this.checkData();
                break;
            }
            case "submit": {
                this.checkData();
                break;
            }
            case "delete": {
                this.checkDeleteData();
                break;
            }
            case "unaudit": {
                this.checkUnAuditData();
                break;
            }
        }
    }

    private boolean checkHeadData(ExtendedDataEntity entity, Map<String, String> param, ExistRouteEntity existRoute) {
        String operateKey;
        boolean isError = false;
        DynamicObject obj = entity.getDataEntity();
        if (this.isNull(obj.getString("number"))) {
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5de5\u827a\u8def\u7ebf\u7f16\u7801\u201d\u3002", (String)"ProcessRouteValidator_55", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), new Object[0]));
            isError = true;
        }
        if (this.isNull(obj.getString("name"))) {
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ProcessRouteValidator_117", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), new Object[0]));
            isError = true;
        }
        if ("A".equals(obj.getString("processtype"))) {
            if (this.isNull(obj.getDynamicObject("material"))) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ProcessRouteValidator_118", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), new Object[0]));
                isError = true;
                return isError;
            }
        } else if ("B".equals(obj.getString("processtype"))) {
            if (this.isNull(obj.getDynamicObject("unit"))) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u9ed8\u8ba4\u8ba1\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ProcessRouteValidator_119", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), new Object[0]));
                isError = true;
            }
            if (this.isNull(obj.getDynamicObject("materialgroup"))) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u63a7\u5236\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ProcessRouteValidator_120", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), new Object[0]));
                isError = true;
                return isError;
            }
        } else if ("C".equals(obj.getString("processtype")) && this.isNull(obj.getDynamicObject("unit"))) {
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u9ed8\u8ba4\u8ba1\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ProcessRouteValidator_119", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), new Object[0]));
            isError = true;
        }
        if (!"submit".equals(operateKey = this.getOperateKey())) {
            this.setParam(param, obj);
            return isError;
        }
        if (existRoute != null) {
            StringBuilder str = new StringBuilder();
            str.append(obj.getDynamicObject("createorg").getPkValue());
            str.append(obj.getDynamicObject("routeversion") == null ? "0" : obj.getDynamicObject("routeversion").getString("name"));
            String wbsPk = obj.getDynamicObject("wbs") != null ? String.valueOf(obj.getDynamicObject("wbs").getPkValue()) : "0";
            str.append(wbsPk);
            long routePkV = obj.getLong("id");
            if (obj.getBoolean("ismainprocess")) {
                param.put("ismain", "1");
                if ("A".equals(obj.getString("processtype"))) {
                    param.put("type", "A");
                    str.append(obj.getDynamicObject("material").getPkValue());
                    str.append(obj.getDynamicObject("auxproperty") == null ? "0" : obj.getDynamicObject("auxproperty").getPkValue());
                    if (this.validateMainAUnique(existRoute.getMainAMap(), str.toString(), routePkV)) {
                        this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u827a\u7c7b\u578b\u201c\u7269\u6599\u201d\u7684\u5f53\u524d\u7248\u672c\u5df2\u5b58\u5728\u76f8\u540c\u7269\u6599\u3001\u8f85\u52a9\u5c5e\u6027\u548cWBS\u7684\u4e3b\u5de5\u827a\u8def\u7ebf\u3002", (String)"ProcessRouteValidator_121", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), new Object[0]));
                        isError = true;
                    } else if (this.aMainSet.contains(str.toString())) {
                        this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5de5\u827a\u7c7b\u578b\u201c\u7269\u6599\u201d\u7684\u5df2\u5b58\u5728\u76f8\u540c\u7269\u6599\uff0c\u4e14\u5177\u6709\u76f8\u540c\u8f85\u52a9\u5c5e\u6027\u548cWBS\u7684\u4e3b\u5de5\u827a\u8def\u7ebf\u3002", (String)"ProcessRouteValidator_178", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                        isError = true;
                    }
                } else if ("B".equals(obj.getString("processtype"))) {
                    param.put("type", "B");
                    str.append(obj.getDynamicObject("materialgroup").getPkValue());
                    if (this.validateMainAUnique(existRoute.getMainBMap(), str.toString(), routePkV)) {
                        this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u827a\u7c7b\u578b\u201c\u7269\u6599\u7ec4\u201d\u7684\u5f53\u524d\u7248\u672c\u5df2\u5b58\u5728\u76f8\u540cWBS\u548c\u7269\u6599\u63a7\u5236\u7ec4\u7684\u4e3b\u5de5\u827a\u8def\u7ebf\u3002", (String)"ProcessRouteValidator_123", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), new Object[0]));
                        isError = true;
                    } else if (this.bMainSet.contains(str.toString())) {
                        this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5de5\u827a\u7c7b\u578b\u201c\u7269\u6599\u7ec4\u201d\u7684\u5df2\u5b58\u5728\u76f8\u540cWBS\u548c\u7269\u6599\u63a7\u5236\u7ec4\u7684\u4e3b\u5de5\u827a\u8def\u7ebf\u3002", (String)"ProcessRouteValidator_179", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                        isError = true;
                    }
                } else {
                    param.put("type", "C");
                    str.append(obj.getDynamicObject("group") == null ? "0" : obj.getDynamicObject("group").getPkValue().toString());
                    if (this.validateMainAUnique(existRoute.getMainCMap(), str.toString(), routePkV)) {
                        this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u827a\u7c7b\u578b\u201c\u901a\u7528\u201d\u7684\u5f53\u524d\u7248\u672c\u3001WBS\u548c\u5de5\u827a\u8def\u7ebf\u5206\u7ec4\u4e0b\u5df2\u5b58\u5728\u4e3b\u5de5\u827a\u8def\u7ebf\u3002", (String)"ProcessRouteValidator_125", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), new Object[0]));
                        isError = true;
                    } else if (this.cMainSet.contains(str.toString())) {
                        this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5de5\u827a\u7c7b\u578b\u201c\u901a\u7528\u201d\u7684\u5df2\u5b58\u5728\u76f8\u540cWBS\u548c\u7269\u6599\u63a7\u5236\u7ec4\u7684\u4e3b\u5de5\u827a\u8def\u7ebf\u3002", (String)"ProcessRouteValidator_239", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                        isError = true;
                    }
                }
            } else {
                param.put("ismain", "0");
                if (this.isNull(obj.getDynamicObject("routereplace"))) {
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u975e\u4e3b\u5de5\u827a\u8def\u7ebf,\u66ff\u4ee3\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ProcessRouteValidator_176", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                    isError = true;
                    return isError;
                }
                if ("A".equals(obj.getString("processtype"))) {
                    param.put("type", "A");
                    str.append(obj.getDynamicObject("material").getPkValue().toString());
                    str.append(obj.getDynamicObject("auxproperty") == null ? "0" : obj.getDynamicObject("auxproperty").getPkValue().toString());
                    str.setLength(0);
                    str.append(obj.getDynamicObject("createorg").getPkValue().toString());
                    str.append(obj.getDynamicObject("routeversion") == null ? "0" : obj.getDynamicObject("routeversion").getString("name"));
                    str.append(wbsPk);
                    str.append(obj.getDynamicObject("routereplace").getPkValue().toString());
                    str.append(obj.getDynamicObject("material").getPkValue().toString());
                    str.append(obj.getDynamicObject("auxproperty") == null ? "0" : obj.getDynamicObject("auxproperty").getPkValue().toString());
                    if (this.aReplaceSet.contains(str.toString())) {
                        this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5de5\u827a\u7c7b\u578b\u201c\u7269\u6599\u201d\u7684\u672c\u6b21\u5df2\u5b58\u5728\u76f8\u540c\u7269\u6599\u3001\u8f85\u52a9\u5c5e\u6027\u548cWBS\u7684\u66ff\u4ee3\u5de5\u827a\u8def\u7ebf\u3002", (String)"ProcessRouteValidator_180", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                        isError = true;
                    } else if (this.validateMainAUnique(existRoute.getNoMainAMap(), str.toString(), routePkV)) {
                        this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5de5\u827a\u7c7b\u578b\u201c\u7269\u6599\u201d\u7684\u5f53\u524d\u7248\u672c\u5df2\u5b58\u5728\u76f8\u540c\u7269\u6599\u3001\u8f85\u52a9\u5c5e\u6027\u548cWBS\u4e14\u66ff\u4ee3\u53f7\u76f8\u540c\u7684\u5de5\u827a\u8def\u7ebf\u3002", (String)"ProcessRouteValidator_181", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                        isError = true;
                    }
                } else if ("B".equals(obj.getString("processtype"))) {
                    param.put("type", "B");
                    str.append(obj.getDynamicObject("materialgroup").getPkValue().toString());
                    str.setLength(0);
                    str.append(obj.getDynamicObject("createorg").getPkValue().toString());
                    str.append(obj.getDynamicObject("routeversion") == null ? "0" : obj.getDynamicObject("routeversion").getString("name"));
                    str.append(wbsPk);
                    str.append(obj.getDynamicObject("routereplace").getPkValue().toString());
                    str.append(obj.getDynamicObject("materialgroup").getPkValue().toString());
                    if (this.bReplaceSet.contains(str.toString())) {
                        this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5de5\u827a\u7c7b\u578b\u201c\u7269\u6599\u7ec4\u201d\u7684\u672c\u6b21\u5df2\u5b58\u5728\u76f8\u540cWBS\u548c\u7269\u6599\u63a7\u5236\u7ec4\u7684\u66ff\u4ee3\u5de5\u827a\u8def\u7ebf\u3002", (String)"ProcessRouteValidator_182", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                        isError = true;
                    } else if (this.validateMainAUnique(existRoute.getNoMainBMap(), str.toString(), routePkV)) {
                        this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5de5\u827a\u7c7b\u578b\u201c\u7269\u6599\u7ec4\u201d\u7684\u5f53\u524d\u7248\u672c\u5df2\u5b58\u5728\u76f8\u540cWBS\u3001\u7269\u6599\u63a7\u5236\u7ec4\u3001\u76f8\u540c\u66ff\u4ee3\u53f7\u7684\u5de5\u827a\u8def\u7ebf\u3002", (String)"ProcessRouteValidator_183", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                        isError = true;
                    }
                } else {
                    param.put("type", "C");
                    str.append(obj.getDynamicObject("group") == null ? "0" : obj.getDynamicObject("group").getPkValue().toString());
                    str.setLength(0);
                    str.append(obj.getDynamicObject("createorg").getPkValue().toString());
                    str.append(obj.getDynamicObject("routeversion") == null ? "0" : obj.getDynamicObject("routeversion").getString("name"));
                    str.append(wbsPk);
                    str.append(obj.getDynamicObject("routereplace").getPkValue().toString());
                    str.append(obj.getDynamicObject("group") == null ? "0" : obj.getDynamicObject("group").getPkValue().toString());
                    if (this.cReplaceSet.contains(str.toString())) {
                        this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5de5\u827a\u7c7b\u578b\u201c\u901a\u7528\u201d\u7684\u5f53\u524dWBS\u548c\u5de5\u827a\u8def\u7ebf\u5206\u7ec4\u4e0b\u672c\u6b21\u5df2\u5b58\u5728\u66ff\u4ee3\u5de5\u827a\u8def\u7ebf\u3002", (String)"ProcessRouteValidator_184", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                        isError = true;
                    } else if (this.validateMainAUnique(existRoute.getNoMainCMap(), str.toString(), routePkV)) {
                        this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5de5\u827a\u7c7b\u578b\u201c\u901a\u7528\u201d\u7684\u5f53\u524d\u7248\u672c\u3001WBS\u3001\u5de5\u827a\u8def\u7ebf\u5206\u7ec4\u4e0b\u5df2\u5b58\u5728\u76f8\u540c\u66ff\u4ee3\u53f7\u7684\u5de5\u827a\u8def\u7ebf\u3002", (String)"ProcessRouteValidator_185", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                        isError = true;
                    }
                }
            }
        }
        return isError;
    }

    private boolean validateMainAUnique(Map<String, Object> mainAMap, String str, long routePkV) {
        HashSet mainAMapSet = mainAMap.get(str) != null ? (HashSet)mainAMap.get(str) : null;
        boolean mainAMapUnique = false;
        if (mainAMapSet == null || mainAMapSet.isEmpty()) {
            return mainAMapUnique;
        }
        if (mainAMapSet.size() > 1 || !mainAMapSet.contains(routePkV)) {
            mainAMapUnique = true;
        }
        return mainAMapUnique;
    }

    private void setParam(Map<String, String> param, DynamicObject obj) {
        if (obj.getBoolean("ismainprocess")) {
            param.put("ismain", "1");
            if ("A".equals(obj.getString("processtype"))) {
                param.put("type", "A");
            } else if ("B".equals(obj.getString("processtype"))) {
                param.put("type", "B");
            } else {
                param.put("type", "C");
            }
        } else {
            param.put("ismain", "0");
            if ("A".equals(obj.getString("processtype"))) {
                param.put("type", "A");
            } else if ("B".equals(obj.getString("processtype"))) {
                param.put("type", "B");
            } else {
                param.put("type", "C");
            }
        }
    }

    private boolean checkEntryData(ExtendedDataEntity entity) {
        boolean isError = false;
        DynamicObjectCollection entryCol = entity.getDataEntity().getDynamicObjectCollection("entryentity");
        if (entryCol.isEmpty()) {
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u4fe1\u606f\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"ProcessRouteValidator_132", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), new Object[0]));
            isError = true;
        }
        for (int j = 0; j < entryCol.size(); ++j) {
            String processSeq;
            DynamicObject entryObj = (DynamicObject)entryCol.get(j);
            if (this.isNull(entryObj.getString("processseq"))) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u5217\u8868\u7b2c%1$s\u884c\u5206\u5f55\u7684\u201c\u5e8f\u5217\u53f7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ProcessRouteValidator_133", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("processseq")));
                isError = true;
            }
            if (this.isNull(entryObj.getString("processseqname"))) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u5206\u5f55\u5e8f\u5217\u201c%1$s\u201d,\u5e8f\u5217\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ProcessRouteValidator_194", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("processseq")));
                isError = true;
            }
            if (!"1".equals(processSeq = entryObj.getString("processseq"))) {
                if (this.isNull(entryObj.getString("reference"))) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u5206\u5f55\u5e8f\u5217\u201c%1$s\u201d,\u53c2\u7167\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ProcessRouteValidator_195", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("processseq")));
                    isError = true;
                } else if (entryObj.getString("reference").equals(entryObj.getString("processseq"))) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u5206\u5f55\u5e8f\u5217\u201c%1$s\u201d,\u53c2\u7167\u4e0d\u80fd\u4e3a\u81ea\u8eab\u5e8f\u5217\u3002", (String)"ProcessRouteValidator_196", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("processseq")));
                    isError = true;
                }
                if (this.isNull(entryObj.getString("relation"))) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u5206\u5f55\u5e8f\u5217\u201c%1$s\u201d,\u5e76\u884c\u5173\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ProcessRouteValidator_197", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("processseq")));
                    isError = true;
                }
                if (this.isNull(entryObj.getString("output")) || this.isNull(entryObj.getString("input"))) {
                    if (this.isNull(entryObj.getString("input"))) {
                        this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u5206\u5f55\u5e8f\u5217\u201c%1$s\u201d,\u8f6c\u5165\u5de5\u5e8f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ProcessRouteValidator_198", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("processseq")));
                        isError = true;
                    }
                    if (this.isNull(entryObj.getString("output"))) {
                        this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u5206\u5f55\u5e8f\u5217\u201c%1$s\u201d,\u8f6c\u51fa\u5de5\u5e8f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ProcessRouteValidator_199", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("processseq")));
                        isError = true;
                    }
                } else if (Integer.parseInt(entryObj.getString("input")) < Integer.parseInt(entryObj.getString("output"))) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u5206\u5f55\u5e8f\u5217\u201c%1$s\u201d,\u8f6c\u5165\u5de5\u5e8f\u4e0d\u80fd\u5c0f\u4e8e\u8f6c\u51fa\u5de5\u5e8f\u3002", (String)"ProcessRouteValidator_200", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("processseq")));
                    isError = true;
                }
            }
            DynamicObjectCollection subEntryCol = entity.getDataEntity().getDynamicObjectCollection("processentry");
            boolean isExist = false;
            for (int k = 0; k < subEntryCol.size(); ++k) {
                DynamicObject subEntryObj = (DynamicObject)subEntryCol.get(k);
                if (!processSeq.equals(subEntryObj.getString("parent"))) continue;
                isExist = true;
                break;
            }
            if (isExist) continue;
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u5206\u5f55\u5e8f\u5217\u201c%1$s\u201d\uff0c\u81f3\u5c11\u9700\u8981\u5f55\u5165\u4e00\u6761\u5de5\u5e8f\u3002", (String)"ProcessRouteValidator_201", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("processseq")));
            isError = true;
        }
        return isError;
    }

    private boolean checkSubEntryData(ExtendedDataEntity entity) {
        boolean isError = false;
        DynamicObjectCollection entryCol = entity.getDataEntity().getDynamicObjectCollection("processentry");
        if (entryCol.isEmpty()) {
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ProcessRouteValidator_142", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), new Object[0]));
            isError = true;
        }
        for (int j = 0; j < entryCol.size(); ++j) {
            BigDecimal qty;
            DynamicObject entryObj = (DynamicObject)entryCol.get(j);
            String seq = entryObj.getString("operationno");
            if (seq.isEmpty()) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u201c%1$s\u201d\u4e0b\u5b58\u5728\u5de5\u5e8f\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u51654\u4f4d\u62164\u4f4d\u4ee5\u5185\u7684\u6b63\u6574\u6570\u3002", (String)"ProcessRouteValidator_202", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("parent")));
                isError = true;
            } else {
                String pattern = "^[1-9][0-9]{0,3}$";
                Pattern p = Pattern.compile(pattern);
                if (!p.matcher(entryObj.getString("operationno")).find()) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u201c%1$s\u201d\u4e0b\u5de5\u5e8f\u201c%2$s\u201d\u5de5\u5e8f\u53f7\u4e0d\u5408\u6cd5\uff0c\u8bf7\u8f93\u51654\u4f4d\u62164\u4f4d\u4ee5\u5185\u7684\u6b63\u6574\u6570\u3002", (String)"ProcessRouteValidator_203", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                    isError = true;
                }
            }
            boolean flag = false;
            if (this.isNull(entryObj.get("parent"))) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u201c%1$s\u201d\u5de5\u5e8f\u5e8f\u5217\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ProcessRouteValidator_204", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("operationno")));
                isError = true;
            } else {
                for (int j2 = 0; j2 < entity.getDataEntity().getDynamicObjectCollection("entryentity").size(); ++j2) {
                    if (!entryObj.get("parent").equals(((DynamicObject)entity.getDataEntity().getDynamicObjectCollection("entryentity").get(j2)).getString("processseq"))) continue;
                    flag = true;
                    break;
                }
            }
            if (!flag) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ProcessRouteValidator_205", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("parent")));
                isError = true;
            }
            if ("1002".equals(entryObj.getString("machiningtype"))) {
                if (entryObj.getBigDecimal("settlementcoefficient").compareTo(BigDecimal.ZERO) < 0) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u201c%1$s\u201d\u4e0b\u5de5\u5e8f\u201c%2$s\u201d\u91cd\u53e0\u6279\u91cf\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"ProcessRouteValidator_207", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                    isError = true;
                }
            } else if ("1003".equals(entryObj.getString("machiningtype"))) {
                // empty if block
            }
            if (this.isNull(entryObj.getDynamicObject("workcenter"))) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u201c%1$s\u201d\u4e0b\u5de5\u5e8f\u201c%2$s\u201d\u5de5\u4f5c\u4e2d\u5fc3\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ProcessRouteValidator_208", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                isError = true;
            }
            if (this.isNull(entryObj.getDynamicObject("productionorg"))) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u201c%1$s\u201d\u4e0b\u5de5\u5e8f\u201c%2$s\u201d\u7684\u751f\u4ea7\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ProcessRouteValidator_209", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                isError = true;
            }
            if (this.isNull(entryObj.getString("operationdesc"))) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u201c\u5de5\u5e8f\u8bf4\u660e\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"ProcessRouteValidator_210", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                isError = true;
            }
            if (this.isNull(entryObj.getDynamicObject("oprctrlstrategy"))) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u201c\u5de5\u5e8f\u63a7\u5236\u7b56\u7565\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"ProcessRouteValidator_211", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                isError = true;
            }
            if (this.isNull(entryObj.getBigDecimal("upperratio")) || entryObj.getBigDecimal("upperratio").compareTo(BigDecimal.ZERO) < 0) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u201c\u6c47\u62a5\u4e0a\u9650\u6bd4\u4f8b\u201d\u987b\u5927\u4e8e\u7b49\u4e8e0\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"ProcessRouteValidator_212", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                isError = true;
            }
            if (this.isNull(entryObj.getBigDecimal("floorratio")) || entryObj.getBigDecimal("floorratio").compareTo(BigDecimal.ZERO) < 0) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u201c\u6c47\u62a5\u4e0b\u9650\u6bd4\u4f8b\u201d\u987b\u5927\u4e8e\u7b49\u4e8e0\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"ProcessRouteValidator_213", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                isError = true;
            }
            if (this.isNull(entryObj.getBigDecimal("basebatchqty")) || entryObj.getBigDecimal("basebatchqty").compareTo(BigDecimal.ZERO) <= 0) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u201c\u57fa\u672c\u6279\u91cf\u201d\u987b\u5927\u4e8e\u7b49\u4e8e0\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"ProcessRouteValidator_214", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                isError = true;
            }
            if (this.isNull(entryObj.getBigDecimal("headqty")) || entryObj.getBigDecimal("headqty").compareTo(BigDecimal.ZERO) <= 0) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u201c\u8868\u5934\u6570\u91cf\u201d\u987b\u5927\u4e8e\u7b49\u4e8e0\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"ProcessRouteValidator_215", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                isError = true;
            }
            if (this.isNull(entryObj.getDynamicObject("headunit"))) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u201c\u8868\u5934\u5355\u4f4d\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"ProcessRouteValidator_216", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                isError = true;
            }
            if (this.isNull(entryObj.getBigDecimal("operationqty")) || entryObj.getBigDecimal("operationqty").compareTo(BigDecimal.ZERO) <= 0) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u201c\u5de5\u5e8f\u6570\u91cf\u201d\u987b\u5927\u4e8e\u7b49\u4e8e0\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"ProcessRouteValidator_217", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                isError = true;
            }
            if (this.isNull(entryObj.getDynamicObject("operationunit"))) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u201c\u5de5\u5e8f\u5355\u4f4d\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"ProcessRouteValidator_218", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                isError = true;
            }
            if (entryObj.getBoolean("issplit")) {
                qty = entryObj.getBigDecimal("splitqty");
                if (qty.compareTo(BigDecimal.ZERO) <= 0) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u542f\u7528\u62c6\u5206\u6392\u7a0b\uff0c\u201c\u5efa\u8bae\u62c6\u5206\u6570\u91cf\u201d\u987b\u5927\u4e8e0\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"ProcessRouteValidator_219", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                    isError = true;
                }
                if ((qty = entryObj.getBigDecimal("minworktime")).compareTo(BigDecimal.ZERO) <= 0) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u542f\u7528\u62c6\u5206\u6392\u7a0b\uff0c\u201c\u6700\u5c0f\u52a0\u5de5\u65f6\u95f4\u201d\u987b\u5927\u4e8e0\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"ProcessRouteValidator_220", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                    isError = true;
                }
            } else {
                qty = entryObj.getBigDecimal("splitqty");
                if (qty.compareTo(BigDecimal.ZERO) < 0) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u201c\u5efa\u8bae\u62c6\u5206\u6570\u201d\u987b\u5927\u4e8e\u7b49\u4e8e0\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"ProcessRouteValidator_221", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                    isError = true;
                }
                if ((qty = entryObj.getBigDecimal("minworktime")).compareTo(BigDecimal.ZERO) < 0) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u201c\u6700\u5c0f\u52a0\u5de5\u65f6\u95f4\u201d\u987b\u5927\u4e8e\u7b49\u4e8e0\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"ProcessRouteValidator_222", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                    isError = true;
                }
            }
            if (entryObj.getBoolean("isprocessoverlap")) {
                qty = entryObj.getBigDecimal("minoverlaptime");
                if (qty.compareTo(BigDecimal.ZERO) <= 0) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u91cd\u53e0\u5de5\u5e8f\uff0c\u201c\u91cd\u53e0\u6700\u5c0f\u65f6\u95f4\u201d\u987b\u5927\u4e8e0\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"ProcessRouteValidator_223", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                    isError = true;
                }
                if ((qty = entryObj.getBigDecimal("overlapqty")).compareTo(BigDecimal.ZERO) <= 0) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u91cd\u53e0\u5de5\u5e8f\uff0c\u201c\u91cd\u53e0\u6279\u91cf\u201d\u987b\u5927\u4e8e0\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"ProcessRouteValidator_224", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                    isError = true;
                }
                if (this.isNull(entryObj.getDynamicObject("overlapunit"))) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u91cd\u53e0\u5de5\u5e8f\uff0c\u201c\u8ba1\u91cf\u5355\u4f4d\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"ProcessRouteValidator_225", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                    isError = true;
                }
            } else {
                qty = entryObj.getBigDecimal("minoverlaptime");
                if (qty.compareTo(BigDecimal.ZERO) < 0) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u201c\u91cd\u53e0\u6700\u5c0f\u65f6\u95f4\u201d\u987b\u5927\u4e8e\u7b49\u4e8e0\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"ProcessRouteValidator_226", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                    isError = true;
                }
                if ((qty = entryObj.getBigDecimal("overlapqty")).compareTo(BigDecimal.ZERO) < 0) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u201c%1$s\u201d\u4e0b\u5de5\u5e8f\u201c%2$s\u201d\u91cd\u53e0\u6279\u91cf\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"ProcessRouteValidator_207", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                    isError = true;
                }
            }
            DynamicObjectCollection subEntryCol = entryObj.getDynamicObjectCollection("subentryentity");
            for (int k = 0; k < subEntryCol.size(); ++k) {
                DynamicObject subEntryObj = (DynamicObject)subEntryCol.get(k);
                if (!this.isNull(subEntryObj.getDynamicObject("resource"))) continue;
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u6392\u7a0b\u5206\u5f55\u4e2d\uff0c\u201c\u8d44\u6e90\u7f16\u7801\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"ProcessRouteValidator_227", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno")));
                isError = true;
            }
            subEntryCol = entryObj.getDynamicObjectCollection("actentryentity");
            Map<Object, Boolean> queryWorkCenter = this.queryWorkCenter(entryObj);
            for (int k = 0; k < subEntryCol.size(); ++k) {
                DynamicObject subEntryObj = (DynamicObject)subEntryCol.get(k);
                if (this.isNull(subEntryObj.getString("processstage"))) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u6d3b\u52a8\u5206\u5f55\u7b2c%3$s\u884c\u201c\u5de5\u5e8f\u9636\u6bb5\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff09\u3002", (String)"ProcessRouteValidator_229", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno"), k + 1));
                    isError = true;
                }
                if (this.isNull(subEntryObj.getDynamicObject("standardformula"))) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u201c%1$s\u201d\u4e0b\u5de5\u5e8f\u201c%2$s\u201d\u7684\u5de5\u5e8f\u6d3b\u52a8\u5b50\u5206\u5f55\u7b2c\u201c%3$s\u201d\u884c\uff0c\u201c\u6d3b\u52a8\u6c47\u62a5\u91cf\u516c\u5f0f-\u6807\u51c6\u516c\u5f0f\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ProcessRouteValidator_230", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno"), k + 1));
                    isError = true;
                }
                if (this.isNull(subEntryObj.getDynamicObject("standardformula1"))) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u201c%1$s\u201d\u4e0b\u5de5\u5e8f\u201c%2$s\u201d\u7684\u5de5\u5e8f\u6d3b\u52a8\u5b50\u5206\u5f55\u7b2c\u201c%3$s\u201d\u884c\uff0c\u201c\u6d3b\u52a8\u6c47\u62a5\u91cf\u516c\u5f0f-\u6807\u51c6\u516c\u5f0f\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ProcessRouteValidator_231", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno"), k + 1));
                    isError = true;
                }
                if (subEntryObj.getBigDecimal("baseqty").compareTo(BigDecimal.ZERO) < 0) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u201c%1$s\u201d\u4e0b\u5de5\u5e8f\u201c%2$s\u201d\u5de5\u5e8f\u6d3b\u52a8\u5b50\u5206\u5f55\u7b2c\u201c%3$s\u201d\u884c\u57fa\u672c\u6570\u91cf\u5e94\u5927\u4e8e\u7b49\u4e8e0\u3002", (String)"ProcessRouteValidator_232", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno"), k + 1));
                    isError = true;
                }
                if (this.isNull(subEntryObj.getDynamicObject("activity"))) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u201c%1$s\u201d\u4e0b\u5de5\u5e8f\u201c%2$s\u201d\u5de5\u5e8f\u6d3b\u52a8\u5b50\u5206\u5f55\u7b2c\u201c%3$s\u201d\u884c\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ProcessRouteValidator_233", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno"), k + 1));
                    isError = true;
                    continue;
                }
                if (!queryWorkCenter.containsKey(subEntryObj.getDynamicObject("activity").getPkValue()) || !queryWorkCenter.get(subEntryObj.getDynamicObject("activity").getPkValue()).booleanValue() || BigDecimal.ZERO.compareTo(subEntryObj.getBigDecimal("baseqty")) < 0) continue;
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\u201c%1$s\u201d\u4e0b\u5de5\u5e8f\u201c%2$s\u201d\u5de5\u5e8f\u6d3b\u52a8\u5b50\u5206\u5f55\u7b2c\u201c%3$s\u201d\u884c\u57fa\u672c\u6570\u91cf\u9700\u8981\u5927\u4e8e0\u3002", (String)"ProcessRouteValidator_234", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), entryObj.getString("parent"), entryObj.getString("operationno"), k + 1));
            }
            Date entryvaliddate = entryObj.getDate("entryvaliddate");
            Date entryinvaliddate = entryObj.getDate("entryinvaliddate");
            if (entryvaliddate == null || entryinvaliddate == null || !entryvaliddate.after(entryinvaliddate)) continue;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u4fe1\u606f\u5206\u5f55\u7684\u751f\u6548\u65e5\u671f[%1$s]\u5927\u4e8e\u5931\u6548\u65e5\u671f[%2$s]\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProcessRouteValidator_236", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), simpleDateFormat.format(entryvaliddate), simpleDateFormat.format(entryinvaliddate)));
        }
        return isError;
    }

    private Map<Object, Boolean> queryWorkCenter(DynamicObject entryObj) {
        Map<Object, Boolean> map = new HashMap<Object, Boolean>(16);
        DynamicObject dynamicObject = entryObj.getDynamicObject("workcenter");
        if (dynamicObject != null) {
            if (this.workCenterMap.get(dynamicObject.getPkValue()) != null) {
                map = this.workCenterMap.get(dynamicObject.getPkValue());
            } else {
                DynamicObjectCollection col = QueryServiceHelper.query((String)"mpdm_workcentre", (String)"id,processactivetable.processnumber processnumber,processactivetable.processroutecontrol processroutecontrol", (QFilter[])new QFilter[]{new QFilter("id", "=", dynamicObject.getPkValue())});
                for (int i = 0; i < col.size(); ++i) {
                    DynamicObject entry = (DynamicObject)col.get(i);
                    if (entry.get("processnumber") == null || entry.getLong("processnumber") == 0L) continue;
                    map.put(entry.getLong("processnumber"), "1".equals(entry.getString("processroutecontrol")));
                }
                this.workCenterMap.put(dynamicObject.getPkValue(), map);
            }
        }
        return map;
    }

    private void checkSaveData() {
        HashMap<String, String> param = new HashMap<String, String>(3);
        int n = this.dataEntities.length;
        for (int i = 0; i < n; ++i) {
            DynamicObject route = this.dataEntities[i].getDataEntity();
            boolean isEcoRoute = this.isEcoRoute(route);
            boolean checkDataHead = false;
            if (isEcoRoute) continue;
            checkDataHead = this.checkHeadData(this.dataEntities[i], param, null);
        }
    }

    private void checkData() {
        ArrayList<ExtendedDataEntity> allDataList = new ArrayList<ExtendedDataEntity>(this.dataEntities.length);
        ExistRouteEntity existRoute = this.getRouteByDatabase(allDataList);
        StringBuilder str = new StringBuilder();
        HashMap<String, String> param = new HashMap<String, String>(3);
        for (int i = 0; i < allDataList.size(); ++i) {
            boolean isEcoRoute = this.isEcoRoute(((ExtendedDataEntity)allDataList.get(i)).getDataEntity());
            boolean checkDataHead = false;
            if (!isEcoRoute && (checkDataHead = this.checkHeadData((ExtendedDataEntity)allDataList.get(i), param, existRoute))) continue;
            boolean checkEntryData = this.checkEntryData((ExtendedDataEntity)allDataList.get(i));
            boolean checkSubEntryData = this.checkSubEntryData((ExtendedDataEntity)allDataList.get(i));
            if (isEcoRoute) continue;
            str.setLength(0);
            if (checkDataHead || checkEntryData || checkSubEntryData) continue;
            DynamicObject obj = ((ExtendedDataEntity)allDataList.get(i)).getDataEntity();
            String wbsPk = obj.getDynamicObject("wbs") != null ? String.valueOf(obj.getDynamicObject("wbs").getPkValue()) : "0";
            str.append(obj.getDynamicObject("createorg").getPkValue().toString());
            str.append(obj.getDynamicObject("routeversion") == null ? "0" : obj.getDynamicObject("routeversion").getString("name"));
            str.append(wbsPk);
            if ("1".equals(param.get("ismain"))) {
                if ("A".equals(param.get("type"))) {
                    str.append(obj.getDynamicObject("material").getPkValue().toString());
                    str.append(obj.getDynamicObject("auxproperty") == null ? "0" : obj.getDynamicObject("auxproperty").getPkValue().toString());
                    this.aMainSet.add(str.toString());
                    continue;
                }
                if ("B".equals(param.get("type"))) {
                    str.append(obj.getDynamicObject("materialgroup").getPkValue().toString());
                    this.bMainSet.add(str.toString());
                    continue;
                }
                str.append(obj.getDynamicObject("group") == null ? "0" : obj.getDynamicObject("group").getPkValue().toString());
                this.cMainSet.add(str.toString());
                continue;
            }
            str.append(obj.getDynamicObject("routereplace").getPkValue().toString());
            if ("A".equals(param.get("type"))) {
                str.append(obj.getDynamicObject("material").getPkValue().toString());
                str.append(obj.getDynamicObject("auxproperty") == null ? "0" : obj.getDynamicObject("auxproperty").getPkValue().toString());
                this.aReplaceSet.add(str.toString());
                continue;
            }
            if ("B".equals(param.get("type"))) {
                str.append(obj.getDynamicObject("materialgroup").getPkValue().toString());
                this.bReplaceSet.add(str.toString());
                continue;
            }
            str.append(obj.getDynamicObject("group") == null ? "0" : obj.getDynamicObject("group").getPkValue().toString());
            this.cReplaceSet.add(str.toString());
        }
    }

    private ExistRouteEntity getRouteByDatabase(List<ExtendedDataEntity> allDataList) {
        ArrayList<ExtendedDataEntity> isMainDataList = new ArrayList<ExtendedDataEntity>(this.dataEntities.length);
        ArrayList<ExtendedDataEntity> notMainDataList = new ArrayList<ExtendedDataEntity>(this.dataEntities.length);
        HashSet<Object> orgSet = new HashSet<Object>(this.dataEntities.length);
        HashSet<Long> materialIdSet = new HashSet<Long>(16);
        HashSet<Long> materialGroupIdSet = new HashSet<Long>(16);
        HashSet<Long> groupIdSet = new HashSet<Long>(16);
        int n = this.dataEntities.length;
        for (int i = 0; i < n; ++i) {
            DynamicObject route = this.dataEntities[i].getDataEntity();
            if (route.getBoolean("ismainprocess")) {
                isMainDataList.add(this.dataEntities[i]);
            } else {
                notMainDataList.add(this.dataEntities[i]);
            }
            if (this.isEcoRoute(route)) continue;
            String processtype = route.getString("processtype");
            if ("A".equals(processtype)) {
                DynamicObject material = route.getDynamicObject("material");
                materialIdSet.add(material == null ? 0L : material.getLong("id"));
            } else if ("B".equals(processtype)) {
                DynamicObject materialGroup = route.getDynamicObject("materialgroup");
                materialGroupIdSet.add(materialGroup == null ? 0L : materialGroup.getLong("id"));
            } else {
                DynamicObject group = route.getDynamicObject("group");
                groupIdSet.add(group == null ? 0L : group.getLong("id"));
            }
            if (this.isNull(route.getDynamicObject("createorg"))) continue;
            orgSet.add(route.getDynamicObject("createorg").getPkValue());
        }
        allDataList.addAll(isMainDataList);
        allDataList.addAll(notMainDataList);
        ExistRouteEntity entity = new ExistRouteEntity();
        if (!orgSet.isEmpty()) {
            for (int i = 0; i < 3; ++i) {
                QFilter qfilter = new QFilter("createorg", "in", orgSet);
                qfilter.and(new QFilter("status", "in", Arrays.asList("B", "C")));
                if (i == 0) {
                    if (materialIdSet.isEmpty()) continue;
                    qfilter = qfilter.and(new QFilter("processtype", "=", (Object)"A"));
                    qfilter = qfilter.and(new QFilter("material", "in", materialIdSet));
                } else if (i == 1) {
                    if (materialGroupIdSet.isEmpty()) continue;
                    qfilter = qfilter.and(new QFilter("processtype", "=", (Object)"B"));
                    qfilter = qfilter.and(new QFilter("materialgroup", "in", materialGroupIdSet));
                } else {
                    if (groupIdSet.isEmpty()) continue;
                    qfilter = qfilter.and(new QFilter("processtype", "=", (Object)"C"));
                    qfilter = qfilter.and(new QFilter("group", "in", groupIdSet));
                }
                DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)this.entityKey, (String)"id,createorg.id createorg,ismainprocess ismainprocess,routeversion.name version,processtype processtype,material material,auxproperty auxproperty,materialgroup materialgroup,group group,routereplace routereplace,wbs wbs", (QFilter[])new QFilter[]{qfilter}, null);
                StringBuilder str = new StringBuilder();
                for (Row row : queryDataSet) {
                    HashSet<Long> mianASet;
                    str.setLength(0);
                    String processtype = row.getString("processtype");
                    boolean isMainprocess = row.getBoolean("ismainprocess");
                    Long id = row.getLong("id");
                    str.append(row.getLong("createorg"));
                    str.append(row.getString("version") == null ? "0" : row.getString("version"));
                    str.append(row.getLong("wbs") == null ? "0" : row.getLong("wbs"));
                    if ("A".equals(processtype)) {
                        if (isMainprocess) {
                            str.append(row.getLong("material"));
                            str.append(row.getLong("auxproperty"));
                            mianASet = entity.getMainAMap().getOrDefault(str.toString(), new HashSet(2));
                            mianASet.add(id);
                            entity.getMainAMap().put(str.toString(), mianASet);
                            continue;
                        }
                        str.append(row.getLong("routereplace"));
                        str.append(row.getLong("material"));
                        str.append(row.getLong("auxproperty"));
                        mianASet = entity.getNoMainAMap().getOrDefault(str.toString(), new HashSet(2));
                        mianASet.add(id);
                        entity.getNoMainAMap().put(str.toString(), mianASet);
                        continue;
                    }
                    if ("B".equals(processtype)) {
                        if (isMainprocess) {
                            str.append(row.getLong("materialgroup"));
                            mianASet = entity.getMainBMap().getOrDefault(str.toString(), new HashSet(2));
                            mianASet.add(id);
                            entity.getMainBMap().put(str.toString(), mianASet);
                            continue;
                        }
                        str.append(row.getLong("routereplace"));
                        str.append(row.getLong("materialgroup"));
                        mianASet = entity.getNoMainBMap().getOrDefault(str.toString(), new HashSet(2));
                        mianASet.add(id);
                        entity.getNoMainBMap().put(str.toString(), mianASet);
                        continue;
                    }
                    if (isMainprocess) {
                        str.append(row.getLong("group"));
                        mianASet = entity.getMainCMap().getOrDefault(str.toString(), new HashSet(2));
                        mianASet.add(id);
                        entity.getMainCMap().put(str.toString(), mianASet);
                        continue;
                    }
                    str.append(row.getLong("routereplace"));
                    str.append(row.getLong("group"));
                    mianASet = entity.getNoMainCMap().getOrDefault(str.toString(), new HashSet(2));
                    mianASet.add(id);
                    entity.getNoMainCMap().put(str.toString(), mianASet);
                }
            }
        }
        return entity;
    }

    private boolean isNull(Object obj) {
        if (obj instanceof String) {
            return obj.toString().trim().length() == 0;
        }
        return obj == null;
    }

    private boolean isPdmRoute(DynamicObject route) {
        return "pdm_route".equalsIgnoreCase(route.getDynamicObjectType().getName());
    }

    private boolean isEcoRoute(DynamicObject route) {
        return "pdm_ecoroute".equalsIgnoreCase(route.getDynamicObjectType().getName());
    }

    private void checkDeleteData() {
        Set<Long> routeIDSet = this.getRouteIdSet();
        String opKey = "delete";
        if (!routeIDSet.isEmpty()) {
            Set<Long> existsRouteIDSet = this.getExistsECNRouteIdSet(routeIDSet, opKey);
            this.checkExistsECN(existsRouteIDSet, opKey);
        }
    }

    private Set<Long> getRouteIdSet() {
        HashSet<Long> routeIDSet = new HashSet<Long>(16);
        int n = this.dataEntities.length;
        for (int i = 0; i < n; ++i) {
            DynamicObject route = this.dataEntities[i].getDataEntity();
            Long routeId = route.getLong("id");
            if (!this.isPdmRoute(route) || routeId == null || routeId.equals(0L)) continue;
            routeIDSet.add(routeId);
        }
        return routeIDSet;
    }

    private Set<String> getUnAuditStatus() {
        HashSet<String> unAuditStatusSet = new HashSet<String>(16);
        unAuditStatusSet.add("A");
        unAuditStatusSet.add("B");
        return unAuditStatusSet;
    }

    private boolean isUnAuditOpKey(String opKey) {
        return "unaudit".equals(opKey);
    }

    private Set<Long> getExistsECNRouteIdSet(Set<Long> routeIDSet, String opKey) {
        DynamicObjectCollection ecoBills;
        HashSet<Long> existsRouteIDSet = new HashSet<Long>(16);
        String selectProperties = "pentry.pentryroute as routeid";
        QFilter qfilter = new QFilter("pentry.pentryroute", "in", routeIDSet);
        if (this.isUnAuditOpKey(opKey)) {
            qfilter = qfilter.and(new QFilter("billstatus", "in", this.getUnAuditStatus()));
        }
        if ((ecoBills = QueryServiceHelper.query((String)"pdm_bom_eco", (String)selectProperties, (QFilter[])new QFilter[]{qfilter})) != null && !ecoBills.isEmpty()) {
            for (DynamicObject ecnBill : ecoBills) {
                Long routeId = ecnBill.getLong("routeid");
                existsRouteIDSet.add(routeId);
            }
        }
        return existsRouteIDSet;
    }

    private boolean checkExistsECN(Set<Long> existsRouteIDSet, String opKey) {
        boolean isCheck = Boolean.TRUE;
        if (!existsRouteIDSet.isEmpty()) {
            int n = this.dataEntities.length;
            for (int i = 0; i < n; ++i) {
                DynamicObject route = this.dataEntities[i].getDataEntity();
                Long routeId = route.getLong("id");
                if (!this.isPdmRoute(route) || !existsRouteIDSet.contains(routeId)) continue;
                String checkMsg = String.format(ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u201c%1$s\u201d\u5df2\u7ecf\u5b58\u5728\u5de5\u7a0b\u53d8\u66f4\u7ef4\u62a4\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u5220\u9664\u3002", (String)"ProcessRouteValidator_235", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), route.getString("number"));
                if (this.isUnAuditOpKey(opKey)) {
                    checkMsg = String.format(ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u201c%1$s\u201d\u5df2\u7ecf\u5b58\u5728\u672a\u5ba1\u6838\u7684\u5de5\u7a0b\u53d8\u66f4\u7ef4\u62a4\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u53cd\u5ba1\u6838\u3002", (String)"ProcessRouteValidator_237", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), route.getString("number"));
                }
                this.addErrorMessage(this.dataEntities[i], checkMsg);
                isCheck = Boolean.FALSE;
            }
        }
        return isCheck;
    }

    private void checkUnAuditData() {
        Set<Long> routeIDSet = this.getRouteIdSet();
        String opKey = "unaudit";
        if (!routeIDSet.isEmpty()) {
            Set<Long> existsRouteIDSet = this.getExistsECNRouteIdSet(routeIDSet, opKey);
            if (!this.checkExistsECN(existsRouteIDSet, opKey)) {
                return;
            }
            if (PdmParamSetHelper.getBooleanParamValue((String)"BomUnAuditCheckMutex")) {
                return;
            }
            List ids = routeIDSet.stream().map(x -> x.toString()).collect(Collectors.toList());
            Set lockIds = BomUtils.checkEntityIsLock(ids, (String)"pdm_route", (String)"modify");
            if (!lockIds.isEmpty()) {
                int n = this.dataEntities.length;
                for (int i = 0; i < n; ++i) {
                    DynamicObject route = this.dataEntities[i].getDataEntity();
                    Long routeId = route.getLong("id");
                    if (!this.isPdmRoute(route) || !lockIds.contains(String.valueOf(routeId))) continue;
                    String checkMsg = String.format(ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u201c%1$s\u201d\u6b63\u5728\u7f16\u8f91\u4e2d\uff0c\u5df2\u88ab\u9501\u5b9a\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"ProcessRouteValidator_238", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), route.getString("number"));
                    this.addErrorMessage(this.dataEntities[i], checkMsg);
                }
            }
        }
    }
}

