/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.routebasedata;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import kd.bd.mpdm.common.utils.DynamicObjDataUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class ToolEquipSubmitValidator
extends AbstractValidator {
    private static final String OPERATION_SUBMIT = "submit";
    private static final String OPERATION_SAVE = "save";
    private static final String ENTRY = "mpdm_toolequipentry";
    private static final String JOBSUBENTRY = "mpdm_toolequipentry_p";
    private static final String JOBTASKNO = "jobtaskno";
    private static final String BEGINDATE = "begindate";
    private static final String ENDDATE = "enddate";

    public void validate() {
        String operate = this.getOperateKey();
        ExtendedDataEntity[] objs = this.getDataEntities();
        if (OPERATION_SUBMIT.equalsIgnoreCase(operate) || OPERATION_SAVE.equalsIgnoreCase(operate)) {
            for (ExtendedDataEntity obj : objs) {
                boolean isError;
                DynamicObject entry;
                DynamicObjectCollection jobEntry;
                DynamicObject toolEquip = obj.getDataEntity();
                DynamicObjectCollection entrys = toolEquip.getDynamicObjectCollection(ENTRY);
                for (int i = 0; i < entrys.size() && ((jobEntry = (entry = (DynamicObject)entrys.get(i)).getDynamicObjectCollection(JOBSUBENTRY)) == null || jobEntry.isEmpty() || !(isError = this.uniteJobEntry(obj, i + 1, jobEntry))); ++i) {
                }
            }
        }
    }

    private boolean uniteJobEntry(ExtendedDataEntity obj, int index, DynamicObjectCollection jobEntry) {
        boolean isError = false;
        jobEntry.sort((Comparator)new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                String jobNo1 = DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)o1, (String)ToolEquipSubmitValidator.JOBTASKNO);
                String jobNo2 = DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)o2, (String)ToolEquipSubmitValidator.JOBTASKNO);
                if (jobNo1 == null || jobNo2 == null) {
                    return 0;
                }
                if (jobNo1.compareTo(jobNo2) == 0) {
                    Date validate1 = DynamicObjDataUtil.getDynamicObjectDateData((DynamicObject)o1, (String)ToolEquipSubmitValidator.BEGINDATE);
                    Date invalidate1 = DynamicObjDataUtil.getDynamicObjectDateData((DynamicObject)o1, (String)ToolEquipSubmitValidator.ENDDATE);
                    Date validate2 = DynamicObjDataUtil.getDynamicObjectDateData((DynamicObject)o2, (String)ToolEquipSubmitValidator.BEGINDATE);
                    Date invalidate2 = DynamicObjDataUtil.getDynamicObjectDateData((DynamicObject)o2, (String)ToolEquipSubmitValidator.ENDDATE);
                    if (validate1 == null || validate2 == null) {
                        return 0;
                    }
                    if (validate1.compareTo(validate2) == 0) {
                        if (invalidate1 == null || invalidate2 == null) {
                            return 0;
                        }
                        return invalidate1.compareTo(invalidate2);
                    }
                    return validate1.compareTo(validate2);
                }
                return jobNo1.compareTo(jobNo2);
            }
        });
        for (int i = 0; i < jobEntry.size(); ++i) {
            Date invalidate;
            DynamicObject job = (DynamicObject)jobEntry.get(i);
            Date validate = DynamicObjDataUtil.getDynamicObjectDateData((DynamicObject)job, (String)BEGINDATE);
            if (!validate.after(invalidate = DynamicObjDataUtil.getDynamicObjectDateData((DynamicObject)job, (String)ENDDATE))) continue;
            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u5de5\u88c5\u660e\u7ec6\u5206\u5f55\u7b2c%1$s\u884c\uff0c\u8ba1\u5212\u5206\u5f55\u7b2c%2$s\u884c\uff0c\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u5927\u4e8e\u8ba1\u5212\u7ed3\u675f\u65f6\u95f4\uff0c\u8bf7\u4fee\u6539", (String)"ToolEquipSubmitValidator_8", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), index, i + 1));
            isError = true;
            break;
        }
        if (!isError) {
            ArrayList<Integer> delIndexs = new ArrayList<Integer>();
            for (int i = 0; i < jobEntry.size(); ++i) {
                for (int j = i + 1; j < jobEntry.size(); ++j) {
                    if (delIndexs.contains(j) || delIndexs.contains(i)) continue;
                    DynamicObject job1 = (DynamicObject)jobEntry.get(i);
                    DynamicObject job2 = (DynamicObject)jobEntry.get(j);
                    String jobNo1 = DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)job1, (String)JOBTASKNO);
                    String jobNo2 = DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)job2, (String)JOBTASKNO);
                    Date validate1 = DynamicObjDataUtil.getDynamicObjectDateData((DynamicObject)job1, (String)BEGINDATE);
                    Date invalidate1 = DynamicObjDataUtil.getDynamicObjectDateData((DynamicObject)job1, (String)ENDDATE);
                    Date validate2 = DynamicObjDataUtil.getDynamicObjectDateData((DynamicObject)job2, (String)BEGINDATE);
                    Date invalidate2 = DynamicObjDataUtil.getDynamicObjectDateData((DynamicObject)job2, (String)ENDDATE);
                    if ((validate1.compareTo(invalidate2) > 0 || validate1.compareTo(validate2) < 0) && (validate2.compareTo(invalidate1) > 0 || validate2.compareTo(validate1) < 0)) continue;
                    if (StringUtils.equalsIgnoreCase((CharSequence)jobNo1, (CharSequence)jobNo2)) {
                        Date beiginDate = validate1.before(validate2) ? validate1 : validate2;
                        Date endDate = invalidate1.after(invalidate2) ? invalidate1 : invalidate2;
                        job1.set(BEGINDATE, (Object)beiginDate);
                        job1.set(ENDDATE, (Object)endDate);
                        delIndexs.add(j);
                        continue;
                    }
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u5de5\u88c5\u660e\u7ec6\u5206\u5f55\u7b2c%1$s\u884c\uff0c\u8ba1\u5212\u5206\u5f55\u7b2c%2$s\u884c\u548c\u7b2c%3$s\u884c\uff0c\u8ba1\u5212\u65f6\u95f4\u5b58\u5728\u91cd\u53e0", (String)"ToolEquipSubmitValidator_9", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), index, i + 1, j + 1));
                    isError = true;
                    break;
                }
                if (isError) break;
            }
            if (!isError && !delIndexs.isEmpty()) {
                ArrayList<Object> delList = new ArrayList<Object>(delIndexs.size());
                for (Integer i : delIndexs) {
                    delList.add(jobEntry.get(i.intValue()));
                }
                jobEntry.removeAll(delList);
            }
        }
        return isError;
    }
}

