/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.routebasedata;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.AbstractValidator;

public class WorkShiftValidator
extends AbstractValidator {
    public void validate() {
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject workShift = this.dataEntities[i].getDataEntity();
            BigDecimal workShiftTIme = new BigDecimal(workShift.get("workshifttime").toString());
            if (workShiftTIme.compareTo(new BigDecimal(24)) > 0) {
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u73ed\u6b21\u603b\u65f6\u957f\u4e0d\u80fd\u8d85\u8fc724\u5c0f\u65f6\uff01", (String)"WorkShiftValidator_0", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
            }
            DynamicObjectCollection col = workShift.getDynamicObjectCollection("entryentity");
            this.getRepeatRow(col, i);
        }
    }

    private void getRepeatRow(DynamicObjectCollection col, int row) {
        ArrayList<Integer> repectList = new ArrayList<Integer>();
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject entry = (DynamicObject)col.get(i);
            int workStartTime = Integer.parseInt(entry.get("workstarttime").toString());
            int workEndTime = Integer.parseInt(entry.get("workendtime").toString());
            if (workStartTime < 0) {
                this.addErrorMessage(this.dataEntities[row], String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55,\u5de5\u4f5c\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (String)"WorkShiftValidator_4", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i + 1));
                return;
            }
            if (workEndTime < 0) {
                this.addErrorMessage(this.dataEntities[row], String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55,\u5de5\u4f5c\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (String)"WorkShiftValidator_5", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i + 1));
                return;
            }
            boolean isCrossDay = entry.getBoolean("iscrossday");
            for (int j = i + 1; j < col.size(); ++j) {
                DynamicObject obj = (DynamicObject)col.get(j);
                int start = Integer.parseInt(obj.get("workstarttime").toString());
                int end = Integer.parseInt(obj.get("workendtime").toString());
                boolean cross = obj.getBoolean("iscrossday");
                boolean flag = this.compareDay(isCrossDay, cross, workStartTime, workEndTime, start, end);
                if (flag) {
                    repectList.add(i + 1);
                    repectList.add(j + 1);
                }
                if (isCrossDay && cross) {
                    repectList.add(i + 1);
                    repectList.add(j + 1);
                }
                if (flag = this.compareDay1(isCrossDay, cross, workStartTime, workEndTime, start, end)) {
                    repectList.add(i + 1);
                    repectList.add(j + 1);
                }
                if (!(flag = this.compareDay2(isCrossDay, cross, workStartTime, workEndTime, start, end))) continue;
                repectList.add(i + 1);
                repectList.add(j + 1);
            }
        }
        HashSet set = new HashSet(repectList);
        if (!(repectList = new ArrayList(set)).isEmpty()) {
            this.addErrorMessage(this.dataEntities[row], String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u65f6\u95f4\u6bb5\u6709\u91cd\u53e0\uff01", (String)"WorkShiftValidator_6", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), ((Object)repectList).toString()));
        }
    }

    private boolean compareDay(boolean isCrossDay, boolean cross, int workStartTime, int workEndTime, int start, int end) {
        boolean flag = isCrossDay && !cross && (workStartTime <= end || workEndTime >= start);
        return flag;
    }

    private boolean compareDay1(boolean isCrossDay, boolean cross, int workStartTime, int workEndTime, int start, int end) {
        boolean flag = !isCrossDay && !cross && Math.max(workStartTime, start) <= Math.min(workEndTime, end);
        return flag;
    }

    private boolean compareDay2(boolean isCrossDay, boolean cross, int workStartTime, int workEndTime, int start, int end) {
        boolean flag = !isCrossDay && cross && (workEndTime >= start || workStartTime <= end);
        return flag;
    }
}

