/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.sn.val;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.business.mftorder.SerialNumberHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class SerialNumberSaveValidator
extends AbstractValidator {
    public void validate() {
        try (TraceSpan span = Tracer.create((String)"SerialNumberSaveValidator", (String)"validate");){
            int length = this.dataEntities.length;
            HashMap<Object, ExtendedDataEntity> billIdToDataEntityMap = new HashMap<Object, ExtendedDataEntity>(length);
            ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>(length);
            for (int dataEntityIndex = 0; dataEntityIndex < length; ++dataEntityIndex) {
                ExtendedDataEntity extendedDataEntity = this.dataEntities[dataEntityIndex];
                Object billId = extendedDataEntity.getBillPkId();
                billIdToDataEntityMap.put(billId, extendedDataEntity);
                bills.add(extendedDataEntity.getDataEntity());
            }
            Map errorMessageData = SerialNumberHelper.validateCallSNService(bills, (String)this.getOperateKey());
            for (Map.Entry errorMessageEntry : errorMessageData.entrySet()) {
                Object billId = errorMessageEntry.getKey();
                ExtendedDataEntity errorDataEntity = (ExtendedDataEntity)billIdToDataEntityMap.get(billId);
                if (errorDataEntity == null) {
                    errorDataEntity = (ExtendedDataEntity)billIdToDataEntityMap.get(0L);
                }
                if (errorDataEntity == null) continue;
                List errorMessages = (List)errorMessageEntry.getValue();
                for (String errorMessage : errorMessages) {
                    this.addErrorMessage(errorDataEntity, errorMessage);
                }
            }
        }
    }
}

