/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.state;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.business.state.helper.StateHelper;
import kd.bd.mpdm.business.state.mservice.StateServiceImpl;
import kd.bd.mpdm.common.state.model.StateRuleModel;
import kd.bd.mpdm.common.state.model.StateSchemeModel;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class StateChangeOp
extends AbstractOperationServicePlugIn {
    private Set<Long> successIds = new HashSet<Long>();
    private Set<Long> errorIds = new HashSet<Long>();
    private List<StateSchemeModel> stateSchemes;

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operationKey = e.getOperationKey();
        if (!this.successIds.isEmpty()) {
            DynamicObject[] dyObjs;
            Map rules = this.stateSchemes.get(0).getStateRuleModels();
            String attribute = null;
            Long stateId = null;
            for (Map.Entry rule : rules.entrySet()) {
                if (!operationKey.equalsIgnoreCase(((StateRuleModel)rule.getValue()).getBillstate())) continue;
                attribute = ((StateRuleModel)rule.getValue()).getBillfield();
                stateId = ((StateRuleModel)rule.getValue()).getBillstateid();
                break;
            }
            if (attribute == null || attribute.isEmpty()) {
                return;
            }
            String pageBill = this.billEntityType.getExtendName();
            for (DynamicObject dataEntitie : dyObjs = StateHelper.getState((String)pageBill, this.successIds, (String)attribute)) {
                if (this.successIds.contains(Long.parseLong(dataEntitie.getPkValue().toString()))) {
                    dataEntitie.set(attribute, (Object)stateId);
                }
                long userId = RequestContext.get().getCurrUserId();
                dataEntitie.set("pjsuptime", (Object)new Date());
                dataEntitie.set("pjsupuser", (Object)userId);
            }
            SaveServiceHelper.save((DynamicObject[])dyObjs);
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        String operationKey = e.getOperationKey();
        String pageBill = this.billEntityType.getExtendName();
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Long> ids = new HashSet<Long>(16);
        for (DynamicObject dataEntitie : dataEntities) {
            ids.add(Long.parseLong(dataEntitie.getPkValue().toString()));
            this.successIds.add(Long.parseLong(dataEntitie.getPkValue().toString()));
        }
        if (!ids.isEmpty()) {
            StateServiceImpl stateService = new StateServiceImpl();
            Map sateChangeMap = stateService.StateChange(operationKey, pageBill, ids);
            List errorList = (List)sateChangeMap.get("errorList");
            if (errorList != null) {
                for (Map errorMap : errorList) {
                    Set errIds = (Set)errorMap.get("error_ids");
                    for (ExtendedDataEntity dataEntity : e.getValidExtDataEntities()) {
                        if (!errIds.contains(Long.parseLong(dataEntity.getBillPkId().toString()))) continue;
                        this.addErrMessage(dataEntity, errorMap.get("error_msg").toString());
                        this.errorIds.add(Long.parseLong(dataEntity.getBillPkId().toString()));
                    }
                }
            }
            this.successIds.removeAll(this.errorIds);
            ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>(this.successIds.size());
            this.stateSchemes = (List)sateChangeMap.get("stateScheme");
            for (DynamicObject dataEntitie : dataEntities) {
                if (!this.successIds.contains(Long.parseLong(dataEntitie.getPkValue().toString()))) continue;
                successObjs.add(dataEntitie);
            }
            e.setDataEntities(successObjs.toArray(new DynamicObject[successObjs.size()]));
        }
    }

    private void addErrMessage(ExtendedDataEntity dataEntity, String errMsg) {
        Object pkId = dataEntity.getDataEntity().getPkValue();
        int dataIndex = dataEntity.getDataEntityIndex();
        int rowIndex = 0;
        ErrorLevel errorLevel = ErrorLevel.Error;
        ValidationErrorInfo errInfo = new ValidationErrorInfo("", pkId, dataIndex, rowIndex, "StateChangeOp", "", errMsg, errorLevel);
        this.operationResult.addErrorInfo((OperateErrorInfo)errInfo);
    }
}

