/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.stockchange;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.mftorder.utils.CreateStockByBomUtils;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bd.mpdm.common.stockchange.utils.ChangeConfigUtils;
import kd.bd.mpdm.common.stockchange.utils.StockChangeUtils;
import kd.bd.mpdm.opplugin.stockchange.validator.StockChangeAuditValidator;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.sequence.SequenceReader;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class StockChangeAuditTplOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(StockChangeAuditTplOp.class);
    Map<String, DynamicObject> stockNoDymMap = new HashMap<String, DynamicObject>(16);
    Map<String, DynamicObject> manftechMap = new HashMap<String, DynamicObject>(16);
    Map<String, DynamicObject> stockChangeLogMap = new HashMap<String, DynamicObject>(16);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List filds = e.getFieldKeys();
        filds.add("stockentry");
        filds.add("id");
        filds.add("reason");
        filds.add("createtime");
        filds.add("creator");
        filds.add("stockentry.entryidf");
        filds.add("stockentry.entryorderentryid");
        filds.add("stockentry.stockentry_lk");
        filds.add("stockentry.stockentry_lk_stableid");
        filds.add("stockentry.stockentry_lk_sbillid");
        filds.add("stockentry.stockentry_lk_sid");
        filds.add("stockentry.stockno");
        filds.add("stockentry.stockid");
        filds.add("stockentry.productno");
        filds.add("stockentry.materielmasterid");
        filds.add("stockentry.entryorderentryid");
        filds.add("stockentry.stockentryid");
        filds.add("stockentry.stockentryseq");
        filds.add("stockentry.seq");
        filds.add("stockentry.sourcetype");
        filds.add("orderentryid.supplier");
        filds.add("stockentry.pid");
        filds.add("isinitbill");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new StockChangeAuditValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] stockChangeBills = e.getDataEntities();
        logger.info("\u7ec4\u4ef6\u6e05\u5355\u53d8\u66f4\u5355\u5ba1\u6838beginOperationTransaction");
        String stockChangeName = stockChangeBills[0].getDataEntityType().getName();
        this.stockNoDymMap = StockChangeUtils.getStockNoDymMap((DynamicObject[])stockChangeBills, (String)stockChangeName);
        this.manftechMap = StockChangeUtils.getManftechMap((DynamicObject[])stockChangeBills, (String)stockChangeName);
        this.stockChangeLogMap = StockChangeUtils.getStockChangeLogMap((DynamicObject[])stockChangeBills, (String)stockChangeName);
        HashMap<String, List<DynamicObject>> addStockMap = new HashMap<String, List<DynamicObject>>(16);
        for (int i = 0; i < stockChangeBills.length; ++i) {
            DynamicObject stockChangeBill = stockChangeBills[i];
            DynamicObjectCollection dynamicObjectCollection = stockChangeBill.getDynamicObjectCollection("stockentry");
            for (int j = 0; j < dynamicObjectCollection.size(); ++j) {
                DynamicObject stockChangeEntry = (DynamicObject)dynamicObjectCollection.get(j);
                this.changeManuBillAfterAudit(stockChangeEntry, stockChangeName, addStockMap);
            }
        }
        if (!addStockMap.isEmpty()) {
            ArrayList<DynamicObject> saveBomStocks = new ArrayList<DynamicObject>(16);
            for (Map.Entry entry : addStockMap.entrySet()) {
                DynamicObject stock = this.stockNoDymMap.get(entry.getKey());
                List stockEntryList = (List)entry.getValue();
                CreateStockByBomUtils.setPStockEntryId((DynamicObject)stock, (List)stockEntryList);
                saveBomStocks.add(stock);
            }
            MPDMMftGenStocksUtils.updateRepPid(saveBomStocks);
        }
        if (!this.stockNoDymMap.isEmpty()) {
            Collection<DynamicObject> values = this.stockNoDymMap.values();
            DynamicObject[] array = values.toArray(new DynamicObject[values.size()]);
            SaveServiceHelper.save((DynamicObject[])array);
        }
    }

    public static String getErrDetail(OperationResult optResult) {
        StringBuilder errDetail = new StringBuilder();
        if (optResult.getMessage() != null) {
            errDetail.append(optResult.getMessage());
        }
        for (IOperateInfo errInfo : optResult.getAllErrorOrValidateInfo()) {
            errDetail.append(errInfo.getMessage());
        }
        return errDetail.toString();
    }

    private void changeChangeLogStatus(DynamicObject stockChangeEntry) {
        String stockChangeEntryId = stockChangeEntry.getPkValue().toString();
        DynamicObject dynamicObject = this.stockChangeLogMap.get(stockChangeEntryId);
        dynamicObject.set("billstatus", (Object)"C");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        Object entryCol;
        super.afterExecuteOperationTransaction(e);
        logger.info("\u7ec4\u4ef6\u6e05\u5355\u53d8\u66f4\u5355\u5ba1\u6838afterExecuteOperationTransaction");
        DynamicObject[] stockChangeBills = e.getDataEntities();
        String stockChangeName = stockChangeBills[0].getDataEntityType().getName();
        String stockName = StockChangeUtils.getEntityName((int)3, (int)1, (String)stockChangeName);
        String orderName = StockChangeUtils.getEntityName((int)3, (int)0, (String)stockChangeName);
        TableDefine srcTableDefine = EntityMetadataCache.loadTableDefine((String)stockName, (String)stockName);
        HashSet<String> billEntityIds = new HashSet<String>(20);
        HashSet<Object> billEntryIdSets = new HashSet<Object>(20);
        HashSet<String> billIds = new HashSet<String>(20);
        StockChangeUtils.removeStockThreadLocal();
        Map stockF7Map = StockChangeUtils.getStockF7Map((DynamicObject[])stockChangeBills, (String)stockName);
        for (int i = 0; i < stockChangeBills.length; ++i) {
            DynamicObject stockChangeEntry;
            DynamicObject stockChangeBill = stockChangeBills[i];
            entryCol = stockChangeBill.getDynamicObjectCollection("stockentry");
            for (int j = 0; j < entryCol.size(); ++j) {
                stockChangeEntry = (DynamicObject)entryCol.get(j);
                DynamicObjectCollection linkRows = stockChangeEntry.getDynamicObjectCollection("stockentry_lk");
                billEntityIds.add(stockChangeEntry.getDynamicObject("entryorderentryid").getPkValue().toString());
                billEntryIdSets.add(stockChangeEntry.getDynamicObject("entryorderentryid").getPkValue());
                if (this.checkHasStockBotpLink(linkRows, srcTableDefine.getTableId())) continue;
                String stockNo = stockChangeEntry.getString("stockno");
                String stockid = stockChangeEntry.getString("stockid");
                if (StringUtils.isEmpty((CharSequence)stockNo)) {
                    return;
                }
                DynamicObject stockBill = this.stockNoDymMap.get(stockNo);
                int stockentryseq = Integer.parseInt(stockChangeEntry.getString("stockentryseq"));
                DynamicObject stockEntry = (DynamicObject)stockBill.getDynamicObjectCollection("stockentry").get(stockentryseq - 1);
                stockChangeEntry.set("stockentryid", stockEntry.getPkValue());
                stockChangeEntry.set("entryidf", stockF7Map.get(Long.parseLong(stockChangeEntry.getString("stockentryid"))));
                DynamicObject linkRow = new DynamicObject(linkRows.getDynamicObjectType());
                linkRow.set("stockentry_lk_stableid", (Object)srcTableDefine.getTableId());
                linkRow.set("stockentry_lk_sbillid", (Object)stockid);
                linkRow.set("stockentry_lk_sid", stockEntry.getPkValue());
                linkRows.add((Object)linkRow);
            }
            Iterator j = entryCol.iterator();
            while (j.hasNext()) {
                stockChangeEntry = (DynamicObject)j.next();
                this.changeChangeLogStatus(stockChangeEntry);
            }
        }
        OperateOption create = OperateOption.create();
        create.setVariableValue("aduitToSave", "aduitToSave");
        SaveServiceHelper.saveOperate((String)stockChangeName, (DynamicObject[])stockChangeBills, (OperateOption)create);
        if (!this.stockChangeLogMap.isEmpty()) {
            Collection<DynamicObject> values = this.stockChangeLogMap.values();
            SaveServiceHelper.update((DynamicObject[])values.toArray(new DynamicObject[values.size()]));
        }
        if (CollectionUtils.isNotEmpty(billEntryIdSets)) {
            DataSet result = QueryServiceHelper.queryDataSet((String)"QueryOrderIds", (String)orderName, (String)"id", (QFilter[])new QFilter[]{new QFilter("treeentryentity.id", "in", billEntryIdSets)}, (String)"");
            entryCol = null;
            try {
                while (result.hasNext()) {
                    Row row = result.next();
                    billIds.add(row.get("id").toString());
                }
            }
            catch (Throwable row) {
                entryCol = row;
                throw row;
            }
            finally {
                if (result != null) {
                    if (entryCol != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable row) {
                            ((Throwable)entryCol).addSuppressed(row);
                        }
                    } else {
                        result.close();
                    }
                }
            }
        }
        String appId = "pom";
        String modetype = "1";
        if (stockChangeName.startsWith("om")) {
            appId = "om";
            modetype = "2";
        }
        if (!billEntityIds.isEmpty() && !billIds.isEmpty()) {
            HashMap<String, Object> calparam = new HashMap<String, Object>();
            calparam.put("orderentryids", billEntityIds);
            calparam.put("orderids", billIds);
            calparam.put("operate", "audit");
            calparam.put("iscloseorder", "1");
            calparam.put("modetype", modetype);
            calparam.put("isautocal", "0");
            calparam.put("isautoflag", "0");
            calparam.put("appId", appId);
            String jsonString = JSON.toJSONString(calparam);
            EventServiceHelper.triggerEventSubscribe((String)"auditCalMaterial", (String)jsonString);
        }
    }

    private void changeManuBillAfterAudit(DynamicObject stockChangeEntry, String stockChangeName, Map<String, List<DynamicObject>> addStockMap) {
        String changeType = stockChangeEntry.getString("entrychangetype");
        if (StringUtils.equals((CharSequence)"A", (CharSequence)changeType)) {
            this.changeBillForNew(stockChangeEntry, stockChangeName, addStockMap);
        } else if (StringUtils.equals((CharSequence)"B", (CharSequence)changeType)) {
            this.changeBillForChange(stockChangeEntry);
        }
    }

    private void changeBillForChange(DynamicObject stockChangeEntry) {
        String stockNo = stockChangeEntry.getString("stockno");
        String stockEntryid = stockChangeEntry.getString("stockentryid");
        if (StringUtils.isEmpty((CharSequence)stockNo) || StringUtils.isEmpty((CharSequence)stockEntryid)) {
            return;
        }
        DynamicObject stockBill = this.stockNoDymMap.get(stockNo);
        DynamicObjectCollection entryCol = stockBill.getDynamicObjectCollection("stockentry");
        String stockChangeName = stockBill.getDataEntityType().getName();
        for (int i = 0; i < entryCol.size(); ++i) {
            DynamicObject stockBillEntry = (DynamicObject)entryCol.get(i);
            if (!StringUtils.equals((CharSequence)stockBillEntry.getPkValue().toString(), (CharSequence)stockEntryid)) continue;
            this.updateStockEntry(stockBillEntry, stockChangeEntry, stockChangeName);
            this.updateMftStockEntry(stockBill, stockBillEntry);
        }
    }

    private void updateStockEntry(DynamicObject stockBillEntry, DynamicObject stockChangeEntry, String stockChangeName) {
        DynamicObject materialOld = stockBillEntry.getDynamicObject("materialid");
        DynamicObject materialNew = stockChangeEntry.getDynamicObject("materialid");
        if (materialOld == null || materialNew == null) {
            return;
        }
        if (!materialOld.getPkValue().equals(materialNew.getPkValue())) {
            return;
        }
        String[] stock = ChangeConfigUtils.getEntryFields((String)StockChangeUtils.getEntityName((int)1, (int)3, (String)stockChangeName), (String)"b");
        for (int i = 0; i < stock.length; ++i) {
            String propertyName = stock[i];
            stockBillEntry.set(propertyName, stockChangeEntry.get(propertyName));
        }
        this.reCalQty(stockBillEntry, stockChangeEntry);
    }

    private void reCalQty(DynamicObject stockBillEntry, DynamicObject stockChangeEntry) {
        if (stockBillEntry.getBoolean("iscannegative") || stockChangeEntry.getBoolean("iscannegative")) {
            stockBillEntry.set("actissueqty", stockChangeEntry.get("actissueqty"));
        }
        BigDecimal actissueqty = stockBillEntry.getBigDecimal("actissueqty");
        BigDecimal rejectedqty = stockBillEntry.getBigDecimal("rejectedqty");
        BigDecimal feedingqty = stockBillEntry.getBigDecimal("feedingqty");
        BigDecimal demandqty = stockChangeEntry.getBigDecimal("demandqty");
        BigDecimal extraratioqty = stockChangeEntry.getBigDecimal("extraratioqty");
        BigDecimal calQty = actissueqty.subtract(rejectedqty).add(feedingqty);
        stockBillEntry.set("unissueqty", (Object)demandqty.subtract(calQty));
        stockBillEntry.set("cansendqty", (Object)(extraratioqty.subtract(calQty).compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : extraratioqty.subtract(calQty)));
    }

    private void changeBillForNew(DynamicObject stockChangeEntry, String stockChangeName, Map<String, List<DynamicObject>> addStockMap) {
        List<DynamicObject> addstockEntryList;
        String stockNo = stockChangeEntry.getString("stockno");
        if (StringUtils.isEmpty((CharSequence)stockNo)) {
            return;
        }
        DynamicObject stock = this.stockNoDymMap.get(stockNo);
        if (stock == null) {
            return;
        }
        DynamicObjectCollection stockEntryCol = stock.getDynamicObjectCollection("stockentry");
        DynamicObjectType dynamicObjectType = stockEntryCol.getDynamicObjectType();
        DynamicObject stockEntry = (DynamicObject)dynamicObjectType.createInstance();
        Set stockFields = StockChangeUtils.getAllStockEentryFields((String)stockChangeName);
        for (String stockField : stockFields) {
            stockEntry.set(stockField, stockChangeEntry.get(stockField));
        }
        stockEntry.set("pid", stockChangeEntry.get("pid"));
        int seq = stockEntryCol.size() + 1;
        IDataEntityType type = stockEntry.getDataEntityType();
        DBRoute rt = new DBRoute(type.getDBRouteKey());
        SequenceReader seqReader = new SequenceReader(rt);
        seqReader.autoSetPrimaryKey((Object[])new DynamicObject[]{stockEntry}, type);
        stockEntry.set("seq", (Object)seq);
        stockEntry.set("sourcetype", stockChangeEntry.get("sourcetype"));
        this.updateMftStockEntry(stock, stockEntry);
        stockEntryCol.add((Object)stockEntry);
        int changeSeq = (Integer)stockChangeEntry.get("seq");
        if (changeSeq >= 1) {
            stockChangeEntry.set("stockentryid", stockEntry.getPkValue());
            stockChangeEntry.set("stockentryseq", (Object)seq);
            this.updateMftStockEntry(stock, stockChangeEntry);
            this.updateChangeLog(stockEntry.getPkValue(), stockChangeEntry.getPkValue());
        }
        if ((addstockEntryList = addStockMap.get(stockNo)) == null) {
            addstockEntryList = new ArrayList<DynamicObject>(16);
        }
        addstockEntryList.add(stockEntry);
        addStockMap.put(stockNo, addstockEntryList);
    }

    private void updateChangeLog(Object stockEntryId, Object xstockEntryId) {
        DynamicObject stockLog = this.stockChangeLogMap.get(xstockEntryId.toString());
        if (stockLog != null) {
            stockLog.set("entryidf", stockEntryId);
        }
    }

    private void updateMftStockEntry(DynamicObject stock, DynamicObject stockEntry) {
        DynamicObject load = this.manftechMap.get(stock.getDynamicObject("orderentryid").getPkValue().toString());
        if (load != null) {
            MPDMMftGenStocksUtils.updateMftStockEntry((DynamicObject)stockEntry, (DynamicObject)load);
        }
    }

    private boolean checkHasStockBotpLink(DynamicObjectCollection linkRows, Long sTableId) {
        if (linkRows == null || linkRows.isEmpty()) {
            return false;
        }
        for (DynamicObject linkRow : linkRows) {
            Long existSTableId = linkRow.getLong("stockentry_lk_stableid");
            if (existSTableId == null || !existSTableId.equals(sTableId)) continue;
            return true;
        }
        return false;
    }
}

