/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.stockchange;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class StockChangeImportTplOp
extends BatchImportPlugin {
    private static final Map<String, DynamicObject> materialmftinfo = new HashMap<String, DynamicObject>(16);
    private static final String NUMBER = "number";
    private static Log logger = LogFactory.getLog(StockChangeImportTplOp.class);

    protected int getBatchImportSize() {
        return 5000;
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        this.cacheData(rowdatas);
        this.defalutData(rowdatas);
        return super.save(rowdatas, logger);
    }

    private void cacheData(List<ImportBillData> rowdatas) {
        Iterator<ImportBillData> iterator = rowdatas.iterator();
        ArrayList<String> mftInfoNumberList = new ArrayList<String>(10);
        String orgNum = "";
        while (iterator.hasNext()) {
            ImportBillData rowdata = iterator.next();
            JSONObject data = rowdata.getData();
            Map orgMap = (Map)data.get((Object)"org");
            if (orgMap == null) continue;
            orgNum = (String)orgMap.get(NUMBER);
            List listData = (List)data.get((Object)"stockentry");
            for (Map entry : listData) {
                Map mtinfo = (Map)entry.get("materialid");
                String mtNumber = (String)mtinfo.get(NUMBER);
                if (StringUtils.isBlank((CharSequence)mtNumber) || !"A".equals(entry.get("entrychangetype"))) continue;
                mftInfoNumberList.add(mtNumber);
            }
        }
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id,number", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)orgNum)});
        if (org == null) {
            return;
        }
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialmftinfo", (Long)((Long)org.getPkValue()));
        logger.info("\u5bfc\u5165\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u7f13\u5b58\u8fc7\u6ee4" + baseDataFilter.toString());
        Map mftInfoMap = BusinessDataServiceHelper.loadFromCache((String)"bd_materialmftinfo", (QFilter[])new QFilter[]{baseDataFilter.and(new QFilter("masterid.number", "in", mftInfoNumberList))});
        logger.info("\u5bfc\u5165\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u7f13\u5b58\u8fc7\u6ee4" + ((Object)mftInfoNumberList).toString());
        Collection values = mftInfoMap.values();
        for (DynamicObject value : values) {
            materialmftinfo.put(value.getString("masterid.number"), value);
        }
        logger.info("\u5bfc\u5165\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u7f13\u5b58" + materialmftinfo.size());
    }

    private void defalutData(List<ImportBillData> rowdatas) {
        for (ImportBillData rowdata : rowdatas) {
            JSONObject data = rowdata.getData();
            data.put("billstatus", (Object)"A");
            List listData = (List)data.get((Object)"stockentry");
            for (Map entry : listData) {
                entry.put("islead", Boolean.TRUE);
                if (!"A".equals(entry.get("entrychangetype"))) continue;
                this.autoFillStockNew(entry);
            }
        }
    }

    private void autoFillStockNew(Map<String, Object> entry) {
        logger.info("\u5bfc\u5165\u53d6\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u5b57\u6bb5\uff0c\u5224\u65ad\u662f\u5426\u4e3a\u7a7a");
        Map mtinfo = (Map)entry.get("materialid");
        if (mtinfo == null) {
            return;
        }
        logger.info("\u5bfc\u5165\u53d6\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u5b57\u6bb5\uff0c\u5224\u65ad\u662f\u5426\u4e3a\u7a7a1");
        String mtNumber = (String)mtinfo.get(NUMBER);
        DynamicObject materialInfo = materialmftinfo.get(mtNumber);
        if (materialInfo == null) {
            return;
        }
        logger.info("\u5bfc\u5165\u53d6\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u5b57\u6bb5\uff0c\u5f00\u59cb");
        String issuemode = materialInfo.getString("issuemode");
        String modestring = MPDMMftGenStocksUtils.getIssuemode((Object)issuemode);
        String isbackflush = materialInfo.getString("isbackflush");
        Boolean isbulkmaterial = materialInfo.getBoolean("isbulkmaterial");
        Boolean iskeypart = materialInfo.getBoolean("iskeypart");
        Boolean isquotacontrol = materialInfo.getBoolean("isquotacontrol");
        if (entry.get("issuemode") == null) {
            entry.put("issuemode", modestring);
        }
        if (entry.get("isbackflush") == null) {
            entry.put("isbackflush", isbackflush);
        }
        if (entry.get("isbulkmaterial") == null) {
            entry.put("isbulkmaterial", isbulkmaterial);
        }
        if (entry.get("iskeypart") == null) {
            entry.put("iskeypart", iskeypart);
        }
        if (entry.get("overissuecontrl") == null) {
            entry.put("overissuecontrl", "A");
            if (isquotacontrol.booleanValue()) {
                entry.put("overissuecontrl", "B");
            }
        }
        logger.info("\u5bfc\u5165\u53d6\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u5b57\u6bb5\uff0c\u7ed3\u675f");
    }
}

