/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.stockchange.validator;

import java.util.ArrayList;
import java.util.Map;
import kd.bd.mpdm.common.mftorder.enums.ManuBillBizStatusEnum;
import kd.bd.mpdm.common.stockchange.utils.StockChangeUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.validate.AbstractValidator;

public class StockChangeAuditValidator
extends AbstractValidator {
    public void validate() {
        ArrayList<Integer> unExistList = new ArrayList<Integer>();
        ArrayList<Integer> unauditList = new ArrayList<Integer>();
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        ArrayList<Integer> ischangedList = new ArrayList<Integer>();
        ArrayList<String> ischangedBillNoList = new ArrayList<String>();
        ArrayList<String> ischangedMnoList = new ArrayList<String>();
        ArrayList<Integer> isstockchangeList = new ArrayList<Integer>();
        ArrayList<Integer> isExistSeqList = new ArrayList<Integer>();
        DynamicObject[] stockChangeBills = new DynamicObject[this.dataEntities.length];
        String stockChangeName = this.getEntityKey();
        for (int i = 0; i < this.dataEntities.length; ++i) {
            stockChangeBills[i] = this.dataEntities[i].getDataEntity();
        }
        Map stockNoDymMap = StockChangeUtils.getStockNoDymMap((DynamicObject[])stockChangeBills, (String)stockChangeName);
        Map stockNoChangeMap = StockChangeUtils.getStockNoChangeBillnoMap((DynamicObject[])stockChangeBills, (String)stockChangeName);
        Map stockChangeMap = StockChangeUtils.getStockChangeMap((DynamicObject[])stockChangeBills, (String)stockChangeName);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            unExistList.clear();
            unauditList.clear();
            statusList.clear();
            ischangedList.clear();
            ischangedBillNoList.clear();
            ischangedMnoList.clear();
            isstockchangeList.clear();
            isExistSeqList.clear();
            DynamicObject manuChangeBill = this.dataEntities[i].getDataEntity();
            DynamicObjectCollection entryCol = manuChangeBill.getDynamicObjectCollection("stockentry");
            for (int j = 0; j < entryCol.size(); ++j) {
                String bizstatus;
                DynamicObject orderEntry;
                DynamicObject stockChangeEntry = (DynamicObject)entryCol.get(j);
                String stockNo = stockChangeEntry.getString("stockno");
                DynamicObject stock = (DynamicObject)stockNoDymMap.get(stockNo);
                String stockid = stock == null ? "0" : stock.getPkValue().toString();
                if ("0".equals(stockid)) {
                    unExistList.add(j + 1);
                    continue;
                }
                if (stock == null || "B".equals(stockChangeEntry.getString("entrychangetype")) && !this.isExistSeq(stock, stockChangeEntry)) {
                    isExistSeqList.add(j + 1);
                }
                if (stock != null && !StringUtils.equals((CharSequence)stock.getString("billstatus"), (CharSequence)"C")) {
                    unauditList.add(j + 1);
                }
                if (stock != null && !stock.getBoolean("transactiontypeid.isstockchange")) {
                    isstockchangeList.add(j + 1);
                }
                DynamicObject load = (DynamicObject)stockChangeMap.get(manuChangeBill.getPkValue().toString());
                String unAuditXChangeBillno = StockChangeUtils.changeExistUnAuditChangeBillno((DynamicObject)stockChangeEntry, (Map)stockNoChangeMap);
                if ((load == null || "0".equals(manuChangeBill.getPkValue().toString())) && !kd.bos.util.StringUtils.isEmpty((String)unAuditXChangeBillno)) {
                    ischangedList.add(j + 1);
                    ischangedBillNoList.add(unAuditXChangeBillno);
                    DynamicObject material = stockChangeEntry.getDynamicObject("materielmasterid");
                    String materialNumber = material == null ? "" : material.getString("number");
                    ischangedMnoList.add(materialNumber);
                }
                if (stock == null || (orderEntry = stock.getDynamicObject("orderentryid")) == null || StringUtils.equals((CharSequence)(bizstatus = orderEntry.getString("bizstatus")), (CharSequence)ManuBillBizStatusEnum.NORMAL.getValue())) continue;
                statusList.add(j + 1);
            }
            if (!unauditList.isEmpty()) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5bf9\u5e94\u7684\u7ec4\u4ef6\u6e05\u5355\u672a\u5ba1\u6838\u3002", (String)"StockChangeAuditValidator_7", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), ((Object)unauditList).toString()));
            }
            if (!ischangedList.isEmpty()) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5bf9\u5e94\u7684\u7ec4\u4ef6\u6e05\u5355\u5206\u5f55\u7269\u6599%2$s\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7ec4\u4ef6\u6e05\u5355\u53d8\u66f4\u5355%3$s\u3002", (String)"StockChangeAuditValidator_8", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), ((Object)ischangedList).toString(), ((Object)ischangedMnoList).toString(), ((Object)ischangedBillNoList).toString()));
            }
            if (!statusList.isEmpty()) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u5206\u5f55\u5bf9\u5e94\u7684\u5de5\u5355\u884c\uff0c\u884c\u72b6\u6001\u4e0d\u6ee1\u8db3 \u4e1a\u52a1\u72b6\u6001=\u6b63\u5e38\u3002", (String)"StockChangeAuditValidator_13", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), ((Object)statusList).toString()));
            }
            if (!unExistList.isEmpty()) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5bf9\u5e94\u7684\u7ec4\u4ef6\u6e05\u5355\u4e0d\u5b58\u5728\u3002", (String)"StockChangeAuditValidator_10", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), ((Object)unExistList).toString()));
            }
            if (!isstockchangeList.isEmpty()) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5bf9\u5e94\u7ec4\u4ef6\u6e05\u5355\u7684\u4e8b\u52a1\u7c7b\u578b\u672a\u542f\u7528\u7ec4\u4ef6\u6e05\u5355\u53d8\u66f4\u3002", (String)"StockChangeAuditValidator_11", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), ((Object)isstockchangeList).toString()));
            }
            if (isExistSeqList.isEmpty()) continue;
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u53d8\u66f4\u65b9\u5f0f\u4e3a\u4fee\u6539\uff0c\u7ec4\u4ef6\u6e05\u5355\u7f16\u53f7\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u7ec4\u4ef6\u7f16\u7801\u548c\u884c\u53f7\u3002", (String)"StockChangeAuditValidator_12", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), ((Object)isExistSeqList).toString()));
        }
    }

    private boolean isExistSeq(DynamicObject stock, DynamicObject stockChangeEntry) {
        String stockEntrySeq = stockChangeEntry.getString("stockentryseq");
        DynamicObject material = stockChangeEntry.getDynamicObject("materialid");
        String stockEntryId = stockChangeEntry.getString("stockentryid");
        DynamicObjectCollection stockEntryCol = stock.getDynamicObjectCollection("stockentry");
        for (DynamicObject stockEntry : stockEntryCol) {
            if (!stockEntrySeq.equals(stockEntry.getString("seq")) || !material.getPkValue().equals(stockEntry.getDynamicObject("materialid").getPkValue()) || !stockEntry.getPkValue().toString().equals(stockEntryId)) continue;
            return true;
        }
        return false;
    }
}

