/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.stockchange.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.query.helper.TransactionTypeQueryHelper;
import kd.bd.mpdm.common.stockchange.utils.StockChangeImportUtils;
import kd.bd.mpdm.common.stockchange.utils.StockChangeUtils;
import kd.bd.mpdm.common.utils.CommonUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class StockChangeSaveImpValidator
extends AbstractValidator {
    private static final String EQUALSMAINLIST = "equalsmainlist";
    private static final String ISBACKFLUSHLIST = "isbackflushlist";
    private static final String WAREHOUSELIST = "warehouselist";
    private static final String BACKFLUSHTIMELIST = "backflushtimelist";
    private static final String OVERISSUECONTRLLIST = "overissuecontrllist";
    private static final String LOCATIONLIST = "locationlist";
    private static final String OUTORGUNIT = "outorgunit";
    private static final String WASTAGERATELIST = "wastageratelist";
    private static final String SUPPLIERLIST = "supplierlist";
    private static final String SUPPLYORGLIST = "supplyorglist";
    private static final String ISSUEMODELIST = "issuemodelist";
    private static final String ISCANNEGATIVELIST = "iscannegativelist";
    private static final String ISBULKMATERIALLIST = "isbulkmateriallist";
    private static final String ISSINHIGHLIMITLIST = "issinhighlimitlist";
    private static final String[] ENTRY_FIELD_DYNAMICOBJECT_STR = new String[]{"materialid", "bomreversion", "entryconfiguredcode", "materialunitid", "workprocedureid"};
    private static final String[] ENTRY_FIELD_STRING_STR = new String[]{"batchno", "qtytype"};
    private static final String[] ENTRY_FIELD_BOOLEAN_STR = new String[]{"iscannegative"};
    private static Map<String, String> FIELD_NAME_MAP = new HashMap<String, String>(16);

    public void validate() {
        String mtSave = this.getOption().getVariableValue("mtSave", "0");
        boolean aduitToSave = this.getOption().containsVariable("aduittosave");
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (!aduitToSave || "1".equals(mtSave)) {
            DynamicObject[] stockChangeBills = new DynamicObject[dataEntities.length];
            boolean needQuery = false;
            for (int i = 0; i < stockChangeBills.length; ++i) {
                stockChangeBills[i] = dataEntities[i].getDataEntity();
                DynamicObject stockChangeBill = stockChangeBills[i];
                DynamicObjectCollection entryCol = stockChangeBill.getDynamicObjectCollection("stockentry");
                for (int j = 0; j < entryCol.size(); ++j) {
                    DynamicObject stockChangeEntry = (DynamicObject)entryCol.get(j);
                    if (!stockChangeEntry.getBoolean("islead")) continue;
                    needQuery = true;
                }
            }
            HashMap<String, DynamicObject> stockNoDymMap = new HashMap(16);
            if (needQuery) {
                stockNoDymMap = StockChangeUtils.getStockNoDymMap((DynamicObject[])stockChangeBills, (String)stockChangeBills[0].getDataEntityType().getName());
            }
            for (int i = 0; i < stockChangeBills.length; ++i) {
                DynamicObject stockChangeBill = stockChangeBills[i];
                DynamicObjectCollection entryCol = stockChangeBill.getDynamicObjectCollection("stockentry");
                for (int j = 0; j < entryCol.size(); ++j) {
                    DynamicObject stockChangeEntry = (DynamicObject)entryCol.get(j);
                    if (!stockChangeEntry.getBoolean("islead")) continue;
                    DynamicObject stockDy = (DynamicObject)stockNoDymMap.get(stockChangeEntry.getString("stockno"));
                    StockChangeImportUtils.changeManuBillAfterSubmit((DynamicObject)stockChangeEntry, (DynamicObject)stockChangeBill, (DynamicObject)stockDy);
                }
            }
            for (ExtendedDataEntity rowDataEntity : dataEntities) {
                boolean isValide = this.validateImp(rowDataEntity);
                if (!isValide) continue;
                this.valdateImportOther(rowDataEntity, stockNoDymMap);
            }
        }
    }

    private boolean validateImp(ExtendedDataEntity rowDataEntity) {
        Map<String, List<Integer>> indexList = this.getIndexList();
        DynamicObject stock = rowDataEntity.getDataEntity();
        String stockName = stock.getDataEntityType().getName();
        DynamicObject transactionType = stock.getDynamicObject("transactiontypeid");
        String bizBomType = "";
        boolean checkMain = false;
        if (transactionType != null) {
            if ("mpdm_transactout".equals(transactionType.getDataEntityType().getName())) {
                bizBomType = transactionType.getString("feedtype");
                checkMain = !"E".equals(bizBomType);
            } else if ("mpdm_transactproduct".equals(transactionType.getDataEntityType().getName())) {
                bizBomType = transactionType.getString("stockmaterials");
                boolean bl = checkMain = !"B".equals(bizBomType);
            }
            if (TransactionTypeQueryHelper.isReworkTransType((DynamicObject)transactionType)) {
                checkMain = false;
            }
        }
        if (checkMain) {
            indexList.put(EQUALSMAINLIST, this.getEqualsMainList(stockName, stock));
        }
        DynamicObjectCollection listdym = stock.getDynamicObjectCollection("stockentry");
        int rowcount = listdym.size();
        for (int index = 0; index < rowcount; ++index) {
            String wastagerate;
            DynamicObject stockdym = (DynamicObject)listdym.get(index);
            if (!stockdym.getBoolean("islead")) continue;
            boolean s = transactionType.getBoolean("isconsiderloss");
            if (s && !"A".equals(wastagerate = (String)stockdym.get("wastagerateformula")) && !"B".equals(wastagerate)) {
                this.mapListAdd(WASTAGERATELIST, indexList, index);
            }
            this.valdateA(stockdym, indexList, index);
            this.valdateB(stockdym, indexList, index, stockName);
            this.valdateC(stockdym, indexList, index);
        }
        StringBuilder err = new StringBuilder();
        this.errAdd(indexList, err);
        if (!"".equals(err.toString())) {
            this.addErrorMessage(rowDataEntity, err.toString());
            return false;
        }
        return true;
    }

    private void valdateImportOther(ExtendedDataEntity rowDataEntity, Map<String, DynamicObject> stockNoDymMap) {
        DynamicObject xstock = rowDataEntity.getDataEntity();
        DynamicObjectCollection listdym = xstock.getDynamicObjectCollection("stockentry");
        int rowcount = listdym.size();
        for (int index = 0; index < rowcount; ++index) {
            Object objDy2;
            Object objDy1;
            DynamicObject xstockdym = (DynamicObject)listdym.get(index);
            if (!xstockdym.getBoolean("islead")) continue;
            String stockNo = xstockdym.getString("stockno");
            DynamicObject stock = this.getStock(stockNoDymMap, stockNo);
            if (stock == null) {
                this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\uff08%1$s\uff09\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"StockChangeSaveImpValidator_09", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), stockNo));
                return;
            }
            if (!stock.getDynamicObject("transactiontypeid").getPkValue().equals(xstock.getDynamicObject("transactiontypeid").getPkValue())) {
                this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u6570\u636e\uff1a\u53d8\u66f4\u5355\u7684\u4e8b\u52a1\u7c7b\u578b\u5fc5\u987b\u4e0e\u7ec4\u4ef6\u6e05\u5355\u7684\u4e8b\u52a1\u7c7b\u578b\u4e00\u81f4\u3002", (String)"StockChangeSaveImpValidator_11", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), index + 1));
                return;
            }
            if (!"B".equals(xstockdym.getString("entrychangetype"))) continue;
            String stockSeq = xstockdym.getString("stockentryseq");
            DynamicObject entry = this.getStockEntry(stock, stockSeq);
            if (entry == null) {
                this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\uff08%1$s\uff09\u4e2d\u4e0d\u5b58\u5728\u5206\u5f55\u5e8f\u53f7\u4e3a\u201c%2$s\u201d\u7684\u6570\u636e\u3002", (String)"StockChangeSaveImpValidator_10", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), stockNo, stockSeq));
                return;
            }
            for (String entryField : ENTRY_FIELD_DYNAMICOBJECT_STR) {
                objDy1 = entry.getDynamicObject(entryField);
                if (CommonUtils.isEqualsDynamicObject((DynamicObject)objDy1, (DynamicObject)(objDy2 = xstockdym.getDynamicObject(entryField)))) continue;
                String fildName = FIELD_NAME_MAP.get(entryField);
                this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u6570\u636e\uff1a\u5f53\u53d8\u66f4\u65b9\u5f0f\u4e3a\u4fee\u6539\u65f6\uff0c\u53d8\u66f4\u5355\u7684\u201c%2$s\u201d\u5fc5\u987b\u4e0e\u7ec4\u4ef6\u6e05\u5355\u7684\u201c%3$s\u201d\u4e00\u81f4\u3002", (String)"StockChangeSaveImpValidator_12", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), index + 1, fildName, fildName));
                return;
            }
            for (String entryField : ENTRY_FIELD_STRING_STR) {
                objDy1 = entry.getString(entryField);
                if (CommonUtils.isEqualsString((String)objDy1, (String)(objDy2 = xstockdym.getString(entryField)))) continue;
                String fildName = FIELD_NAME_MAP.get(entryField);
                this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u6570\u636e\uff1a\u5f53\u53d8\u66f4\u65b9\u5f0f\u4e3a\u4fee\u6539\u65f6\uff0c\u53d8\u66f4\u5355\u7684\u201c%2$s\u201d\u5fc5\u987b\u4e0e\u7ec4\u4ef6\u6e05\u5355\u7684\u201c%3$s\u201d\u4e00\u81f4\u3002", (String)"StockChangeSaveImpValidator_12", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), index + 1, fildName, fildName));
                return;
            }
            for (String entryField : ENTRY_FIELD_BOOLEAN_STR) {
                boolean objDy22;
                boolean objDy12 = entry.getBoolean(entryField);
                if (CommonUtils.isEqualsBoolean((boolean)objDy12, (boolean)(objDy22 = xstockdym.getBoolean(entryField)))) continue;
                String fildName = FIELD_NAME_MAP.get(entryField);
                this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u6570\u636e\uff1a\u5f53\u53d8\u66f4\u65b9\u5f0f\u4e3a\u4fee\u6539\u65f6\uff0c\u53d8\u66f4\u5355\u7684\u201c%2$s\u201d\u5fc5\u987b\u4e0e\u7ec4\u4ef6\u6e05\u5355\u7684\u201c%3$s\u201d\u4e00\u81f4\u3002", (String)"StockChangeSaveImpValidator_12", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), index + 1, fildName, fildName));
                return;
            }
        }
    }

    private DynamicObject getStock(Map<String, DynamicObject> stockMap, String stockNo) {
        return stockMap.get(stockNo);
    }

    private DynamicObject getStockEntry(DynamicObject stock, String seq) {
        DynamicObjectCollection entryCol = stock.getDynamicObjectCollection("stockentry");
        if (entryCol == null) {
            return null;
        }
        for (DynamicObject stockBillEntry : entryCol) {
            if (!StringUtils.equals((CharSequence)stockBillEntry.getString("seq"), (CharSequence)seq)) continue;
            return stockBillEntry;
        }
        return null;
    }

    private void valdateC(DynamicObject stockdym, Map<String, List<Integer>> indexList, int index) {
        String issuemode = (String)stockdym.get("issuemode");
        String isbackflush = stockdym.getString("isbackflush");
        String overissuecontrl = stockdym.getString("overissuecontrl");
        Boolean iscannegative = stockdym.getBoolean("iscannegative");
        Boolean isbulkmaterial = stockdym.getBoolean("isbulkmaterial");
        if (!(!iscannegative.booleanValue() || "C".equals(issuemode) && "A".equals(isbackflush) && "A".equals(overissuecontrl))) {
            this.mapListAdd(ISCANNEGATIVELIST, indexList, index);
        }
        if (isbulkmaterial.booleanValue() && !"C".equals(issuemode)) {
            this.mapListAdd(ISBULKMATERIALLIST, indexList, index);
        }
        BigDecimal high = stockdym.getBigDecimal("issinhighlimit");
        BigDecimal low = stockdym.getBigDecimal("issinlowlimit");
        if ("A".equals(overissuecontrl) && (BigDecimal.ZERO.compareTo(high) != 0 || BigDecimal.ZERO.compareTo(low) != 0)) {
            this.mapListAdd(ISSINHIGHLIMITLIST, indexList, index);
        }
    }

    private void valdateB(DynamicObject stockdym, Map<String, List<Integer>> indexList, int index, String stockName) {
        String issuemode;
        DynamicObject supplyorg;
        Object outorg;
        Boolean isstockallot = (Boolean)stockdym.get("isstockallot");
        if (isstockallot.booleanValue() && StringUtils.equals((CharSequence)"om_mftstock", (CharSequence)stockName) && (outorg = stockdym.get("outorgunitid")) == null) {
            this.mapListAdd(OUTORGUNIT, indexList, index);
        }
        String supplyfield = (String)stockdym.get("supplymode");
        DynamicObject supply = (DynamicObject)stockdym.get("supplierid");
        if (supply == null && "bos_org".equals(supplyfield)) {
            this.mapListAdd(SUPPLIERLIST, indexList, index);
        }
        if ((supplyorg = (DynamicObject)stockdym.get("supplyorgid")) == null) {
            this.mapListAdd(SUPPLYORGLIST, indexList, index);
        }
        if (!("A".equals(issuemode = (String)stockdym.get("issuemode")) || "B".equals(issuemode) || "C".equals(issuemode))) {
            this.mapListAdd(ISSUEMODELIST, indexList, index);
        }
    }

    private void valdateA(DynamicObject stockdym, Map<String, List<Integer>> indexList, int index) {
        String overissuecontrl;
        String backflushtime;
        DynamicObject warehouse;
        String isbackflush = stockdym.getString("isbackflush");
        if (!("A".equals(isbackflush) || "B".equals(isbackflush) || "C".equals(isbackflush))) {
            this.mapListAdd(ISBACKFLUSHLIST, indexList, index);
        }
        if ((warehouse = stockdym.getDynamicObject("warehouseid")) == null && "B".equals(isbackflush)) {
            this.mapListAdd(WAREHOUSELIST, indexList, index);
        }
        if ("B".equals(isbackflush) && !"A".equals(backflushtime = stockdym.getString("backflushtime")) && !"B".equals(backflushtime)) {
            this.mapListAdd(BACKFLUSHTIMELIST, indexList, index);
        }
        if (!"A".equals(overissuecontrl = stockdym.getString("overissuecontrl")) && !"B".equals(overissuecontrl)) {
            this.mapListAdd(OVERISSUECONTRLLIST, indexList, index);
        }
        if (warehouse != null) {
            Boolean isopenlocation = warehouse.getBoolean("isopenlocation");
            if ("B".equals(isbackflush) && isopenlocation.booleanValue() && stockdym.get("location") == null) {
                this.mapListAdd(LOCATIONLIST, indexList, index);
            }
        }
    }

    private void errAdd(Map<String, List<Integer>> indexList, StringBuilder err) {
        if (!indexList.get(EQUALSMAINLIST).isEmpty()) {
            err.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u5bf9\u5e94\u7684\u7ec4\u4ef6\u7f16\u7801\u7b49\u4e8e\u4ea7\u54c1\u7f16\u7801\u3002", (String)"StockChangeSaveImpValidator_15", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), indexList.get(EQUALSMAINLIST).stream().map(String::valueOf).collect(Collectors.joining(","))));
        }
        if (!indexList.get(WAREHOUSELIST).isEmpty()) {
            err.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u201c\u5012\u51b2\u201d\u4e3a\u201c\u59cb\u7ec8\u5012\u51b2\u201d,\u201c\u4f9b\u8d27\u4ed3\u5e93\u201d\u5fc5\u586b\u3002", (String)"StockChangeSaveImpValidator_16", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), indexList.get(WAREHOUSELIST).stream().map(String::valueOf).collect(Collectors.joining(","))));
        }
        if (!indexList.get(LOCATIONLIST).isEmpty()) {
            err.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u201c\u5012\u51b2\u201d\u4e3a\u201c\u59cb\u7ec8\u5012\u51b2\u201d\u4e14\u4ed3\u5e93\u542f\u7528\u4ed3\u4f4d\u7ba1\u7406,\u201c\u4f9b\u8d27\u4ed3\u4f4d\u201d\u5fc5\u586b\u3002", (String)"StockChangeSaveImpValidator_17", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), indexList.get(LOCATIONLIST).stream().map(String::valueOf).collect(Collectors.joining(","))));
        }
        if (!indexList.get(BACKFLUSHTIMELIST).isEmpty()) {
            err.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u201c\u5012\u51b2\u201d\u4e3a\u201c\u59cb\u7ec8\u5012\u51b2\u201d,\u201c\u5012\u51b2\u65f6\u673a\u201d\u5fc5\u586b\u3002", (String)"StockChangeSaveImpValidator_18", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), indexList.get(BACKFLUSHTIMELIST).stream().map(String::valueOf).collect(Collectors.joining(","))));
        }
        if (!indexList.get(OVERISSUECONTRLLIST).isEmpty()) {
            err.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u201c\u8d85\u53d1\u63a7\u5236\u201d\u5fc5\u586b\u3002", (String)"StockChangeSaveImpValidator_19", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), indexList.get(OVERISSUECONTRLLIST).stream().map(String::valueOf).collect(Collectors.joining(","))));
        }
        if (!indexList.get(OUTORGUNIT).isEmpty()) {
            err.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u7269\u6599\u542f\u7528\u5907\u6599\u8c03\u62e8,\u8c03\u51fa\u7ec4\u7ec7\u5fc5\u586b\u3002", (String)"StockChangeSaveImpValidator_20", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), indexList.get(OUTORGUNIT).stream().map(String::valueOf).collect(Collectors.joining(","))));
        }
        if (!indexList.get(WASTAGERATELIST).isEmpty()) {
            err.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u201c\u635f\u8017\u8ba1\u7b97\u516c\u5f0f\u201d\u5fc5\u586b\u3002", (String)"StockChangeSaveImpValidator_21", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), indexList.get(WASTAGERATELIST).stream().map(String::valueOf).collect(Collectors.joining(","))));
        }
        if (!indexList.get(SUPPLIERLIST).isEmpty()) {
            err.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u8d27\u4e3b\u7c7b\u578b\u4e3a\u4e1a\u52a1\u5355\u5143\uff0c\u8d27\u4e3b\u5fc5\u586b\u3002", (String)"StockChangeSaveImpValidator_22", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), indexList.get(SUPPLIERLIST).stream().map(String::valueOf).collect(Collectors.joining(","))));
        }
        if (!indexList.get(SUPPLYORGLIST).isEmpty()) {
            err.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u4f9b\u8d27\u7ec4\u7ec7\u5fc5\u586b\u3002", (String)"StockChangeSaveImpValidator_23", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), indexList.get(SUPPLYORGLIST).stream().map(String::valueOf).collect(Collectors.joining(","))));
        }
        if (!indexList.get(ISBACKFLUSHLIST).isEmpty()) {
            err.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u201c\u5012\u51b2\u201d\u5fc5\u586b\u3002", (String)"StockChangeSaveImpValidator_24", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), indexList.get(ISBACKFLUSHLIST).stream().map(String::valueOf).collect(Collectors.joining(","))));
        }
        if (!indexList.get(ISSUEMODELIST).isEmpty()) {
            err.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u9886\u9001\u6599\u65b9\u5f0f\u5fc5\u586b\u3002", (String)"StockChangeSaveImpValidator_25", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), indexList.get(ISSUEMODELIST).stream().map(String::valueOf).collect(Collectors.joining(","))));
        }
        if (!indexList.get(ISCANNEGATIVELIST).isEmpty()) {
            err.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u201c\u9000\u6599\u201d\u4e3a\u662f\uff0c\u987b\u6ee1\u8db3\uff1a\u9886\u6599\u65b9\u5f0f\u4e3a\u201c\u4e0d\u9886\u6599\u201d\uff0c\u5012\u51b2\u672a\u201c\u4e0d\u5012\u51b2\u201d\uff0c\u8d85\u53d1\u63a7\u5236\u4e3a\u201c\u53ef\u8d85\u53d1\u201d\u3002", (String)"StockChangeSaveImpValidator_26", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), indexList.get(ISCANNEGATIVELIST).stream().map(String::valueOf).collect(Collectors.joining(","))));
        }
        if (!indexList.get(ISBULKMATERIALLIST).isEmpty()) {
            err.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u201c\u6563\u88c5\u7269\u6599\u201d\u4e3a\u662f\uff0c\u987b\u6ee1\u8db3\uff1a\u9886\u6599\u65b9\u5f0f\u4e3a\u201c\u4e0d\u9886\u6599\u201d\u3002", (String)"StockChangeSaveImpValidator_27", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), indexList.get(ISBULKMATERIALLIST).stream().map(String::valueOf).collect(Collectors.joining(","))));
        }
        if (!indexList.get(ISSINHIGHLIMITLIST).isEmpty()) {
            err.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u201c\u8d85\u53d1\u63a7\u5236\u201d\u4e3a\u53ef\u8d85\u53d1\uff0c\u987b\u6ee1\u8db3\uff1a\u9886\u6599\u4e0a\u9650\u5141\u5dee\u4e3a0\u3001\u9886\u6599\u4e0b\u9650\u5141\u5dee\u4e3a0\u3002", (String)"StockChangeSaveImpValidator_28", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), indexList.get(ISSINHIGHLIMITLIST).stream().map(String::valueOf).collect(Collectors.joining(","))));
        }
    }

    private void mapListAdd(String listName, Map<String, List<Integer>> indexList, int index) {
        List<Integer> list = indexList.get(listName);
        list.add(index + 1);
        indexList.put(listName, list);
    }

    private Map<String, List<Integer>> getIndexList() {
        HashMap<String, List<Integer>> indexList = new HashMap<String, List<Integer>>(16);
        indexList.put(WAREHOUSELIST, new ArrayList(10));
        indexList.put(LOCATIONLIST, new ArrayList(10));
        indexList.put(BACKFLUSHTIMELIST, new ArrayList(10));
        indexList.put(OVERISSUECONTRLLIST, new ArrayList(10));
        indexList.put(OUTORGUNIT, new ArrayList(10));
        indexList.put(WASTAGERATELIST, new ArrayList(10));
        indexList.put(SUPPLIERLIST, new ArrayList(10));
        indexList.put(SUPPLYORGLIST, new ArrayList(10));
        indexList.put(ISBACKFLUSHLIST, new ArrayList(10));
        indexList.put(ISSUEMODELIST, new ArrayList(10));
        indexList.put(EQUALSMAINLIST, new ArrayList(10));
        indexList.put(ISCANNEGATIVELIST, new ArrayList(10));
        indexList.put(ISBULKMATERIALLIST, new ArrayList(10));
        indexList.put(ISSINHIGHLIMITLIST, new ArrayList(10));
        return indexList;
    }

    private List<Integer> getEqualsMainList(String entityName, DynamicObject stock) {
        ArrayList<Integer> equalsMainList = new ArrayList<Integer>();
        DynamicObjectCollection entryEntity = stock.getDynamicObjectCollection("stockentry");
        if (!entityName.equals("om_xxcomponentlist")) {
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject entry = (DynamicObject)entryEntity.get(i);
                String changeType = entry.getString("entrychangetype");
                if (!"A".equals(changeType)) continue;
                String productId = "";
                DynamicObject productDym = entry.getDynamicObject("productno");
                if (productDym != null) {
                    productId = productDym.getPkValue().toString();
                }
                DynamicObject material = entry.getDynamicObject("materialid");
                String materialId = "";
                if (material != null) {
                    materialId = material.getPkValue().toString();
                }
                if (!productId.equals(materialId)) continue;
                equalsMainList.add(i + 1);
            }
        }
        return equalsMainList;
    }

    static {
        FIELD_NAME_MAP.put("materialid", ResManager.loadKDString((String)"\u7ec4\u4ef6\u7f16\u7801", (String)"StockChangeSaveImpValidator_01", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
        FIELD_NAME_MAP.put("bomreversion", ResManager.loadKDString((String)"BOM\u7248\u672c", (String)"StockChangeSaveImpValidator_02", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
        FIELD_NAME_MAP.put("entryconfiguredcode", ResManager.loadKDString((String)"\u7ec4\u4ef6\u914d\u7f6e\u53f7", (String)"StockChangeSaveImpValidator_03", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
        FIELD_NAME_MAP.put("materialunitid", ResManager.loadKDString((String)"\u57fa\u672c\u5355\u4f4d", (String)"StockChangeSaveImpValidator_04", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
        FIELD_NAME_MAP.put("workprocedureid", ResManager.loadKDString((String)"\u5de5\u5e8f\u7f16\u7801", (String)"StockChangeSaveImpValidator_05", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
        FIELD_NAME_MAP.put("batchno", ResManager.loadKDString((String)"\u6279\u53f7", (String)"StockChangeSaveImpValidator_06", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
        FIELD_NAME_MAP.put("qtytype", ResManager.loadKDString((String)"\u7528\u91cf\u7c7b\u578b", (String)"StockChangeSaveImpValidator_07", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
        FIELD_NAME_MAP.put("iscannegative", ResManager.loadKDString((String)"\u9000\u6599", (String)"StockChangeSaveImpValidator_08", (String)"mmc-pom-opplugin", (Object[])new Object[0]));
    }
}

