/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.stockchange.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import kd.bd.mpdm.common.mftorder.enums.ManuBillBizStatusEnum;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bd.mpdm.common.stockchange.utils.StockChangeUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.validate.AbstractValidator;

public class StockChangeSubmitValidator
extends AbstractValidator {
    public void validate() {
        ArrayList<Integer> unauditList = new ArrayList<Integer>();
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        ArrayList<Integer> qtyList = new ArrayList<Integer>();
        ArrayList<Integer> ischangedList = new ArrayList<Integer>();
        ArrayList<String> ischangedBillNoList = new ArrayList<String>();
        ArrayList<String> ischangedMnoList = new ArrayList<String>();
        ArrayList<Integer> stockIdList = new ArrayList<Integer>();
        DynamicObject[] stockChangeBills = new DynamicObject[this.dataEntities.length];
        for (int i = 0; i < this.dataEntities.length; ++i) {
            stockChangeBills[i] = this.dataEntities[i].getDataEntity();
        }
        String stockChangeName = stockChangeBills[0].getDataEntityType().getName();
        Map stockNoDymMap = StockChangeUtils.getStockNoDymMap((DynamicObject[])stockChangeBills, (String)stockChangeName);
        Map stockNoChangeMap = StockChangeUtils.getStockNoChangeBillnoMap((DynamicObject[])stockChangeBills, (String)stockChangeName);
        Map stockChangeMap = StockChangeUtils.getStockChangeMap((DynamicObject[])stockChangeBills, (String)stockChangeName);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            unauditList.clear();
            statusList.clear();
            qtyList.clear();
            ischangedList.clear();
            ischangedBillNoList.clear();
            ischangedMnoList.clear();
            stockIdList.clear();
            DynamicObject manuChangeBill = this.dataEntities[i].getDataEntity();
            DynamicObjectCollection entryCol = manuChangeBill.getDynamicObjectCollection("stockentry");
            for (int j = 0; j < entryCol.size(); ++j) {
                String bizstatus;
                DynamicObject orderEntry;
                DynamicObject stockChangeEntry = (DynamicObject)entryCol.get(j);
                String stockid = stockChangeEntry.getString("stockid");
                if (StringUtils.isEmpty((CharSequence)stockid)) {
                    stockIdList.add(j + 1);
                    continue;
                }
                String stockEntryid = stockChangeEntry.get("stockentryid") == null ? null : stockChangeEntry.getString("stockentryid");
                BigDecimal newdemandqty = stockChangeEntry.getBigDecimal("demandqty");
                DynamicObject stock = (DynamicObject)stockNoDymMap.get(stockChangeEntry.getString("stockno"));
                if (stock == null || !StringUtils.equals((CharSequence)stock.getString("billstatus"), (CharSequence)"C")) {
                    unauditList.add(j + 1);
                }
                DynamicObject load = (DynamicObject)stockChangeMap.get(manuChangeBill.getPkValue().toString());
                String unAuditXChangeBillno = StockChangeUtils.changeExistUnAuditChangeBillno((DynamicObject)stockChangeEntry, (Map)stockNoChangeMap);
                if ((load == null || "0".equals(manuChangeBill.getPkValue().toString())) && !kd.bos.util.StringUtils.isEmpty((String)unAuditXChangeBillno)) {
                    ischangedList.add(j + 1);
                    ischangedBillNoList.add(unAuditXChangeBillno);
                    DynamicObject material = stockChangeEntry.getDynamicObject("materielmasterid");
                    String materialNumber = material == null ? "" : material.getString("number");
                    ischangedMnoList.add(materialNumber);
                }
                if (stock != null && this.checkqty(stock, stockEntryid, newdemandqty).booleanValue()) {
                    qtyList.add(j + 1);
                }
                if (stock == null || (orderEntry = stock.getDynamicObject("orderentryid")) == null || StringUtils.equals((CharSequence)(bizstatus = orderEntry.getString("bizstatus")), (CharSequence)ManuBillBizStatusEnum.NORMAL.getValue())) continue;
                statusList.add(j + 1);
            }
            if (!stockIdList.isEmpty()) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u7684\u7ec4\u4ef6\u6e05\u5355\u7f16\u53f7\u4e0d\u5b58\u5728\u3002", (String)"StockChangeSubmitValidator_6", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), ((Object)stockIdList).toString()));
            }
            if (!unauditList.isEmpty()) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5bf9\u5e94\u7684\u7ec4\u4ef6\u6e05\u5355\u672a\u5ba1\u6838\u3002", (String)"StockChangeSubmitValidator_7", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), ((Object)unauditList).toString()));
            }
            String name = manuChangeBill.getDynamicObjectType().getName();
            Map pmAppParameterMap = MPDMMftGenStocksUtils.getPmAppParameterMap((Long)((Long)manuChangeBill.getDynamicObject("org").getPkValue()), (String)name);
            Boolean isMftStockCtrlBusExe = (Boolean)pmAppParameterMap.get("ismftstockctrlbusexe");
            if (isMftStockCtrlBusExe == null) {
                isMftStockCtrlBusExe = Boolean.TRUE;
            }
            if (isMftStockCtrlBusExe.booleanValue() && !ischangedList.isEmpty()) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5bf9\u5e94\u7684\u7ec4\u4ef6\u6e05\u5355\u5206\u5f55\u7269\u6599%2$s\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7ec4\u4ef6\u6e05\u5355\u53d8\u66f4\u5355%3$s\u3002", (String)"StockChangeSubmitValidator_8", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), ((Object)ischangedList).toString(), ((Object)ischangedMnoList).toString(), ((Object)ischangedBillNoList).toString()));
            }
            if (!statusList.isEmpty()) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u5206\u5f55\u5bf9\u5e94\u7684\u5de5\u5355\u884c\uff0c\u884c\u72b6\u6001\u987b\u6ee1\u8db3\uff1a\u8ba1\u5212\u72b6\u6001\u4e3a\u201c\u4e0b\u8fbe\u201d\uff0c\u4e1a\u52a1\u72b6\u6001\u4e3a\u201c\u6b63\u5e38\u201d\u3002", (String)"StockChangeSubmitValidator_11", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), ((Object)statusList).toString()));
            }
            if (qtyList.isEmpty()) continue;
            this.addWarningMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5bf9\u5e94\u7684\u9700\u6c42\u6570\u91cf\u5c0f\u4e8e\u5df2\u9886\u6570\u91cf\u3002", (String)"StockChangeSubmitValidator_10", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), ((Object)qtyList).toString()));
        }
    }

    private Boolean checkqty(DynamicObject stock, String stockEntryid, BigDecimal newdemandqty) {
        DynamicObjectCollection entryCol = stock.getDynamicObjectCollection("stockentry");
        for (int i = 0; i < entryCol.size(); ++i) {
            DynamicObject stockBillEntry = (DynamicObject)entryCol.get(i);
            if (!StringUtils.equals((CharSequence)stockBillEntry.getPkValue().toString(), (CharSequence)stockEntryid)) continue;
            BigDecimal actissueqty = stockBillEntry.getBigDecimal("actissueqty");
            BigDecimal rejectedqty = stockBillEntry.getBigDecimal("rejectedqty");
            BigDecimal feedingqty = stockBillEntry.getBigDecimal("feedingqty");
            BigDecimal canqty = actissueqty.subtract(rejectedqty).add(feedingqty);
            if (newdemandqty.compareTo(canqty) >= 0) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

