/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.stockchange.validator;

import java.util.HashMap;
import java.util.HashSet;
import kd.bd.mpdm.common.stockchange.utils.StockChangeUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class StockUnAuditTplOpValidator
extends AbstractValidator {
    public void validate() {
        String stockName = this.getEntityKey();
        HashSet<String> stockNoSet = new HashSet<String>(16);
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            String billNo = extendedDataEntity.getBillNo();
            stockNoSet.add(billNo);
        }
        String stockChangeName = StockChangeUtils.getEntityName((int)1, (int)3, (String)stockName);
        DynamicObject[] stockChangeDyms = BusinessDataServiceHelper.load((String)stockChangeName, (String)"stockentry.stockno,billno", (QFilter[])new QFilter[]{new QFilter("stockentry.stockno", "in", stockNoSet)});
        HashMap<String, String> stockNoDymMap = new HashMap<String, String>(16);
        for (DynamicObject dynamicObject : stockChangeDyms) {
            DynamicObjectCollection entryCol = dynamicObject.getDynamicObjectCollection("stockentry");
            for (DynamicObject entry : entryCol) {
                stockNoDymMap.put(entry.getString("stockno"), dynamicObject.getString("billno"));
            }
        }
        for (DynamicObject dynamicObject : this.dataEntities) {
            String billNo = dynamicObject.getBillNo();
            if (stockNoDymMap.get(billNo) == null) continue;
            this.addErrorMessage((ExtendedDataEntity)dynamicObject, ResManager.loadKDString((String)"\u5b58\u5728\u7ec4\u4ef6\u6e05\u5355\u53d8\u66f4\u5355\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"StockUnAuditTplOpValidator_0", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
        }
    }
}

