/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.workcardinfo;

import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class CardRiskDefValidator
extends AbstractValidator {
    private static final String MPDM_RISKREF = "mpdm_cardriskdef";
    private static final String CARD_NUMBER = "card";

    public void validate() {
        String operate = this.getOperateKey();
        HashSet<String> set = new HashSet<String>(16);
        for (ExtendedDataEntity extend : this.dataEntities) {
            DynamicObject dynamicObject;
            long workcardid;
            Map loadFromCache;
            DynamicObject dataEntity = extend.getDataEntity();
            DynamicObject workcard = dataEntity.getDynamicObject(CARD_NUMBER);
            if (workcard == null) continue;
            DynamicObject createorg = dataEntity.getDynamicObject("createorg");
            if (("submit".equals(operate) || "save".equals(operate)) && (loadFromCache = BusinessDataServiceHelper.loadFromCache((Object[])new Object[]{workcardid = ((Long)workcard.getPkValue()).longValue()}, (String)"mpdm_mrocardroute")) != null && loadFromCache.size() > 0 && !(dynamicObject = (DynamicObject)loadFromCache.get(workcardid)).getBoolean("riskcard")) {
                this.addErrorMessage(extend, String.format(ResManager.loadKDString((String)"\u5de5\u5361%1$s\uff1a\u6ca1\u6709\u542f\u7528\u98ce\u9669\u5361\uff0c\u8bf7\u4f7f\u7528\u6b63\u786e\u7684\u5de5\u5361\u6570\u636e\u3002", (String)"CardRiskDefValidator_1", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), workcard.getString("number")));
                continue;
            }
            if (!"submit".equals(operate) && !"audit".equals(operate) && !"enable".equals(operate)) continue;
            workcardid = (Long)workcard.getPkValue();
            long createOrgId = createorg.getLong("id");
            String enable = dataEntity.getString("enable");
            String uniqueFlag = workcardid + "-" + createOrgId + "-" + enable;
            if (set.contains(uniqueFlag) && !"submit".equals(operate)) {
                this.addErrorMessage(extend, String.format(ResManager.loadKDString((String)"\u5de5\u5361%1$s\uff1a\u5df2\u5b58\u5728\u5ba1\u6838\u4e14\u53ef\u7528\u7684\u5de5\u5361\uff0c\u8bf7\u5148\u7981\u7528\u6216\u5220\u9664\u91cd\u590d\u5de5\u5361\u6570\u636e\u3002", (String)"CardRiskDefValidator_3", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), workcard.getString("number")));
                continue;
            }
            set.add(uniqueFlag);
            boolean unique = this.checkUnique(dataEntity.getLong("id"), workcardid, createOrgId, "1");
            if (!unique) continue;
            this.addErrorMessage(extend, String.format(ResManager.loadKDString((String)"\u5de5\u5361%1$s\uff1a\u5df2\u5b58\u5728\u5ba1\u6838\u4e14\u53ef\u7528\u7684\u5de5\u5361\uff0c\u8bf7\u5148\u7981\u7528\u6216\u5220\u9664\u91cd\u590d\u5de5\u5361\u6570\u636e\u3002", (String)"CardRiskDefValidator_3", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), workcard.getString("number")));
        }
    }

    public boolean checkUnique(long dataPK, long cardnoPK, long createOrgPK, String enable) {
        QFilter[] qFilters;
        QFilter orgQfiter = BaseDataServiceHelper.getBaseDataFilter((String)MPDM_RISKREF, (Long)createOrgPK);
        QFilter cardNoQfiter = new QFilter(CARD_NUMBER, "=", (Object)cardnoPK);
        QFilter enableQfiter = new QFilter("enable", "in", (Object)enable);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        if (dataPK > 0L) {
            QFilter pkQFilter = new QFilter("id", "not in", (Object)dataPK);
            qFilters = new QFilter[]{pkQFilter, cardNoQfiter, enableQfiter, orgQfiter, statusFilter};
        } else {
            qFilters = new QFilter[]{cardNoQfiter, enableQfiter, orgQfiter, statusFilter};
        }
        boolean isExists = QueryServiceHelper.exists((String)MPDM_RISKREF, (QFilter[])qFilters);
        return isExists;
    }
}

