/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.workcardinfo;

import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class CardToolDemandUniqueValidator
extends AbstractValidator {
    private static final String FORM_MPDM_CARDTOOLDEMAND = "mpdm_cardtooldemand";
    private static final String CARD_NO = "workcard";
    private static final String ENTRY_OWNTYPE = "entryownertype";
    private static final String ENTRY_OWNER = "entryowner";

    public void validate() {
        ExtendedDataEntity[] dataEntityArray = this.getDataEntities();
        String operate = this.getOperateKey();
        HashMap<String, DynamicObject> uniqueMap = new HashMap<String, DynamicObject>(2);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject dataEntity = this.dataEntities[i].getDataEntity();
            DynamicObject createOrg = dataEntity.getDynamicObject("createorg");
            DynamicObject workcard = dataEntity.getDynamicObject(CARD_NO);
            if (createOrg == null) {
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"CardToolDemandUniqueValidator_0", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                return;
            }
            if (workcard == null) {
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5de5\u5361\u53f7\u3002", (String)"CardToolDemandUniqueValidator_1", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                return;
            }
            StringBuilder uniqueKey = new StringBuilder();
            long cardnoPK = workcard.getLong("id");
            long createOrgPK = createOrg.getLong("id");
            String enable = dataEntity.getString("enable");
            uniqueKey.append(cardnoPK);
            uniqueKey.append(createOrgPK);
            uniqueKey.append(enable);
            String cardNoNumber = workcard.getString("number");
            if (uniqueMap.containsKey(uniqueKey.toString())) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5361%1$s\uff1a\u5df2\u5b58\u5728\u5ba1\u6838\u4e14\u53ef\u7528\u7684\u5de5\u5177\u9700\u6c42\u4fe1\u606f\uff0c\u8bf7\u5148\u7981\u7528\u91cd\u590d\u5de5\u5361\u53f7\u6570\u636e\u3002", (String)"CardToolDemandUniqueValidator_4", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), cardNoNumber));
                continue;
            }
            uniqueMap.put(uniqueKey.toString(), dataEntity);
            long dataPK = dataEntity.getLong("id");
            boolean unique = this.checkUnique(dataPK, cardnoPK, createOrgPK, "1");
            if (!unique) continue;
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5361%1$s\uff1a\u5df2\u5b58\u5728\u5ba1\u6838\u4e14\u53ef\u7528\u7684\u5de5\u5177\u9700\u6c42\u4fe1\u606f\uff0c\u8bf7\u5148\u7981\u7528\u91cd\u590d\u5de5\u5361\u53f7\u6570\u636e\u3002", (String)"CardToolDemandUniqueValidator_4", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), cardNoNumber));
        }
    }

    public boolean checkUnique(long dataPK, long cardnoPK, long createOrgPK, String enable) {
        QFilter[] qFilters;
        QFilter orgQfiter = BaseDataServiceHelper.getBaseDataFilter((String)FORM_MPDM_CARDTOOLDEMAND, (Long)createOrgPK);
        QFilter cardNoQfiter = new QFilter(CARD_NO, "in", (Object)cardnoPK);
        QFilter enableQfiter = new QFilter("enable", "in", (Object)enable);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        if (dataPK > 0L) {
            QFilter pkQFilter = new QFilter("id", "not in", (Object)dataPK);
            qFilters = new QFilter[]{pkQFilter, cardNoQfiter, enableQfiter, orgQfiter, statusFilter};
        } else {
            qFilters = new QFilter[]{cardNoQfiter, enableQfiter, orgQfiter, statusFilter};
        }
        boolean isExists = QueryServiceHelper.exists((String)FORM_MPDM_CARDTOOLDEMAND, (QFilter[])qFilters);
        return isExists;
    }
}

