/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.workcardinfo;

import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class CardToolDemandValidator
extends AbstractValidator {
    private static final String FORM_MPDM_CARDTOOLDEMAND = "mpdm_cardtooldemand";
    private static final String CARD_NO = "workcard";
    private static final String ENTRY_OWNTYPE = "entryownertype";
    private static final String ENTRY_OWNER = "entryowner";

    public void validate() {
        ExtendedDataEntity[] dataEntityArray = this.getDataEntities();
        String operate = this.getOperateKey();
        if ("save".equals(operate)) {
            return;
        }
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject dataEntity = this.dataEntities[i].getDataEntity();
            DynamicObject workcard = dataEntity.getDynamicObject(CARD_NO);
            if (workcard == null) {
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5de5\u5361\u53f7\u3002", (String)"CardToolDemandValidator_1", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                return;
            }
            String cardNoNumber = workcard.getString("number");
            DynamicObjectCollection entryDOC = dataEntity.getDynamicObjectCollection("entryentity");
            this.checkEntry(this.dataEntities[i], entryDOC, cardNoNumber);
        }
    }

    public void checkEntry(ExtendedDataEntity dataEntity, DynamicObjectCollection entryDOC, String cardNoNumber) {
        if (entryDOC == null) {
            return;
        }
        HashMap<String, Integer> materailRepalceSet = new HashMap<String, Integer>(4);
        for (int i = 0; i < entryDOC.size(); ++i) {
            DynamicObject entryDO = (DynamicObject)entryDOC.get(i);
            int seq = entryDO.getInt("seq");
            DynamicObject entryMaterialDO = entryDO.getDynamicObject("entrymaterial");
            if (entryMaterialDO == null) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5de5\u5361%1$s\uff1a\u5de5\u5177\u6e05\u5355\u7b2c%2$s\u884c\u201c\u5de5\u5177\u4ef6\u53f7\u201d\u5fc5\u586b\u3002", (String)"CardToolDemandValidator_4", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), cardNoNumber, seq));
                continue;
            }
            long entryMaterialPK = entryMaterialDO.getLong("id");
            DynamicObject toolsubgroup = entryDO.getDynamicObject("toolsubgroup");
            DynamicObject owner = entryDO.getDynamicObject(ENTRY_OWNER);
            String ownerType = entryDO.getString(ENTRY_OWNTYPE);
            String entryReplaceGroup = toolsubgroup == null ? "" : toolsubgroup.getString("id");
            String entryownerStr = owner == null ? "" : owner.getString("id");
            String materailRepalceStr = entryMaterialPK + "-" + entryReplaceGroup + "-" + entryownerStr + "-" + ownerType;
            if (materailRepalceSet.containsKey(materailRepalceStr)) {
                int preSeq = (Integer)materailRepalceSet.get(materailRepalceStr);
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5de5\u5361%1$s\uff1a\u7b2c%2$s\u884c\u4e0e\u7b2c%3$s\u884c\u201c\u5de5\u5177\u4ef6\u53f7\u201d\u3001\u201c\u4f9b\u5e94\u65b9\u201d\u3001\u201c\u66ff\u4ee3\u7ec4\u201d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CardToolDemandValidator_11", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), cardNoNumber, seq, preSeq));
                continue;
            }
            materailRepalceSet.put(materailRepalceStr, seq);
        }
    }
}

