/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.workcardinfo;

import java.util.HashMap;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class CardWorkDetailValidator
extends AbstractValidator {
    private static final String SAVE = "save";
    private static final String ENABLE = "enable";
    private static final String SUBMIT = "submit";
    private static final String AUDIT = "audit";

    public void validate() {
        String operate;
        switch (operate = this.getOperateKey()) {
            case "save": {
                this.unqueVerification(operate);
                break;
            }
            case "enable": {
                this.unqueVerification(operate);
                break;
            }
            case "submit": {
                this.unqueVerification(operate);
                break;
            }
            case "audit": {
                this.unqueVerification(operate);
            }
        }
    }

    public void unqueVerification(String operate) {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null) {
            return;
        }
        HashMap<String, DynamicObject> uniqueMap = new HashMap<String, DynamicObject>(2);
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObjectCollection entryDOC;
            boolean unique;
            DynamicObject createorg;
            DynamicObject dataEntity = dataEntities[i].getDataEntity();
            DynamicObject cardno = dataEntity.getDynamicObject("cardno");
            Long cardnoPK = 0L;
            Long createOrgPK = 0L;
            StringBuilder uniqueKey = new StringBuilder();
            if (cardno != null && cardno.getPkValue() instanceof Long) {
                cardnoPK = (Long)cardno.getPkValue();
                uniqueKey.append(cardnoPK);
            }
            if ((createorg = dataEntity.getDynamicObject("createorg")) != null && createorg.getPkValue() instanceof Long) {
                createOrgPK = (Long)createorg.getPkValue();
                uniqueKey.append(createOrgPK);
            }
            String cardNoNumber = "";
            if (cardno != null && cardno.get("number") instanceof String) {
                cardNoNumber = String.valueOf(cardno.get("number"));
            }
            String enable = dataEntity.getString(ENABLE);
            uniqueKey.append(enable);
            if (uniqueMap.containsKey(uniqueKey.toString())) {
                this.addErrorMessage(dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5361%1$s\uff1a\u5df2\u5b58\u5728\u5ba1\u6838\u4e14\u53ef\u7528\u7684\u5de5\u4f5c\u6e05\u5355\uff0c\u8bf7\u5148\u7981\u7528\u6216\u5220\u9664\u91cd\u590d\u5de5\u53f7\u5361\u6570\u636e\u3002", (String)"CardWorkDetailValidator_5", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), cardNoNumber));
                continue;
            }
            uniqueMap.put(uniqueKey.toString(), dataEntity);
            Object pkValue = dataEntity.getPkValue();
            Long dataPK = 0L;
            if (pkValue instanceof Long) {
                dataPK = (Long)pkValue;
            }
            if (unique = this.checkUnique(dataPK, cardnoPK, createOrgPK, "1")) {
                this.addErrorMessage(dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5361%1$s\uff1a\u5df2\u5b58\u5728\u5ba1\u6838\u4e14\u53ef\u7528\u7684\u5de5\u4f5c\u6e05\u5355\uff0c\u8bf7\u5148\u7981\u7528\u6216\u5220\u9664\u91cd\u590d\u5de5\u53f7\u5361\u6570\u636e\u3002", (String)"CardWorkDetailValidator_5", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), cardNoNumber));
                continue;
            }
            if (ENABLE.equals(operate) || (entryDOC = dataEntity.getDynamicObjectCollection("entryentity")) == null) continue;
            HashMap<String, Integer> entryDOMap = new HashMap<String, Integer>(4);
            boolean isSort = true;
            for (DynamicObject entryDO : entryDOC) {
                String processno = entryDO.getString("processno");
                int seq = entryDO.getInt("seq");
                if (StringUtils.isEmpty((CharSequence)processno)) {
                    isSort = false;
                } else {
                    String optionFormat = "^[1-9][0-9]{0,3}$";
                    boolean noFormat = Pattern.matches(optionFormat, processno);
                    if (!noFormat) {
                        this.addErrorMessage(dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u53f7%1$s\u4e0d\u5408\u6cd5\uff0c\u8bf7\u8f93\u51654\u4f4d\u62164\u4f4d\u4ee5\u5185\u7684\u6b63\u6574\u6570\u3002", (String)"CardWorkDetailValidator_6", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), processno));
                        continue;
                    }
                    if (entryDOMap.containsKey(processno)) {
                        this.addErrorMessage(dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5361%1$s\uff1a\u5de5\u5e8f\u53f7%2$s\u91cd\u590d\u3002", (String)"CardWorkDetailValidator_1", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), cardNoNumber, processno));
                    } else {
                        entryDOMap.put(processno, seq);
                    }
                }
                boolean checkOpDesc = this.checkOpDesc(entryDO, i, cardNoNumber);
                if (checkOpDesc) continue;
            }
        }
    }

    public boolean checkOpDesc(DynamicObject entryDO, int index, String cardNoNumber) {
        boolean check;
        boolean result = true;
        if (entryDO == null) {
            return result;
        }
        String operationdesc = entryDO.getString("operationdesc");
        String processNo = entryDO.getString("processno");
        DynamicObject operationUnit = entryDO.getDynamicObject("operationunit");
        Object operationQty = entryDO.get("operationqty");
        Object headQty = entryDO.get("headqty");
        Object oprctrlStrategy = entryDO.get("oprctrlstrategy");
        boolean bl = check = StringUtils.isEmpty((CharSequence)processNo) || operationUnit == null || operationQty == null || headQty == null || oprctrlStrategy == null;
        if (StringUtils.isNotEmpty((CharSequence)operationdesc) && check) {
            result = false;
            this.addErrorMessage(this.dataEntities[index], String.format(ResManager.loadKDString((String)"\u5de5\u5361%1$s\uff1a\u7b2c%2$s\u884c\u5206\u5f55\u5b58\u5728\u5de5\u5e8f\u8bf4\u660e\uff0c\u201c\u5de5\u5e8f\u53f7\u201d\u3001\u201c\u5de5\u5e8f\u5355\u4f4d\u201d\u3001\u201c\u5de5\u5e8f\u6570\u91cf\u201d\u3001\u201c\u8868\u5934\u6570\u91cf\u201d\u3001\u201c\u5de5\u5e8f\u63a7\u5236\u7b56\u7565\u201d\u5fc5\u5f55\u3002", (String)"CardWorkDetailValidator_4", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), cardNoNumber, index + 1));
        }
        return result;
    }

    public boolean checkUnique(Long dataPK, Long cardnoPK, Long createOrgPK, String enable) {
        QFilter[] qFilters;
        QFilter orgQfiter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_cardworkdetail", (Long)createOrgPK);
        QFilter cardNoQfiter = new QFilter("cardno", "in", (Object)cardnoPK);
        QFilter enableQfiter = new QFilter(ENABLE, "in", (Object)enable);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        if (dataPK > 0L) {
            QFilter pkQFilter = new QFilter("id", "not in", (Object)dataPK);
            qFilters = new QFilter[]{pkQFilter, cardNoQfiter, enableQfiter, orgQfiter, statusFilter};
        } else {
            qFilters = new QFilter[]{cardNoQfiter, enableQfiter, orgQfiter, statusFilter};
        }
        boolean isExists = QueryServiceHelper.exists((String)"mpdm_cardworkdetail", (QFilter[])qFilters);
        return isExists;
    }
}

