/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.workcardinfo;

import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class MPDMVersionSerialVal
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObject dataEntity = dataEntities[0].getDataEntity();
            if (dataEntity == null) continue;
            DynamicObjectCollection serialentry = dataEntity.getDynamicObjectCollection("serialentry");
            this.checkEntryReset(dataEntities[0], serialentry);
        }
    }

    private void checkEntryReset(ExtendedDataEntity dataEntity, DynamicObjectCollection serialentry) {
        if (serialentry == null) {
            return;
        }
        HashMap<String, Integer> serialMap = new HashMap<String, Integer>(4);
        for (DynamicObject serialDO : serialentry) {
            if (serialDO == null) {
                return;
            }
            int seq = serialDO.getInt("seq");
            String serialumber = serialDO.getString("serialumber");
            if (serialMap.containsKey(serialumber)) {
                int preSeq = (Integer)serialMap.get(serialumber);
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u4e0e\u7b2c%2$s\u884c\u5e8f\u5217\u53f7\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"MPDMVersionSerialVal_0", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), preSeq, seq));
                continue;
            }
            serialMap.put(serialumber, seq);
        }
    }
}

