/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.workcardinfo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.business.workcardinfo.CardBusinessUtils;
import kd.bd.mpdm.opplugin.workcardinfo.MROCardRouteConstsUtils;
import kd.bd.mpdm.opplugin.workcardinfo.validator.MROCardRouteUpdateValidator;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.sequence.SequenceReader;
import kd.bos.param.ParameterReader;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class MROCardRouteUpdateOp
extends AbstractOperationServicePlugIn {
    public boolean statusCheck(String operateKey) {
        return operateKey.equalsIgnoreCase("save") || operateKey.equalsIgnoreCase("unsubmit") || operateKey.equalsIgnoreCase("submit") || operateKey.equalsIgnoreCase("delete") || operateKey.equalsIgnoreCase("audit") || operateKey.equalsIgnoreCase("unaudit") || operateKey.equalsIgnoreCase("enable") || operateKey.equalsIgnoreCase("disable");
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("cardno");
        e.getFieldKeys().add("number");
        e.getFieldKeys().add("pageentity");
        e.getFieldKeys().add("pageentity.pageseq");
        e.getFieldKeys().add("pageentity.pagesumhours");
        e.getFieldKeys().add("pageentity.salehours");
        e.getFieldKeys().add("pageentity.pageremark");
        e.getFieldKeys().add("cardid");
        e.getFieldKeys().add("zone");
        e.getFieldKeys().add("workarea");
        e.getFieldKeys().add("mulzone");
        e.getFieldKeys().add("mulworkarea");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new MROCardRouteUpdateValidator());
    }

    /*
     * Could not resolve type clashes
     */
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] datas = e.getDataEntities();
        String operateKey = e.getOperationKey();
        DynamicObject dynamicObject = ParameterReader.getBillParameter((String)"mpdm_mrocardroute");
        Boolean isviewbill = (Boolean)dynamicObject.get("generatecard");
        if (!isviewbill.booleanValue()) {
            return;
        }
        if (!this.statusCheck(operateKey)) {
            return;
        }
        this.initCardIDPrimaryKey(e);
        long currentUserID = RequestContext.get().getCurrUserId();
        DynamicObject currentUser = BusinessDataServiceHelper.loadSingleFromCache((Object)currentUserID, (String)"bos_user");
        Date currentDate = new Date();
        for (DynamicObject data : datas) {
            DynamicObject[] workCardRouteColl;
            if (operateKey.equalsIgnoreCase("save") || operateKey.equalsIgnoreCase("submit")) {
                DynamicObjectCollection pageColl = data.getDynamicObjectCollection("pageentity");
                if (pageColl == null || pageColl.isEmpty()) continue;
                HashSet<Long> versionIDSet = new HashSet<Long>(pageColl.size());
                HashMap<Long, DynamicObject> versionMap = new HashMap<Long, DynamicObject>(pageColl.size());
                HashSet<String> versionNumberSet = new HashSet<String>(pageColl.size());
                for (int i = 0; i < pageColl.size(); ++i) {
                    String errorStr;
                    DynamicObject pageVersion = (DynamicObject)pageColl.get(i);
                    if (pageVersion.get("pageseq") == null || "".equals(pageVersion.getString("pageseq"))) {
                        errorStr = String.format(ResManager.loadKDString((String)"\u9875\u9762\u5de5\u65f6\u4fe1\u606f\u7b2c\uff1a%1$s \u884c\u6ca1\u6709\u8bbe\u7f6e\u9875\u7801\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8!", (String)"MROCardRouteUpdateOp_0", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i + 1);
                        throw new KDBizException(errorStr);
                    }
                    if (versionNumberSet.contains(pageVersion.getString("pageseq"))) {
                        errorStr = String.format(ResManager.loadKDString((String)"\u9875\u9762\u5de5\u65f6\u4fe1\u606f\u7b2c%1$s\u884c\u7684\u9875\u7801\u4fe1\u606f%2$s\u5b58\u5728\u91cd\u590d\u9879\u3002", (String)"MROCardRouteUpdateOp_1", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i + 1, pageVersion.getString("pageseq"));
                        throw new KDBizException(errorStr);
                    }
                    Long versionID = pageVersion.getPkValue() == null ? 0L : pageVersion.getLong("id");
                    if (versionID.equals(0L)) {
                        versionID = this.genID("mpdm_processversion");
                        pageVersion.set("id", (Object)versionID);
                    }
                    versionIDSet.add(versionID);
                    versionMap.put(versionID, pageVersion);
                    versionNumberSet.add(pageVersion.getString("pageseq"));
                    pageVersion.set("workcardno", (Object)(data.getString("number") + "-" + pageVersion.getString("pageseq")));
                }
                Map<Long, DynamicObject> workCardRouteMap = this.getWorkCardRouteHeadMap(data);
                ArrayList<Object> saveWorkCardRoutesList1 = new ArrayList<Object>(versionIDSet.size());
                ArrayList<Object> saveWorkCardRoutesList2 = new ArrayList<Object>(versionIDSet.size());
                ArrayList<Object> submitWorkCardRoutesList = new ArrayList<Object>(versionIDSet.size());
                for (Long versionID : versionIDSet) {
                    boolean isAdd;
                    Object workCardRoute = null;
                    DynamicObject version = (DynamicObject)versionMap.get(versionID);
                    workCardRoute = workCardRouteMap.get(versionID);
                    if (workCardRoute != null) {
                        workCardRoute = this.updateWorkCardRouteHead(data, version, (DynamicObject)workCardRoute);
                        isAdd = false;
                    } else {
                        workCardRoute = this.addWorkCardRouteHead(data, version);
                        isAdd = true;
                    }
                    workCardRoute.set("cardid", data.getPkValue());
                    if (this.isSubmitStatus((DynamicObject)workCardRoute) && !isAdd) {
                        submitWorkCardRoutesList.add(workCardRoute);
                    } else if (isAdd) {
                        saveWorkCardRoutesList1.add(workCardRoute);
                    } else if (operateKey.equalsIgnoreCase("save")) {
                        saveWorkCardRoutesList2.add(workCardRoute);
                    } else {
                        submitWorkCardRoutesList.add(workCardRoute);
                    }
                    this.updateMROWorkCardRouteEntryIDs(data, version, (DynamicObject)workCardRoute);
                }
                if (!saveWorkCardRoutesList1.isEmpty()) {
                    this.saveWorkCardRouteByColl(saveWorkCardRoutesList1.toArray(new DynamicObject[saveWorkCardRoutesList1.size()]), true);
                }
                if (!saveWorkCardRoutesList2.isEmpty()) {
                    this.saveWorkCardRouteByColl(saveWorkCardRoutesList2.toArray(new DynamicObject[saveWorkCardRoutesList2.size()]), false);
                }
                if (!submitWorkCardRoutesList.isEmpty()) {
                    this.submitWorkCardRouteByColl(submitWorkCardRoutesList.toArray(new DynamicObject[submitWorkCardRoutesList.size()]));
                }
                HashSet<Object> deleteWorkCardRouteIDs = new HashSet<Object>(workCardRouteMap.size());
                IDataEntityType workCardRouteType = null;
                for (Map.Entry entrys : workCardRouteMap.entrySet()) {
                    if (versionIDSet.contains(entrys.getKey())) continue;
                    deleteWorkCardRouteIDs.add(((DynamicObject)entrys.getValue()).getPkValue());
                    workCardRouteType = ((DynamicObject)entrys.getValue()).getDataEntityType();
                }
                if (deleteWorkCardRouteIDs.isEmpty()) continue;
                DynamicObject[] deleteWorkCardRoutes = new DynamicObject[deleteWorkCardRouteIDs.size()];
                int iloop = 0;
                for (Map.Entry<Long, DynamicObject> entrys : workCardRouteMap.entrySet()) {
                    if (!deleteWorkCardRouteIDs.contains(entrys.getValue().getPkValue())) continue;
                    deleteWorkCardRoutes[iloop] = entrys.getValue();
                    ++iloop;
                }
                this.deleteWorkCardRouteColl(deleteWorkCardRoutes);
                continue;
            }
            if (operateKey.equalsIgnoreCase("delete")) {
                workCardRouteColl = this.getWorkCardRouteHeadArray(data);
                this.deleteWorkCardRouteColl(workCardRouteColl);
                continue;
            }
            if (operateKey.equalsIgnoreCase("audit")) {
                workCardRouteColl = this.getWorkCardRouteHeadArray(data);
                this.auditWorkCardRouteColl(workCardRouteColl);
                continue;
            }
            if (operateKey.equalsIgnoreCase("unaudit")) {
                workCardRouteColl = this.getWorkCardRouteHeadArray(data);
                Set<Long> workCardRouteIdSet = this.getWorkCardRouteIDSet(workCardRouteColl);
                Set<Long> valideIDSet = this.valideUnAudit(workCardRouteIdSet);
                for (DynamicObject entrys : workCardRouteColl) {
                    if (!valideIDSet.contains((Long)entrys.getPkValue())) continue;
                    String errorStr = String.format(ResManager.loadKDString((String)"\u68c0\u4fee\u5de5\u827a\u4fe1\u606f\uff1a%1$s \u5df2\u7ecf\u88ab\u68c0\u4fee\u5de5\u5355\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u53cd\u5ba1\u6838!", (String)"MROCardRouteUpdateOp_2", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), this.getWorkCardRouteNumber(entrys));
                    throw new KDBizException(errorStr);
                }
                this.unAuditWorkCardRouteColl(workCardRouteColl);
                continue;
            }
            if (operateKey.equalsIgnoreCase("enable")) {
                workCardRouteColl = this.getWorkCardRouteHeadArray(data);
                for (int i = 0; i < workCardRouteColl.length; ++i) {
                    workCardRouteColl[i].set("canceler", null);
                    workCardRouteColl[i].set("canceltime", null);
                    workCardRouteColl[i].set("enable", (Object)"1");
                }
                SaveServiceHelper.update((DynamicObject[])workCardRouteColl);
                continue;
            }
            if (operateKey.equalsIgnoreCase("disable")) {
                workCardRouteColl = this.getWorkCardRouteHeadArray(data);
                for (int i = 0; i < workCardRouteColl.length; ++i) {
                    workCardRouteColl[i].set("canceler", (Object)currentUser);
                    workCardRouteColl[i].set("canceltime", (Object)currentDate);
                    workCardRouteColl[i].set("enable", (Object)"0");
                }
                SaveServiceHelper.update((DynamicObject[])workCardRouteColl);
                continue;
            }
            if (!operateKey.equalsIgnoreCase("unsubmit")) continue;
            workCardRouteColl = this.getWorkCardRouteHeadArray(data);
            for (int i = 0; i < workCardRouteColl.length; ++i) {
                workCardRouteColl[i].set("status", (Object)"A");
            }
            SaveServiceHelper.update((DynamicObject[])workCardRouteColl);
        }
        super.beginOperationTransaction(e);
    }

    private void updateMROWorkCardRouteEntryIDs(DynamicObject mroCardRoute, DynamicObject version, DynamicObject workCardRoute) {
        int i;
        DynamicObject dataObject;
        String versionIdFileds;
        DynamicObjectCollection dataColl = mroCardRoute.getDynamicObjectCollection("entryentity");
        String processSeq = null;
        if (dataColl != null && !dataColl.isEmpty() && !StringUtils.isEmpty((String)(versionIdFileds = MROCardRouteConstsUtils.getVersionIDFields(dataObject = (DynamicObject)dataColl.get(0), "pageversionid")))) {
            for (i = 0; i < dataColl.size(); ++i) {
                dataObject = (DynamicObject)dataColl.get(i);
                if (dataObject.get(versionIdFileds) == null) {
                    String errorStr = String.format(ResManager.loadKDString((String)"\u5de5\u5361\u5bf9\u5e94\u7684\u5de5\u5e8f\u5173\u7cfb\u4e2d\u7b2c:%1$s \u884c\u5206\u5f55\u7684\u7248\u672cID\u4e3a\u7a7a!", (String)"MROCardRouteUpdateOp_3", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i + 1);
                    throw new KDBizException(errorStr);
                }
                if (!dataObject.getString(versionIdFileds).equals(String.valueOf(version.getLong("id")))) continue;
                dataObject.set("workcardxlid", (Object)workCardRoute.getLong("id"));
                processSeq = dataObject.getString("processseq");
            }
        }
        if ((dataColl = mroCardRoute.getDynamicObjectCollection("processentry")) != null && !dataColl.isEmpty() && !StringUtils.isEmpty((String)(versionIdFileds = MROCardRouteConstsUtils.getVersionIDFields(dataObject = (DynamicObject)dataColl.get(0), "versionid")))) {
            for (i = 0; i < dataColl.size(); ++i) {
                dataObject = (DynamicObject)dataColl.get(i);
                if (dataObject.get(versionIdFileds) == null) {
                    String errorStr = String.format(ResManager.loadKDString((String)"\u5de5\u5361\u5bf9\u5e94\u7684\u5de5\u5e8f\u4fe1\u606f\u4e2d\u7b2c:%1$s \u884c\u5206\u5f55\u7684\u7248\u672cID\u4e3a\u7a7a!", (String)"MROCardRouteUpdateOp_4", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i + 1);
                    throw new KDBizException(errorStr);
                }
                if (!dataObject.getString(versionIdFileds).equals(String.valueOf(version.getLong("id")))) continue;
                dataObject.set("workcardrouteid", (Object)workCardRoute.getLong("id"));
                if (StringUtils.isEmpty((String)processSeq)) continue;
                dataObject.set("parent", (Object)processSeq);
            }
        }
    }

    private DynamicObject addWorkCardRouteHead(DynamicObject mroCardRoute, DynamicObject version) {
        ORM orm = ORM.create();
        DynamicObject workCardRoute = orm.newDynamicObject("mpdm_workcardroute");
        Set<String> updateFieldSet = MROCardRouteConstsUtils.getMroCardRouteUpdateHeadFields(mroCardRoute);
        for (String propertyName : updateFieldSet) {
            if (propertyName.equalsIgnoreCase("typeidentity")) {
                workCardRoute.set(propertyName, (Object)this.trasnsMulBaseDynamicObjectCollection(mroCardRoute.get(propertyName), propertyName, "mpdm_typeidentity"));
                continue;
            }
            if (propertyName.equalsIgnoreCase("traderelation")) {
                workCardRoute.set(propertyName, (Object)this.trasnsMulBaseDynamicObjectCollection(mroCardRoute.get(propertyName), propertyName, "mpdm_professiona"));
                continue;
            }
            if (propertyName.equalsIgnoreCase("mulconditionexe")) {
                workCardRoute.set(propertyName, (Object)this.trasnsMulBaseDynamicObjectCollection(mroCardRoute.get(propertyName), propertyName, "mpdm_execondition"));
                continue;
            }
            if (propertyName.equalsIgnoreCase("mulworkarea")) {
                workCardRoute.set(propertyName, (Object)this.trasnsMulBaseDynamicObjectCollection(mroCardRoute.get(propertyName), propertyName, "mpdm_area"));
                continue;
            }
            if (propertyName.equalsIgnoreCase("mulzone")) {
                workCardRoute.set(propertyName, (Object)this.trasnsMulBaseDynamicObjectCollection(mroCardRoute.get(propertyName), propertyName, "mpdm_functionlocation"));
                continue;
            }
            if (propertyName.equalsIgnoreCase("sumhours")) {
                workCardRoute.set(propertyName, version.get("pagesumhours"));
                continue;
            }
            workCardRoute.set(propertyName, mroCardRoute.get(propertyName));
        }
        workCardRoute.set("number", (Object)this.genWorkCardRouteNumber(mroCardRoute, version));
        Long newID = this.genID("mpdm_workcardroute");
        workCardRoute.set("id", (Object)newID);
        workCardRoute.set("masterid", (Object)newID);
        workCardRoute.set("version", (Object)version.getLong("id"));
        return workCardRoute;
    }

    private DynamicObject updateWorkCardRouteHead(DynamicObject mroCardRoute, DynamicObject version, DynamicObject workCardRoute) {
        Set<String> updateFieldSet = MROCardRouteConstsUtils.getMroCardRouteUpdateHeadFields(mroCardRoute);
        for (String propertyName : updateFieldSet) {
            if (propertyName.equalsIgnoreCase("typeidentity")) {
                workCardRoute.set(propertyName, (Object)this.trasnsMulBaseDynamicObjectCollection(mroCardRoute.get(propertyName), propertyName, "mpdm_typeidentity"));
                continue;
            }
            if (propertyName.equalsIgnoreCase("traderelation")) {
                workCardRoute.set(propertyName, (Object)this.trasnsMulBaseDynamicObjectCollection(mroCardRoute.get(propertyName), propertyName, "mpdm_professiona"));
                continue;
            }
            if (propertyName.equalsIgnoreCase("mulconditionexe")) {
                workCardRoute.set(propertyName, (Object)this.trasnsMulBaseDynamicObjectCollection(mroCardRoute.get(propertyName), propertyName, "mpdm_execondition"));
                continue;
            }
            if (propertyName.equalsIgnoreCase("mulworkarea")) {
                workCardRoute.set(propertyName, (Object)this.trasnsMulBaseDynamicObjectCollection(mroCardRoute.get(propertyName), propertyName, "mpdm_area"));
                continue;
            }
            if (propertyName.equalsIgnoreCase("mulzone")) {
                workCardRoute.set(propertyName, (Object)this.trasnsMulBaseDynamicObjectCollection(mroCardRoute.get(propertyName), propertyName, "mpdm_functionlocation"));
                continue;
            }
            if (propertyName.equalsIgnoreCase("sumhours")) {
                workCardRoute.set(propertyName, version.get("pagesumhours"));
                continue;
            }
            workCardRoute.set(propertyName, mroCardRoute.get(propertyName));
        }
        workCardRoute.set("number", (Object)this.genWorkCardRouteNumber(mroCardRoute, version));
        workCardRoute.set("version", (Object)version);
        return workCardRoute;
    }

    private String genWorkCardRouteNumber(DynamicObject mroCardRoute, DynamicObject version) {
        return mroCardRoute.getString("number") + "_" + version.getString("pageseq");
    }

    private DynamicObject[] getWorkCardRouteHeadArray(DynamicObject mroCardRoute) {
        Long cardID = (Long)mroCardRoute.getPkValue();
        QFilter qfilter = new QFilter("cardid", "=", (Object)cardID);
        Set<String> workCardRouteHeadFieldSet = MROCardRouteConstsUtils.getWorkCardRouteFields();
        String selectProperties = MROCardRouteConstsUtils.setToString(workCardRouteHeadFieldSet);
        DynamicObject[] workCardColl = BusinessDataServiceHelper.load((String)"mpdm_workcardroute", (String)selectProperties, (QFilter[])new QFilter[]{qfilter});
        return workCardColl;
    }

    private Map<Long, DynamicObject> getWorkCardRouteHeadMap(DynamicObject mroCardRoute) {
        DynamicObject[] workCardColl = this.getWorkCardRouteHeadArray(mroCardRoute);
        if (workCardColl == null || workCardColl.length < 1) {
            return Collections.emptyMap();
        }
        HashMap<Long, DynamicObject> versionCardMap = new HashMap<Long, DynamicObject>(workCardColl.length);
        for (int i = 0; i < workCardColl.length; ++i) {
            DynamicObject dy = workCardColl[i];
            DynamicObject version = dy.getDynamicObject("version");
            if (version == null) continue;
            versionCardMap.put(version.getLong("id"), dy);
        }
        return versionCardMap;
    }

    private Long genID(String entityName) {
        ORM orm = ORM.create();
        return orm.genLongId(entityName);
    }

    private void initCardIDPrimaryKey(BeginOperationTransactionArgs e) {
        Object[] datas = e.getDataEntities();
        String operateKey = e.getOperationKey();
        if (operateKey.equalsIgnoreCase("save") || operateKey.equalsIgnoreCase("submit")) {
            IDataEntityType type = datas[0].getDataEntityType();
            DBRoute rt = new DBRoute(type.getDBRouteKey());
            SequenceReader seqReader = new SequenceReader(rt);
            seqReader.autoSetPrimaryKey(datas, type);
        }
    }

    private Set<Long> valideUnAudit(Set<Long> workCardRouteIDSet) {
        if (workCardRouteIDSet == null || workCardRouteIDSet.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Long> unValideIDSet = new HashSet<Long>(workCardRouteIDSet.size());
        QFilter qFilter = new QFilter("treeentryentity.workcard", "in", workCardRouteIDSet);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-mrocardroute-valideUnAudit", (String)"pom_mroorder", (String)"treeentryentity.workcard workcardid", (QFilter[])new QFilter[]{qFilter}, (String)"");){
            for (Row row : ds) {
                unValideIDSet.add(row.getLong("workcardid"));
            }
        }
        return unValideIDSet;
    }

    private Set<Long> getWorkCardRouteIDSet(DynamicObject[] workCardRouteColl) {
        HashSet<Long> workCardRouteIDSet = new HashSet<Long>(workCardRouteColl.length);
        for (DynamicObject entrys : workCardRouteColl) {
            workCardRouteIDSet.add((Long)entrys.getPkValue());
        }
        return workCardRouteIDSet;
    }

    private void deleteWorkCardRouteColl(DynamicObject[] workCardRouteColl) {
        String errorString;
        OperationResult deleteResult;
        ArrayList<Object> unSubmitWorkCardRouteIDs = new ArrayList<Object>(workCardRouteColl.length);
        ArrayList<Object> deleteWorkCardRouteIDs = new ArrayList<Object>(workCardRouteColl.length);
        IDataEntityType workCardRouteType = null;
        Map<Object, DynamicObject> workCardRouteMap = MROCardRouteConstsUtils.arrayToMap(workCardRouteColl);
        for (DynamicObject entrys : workCardRouteColl) {
            String status = entrys.getString("status");
            if (this.isAuditStatus(entrys)) {
                String errorStr = String.format(ResManager.loadKDString((String)"\u68c0\u4fee\u5de5\u827a\u4fe1\u606f:%1$s \u5df2\u7ecf\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u5220\u9664\u64cd\u4f5c! ", (String)"MROCardRouteUpdateOp_5", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), this.getWorkCardRouteNumber(entrys));
                throw new KDBizException(errorStr);
            }
            if (this.isSubmitStatus(entrys)) {
                unSubmitWorkCardRouteIDs.add(entrys.getPkValue());
            }
            deleteWorkCardRouteIDs.add(entrys.getPkValue());
            workCardRouteType = entrys.getDataEntityType();
        }
        if (!unSubmitWorkCardRouteIDs.isEmpty()) {
            this.unSubmitWorkCardRouteByID(unSubmitWorkCardRouteIDs, workCardRouteMap);
        }
        OperateOption option = this.getOperateOption();
        if (!deleteWorkCardRouteIDs.isEmpty() && (deleteResult = OperationServiceHelper.executeOperate((String)"delete", (String)"mpdm_workcardroute", (Object[])deleteWorkCardRouteIDs.toArray(), (OperateOption)option)).getAllErrorOrValidateInfo() != null && !StringUtils.isEmpty((String)(errorString = this.getErrorString(deleteResult, workCardRouteMap)))) {
            String errorStr = String.format(ResManager.loadKDString((String)"\u68c0\u4fee\u5de5\u827a\u4fe1\u606f\u8fdb\u884c\u5220\u9664\u64cd\u4f5c\u65f6\u53d1\u751f\u9519\u8bef:%1$s ", (String)"MROCardRouteUpdateOp_6", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), errorString);
            throw new KDBizException(errorStr);
        }
    }

    private void saveWorkCardRouteByColl(DynamicObject[] workCardRouteColl, boolean isfirst) {
        String errorString;
        if (workCardRouteColl == null || workCardRouteColl.length < 1) {
            return;
        }
        if (!isfirst) {
            SaveServiceHelper.save((IDataEntityType)workCardRouteColl[0].getDataEntityType(), (Object[])workCardRouteColl);
            return;
        }
        Object workCardRouteType = null;
        Map<Object, DynamicObject> workCardRouteMap = MROCardRouteConstsUtils.arrayToMap(workCardRouteColl);
        OperateOption option = this.getOperateOption();
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"mpdm_workcardroute", (DynamicObject[])workCardRouteColl, (OperateOption)option);
        if (saveResult.getAllErrorOrValidateInfo() != null && !StringUtils.isEmpty((String)(errorString = this.getErrorString(saveResult, workCardRouteMap)))) {
            String errorStr = String.format(ResManager.loadKDString((String)"\u68c0\u4fee\u5de5\u827a\u4fe1\u606f\u8fdb\u884c\u4fdd\u5b58\u64cd\u4f5c\u65f6\u53d1\u751f\u9519\u8bef:%1$s ", (String)"MROCardRouteUpdateOp_7", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), errorString);
            throw new KDBizException(errorStr);
        }
    }

    private void submitWorkCardRouteByColl(DynamicObject[] workCardRouteColl) {
        if (workCardRouteColl == null || workCardRouteColl.length < 1) {
            return;
        }
        SaveServiceHelper.save((IDataEntityType)workCardRouteColl[0].getDataEntityType(), (Object[])workCardRouteColl);
    }

    private void unSubmitWorkCardRouteByID(List<Object> unSubmitWorkCardRouteIDs, Map<Object, DynamicObject> workCardRouteMap) {
        String errorString;
        OperationResult unSubmitResult;
        OperateOption option = this.getOperateOption();
        if (!unSubmitWorkCardRouteIDs.isEmpty() && (unSubmitResult = OperationServiceHelper.executeOperate((String)"unsubmit", (String)"mpdm_workcardroute", (Object[])unSubmitWorkCardRouteIDs.toArray(), (OperateOption)option)).getAllErrorOrValidateInfo() != null && !StringUtils.isEmpty((String)(errorString = this.getErrorString(unSubmitResult, workCardRouteMap)))) {
            String errorStr = String.format(ResManager.loadKDString((String)"\u68c0\u4fee\u5de5\u827a\u4fe1\u606f\u8fdb\u884c\u64a4\u9500\u64cd\u4f5c\u65f6\u53d1\u751f\u9519\u8bef:%1$s ", (String)"MROCardRouteUpdateOp_9", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), errorString);
            throw new KDBizException(errorStr);
        }
    }

    private void auditWorkCardRouteColl(DynamicObject[] workCardRouteColl) {
        String errorString;
        OperationResult auditResult;
        ArrayList<DynamicObject> submitWorkCardRouteList = new ArrayList<DynamicObject>(workCardRouteColl.length);
        ArrayList<Object> auditWorkCardRouteIDs = new ArrayList<Object>(workCardRouteColl.length);
        Map<Object, DynamicObject> workCardRouteMap = MROCardRouteConstsUtils.arrayToMap(workCardRouteColl);
        for (DynamicObject entrys : workCardRouteColl) {
            if (this.isAuditStatus(entrys)) continue;
            if (this.isSaveStatus(entrys)) {
                entrys.set("status", (Object)"B");
                submitWorkCardRouteList.add(entrys);
            }
            auditWorkCardRouteIDs.add(entrys.getPkValue());
        }
        if (!submitWorkCardRouteList.isEmpty()) {
            this.submitWorkCardRouteByColl(submitWorkCardRouteList.toArray(new DynamicObject[submitWorkCardRouteList.size()]));
        }
        OperateOption option = this.getOperateOption();
        if (!auditWorkCardRouteIDs.isEmpty() && (auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"mpdm_workcardroute", (Object[])auditWorkCardRouteIDs.toArray(), (OperateOption)option)).getAllErrorOrValidateInfo() != null && !StringUtils.isEmpty((String)(errorString = this.getErrorString(auditResult, workCardRouteMap)))) {
            String errorStr = String.format(ResManager.loadKDString((String)"\u68c0\u4fee\u5de5\u827a\u4fe1\u606f\u8fdb\u884c\u5ba1\u6838\u64cd\u4f5c\u65f6\u53d1\u751f\u9519\u8bef:%1$s ", (String)"MROCardRouteUpdateOp_10", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), errorString);
            throw new KDBizException(errorStr);
        }
    }

    private boolean isSaveStatus(DynamicObject dy) {
        return dy.getString("status").equals("A");
    }

    private boolean isSubmitStatus(DynamicObject dy) {
        return dy.getString("status").equals("B");
    }

    private boolean isAuditStatus(DynamicObject dy) {
        return dy.getString("status").equals("C");
    }

    private String getWorkCardRouteNumber(DynamicObject dy) {
        return dy.getString("number") == null ? dy.getString("name") : dy.getString("number");
    }

    private void unAuditWorkCardRouteColl(DynamicObject[] workCardRouteColl) {
        String errorString;
        OperationResult unAuditResult;
        ArrayList<Object> unAuditWorkCardRouteIDs = new ArrayList<Object>(workCardRouteColl.length);
        IDataEntityType workCardRouteType = null;
        Map<Object, DynamicObject> workCardRouteMap = MROCardRouteConstsUtils.arrayToMap(workCardRouteColl);
        for (DynamicObject entrys : workCardRouteColl) {
            if (!this.isAuditStatus(entrys)) continue;
            unAuditWorkCardRouteIDs.add(entrys.getPkValue());
            workCardRouteType = entrys.getDataEntityType();
        }
        OperateOption option = this.getOperateOption();
        if (!unAuditWorkCardRouteIDs.isEmpty() && (unAuditResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"mpdm_workcardroute", (Object[])unAuditWorkCardRouteIDs.toArray(), (OperateOption)option)).getAllErrorOrValidateInfo() != null && !StringUtils.isEmpty((String)(errorString = this.getErrorString(unAuditResult, workCardRouteMap)))) {
            String errorStr = String.format(ResManager.loadKDString((String)"\u68c0\u4fee\u5de5\u827a\u4fe1\u606f\u8fdb\u884c\u53cd\u5ba1\u6838\u64cd\u4f5c\u65f6\u53d1\u751f\u9519\u8bef:%1$s ", (String)"MROCardRouteUpdateOp_11", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), errorString);
            throw new KDBizException(errorStr);
        }
    }

    private OperateOption getOperateOption() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("ignorewarn", "true");
        option.setVariableValue("ignoreinteraction", "true");
        return option;
    }

    private String getErrorString(OperationResult operResult, Map<Object, DynamicObject> objMap) {
        StringBuilder sf = new StringBuilder();
        for (IOperateInfo errInfo : operResult.getAllErrorOrValidateInfo()) {
            DynamicObject obj = objMap.get(errInfo.getPkValue());
            String number = "";
            if (obj != null) {
                number = this.getWorkCardRouteNumber(obj);
            }
            sf.append(number).append(':').append(errInfo.getMessage()).append(';');
        }
        return sf.toString();
    }

    private DynamicObjectCollection trasnsMulBaseDynamicObjectCollection(Object sourceData, String propertyName, String proEntityNum) {
        return CardBusinessUtils.trasnsMulBaseDynamicObjectCollection((String)"mpdm_workcardroute", (Object)sourceData, (String)propertyName, (String)proEntityNum);
    }
}

