/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.workcardinfo;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.utils.QueryNameByEntityUtils;
import kd.bd.mpdm.common.wordcard.utils.WorkCardUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class WorkCardDataUniqueVal
extends AbstractValidator {
    private static Log logger = LogFactory.getLog(WorkCardDataUniqueVal.class);
    private static final String MPDM_MROCARDROUTE = "mpdm_mrocardroute";
    private static final String CARDNUM = "cardnum";
    private static final String CUSTOMER = "customer";
    private static final String CARDNUMID = "cardnumid";
    private static final String CARDVERSION = "cardversion";
    private static final String CARDTYPE = "cardtype";
    private static Set<String> filedSet = Sets.newHashSet((Object[])new String[]{"cardnum", "customer", "cardnumid", "cardversion", "cardtype", "zone", "cardhourtype", "version", "materialtype", "material", "number", "createorg"});

    public void validate() {
        String operate = this.getOperateKey();
        String entityKey = this.getEntityKey();
        if (!MPDM_MROCARDROUTE.equals(entityKey)) {
            return;
        }
        HashSet validSet = Sets.newHashSet((Object[])new String[]{"audit", "enable", "submit", "save"});
        if (validSet.contains(operate)) {
            logger.info("WorkCardDataUniqueVal----start---" + operate);
            Map MroCardMap = QueryNameByEntityUtils.queryNameMap(filedSet, (String)MPDM_MROCARDROUTE);
            HashMap<Long, Set<String>> orgMap = new HashMap<Long, Set<String>>(16);
            HashMap<Long, Set<String>> orgNumberMap = new HashMap<Long, Set<String>>(16);
            for (int i = 0; i < this.dataEntities.length; ++i) {
                HashSet<String> keySet;
                DynamicObject dataEntity = this.dataEntities[i].getDataEntity();
                String number = dataEntity.getString("number");
                DynamicObject createOrg = dataEntity.getDynamicObject("createorg");
                if (createOrg == null) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199%1$s\u3002", (String)"WorkCardDataUniqueVal_54", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), MroCardMap.get("createorg")));
                    return;
                }
                if (MPDM_MROCARDROUTE.equals(entityKey) && this.checkEntryData(this.dataEntities[i])) continue;
                String processtype = dataEntity.getString("processtype");
                Long createOrgPK = createOrg.getLong("id");
                if (orgNumberMap.containsKey(createOrgPK)) {
                    keySet = (HashSet<String>)orgNumberMap.get(createOrgPK);
                    if (keySet.contains(number)) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5361%1$s\uff1a\u5df2\u5b58\u5728[%2$s]\u4e00\u81f4\u7684\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"WorkCardDataUniqueVal_55", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), number, MroCardMap.get("number")));
                        continue;
                    }
                    keySet.add(number);
                } else {
                    keySet = new HashSet<String>(16);
                    keySet.add(number);
                    orgNumberMap.put(createOrgPK, keySet);
                }
                if (!"E".equals(processtype)) {
                    HashSet<String> keySet2;
                    String uniqueKey = WorkCardUtils.getUniqueKey((DynamicObject)dataEntity, (String)processtype);
                    logger.info("WorkCardDataUniqueVal----uniqueKey---" + uniqueKey);
                    if (orgMap.containsKey(createOrgPK)) {
                        keySet2 = (HashSet<String>)orgMap.get(createOrgPK);
                        if (keySet2.contains(uniqueKey)) {
                            if ("C".equals(processtype)) {
                                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5361%1$s\uff1a\u5df2\u5b58\u5728%2$s\u3001%3$s\u3001%4$s\u3001%5$s\u3001%6$s\u3001%7$s\u3001%8$s\u3001%9$s\u3001%10$s\u4e00\u81f4\u7684\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"WorkCardDataUniqueVal_51", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), number, MroCardMap.get(CARDTYPE), MroCardMap.get("materialtype"), MroCardMap.get(CUSTOMER), MroCardMap.get(CARDNUM), MroCardMap.get(CARDNUMID), MroCardMap.get(CARDVERSION), MroCardMap.get("material"), MroCardMap.get("zone"), MroCardMap.get("cardhourtype")));
                                continue;
                            }
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5361%1$s\uff1a\u5df2\u5b58\u5728%2$s\u3001%3$s\u3001%4$s\u3001%5$s\u3001%6$s\u3001%7$s\u3001%8$s\u4e00\u81f4\u7684\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"WorkCardDataUniqueVal_41", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), number, MroCardMap.get(CUSTOMER), MroCardMap.get(CARDNUM), MroCardMap.get(CARDNUMID), MroCardMap.get(CARDTYPE), MroCardMap.get(CARDVERSION), MroCardMap.get("materialtype"), MroCardMap.get("material")));
                            continue;
                        }
                        keySet2.add(uniqueKey);
                        orgMap.put(createOrgPK, keySet2);
                    } else {
                        keySet2 = new HashSet<String>(16);
                        keySet2.add(uniqueKey);
                        orgMap.put(createOrgPK, keySet2);
                    }
                    dataEntity.set("numberkeys", (Object)uniqueKey);
                    continue;
                }
                dataEntity.set("numberkeys", (Object)number);
            }
            logger.info("WorkCardDataUniqueVal----checkUniqueCard---" + orgNumberMap);
            this.checkUniqueNumber(orgNumberMap, MroCardMap, operate);
            logger.info("WorkCardDataUniqueVal----checkUniqueCard---" + orgMap);
            this.checkUniqueCard(orgMap, MroCardMap, operate);
            logger.info("WorkCardDataUniqueVal----checkUniqueCard----end---");
        }
    }

    private void checkUniqueNumber(Map<Long, Set<String>> orgMap, Map<String, String> MroCardMap, String operate) {
        HashMap catchCardMap = new HashMap(16);
        for (Map.Entry<Long, Set<String>> uniqueMap : orgMap.entrySet()) {
            Long orgid = uniqueMap.getKey();
            Set<String> uniqueSet = uniqueMap.getValue();
            Map<Object, DynamicObject> cardMap = this.getWorkCardNumData(orgid, uniqueSet, operate);
            for (Map.Entry<Object, DynamicObject> mroCard : cardMap.entrySet()) {
                ArrayList<DynamicObject> list;
                String numberkeys;
                DynamicObject card = mroCard.getValue();
                DynamicObject createorg = card.getDynamicObject("createorg");
                StringBuilder sb = new StringBuilder();
                sb.append(card.getString("number"));
                if ("save".equals(operate) || "submit".equals(operate)) {
                    sb.append("@@");
                    sb.append(createorg.getPkValue());
                }
                if (catchCardMap.containsKey(numberkeys = sb.toString())) {
                    list = (ArrayList<DynamicObject>)catchCardMap.get(numberkeys);
                    list.add(card);
                    catchCardMap.put(numberkeys, list);
                    continue;
                }
                list = new ArrayList<DynamicObject>(8);
                list.add(card);
                catchCardMap.put(numberkeys, list);
            }
        }
        logger.info("WorkCardDataUniqueVal----checkUniqueNumber----catchCardMap---" + catchCardMap);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject dataEntity = this.dataEntities[i].getDataEntity();
            DynamicObject createorg = dataEntity.getDynamicObject("createorg");
            String number = dataEntity.getString("number");
            StringBuilder sb = new StringBuilder();
            sb.append(number);
            if ("save".equals(operate) || "submit".equals(operate)) {
                sb.append("@@");
                sb.append(createorg.getPkValue());
            }
            String numberkeys = sb.toString();
            Long pkValue = (Long)dataEntity.getPkValue();
            logger.info("WorkCardDataUniqueVal----checkUniqueNumber----numberkeys---" + numberkeys);
            if (!catchCardMap.containsKey(numberkeys)) continue;
            List cardList = (List)catchCardMap.get(numberkeys);
            Boolean repeat = Boolean.FALSE;
            if (cardList.size() == 1) {
                DynamicObject card = (DynamicObject)cardList.get(0);
                Long cardid = card.getLong("id");
                if (!cardid.equals(pkValue)) {
                    repeat = Boolean.TRUE;
                }
            } else if (cardList.size() > 1) {
                repeat = Boolean.TRUE;
            }
            if (!repeat.booleanValue()) continue;
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5361%1$s\uff1a\u5df2\u5b58\u5728[%2$s]\u4e00\u81f4\u7684\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"WorkCardDataUniqueVal_55", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), number, MroCardMap.get("number")));
        }
    }

    private void checkUniqueCard(Map<Long, Set<String>> orgMap, Map<String, String> MroCardMap, String operate) {
        HashMap catchCardMap = new HashMap(16);
        for (Map.Entry<Long, Set<String>> uniqueMap : orgMap.entrySet()) {
            Long orgid = uniqueMap.getKey();
            Set<String> uniqueSet = uniqueMap.getValue();
            Map<Object, DynamicObject> cardMap = this.getWorkCardData(orgid, uniqueSet, operate);
            for (Map.Entry<Object, DynamicObject> mroCard : cardMap.entrySet()) {
                ArrayList<DynamicObject> list;
                String numberkeys;
                DynamicObject card = mroCard.getValue();
                DynamicObject createorg = card.getDynamicObject("createorg");
                StringBuilder sb = new StringBuilder();
                sb.append(card.getString("numberkeys"));
                if ("save".equals(operate) || "submit".equals(operate)) {
                    sb.append("@@");
                    sb.append(createorg.getPkValue());
                }
                if (catchCardMap.containsKey(numberkeys = sb.toString())) {
                    list = (ArrayList<DynamicObject>)catchCardMap.get(numberkeys);
                    list.add(card);
                    catchCardMap.put(numberkeys, list);
                    continue;
                }
                list = new ArrayList<DynamicObject>(8);
                list.add(card);
                catchCardMap.put(numberkeys, list);
            }
        }
        logger.info("WorkCardDataUniqueVal----checkUniqueCard----catchCardMap---" + catchCardMap);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject dataEntity = this.dataEntities[i].getDataEntity();
            DynamicObject createorg = dataEntity.getDynamicObject("createorg");
            StringBuilder sb = new StringBuilder();
            sb.append(dataEntity.getString("numberkeys"));
            if ("save".equals(operate) || "submit".equals(operate)) {
                sb.append("@@");
                sb.append(createorg.getPkValue());
            }
            String numberkeys = sb.toString();
            String number = dataEntity.getString("number");
            Long pkValue = (Long)dataEntity.getPkValue();
            logger.info("WorkCardDataUniqueVal----checkUniqueCard----numberkeys---" + numberkeys);
            if (!catchCardMap.containsKey(numberkeys)) continue;
            List cardList = (List)catchCardMap.get(numberkeys);
            Boolean repeat = Boolean.FALSE;
            if (cardList.size() == 1) {
                DynamicObject card = (DynamicObject)cardList.get(0);
                Long cardid = card.getLong("id");
                if (!cardid.equals(pkValue)) {
                    repeat = Boolean.TRUE;
                }
            } else if (cardList.size() > 1) {
                repeat = Boolean.TRUE;
            }
            if (!repeat.booleanValue()) continue;
            String processtype = dataEntity.getString("processtype");
            String unique = ((DynamicObject)cardList.get(0)).getString("number");
            if ("C".equals(processtype)) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5361%1$s\uff1a\u5df2\u5b58\u5728%2$s\u3001%3$s\u3001%4$s\u3001%5$s\u3001%6$s\u3001%7$s\u3001%8$s\u3001%9$s\u3001%10$s\u4e00\u81f4\u7684\u6570\u636e%11$s\uff0c\u8bf7\u4fee\u6539\u3002", (String)"WorkCardDataUniqueVal_53", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), number, MroCardMap.get(CARDTYPE), MroCardMap.get("materialtype"), MroCardMap.get(CUSTOMER), MroCardMap.get(CARDNUM), MroCardMap.get(CARDNUMID), MroCardMap.get(CARDVERSION), MroCardMap.get("material"), MroCardMap.get("zone"), MroCardMap.get("cardhourtype"), unique));
                continue;
            }
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5de5\u5361%1$s\uff1a\u5df2\u5b58\u5728%2$s\u3001%3$s\u3001%4$s\u3001%5$s\u3001%6$s\u3001%7$s\u3001%8$s\u4e00\u81f4\u7684\u6570\u636e%9$s\uff0c\u8bf7\u4fee\u6539\u3002", (String)"WorkCardDataUniqueVal_45", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), number, MroCardMap.get(CUSTOMER), MroCardMap.get(CARDNUM), MroCardMap.get(CARDNUMID), MroCardMap.get(CARDTYPE), MroCardMap.get(CARDVERSION), MroCardMap.get("materialtype"), MroCardMap.get("material"), unique));
        }
    }

    private Map<Object, DynamicObject> getWorkCardData(Long orgid, Set<String> uniqueSet, String operate) {
        QFilter orgQfiter = BaseDataServiceHelper.getBaseDataFilter((String)MPDM_MROCARDROUTE, (Long)orgid);
        if ("audit".equals(operate) || "enable".equals(operate)) {
            orgQfiter.and(new QFilter("enable", "=", (Object)"1"));
            orgQfiter.and(new QFilter("status", "=", (Object)"C"));
        }
        if (!uniqueSet.isEmpty()) {
            orgQfiter.and(new QFilter("numberkeys", "in", uniqueSet));
        }
        return BusinessDataServiceHelper.loadFromCache((String)MPDM_MROCARDROUTE, (String)"id,numberkeys,number,createorg", (QFilter[])new QFilter[]{orgQfiter});
    }

    private Map<Object, DynamicObject> getWorkCardNumData(Long orgid, Set<String> uniqueSet, String operate) {
        QFilter orgQfiter = BaseDataServiceHelper.getBaseDataFilter((String)MPDM_MROCARDROUTE, (Long)orgid);
        if ("audit".equals(operate) || "enable".equals(operate)) {
            orgQfiter.and(new QFilter("enable", "=", (Object)"1"));
            orgQfiter.and(new QFilter("status", "=", (Object)"C"));
        }
        if (!uniqueSet.isEmpty()) {
            orgQfiter.and(new QFilter("number", "in", uniqueSet));
        }
        return BusinessDataServiceHelper.loadFromCache((String)MPDM_MROCARDROUTE, (String)"id,numberkeys,number,createorg", (QFilter[])new QFilter[]{orgQfiter});
    }

    public String checkUnique(String entityNumber, QFilter qfiter, Object pkid) {
        DynamicObject matCommandObj = QueryServiceHelper.queryOne((String)entityNumber, (String)"id,number", (QFilter[])new QFilter[]{qfiter});
        if (matCommandObj != null && !pkid.equals(matCommandObj.getLong("id"))) {
            return matCommandObj.getString("number");
        }
        return null;
    }

    private boolean checkEntryData(ExtendedDataEntity entity) {
        boolean isError = false;
        DynamicObjectCollection entryCol = entity.getDataEntity().getDynamicObjectCollection("pageentity");
        for (int j = 0; j < entryCol.size(); ++j) {
            DynamicObject entryObj = (DynamicObject)entryCol.get(j);
            String queryName = QueryNameByEntityUtils.queryNameAndEntry((String)"pageseq", (String)MPDM_MROCARDROUTE);
            if (this.isNull(entryObj.getString("pageseq"))) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkCardDataUniqueVal_46", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), queryName));
                isError = true;
            }
            BigDecimal calsumhours = entryObj.getBigDecimal("calsumhours");
            BigDecimal customesumhours = entryObj.getBigDecimal("customesumhours");
            if (calsumhours.compareTo(BigDecimal.ZERO) > 0 && customesumhours.compareTo(calsumhours) > 0) {
                String queryName2 = QueryNameByEntityUtils.queryNameAndEntry((String)"customhours3", (String)MPDM_MROCARDROUTE);
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"%1$s\u5927\u4e8e%2$s\u4e4b\u548c%3$s\u3002", (String)"WorkCardDataUniqueVal_47", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), customesumhours, queryName2, calsumhours));
                isError = true;
            }
            Long vid = (Long)entryObj.getPkValue();
            DynamicObjectCollection subEntryCol = entity.getDataEntity().getDynamicObjectCollection("processentry");
            boolean isExist = false;
            for (int k = 0; k < subEntryCol.size(); ++k) {
                DynamicObject subEntryObj = (DynamicObject)subEntryCol.get(k);
                if (!vid.equals(subEntryObj.getLong("versionid"))) continue;
                isExist = true;
                break;
            }
            if (isExist) continue;
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"%1$s[%2$s]\uff0c\u81f3\u5c11\u9700\u8981\u5f55\u5165\u4e00\u6761\u5de5\u5e8f\u3002", (String)"WorkCardDataUniqueVal_56", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), queryName, entryObj.getString("pageseq")));
            isError = true;
        }
        return isError;
    }

    private boolean isNull(Object obj) {
        if (obj instanceof String) {
            return obj == null || obj.toString().trim().length() == 0;
        }
        return obj == null;
    }
}

