/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.workcardinfo;

import com.alibaba.nacos.api.utils.StringUtils;
import java.util.Comparator;
import java.util.Date;
import kd.bd.mpdm.business.workcardinfo.MroCardGeneratePhotoUtils;
import kd.bd.mpdm.common.utils.WorkcardDataInfoUtils;
import kd.bd.mpdm.opplugin.workcardinfo.ProcessRouteComparatorImpl;
import kd.bd.mpdm.opplugin.workcardinfo.WorkCardDataAuxpropertyVal;
import kd.bd.mpdm.opplugin.workcardinfo.WorkCardDataMustInputVal;
import kd.bd.mpdm.opplugin.workcardinfo.WorkCardDataProcessMatchVal;
import kd.bd.mpdm.opplugin.workcardinfo.WorkCardDataUniqueVal;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class WorkCardProcessRouteOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        WorkcardDataInfoUtils.setPreparePropertyFieldKeys((PreparePropertysEventArgs)e, (String)this.billEntityType.getName());
        e.getFieldKeys().add("version");
        e.getFieldKeys().add("baseqty");
        e.getFieldKeys().add("open");
        e.getFieldKeys().add("close");
        e.getFieldKeys().add("cardhourtype");
        e.getFieldKeys().add("processentry.parent");
        e.getFieldKeys().add("processentry.seq");
        e.getFieldKeys().add("relentryentity1.seq");
        e.getFieldKeys().add("relentryentity.seq");
        e.getFieldKeys().add("entryentity1.seq");
        e.getFieldKeys().add("actentryentity.seq");
        e.getFieldKeys().add("entryentity2.seq");
        e.getFieldKeys().add("pageinfo.seq");
        e.getFieldKeys().add("pageentity.seq");
        e.getFieldKeys().add("pageentity.workcardno");
        e.getFieldKeys().add("pageentity.calsumhours");
        e.getFieldKeys().add("entryentity.workcardxlid");
        e.getFieldKeys().add("processentry.overlapunit");
        e.getFieldKeys().add("processentry.workcardrouteid");
        e.getFieldKeys().add("name");
        e.getFieldKeys().add("cardintegrity");
        e.getFieldKeys().add("cardversion");
        e.getFieldKeys().add("processtype");
        e.getFieldKeys().add("customer");
        e.getFieldKeys().add("bomversion");
        e.getFieldKeys().add("material");
        e.getFieldKeys().add("auxproperty");
        e.getFieldKeys().add("materialgroup");
        e.getFieldKeys().add("materialtype");
        e.getFieldKeys().add("zone");
        e.getFieldKeys().add("mulzone");
        e.getFieldKeys().add("cardnumid");
        e.getFieldKeys().add("cardnum");
        e.getFieldKeys().add("cardname");
        e.getFieldKeys().add("numberkeys");
        e.getFieldKeys().add("createorg");
        e.getFieldKeys().add("isgeneratephoto");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataArray = e.getDataEntities();
        long userId = RequestContext.get().getCurrUserId();
        DynamicObject userObj = BusinessDataServiceHelper.loadSingle((Object)userId, (String)"bos_user");
        block15: for (int i = 0; i < dataArray.length; ++i) {
            DynamicObject obj = dataArray[i];
            switch (e.getOperationKey()) {
                case "audit": {
                    obj.set("auditor", (Object)userObj);
                    obj.set("audittime", (Object)new Date());
                    this.setCardIntegrity(obj, e.getOperationKey());
                    continue block15;
                }
                case "unaudit": {
                    obj.set("auditor", null);
                    obj.set("audittime", null);
                    continue block15;
                }
                case "enable": {
                    obj.set("canceler", null);
                    obj.set("canceltime", null);
                    obj.set("enableuser", (Object)userObj);
                    obj.set("enabledate", (Object)new Date());
                    continue block15;
                }
                case "disable": {
                    obj.set("canceler", (Object)userObj);
                    obj.set("canceltime", (Object)new Date());
                    obj.set("enableuser", null);
                    obj.set("enabledate", null);
                    continue block15;
                }
                case "save": 
                case "submit": {
                    this.setCardName(obj);
                    String cardversionchange = "0";
                    if (this.getOption().containsVariable("cardversionchange")) {
                        cardversionchange = this.getOption().getVariableValue("cardversionchange");
                        if ("1".equals(cardversionchange)) {
                            obj.set("cardversiontime", (Object)new Date());
                        }
                    } else {
                        String cardversion = obj.getString("cardversion");
                        if (!StringUtils.isEmpty((CharSequence)cardversion)) {
                            obj.set("cardversiontime", (Object)new Date());
                        }
                    }
                    this.setCardIntegrity(obj, e.getOperationKey());
                    String ischangedata = "0";
                    if (this.getOption().containsVariable("importtag_of_datasource")) {
                        String isimport = this.getOption().getVariableValue("importtag_of_datasource");
                        boolean isgeneratephoto = obj.getBoolean("isgeneratephoto");
                        if (isgeneratephoto && Boolean.parseBoolean(isimport)) {
                            cardversionchange = "1";
                            ischangedata = "1";
                        }
                    }
                    if (this.getOption().containsVariable("ischangedata")) {
                        ischangedata = this.getOption().getVariableValue("ischangedata");
                    }
                    this.generatePhoto(obj, cardversionchange, ischangedata);
                    continue block15;
                }
            }
        }
    }

    private void sort(DynamicObject obj) {
        DynamicObjectCollection objCol = obj.getDynamicObjectCollection("processentry");
        objCol.sort((Comparator)new ProcessRouteComparatorImpl());
        for (int i = 0; i < objCol.size(); ++i) {
            ((DynamicObject)objCol.get(i)).set("seq", (Object)(i + 1));
        }
    }

    private void setCardIntegrity(DynamicObject obj, String operateKey) {
        DynamicObjectCollection processentry;
        String processtype = (String)obj.get("processtype");
        obj.set("cardintegrity", (Object)"C");
        if ("audit".equals(operateKey)) {
            return;
        }
        if (!"C".equals(processtype) && ((processentry = obj.getDynamicObjectCollection("processentry")) == null || processentry.isEmpty())) {
            obj.set("cardintegrity", (Object)"B");
        }
    }

    private void setCardName(DynamicObject obj) {
        OrmLocaleValue name = (OrmLocaleValue)obj.get("name");
        String localeValue = name.getLocaleValue();
        String cardName = obj.getString("cardname");
        if (StringUtils.isEmpty((CharSequence)localeValue)) {
            String number = (String)obj.get("number");
            LocaleString ss = new LocaleString(number);
            obj.set("name", (Object)ss);
        }
    }

    private void generatePhoto(DynamicObject obj, String cardversionchange, String ischangedata) {
        DynamicObject cardtype = obj.getDynamicObject("cardtype");
        String photodimension = (String)cardtype.get("photodimension");
        if ("B".equals(photodimension) && "1".equals(cardversionchange) || "1".equals(ischangedata) && "A".equals(photodimension)) {
            MroCardGeneratePhotoUtils.generateHistory((DynamicObject)obj);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new WorkCardDataUniqueVal());
        e.addValidator((AbstractValidator)new WorkCardDataMustInputVal());
        e.addValidator((AbstractValidator)new WorkCardDataAuxpropertyVal());
        e.addValidator((AbstractValidator)new WorkCardDataProcessMatchVal());
    }
}

