/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.workcardinfo.change;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bd.mpdm.common.utils.MapCompareUtils;
import kd.bd.mpdm.opplugin.workcardinfo.change.CardToolChangeVal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class CardToolChangeOp
extends AbstractOperationServicePlugIn {
    private static String toolentrytr = "entrymaterial,entryownertype,entryowner,entrybaseunit,entrybaseqty,enrtyunit,entryqty,toolsubgroup,entrymaterialtype,toollevel,supplyorg,warehouse,location,entryhistoryusetime,entryremark,repgrpentryid,seq,groupversion";
    private static String docentrystr = "docmanualnumber,docname,docmanualversion,docpagenumber,docdescribe,docappendix,seq";
    private static String TOOLENTITY = "entryentity";
    private static String DOCENTITY = "entryentity1";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("billtype");
        e.getFieldKeys().add("changetime");
        e.getFieldKeys().add("changereasion");
        e.getFieldKeys().add("workcard");
        e.getFieldKeys().add("isneedtool");
        e.getFieldKeys().add("materialnum");
        e.getFieldKeys().add("materialtype");
        e.getFieldKeys().add("toolid");
        e.getFieldKeys().add("entryentity.oldentryid");
        e.getFieldKeys().add("entryentity.entrymaterial");
        e.getFieldKeys().add("entryentity.entryownertype");
        e.getFieldKeys().add("entryentity.entryowner");
        e.getFieldKeys().add("entryentity.seq");
        e.getFieldKeys().add("entryentity.entrybaseunit");
        e.getFieldKeys().add("entryentity.entrybaseqty");
        e.getFieldKeys().add("entryentity.enrtyunit");
        e.getFieldKeys().add("entryentity.entryqty");
        e.getFieldKeys().add("entryentity.toolsubgroup");
        e.getFieldKeys().add("entryentity.groupversion");
        e.getFieldKeys().add("entryentity.entrymaterialtype");
        e.getFieldKeys().add("entryentity.toollevel");
        e.getFieldKeys().add("entryentity.supplyorg");
        e.getFieldKeys().add("entryentity.warehouse");
        e.getFieldKeys().add("entryentity.location");
        e.getFieldKeys().add("entryentity.entryhistoryusetime");
        e.getFieldKeys().add("entryentity.entryremark");
        e.getFieldKeys().add("entryentity.repgrpentryid");
        e.getFieldKeys().add("entryentity1.seq");
        e.getFieldKeys().add("entryentity1.docentryid");
        e.getFieldKeys().add("entryentity1.docmanualnumber");
        e.getFieldKeys().add("entryentity1.docname");
        e.getFieldKeys().add("entryentity1.docmanualversion");
        e.getFieldKeys().add("entryentity1.docpagenumber");
        e.getFieldKeys().add("entryentity1.docdescribe");
        e.getFieldKeys().add("entryentity1.docappendix");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new CardToolChangeVal());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operationKey = e.getOperationKey();
        if ("audit".equals(operationKey)) {
            DynamicObject[] dataEntities2 = e.getDataEntities();
            HashSet<Long> toolidSet = new HashSet<Long>(16);
            for (DynamicObject entity : dataEntities2) {
                Long toolid = entity.getLong("toolid");
                toolidSet.add(toolid);
            }
            QFilter qf = new QFilter("id", "in", toolidSet);
            qf.and(new QFilter("status", "=", (Object)"C"));
            qf.and(new QFilter("enable", "=", (Object)"1"));
            Map tooldemandMap = BusinessDataServiceHelper.loadFromCache((String)"mpdm_cardtooldemand", (QFilter[])new QFilter[]{qf});
            ArrayList<DynamicObject> toolList = new ArrayList<DynamicObject>(tooldemandMap.size());
            for (DynamicObject entity : dataEntities2) {
                Object toolid = entity.get("toolid");
                DynamicObject tool = (DynamicObject)tooldemandMap.get(toolid);
                if (tool == null || !this.compareToolInfo(tool, entity)) continue;
                toolList.add(tool);
            }
            if (!toolList.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])toolList.toArray(new DynamicObject[0]));
            }
        }
    }

    private boolean compareToolInfo(DynamicObject tool, DynamicObject entity) {
        DynamicObjectCollection toolentry = tool.getDynamicObjectCollection(TOOLENTITY);
        DynamicObjectCollection changeentry = entity.getDynamicObjectCollection(TOOLENTITY);
        DynamicObjectCollection toolDocentry = tool.getDynamicObjectCollection(DOCENTITY);
        DynamicObjectCollection changeDocentry = entity.getDynamicObjectCollection(DOCENTITY);
        boolean flag1 = this.setToolEntryData(toolentry, changeentry, "oldentryid", toolentrytr);
        boolean flag2 = this.setToolEntryData(toolDocentry, changeDocentry, "docentryid", docentrystr);
        return flag1 || flag2;
    }

    private boolean setToolEntryData(DynamicObjectCollection toolentry, DynamicObjectCollection changeentry, String entryfield, String fieldStr) {
        DynamicObject changeEntry;
        boolean flag = false;
        HashMap<Object, DynamicObject> toolMap = new HashMap<Object, DynamicObject>(toolentry.size());
        for (DynamicObject row : toolentry) {
            toolMap.put(row.getPkValue(), row);
        }
        HashMap<Object, DynamicObject> changeMap = new HashMap<Object, DynamicObject>(changeentry.size());
        long[] getOrderIds = MapCompareUtils.getOrderIds((String)"mpdm_cardtooldemand", (int)changeentry.size());
        int index = 0;
        for (DynamicObject row : changeentry) {
            Object oldentryid = row.get(entryfield);
            if ("0".equals(String.valueOf(oldentryid))) {
                row.set(entryfield, (Object)getOrderIds[index]);
                changeMap.put(getOrderIds[index], row);
                ++index;
                continue;
            }
            changeMap.put(oldentryid, row);
        }
        Map deleteMap = MapCompareUtils.getDifferenceSetByGuava(toolMap, changeMap);
        Map addMap = MapCompareUtils.getDifferenceSetByGuava(changeMap, toolMap);
        Map interMap = MapCompareUtils.getIntersectionSetByGuava(changeMap, toolMap);
        if (!deleteMap.isEmpty()) {
            toolentry.removeAll(deleteMap.values());
            flag = true;
        }
        if (!interMap.isEmpty()) {
            for (DynamicObject interrow : toolentry) {
                String[] split;
                Object pkValue = interrow.getPkValue();
                if (!interMap.containsKey(pkValue)) continue;
                changeEntry = (DynamicObject)interMap.get(pkValue);
                for (String field : split = fieldStr.split(",")) {
                    if ("entrymaterialtype".equals(field) || "docappendix".equals(field)) {
                        this.setMulBaseDateValue(interrow, changeEntry, field);
                        continue;
                    }
                    interrow.set(field, changeEntry.get(field));
                }
            }
            flag = true;
        }
        if (!addMap.isEmpty()) {
            for (Map.Entry addRow : addMap.entrySet()) {
                String[] split;
                DynamicObject addNew = toolentry.addNew();
                changeEntry = (DynamicObject)addRow.getValue();
                Object key = addRow.getKey();
                for (String field : split = fieldStr.split(",")) {
                    if ("entrymaterialtype".equals(field) || "docappendix".equals(field)) {
                        this.setMulBaseDateValue(addNew, changeEntry, field);
                        continue;
                    }
                    addNew.set(field, changeEntry.get(field));
                }
                addNew.set("id", key);
                if (!"oldentryid".equals(entryfield)) continue;
                addNew.set("entrylevel", (Object)0);
            }
            flag = true;
        }
        return flag;
    }

    private void setMulBaseDateValue(DynamicObject addNew, DynamicObject entry, String field) {
        DynamicObjectCollection col = entry.getDynamicObjectCollection(field);
        DynamicObjectCollection mulData = addNew.getDynamicObjectCollection(field);
        if (col != null && !col.isEmpty()) {
            DynamicObjectType type = mulData.getDynamicObjectType();
            for (DynamicObject uid : col) {
                DynamicObject userIDDy = new DynamicObject(type);
                userIDDy.set("fbasedataid", (Object)uid);
                mulData.add((Object)userIDDy);
            }
            addNew.set(field, (Object)mulData);
        }
    }
}

