/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.workcardinfo.validator;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.business.workcardinfo.CardBusinessUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class CardMaterialCommandChangeValPlugin
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntityArray = this.getDataEntities();
        String operType = this.getOperateKey();
        if (!"submit".equals(operType) && !"audit".equals(operType)) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        Date thisDate = new Date();
        String thisDateStr = sdf.format(thisDate);
        HashSet<Long> cardMaterialIDSet = new HashSet<Long>(dataEntityArray.length);
        HashSet<Long> idSet = new HashSet<Long>(dataEntityArray.length);
        for (ExtendedDataEntity dataEntity : dataEntityArray) {
            String billDateStr;
            DynamicObject obj = dataEntity.getDataEntity();
            DynamicObject createOrg = obj.getDynamicObject("org");
            Date billDate = obj.getDate("billdate");
            DynamicObject cardMaterialCmd = obj.getDynamicObject("cardmaterial");
            if (createOrg == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"CardMaterialCommandChangeValPlugin_01", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (cardMaterialCmd == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u8fdb\u884c[\u9009\u62e9\u5de5\u5361\u7269\u6599\u9700\u6c42]\u64cd\u4f5c\u3002", (String)"CardMaterialCommandChangeValPlugin_02", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (billDate == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u53d8\u66f4\u65e5\u671f\u3002", (String)"CardMaterialCommandChangeValPlugin_03", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                continue;
            }
            if ("submit".equals(operType) && (billDateStr = sdf.format(billDate)).compareTo(thisDateStr) < 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53d8\u66f4\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"CardMaterialCommandChangeValPlugin_04", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                continue;
            }
            if ("B".equals(obj.getString("changetype")) && StringUtils.isEmpty((String)obj.getString("newversion"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7248\u672c\u53d8\u66f4\u7c7b\u578b\u4e3a\u987a\u5ef6\u7248\u672c\u65f6\uff0c\u5fc5\u987b\u5f55\u5165\u65b0\u7248\u672c\u53f7\u3002", (String)"CardMaterialCommandChangeValPlugin_05", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                continue;
            }
            DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("entryentity");
            if (!obj.getBoolean("needmaterial") && entryCol != null && !entryCol.isEmpty()) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u5355\u53f7%1$s:\u5728\u672a\u52fe\u9009[\u9700\u8981\u7269\u6599]\u7684\u60c5\u51b5\u4e0b\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u5206\u5f55\u7269\u6599\u4fe1\u606f\u3002", (String)"CardMaterialCommandChangeValPlugin_13", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), obj.getString("billno")));
                continue;
            }
            Long cardMaterialID = cardMaterialCmd.getLong("id");
            if (cardMaterialIDSet.contains(cardMaterialID)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u5355\u53f7%1$s:\u5728\u5f53\u524d\u6279\u91cf\u64cd\u4f5c\u4e2d\u5df2\u5b58\u5728\u76f8\u540c\u7684\u7269\u6599\u9700\u6c42\u4fe1\u606f\u7684\u53d8\u66f4\uff0c\u8bf7\u6838\u5bf9\u672c\u6b21\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"CardMaterialCommandChangeValPlugin_07", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), obj.getString("billno")));
                continue;
            }
            cardMaterialIDSet.add(cardMaterialID);
            idSet.add(obj.get("id") == null ? 0L : obj.getLong("id"));
            Map cmdEntryMap = CardBusinessUtils.getCardMaterialCmdEntryMap((Long)cardMaterialID);
            this.entryValidata(dataEntity, entryCol, cmdEntryMap);
        }
        Set<String> existsDBSet = this.validateDB(cardMaterialIDSet, idSet);
        if (existsDBSet == null || existsDBSet.isEmpty()) {
            return;
        }
        for (ExtendedDataEntity dataEntity : dataEntityArray) {
            DynamicObject obj = dataEntity.getDataEntity();
            DynamicObject cardMaterialCmd = obj.getDynamicObject("cardmaterial");
            Long cardMaterialCmdID = cardMaterialCmd.getLong("id");
            if (!existsDBSet.contains(String.valueOf(cardMaterialCmdID))) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u5355\u53f7 %1$s \u5bf9\u5e94\u7684\u5de5\u5361\u7269\u6599\u9700\u6c42\u5b58\u5728\u8fd8\u672a\u5ba1\u6838\u7684\u53d8\u66f4\u5355\u6570\u636e\uff0c\u8bf7\u5220\u9664\u540e\u518d\u8fdb\u884c\u672c\u6b21\u64cd\u4f5c!", (String)"CardMaterialCommandChangeValPlugin_08", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), obj.getString("billno")));
        }
    }

    private void entryValidata(ExtendedDataEntity dataEntity, DynamicObjectCollection col, Map<String, List<Map<String, Object>>> cmdEntryMap) {
        int i = -1;
        HashSet<String> unquieSet = new HashSet<String>(col.size());
        DynamicObject obj = dataEntity.getDataEntity();
        Long parentMid = 0L;
        if (obj.getDynamicObject("productmaterial") != null) {
            parentMid = obj.getDynamicObject("productmaterial").getLong("id");
        }
        HashSet<Long> disableEntryIDSet = new HashSet<Long>(col.size());
        HashSet<Long> editeEntryIDSet = new HashSet<Long>(col.size());
        for (DynamicObject entryObj : col) {
            String changeRowType = entryObj.getString("rowtype");
            Long cmdEntryID = entryObj.getLong("cmdentryid");
            ++i;
            if ("A".equals(changeRowType) || "C".equals(changeRowType)) {
                Long childMid;
                String entryownertype = entryObj.getString("entryownertype");
                String entryowner = entryObj.getString("entryowner");
                if (("bd_customer".equals(entryownertype) || "bd_supplier".equals(entryownertype)) && (entryowner == null || "".equals(entryowner))) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c:%1$s \u884c\u5206\u5f55\u4f9b\u5e94\u65b9\u5f0f\u4e3a\u4f9b\u5e94\u5546\u6216\u5ba2\u6237\u65f6\uff0c\u4f9b\u5e94\u65b9\u5fc5\u586b\u3002", (String)"CardMaterialCommandChangeValPlugin_14", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i + 1));
                    continue;
                }
                String entryRespType = entryObj.getString("entryresptype");
                String entryResp = entryObj.getString("entryresp");
                if (("bd_customer".equals(entryRespType) || "bd_supplier".equals(entryRespType)) && (entryResp == null || "".equals(entryResp))) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c:%1$s \u884c\u5206\u5f55\u9884\u6253\u5355\u8d23\u4efb\u4e3a\u4f9b\u5e94\u5546\u6216\u5ba2\u6237\u65f6\uff0c\u9884\u6253\u5355\u8d23\u4efb\u65b9\u5fc5\u586b\u3002", (String)"CardMaterialCommandChangeValPlugin_15", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i + 1));
                    continue;
                }
                if (entryObj.getDate("validdate") == null) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u7684\u751f\u6548\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CardMaterialCommandChangeValPlugin_16", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i + 1));
                    continue;
                }
                if (entryObj.getDate("invaliddate") == null) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c:%1$s \u884c\u5206\u5f55\u7684\u5931\u6548\u65f6\u95f4\u4e0d\u5141\u8bb8\u4e3a\u7a7a!", (String)"CardMaterialCommandChangeValPlugin_17", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i + 1));
                    continue;
                }
                if (entryObj.getDate("validdate").after(entryObj.getDate("invaliddate"))) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c:%1$s \u884c\u5206\u5f55\u7684\u751f\u6548\u65f6\u95f4\u4e0d\u5141\u8bb8\u5927\u4e8e\u5931\u6548\u65f6\u95f4!", (String)"CardMaterialCommandChangeValPlugin_18", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i + 1));
                    continue;
                }
                if (entryObj.getDynamicObject("entrymaterial") != null && entryObj.getDynamicObject("entryprofessiona") != null) {
                    if (unquieSet.contains(entryObj.getDynamicObject("entrymaterial").getPkValue() + "_" + entryObj.getDynamicObject("entryprofessiona").getPkValue())) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c:%1$s \u884c\u5206\u5f55\u7684\u7269\u6599+\u884c\u4e1a\u5b58\u5728\u91cd\u590d\u9879!", (String)"CardMaterialCommandChangeValPlugin_19", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i + 1));
                        continue;
                    }
                    unquieSet.add(entryObj.getDynamicObject("entrymaterial").getPkValue() + "_" + entryObj.getDynamicObject("entryprofessiona").getPkValue());
                }
                if (!parentMid.equals(0L) && (childMid = Long.valueOf(entryObj.getDynamicObject("entrymaterial") == null ? 0L : entryObj.getDynamicObject("entrymaterial").getLong("id"))).equals(parentMid)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c:%1$s \u884c\u5206\u5f55\u7269\u6599\u4e0e\u5355\u5934\u4ea7\u54c1\u7269\u6599\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u3002", (String)"CardMaterialCommandChangeValPlugin_20", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i + 1));
                    continue;
                }
                if (disableEntryIDSet.contains(cmdEntryID)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c:%1$s \u884c\u5206\u5f55\u8fdb\u884c\u4e86\u5931\u6548\u7ec4\u4ef6\u64cd\u4f5c\uff0c\u4e0d\u5141\u8bb8\u540c\u65f6\u8fdb\u884c\u4fee\u6539\u3002", (String)"CardMaterialCommandChangeValPlugin_09", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i + 1));
                    continue;
                }
                editeEntryIDSet.add(cmdEntryID);
            }
            if ("D".equals(changeRowType)) {
                if (editeEntryIDSet.contains(cmdEntryID)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c:%1$s \u884c\u5206\u5f55\u8fdb\u884c\u4e86\u4fee\u6539\u7ec4\u4ef6\u64cd\u4f5c\uff0c\u4e0d\u5141\u8bb8\u540c\u65f6\u8fdb\u884c\u5931\u6548\u3002", (String)"CardMaterialCommandChangeValPlugin_10", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i + 1));
                    continue;
                }
                disableEntryIDSet.add(cmdEntryID);
            }
            if (("D".equals(changeRowType) || "C".equals(changeRowType)) && !this.existOldData(cmdEntryID, cmdEntryMap)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c:%1$s \u884c\u5206\u5f55\u5bf9\u5e94\u7684\u5de5\u5361\u7269\u6599\u9700\u6c42\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"CardMaterialCommandChangeValPlugin_11", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i + 1));
                continue;
            }
            if (!"A".equals(changeRowType) || !this.existOldDataAdd(entryObj, cmdEntryMap)) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c:%1$s \u884c\u5206\u5f55,\u7ec4\u4ef6+\u884c\u4e1a\u5df2\u7ecf\u5b58\u5728\u4e8e\u539f\u5de5\u5361\u7269\u6599\u9700\u6c42\u5355\u4e2d\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"CardMaterialCommandChangeValPlugin_12", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i + 1));
        }
    }

    private boolean existOldDataAdd(DynamicObject entryObj, Map<String, List<Map<String, Object>>> cmdEntryMap) {
        String midStr = entryObj.getDynamicObject("entrymaterial").getPkValue() + "_" + entryObj.getDynamicObject("entryprofessiona").getPkValue();
        List<Map<String, Object>> lists = cmdEntryMap.get(midStr);
        if (lists == null || lists.isEmpty()) {
            return false;
        }
        Date validdate1 = entryObj.getDate("validdate");
        Date invaliddate1 = entryObj.getDate("invaliddate");
        for (int i = 0; i < lists.size(); ++i) {
            Date invaliddate2;
            Map<String, Object> rowmap = lists.get(i);
            Date validdate2 = (Date)rowmap.get("validdate");
            if (!CardBusinessUtils.isDateUnion((Date)validdate1, (Date)invaliddate1, (Date)validdate2, (Date)(invaliddate2 = (Date)rowmap.get("invaliddate")))) continue;
            return true;
        }
        return false;
    }

    private boolean existOldData(Long cmdEntryID, Map<String, List<Map<String, Object>>> cmdEntryMap) {
        for (Map.Entry<String, List<Map<String, Object>>> cmdEntrys : cmdEntryMap.entrySet()) {
            List<Map<String, Object>> lists = cmdEntrys.getValue();
            for (int i = 0; i < lists.size(); ++i) {
                Map<String, Object> rowmap = lists.get(i);
                if (rowmap.get("entryID") == null || !Long.valueOf(rowmap.get("entryID").toString()).equals(cmdEntryID)) continue;
                return true;
            }
        }
        return false;
    }

    private Set<String> validateDB(Set<Long> cardMaterialCmdID, Set<Long> idSet) {
        HashSet<String> existsDBSet = new HashSet<String>(16);
        String selectFields = "id,cardmaterial.id cardmaterialID";
        QFilter qFilter = new QFilter("cardmaterial.id", "in", cardMaterialCmdID);
        qFilter.and(new QFilter("billstatus", "!=", (Object)"C"));
        qFilter.and(new QFilter("id", "not in", idSet));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-cardmaterialcommandchange-validatorexists", (String)"mpdm_cmatcmdchange", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"");){
            for (Row row : ds) {
                Long cardmaterialID = row.getLong("cardmaterialID");
                existsDBSet.add(String.valueOf(cardmaterialID));
            }
        }
        return existsDBSet;
    }
}

