/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.workcardinfo.validator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class CardMaterialCommandValPlugin
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntityArray = this.getDataEntities();
        String operType = this.getOperateKey();
        HashSet<Long> idSet = new HashSet<Long>(dataEntityArray.length);
        if ("save".equals(operType) || "submit".equals(operType) || "audit".equals(operType) || "enable".equals(operType)) {
            HashSet<String> set = new HashSet<String>(dataEntityArray.length);
            ExtendedDataEntity[] cardIDSet = new HashSet(dataEntityArray.length);
            HashSet<Long> orgIDSet = new HashSet<Long>(dataEntityArray.length);
            for (ExtendedDataEntity extendedDataEntity : dataEntityArray) {
                boolean needmaterial;
                DynamicObject obj = extendedDataEntity.getDataEntity();
                DynamicObject createOrg = obj.getDynamicObject("createorg");
                DynamicObject workCard = obj.getDynamicObject("workcard");
                if (createOrg == null) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"CardMaterialCommandValPlugin_0", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                    return;
                }
                if (workCard == null) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5de5\u5361\u53f7\u3002", (String)"CardMaterialCommandValPlugin_1", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                    return;
                }
                String uniqueFlag = workCard.getPkValue() + "-" + createOrg.getPkValue();
                if (set.contains(uniqueFlag)) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u5de5\u5361%1$s\uff1a\u5728\u5f53\u524d\u6279\u91cf\u64cd\u4f5c\u4e2d\u5df2\u5b58\u5728\u7269\u6599\u9700\u6c42\u4fe1\u606f\uff0c\u8bf7\u6838\u5bf9\u672c\u6b21\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"CardMaterialCommandValPlugin_2", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), workCard.getString("number")));
                    continue;
                }
                set.add(uniqueFlag);
                if (obj.getPkValue() != null && !obj.getPkValue().equals(0L)) {
                    idSet.add(obj.getLong("id"));
                }
                cardIDSet.add((Long)workCard.getPkValue());
                orgIDSet.add((Long)createOrg.getPkValue());
                if (("save".equals(operType) || "submit".equals(operType)) && obj.getString("status").equals("C")) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u5de5\u5361%1$s\uff1a\u4e0d\u5141\u8bb8\u4fee\u6539\u5df2\u5ba1\u6838\u7684\u6570\u636e\u3002", (String)"CardMaterialCommandValPlugin_3", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), workCard.getString("number")));
                    continue;
                }
                if (!"submit".equals(operType) || !(needmaterial = obj.getBoolean("needmaterial"))) continue;
                DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("entryentity");
                if (entryCol == null || entryCol.isEmpty()) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u5de5\u5361%1$s\uff1a\u9700\u8981\u7269\u6599\uff0c\u4f46\u672a\u8bbe\u7f6e\u5206\u5f55\u7269\u6599\u4fe1\u606f\u3002", (String)"CardMaterialCommandValPlugin_12", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), workCard.getString("number")));
                    continue;
                }
                this.entryValidata(extendedDataEntity, entryCol);
            }
            for (Long orgID : orgIDSet) {
                Set<String> existsDBSet = this.validateDB((Set<Long>)cardIDSet, idSet, orgID);
                if (existsDBSet == null || existsDBSet.isEmpty()) continue;
                for (ExtendedDataEntity dataEntity : dataEntityArray) {
                    DynamicObject obj = dataEntity.getDataEntity();
                    DynamicObject createOrg = obj.getDynamicObject("createorg");
                    DynamicObject workCard = obj.getDynamicObject("workcard");
                    if (!orgID.equals(createOrg.getLong("id"))) continue;
                    Long workcardid = workCard.getLong("id");
                    Long cabinconfigid = 0L;
                    if (obj.getDynamicObject("cabinconfig") != null) {
                        cabinconfigid = (Long)obj.getDynamicObject("cabinconfig").getPkValue();
                    }
                    String version = "";
                    if (obj.getString("version") != null) {
                        version = obj.getString("version");
                    }
                    String modelmpdone = "";
                    if (obj.getString("modelmpdone") != null) {
                        modelmpdone = obj.getString("modelmpdone");
                    }
                    if (existsDBSet.contains(String.valueOf(workcardid) + "_" + modelmpdone + "_" + String.valueOf(cabinconfigid) + "_" + version)) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4f7f\u7528\u7ec4\u7ec7 %1$s \u4e0b\u5b58\u5728\u5de5\u5361: %2$s \u578b\u53f7L1 \u6784\u578b \u7248\u672c\u53f7 \u5df2\u5ba1\u6838\u4e14\u53ef\u7528\u7684\u6570\u636e\uff0c\u8bf7\u81f3\u5c11\u4fee\u6539\u4e00\u9879!", (String)"CardMaterialCommandValPlugin_4", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), createOrg.getString("number"), workCard.getString("number")));
                        continue;
                    }
                    if (obj.getBoolean("fromchange")) continue;
                    String cardVersionStr = String.valueOf(workcardid) + "_" + modelmpdone + "_" + String.valueOf(cabinconfigid) + "_";
                    for (String keyString : existsDBSet) {
                        if (!keyString.startsWith(cardVersionStr)) continue;
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4f7f\u7528\u7ec4\u7ec7 %1$s \u4e0b\u5b58\u5728\u5de5\u5361: %2$s \u578b\u53f7L1 \u6784\u578b \u4e14\u5176\u5b83\u7248\u672c\u7684\u6570\u636e\uff0c\u53ea\u5141\u8bb8\u901a\u8fc7\u53d8\u66f4\u5355\u8fdb\u884c\u4fee\u6539!", (String)"CardMaterialCommandValPlugin_13", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), createOrg.getString("number"), workCard.getString("number")));
                    }
                }
            }
        }
        if ("unaudit".equals(operType)) {
            Set<Long> existsChangeIDSet;
            HashMap<Long, ExtendedDataEntity> rowMap = new HashMap<Long, ExtendedDataEntity>(dataEntityArray.length);
            for (ExtendedDataEntity dataEntity : dataEntityArray) {
                DynamicObject obj = dataEntity.getDataEntity();
                DynamicObject dynamicObject = obj.getDynamicObject("workcard");
                if (!obj.getBoolean("fromchange")) {
                    if (obj.getPkValue() == null || obj.getPkValue().equals(0L)) continue;
                    idSet.add(obj.getLong("id"));
                    rowMap.put(obj.getLong("id"), dataEntity);
                    continue;
                }
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5de5\u5361%1$s\uff1a\u5f53\u524d\u5de5\u5361\u7269\u6599\u9700\u6c42\u6765\u6e90\u4e8e\u53d8\u66f4\u5355\u5ba1\u6838\u751f\u6210\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u53cd\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"CardMaterialCommandValPlugin_14", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), dynamicObject.getString("number")));
            }
            if (!idSet.isEmpty() && !(existsChangeIDSet = this.validateExistsChange(idSet)).isEmpty()) {
                for (Map.Entry maps : rowMap.entrySet()) {
                    if (!existsChangeIDSet.contains(maps.getKey())) continue;
                    ExtendedDataEntity dataEntity = (ExtendedDataEntity)maps.getValue();
                    DynamicObject obj = dataEntity.getDataEntity();
                    DynamicObject dynamicObject = obj.getDynamicObject("workcard");
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5de5\u5361%1$s\uff1a\u5f53\u524d\u5de5\u5361\u7269\u6599\u9700\u6c42\u5df2\u7ecf\u5b58\u5728\u53d8\u66f4\u5355\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u53cd\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"CardMaterialCommandValPlugin_15", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), dynamicObject.getString("number")));
                }
            }
        }
    }

    private void entryValidata(ExtendedDataEntity dataEntity, DynamicObjectCollection col) {
        int i = 0;
        HashSet<String> unquieSet = new HashSet<String>(col.size());
        DynamicObject obj = dataEntity.getDataEntity();
        Long parentMid = 0L;
        if (obj.getDynamicObject("productmaterial") != null) {
            parentMid = obj.getDynamicObject("productmaterial").getLong("id");
        }
        for (DynamicObject entryObj : col) {
            Long childMid;
            String entryownertype = entryObj.getString("entryownertype");
            String entryowner = entryObj.getString("entryowner");
            if (("bd_customer".equals(entryownertype) || "bd_supplier".equals(entryownertype)) && (entryowner == null || "".equals(entryowner))) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c:%1$s \u884c\u5206\u5f55\u4f9b\u5e94\u65b9\u5f0f\u4e3a\u4f9b\u5e94\u5546\u6216\u5ba2\u6237\u65f6\uff0c\u4f9b\u5e94\u65b9\u5fc5\u586b\u3002", (String)"CardMaterialCommandValPlugin_5", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i + 1));
            }
            String entryRespType = entryObj.getString("entryresptype");
            String entryResp = entryObj.getString("entryresp");
            if (("bd_customer".equals(entryRespType) || "bd_supplier".equals(entryRespType)) && (entryResp == null || "".equals(entryResp))) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c:%1$s \u884c\u5206\u5f55\u9884\u6253\u5355\u8d23\u4efb\u4e3a\u4f9b\u5e94\u5546\u6216\u5ba2\u6237\u65f6\uff0c\u9884\u6253\u5355\u8d23\u4efb\u65b9\u5fc5\u586b\u3002", (String)"CardMaterialCommandValPlugin_6", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i + 1));
            }
            if (entryObj.getDate("validdate") == null) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u7684\u751f\u6548\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CardMaterialCommandValPlugin_7", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i + 1));
            }
            if (entryObj.getDate("invaliddate") == null) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u7684\u5931\u6548\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CardMaterialCommandValPlugin_8", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i + 1));
            }
            if (entryObj.getDate("validdate").after(entryObj.getDate("invaliddate"))) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u7684\u751f\u6548\u65f6\u95f4\u4e0d\u5f97\u5927\u4e8e\u5931\u6548\u65f6\u95f4\u3002", (String)"CardMaterialCommandValPlugin_9", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i + 1));
            }
            if (entryObj.getDynamicObject("entrymaterial") != null && entryObj.getDynamicObject("entryprofessiona") != null) {
                if (unquieSet.contains(entryObj.getDynamicObject("entrymaterial").getPkValue() + "_" + entryObj.getDynamicObject("entryprofessiona").getPkValue())) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c:%1$s \u884c\u5206\u5f55\u7684\u7269\u6599+\u884c\u4e1a\u5b58\u5728\u91cd\u590d\u9879!", (String)"CardMaterialCommandValPlugin_10", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i + 1));
                }
                unquieSet.add(entryObj.getDynamicObject("entrymaterial").getPkValue() + "_" + entryObj.getDynamicObject("entryprofessiona").getPkValue());
            }
            if (!parentMid.equals(0L) && (childMid = Long.valueOf(entryObj.getDynamicObject("entrymaterial") == null ? 0L : entryObj.getDynamicObject("entrymaterial").getLong("id"))).equals(parentMid)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c:%1$s \u884c\u5206\u5f55\u7269\u6599\u4e0e\u5355\u5934\u4ea7\u54c1\u7269\u6599\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u3002", (String)"CardMaterialCommandValPlugin_11", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i + 1));
            }
            ++i;
        }
    }

    private Set<String> validateDB(Set<Long> cardIDSet, Set<Long> idSet, Long orgID) {
        HashSet<String> existsDBSet = new HashSet<String>(16);
        String selectFields = "id,workcard.id workcardid,modelmpdone,cabinconfig.id cabinconfigid,version";
        QFilter qFilter = new QFilter("workcard.id", "in", cardIDSet);
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("id", "not in", idSet));
        QFilter userOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_cardmatcommand", (Long)orgID);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-cardmaterialcommand-validatorexists", (String)"mpdm_cardmatcommand", (String)selectFields, (QFilter[])new QFilter[]{qFilter, userOrgFilter}, (String)"");){
            for (Row row : ds) {
                Long workcardid = row.getLong("workcardid");
                String modelmpdone = "";
                if (row.get("modelmpdone") != null) {
                    modelmpdone = row.getString("modelmpdone");
                }
                String version = "";
                if (row.get("version") != null) {
                    version = row.getString("version");
                }
                Long cabinconfigid = 0L;
                if (row.get("cabinconfigid") != null) {
                    cabinconfigid = row.getLong("cabinconfigid");
                }
                existsDBSet.add(String.valueOf(workcardid) + "_" + modelmpdone + "_" + String.valueOf(cabinconfigid) + "_" + version);
            }
        }
        return existsDBSet;
    }

    private Set<Long> validateExistsChange(Set<Long> cardMaterialCmdID) {
        HashSet<Long> existsDBSet = new HashSet<Long>(16);
        String selectFields = "cardmaterial.id cardmaterialID";
        QFilter qFilter = new QFilter("cardmaterial.id", "in", cardMaterialCmdID);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-cardmaterialcommand-validateExistsChange", (String)"mpdm_cmatcmdchange", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"");){
            for (Row row : ds) {
                Long cardmaterialID = row.getLong("cardmaterialID");
                existsDBSet.add(cardmaterialID);
            }
        }
        return existsDBSet;
    }
}

