/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.opplugin.workscope;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bd.mpdm.business.workscope.WorkScopeHelper;
import kd.bd.mpdm.opplugin.workscope.WorkScopeSheetHandle;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.HeartBeat;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class WorkSopeImportOp
extends BatchImportPlugin {
    private static Log log = LogFactory.getLog(WorkSopeImportOp.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveExcel() {
        FileService service = FileServiceFactory.getAttachmentFileService();
        ExcelReader reader = new ExcelReader();
        Map option = this.ctx.getOption();
        for (String url : this.ctx.getAllUrls()) {
            try {
                InputStream in = service.getInputStream(url);
                Throwable throwable = null;
                try {
                    MainEntityType mainEntityType;
                    if (this.mainEntityType != null) {
                        mainEntityType = this.mainEntityType;
                    } else {
                        mainEntityType = MetadataServiceHelper.getDataEntityType((String)this.getBillFormId());
                        this.mainEntityType = this.mainEntityType;
                    }
                    MainEntityType mainEntityType2 = mainEntityType;
                    if (mainEntityType2 instanceof QueryEntityType) {
                        mainEntityType2 = ((QueryEntityType)mainEntityType2).getMainEntityType();
                    }
                    reader.read(in, (SheetHandler)new WorkScopeSheetHandle(this.ctx, mainEntityType2, url, option, new HeartBeat()));
                }
                catch (Throwable mainEntityType2) {
                    throwable = mainEntityType2;
                    throw mainEntityType2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable mainEntityType2) {
                            throwable.addSuppressed(mainEntityType2);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (Throwable e) {
                log.error(e);
                if (SystemParamServiceHelper.isShowStackTrace()) {
                    this.ctx.getLogger(url).log(Integer.valueOf(0), e);
                } else {
                    Throwable cause = e.getCause();
                    String importErrMsg = cause instanceof KDBizException ? e.getMessage() : ResManager.loadKDString((String)"\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790", (String)"WorkSopeImportOp_0", (String)"bos-import", (Object[])new Object[0]);
                    this.ctx.getLogger(url).log(Integer.valueOf(0), importErrMsg);
                }
                this.ctx.addBillData(url, new ImportBillData(new JSONObject(), 0, 0));
            }
            finally {
                this.ctx.setResolveComplete(url);
            }
        }
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        Iterator<ImportBillData> it = rowdatas.iterator();
        while (it.hasNext()) {
            String wDetail;
            HashMap<Integer, List<String>> errorMsg = new HashMap<Integer, List<String>>();
            ImportBillData rowdata = it.next();
            JSONObject data = rowdata.getData();
            JSONObject workscopetpl = (JSONObject)data.get((Object)"workscopetpl");
            String workscopetplNo = (String)workscopetpl.get((Object)"number");
            DynamicObject workScopeTel = WorkScopeHelper.queryWorkScopeTplByNo((String)workscopetplNo);
            Map<String, JSONObject> detailMap = this.getAllDetails(data, workScopeTel, errorMsg);
            if (workScopeTel == null) continue;
            String comboType = workScopeTel.getString("combotype");
            String combosymbol = workScopeTel.getString("combosymbol");
            data.put("combotype", (Object)comboType);
            data.put("combosymbol", (Object)combosymbol);
            data.put("status", (Object)"C");
            DynamicObjectCollection workCateEntries = workScopeTel.getDynamicObjectCollection("workcategory");
            JSONArray worCateEntryArray = new JSONArray(workCateEntries.size());
            List workCateIds = workCateEntries.stream().filter(i -> {
                DynamicObject wsworkCate = i.getDynamicObject("workcate");
                return wsworkCate != null && StringUtils.equals((CharSequence)"1", (CharSequence)wsworkCate.getString("enable"));
            }).map(i -> i.getDynamicObject("workcate").getPkValue()).collect(Collectors.toList());
            DynamicObject[] workCates = WorkScopeHelper.queryWorkCategoryByPks(workCateIds);
            HashMap<Object, DynamicObject> workcategoryMap = new HashMap<Object, DynamicObject>(workCateIds.size());
            for (DynamicObject object : workCates) {
                workcategoryMap.put(object.getPkValue(), object);
            }
            StringBuilder wsDetailString = new StringBuilder();
            for (DynamicObject workCateEntry : workCateEntries) {
                DynamicObject workCate;
                JSONObject workCateEntryObj = new JSONObject();
                JSONObject workCateObj = new JSONObject();
                JSONArray detailEntryObjs = new JSONArray();
                DynamicObject worktplCate = workCateEntry.getDynamicObject("workcate");
                if (worktplCate == null || (workCate = (DynamicObject)workcategoryMap.get(worktplCate.getPkValue())) == null) continue;
                String workCateName = workCate.getString("name");
                DynamicObjectCollection workCateDetailEntries = workCate.getDynamicObjectCollection("detailentry");
                workCateObj.put("importprop", (Object)"id");
                workCateObj.put("number", (Object)workCate.getString("number"));
                workCateObj.put("id", workCate.getPkValue());
                workCateEntryObj.put("priority", (Object)workCateEntry.getInt("priority"));
                String connector = workCateEntry.getString("connector");
                workCateEntryObj.put("connector", (Object)connector);
                StringJoiner typeDesc = new StringJoiner(combosymbol);
                for (DynamicObject workCateDetailEntry : workCateDetailEntries) {
                    DynamicObject workCateDetail = workCateDetailEntry.getDynamicObject("workdetail");
                    String detailName = workCateDetail.getString("name");
                    String detailNo = workCateDetail.getString("number");
                    JSONObject detail = detailMap.get(detailNo);
                    if (detail != null) {
                        detail.put("select", (Object)"1");
                        detailEntryObjs.add((Object)detail);
                        detailMap.remove(detailNo);
                        typeDesc.add(detailName);
                        continue;
                    }
                    JSONObject workCateDetailEntryObj = new JSONObject(4);
                    JSONObject workCateDetailObj = new JSONObject(2);
                    workCateDetailObj.put("importprop", (Object)"number");
                    workCateDetailObj.put("number", (Object)detailNo);
                    workCateDetailEntryObj.put("details", (Object)workCateDetailObj);
                    detailEntryObjs.add((Object)workCateDetailEntryObj);
                }
                String typeDetail = "";
                typeDetail = typeDesc.length() > 0 && StringUtils.equals((CharSequence)"B", (CharSequence)comboType) ? workCateName + connector + typeDesc.toString() : typeDesc.toString();
                if (typeDetail.length() > 0) {
                    wsDetailString.append(typeDetail).append(connector);
                    workCateEntryObj.put("typedesc_tag", (Object)typeDetail);
                    if (typeDesc.length() > 255) {
                        workCateEntryObj.put("typedesc", (Object)typeDetail.substring(0, 255));
                    } else {
                        workCateEntryObj.put("typedesc", (Object)typeDetail);
                    }
                }
                workCateEntryObj.put("workcate", (Object)workCateObj);
                workCateEntryObj.put("workdetail", (Object)detailEntryObjs);
                worCateEntryArray.add((Object)workCateEntryObj);
            }
            if (detailMap.size() > 0) {
                for (JSONObject detailEntry : detailMap.values()) {
                    JSONObject detail = detailEntry.getJSONObject("details");
                    this.addErrorMsg(errorMsg, detailEntry.getInteger("rowNum"), String.format(ResManager.loadKDString((String)"\u5de5\u4f5c\u5185\u5bb9\u6a21\u677f:%1$s\u4e0b\u4e0d\u5b58\u5728\u660e\u7ec6\u7f16\u7801\uff1a%2$s\u6570\u636e\u3002", (String)"WorkSopeImportOp_1", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), workscopetplNo, detail.get((Object)"number")));
                }
            }
            if (errorMsg.size() > 0) {
                this.loggerErrorInfo(logger, errorMsg);
                it.remove();
                continue;
            }
            data.put("workcategory", (Object)worCateEntryArray);
            if (wsDetailString.length() > 0) {
                wsDetailString.deleteCharAt(wsDetailString.length() - 1);
            }
            if ((wDetail = wsDetailString.toString()).length() > 255) {
                data.put("contentdetail", (Object)wDetail.substring(0, 255));
            } else {
                data.put("contentdetail", (Object)wDetail);
            }
            data.put("contentdetail_tag", (Object)wDetail);
        }
        return super.save(rowdatas, logger);
    }

    public Map<String, JSONObject> getAllDetails(JSONObject data, DynamicObject workScopeTel, Map<Integer, List<String>> errorMsg) {
        List workcategorys = (List)data.get((Object)"workcategory");
        HashMap<String, JSONObject> detailMap = new HashMap<String, JSONObject>(10);
        for (Map workcategory : workcategorys) {
            JSONObject workcate = (JSONObject)workcategory.get("workcate");
            String cateNo = (String)workcate.get("number");
            if (workScopeTel == null && StringUtils.equals((CharSequence)"EMPTY_DATA", (CharSequence)cateNo)) {
                workcate.put("number", null);
                continue;
            }
            List detailEntrys = (List)workcategory.get("workdetail");
            if (detailEntrys == null) continue;
            for (JSONObject detailEntry : detailEntrys) {
                JSONObject detail = (JSONObject)detailEntry.get((Object)"details");
                if (detail == null) continue;
                String detailNo = (String)detail.get((Object)"number");
                if (detailMap.containsKey(detailNo)) {
                    this.addErrorMsg(errorMsg, detailEntry.getInteger("rowNum"), String.format(ResManager.loadKDString((String)"\u540c\u4e00\u5de5\u4f5c\u5185\u5bb9\u5b58\u5728\u76f8\u540c\u660e\u7ec6\u540d\u79f0.\u7f16\u7801\uff1a%s\u3002", (String)"WorkSopeImportOp_2", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), detailNo));
                }
                detailMap.put(detailNo, detailEntry);
            }
        }
        return detailMap;
    }

    public void addErrorMsg(Map<Integer, List<String>> errorMsg, Integer index, String msg) {
        List msgs = errorMsg.computeIfAbsent(index, key -> new ArrayList(5));
        msgs.add(msg);
    }

    private void loggerErrorInfo(ImportLogger logger, Map<Integer, List<String>> errorMsg) {
        StringJoiner msg = new StringJoiner("\n");
        if (errorMsg.size() > 0) {
            List idxs = errorMsg.keySet().stream().sorted().collect(Collectors.toList());
            int startIndex = (Integer)idxs.get(0);
            for (Integer idx : idxs) {
                List<String> msgs = errorMsg.get(idx);
                if (msgs == null) continue;
                StringBuilder rowMsg = new StringBuilder();
                if (idx != startIndex) {
                    rowMsg.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c", (String)"WorkSopeImportOp_3", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), idx + 1));
                }
                for (String s : msgs) {
                    rowMsg.append(s);
                }
                msg.add(rowMsg);
            }
            logger.logAll(Integer.valueOf(startIndex), new String[]{msg.toString()}).fail();
        }
    }
}

