/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.bombasedata;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.form.operate.MutexHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class ReplaceUpdateBomUtils {
    public static final DBRoute scmDBRoute = new DBRoute("scm");
    private static final String EDIT = "modify";
    public static String ENTITY_BOMENTRY = "pdm_mftbomentry";

    public static Map<Long, String> getBomIdMap(Set<Long> bomentryIdSet) {
        HashMap<Long, String> bomMap = new HashMap<Long, String>(16);
        SqlBuilder sql = new SqlBuilder();
        sql.append(" select distinct h.fid,h.fnumber from t_pdm_mftbomentry d  inner join t_pdm_mftbom h on h.fid = d.fid where ", new Object[0]);
        sql.appendIn("d.fentryid", bomentryIdSet.toArray());
        try (DataSet ds = DB.queryDataSet((String)(ReplaceUpdateBomUtils.class.getName() + "_getBomIds"), (DBRoute)scmDBRoute, (SqlBuilder)sql);){
            while (ds.hasNext()) {
                Row arow = ds.next();
                bomMap.put(arow.getLong("fid"), arow.getString("fnumber"));
            }
        }
        return bomMap;
    }

    public static String batchRequire(Map<Long, String> bomMaps, Set<Long> lockSuccessfulIdSet) {
        StringBuilder lockMsg = new StringBuilder();
        for (Map.Entry<Long, String> entry : bomMaps.entrySet()) {
            Long key = entry.getKey();
            String value = String.format(ResManager.loadKDString((String)"BOM\u7f16\u53f7\u201c%1$s\u201d\u3002", (String)"ReplaceUpdateBomUtils_01", (String)"bd-mpdm-common", (Object[])new Object[0]), entry.getValue());
            boolean mutex = MutexHelper.require((String)"pdm_mftbom", (Object)key, (String)EDIT, (boolean)true, (StringBuilder)lockMsg);
            if (mutex) {
                lockSuccessfulIdSet.add(key);
                continue;
            }
            for (Long successId : lockSuccessfulIdSet) {
                MutexHelper.release((String)"pdm_mftbom", (String)EDIT, (String)String.valueOf(successId));
            }
            lockSuccessfulIdSet.clear();
            return String.join((CharSequence)"\uff1a ", value, lockMsg.toString());
        }
        return lockMsg.toString();
    }

    public static void releaseLock(Set<Long> ids) {
        if (ids.isEmpty()) {
            return;
        }
        for (Long id : ids) {
            MutexHelper.release((String)"pdm_mftbom", (String)EDIT, (String)String.valueOf(id));
        }
    }

    public static DynamicObjectCollection queryBomEntryById(Set<Long> bomentryIdSet) {
        String selectFields = ReplaceUpdateBomUtils.getBomEntrySelectProperties();
        QFilter qfilter = new QFilter("entryid", "in", bomentryIdSet);
        return QueryServiceHelper.query((String)ENTITY_BOMENTRY, (String)selectFields, (QFilter[])new QFilter[]{qfilter}, (String)"bomid,entryseq");
    }

    private static String getBomEntrySelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("entryid ");
        sb.append(",entryvaliddate ");
        sb.append(",entryinvaliddate ");
        sb.append(",entryreplaceplan");
        sb.append(",entryisreplace");
        sb.append(",entryreplacegroup");
        sb.append(",entrymaterialid");
        sb.append(",entryversion");
        sb.append(",entryqtynumerator");
        sb.append(",entryqtydenominator");
        sb.append(",bomid");
        sb.append(",entryisjumplevel");
        sb.append(",auxpropertyid");
        sb.append(",entrytype");
        sb.append(",entryseq");
        return sb.toString();
    }

    public static boolean isIntBigdecimal(BigDecimal value) {
        int valueInt = value.intValue();
        return value.compareTo(new BigDecimal(valueInt)) == 0;
    }

    private static String genReplaceGroupNo(Long entryId, int seq) {
        return entryId + "_" + seq;
    }

    public static void updateBomEntryReplaceGroup(Set<Long> bomIdSet) {
        if (bomIdSet == null || bomIdSet.isEmpty()) {
            return;
        }
        HashMap<String, String> groupMap = new HashMap<String, String>(64);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(64);
        HashSet<String> execIdSet = new HashSet<String>(64);
        String updateSql = " update t_pdm_mftbomentry set fentryreplacegroup = ? where fentryid = ? ";
        StringBuilder sb = new StringBuilder();
        sb.append(" select d.fentryid,d.freplaceplanid ,d.fentryreplacegroup ,d.fentrymatid ,d.fauxpropertyid ,d.fversionid,h.fid,d.fseq ");
        sb.append(" from t_pdm_mftbom h ");
        sb.append(" inner join t_pdm_mftbomentry d on h.fid = d.fid  ");
        sb.append(" where h.fid in( ");
        int size = 0;
        for (Long bomId : bomIdSet) {
            if (++size > 1) {
                sb.append(",");
            }
            sb.append("'").append(bomId).append("'");
        }
        sb.append(" ) ");
        sb.append(" and d.freplaceplanid > 0 ");
        sb.append(" and (d.fentryreplacegroup = ' ' or d.fentryreplacegroup = '' or d.fentryreplacegroup is null) ");
        sb.append(" order by h.fid,d.fseq ");
        try (DataSet ds = DB.queryDataSet((String)ReplaceUpdateBomUtils.class.getName(), (DBRoute)scmDBRoute, (String)sb.toString());){
            while (ds.hasNext()) {
                String rowKeys;
                Row arow = ds.next();
                long entryId = arow.getLong("fentryid");
                long freplaceplanid = arow.getLong("freplaceplanid");
                long fentrymatid = arow.getLong("fentrymatid");
                long fauxpropertyid = arow.getLong("fauxpropertyid");
                long fversionid = arow.getLong("fversionid");
                long fid = arow.getLong("fid");
                int seq = arow.getInteger("fseq");
                String groupKeys = fid + "_" + freplaceplanid;
                String newGroupno = (String)groupMap.get(groupKeys);
                if (StringUtils.isEmpty((String)newGroupno)) {
                    newGroupno = ReplaceUpdateBomUtils.genReplaceGroupNo(entryId, seq);
                    groupMap.put(groupKeys, newGroupno);
                }
                if (!execIdSet.add(rowKeys = groupKeys + "_" + fentrymatid + "_" + fversionid + "_" + fauxpropertyid)) {
                    newGroupno = ReplaceUpdateBomUtils.genReplaceGroupNo(entryId, seq);
                    groupMap.put(groupKeys, newGroupno);
                }
                paramList.add(new Object[]{newGroupno, entryId});
            }
        }
        if (!paramList.isEmpty()) {
            DB.executeBatch((DBRoute)scmDBRoute, (String)updateSql, paramList);
        }
    }
}

