/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.botp;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class BotpRowLinkUtils {
    private static final DBRoute scmDBRoute = new DBRoute("scm");
    private static final DBRoute sysDBRoute = new DBRoute("sys");

    public static void fixRowLink(String targetEntityNumber, String targetEntryKey, String srcEntityNumber, String srcEntryFld, String srcRowSeqFld, Object targetBillId, String srcBillNo) {
        if (StringUtils.isNotBlank((CharSequence)targetEntityNumber) && StringUtils.isNotBlank((CharSequence)targetEntryKey) && StringUtils.isNotBlank((CharSequence)srcEntityNumber) && StringUtils.isNotBlank((CharSequence)srcEntryFld) && StringUtils.isNotBlank((CharSequence)srcRowSeqFld) && StringUtils.isNotBlank((CharSequence)srcBillNo) && null != targetBillId) {
            DynamicObject targetBillObj = BusinessDataServiceHelper.loadSingle((Object)targetBillId, (String)targetEntityNumber);
            TableDefine targetTableDefine = EntityMetadataCache.loadTableDefine((String)targetEntityNumber, (String)targetEntryKey);
            TableDefine srcTableDefine = EntityMetadataCache.loadTableDefine((String)srcEntityNumber, (String)srcEntryFld);
            DynamicObject[] sourceBillObjs = BotpRowLinkUtils.loadSourceBill(srcTableDefine, srcBillNo);
            BotpRowLinkUtils.createLinkEntity(targetTableDefine, targetBillObj, srcTableDefine, sourceBillObjs, srcRowSeqFld);
            SaveServiceHelper.saveOperate((String)targetEntityNumber, (DynamicObject[])new DynamicObject[]{targetBillObj}, (OperateOption)OperateOption.create());
        }
    }

    private static DynamicObject[] loadSourceBill(TableDefine srcTableDefine, String srcBillNo) {
        BillEntityType sourceMainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)srcTableDefine.getEntityNumber());
        HashSet<String> selectFields = new HashSet<String>();
        selectFields.add("id");
        selectFields.add(sourceMainType.getBillNo());
        selectFields.add(srcTableDefine.getEntityKey() + ".id");
        selectFields.add(srcTableDefine.getEntityKey() + ".seq");
        QFilter filter = new QFilter(sourceMainType.getBillNo(), "=", (Object)srcBillNo);
        DynamicObject[] sourceBillObjs = BusinessDataServiceHelper.load((String)srcTableDefine.getEntityNumber(), (String)StringUtils.join((Object[])selectFields.toArray(), (String)","), (QFilter[])new QFilter[]{filter});
        return sourceBillObjs;
    }

    private static void createLinkEntity(TableDefine targetTableDefine, DynamicObject targetBillObj, TableDefine srcTableDefine, DynamicObject[] sourceBillObjs, String srcRowSeqFld) {
        Object[] srcRowId;
        HashMap<Integer, Object[]> srcRowIds = new HashMap<Integer, Object[]>();
        for (DynamicObject srcObj : sourceBillObjs) {
            DynamicObjectCollection srcRows = srcObj.getDynamicObjectCollection(srcTableDefine.getEntityKey());
            for (DynamicObject srcRow : srcRows) {
                Integer srcRowSeq = srcRow.getInt("seq");
                srcRowId = new Object[]{srcObj.getPkValue(), srcRow.getPkValue()};
                srcRowIds.put(srcRowSeq, srcRowId);
            }
        }
        Long srcTableId = srcTableDefine.getTableId();
        String lkEntryKey = targetTableDefine.getEntityKey() + "_lk";
        DynamicObjectCollection targetRows = targetBillObj.getDynamicObjectCollection(targetTableDefine.getEntityKey());
        for (DynamicObject targetRow : targetRows) {
            Integer srcRowSeq;
            DynamicObjectCollection linkRows = targetRow.getDynamicObjectCollection(lkEntryKey);
            if (!linkRows.isEmpty() || !srcRowIds.containsKey(srcRowSeq = Integer.valueOf(targetRow.getInt(srcRowSeqFld)))) continue;
            DynamicObject linkRow = new DynamicObject(linkRows.getDynamicObjectType());
            linkRows.add((Object)linkRow);
            srcRowId = (Object[])srcRowIds.get(srcRowSeq);
            linkRow.set(lkEntryKey + "_stableid", (Object)srcTableId);
            linkRow.set(lkEntryKey + "_sbillid", srcRowId[0]);
            linkRow.set(lkEntryKey + "_sid", srcRowId[1]);
        }
    }

    public static void fixRowLinkDB(String targetEntityNumber, String targetEntryKey, String srcEntityNumber, String srcEntryFld, String srcRowSeqFld, Long targetBillId, Long srcBillID) {
        if (StringUtils.isNotBlank((CharSequence)targetEntityNumber) && StringUtils.isNotBlank((CharSequence)targetEntryKey) && StringUtils.isNotBlank((CharSequence)srcEntityNumber) && StringUtils.isNotBlank((CharSequence)srcEntryFld) && StringUtils.isNotBlank((CharSequence)srcRowSeqFld) && !BotpRowLinkUtils.isNullLong(srcBillID) && null != targetBillId) {
            DynamicObject targetBillObj = BusinessDataServiceHelper.loadSingle((Object)targetBillId, (String)targetEntityNumber);
            TableDefine targetTableDefine = EntityMetadataCache.loadTableDefine((String)targetEntityNumber, (String)targetEntryKey);
            TableDefine srcTableDefine = EntityMetadataCache.loadTableDefine((String)srcEntityNumber, (String)srcEntryFld);
            String targetTcTable = BotpRowLinkUtils.getTcTable(targetEntityNumber);
            String targetLinkTable = BotpRowLinkUtils.getLinkTable(targetTableDefine, targetEntityNumber);
            Long targetEntryTableID = targetTableDefine.getTableId();
            Long srcEntryTableID = srcTableDefine.getTableId();
            Long targetTableID = EntityMetadataCache.loadMainTableDefine((String)targetEntityNumber).getTableId();
            Long srcTableID = EntityMetadataCache.loadMainTableDefine((String)srcEntityNumber).getTableId();
            ORM orm = ORM.create();
            DynamicObject[] sourceBillObjs = BotpRowLinkUtils.loadSourceBillByID(srcTableDefine, srcBillID);
            HashMap<Integer, Object[]> srcRowIds = new HashMap<Integer, Object[]>();
            for (DynamicObject srcObj : sourceBillObjs) {
                DynamicObjectCollection srcRows = srcObj.getDynamicObjectCollection(srcTableDefine.getEntityKey());
                for (DynamicObject srcRow : srcRows) {
                    Integer srcRowSeq = srcRow.getInt("seq");
                    Object[] srcRowId = new Object[]{srcObj.getPkValue(), srcRow.getPkValue()};
                    srcRowIds.put(srcRowSeq, srcRowId);
                }
            }
            String lkEntryKey = targetTableDefine.getEntityKey() + "_lk";
            DynamicObjectCollection targetRows = targetBillObj.getDynamicObjectCollection(targetTableDefine.getEntityKey());
            HashSet<String> executeSet = new HashSet<String>(16);
            String keyString = null;
            ArrayList<Object[]> paramList1 = new ArrayList<Object[]>(16);
            ArrayList<Object[]> paramList2 = new ArrayList<Object[]>(16);
            ArrayList<Object[]> paramList3 = new ArrayList<Object[]>(16);
            for (DynamicObject targetRow : targetRows) {
                DynamicObjectCollection linkRows = targetRow.getDynamicObjectCollection(lkEntryKey);
                if (!linkRows.isEmpty()) continue;
                Long tBillEntryID = (Long)targetRow.getPkValue();
                Integer srcRowSeq = targetRow.getInt(srcRowSeqFld);
                if (!srcRowIds.containsKey(srcRowSeq)) continue;
                Object[] srcRowId = (Object[])srcRowIds.get(srcRowSeq);
                Long srcBillId = Long.parseLong(srcRowId[0].toString());
                Long srcBillEntryId = Long.parseLong(srcRowId[1].toString());
                keyString = BotpRowLinkUtils.getKeySting("1", srcBillId, targetBillId, "", "");
                if (executeSet.add(keyString)) {
                    BotpRowLinkUtils.addBilltrackerData(srcTableID, srcBillId, targetTableID, targetBillId, orm, paramList1);
                }
                if (executeSet.add(keyString = BotpRowLinkUtils.getKeySting("2", srcBillId, targetBillId, srcBillEntryId, tBillEntryID)) && !BotpRowLinkUtils.isNullString(targetLinkTable)) {
                    BotpRowLinkUtils.addLinkTableData(targetLinkTable, srcEntryTableID, srcBillId, srcBillEntryId, tBillEntryID, srcRowSeq, paramList2);
                }
                if (!executeSet.add(keyString = BotpRowLinkUtils.getKeySting("3", srcBillId, targetBillId, srcBillEntryId, tBillEntryID)) || BotpRowLinkUtils.isNullString(targetTcTable)) continue;
                BotpRowLinkUtils.addTcTableData(targetTcTable, srcEntryTableID, srcBillId, srcBillEntryId, targetEntryTableID, targetBillId, tBillEntryID, paramList3);
            }
            if (!paramList1.isEmpty()) {
                BotpRowLinkUtils.insertBilltrackerData(paramList1);
            }
            if (!paramList2.isEmpty()) {
                BotpRowLinkUtils.insertLinkTableData(targetLinkTable, paramList2);
            }
            if (!paramList3.isEmpty()) {
                BotpRowLinkUtils.insertTcTableData(targetTcTable, paramList3);
            }
        }
    }

    private static String getKeySting(String atype, Object obj1, Object obj2, Object obj3, Object obj4) {
        StringBuilder bf = new StringBuilder(100);
        bf.append(atype);
        bf.append('_');
        bf.append(obj1);
        bf.append('_');
        bf.append(obj2);
        bf.append('_');
        bf.append(obj3);
        bf.append('_');
        bf.append(obj4);
        return bf.toString();
    }

    private static void addBilltrackerData(Long stableid, Long sbillid, Long ttableid, Long tbillid, ORM orm, List<Object[]> paramList) {
        if (!BotpRowLinkUtils.isExistsBilltrackerData(stableid, sbillid, ttableid, tbillid)) {
            Long trackID = orm.genLongId("botp_billtracker");
            Object[] objects = new Object[]{trackID, stableid, sbillid, ttableid, tbillid, new Date()};
            paramList.add(objects);
        }
    }

    private static boolean isExistsBilltrackerData(Long stableid, Long sbillid, Long ttableid, Long tbillid) {
        StringBuilder bf = new StringBuilder(200);
        bf.append(" select fid from t_botp_billtracker where fsbillid = ? and  ftbillid = ? and fstableid = ? and fttableid = ?  ");
        try (DataSet ds = DB.queryDataSet((String)"mmc-BotpRowLinkUtils-isExistsBilltrackerData", (DBRoute)sysDBRoute, (String)bf.toString(), (Object[])new Long[]{sbillid, tbillid, stableid, ttableid});){
            boolean bl = ds.hasNext();
            return bl;
        }
    }

    private static void insertBilltrackerData(List<Object[]> paramList) {
        try (TXHandle txHandle = TX.requiresNew();){
            StringBuilder bf = new StringBuilder(200);
            bf.append(" insert into t_botp_billtracker(fid,fstableid,fsbillid,fttableid,ftbillid,fcreatetime) ");
            bf.append(" values(?,?,?,?,?,?) ");
            DB.executeBatch((DBRoute)sysDBRoute, (String)bf.toString(), paramList);
        }
    }

    private static void addLinkTableData(String lkTableName, Long stableid, Long sbillid, Long sbillEntryid, Long tbillEntryid, int seq, List<Object[]> paramList) {
        if (!BotpRowLinkUtils.isExistsLinkTableData(lkTableName, sbillEntryid, tbillEntryid)) {
            Long linkID = DBServiceHelper.genGlobalLongId();
            Object[] objects = new Object[]{tbillEntryid, linkID, seq, stableid, sbillid, sbillEntryid};
            paramList.add(objects);
        }
    }

    private static boolean isExistsLinkTableData(String lkTableName, Long sbillEntryid, Long tbillEntryid) {
        StringBuilder bf = new StringBuilder(150);
        bf.append(" select fpkid from ").append(lkTableName).append(" where fentryid = ? and  fsid = ? ");
        try (DataSet ds = DB.queryDataSet((String)"mmc-BotpRowLinkUtils-isExistsLinkTableData", (DBRoute)scmDBRoute, (String)bf.toString(), (Object[])new Long[]{tbillEntryid, sbillEntryid});){
            boolean bl = ds.hasNext();
            return bl;
        }
    }

    private static void insertLinkTableData(String lkTableName, List<Object[]> paramList) {
        StringBuilder bf = new StringBuilder(100);
        bf.append(" insert into ").append(lkTableName).append("(fentryid,fpkid,fseq,fstableid,fsbillid,fsid) ");
        bf.append(" values(?,?,?,?,?,?) ");
        DB.executeBatch((DBRoute)scmDBRoute, (String)bf.toString(), paramList);
    }

    private static void addTcTableData(String tcTableName, Long stableid, Long sbillid, Long sbillEntryid, Long ttableid, Long tbillid, Long tbillEntryid, List<Object[]> paramList) {
        if (!BotpRowLinkUtils.isExistsTcTableData(tcTableName, sbillEntryid, tbillEntryid)) {
            Long tcID = DBServiceHelper.genGlobalLongId();
            Object[] objects = new Object[]{tcID, tbillid, ttableid, tbillEntryid, sbillid, stableid, sbillEntryid};
            paramList.add(objects);
        }
    }

    private static boolean isExistsTcTableData(String tcTableName, Long sbillEntryid, Long tbillEntryid) {
        StringBuilder bf = new StringBuilder(100);
        bf.append(" select fid from ").append(tcTableName).append(" where ftid = ? and  fsid = ? ");
        try (DataSet ds = DB.queryDataSet((String)"mmc-BotpRowLinkUtils-isExistsLinkTableData", (DBRoute)scmDBRoute, (String)bf.toString(), (Object[])new Long[]{tbillEntryid, sbillEntryid});){
            boolean bl = ds.hasNext();
            return bl;
        }
    }

    private static void insertTcTableData(String tcTableName, List<Object[]> paramList) {
        StringBuilder bf = new StringBuilder(100);
        bf.append(" insert into ").append(tcTableName).append("(fid,ftbillid,fttableid,ftid,fsbillid,fstableid,fsid) ");
        bf.append(" values(?,?,?,?,?,?,?) ");
        DB.executeBatch((DBRoute)scmDBRoute, (String)bf.toString(), paramList);
    }

    private static String getLinkTable(TableDefine tableDefine, String entityNumber) {
        LinkSetElement targgetLinkSet = ConvertMetaServiceHelper.loadLinkSet((String)entityNumber);
        String lkEntryKey = tableDefine.getEntityKey() + "_lk";
        List lkitems = targgetLinkSet.getItems();
        for (int i = 0; i < lkitems.size(); ++i) {
            if (!((LinkSetItemElement)lkitems.get(i)).getLinkEntityKey().equals(lkEntryKey)) continue;
            return ((LinkSetItemElement)lkitems.get(i)).getTableName();
        }
        return "";
    }

    private static String getTcTable(String entityNumber) {
        LinkSetElement targgetLinkSet = ConvertMetaServiceHelper.loadLinkSet((String)entityNumber);
        return targgetLinkSet.getTrackerTable();
    }

    private static DynamicObject[] loadSourceBillByID(TableDefine srcTableDefine, Long srcBillID) {
        BillEntityType sourceMainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)srcTableDefine.getEntityNumber());
        HashSet<String> selectFields = new HashSet<String>(10);
        selectFields.add("id");
        selectFields.add(sourceMainType.getBillNo());
        selectFields.add(srcTableDefine.getEntityKey() + ".id");
        selectFields.add(srcTableDefine.getEntityKey() + ".seq");
        QFilter filter = new QFilter(sourceMainType.getPrimaryKey().getName(), "=", (Object)srcBillID);
        DynamicObject[] sourceBillObjs = BusinessDataServiceHelper.load((String)srcTableDefine.getEntityNumber(), (String)StringUtils.join((Object[])selectFields.toArray(), (String)","), (QFilter[])new QFilter[]{filter});
        return sourceBillObjs;
    }

    private static boolean isNullLong(Long obj) {
        return obj == null || obj.equals(0L);
    }

    private static boolean isNullInt(int obj) {
        return obj == 0;
    }

    private static boolean isNullString(String obj) {
        return obj == null || "".equals(obj);
    }

    private static boolean isNullList(List obj) {
        return obj == null || obj.isEmpty();
    }

    private static Long getLongFromMap(Map<String, Object> aMap, String keyField) {
        Object id = aMap.get(keyField);
        return id == null ? 0L : Long.parseLong(id.toString());
    }

    private static int getIntFromMap(Map<String, Object> aMap, String keyField) {
        Object id = aMap.get(keyField);
        return id == null ? 0 : (Integer)id;
    }

    public static void batchFixRowLinkDB(String targetEntityNumber, String targetEntryKey, String srcEntityNumber, String srcEntryKey, List<Map<String, Object>> linkList) {
        if (StringUtils.isNotBlank((CharSequence)targetEntityNumber) && StringUtils.isNotBlank((CharSequence)targetEntryKey) && StringUtils.isNotBlank((CharSequence)srcEntityNumber) && StringUtils.isNotBlank((CharSequence)srcEntryKey) && !BotpRowLinkUtils.isNullList(linkList)) {
            TableDefine targetTableDefine = EntityMetadataCache.loadTableDefine((String)targetEntityNumber, (String)targetEntryKey);
            TableDefine srcTableDefine = EntityMetadataCache.loadTableDefine((String)srcEntityNumber, (String)srcEntryKey);
            String targetTcTable = BotpRowLinkUtils.getTcTable(targetEntityNumber);
            String targetLinkTable = BotpRowLinkUtils.getLinkTable(targetTableDefine, targetEntityNumber);
            Long targetEntryTableID = targetTableDefine.getTableId();
            Long srcEntryTableID = srcTableDefine.getTableId();
            Long targetTableID = EntityMetadataCache.loadMainTableDefine((String)targetEntityNumber).getTableId();
            Long srcTableID = EntityMetadataCache.loadMainTableDefine((String)srcEntityNumber).getTableId();
            ORM orm = ORM.create();
            HashSet<String> executeSet = new HashSet<String>(16);
            String keyString = null;
            ArrayList<Object[]> paramList1 = new ArrayList<Object[]>(16);
            ArrayList<Object[]> paramList2 = new ArrayList<Object[]>(16);
            ArrayList<Object[]> paramList3 = new ArrayList<Object[]>(16);
            for (int i = 0; i < linkList.size(); ++i) {
                Map<String, Object> linkMap = linkList.get(i);
                Long sbillid = BotpRowLinkUtils.getLongFromMap(linkMap, "sbillid");
                Long sbillentryid = BotpRowLinkUtils.getLongFromMap(linkMap, "sbillentryid");
                Long tbillid = BotpRowLinkUtils.getLongFromMap(linkMap, "tbillid");
                Long tbillentryid = BotpRowLinkUtils.getLongFromMap(linkMap, "tbillentryid");
                int tseq = BotpRowLinkUtils.getIntFromMap(linkMap, "tseq");
                if (BotpRowLinkUtils.isNullLong(sbillid) || BotpRowLinkUtils.isNullLong(sbillentryid) || BotpRowLinkUtils.isNullLong(tbillid) || BotpRowLinkUtils.isNullLong(tbillentryid) || BotpRowLinkUtils.isNullInt(tseq)) continue;
                keyString = BotpRowLinkUtils.getKeySting("1", sbillid, tbillid, "", "");
                if (executeSet.add(keyString)) {
                    BotpRowLinkUtils.addBilltrackerData(srcTableID, sbillid, targetTableID, tbillid, orm, paramList1);
                }
                if (executeSet.add(keyString = BotpRowLinkUtils.getKeySting("2", sbillid, tbillid, sbillentryid, tbillentryid)) && !BotpRowLinkUtils.isNullString(targetLinkTable)) {
                    BotpRowLinkUtils.addLinkTableData(targetLinkTable, srcEntryTableID, sbillid, sbillentryid, tbillentryid, tseq, paramList2);
                }
                if (!executeSet.add(keyString = BotpRowLinkUtils.getKeySting("3", sbillid, tbillid, sbillentryid, tbillentryid)) || BotpRowLinkUtils.isNullString(targetTcTable)) continue;
                BotpRowLinkUtils.addTcTableData(targetTcTable, srcEntryTableID, sbillid, sbillentryid, targetEntryTableID, tbillid, tbillentryid, paramList3);
            }
            if (!paramList1.isEmpty()) {
                BotpRowLinkUtils.insertBilltrackerData(paramList1);
            }
            if (!paramList2.isEmpty()) {
                BotpRowLinkUtils.insertLinkTableData(targetLinkTable, paramList2);
            }
            if (!paramList3.isEmpty()) {
                BotpRowLinkUtils.insertTcTableData(targetTcTable, paramList3);
            }
        }
    }
}

