/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.business;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.common.utils.MulBaseDataUtils;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;

public class BusiSyschFieldUtil {
    private static final String algokey = BusiSyschFieldUtil.class.getName();
    private static final String FIELD_TYPE = "BasedataProp";

    public static Boolean isNewCreate(IFormView view) {
        Long pkValue;
        Boolean result = Boolean.TRUE;
        DynamicObject entity = view.getModel().getDataEntity();
        if (entity != null && (pkValue = (Long)entity.getPkValue()) != null && pkValue != 0L) {
            IDataEntityType dataEntityType = entity.getDataEntityType();
            String entityName = dataEntityType.getName();
            return !QueryServiceHelper.exists((String)entityName, (Object)pkValue);
        }
        return result;
    }

    public static Long getSysField(String targetEntity, Long pkValue) {
        boolean exists;
        Long targetResult = 0L;
        if (pkValue != null && pkValue != 0L && (exists = QueryServiceHelper.exists((String)targetEntity, (Object)pkValue))) {
            targetResult = pkValue;
        }
        return targetResult;
    }

    public static Long getSysField(String targetEntity, DynamicObject sourceObj) {
        Long targetResult = 0L;
        if (sourceObj != null) {
            Long pkValue = (Long)sourceObj.getPkValue();
            targetResult = BusiSyschFieldUtil.getSysField(targetEntity, pkValue);
        }
        return targetResult;
    }

    public static Long[] getExistentPksFromSrcDObjColl(String targetEntityName, DynamicObjectCollection sourceColl) {
        if (CollectionUtils.isEmpty((Collection)sourceColl)) {
            return new Long[0];
        }
        List<Long> pkValuesByMulData = MulBaseDataUtils.getPkValuesByMulData(sourceColl);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)algokey, (String)targetEntityName, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", pkValuesByMulData)}, null);
        HashSet pks = new HashSet(8);
        dataSet.forEach(t -> pks.add(t.getLong("id")));
        dataSet.close();
        return pks.toArray(new Long[0]);
    }

    public static void setValue(IFormView view, Map<String, String> fieldMap, Map<String, List<Tuple<String, String>>> entryFieldMap) {
        IDataModel model = view.getModel();
        if (!CollectionUtils.isEmpty(fieldMap)) {
            for (Map.Entry<String, Object> entry : fieldMap.entrySet()) {
                BusiSyschFieldUtil.setSingleValue(view, entry.getKey(), (String)entry.getValue());
            }
        }
        if (!CollectionUtils.isEmpty(entryFieldMap)) {
            for (Map.Entry<String, Object> entry : entryFieldMap.entrySet()) {
                String entryName = entry.getKey();
                List fieldTuples = (List)entry.getValue();
                for (Tuple fieldTuple : fieldTuples) {
                    int rowCount = model.getEntryRowCount(entryName);
                    for (int i = 0; i < rowCount; ++i) {
                        BusiSyschFieldUtil.setSingleValue(view, (String)fieldTuple.item2, (String)fieldTuple.item1, i);
                    }
                }
            }
        }
    }

    public static void afterBindSetValue(IFormView view, Map<String, String> fieldMap, Map<String, List<Tuple<String, String>>> entryFieldMap) {
        if (BusiSyschFieldUtil.isNewCreate(view).booleanValue()) {
            BusiSyschFieldUtil.setValue(view, fieldMap, entryFieldMap);
        }
    }

    public static void propertyChanged(PropertyChangedArgs e, IFormView view, Map<String, String> fieldMap, Map<String, List<Tuple<String, String>>> entryFieldMap) {
        HashMap<Object, Object> entryFields = new HashMap<Object, Object>(2);
        if (!CollectionUtils.isEmpty(entryFieldMap)) {
            for (Map.Entry<String, List<Tuple<String, String>>> entry : entryFieldMap.entrySet()) {
                List<Tuple<String, String>> fieldList = entry.getValue();
                for (Tuple<String, String> fieldTuple : fieldList) {
                    entryFields.put(fieldTuple.item1, fieldTuple.item2);
                }
            }
        }
        String name = e.getProperty().getName();
        if (!CollectionUtils.isEmpty(fieldMap) && fieldMap.containsKey(name)) {
            BusiSyschFieldUtil.setSingleValue(view, name, fieldMap.get(name));
        } else if (!CollectionUtils.isEmpty(entryFields) && entryFields.containsKey(name)) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            BusiSyschFieldUtil.setSingleValue(view, name, (String)entryFields.get(name), rowIndex);
        }
    }

    public static void setSingleValue(IFormView view, String origField, String targetField) {
        BusiSyschFieldUtil.setValueInternal(view, origField, targetField, -1);
    }

    public static void setSingleValue(IFormView view, String origField, String targetField, int rowIndex) {
        BusiSyschFieldUtil.setValueInternal(view, origField, targetField, rowIndex);
    }

    private static void setValueInternal(IFormView view, String origField, String targetField, int rowIndex) {
        IDataModel model = view.getModel();
        if (StringUtils.isEmpty((Object)origField) || StringUtils.isEmpty((Object)targetField)) {
            return;
        }
        IDataEntityProperty targetEntityProp = model.getDataEntityType().findProperty(targetField);
        Object modelValue = BusiSyschFieldUtil.getModelValue(model, origField, rowIndex);
        if (targetEntityProp instanceof BasedataProp) {
            String entityName;
            boolean exists;
            DynamicObject origObj = (DynamicObject)modelValue;
            DynamicObject targetResult = null;
            if (origObj != null && (exists = QueryServiceHelper.exists((String)(entityName = ((BasedataProp)targetEntityProp).getBaseEntityId()), (Object)origObj.getPkValue()))) {
                targetResult = origObj;
            }
            BusiSyschFieldUtil.setModelValue(model, targetField, targetResult, rowIndex, FIELD_TYPE);
        } else if (targetEntityProp instanceof MulBasedataProp) {
            String baseEntityId = ((MulBasedataProp)targetEntityProp).getBaseEntityId();
            DynamicObjectCollection origColl = (DynamicObjectCollection)modelValue;
            Long[] existentPks = BusiSyschFieldUtil.getExistentPksFromSrcDObjColl(baseEntityId, origColl);
            BusiSyschFieldUtil.setModelValue(model, targetField, existentPks, rowIndex, null);
        } else {
            BusiSyschFieldUtil.setModelValue(model, targetField, modelValue, rowIndex, null);
        }
    }

    private static Object getModelValue(IDataModel model, String field, int rowIndex) {
        if (rowIndex >= 0) {
            return model.getValue(field, rowIndex);
        }
        return model.getValue(field);
    }

    private static void setModelValue(IDataModel model, String field, Object value, int rowIndex, String fieldType) {
        if (rowIndex >= 0) {
            model.setValue(field, value, rowIndex);
        } else {
            model.setValue(field, value);
            if (FIELD_TYPE.equals(fieldType)) {
                BusiSyschFieldUtil.setExitWithOutReminder(model, field);
            }
        }
    }

    private static void setExitWithOutReminder(IDataModel model, String field) {
        DynamicObject dyo = model.getDataEntity();
        DynamicProperty baseDataProp = dyo.getDynamicObjectType().getProperty(field + "_id");
        dyo.getDataEntityState().setBizChanged(baseDataProp.getOrdinal(), false);
    }
}

