/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.calendar.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.botp.EcoCommonHelper;
import kd.bd.mpdm.common.calendar.CalendarDateCollComparatorImpl;
import kd.bd.mpdm.common.calendar.ICalendarService;
import kd.bd.mpdm.common.query.helper.OrgQueryHelper;
import kd.bd.mpdm.common.utils.DateUtils;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;

public class CalendarServiceImpl
implements ICalendarService {
    private static final String APPPARAM = "bd-mpdm-common";
    private static final String[] CALENDAR_HEAD_FIELDS = new String[]{"id", "number", "name", "startdate", "enddate", "issunrest", "ismonrest", "istuerest", "iswedrest", "isthurest", "isfrirest", "issatrest"};
    private static final Log log = LogFactory.getLog(CalendarServiceImpl.class);
    private static CalendarServiceImpl impl;

    public static CalendarServiceImpl getInstance() {
        if (impl == null) {
            impl = new CalendarServiceImpl();
        }
        return impl;
    }

    @Override
    public Set<Long> getCalendarIdSet(Long bizDataId, String bizObjectType, String fromModel) {
        HashSet<Long> idSet = new HashSet<Long>(16);
        String selectFields = "entryentity.calendar calendarid";
        DynamicObjectCollection coll = this.loopQueryCalendarSetColl(bizDataId, bizObjectType, fromModel, null, selectFields);
        for (DynamicObject data : coll) {
            idSet.add(data.getLong("calendarid"));
        }
        return idSet;
    }

    private DynamicObjectCollection loopQueryCalendarSetColl(Long bizDataId, String bizObjectType, String fromModel, Long calendarId, String selectFields) {
        DynamicObjectCollection coll = this.queryCalendarSetColl(bizDataId, bizObjectType, fromModel, calendarId, selectFields, null);
        if (coll.isEmpty() && "C".equals(bizObjectType)) {
            DynamicObject workCenter = this.getWorkCenter(bizDataId);
            Long workShopId = this.getWorkShopIdByWorkCenter(workCenter);
            if (this.isNullLong(workShopId)) {
                Long orgId = this.getOrgIdByWorkCenter(workCenter);
                coll = this.queryCalendarSetColl(orgId, "A", fromModel, calendarId, selectFields, null);
            } else {
                bizObjectType = "B";
                bizDataId = workShopId;
                coll = this.queryCalendarSetColl(bizDataId, bizObjectType, fromModel, calendarId, selectFields, null);
            }
        }
        if (coll.isEmpty() && "B".equals(bizObjectType)) {
            Long orgId = this.getOrgIdByWorkShop(bizDataId);
            coll = this.queryCalendarSetColl(orgId, "A", fromModel, calendarId, selectFields, null);
        }
        return coll;
    }

    private DynamicObjectCollection queryCalendarSetColl(Long bizDataId, String bizObjectType, String fromModel, Long calendarId, String selectProperties, QFilter otherQfilter) {
        String effectBizField = "entryentity." + this.getEffectFieldByModel(fromModel);
        QFilter qf = new QFilter("objecttype", "=", (Object)bizObjectType);
        qf.and(new QFilter(this.getBizObjectFieldByType(bizObjectType), "=", (Object)bizDataId));
        qf.and(new QFilter(effectBizField, "=", (Object)true));
        qf.and(new QFilter("entryentity.calendar.enable", "=", (Object)"1"));
        qf.and(new QFilter("entryentity.calendar.status", "=", (Object)"C"));
        if (!this.isNullLong(calendarId)) {
            qf.and(new QFilter("entryentity.calendar", "=", (Object)calendarId));
        }
        if (otherQfilter != null) {
            qf.and(otherQfilter);
        }
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"mpdm_calendarset", (String)selectProperties, (QFilter[])new QFilter[]{qf});
        return coll;
    }

    private boolean isNullLong(Long data) {
        return data == null || data.equals(0L);
    }

    private Long getWorkShopIdByWorkCenter(DynamicObject workCenter) {
        DynamicObject workShop = workCenter.getDynamicObject("workshop");
        return workShop == null ? 0L : workShop.getLong("id");
    }

    private Long getOrgIdByWorkCenter(DynamicObject workCenter) {
        DynamicObject createorg = workCenter.getDynamicObject("createorg");
        return createorg == null ? 0L : createorg.getLong("id");
    }

    private DynamicObject getWorkCenter(Long workCenterId) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)workCenterId, (String)"mpdm_workcentre", (String)"createorg,workshop");
    }

    private Long getOrgIdByWorkShop(Long workShopId) {
        DynamicObject workShop = BusinessDataServiceHelper.loadSingleFromCache((Object)workShopId, (String)"mpdm_workshopsetup", (String)"createorg");
        DynamicObject createorg = workShop.getDynamicObject("createorg");
        return createorg == null ? 0L : createorg.getLong("id");
    }

    private String getEffectFieldByModel(String fromModel) {
        return "B".equalsIgnoreCase(fromModel) ? "iseffectplan" : ("C".equalsIgnoreCase(fromModel) ? "iseffectproject" : "iseffectproduct");
    }

    private String getBizObjectFieldByType(String bizObjectType) {
        return "B".equalsIgnoreCase(bizObjectType) ? "workshop" : ("C".equalsIgnoreCase(bizObjectType) ? "workcenter" : "org");
    }

    @Override
    public JSONObject getCalendarData(Long bizDataId, String bizObjectType, String fromModel, Long calendarId, Date fromDate, Date toDate) {
        return this.getCalendarData(bizDataId, bizObjectType, fromModel, calendarId, fromDate, toDate, true);
    }

    private JSONObject getCalendarData(Long bizDataId, String bizObjectType, String fromModel, Long calendarId, Date fromDate, Date toDate, boolean isQueryHead) {
        String selectFields = this.getCalendarSetpeoperties();
        JSONObject result = this.buildResultJs(false, ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u65e5\u5386\u4fe1\u606f\u3002", (String)"CalendarBusImpl_01", (String)APPPARAM, (Object[])new Object[0]), 0, "");
        try {
            DynamicObjectCollection coll = this.loopQueryCalendarSetColl(bizDataId, bizObjectType, fromModel, calendarId, selectFields);
            if (coll.isEmpty()) {
                return result;
            }
            Set<Long> calendarIdSet = coll.stream().map(p -> p.getLong("calendarid")).collect(Collectors.toSet());
            Map<Long, JSONObject> calendarWorkDateMap = this.bulidCalendarWorkDateMap(calendarIdSet, fromDate, toDate, isQueryHead);
            JSONArray calendarWorkDateArray = this.buildWorkDateArray(coll, calendarWorkDateMap, fromModel, fromDate, toDate, isQueryHead);
            return this.buildResultJs(true, "", coll.size(), calendarWorkDateArray.toJSONString());
        }
        catch (Exception e) {
            String errorMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            return this.buildResultJs(false, errorMsg, 0, "");
        }
    }

    private String getCalendarSetpeoperties() {
        return "id,org,objecttype,workshop,workcenter,entryentity.id entryid,entryentity.calendar calendarid,entryentity.classsystem classsystem";
    }

    private JSONArray buildWorkDateArray(DynamicObjectCollection coll, Map<Long, JSONObject> calendarWorkDateMap, String fromModel, Date fromDate, Date toDate, boolean addClassSystem) {
        JSONArray calendarWorkDateArray = new JSONArray(coll.size());
        for (DynamicObject data : coll) {
            Long curCalendarid = data.getLong("calendarid");
            Long setEntryid = data.getLong("entryid");
            JSONObject calendarWorkDateJs = calendarWorkDateMap.get(curCalendarid);
            if (addClassSystem) {
                calendarWorkDateJs.put("classsystem", (Object)data.getLong("classsystem"));
            }
            JSONObject setMakeDateJs = new JSONObject();
            String dataObjectType = data.getString("objecttype");
            Long dataId = "C".equals(dataObjectType) ? data.getLong("workcenter") : ("B".equals(dataObjectType) ? data.getLong("workshop") : data.getLong("org"));
            this.loopQueryCalendarMarkSetData(setEntryid, dataObjectType, dataId, fromModel, curCalendarid, fromDate, toDate, setMakeDateJs);
            if (setMakeDateJs != null && !setMakeDateJs.isEmpty()) {
                Set markDateSet = setMakeDateJs.keySet();
                JSONObject workDateEntryJs = calendarWorkDateJs.getJSONObject("workdateentry");
                for (String markDates : markDateSet) {
                    workDateEntryJs.put(markDates, (Object)setMakeDateJs.getString(markDates));
                }
            }
            calendarWorkDateArray.add((Object)calendarWorkDateJs);
        }
        return calendarWorkDateArray;
    }

    private void loopQueryCalendarMarkSetData(Long entryId, String bizObjectType, Long bizDataId, String fromModel, Long calendarid, Date fromDate, Date toDate, JSONObject setDateJs) {
        DynamicObjectCollection coll;
        String selectFields = this.getSetProperties();
        QFilter workDateQFilter = this.getSetWorkDateFilter(fromDate, toDate);
        if (!this.isNullLong(entryId)) {
            QFilter qf = new QFilter("entryentity.id", "=", (Object)entryId);
            coll = QueryServiceHelper.query((String)"mpdm_calendarset", (String)selectFields, (QFilter[])new QFilter[]{qf, workDateQFilter});
            this.putSetMarkWorkDateCollToJs(coll, setDateJs);
        }
        if ("C".equals(bizObjectType)) {
            DynamicObject workCenter = this.getWorkCenter(bizDataId);
            Long workShopId = this.getWorkShopIdByWorkCenter(workCenter);
            if (this.isNullLong(workShopId)) {
                Long orgId = this.getOrgIdByWorkCenter(workCenter);
                DynamicObjectCollection coll2 = this.queryCalendarSetColl(orgId, "A", fromModel, calendarid, selectFields, workDateQFilter);
                this.putSetMarkWorkDateCollToJs(coll2, setDateJs);
            } else {
                bizObjectType = "B";
                bizDataId = workShopId;
                DynamicObjectCollection coll3 = this.queryCalendarSetColl(bizDataId, bizObjectType, fromModel, calendarid, selectFields, workDateQFilter);
                this.putSetMarkWorkDateCollToJs(coll3, setDateJs);
            }
        }
        if ("B".equals(bizObjectType)) {
            Long orgId = this.getOrgIdByWorkShop(bizDataId);
            coll = this.queryCalendarSetColl(orgId, "A", fromModel, calendarid, selectFields, workDateQFilter);
            this.putSetMarkWorkDateCollToJs(coll, setDateJs);
        }
    }

    private QFilter getSetWorkDateFilter(Date fromDate, Date toDate) {
        QFilter qf1 = null;
        QFilter qf2 = null;
        if (fromDate != null) {
            qf1 = new QFilter("entryentity.dateentry.workdate", ">=", (Object)fromDate);
        }
        if (toDate != null) {
            qf2 = new QFilter("entryentity.dateentry.workdate", "<=", (Object)toDate);
        }
        return qf1 == null ? qf2 : (qf2 == null ? qf1 : qf1.and(qf2));
    }

    private void putSetMarkWorkDateCollToJs(DynamicObjectCollection coll, JSONObject setDateJs) {
        if (coll == null || coll.isEmpty()) {
            return;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        for (DynamicObject data : coll) {
            String dates;
            Date workDate = data.getDate("workdate");
            if (workDate == null || setDateJs.containsKey((Object)(dates = dateFormat.format(workDate)))) continue;
            setDateJs.put(dates, (Object)data.getString("datetype"));
        }
    }

    private String getSetProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        sb.append(",org");
        sb.append(",objecttype");
        sb.append(",workshop");
        sb.append(",workcenter");
        sb.append(",entryentity.id entryid");
        sb.append(",entryentity.calendar calendarid");
        sb.append(",entryentity.dateentry.workdate workdate");
        sb.append(",entryentity.dateentry.datetype datetype");
        return sb.toString();
    }

    private Map<Long, JSONObject> bulidCalendarWorkDateMap(Set<Long> calendarIdSet, Date fromDate, Date toDate, boolean isQueryHead) {
        HashMap<Long, JSONObject> dataMap = new HashMap<Long, JSONObject>(16);
        Map calendars = new HashMap(16);
        if (isQueryHead) {
            String selectProprties = this.getCalendarSelectProperties();
            QFilter qf = new QFilter("id", "in", calendarIdSet);
            calendars = BusinessDataServiceHelper.loadFromCache((String)"mpdm_calendar", (String)selectProprties, (QFilter[])new QFilter[]{qf});
        }
        Map<Long, JSONObject> workDateMap = this.getCalendarWorkDataMap(calendarIdSet, fromDate, toDate);
        for (Long calendarId : calendarIdSet) {
            DynamicObject calendar = (DynamicObject)calendars.get(calendarId);
            JSONObject calendarJs = this.putCalendarToJs(calendar, calendarId);
            JSONObject workDateJs = workDateMap.get(calendarId);
            calendarJs.put("workdateentry", (Object)(workDateJs == null ? new JSONObject() : workDateJs));
            dataMap.put(calendarId, calendarJs);
        }
        return dataMap;
    }

    private JSONObject putCalendarToJs(DynamicObject calendar, Long id) {
        JSONObject data = new JSONObject();
        if (calendar == null) {
            data.put("id", (Object)id);
        } else {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            for (String field : CALENDAR_HEAD_FIELDS) {
                Object value = calendar.get(field);
                if (value instanceof Date) {
                    value = dateFormat.format((Date)value);
                }
                data.put(field, value);
            }
        }
        return data;
    }

    private String getCalendarSelectProperties() {
        StringBuilder sb = new StringBuilder();
        for (String field : CALENDAR_HEAD_FIELDS) {
            sb.append(field).append(",");
        }
        return sb.toString().substring(0, sb.toString().length() - 1);
    }

    private Map<Long, JSONObject> getCalendarWorkDataMap(Set<Long> calendarIdSet, Date fromDate, Date toDate) {
        HashMap<Long, JSONObject> maps = new HashMap<Long, JSONObject>(calendarIdSet.size());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        QFilter qf = new QFilter("id", "in", calendarIdSet);
        if (fromDate != null) {
            qf.and(new QFilter("dateentry.workdate", ">=", (Object)fromDate));
        }
        if (toDate != null) {
            qf.and(new QFilter("dateentry.workdate", "<=", (Object)toDate));
        }
        String selectProprties = "id,dateentry.workdate workdate,dateentry.datetype datetype";
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"mpdm_calendar", (String)selectProprties, (QFilter[])new QFilter[]{qf});
        for (DynamicObject data : coll) {
            Long calendarId = data.getLong("id");
            JSONObject workDateJson = (JSONObject)maps.get(calendarId);
            if (workDateJson == null) {
                workDateJson = new JSONObject();
            }
            workDateJson.put(dateFormat.format(data.getDate("workdate")), (Object)data.getString("datetype"));
            maps.put(calendarId, workDateJson);
        }
        return maps;
    }

    private JSONObject buildResultJs(boolean isTrue, String msg, int count, String data) {
        JSONObject resultObject = new JSONObject();
        resultObject.put("issuccessful", (Object)isTrue);
        resultObject.put("msg", (Object)msg);
        resultObject.put("count", (Object)count);
        resultObject.put("data", (Object)data);
        return resultObject;
    }

    @Override
    public String getWorkDateType(Long bizDataId, String bizObjectType, String fromModel, Long calendarId, Date queryDate) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String queryDates = dateFormat.format(queryDate);
            Date fromDate = dateTimeFormat.parse(queryDates + " 00:00:00");
            Date toDate = dateTimeFormat.parse(queryDates + " 23:59:59");
            JSONObject resultJs = this.getCalendarData(bizDataId, bizObjectType, fromModel, calendarId, fromDate, toDate, false);
            boolean isSuccessful = resultJs.getBoolean("issuccessful");
            if (!isSuccessful) {
                return "error:" + resultJs.getString("msg");
            }
            String resultData = resultJs.getString("data");
            JSONArray dataArray = JSON.parseArray((String)resultData);
            JSONObject calendarWorkDateJs = dataArray.getJSONObject(0);
            JSONObject workDateEntryJs = calendarWorkDateJs.getJSONObject("workdateentry");
            return workDateEntryJs.getString(queryDates);
        }
        catch (ParseException e) {
            return "error:parse date error\u3002";
        }
    }

    @Override
    public Date getRecentlyWorkDate(Long bizDataId, String bizObjectType, String fromModel, Long calendarId, Date startDate, int toDays) {
        if (toDays == 0) {
            return startDate;
        }
        String selectFields = this.getCalendarSetpeoperties();
        DynamicObjectCollection coll = this.loopQueryCalendarSetColl(bizDataId, bizObjectType, fromModel, calendarId, selectFields);
        if (coll.isEmpty()) {
            return null;
        }
        int oneBatchDays = toDays * 2;
        Date nextWorkDate = null;
        int loop = 0;
        int workDateDays = 0;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        HashSet<String> daySet = new HashSet<String>(64);
        int mathAbsSize = Math.abs(toDays);
        block0: while (nextWorkDate == null) {
            Date beginDate = toDays > 0 ? startDate : DateUtils.addDay(startDate, oneBatchDays);
            Date endDate = toDays > 0 ? DateUtils.addDay(startDate, oneBatchDays) : startDate;
            Date date = startDate = toDays > 0 ? endDate : beginDate;
            if (++loop > 30) break;
            JSONObject workDateEntryJs = this.getWorkDateEntry(coll, fromModel, calendarId, beginDate, endDate);
            Date currentDate = toDays > 0 ? beginDate : endDate;
            while ((currentDate = DateUtils.addDay(currentDate, toDays > 0 ? 1 : -1)).compareTo(endDate) <= 0 && currentDate.compareTo(beginDate) >= 0) {
                String currentDates = dateFormat.format(currentDate);
                if (!daySet.add(currentDates)) continue;
                String workType = workDateEntryJs.getString(currentDates);
                if (workType == null) {
                    return null;
                }
                if (!"1".equals(workType) || ++workDateDays < mathAbsSize) continue;
                nextWorkDate = currentDate;
                continue block0;
            }
        }
        return nextWorkDate;
    }

    private JSONObject getWorkDateEntry(DynamicObjectCollection coll, String fromModel, Long calendarId, Date fromDate, Date toDate) {
        Set<Long> calendarIdSet = coll.stream().map(p -> p.getLong("calendarid")).collect(Collectors.toSet());
        Map<Long, JSONObject> calendarWorkDateMap = this.bulidCalendarWorkDateMap(calendarIdSet, fromDate, toDate, false);
        JSONArray calendarWorkDateArray = this.buildWorkDateArray(coll, calendarWorkDateMap, fromModel, fromDate, toDate, false);
        JSONObject calendarWorkDateJs = calendarWorkDateArray.getJSONObject(0);
        return calendarWorkDateJs.getJSONObject("workdateentry");
    }

    private Set<Long> getOrgIdSet(Long viewId) {
        QFilter filterTreetype = new QFilter("view", "=", (Object)viewId);
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)"0");
        QFilter freezeFilter1 = new QFilter("isfreeze", "is null", null);
        freezeFilter = freezeFilter.or(freezeFilter1);
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_org_structure", (String)"id, org.id org", (QFilter[])new QFilter[]{filterTreetype, freezeFilter}, (String)"level");
        return orgCol.stream().map(p -> p.getLong("org")).collect(Collectors.toSet());
    }

    @Override
    public String syncCalendar(Long calendarId, Long calendarSetId, String opKey) {
        String allErrorMsg;
        if (this.isNullLong(calendarId) && this.isNullLong(calendarSetId)) {
            return "";
        }
        String errorMsgA = this.syncCalendarToPlanCalendar(calendarId, calendarSetId, opKey);
        String errorMsgB = this.syncCalendarToProudctOrg(calendarId, calendarSetId, opKey);
        String string = StringUtils.isEmpty((String)errorMsgA) ? errorMsgB : (allErrorMsg = StringUtils.isEmpty((String)errorMsgB) ? errorMsgA : errorMsgA + " " + errorMsgB);
        if (!StringUtils.isEmpty((String)allErrorMsg)) {
            log.error(allErrorMsg);
            DynamicObject syncLog = this.genSyncLog(ResManager.loadKDString((String)"\u751f\u4ea7\u65e5\u5386\u540c\u6b65\u9519\u8bef", (String)"CalendarServiceImpl_9", (String)APPPARAM, (Object[])new Object[0]), null, null, calendarSetId);
            syncLog.set("updatedata", (Object)this.getSimpleSql(allErrorMsg));
            syncLog.set("updatedata_tag", (Object)allErrorMsg);
            syncLog.set("remark", (Object)("calendarId:" + calendarId + ",calendarSetId:" + calendarSetId));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{syncLog});
        }
        return allErrorMsg;
    }

    private String syncCalendarToProudctOrg(Long calendarId, Long calendarSetId, String opKey) {
        if (opKey.startsWith("calendar_op_")) {
            return "";
        }
        StringBuilder errorMsg = new StringBuilder();
        try {
            QFilter qf = new QFilter("entryentity.iseffectproduct", "=", (Object)true);
            if (!this.isNullLong(calendarSetId)) {
                qf.and(new QFilter("id", "=", (Object)calendarSetId));
            }
            if (!this.isNullLong(calendarId)) {
                qf.and(new QFilter("entryentity.calendar", "=", (Object)calendarId));
            }
            HashMap<Long, Boolean> org2sync = new HashMap<Long, Boolean>(16);
            HashMap<Long, DynamicObject> cacheMap = new HashMap<Long, DynamicObject>(16);
            String remark = "calendarId:" + calendarId + ",calendarSetId:" + calendarSetId + ",opKey:" + opKey;
            String selectProperties = "id,objecttype,org,workshop,workcenter,entryentity.calendar calendarid,entryentity.id entryid,entryentity.classsystem classsystem";
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"mpdm_calendarset", (String)selectProperties, (QFilter[])new QFilter[]{qf});
            if (coll.isEmpty() && !this.isNullLong(calendarSetId)) {
                DynamicObject data = QueryServiceHelper.queryOne((String)"mpdm_calendarset", (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calendarSetId)});
                String objectType = data.getString("objecttype");
                Long orgId = data.getLong("org");
                String updateTag = this.getUpdateTag(objectType);
                DynamicObject org = OrgQueryHelper.getDataCacheByID(orgId);
                if (!this.isSyncProductOrg(orgId, org2sync)) {
                    errorMsg.append(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u5bf9\u5e94\u7684\u7cfb\u7edf\u53c2\u6570\u3010\u540c\u6b65\u5386\u53f2\u7248\u672c\u65e5\u5386\u8bbe\u7f6e\u3011\u672a\u542f\u7528\uff0c\u4e0d\u8fdb\u884c%2$s\u7684\u540c\u6b65\u3002", (String)"CalendarServiceImpl_11", (String)APPPARAM, (Object[])new Object[0]), org.getString("name"), updateTag));
                    return errorMsg.toString();
                }
                Long bizDataId = "A".equals(objectType) ? orgId : ("B".equals(objectType) ? data.getLong("workshop") : data.getLong("workcenter"));
                String queryProperties = this.getProductSelectProperties(objectType);
                String entityNumber = this.getEntityNumber(objectType);
                HashSet<Long> allBizDataId = new HashSet<Long>(16);
                allBizDataId.add(bizDataId);
                DynamicObject bizDataObj = this.getProductOrgData(bizDataId, allBizDataId, cacheMap, entityNumber, queryProperties);
                if (bizDataObj != null) {
                    String oldDatas = this.getOldDataStr(bizDataObj, objectType);
                    String saveMsg = this.saveBizDataObj(bizDataObj, objectType, 0L, 0L);
                    if (!StringUtils.isEmpty((String)saveMsg)) {
                        errorMsg.append(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\uff0c\u751f\u4ea7\u65e5\u5386\u7f16\u7801\u201c%2$s\u201d\u540c\u6b65\u66f4\u65b0%3$s\u65f6\u53d1\u751f\u9519\u8bef\uff1a%4$s", (String)"CalendarServiceImpl_1", (String)APPPARAM, (Object[])new Object[0]), org.getString("name"), "", updateTag, saveMsg));
                    } else {
                        this.createSyncLog(bizDataId, updateTag, null, org, objectType, data.getLong("id"), bizDataObj, oldDatas, "", remark);
                    }
                }
                return errorMsg.toString();
            }
            Set<Long> orgIdSet = coll.stream().map(p -> p.getLong("org")).collect(Collectors.toSet());
            Set workshopIdSet = coll.stream().map(p -> p.getLong("workshop")).collect(Collectors.toSet());
            Set workcenterIdSet = coll.stream().map(p -> p.getLong("workcenter")).collect(Collectors.toSet());
            for (DynamicObject data : coll) {
                String saveMsg;
                DynamicObject org;
                Long orgId = data.getLong("org");
                String objectType = data.getString("objecttype");
                String updateTag = this.getUpdateTag(objectType);
                if (!this.isSyncProductOrg(orgId, org2sync)) {
                    org = OrgQueryHelper.getDataCacheByID(orgId);
                    errorMsg.append(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u5bf9\u5e94\u7684\u7cfb\u7edf\u53c2\u6570\u3010\u540c\u6b65\u5386\u53f2\u7248\u672c\u65e5\u5386\u8bbe\u7f6e\u3011\u672a\u542f\u7528\uff0c\u4e0d\u8fdb\u884c%2$s\u7684\u540c\u6b65\u3002", (String)"CalendarServiceImpl_11", (String)APPPARAM, (Object[])new Object[0]), org.getString("name"), updateTag));
                    continue;
                }
                org = OrgQueryHelper.getDataCacheByID(orgId);
                DynamicObject calendar = this.getCalendarObj(data.getLong("calendarid"));
                if ((calendarId == null || calendarId.equals(0L)) && !this.checkCalendarIsEnable(calendar)) {
                    errorMsg.append(String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u65e5\u5386\u201c%1$s\u201d\u4e0d\u5904\u4e8e\u5ba1\u6838\u53ef\u7528\u72b6\u6001\uff0c\u4e0d\u8fdb\u884c%2$s\u7684\u540c\u6b65\u3002", (String)"CalendarServiceImpl_12", (String)APPPARAM, (Object[])new Object[0]), calendar.getString("number"), updateTag));
                    continue;
                }
                Long newClassSystemId = data.getLong("classsystem");
                if ("C".equals(objectType)) {
                    newClassSystemId = 0L;
                }
                Long bizDataId = "A".equals(objectType) ? orgId : ("B".equals(objectType) ? data.getLong("workshop") : data.getLong("workcenter"));
                String queryProperties = this.getProductSelectProperties(objectType);
                String entityNumber = this.getEntityNumber(objectType);
                Set<Long> allBizDataId = "A".equals(objectType) ? orgIdSet : ("B".equals(objectType) ? workshopIdSet : workcenterIdSet);
                String newDatas = this.getNewDataStr(data.getLong("calendarid"), data.getLong("classsystem"), objectType);
                DynamicObject bizDataObj = this.getProductOrgData(bizDataId, allBizDataId, cacheMap, entityNumber, queryProperties);
                if (bizDataObj == null) {
                    if (!this.isProductOrg(entityNumber)) continue;
                    DynamicObject productOrg = this.buildProductOrgData(calendar, newClassSystemId, org);
                    saveMsg = this.saveProductOrg(productOrg);
                    if (!StringUtils.isEmpty((String)saveMsg)) {
                        errorMsg.append(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\uff0c\u751f\u4ea7\u65e5\u5386\u7f16\u7801\u201c%2$s\u201d\u540c\u6b65\u66f4\u65b0%3$s\u65f6\u53d1\u751f\u9519\u8bef\uff1a%4$s", (String)"CalendarServiceImpl_1", (String)APPPARAM, (Object[])new Object[0]), org.getString("name"), calendar.getString("number"), updateTag, saveMsg));
                        continue;
                    }
                    this.createSyncLog(bizDataId, updateTag, calendar, org, objectType, data.getLong("id"), productOrg, "", newDatas, remark);
                    continue;
                }
                if (!this.isDifferentData(bizDataObj, objectType, data.getLong("calendarid"), newClassSystemId)) continue;
                String oldDatas = this.getOldDataStr(bizDataObj, objectType);
                saveMsg = this.saveBizDataObj(bizDataObj, objectType, data.getLong("calendarid"), data.getLong("classsystem"));
                if (!StringUtils.isEmpty((String)saveMsg)) {
                    errorMsg.append(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\uff0c\u751f\u4ea7\u65e5\u5386\u7f16\u7801\u201c%2$s\u201d\u540c\u6b65\u66f4\u65b0%3$s\u65f6\u53d1\u751f\u9519\u8bef\uff1a%4$s", (String)"CalendarServiceImpl_1", (String)APPPARAM, (Object[])new Object[0]), org.getString("name"), calendar.getString("number"), updateTag, saveMsg));
                    continue;
                }
                this.createSyncLog(bizDataId, updateTag, calendar, org, objectType, data.getLong("id"), bizDataObj, oldDatas, newDatas, remark);
            }
        }
        catch (Exception e) {
            errorMsg.append(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return errorMsg.toString();
    }

    private void createSyncLog(Long bizDataId, String updateTag, DynamicObject calendar, DynamicObject org, String objectType, Long settingId, DynamicObject bizDataObj, String oldDatas, String newDatas, String remark) {
        DynamicObject syncLog = this.genSyncLog(String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u65e5\u5386\u540c\u6b65\u66f4\u65b0%1$s", (String)"CalendarServiceImpl_2", (String)APPPARAM, (Object[])new Object[0]), updateTag), calendar, org, settingId);
        syncLog.set("nextid", (Object)bizDataId);
        syncLog.set("nextnumber", (Object)bizDataObj.getString("number"));
        syncLog.set("nexttype", (Object)("A".equals(objectType) ? "C" : ("B".equals(objectType) ? "D" : ("C".equals(objectType) ? "E" : "A"))));
        syncLog.set("nextolddata", (Object)this.getSimpleSql(oldDatas));
        syncLog.set("nextolddata_tag", (Object)oldDatas);
        syncLog.set("updatedata", (Object)this.getSimpleSql(newDatas));
        syncLog.set("updatedata_tag", (Object)newDatas);
        syncLog.set("remark", (Object)remark);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{syncLog});
    }

    private DynamicObject buildProductOrgData(DynamicObject calendar, Long classsysteam, DynamicObject org) {
        DynamicObject data = BusinessDataServiceHelper.newDynamicObject((String)"fmm_defaultorg");
        Date currentDate = new Date();
        data.set("createtime", (Object)currentDate);
        data.set("org", (Object)org);
        data.set("number", (Object)org.getString("number"));
        data.set("name", (Object)org.getString("name"));
        data.set("calendar", (Object)calendar);
        data.set("classsysteam", (Object)classsysteam);
        data.set("enable", (Object)"1");
        data.set("status", (Object)"C");
        data.set("createorg", (Object)org);
        data.set("classsysteam", (Object)classsysteam);
        return data;
    }

    private String getUpdateTag(String objectType) {
        return "A".equals(objectType) ? ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\u5c5e\u6027", (String)"CalendarServiceImpl_6", (String)APPPARAM, (Object[])new Object[0]) : ("B".equals(objectType) ? ResManager.loadKDString((String)"\u8f66\u95f4\u5c5e\u6027", (String)"CalendarServiceImpl_7", (String)APPPARAM, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5de5\u4f5c\u4e2d\u5fc3", (String)"CalendarServiceImpl_8", (String)APPPARAM, (Object[])new Object[0]));
    }

    private String saveBizDataObj(DynamicObject bizDataObj, String objectType, Long newCalendarId, Long newClassSystemId) {
        String calendarField;
        String string = "A".equals(objectType) ? "calendar" : (calendarField = "B".equals(objectType) ? "fcalendar" : "calendar");
        String classSystemField = "A".equals(objectType) ? "classsysteam" : ("B".equals(objectType) ? "classsystem" : "");
        bizDataObj.set(calendarField, (Object)newCalendarId);
        if (!StringUtils.isEmpty((String)classSystemField)) {
            bizDataObj.set(classSystemField, (Object)newClassSystemId);
        }
        try {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bizDataObj});
        }
        catch (Exception e) {
            return ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
        }
        return "";
    }

    private boolean isDifferentData(DynamicObject bizDataObj, String objectType, Long newCalendarId, Long newClassSystemId) {
        Long oldCalendarId = this.getOldCalendarId(bizDataObj, objectType);
        Long oldClassSystemId = this.getOldClassSystemId(bizDataObj, objectType);
        return !oldCalendarId.equals(newCalendarId) || !oldClassSystemId.equals(newClassSystemId);
    }

    private String getOldDataStr(DynamicObject bizDataObj, String objectType) {
        Long oldCalendarId = this.getOldCalendarId(bizDataObj, objectType);
        Long oldClassSystemId = this.getOldClassSystemId(bizDataObj, objectType);
        StringBuilder str = new StringBuilder();
        str.append(this.getCalendarStr(oldCalendarId));
        if (!"C".equals(objectType)) {
            str.append(",");
            str.append(this.getClassSystemStr(oldClassSystemId));
        }
        str.append(";");
        return str.toString();
    }

    private String getNewDataStr(Long newCalendarId, Long newClassSystemId, String objectType) {
        StringBuilder str = new StringBuilder();
        str.append(this.getCalendarStr(newCalendarId));
        if (!"C".equals(objectType)) {
            str.append(",");
            str.append(this.getClassSystemStr(newClassSystemId));
        }
        str.append(";");
        return str.toString();
    }

    private Long getOldCalendarId(DynamicObject bizDataObj, String objectType) {
        String calendarField = "A".equals(objectType) ? "calendar" : ("B".equals(objectType) ? "fcalendar" : "calendar");
        DynamicObject oldCalendar = bizDataObj.getDynamicObject(calendarField);
        return oldCalendar == null ? 0L : oldCalendar.getLong("id");
    }

    private Long getOldClassSystemId(DynamicObject bizDataObj, String objectType) {
        String calendarField;
        String string = "A".equals(objectType) ? "classsysteam" : (calendarField = "B".equals(objectType) ? "classsystem" : "");
        if (StringUtils.isEmpty((String)calendarField)) {
            return 0L;
        }
        DynamicObject oldClassSystem = bizDataObj.getDynamicObject(calendarField);
        return oldClassSystem == null ? 0L : oldClassSystem.getLong("id");
    }

    private boolean isProductOrg(String entityNumber) {
        return "fmm_defaultorg".equalsIgnoreCase(entityNumber);
    }

    private DynamicObject getProductOrgData(Long orgId, Set<Long> orgIdSet, Map<Long, DynamicObject> cacheMap, String entityNumber, String selectProperties) {
        DynamicObject dataObject = cacheMap.get(orgId);
        if (dataObject == null && cacheMap.isEmpty()) {
            DynamicObject[] datas;
            String queryField = this.isProductOrg(entityNumber) ? "createorg" : "id";
            for (DynamicObject data : datas = BusinessDataServiceHelper.load((String)entityNumber, (String)selectProperties, (QFilter[])new QFilter[]{new QFilter(queryField, "in", orgIdSet)})) {
                Long dataId = (Long)(this.isProductOrg(entityNumber) ? data.getDynamicObject("createorg").getPkValue() : data.getPkValue());
                cacheMap.put(dataId, data);
            }
            dataObject = cacheMap.get(orgId);
        }
        return dataObject;
    }

    private String getProductSelectProperties(String objectType) {
        String commonField = "id,number,createorg,";
        return commonField + ("A".equals(objectType) ? "calendar,classsysteam" : ("B".equals(objectType) ? "fcalendar,classsystem" : "calendar"));
    }

    private String getEntityNumber(String objectType) {
        return "A".equals(objectType) ? "fmm_defaultorg" : ("B".equals(objectType) ? "mpdm_workshopsetup" : "mpdm_workcentre");
    }

    private boolean checkCalendarIsEnable(DynamicObject calendar) {
        return "1".equals(calendar.getString("enable")) && "C".equals(calendar.getString("status"));
    }

    private void disablePlanCalendar(Set<Long> planOrgIdSet, Map<Long, Boolean> org2sync, Long orgId, String opKey, String updateTag, Long calendarSetId) {
        if (!planOrgIdSet.contains(orgId) || !this.isSyncPlanCalendar(orgId, org2sync)) {
            return;
        }
        DynamicObject planCalendar = this.getPlanCalendar(orgId);
        if (planCalendar == null) {
            return;
        }
        planCalendar.set("enable", (Object)"0");
        planCalendar.set("isfault", (Object)"0");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{planCalendar});
        DynamicObject org = OrgQueryHelper.getDataCacheByID(orgId);
        String desc = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\uff0c\u5bf9\u8ba1\u5212\u65e5\u5386\u7f16\u7801\u201c%2$s\u201d\u8fdb\u884c\u4e86\u7981\u7528\u5e76\u53d6\u6d88\u9ed8\u8ba4\u503c\u7684\u8bbe\u7f6e\uff0c\u5f53\u524d\u64cd\u4f5c\u4e3a\uff1a%3$s\u3002", (String)"CalendarServiceImpl_10", (String)APPPARAM, (Object[])new Object[0]), org.getString("name"), planCalendar.getString("number"), opKey);
        DynamicObject syncLog = this.genSyncLog(String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u65e5\u5386\u540c\u6b65\u66f4\u65b0%1$s", (String)"CalendarServiceImpl_2", (String)APPPARAM, (Object[])new Object[0]), updateTag), planCalendar.getDynamicObject("mpdmcalendar"), org, calendarSetId);
        syncLog.set("nextid", (Object)((Long)planCalendar.getPkValue()));
        syncLog.set("nextnumber", (Object)planCalendar.getString("number"));
        syncLog.set("nexttype", (Object)"A");
        syncLog.set("remark", (Object)desc);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{syncLog});
    }

    private boolean isDisablePlanCalendarOp(String opKey) {
        return "calendar_op_unsubmit".equalsIgnoreCase(opKey) || "calendar_op_disable".equalsIgnoreCase(opKey);
    }

    private DynamicObjectCollection queryEffectPlanSettingColl(Long calendarId, Long calendarSetId) {
        String selectProperties = "id,org,entryentity.calendar calendarid,entryentity.id entryid";
        QFilter qf = new QFilter("entryentity.iseffectplan", "=", (Object)true);
        qf.and(new QFilter("objecttype", "=", (Object)"A"));
        if (!this.isNullLong(calendarSetId)) {
            qf.and(new QFilter("id", "=", (Object)calendarSetId));
        }
        if (!this.isNullLong(calendarId)) {
            qf.and(new QFilter("entryentity.calendar", "=", (Object)calendarId));
        }
        return QueryServiceHelper.query((String)"mpdm_calendarset", (String)selectProperties, (QFilter[])new QFilter[]{qf});
    }

    private Long getSettingOrgId(Long calendarSetId) {
        QFilter qf = new QFilter("id", "=", (Object)calendarSetId);
        qf.and(new QFilter("objecttype", "=", (Object)"A"));
        DynamicObject head = QueryServiceHelper.queryOne((String)"mpdm_calendarset", (String)"org", (QFilter[])new QFilter[]{qf});
        return head.getLong("org");
    }

    private String syncCalendarToPlanCalendar(Long calendarId, Long calendarSetId, String opKey) {
        Set<Long> planOrgIdSet = this.getOrgIdSet(914427355726916608L);
        HashMap<Long, Boolean> org2sync = new HashMap<Long, Boolean>(16);
        StringBuilder errorMsg = new StringBuilder();
        String updateTag = ResManager.loadKDString((String)"\u8ba1\u5212\u65e5\u5386", (String)"CalendarServiceImpl_5", (String)APPPARAM, (Object[])new Object[0]);
        try {
            DynamicObjectCollection coll = this.queryEffectPlanSettingColl(calendarId, calendarSetId);
            if (coll.isEmpty() && !this.isNullLong(calendarSetId)) {
                Long orgId = this.getSettingOrgId(calendarSetId);
                if (orgId != null && !orgId.equals(0L)) {
                    this.disablePlanCalendar(planOrgIdSet, org2sync, orgId, opKey, updateTag, calendarSetId);
                }
                return errorMsg.toString();
            }
            String remark = "calendarId:" + calendarId + ",calendarSetId:" + calendarSetId + ",opKey:" + opKey;
            for (DynamicObject data : coll) {
                Long orgId = data.getLong("org");
                DynamicObject org = OrgQueryHelper.getDataCacheByID(orgId);
                if (!planOrgIdSet.contains(orgId)) continue;
                if (!this.isSyncPlanCalendar(orgId, org2sync)) {
                    errorMsg.append(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u5bf9\u5e94\u7684\u7cfb\u7edf\u53c2\u6570\u3010\u540c\u6b65\u8ba1\u5212\u65e5\u5386\u3011\u672a\u542f\u7528\uff0c\u4e0d\u8fdb\u884c\u8ba1\u5212\u65e5\u5386\u7684\u540c\u6b65\u3002", (String)"CalendarServiceImpl_14", (String)APPPARAM, (Object[])new Object[0]), org.getString("name")));
                    continue;
                }
                DynamicObject calendar = this.getCalendarObj(data.getLong("calendarid"));
                if (this.isDisablePlanCalendarOp(opKey)) {
                    this.disablePlanCalendar(planOrgIdSet, org2sync, orgId, opKey, updateTag, calendarSetId);
                    continue;
                }
                if ((calendarId == null || calendarId.equals(0L)) && !this.checkCalendarIsEnable(calendar)) {
                    errorMsg.append(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\uff0c\u751f\u4ea7\u65e5\u5386\u7f16\u7801\u201c%2$s\u201d\u4e0d\u5904\u4e8e\u5ba1\u6838\u53ef\u7528\u7684\u72b6\u6001\uff0c\u4e0d\u8fdb\u884c\u8ba1\u5212\u65e5\u5386\u7684\u540c\u6b65\u3002", (String)"CalendarServiceImpl_13", (String)APPPARAM, (Object[])new Object[0]), org.getString("name"), calendar.getString("number")));
                    continue;
                }
                JSONObject calendarJs = this.getCalendarData(orgId, "A", "B", data.getLong("calendarid"), null, null);
                boolean isSuccessful = calendarJs.getBoolean("issuccessful");
                if (!isSuccessful) {
                    errorMsg.append(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\uff0c\u751f\u4ea7\u65e5\u5386\u7f16\u7801\u201c%2$s\u201d\u540c\u6b65\u66f4\u65b0%3$s\u65f6\u53d1\u751f\u9519\u8bef\uff1a%4$s", (String)"CalendarServiceImpl_1", (String)APPPARAM, (Object[])new Object[0]), org.getString("name"), calendar.getString("number"), updateTag, calendarJs.getString("msg")));
                    continue;
                }
                DynamicObject planCalendar = this.getPlanCalendar(orgId);
                if (planCalendar == null) {
                    planCalendar = this.buildPlanCalendar(data, orgId);
                    planCalendar.set("createorg", (Object)org);
                } else {
                    this.updatePlanCalendarData(data.getLong("calendarid"), planCalendar);
                }
                String oldDatas = this.getPlanCalendarDateEntry(planCalendar);
                String newDatas = this.syncWorkDateEntry(planCalendar, calendarJs);
                String saveMsg = this.savePlanCalendar(planCalendar);
                if (!StringUtils.isEmpty((String)saveMsg)) {
                    errorMsg.append(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\uff0c\u751f\u4ea7\u65e5\u5386\u7f16\u7801\u201c%2$s\u201d\u540c\u6b65\u66f4\u65b0%3$s\u65f6\u53d1\u751f\u9519\u8bef\uff1a%4$s", (String)"CalendarServiceImpl_1", (String)APPPARAM, (Object[])new Object[0]), org.getString("name"), calendar.getString("number"), updateTag, saveMsg));
                    continue;
                }
                this.createSyncLog((Long)planCalendar.getPkValue(), updateTag, calendar, org, "D", data.getLong("id"), planCalendar, oldDatas, newDatas, remark);
            }
        }
        catch (Exception e) {
            errorMsg.append(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return errorMsg.toString();
    }

    private boolean isSyncPlanCalendar(Long org, Map<Long, Boolean> org2sync) {
        return org2sync.computeIfAbsent(org, k -> {
            AppParam appParam = new AppParam("064+L=UVGI9P", org);
            Map fmmParam = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
            return fmmParam.containsKey("issyncplancalendar") && (Boolean)fmmParam.get("issyncplancalendar") != false;
        });
    }

    private boolean isSyncProductOrg(Long org, Map<Long, Boolean> org2sync) {
        return org2sync.computeIfAbsent(org, k -> {
            AppParam appParam = new AppParam("064+L=UVGI9P", org);
            Map fmmParam = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
            return fmmParam.containsKey("issynchiscalendarset") && (Boolean)fmmParam.get("issynchiscalendarset") != false;
        });
    }

    private String getSimpleSql(String fullSql) {
        if (fullSql != null && fullSql.length() > 240) {
            return fullSql.substring(0, 240);
        }
        return fullSql;
    }

    private DynamicObject genSyncLog(String desc, DynamicObject calendar, DynamicObject org, Long setId) {
        Date currentDate = new Date();
        DynamicObject syncLog = BusinessDataServiceHelper.newDynamicObject((String)"mpdm_calendarsynclog");
        syncLog.set("number", (Object)new SimpleDateFormat("yyyyMMddHHmmss").format(currentDate));
        syncLog.set("name", (Object)desc);
        syncLog.set("status", (Object)"C");
        syncLog.set("enable", (Object)"1");
        syncLog.set("productcalendar", (Object)calendar);
        syncLog.set("org", (Object)org);
        syncLog.set("setid", (Object)setId);
        return syncLog;
    }

    private String savePlanCalendar(DynamicObject planCalendar) {
        Long id = planCalendar.getLong("id");
        try {
            if (this.isNullLong(id)) {
                OperationResult saveResult = SaveServiceHelper.saveOperate((String)planCalendar.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{planCalendar}, (OperateOption)this.getOperateOption());
                if (!saveResult.isSuccess()) {
                    return this.getErrorMsg(saveResult);
                }
            } else {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{planCalendar});
            }
        }
        catch (Exception e) {
            return ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
        }
        return "";
    }

    private String saveProductOrg(DynamicObject productOrg) {
        try {
            OperationResult saveResult = SaveServiceHelper.saveOperate((String)productOrg.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{productOrg}, (OperateOption)this.getOperateOption());
            if (!saveResult.isSuccess()) {
                return this.getErrorMsg(saveResult);
            }
        }
        catch (Exception e) {
            return ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
        }
        return "";
    }

    public String getErrorMsg(OperationResult operationResult) {
        StringBuilder errMsg = new StringBuilder();
        List validateErrors = operationResult.getValidateResult().getValidateErrors();
        for (ValidateResult validateResult : validateErrors) {
            List allErrorInfo = validateResult.getAllErrorInfo();
            String validatorKey = validateResult.getValidatorKey();
            allErrorInfo.forEach(operateErrorInfo -> {
                String message = operateErrorInfo.getMessage();
                errMsg.append(validatorKey).append(message);
            });
        }
        if (errMsg.length() < 1 && !operationResult.getAllErrorInfo().isEmpty()) {
            errMsg.append(operationResult.getAllErrorInfo());
        }
        if (errMsg.length() < 1 && !operationResult.isSuccess() && operationResult.getMessage() != null) {
            errMsg.append(operationResult.getMessage());
        }
        if (errMsg.length() < 1 && operationResult.getInteractionContext() != null && operationResult.getInteractionContext().getSimpleMessage() != null) {
            errMsg.append(operationResult.getInteractionContext().getSimpleMessage());
        }
        if (errMsg.length() < 1 && !operationResult.isSuccess()) {
            errMsg.append(operationResult.toString());
        }
        return errMsg.toString();
    }

    private OperateOption getOperateOption() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("ignorewarn", "true");
        option.setVariableValue("ignoreinteraction", "true");
        option.setVariableValue("batchop_batchsize", "50");
        option.setVariableValue("needlog", String.valueOf(true));
        return option;
    }

    private String syncWorkDateEntry(DynamicObject planCalendar, JSONObject calendarJs) {
        String resultData = calendarJs.getString("data");
        JSONArray dataArray = JSON.parseArray((String)resultData);
        JSONObject calendarWorkDateJs = dataArray.getJSONObject(0);
        JSONObject workDateEntryJs = calendarWorkDateJs.getJSONObject("workdateentry");
        DynamicObjectCollection coll = planCalendar.getDynamicObjectCollection("dateentry");
        StringBuilder updateMsg = new StringBuilder();
        coll.clear();
        Set datesSet = workDateEntryJs.keySet();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            int seq = 0;
            for (String workDates : datesSet) {
                Date workDate = dateFormat.parse(workDates);
                String workType = workDateEntryJs.getString(workDates);
                updateMsg.append("workdate:").append(workDates).append(",datetype:").append(workType).append(";");
                DynamicObject entry = coll.addNew();
                entry.set("workdate", (Object)workDate);
                entry.set("datetype", (Object)workType);
                entry.set("seq", (Object)seq++);
            }
        }
        catch (ParseException e) {
            log.error((Throwable)e);
            updateMsg.append("date paese error:").append(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        if (coll.size() > 1) {
            coll.sort((Comparator)new CalendarDateCollComparatorImpl());
            for (int i = 0; i < coll.size(); ++i) {
                ((DynamicObject)coll.get(i)).set("seq", (Object)(i + 1));
            }
        }
        return updateMsg.toString();
    }

    private String getPlanCalendarDateEntry(DynamicObject planCalendar) {
        StringBuilder oldDatas = new StringBuilder();
        DynamicObjectCollection coll = planCalendar.getDynamicObjectCollection("dateentry");
        for (DynamicObject entry : coll) {
            oldDatas.append("workdate:").append(entry.get("workdate")).append(",datetype:").append(entry.get("datetype")).append(";");
        }
        return oldDatas.toString();
    }

    private DynamicObject buildPlanCalendar(DynamicObject setData, Long orgId) {
        Long productCalendarId = setData.getLong("calendarid");
        DynamicObject planCalendar = BusinessDataServiceHelper.newDynamicObject((String)"mrp_plancalendar");
        this.updatePlanCalendarData(productCalendarId, planCalendar);
        planCalendar.set("isfault", (Object)true);
        planCalendar.set("enable", (Object)"1");
        planCalendar.set("status", (Object)"C");
        planCalendar.set("createorg", (Object)orgId);
        String oldNumber = planCalendar.getString("number");
        planCalendar.set("number", (Object)this.getNewNumber(oldNumber, orgId));
        return planCalendar;
    }

    private void updatePlanCalendarData(Long productCalendarId, DynamicObject planCalendar) {
        DynamicObject productCalendar = BusinessDataServiceHelper.loadSingleFromCache((Object)productCalendarId, (String)"mpdm_calendar");
        EcoCommonHelper.putHeadProperties(productCalendar, planCalendar, this.getUnIncludeFieldSet());
    }

    private String getNewNumber(String oldNumber, Long orgId) {
        QFilter qf = new QFilter("number", "like", (Object)(oldNumber + "%"));
        qf.and(new QFilter("createorg", "=", (Object)orgId));
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"mrp_plancalendar", (String)"id", (QFilter[])new QFilter[]{qf});
        return oldNumber + "_" + (coll.size() + 1);
    }

    private Set<String> getUnIncludeFieldSet() {
        HashSet<String> fieldSet = new HashSet<String>(16);
        fieldSet.add("id");
        fieldSet.add("masterid");
        fieldSet.add("isfault");
        fieldSet.add("createtime");
        fieldSet.add("modifytime");
        fieldSet.add("createorg");
        fieldSet.add("org");
        fieldSet.add("useorg");
        fieldSet.add("modifier");
        fieldSet.add("sourcedata");
        fieldSet.add("isindividuation");
        fieldSet.add("bitindex");
        fieldSet.add("srcindex");
        fieldSet.add("srccreateorg");
        fieldSet.add("creator");
        fieldSet.add("isrsyncplancalendar");
        fieldSet.add("srccalendarid");
        fieldSet.add("ctrlstrategy");
        return fieldSet;
    }

    private DynamicObject getPlanCalendar(Long orgId) {
        QFilter qfilter = new QFilter("createorg", "=", (Object)orgId);
        qfilter.and(new QFilter("isfault", "=", (Object)true));
        qfilter.and(new QFilter("enable", "=", (Object)"1"));
        qfilter.and(new QFilter("status", "=", (Object)"C"));
        DynamicObject idData = QueryServiceHelper.queryOne((String)"mrp_plancalendar", (String)"id", (QFilter[])new QFilter[]{qfilter});
        if (idData != null) {
            DynamicObject planCalendar = BusinessDataServiceHelper.newDynamicObject((String)"mrp_plancalendar");
            return BusinessDataServiceHelper.loadSingle((Object)idData.getLong("id"), (DynamicObjectType)planCalendar.getDynamicObjectType());
        }
        return null;
    }

    private DynamicObject getCalendarObj(Long calendarId) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)calendarId, (String)"mpdm_calendar", (String)"createorg,id,number,name,enable,status");
    }

    private String getCalendarStr(Long calendarId) {
        DynamicObject calendar = null;
        if (!this.isNullLong(calendarId)) {
            calendar = this.getCalendarObj(calendarId);
        }
        return String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u65e5\u5386\uff1a%1$s", (String)"CalendarServiceImpl_3", (String)APPPARAM, (Object[])new Object[0]), calendar == null ? "" : calendar.getString("number") + "_" + calendar.getString("name"));
    }

    private String getClassSystemStr(Long classSystemId) {
        DynamicObject classSystem = null;
        if (!this.isNullLong(classSystemId)) {
            classSystem = BusinessDataServiceHelper.loadSingleFromCache((Object)classSystemId, (String)"mpdm_classsystem", (String)"number,name");
        }
        return String.format(ResManager.loadKDString((String)"\u73ed\u5236\uff1a%1$s", (String)"CalendarServiceImpl_4", (String)APPPARAM, (Object[])new Object[0]), classSystem == null ? "" : classSystem.getString("number") + "_" + classSystem.getString("name"));
    }

    @Override
    public Date getFirstWorkDate(Long bizDataId, String bizObjectType, String fromModel, Long calendarId, Date startDate, boolean isForward) {
        String workType = this.getWorkDateType(bizDataId, bizObjectType, fromModel, calendarId, startDate);
        if (workType == null || workType != null && workType.startsWith("error:")) {
            return null;
        }
        if ("1".equals(workType)) {
            return startDate;
        }
        return this.getRecentlyWorkDate(bizDataId, bizObjectType, fromModel, calendarId, startDate, isForward ? 1 : -1);
    }
}

