/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.colsassist;

import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.colsassist.IColsSelectStrategy;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.servicehelper.MetadataServiceHelper;

public class DefaultSelectStrategy
implements IColsSelectStrategy {
    @Override
    public boolean filterEntryPro(EntryType pro) {
        return "billentry".equals(pro.getName());
    }

    @Override
    public TreeNode buildNode4BaseData(TreeNode parentNode, BasedataProp pro, boolean needBaseDataSubAttr) {
        if (!this.filterBaseDataPro(pro)) {
            return null;
        }
        TreeNode baseDataNode = needBaseDataSubAttr ? this.getLowerTreeNode(parentNode, (IDataEntityProperty)pro) : ("0".equals(parentNode.getId()) ? this.getTreeNode(parentNode.getId(), pro.getName(), pro.getDisplayName().getLocaleValue()) : this.getTreeNode(parentNode.getId(), parentNode.getId() + '.' + pro.getName(), parentNode.getText() + '.' + pro.getDisplayName().getLocaleValue()));
        if (pro instanceof FlexProp) {
            return baseDataNode;
        }
        this.fillBaseDataTree(baseDataNode, pro.getBaseEntityId(), pro);
        return baseDataNode;
    }

    private TreeNode getTreeNode(String parentId, IDataEntityProperty pro) {
        return this.getTreeNode(parentId, pro.getName(), pro.getDisplayName().getLocaleValue());
    }

    private void fillBaseDataTree(TreeNode baseDataNode, String baseDataNo, BasedataProp basedataProp) {
        if (StringUtils.isBlank((CharSequence)baseDataNo)) {
            return;
        }
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)baseDataNo);
        Map fields = type.getFields();
        Set<String> cols = this.getNeedColsOfBaseData(baseDataNo);
        Set<String> addCols = this.getNeedColsOfBaseData(baseDataNo, basedataProp);
        if (cols == null) {
            cols = addCols;
        } else if (addCols != null) {
            cols.addAll(addCols);
        }
        this.addChild(addCols, fields, baseDataNode);
    }

    private void addChild(Set<String> cols, Map<String, IDataEntityProperty> fields, TreeNode baseDataNode) {
        if (cols == null) {
            for (IDataEntityProperty pro : fields.values()) {
                if (!this.fixedFilter(pro)) continue;
                baseDataNode.addChild(this.getLowerTreeNode(baseDataNode, pro));
            }
        } else {
            for (String col : cols) {
                IDataEntityProperty pro = fields.get(col);
                if (pro == null || !this.fixedFilter(pro)) continue;
                baseDataNode.addChild(this.getLowerTreeNode(baseDataNode, pro));
            }
        }
    }

    private TreeNode getLowerTreeNode(TreeNode baseDataNode, IDataEntityProperty pro) {
        String parentId = baseDataNode.getId();
        String parentText = baseDataNode.getText();
        StringBuilder id = new StringBuilder();
        id.append(parentId).append('.').append(pro.getName());
        StringBuilder text = new StringBuilder();
        text.append(parentText).append('.').append(pro.getDisplayName());
        return this.getTreeNode(parentId, id.toString(), text.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void buildNode4Head(TreeNode root, IDataEntityProperty pro, String orgType) {
        TreeNode node;
        if (!this.fixedFilter(pro)) {
            return;
        }
        if (!this.filterPro(pro)) {
            return;
        }
        if (pro instanceof BasedataProp) {
            if (orgType != null && !orgType.isEmpty() && pro instanceof OrgProp) {
                if (!orgType.equals(((OrgProp)pro).getOrgFunc())) return;
                node = this.buildNode4BaseData(root, (BasedataProp)pro, false);
            } else {
                node = this.buildNode4BaseData(root, (BasedataProp)pro, false);
            }
        } else {
            node = this.getTreeNode(root.getId(), pro);
        }
        root.addChild(node);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void buildNode4Entry(TreeNode entryNode, IDataEntityProperty pro, String orgType) {
        TreeNode node;
        if (!this.fixedFilter(pro)) {
            return;
        }
        if (!this.filterPro(pro)) {
            return;
        }
        if (pro instanceof BasedataProp) {
            if (orgType != null && !orgType.isEmpty() && pro instanceof OrgProp) {
                if (!orgType.equals(((OrgProp)pro).getOrgFunc())) return;
                node = this.buildNode4BaseData(entryNode, (BasedataProp)pro, false);
            } else {
                node = this.buildNode4BaseData(entryNode, (BasedataProp)pro, false);
            }
        } else {
            node = this.getLowerTreeNode(entryNode, pro);
        }
        entryNode.addChild(node);
    }
}

