/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.colsassist;

import java.util.HashMap;
import java.util.Map;
import kd.bd.mpdm.common.colsassist.DefaultSelectStrategy;
import kd.bd.mpdm.common.colsassist.IColsSelectStrategy;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.MetadataServiceHelper;

public class MetaHelper {
    private IColsSelectStrategy strategy;
    private MainEntityType meta;

    public MetaHelper(IColsSelectStrategy strategy, MainEntityType meta) {
        if (meta == null) {
            throw new KDBizException(this.getMsgMetaHelperError());
        }
        this.meta = meta;
        this.strategy = strategy == null ? new DefaultSelectStrategy() : strategy;
    }

    private String getMsgMetaHelperError() {
        return ResManager.loadKDString((String)"MetaHelper:\u4f20\u5165\u7684\u5b9e\u4f53\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (String)"MetaHelper_0", (String)"bd-mpdm-common", (Object[])new Object[0]);
    }

    public MetaHelper(IColsSelectStrategy strategy, String metaNo) {
        this(strategy, MetadataServiceHelper.getDataEntityType((String)metaNo));
    }

    public MetaHelper(String metaNo) {
        this(null, metaNo);
    }

    public MetaHelper(MainEntityType meta) {
        this(null, meta);
    }

    public MetaHelper(MainEntityType meta, String no1, String no2) {
        this(null, meta);
    }

    private String getRootId() {
        return "0";
    }

    public String buildTree2JSON() {
        return SerializationUtils.toJsonString((Object)this.buildTree(""));
    }

    public TreeNode buildTree(String orgType) {
        Map allFields = this.meta.getAllFields();
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>();
        String rootId = this.getRootId();
        TreeNode root = new TreeNode(null, rootId, this.meta.getDisplayName().getLocaleValue());
        nodeMap.put(rootId, root);
        root.setIsOpened(true);
        IDataEntityType parent = null;
        for (IDataEntityProperty pro : allFields.values()) {
            parent = pro.getParent();
            if (parent instanceof MainEntityType) {
                this.strategy.buildNode4Head(root, pro, orgType);
                continue;
            }
            if (!(parent instanceof EntryType) || !(parent.getParent() instanceof MainEntityType)) continue;
            TreeNode entryNode = this.getEntryNode(nodeMap, parent);
            this.strategy.buildNode4Entry(entryNode, pro, orgType);
            if (nodeMap.containsKey(entryNode.getId())) continue;
            nodeMap.put(entryNode.getId(), entryNode);
            root.addChild(entryNode);
        }
        return root;
    }

    private TreeNode getEntryNode(Map<String, TreeNode> nodeMap, IDataEntityType entryPro) {
        String entryName = entryPro.getName();
        TreeNode entryNode = nodeMap.get(entryName);
        if (entryNode == null) {
            entryNode = this.strategy.getTreeNode(this.getRootId(), entryName, entryPro.getDisplayName().toString());
            entryNode.setIsOpened(true);
        }
        return entryNode;
    }
}

