/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.gantt.util;

import java.util.ArrayList;
import kd.bd.mpdm.common.gantt.util.GanttBigObjectUtils;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;

public class GanttBigObjectCache {
    private static final int TIMEOUT = 36000;
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("gantt-bigobject");

    public static <T> void put(String type, String key, T value, int timeoutSeconds) {
        cache.put(GanttBigObjectCache.getCacheKey(type, key), GanttBigObjectUtils.encode(value), timeoutSeconds);
    }

    public static <T> void put(String type, String key, T value) {
        GanttBigObjectCache.put(type, key, value, 36000);
    }

    public static <T> T get(String type, String key) {
        byte[] bytes = cache.getByteValue(type + "." + key);
        return (T)GanttBigObjectUtils.decode(bytes);
    }

    public static void remove(String type, String ... keys) {
        ArrayList<String> cacheKeyList = new ArrayList<String>(keys.length);
        for (String key : keys) {
            cacheKeyList.add(GanttBigObjectCache.getCacheKey(type, key));
        }
        String[] cacheKeys = cacheKeyList.toArray(new String[cacheKeyList.size()]);
        cache.remove(cacheKeys);
    }

    private static String getCacheKey(String type, String key) {
        return type + "." + key;
    }
}

