/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.manuftech;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bd.mpdm.common.mftorder.utils.OrderOpUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.ext.scmc.chargeagainst.consts.BillOpEnum;
import kd.bos.ext.scmc.chargeagainst.service.CaLogService;
import kd.bos.ext.scmc.chargeagainst.service.impl.CaLogServiceImpl;
import kd.bos.ext.scmc.chargeagainst.util.BotpLinkHelper;
import kd.bos.ext.scmc.chargeagainst.util.CommonUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import kd.bos.util.ExceptionUtils;

public class ChargeAgainstUtil {
    private static final Log logger = LogFactory.getLog(ChargeAgainstUtil.class);

    public static DynamicObject copyBill(DynamicObject srcBill, String entrySeq, String reason, Date caDate, Date cabookdate, CaLogService caLogService) {
        long start = System.currentTimeMillis();
        DynamicObject copyData = (DynamicObject)OrmUtils.clone((IDataEntityBase)srcBill, (boolean)true, (boolean)true);
        long end = System.currentTimeMillis();
        logger.info("\u590d\u5236\u5355\u636e\u65f6\u95f4:" + (end - start));
        String billNoKey = ((BillEntityType)copyData.getDataEntityType()).getBillNo();
        String origBillNo = srcBill.getString(billNoKey);
        String number = "CX-" + origBillNo + "-" + entrySeq;
        copyData.set(billNoKey, (Object)number);
        String remake = String.format(ResManager.loadKDString((String)"\u51b2\u9500%1$s", (String)"ChargeAgainstUtil_3", (String)"bd-mpdm-common", (Object[])new Object[0]), srcBill.getString(billNoKey));
        StringBuilder sb = new StringBuilder(remake);
        if (StringUtils.isNotEmpty((CharSequence)reason)) {
            sb.append("\uff0c");
            sb.append(String.format(ResManager.loadKDString((String)"\u539f\u56e0\u4e3a%1$s%2$s", (String)"ChargeAgainstUtil_1", (String)"bd-mpdm-common", (Object[])new Object[0]), ":", reason));
        }
        copyData.set("remark", (Object)sb.toString());
        copyData.set("reportdate", (Object)caDate);
        copyData.set("bookdate", (Object)cabookdate);
        copyData.set("billstatus", (Object)"A");
        copyData.set("ischargeoff", (Object)Boolean.TRUE);
        copyData.set("createtime", (Object)new Date());
        copyData.set("creator", (Object)UserServiceHelper.getCurrentUser((String)"id"));
        DynamicObjectCollection copyBillEntryList = copyData.getDynamicObjectCollection("sumentry");
        List proList = CommonUtil.getAmoutAndQtyFieldList((DynamicObject)copyData, (String)"sumentry");
        for (int i = 0; i < copyBillEntryList.size(); ++i) {
            DynamicObject copyEntry = (DynamicObject)copyBillEntryList.get(i);
            if (copyEntry.getString("seq").equals(entrySeq)) {
                Object otherproductentity2;
                for (String field : proList) {
                    BigDecimal value = copyEntry.getBigDecimal(field);
                    copyEntry.set(field, (Object)BigDecimal.ZERO.subtract(value));
                }
                DynamicObjectCollection otherproductentitys = copyEntry.getDynamicObjectCollection("otherproductentity");
                List otherList = CommonUtil.getAmoutAndQtyFieldList((DynamicObject)copyData, (String)"otherproductentity");
                for (Object otherproductentity2 : otherproductentitys) {
                    for (String field : otherList) {
                        BigDecimal value = otherproductentity2.getBigDecimal(field);
                        otherproductentity2.set(field, (Object)BigDecimal.ZERO.subtract(value));
                    }
                }
                DynamicObjectCollection childreportentitys = copyEntry.getDynamicObjectCollection("childreportentity");
                otherproductentity2 = childreportentitys.iterator();
                while (otherproductentity2.hasNext()) {
                    DynamicObject childreportentity = (DynamicObject)otherproductentity2.next();
                    BigDecimal qtyfield = childreportentity.getBigDecimal("qtyfield");
                    childreportentity.set("qtyfield", (Object)BigDecimal.ZERO.subtract(qtyfield));
                }
                DynamicObjectCollection repsubentryentitys = copyEntry.getDynamicObjectCollection("repsubentryentity");
                for (int k = 0; k < repsubentryentitys.size(); ++k) {
                    DynamicObject repsubentryentity = (DynamicObject)repsubentryentitys.get(k);
                    BigDecimal repactualqty = repsubentryentity.getBigDecimal("repactualqty");
                    repsubentryentity.set("repactualqty", (Object)BigDecimal.ZERO.subtract(repactualqty));
                }
                continue;
            }
            copyBillEntryList.remove(i);
            --i;
        }
        BotpLinkHelper.clearBillLink((DynamicObject)copyData);
        BotpLinkHelper.clearBillEntryLink((DynamicObjectCollection)copyBillEntryList);
        ChargeAgainstUtil.buildBillEntryLink(srcBill, copyData);
        long end1 = System.currentTimeMillis();
        logger.info("\u51b2\u9500\u6570\u91cf\u53d6\u53cd\u53ca\u5efa\u7acbbotp\u5173\u7cfb\u65f6\u95f4:" + (end1 - end));
        caLogService.buildCaLogCaBillEntryData(srcBill, copyData);
        return copyData;
    }

    public static void buildBillEntryLink(DynamicObject sourceBill, DynamicObject targetBill) {
        String sourceBillType = sourceBill.getDynamicObjectType().getName();
        if (sourceBill == null || targetBill == null) {
            return;
        }
        String entryName = "sumentry";
        Long srcTableId = ConvertMetaServiceHelper.loadTableDefine((String)sourceBillType, (String)entryName).getTableId();
        DynamicObjectCollection tagBillEntryList = targetBill.getDynamicObjectCollection(entryName);
        DynamicObjectCollection billEntryList = sourceBill.getDynamicObjectCollection(entryName);
        for (int i = 0; i < billEntryList.size(); ++i) {
            DynamicObject entry = (DynamicObject)billEntryList.get(i);
            DynamicObject tagEntry = (DynamicObject)tagBillEntryList.get(0);
            if (!entry.getString("seq").equals(tagEntry.getString("seq"))) continue;
            DynamicObjectCollection tagLinkRows = (DynamicObjectCollection)tagEntry.get("sumentry_lk");
            DynamicObject linkeEntryRow = tagLinkRows.addNew();
            linkeEntryRow.set("sumentry_lk_stableid", (Object)srcTableId);
            linkeEntryRow.set("sumentry_lk_sbillid", sourceBill.getPkValue());
            linkeEntryRow.set("sumentry_lk_sid", entry.getPkValue());
        }
    }

    public static void updateCaBilledStatus(DynamicObject isBilled, Boolean status) {
        isBilled.set("ischargeoffed", (Object)status);
        String dbRouteKey = isBilled.getDataEntityType().getDBRouteKey();
        String alias = isBilled.getDataEntityType().getAlias();
        String sql = " update " + alias + " set fischargeoffed = ? where fentryid = ?";
        DB.execute((DBRoute)new DBRoute(dbRouteKey), (String)sql, (Object[])new Object[]{status, isBilled.getPkValue()});
    }

    public static void rollbackData(DynamicObject caBill, CaLogService caLogService) {
        OperateOption option = CommonUtil.getCaOption();
        String billstatus = caBill.getString("billstatus");
        if ("A".equals(billstatus)) {
            ChargeAgainstUtil.executeOp(caBill, option, BillOpEnum.DELETE, caLogService);
        } else if ("B".equals(billstatus)) {
            ChargeAgainstUtil.executeOp(caBill, option, BillOpEnum.UNSUBMIT, caLogService);
            ChargeAgainstUtil.executeOp(caBill, option, BillOpEnum.DELETE, caLogService);
        } else if ("C".equals(billstatus)) {
            option.setVariableValue("isSysCall", "true");
            ChargeAgainstUtil.executeOp(caBill, option, BillOpEnum.UNAUDIT, caLogService);
            ChargeAgainstUtil.executeOp(caBill, option, BillOpEnum.DELETE, caLogService);
        }
    }

    public static void caRollback(DynamicObject srcBill, String entrySeq, DynamicObject caBill, CaLogService caLogService) {
        logger.info("\u5f00\u59cb\u51b2\u9500\u56de\u6eda\u64cd\u4f5ccaRollback");
        try {
            DynamicObjectCollection sumentitys = srcBill.getDynamicObjectCollection("sumentry");
            for (DynamicObject obj : sumentitys) {
                if (!obj.getString("seq").equals(entrySeq)) continue;
                ChargeAgainstUtil.updateCaBilledStatus(obj, Boolean.FALSE);
                break;
            }
            ChargeAgainstUtil.rollbackData(caBill, caLogService);
            caLogService.getCaLogVo().setCastatus("3");
        }
        catch (Exception e1) {
            logger.error("\u56de\u6eda\u51b2\u9500\u5355\u636e\u5931\u8d25\uff1a" + e1.getMessage());
            caLogService.getCaLogVo().setCastatus("2");
            caLogService.getCaLogVo().setCaBillFailcause(String.format(ResManager.loadKDString((String)"\u51b2\u9500\u56de\u6eda\u5931\u8d25,%1$s", (String)"ChargeAgainstUtil_4", (String)"bd-mpdm-common", (Object[])new Object[0]), e1.getMessage()));
            throw new KDBizException(e1.getMessage());
        }
    }

    public static void executeOp(DynamicObject generatBill, OperateOption option, BillOpEnum op, CaLogService caLogService) {
        String name = generatBill.getDataEntityType().getName();
        IDataEntityType dataEntityType = generatBill.getDataEntityType();
        String billNoKey = ((BillEntityType)dataEntityType).getBillNo();
        String billNo = generatBill.getString(billNoKey);
        OperationResult result = op == BillOpEnum.SAVE ? OperationServiceHelper.executeOperate((String)op.getOpKey(), (String)name, (DynamicObject[])new DynamicObject[]{generatBill}, (OperateOption)option) : OperationServiceHelper.executeOperate((String)op.getOpKey(), (String)name, (Object[])new Object[]{generatBill.getPkValue()}, (OperateOption)option);
        List successPkIds = result.getSuccessPkIds();
        String billType = generatBill.getDataEntityType().getName();
        caLogService.getCaLogVo().setGenerateBillEntry(billType, successPkIds, op);
        if (!result.isSuccess()) {
            logger.error(op.getOpName() + "\u51b2\u9500\u5355\u636e" + name + "\u5931\u8d25\uff1a" + generatBill.getPkValue() + OrderOpUtils.getErrDetail(result));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u51b2\u9500\u5355\u636e%2$s\u5931\u8d25\uff1a%3$s", (String)"ChargeAgainstUtil_2", (String)"bd-mpdm-common", (Object[])new Object[0]), op.getOpName(), billNo, OrderOpUtils.getErrDetail(result)));
        }
        if (op == BillOpEnum.SAVE) {
            generatBill.set("id", successPkIds.get(0));
        }
    }

    private static CaLogService getCaLogService() {
        return new CaLogServiceImpl();
    }

    public static String startCaServiceOp(DynamicObject srcBill, String entrySeq, String reason, Date caDate, Date cabookdate) {
        long start = System.currentTimeMillis();
        CaLogService caLogService = ChargeAgainstUtil.getCaLogService();
        caLogService.setCaLogHead(srcBill);
        DynamicObject caBill = ChargeAgainstUtil.copyBill(srcBill, entrySeq, reason, caDate, cabookdate, caLogService);
        String cxBillNo = caBill.getString("billno");
        if (kd.bos.util.StringUtils.isEmpty((String)cxBillNo)) {
            cxBillNo = String.valueOf(caBill.getPkValue());
        }
        try {
            OperateOption option = CommonUtil.getCaOption();
            ChargeAgainstUtil.executeOp(caBill, option, BillOpEnum.SAVE, caLogService);
            caLogService.getCaLogVo().setCastatus("2");
            caLogService.saveCaLog();
            ChargeAgainstUtil.executeOp(caBill, option, BillOpEnum.SUBMIT, caLogService);
            ChargeAgainstUtil.executeOp(caBill, option, BillOpEnum.AUDIT, caLogService);
            long end6 = System.currentTimeMillis();
            logger.info("\u51b2\u9500\u5355\u636e\u603b\u65f6\u95f4:" + (end6 - start));
            DynamicObjectCollection sumentitys = srcBill.getDynamicObjectCollection("sumentry");
            for (DynamicObject obj : sumentitys) {
                if (!obj.getString("seq").equals(entrySeq)) continue;
                ChargeAgainstUtil.updateCaBilledStatus(obj, Boolean.TRUE);
                if ("sfc_processreportbill".equals(srcBill.getDataEntityType().getName()) || "prop_processreportbill".equals(srcBill.getDataEntityType().getName())) {
                    ChargeAgainstUtil.removeRep(obj, srcBill.getDataEntityType().getName());
                }
                String string = cxBillNo;
                return string;
            }
            caLogService.getCaLogVo().setCastatus("1");
        }
        catch (Exception e) {
            logger.error("\u51b2\u9500\u5355\u636e\u64cd\u4f5c\u5931\u8d25 !", (Throwable)e);
            String failMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            caLogService.getCaLogVo().setCaBillFailcause(failMessage);
            ChargeAgainstUtil.caRollback(srcBill, entrySeq, caBill, caLogService);
            throw new KDBizException(failMessage);
        }
        finally {
            caLogService.saveCaLog();
        }
        return cxBillNo;
    }

    public static String startCaService(DynamicObject srcBill, String entrySeq, String reason, Date caDate, Date cabookdate) {
        String startCaServiceOp = ChargeAgainstUtil.startCaServiceOp(srcBill, entrySeq, reason, caDate, cabookdate);
        IDataEntityType dataEntityType = srcBill.getDataEntityType();
        String entityName = dataEntityType.getName();
        if ("sfc_processreportbill".equals(entityName) || "prop_processreportbill".equals(entityName)) {
            DynamicObjectCollection srcSumentrys = srcBill.getDynamicObjectCollection("sumentry");
            Long entryValue = 0L;
            for (DynamicObject sumentry : srcSumentrys) {
                if (!entrySeq.equals(sumentry.getString("seq"))) continue;
                entryValue = (Long)sumentry.getPkValue();
            }
            QFilter qFilter = new QFilter("sumentry.processentryid", "=", (Object)entryValue);
            qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
            qFilter.and(new QFilter("ischargeoff", "=", (Object)false));
            qFilter.and(new QFilter("sumentry.ischargeoffed", "=", (Object)false));
            DynamicObjectCollection querys = QueryServiceHelper.query((String)entityName, (String)"billno,id,sumentry.id", (QFilter[])new QFilter[]{qFilter});
            HashSet<Long> billidSet = new HashSet<Long>(16);
            HashSet<Long> billentryidSet = new HashSet<Long>(16);
            for (DynamicObject load : querys) {
                billidSet.add(load.getLong("id"));
                billentryidSet.add(load.getLong("sumentry.id"));
            }
            HashMap<String, Object> calparam = new HashMap<String, Object>(16);
            calparam.put("billid", billidSet);
            calparam.put("billentryid", billentryidSet);
            calparam.put("reason", reason);
            calparam.put("cadate", caDate);
            calparam.put("cabookdate", cabookdate);
            calparam.put("appId", "mpdm");
            calparam.put("entityName", entityName);
            String jsonString = JSON.toJSONString(calparam);
            EventServiceHelper.triggerEventSubscribe((String)"mpdm_processreportchargeAgainst", (String)jsonString);
        }
        return startCaServiceOp;
    }

    private static void buildLogHead(DynamicObject calog, DynamicObject srcBill) {
        String billNo = CommonUtil.getBillNo((DynamicObject)srcBill);
        String billType = srcBill.getDataEntityType().getName();
        calog.set("caSourceType", (Object)billType);
        calog.set("caSourceBillno", (Object)billNo);
        calog.set("caSourceId", srcBill.getPkValue());
        calog.set("traceId", (Object)RequestContext.get().getTraceId());
    }

    private static void removeRep(DynamicObject reportbill, String entityName) {
        DynamicObjectCollection repsubentryentitys = reportbill.getDynamicObjectCollection("repsubentryentity");
        Long oprentryid = 0L;
        String manuftechEntityName = "sfc_manftech";
        if ("prop_processreportbill".equalsIgnoreCase(entityName)) {
            oprentryid = Long.valueOf(reportbill.getString("oprentry.id"));
            manuftechEntityName = "prop_manftech";
        } else {
            oprentryid = Long.valueOf(reportbill.getString("oprentryid"));
        }
        DynamicObject manftech = BusinessDataServiceHelper.loadSingle((String)manuftechEntityName, (String)ChargeAgainstUtil.selectProperties(), (QFilter[])new QFilter[]{new QFilter("oprentryentity.id", "=", (Object)oprentryid)});
        if (manftech == null) {
            return;
        }
        DynamicObjectCollection manftechentrys = manftech.getDynamicObjectCollection("oprentryentity");
        for (DynamicObject manftechentry : manftechentrys) {
            if (!manftechentry.getPkValue().toString().equals(oprentryid.toString())) continue;
            DynamicObjectCollection repentitys = manftechentry.getDynamicObjectCollection("repsubentryentity");
            for (int k = 0; k < repsubentryentitys.size(); ++k) {
                DynamicObject repentry = (DynamicObject)repsubentryentitys.get(k);
                for (int i = 0; i < repentitys.size(); ++i) {
                    if (!repentry.getPkValue().toString().equals(((DynamicObject)repentitys.get(i)).getString("srcentryid"))) continue;
                    repentitys.remove(i);
                    --i;
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{manftech});
    }

    private static String selectProperties() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("id,");
        strBuilder.append("qty").append(',');
        strBuilder.append("processroute").append(',');
        strBuilder.append("planstarttime").append(',');
        strBuilder.append("planfinishtime").append(',');
        strBuilder.append("baseqty").append(',');
        strBuilder.append("mftentryseq").append(',');
        strBuilder.append("billno").append(',');
        strBuilder.append("billstatus").append(',');
        strBuilder.append("modifytime").append(',');
        strBuilder.append("modifier").append(',');
        strBuilder.append("manufactureorderseq").append(',');
        strBuilder.append("proentryentity").append('.').append("processseqqty").append(',');
        strBuilder.append("proentryentity").append('.').append("processseq").append(',');
        strBuilder.append("proentryentity").append('.').append("processplanbegintime").append(',');
        strBuilder.append("proentryentity").append('.').append("processplanendtime").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprplanbegintime").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprno").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprplanfinishtime").append(',');
        strBuilder.append("oprentryentity").append('.').append("headqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("operationqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("operationunit").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprstandardqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprproductionqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprstatus").append(',');
        strBuilder.append("oprentryentity").append('.').append("oproperation").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprtotalqualifiedqty").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprparent").append(',');
        strBuilder.append("repsubentryentity").append('.').append("repactivity").append(',');
        strBuilder.append("repsubentryentity").append('.').append("repbaseqty").append(',');
        strBuilder.append("repsubentryentity").append('.').append("repactualqty").append(',');
        strBuilder.append("repsubentryentity").append('.').append("repactualbegintime").append(',');
        strBuilder.append("repsubentryentity").append('.').append("repactualfinishtime").append(',');
        strBuilder.append("repsubentryentity").append('.').append("srcentryid").append(',');
        strBuilder.append("repsubentryentity").append('.').append("represources").append(',');
        strBuilder.append("repsubentryentity").append('.').append("seq").append(',');
        strBuilder.append("oprentryentity").append('.').append("oprinvalid");
        return strBuilder.toString();
    }
}

