/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.manuftech.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bd.mpdm.common.mftorder.utils.CalendarUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;

public class CheckPlanDateUtil {
    public static StringBuilder checkPlanDate(DynamicObjectCollection collection, Map<Integer, Date> mapStart, Map<Integer, Date> mapEnd) {
        ArrayList<Integer> startlist = new ArrayList<Integer>();
        ArrayList<Integer> endlist = new ArrayList<Integer>();
        StringBuilder errMsg = new StringBuilder();
        for (int i = 0; i < collection.size(); ++i) {
            Date workEndDate;
            Date workBeginDate;
            DynamicObject dept = ((DynamicObject)collection.get(i)).getDynamicObject("oprorg");
            DynamicObject oprworkcenter = ((DynamicObject)collection.get(i)).getDynamicObject("oprworkcenter");
            DynamicObject oprworkshop = ((DynamicObject)collection.get(i)).getDynamicObject("oprworkshop");
            Date planBeginTime = ((DynamicObject)collection.get(i)).getDate("oprplanbegintime");
            Date planEndTime = ((DynamicObject)collection.get(i)).getDate("oprplanfinishtime");
            String oprNo = ((DynamicObject)collection.get(i)).getString("oprno");
            DynamicObject calendar = null;
            if (oprworkshop != null && calendar == null) {
                calendar = oprworkshop.getDynamicObject("fcalendar");
            }
            if (oprworkcenter != null) {
                calendar = oprworkcenter.getDynamicObject("calendar");
            }
            if (planBeginTime == null || planEndTime == null) {
                return errMsg;
            }
            if (calendar == null) {
                workBeginDate = CalendarUtils.getRecentleWorkDate(dept, planBeginTime, oprNo);
                workEndDate = CalendarUtils.getRecentleWorkDate(dept, planEndTime, oprNo);
            } else {
                workBeginDate = CalendarUtils.getRecentleWorkDate(calendar.getPkValue().toString(), planBeginTime);
                workEndDate = CalendarUtils.getRecentleWorkDate(calendar.getPkValue().toString(), planEndTime);
            }
            if (workBeginDate != null && !planBeginTime.equals(workBeginDate)) {
                startlist.add(i + 1);
                if (mapStart != null) {
                    mapStart.put(i, workBeginDate);
                }
            }
            if (workEndDate == null || planEndTime.equals(workEndDate)) continue;
            endlist.add(i + 1);
            if (mapEnd == null) continue;
            mapEnd.put(i, workEndDate);
        }
        if (startlist.size() > 0) {
            String info = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u7684\u201c\u8ba1\u5212\u5f00\u5de5\u65f6\u95f4\u201d\u4e0d\u5728\u5de5\u4f5c\u65e5\u3002", (String)"CheckPlanDateUtil_0", (String)"bd-mpdm-common", (Object[])new Object[0]), CheckPlanDateUtil.getSeqString(startlist)) + "\n";
            errMsg.append(info);
        }
        if (endlist.size() > 0) {
            String info = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u7684\u201c\u8ba1\u5212\u5b8c\u5de5\u65f6\u95f4\u201d\u4e0d\u5728\u5de5\u4f5c\u65e5\u3002", (String)"CheckPlanDateUtil_1", (String)"bd-mpdm-common", (Object[])new Object[0]), CheckPlanDateUtil.getSeqString(endlist)) + "\n";
            errMsg.append(info);
        }
        if (errMsg.length() > 0) {
            errMsg.append(ResManager.loadKDString((String)"\u662f\u5426\u7ee7\u7eed\u63d0\u4ea4\uff1f", (String)"CheckPlanDateUtil_2", (String)"bd-mpdm-common", (Object[])new Object[0]));
        }
        return errMsg;
    }

    private static String getSeqString(List<Integer> list) {
        StringJoiner stringJoiner = new StringJoiner("\u3001");
        for (Integer integer : list) {
            stringJoiner.add(String.valueOf(integer));
        }
        return stringJoiner.toString();
    }
}

