/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.manuftech.utils;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.manuftech.ManuftechUtil;
import kd.bd.mpdm.common.manuftech.utils.ManuftechCreateBillUtil;
import kd.bd.mpdm.common.mftorder.helper.OrgHelper;
import kd.bd.mpdm.common.utils.UnitPrecisionUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.UnitConvertHelper;

public class ManuftechChangeImportUtils {
    public static void setOprEntryEntity(DynamicObject xmanftechBill, DynamicObject origin) {
        DynamicObjectCollection xOprEntryEntity = xmanftechBill.getDynamicObjectCollection("oprentryentity");
        DynamicObjectCollection oOprEntryEntity = origin.getDynamicObjectCollection("oprentryentity");
        Map<Long, DynamicObject> oOprEntryOprIdXObj = oOprEntryEntity.stream().collect(Collectors.toMap(x -> x.getLong("id"), r -> r));
        DynamicObject xProentryentity = (DynamicObject)xmanftechBill.getDynamicObjectCollection("proentryentity").get(0);
        HashSet<Object> sets = new HashSet<Object>(1);
        HashMap<Object, DynamicObject> orderEntryMap = new HashMap<Object, DynamicObject>(1);
        Object orderEntryId = xmanftechBill.getDynamicObject("mftentryseq").getPkValue();
        sets.add(orderEntryId);
        ManuftechCreateBillUtil.getOrderEntityMap("pom_mftorder", sets, orderEntryMap);
        HashMap routeOprIdObj = new HashMap(1);
        DynamicObject processRouteObj = xmanftechBill.getDynamicObject("processroute");
        if (processRouteObj != null) {
            processRouteObj = BusinessDataServiceHelper.loadSingleFromCache((Object)processRouteObj.getPkValue(), (String)processRouteObj.getDataEntityType().getName());
            DynamicObjectCollection processEntry = processRouteObj.getDynamicObjectCollection("processentry");
            routeOprIdObj.putAll(processEntry.stream().collect(Collectors.toMap(x -> x.getLong("id"), Function.identity())));
        }
        for (DynamicObject xOpr : xOprEntryEntity) {
            Long oprId;
            DynamicObject oprEntryId = xOpr.getDynamicObject("oprentryid");
            Long l = oprId = oprEntryId != null ? Long.valueOf(oprEntryId.getLong("id")) : null;
            if (oOprEntryOprIdXObj.containsKey(oprId)) {
                DynamicObject oOpr = oOprEntryOprIdXObj.get(oprId);
                ManuftechCreateBillUtil.setOprEntryValue(oOpr, xOpr);
                DynamicObjectCollection oActs = oOpr.getDynamicObjectCollection("actsubentryentity");
                DynamicObjectCollection dynamicObjectCollection = xOpr.getDynamicObjectCollection("actsubentryentity");
                dynamicObjectCollection.removeAll((Collection)dynamicObjectCollection);
                for (DynamicObject oAct : oActs) {
                    ManuftechCreateBillUtil.setActSubEntryEntityValue(oAct, dynamicObjectCollection.addNew());
                }
                continue;
            }
            ManuftechChangeImportUtils.initNewOprEntryEntity(origin, xOpr, xProentryentity);
            ManuftechChangeImportUtils.initNewOprRouteInfo(xOpr, (DynamicObject)routeOprIdObj.get(xOpr.getLong("oprsourceentryid")), (DynamicObject)orderEntryMap.get(orderEntryId));
            xOpr.set("oprchangetype", (Object)"A");
        }
    }

    private static void initNewOprRouteInfo(DynamicObject xOpr, DynamicObject routeOpr, DynamicObject orderEntry) {
        if (routeOpr != null && orderEntry != null) {
            ManuftechCreateBillUtil.setOprEntryEntityValue(routeOpr, orderEntry, xOpr);
            DynamicObjectCollection xActs = xOpr.getDynamicObjectCollection("actsubentryentity");
            xActs.clear();
            DynamicObjectCollection xResSubs = xOpr.getDynamicObjectCollection("ressubentryentity");
            xResSubs.clear();
            ManuftechCreateBillUtil.setActSubEntryEntityValue(routeOpr, orderEntry, xOpr);
        }
    }

    public static void autoFillManftchChange(DynamicObject xmanftechBill, DynamicObject origin) {
        ManuftechChangeImportUtils.reDealAccountOrg(xmanftechBill);
        ManuftechChangeImportUtils.dealOprOrg(xmanftechBill);
        ManuftechChangeImportUtils.oprearliestbegintimeChange(xmanftechBill);
        ManuftechChangeImportUtils.oprctrlstrategyChange(xmanftechBill);
        ManuftechChangeImportUtils.oprstandardqtyChange(xmanftechBill);
        ManuftechChangeImportUtils.machiningtypeChange(xmanftechBill);
        ManuftechChangeImportUtils.upperratioChange(xmanftechBill);
        ManuftechChangeImportUtils.floorratioChange(xmanftechBill);
        ManuftechChangeImportUtils.headQtyChange(xmanftechBill);
        ManuftechChangeImportUtils.operationQtyChange(xmanftechBill);
        ManuftechChangeImportUtils.oprplanfinishtimeChange(xmanftechBill);
        ManuftechChangeImportUtils.oprqtyChange(xmanftechBill);
        ManuftechChangeImportUtils.processOutPutInPutChange(xmanftechBill);
        ManuftechChangeImportUtils.firstinspectionChange(xmanftechBill);
        ManuftechChangeImportUtils.reCalculateQty(xmanftechBill);
        ManuftechChangeImportUtils.setActSubEntryByModify(xmanftechBill);
    }

    public static void setActSubEntryByModify(DynamicObject xmanftechBill) {
        DynamicObjectCollection xOprEntryEntity = xmanftechBill.getDynamicObjectCollection("oprentryentity");
        HashMap routeOprIdObj = new HashMap(1);
        DynamicObject processRouteObj = xmanftechBill.getDynamicObject("processroute");
        if (processRouteObj != null) {
            processRouteObj = BusinessDataServiceHelper.loadSingleFromCache((Object)processRouteObj.getPkValue(), (String)processRouteObj.getDataEntityType().getName());
            DynamicObjectCollection processEntry = processRouteObj.getDynamicObjectCollection("processentry");
            routeOprIdObj.putAll(processEntry.stream().collect(Collectors.toMap(x -> x.getLong("id"), Function.identity())));
        }
        HashSet<Object> sets = new HashSet<Object>(1);
        HashMap<Object, DynamicObject> orderEntryMap = new HashMap<Object, DynamicObject>(1);
        Object orderEntryId = xmanftechBill.getDynamicObject("mftentryseq").getPkValue();
        sets.add(orderEntryId);
        ManuftechCreateBillUtil.getOrderEntityMap("pom_mftorder", sets, orderEntryMap);
        for (DynamicObject xOpr : xOprEntryEntity) {
            DynamicObject processEntry;
            if (!"B".equals(xOpr.getString("oprchangetype")) || (processEntry = (DynamicObject)routeOprIdObj.get(xOpr.getLong("oprsourceentryid"))) == null) continue;
            ManuftechCreateBillUtil.setActSubEntryEntityValue(processEntry, (DynamicObject)orderEntryMap.get(orderEntryId), xOpr);
        }
    }

    private static void firstinspectionChange(DynamicObject xmanftechBill) {
        DynamicObjectCollection xOprEntryEntity = xmanftechBill.getDynamicObjectCollection("oprentryentity");
        for (DynamicObject opr : xOprEntryEntity) {
            boolean firstCheck = opr.getBoolean("firstinspection");
            if (firstCheck && StringUtils.isEmpty((CharSequence)opr.getString("firstinspectioncontrol"))) {
                opr.set("firstinspectioncontrol", (Object)"A");
            }
            if (firstCheck) continue;
            opr.set("firstinspectioncontrol", null);
        }
    }

    private static void purchaseorgChange(DynamicObject xmanftechBill) {
        DynamicObjectCollection xOprEntryEntity = xmanftechBill.getDynamicObjectCollection("oprentryentity");
        for (DynamicObject opr : xOprEntryEntity) {
            Object purchaseorg = opr.get("purchaseorg");
            if (purchaseorg == null) continue;
            opr.set("supplier", null);
        }
    }

    private static void processOutPutInPutChange(DynamicObject xmanftechBill) {
        DynamicObjectCollection xProEntryEntity = xmanftechBill.getDynamicObjectCollection("proentryentity");
        for (DynamicObject pro : xProEntryEntity) {
            if (ManuftechChangeImportUtils.isNull(pro.get("processoutput"))) {
                pro.set("processoutputdesc", null);
                pro.set("processplanouttime", null);
            }
            if (!ManuftechChangeImportUtils.isNull(pro.get("processinput"))) continue;
            pro.set("processinputdesc", null);
            pro.set("processplanintime", null);
        }
    }

    private static void oprqtyChange(DynamicObject xmanftechBill) {
        ManuftechChangeImportUtils.otherQtyChange(xmanftechBill);
        DynamicObjectCollection proentryentitys = xmanftechBill.getDynamicObjectCollection("proentryentity");
        DynamicObjectCollection oprentryentitys = xmanftechBill.getDynamicObjectCollection("oprentryentity");
        for (int i = 0; i < proentryentitys.size(); ++i) {
            DynamicObject proentryentity = (DynamicObject)proentryentitys.get(i);
            List collect = oprentryentitys.stream().filter(var -> proentryentity.getString("processseq").equals(var.get("oprparent"))).collect(Collectors.toList());
            Optional<DynamicObject> dynamicObject = collect.stream().min(Comparator.comparing(var -> var.getInt("oprno")));
            if (!dynamicObject.isPresent()) continue;
            proentryentity.set("processseqqty", dynamicObject.get().get("oprqty"));
        }
    }

    private static void otherQtyChange(DynamicObject xmanftechBill) {
        DynamicObjectCollection xOprEntryEntity = xmanftechBill.getDynamicObjectCollection("oprentryentity");
        for (DynamicObject opr : xOprEntryEntity) {
            BigDecimal oprQty = opr.getBigDecimal("oprqty");
            BigDecimal upperRatio = opr.getBigDecimal("upperratio");
            BigDecimal divide = upperRatio.divide(new BigDecimal("100"), 10, 4);
            opr.set("upperqty", (Object)divide.add(BigDecimal.ONE).multiply(oprQty));
            BigDecimal floorRatio = opr.getBigDecimal("floorratio");
            BigDecimal divide1 = floorRatio.divide(new BigDecimal("100"), 10, 4);
            opr.set("floorqty", (Object)BigDecimal.ONE.subtract(divide1).multiply(oprQty));
        }
    }

    private static void oprplanfinishtimeChange(DynamicObject xmanftechBill) {
        DynamicObjectCollection proentryentitys = xmanftechBill.getDynamicObjectCollection("proentryentity");
        DynamicObjectCollection oprentryentitys = xmanftechBill.getDynamicObjectCollection("oprentryentity");
        for (int i = 0; i < proentryentitys.size(); ++i) {
            DynamicObject proentryentity = (DynamicObject)proentryentitys.get(i);
            Date beginDate = null;
            Date endDate = null;
            for (DynamicObject oprentryentity : oprentryentitys) {
                Date oprPlanFinishTime;
                Date oprPlanBeginTime;
                String oprparent = oprentryentity.getString("oprparent");
                if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)oprparent, (CharSequence)proentryentity.getString("processseq"))) continue;
                beginDate = oprPlanBeginTime = oprentryentity.getDate("oprplanbegintime");
                endDate = oprPlanFinishTime = oprentryentity.getDate("oprplanfinishtime");
            }
            if (beginDate != null) {
                proentryentity.set("processplanbegintime", beginDate);
            }
            if (endDate == null) continue;
            proentryentity.set("processplanendtime", endDate);
        }
    }

    private static void operationQtyChange(DynamicObject xmanftechBill) {
        DynamicObjectCollection xOprEntryEntity = xmanftechBill.getDynamicObjectCollection("oprentryentity");
        for (DynamicObject opr : xOprEntryEntity) {
            BigDecimal oldEntryQty = opr.getBigDecimal("operationqty");
            BigDecimal newHeadQty = ManuftechChangeImportUtils.getNewHeadQty(opr, xmanftechBill);
            BigDecimal oldHeadQty = opr.getBigDecimal("headqty");
            BigDecimal newEntryQty = BigDecimal.ZERO;
            BigDecimal totalQty = opr.getBigDecimal("oprtotalsplitqty");
            BigDecimal splithaedqty = ManuftechChangeImportUtils.getMaterielUnitRateConvertQty(opr.getBigDecimal("oprtotalsplitbaseqty"), opr, xmanftechBill);
            if (BigDecimal.ZERO.compareTo(newHeadQty) == 0 || BigDecimal.ZERO.compareTo(oldHeadQty) == 0 || BigDecimal.ZERO.compareTo(oldEntryQty) == 0 || opr.get("oprunit") == null) continue;
            DynamicObject unitObj = opr.getDynamicObject("oprunit");
            int precisionAccount = UnitPrecisionUtils.getPrecisionDeal(unitObj.getString("precisionaccount"));
            newEntryQty = newHeadQty.multiply(oldEntryQty).divide(oldHeadQty, unitObj.getInt("precision"), precisionAccount);
            if (BigDecimal.ZERO.compareTo(totalQty) < 0) {
                totalQty = splithaedqty.multiply(oldEntryQty).divide(oldHeadQty, unitObj.getInt("precision"), precisionAccount);
            }
            opr.set("oprstandardqty", (Object)newEntryQty);
            opr.set("oprqty", (Object)newEntryQty);
            opr.set("oprtotalsplitqty", (Object)totalQty);
        }
    }

    private static void headQtyChange(DynamicObject xmanftechBill) {
        DynamicObjectCollection xOprEntryEntity = xmanftechBill.getDynamicObjectCollection("oprentryentity");
        if (xmanftechBill.get("mftentryseq") != null) {
            for (DynamicObject opr : xOprEntryEntity) {
                BigDecimal oldHeadQty = opr.getBigDecimal("headqty");
                BigDecimal newHeadQty = ManuftechChangeImportUtils.getNewHeadQty(opr, xmanftechBill);
                BigDecimal oldEntryQty = opr.getBigDecimal("operationqty");
                BigDecimal newEntryQty = BigDecimal.ZERO;
                BigDecimal totalQty = opr.getBigDecimal("oprtotalsplitqty");
                BigDecimal splithaedqty = ManuftechChangeImportUtils.getMaterielUnitRateConvertQty(opr.getBigDecimal("oprtotalsplitbaseqty"), opr, xmanftechBill);
                if (BigDecimal.ZERO.compareTo(newHeadQty) == 0 || BigDecimal.ZERO.compareTo(oldHeadQty) == 0 || BigDecimal.ZERO.compareTo(oldEntryQty) == 0 || opr.get("oprunit") == null) continue;
                DynamicObject unitObj = opr.getDynamicObject("oprunit");
                int precisionAccount = UnitPrecisionUtils.getPrecisionDeal(unitObj.getString("precisionaccount"));
                newEntryQty = newHeadQty.multiply(oldEntryQty).divide(oldHeadQty, unitObj.getInt("precision"), precisionAccount);
                if (BigDecimal.ZERO.compareTo(totalQty) < 0) {
                    totalQty = splithaedqty.multiply(oldEntryQty).divide(oldHeadQty, unitObj.getInt("precision"), precisionAccount);
                }
                opr.set("oprstandardqty", (Object)newEntryQty);
                opr.set("oprqty", (Object)newEntryQty);
                opr.set("oprtotalsplitqty", (Object)totalQty);
            }
        }
    }

    private static BigDecimal getNewHeadQty(DynamicObject oprEntry, DynamicObject manftechBill) {
        Long headUnitId = oprEntry.getLong("headunit_id");
        if (headUnitId != 0L) {
            BigDecimal auxptyqty;
            BigDecimal qty;
            BigDecimal baseqty;
            Long baseUnitId = manftechBill.getLong("baseunit_id");
            if (Long.compare(headUnitId, baseUnitId) == 0 && !BigDecimal.ZERO.equals(baseqty = manftechBill.getBigDecimal("baseqty"))) {
                return baseqty;
            }
            Long unitId = manftechBill.getLong("unit_id");
            if (Long.compare(headUnitId, unitId) == 0 && !BigDecimal.ZERO.equals(qty = manftechBill.getBigDecimal("qty"))) {
                return qty;
            }
            Long auxptyUnitId = manftechBill.getLong("auxptyunit_id");
            if (Long.compare(headUnitId, auxptyUnitId) == 0 && !BigDecimal.ZERO.equals(auxptyqty = manftechBill.getBigDecimal("auxptyqty"))) {
                return auxptyqty;
            }
        }
        return ManuftechChangeImportUtils.getMaterielUnitRateConvertQty(manftechBill.getBigDecimal("baseqty"), oprEntry, manftechBill);
    }

    private static BigDecimal getMaterielUnitRateConvertQty(BigDecimal qty, DynamicObject oprEntry, DynamicObject manftechBill) {
        DynamicObject material = manftechBill.getDynamicObject("material");
        DynamicObject baseUnit = manftechBill.getDynamicObject("baseunit");
        DynamicObject headUnit = oprEntry.getDynamicObject("headunit");
        return UnitConvertHelper.calculateNewQty((BigDecimal)qty, (Long)(headUnit == null ? null : Long.valueOf(headUnit.getLong("id"))), (Long)(baseUnit == null ? null : Long.valueOf(baseUnit.getLong("id"))), (Long)(material == null ? null : Long.valueOf(material.getLong("id"))), (StringBuilder)new StringBuilder());
    }

    private static void floorratioChange(DynamicObject xmanftechBill) {
        DynamicObjectCollection xOprEntryEntity = xmanftechBill.getDynamicObjectCollection("oprentryentity");
        for (DynamicObject opr : xOprEntryEntity) {
            BigDecimal floorRatio = opr.getBigDecimal("floorratio");
            BigDecimal divide = floorRatio.divide(new BigDecimal("100"), 10, 4);
            BigDecimal value = opr.getBigDecimal("oprqty");
            opr.set("floorratio", (Object)floorRatio);
            opr.set("floorqty", (Object)BigDecimal.ONE.subtract(divide).multiply(value));
        }
    }

    private static void upperratioChange(DynamicObject xmanftechBill) {
        DynamicObjectCollection xOprEntryEntity = xmanftechBill.getDynamicObjectCollection("oprentryentity");
        for (DynamicObject opr : xOprEntryEntity) {
            BigDecimal upperratio = opr.getBigDecimal("upperratio");
            BigDecimal divide = upperratio.divide(new BigDecimal("100"), 10, 4);
            BigDecimal value = opr.getBigDecimal("oprqty");
            opr.set("upperratio", (Object)upperratio);
            opr.set("upperqty", (Object)divide.add(BigDecimal.ONE).multiply(value));
        }
    }

    private static void machiningtypeChange(DynamicObject xmanftechBill) {
        DynamicObjectCollection xOprEntryEntity = xmanftechBill.getDynamicObjectCollection("oprentryentity");
        for (DynamicObject opr : xOprEntryEntity) {
            String machiningtype = opr.getString("machiningtype");
            if (!"1002".equals(machiningtype) || opr.get("oprorg") == null) continue;
            long id = OrgHelper.getPurchaseOrg(opr.getDynamicObject("oprorg").getLong("id"));
            opr.set("purchaseorg", (Object)id);
        }
    }

    private static void oprstandardqtyChange(DynamicObject xmanftechBill) {
        DynamicObjectCollection xOprEntryEntity = xmanftechBill.getDynamicObjectCollection("oprentryentity");
        for (DynamicObject opr : xOprEntryEntity) {
            int oprstandardqty = opr.getInt("oprstandardqty");
            opr.set("oprqty", (Object)oprstandardqty);
        }
    }

    private static void oprctrlstrategyChange(DynamicObject xmanftechBill) {
        DynamicObjectCollection xOprEntryEntity = xmanftechBill.getDynamicObjectCollection("oprentryentity");
        for (DynamicObject opr : xOprEntryEntity) {
            DynamicObject oprctrlstrategy = opr.getDynamicObject("oprctrlstrategy");
            if (oprctrlstrategy != null) {
                oprctrlstrategy = BusinessDataServiceHelper.loadSingleFromCache((Object)oprctrlstrategy.getPkValue(), (String)oprctrlstrategy.getDynamicObjectType().getName(), (String)"id,promode,checkmethod");
                String promode = oprctrlstrategy.getString("promode");
                opr.set("inspectiontype", oprctrlstrategy.get("checkmethod"));
                opr.set("machiningtype", (Object)promode);
                if (!"1002".equals(promode) || opr.get("oprorg") == null) continue;
                long id = OrgHelper.getPurchaseOrg(opr.getDynamicObject("oprorg").getLong("id"));
                opr.set("purchaseorg", (Object)id);
                continue;
            }
            opr.set("inspectiontype", null);
            opr.set("machiningtype", null);
        }
    }

    private static void oproperationChange(DynamicObject xmanftechBill) {
        DynamicObjectCollection xOprEntryEntity = xmanftechBill.getDynamicObjectCollection("oprentryentity");
        for (DynamicObject opr : xOprEntryEntity) {
            DynamicObject oproperation = opr.getDynamicObject("oproperation");
            if (oproperation == null) continue;
            String name = oproperation.getString("name");
            boolean collaborative = oproperation.getBoolean("collaborative");
            opr.set("oprdescription", (Object)name);
            opr.set("collaborative", (Object)collaborative);
        }
    }

    private static void initNewOprEntryEntity(DynamicObject xManuFtechObj, DynamicObject xManuFtechOprEntryNewObj, DynamicObject xProentryentity) {
        DynamicObject manFtechId;
        xManuFtechOprEntryNewObj.set("oprproductionqty", xManuFtechObj.get("qty"));
        xManuFtechOprEntryNewObj.set("oprplanbegintime", xManuFtechObj.get("planstarttime"));
        xManuFtechOprEntryNewObj.set("oprplanfinishtime", xManuFtechObj.get("planfinishtime"));
        xManuFtechOprEntryNewObj.set("oprstandardqty", xManuFtechObj.get("baseqty"));
        xManuFtechOprEntryNewObj.set("oprqty", xManuFtechObj.get("baseqty"));
        BigDecimal upperRatio = xManuFtechOprEntryNewObj.getBigDecimal("upperratio");
        BigDecimal divide = upperRatio.divide(new BigDecimal("100"));
        xManuFtechOprEntryNewObj.set("upperqty", (Object)divide.add(BigDecimal.ONE).multiply(xManuFtechObj.getBigDecimal("baseqty")));
        BigDecimal floorRatio = xManuFtechOprEntryNewObj.getBigDecimal("floorratio");
        BigDecimal divide1 = floorRatio.divide(new BigDecimal("100"));
        xManuFtechOprEntryNewObj.set("floorqty", (Object)BigDecimal.ONE.subtract(divide1).multiply(xManuFtechObj.getBigDecimal("baseqty")));
        if (xManuFtechObj.get("mftentryseq") != null) {
            xManuFtechOprEntryNewObj.set("headunit", ((DynamicObject)xManuFtechObj.get("baseunit")).getPkValue());
            xManuFtechOprEntryNewObj.set("overlapunit", ((DynamicObject)xManuFtechObj.get("mftentryseq")).getDynamicObject("unit").getPkValue());
            xManuFtechOprEntryNewObj.set("oprunit", ((DynamicObject)xManuFtechObj.get("baseunit")).getPkValue());
            xManuFtechOprEntryNewObj.set("settlementunit", ((DynamicObject)xManuFtechObj.get("mftentryseq")).getDynamicObject("unit").getPkValue());
        }
        if ((manFtechId = (DynamicObject)xProentryentity.get("promanftechid")) != null) {
            xManuFtechOprEntryNewObj.set("oprproductionqty", manFtechId.get("qty"));
            xManuFtechOprEntryNewObj.set("oprplanbegintime", manFtechId.get("planstarttime"));
            xManuFtechOprEntryNewObj.set("oprplanfinishtime", manFtechId.get("planfinishtime"));
            xManuFtechOprEntryNewObj.set("oprstandardqty", (Object)manFtechId.getBigDecimal("baseqty"));
            xManuFtechOprEntryNewObj.set("oprqty", (Object)manFtechId.getBigDecimal("baseqty"));
            BigDecimal xupperRatio = (BigDecimal)xManuFtechOprEntryNewObj.get("upperratio");
            BigDecimal xdivide = xupperRatio.divide(new BigDecimal("100"));
            xManuFtechOprEntryNewObj.set("upperqty", (Object)xdivide.add(BigDecimal.ONE).multiply(manFtechId.getBigDecimal("baseqty")));
            BigDecimal xfloorRatio = (BigDecimal)xManuFtechOprEntryNewObj.get("floorratio");
            BigDecimal xdivide1 = xfloorRatio.divide(new BigDecimal("100"));
            xManuFtechOprEntryNewObj.set("floorqty", (Object)BigDecimal.ONE.subtract(xdivide1).multiply(manFtechId.getBigDecimal("baseqty")));
        }
        xManuFtechOprEntryNewObj.set("oprmanftechid", (Object)manFtechId);
        DynamicObject proOrderEntryId = (DynamicObject)xProentryentity.get("proorderentryid");
        xManuFtechOprEntryNewObj.set("oprorderentryid", (Object)proOrderEntryId);
        if (proOrderEntryId != null) {
            DynamicObject dynamicObject = proOrderEntryId.getDynamicObject("processroute");
            if (dynamicObject != null) {
                DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((Object)dynamicObject.getPkValue(), (String)"pdm_route", (String)"unit");
                xManuFtechOprEntryNewObj.set("headunit", (Object)(object != null && object.getDynamicObject("unit") != null ? object.getDynamicObject("unit") : proOrderEntryId.getDynamicObject("baseunit")));
            } else {
                xManuFtechOprEntryNewObj.set("headunit", (Object)proOrderEntryId.getDynamicObject("baseunit"));
            }
            xManuFtechOprEntryNewObj.set("oprunit", (Object)proOrderEntryId.getDynamicObject("baseunit"));
            xManuFtechOprEntryNewObj.set("overlapunit", (Object)proOrderEntryId.getDynamicObject("unit"));
            xManuFtechOprEntryNewObj.set("settlementunit", (Object)proOrderEntryId.getDynamicObject("unit"));
        }
    }

    private static void storagepointChange(DynamicObject xManuFtechObj) {
        DynamicObjectCollection xOprEntryEntity = xManuFtechObj.getDynamicObjectCollection("oprentryentity");
        for (int i = 0; i < xOprEntryEntity.size(); ++i) {
            boolean storagePoint = ((DynamicObject)xOprEntryEntity.get(i)).getBoolean("storagepoint");
            if (!storagePoint) continue;
            for (int j = 0; j < xOprEntryEntity.size(); ++j) {
                if (i == j) continue;
                ((DynamicObject)xOprEntryEntity.get(j)).set("storagepoint", (Object)false);
            }
            break;
        }
    }

    private static void oprworkcenterChange(DynamicObject xmanftechBill, DynamicObject origin) {
        DynamicObjectCollection xOprEntryEntity = xmanftechBill.getDynamicObjectCollection("oprentryentity");
        DynamicObjectCollection originOprEntry = origin.getDynamicObjectCollection("oprentryentity");
        Map<Long, DynamicObject> oOprEntryOprIdXObj = originOprEntry.stream().collect(Collectors.toMap(x -> x.getLong("id"), r -> r));
        for (DynamicObject xOpr : xOprEntryEntity) {
            DynamicObject oprEntryId = xOpr.getDynamicObject("oprentryid");
            Long oprId = oprEntryId != null ? Long.valueOf(oprEntryId.getLong("id")) : null;
            DynamicObject xWorkCenter = xOpr.getDynamicObject("oprworkcenter");
            long xWorkCenterId = xWorkCenter != null ? xWorkCenter.getLong("id") : 0L;
            long oWorkCenterId = 0L;
            if (oOprEntryOprIdXObj.containsKey(oprId)) {
                DynamicObject oOpr = oOprEntryOprIdXObj.get(oprId);
                DynamicObject workCenter = oOpr.getDynamicObject("oprworkcenter");
                long l = oWorkCenterId = workCenter != null ? workCenter.getLong("id") : 0L;
            }
            if (xWorkCenterId == 0L || xWorkCenterId == oWorkCenterId) continue;
            DynamicObject workShop = xWorkCenter.getDynamicObject("workshop");
            xOpr.set("oprworkshop", (Object)workShop);
            DynamicObject processStrategy = xWorkCenter.getDynamicObject("processstrategy");
            xOpr.set("oprctrlstrategy", (Object)processStrategy);
            if (processStrategy != null) {
                processStrategy = BusinessDataServiceHelper.loadSingleFromCache((Object)processStrategy.getPkValue(), (String)"mpdm_proctrlstrategy");
                xOpr.set("machiningtype", processStrategy.get("promode"));
            }
            xOpr.getDynamicObjectCollection("actsubentryentity").clear();
            QFilter[] qf = new QFilter[]{new QFilter("id", "=", xWorkCenter.getPkValue())};
            DynamicObjectCollection reEntrys = QueryServiceHelper.query((String)"mpdm_workcentre", (String)"id,entryresouce.resource resource", (QFilter[])qf);
            DynamicObjectCollection acEntrys = QueryServiceHelper.query((String)"mpdm_workcentre", (String)"id,processactivetable.processnumber processnumber,processactivetable.processnumber.processstage processstage,processactivetable.processqty processqty,processactivetable.activeformula activeformula,processactivetable.reportformula reportformula,processactivetable.processunit processunit", (QFilter[])qf);
            if (acEntrys.size() == 0) continue;
            for (int x2 = 0; x2 < acEntrys.size(); ++x2) {
                DynamicObject acEntry = (DynamicObject)acEntrys.get(x2);
                if (acEntry.getLong("processnumber") == 0L) continue;
                if (reEntrys.size() == 0) {
                    DynamicObject ac = xOpr.getDynamicObjectCollection("actsubentryentity").addNew();
                    ManuftechChangeImportUtils.setActsubentryentity(acEntry, ac, xmanftechBill);
                    continue;
                }
                for (int y = 0; y < reEntrys.size(); ++y) {
                    DynamicObject reEntry = (DynamicObject)reEntrys.get(y);
                    DynamicObject ac = xOpr.getDynamicObjectCollection("actsubentryentity").addNew();
                    ManuftechChangeImportUtils.setActsubentryentity(acEntry, ac, xmanftechBill);
                    ac.set("actresources", (Object)reEntry.getLong("resource"));
                }
            }
        }
    }

    private static void setActsubentryentity(DynamicObject acEntry, DynamicObject xOrpActEntry, DynamicObject xBill) {
        xOrpActEntry.set("processstage", acEntry.get("processstage"));
        xOrpActEntry.set("actactivity", (Object)acEntry.getLong("processnumber"));
        xOrpActEntry.set("actqty", (Object)acEntry.getBigDecimal("processqty"));
        xOrpActEntry.set("actunit", (Object)acEntry.getLong("processunit"));
        xOrpActEntry.set("actstandardformula", (Object)acEntry.getLong("activeformula"));
        xOrpActEntry.set("actstandardformula1", (Object)acEntry.getLong("reportformula"));
        xOrpActEntry.set("actplanbegintime", xBill.get("planstarttime"));
        xOrpActEntry.set("actplanfinishtime", xBill.get("planfinishtime"));
    }

    private static void oprearliestbegintimeChange(DynamicObject xmanftechBill) {
        DynamicObjectCollection oprEntryEntity = xmanftechBill.getDynamicObjectCollection("oprentryentity");
        oprEntryEntity.forEach(opr -> {
            Object oprearliestbegintime = opr.get("oprearliestbegintime");
            Object oprlatestfinishtime = opr.get("oprlatestfinishtime");
            if (oprearliestbegintime != null) {
                opr.set("oprplanbegintime", oprearliestbegintime);
            }
            if (oprlatestfinishtime != null) {
                opr.set("oprplanfinishtime", oprlatestfinishtime);
            }
        });
    }

    private static void reDealAccountOrg(DynamicObject xmanftechBill) {
        HashSet<Long> orgIds = new HashSet<Long>(16);
        if (xmanftechBill.getDynamicObject("org") != null) {
            orgIds.add(xmanftechBill.getDynamicObject("org").getLong("id"));
        }
        DynamicObjectCollection oprEntryEntity = xmanftechBill.getDynamicObjectCollection("oprentryentity");
        orgIds.addAll(oprEntryEntity.stream().filter(x -> x.getDynamicObject("oprorg") != null).map(x -> x.getDynamicObject("oprorg").getLong("id")).collect(Collectors.toSet()));
        Map<Long, Object> data = ManuftechUtil.getAccountingOrgIdByMftOrgId(orgIds);
        Map orgMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", data.values())});
        if (xmanftechBill.getDynamicObject("org") != null) {
            xmanftechBill.set("accountingorg", orgMap.get(data.get(xmanftechBill.getDynamicObject("org").getLong("id"))));
        }
        ManuftechCreateBillUtil.setOprEntryAccountingOrgValue(xmanftechBill, data, orgMap);
    }

    private static void dealOprOrg(DynamicObject xmanftechBill) {
        DynamicObjectCollection oprs = xmanftechBill.getDynamicObjectCollection("oprentryentity");
        for (DynamicObject opr : oprs) {
            Object oprOrg = opr.get("oprorg");
            if (oprOrg == null) continue;
            long id = OrgHelper.getPurchaseOrg(((DynamicObject)oprOrg).getLong("id"));
            opr.set("purchaseorg", (Object)id);
            if (!opr.containsProperty("opraccountingorg")) continue;
            DynamicObject org = xmanftechBill.getDynamicObject("org");
            HashSet orgIds = Sets.newHashSet();
            if (org != null) {
                orgIds.add(org.getLong("id"));
            }
            orgIds.add(((DynamicObject)oprOrg).getLong("id"));
            Map<Long, Object> accountingOrgIdByMftOrgId = ManuftechUtil.getAccountingOrgIdByMftOrgId(orgIds);
            Object oprAccountingOrg = accountingOrgIdByMftOrgId.get(((DynamicObject)oprOrg).getLong("id"));
            opr.set("opraccountingorg", oprAccountingOrg);
            if (org == null) continue;
            Object accountingOrg = accountingOrgIdByMftOrgId.get(org.getLong("id"));
            if (xmanftechBill.get("accountingorg") == null) {
                xmanftechBill.set("accountingorg", accountingOrg);
            }
            opr.set("opriscrossesacctorg", (Object)(!Objects.equals(accountingOrg, oprAccountingOrg) ? 1 : 0));
        }
    }

    private static void reCalculateQty(DynamicObject xmanftechBill) {
        DynamicObjectCollection oprs = xmanftechBill.getDynamicObjectCollection("oprentryentity");
        for (DynamicObject opr : oprs) {
            BigDecimal oprtotalinqty = ManuftechChangeImportUtils.toBigDecimal(opr.getBigDecimal("oprtotalinqty"));
            BigDecimal oprtotaloutqty = ManuftechChangeImportUtils.toBigDecimal(opr.getBigDecimal("oprtotaloutqty"));
            BigDecimal oprtotalqualifiedqty = ManuftechChangeImportUtils.toBigDecimal(opr.getBigDecimal("oprtotalqualifiedqty"));
            BigDecimal oprtotalreceiveqty = ManuftechChangeImportUtils.toBigDecimal(opr.getBigDecimal("oprtotalreceiveqty"));
            BigDecimal oprtotalwasteqty = ManuftechChangeImportUtils.toBigDecimal(opr.getBigDecimal("oprtotalwasteqty"));
            BigDecimal oprtotalmaterialqty = ManuftechChangeImportUtils.toBigDecimal(opr.getBigDecimal("oprtotalmaterialqty"));
            BigDecimal oprtotalreworkqty = ManuftechChangeImportUtils.toBigDecimal(opr.getBigDecimal("oprtotalreworkqty"));
            BigDecimal oprrepairedqty = ManuftechChangeImportUtils.toBigDecimal(opr.getBigDecimal("oprrepairedqty"));
            BigDecimal pushreworkreportqty = ManuftechChangeImportUtils.toBigDecimal(opr.getBigDecimal("pushreworkreportqty"));
            BigDecimal reworkreportqty = ManuftechChangeImportUtils.toBigDecimal(opr.getBigDecimal("reworkreportqty"));
            BigDecimal pushreportqty = oprtotalqualifiedqty.add(oprtotalreceiveqty).add(oprtotalwasteqty).add(oprtotalmaterialqty).add(oprtotalreworkqty).add(oprrepairedqty);
            opr.set("pushreportqty", (Object)pushreportqty);
            BigDecimal oprtotalreportqty = oprtotalqualifiedqty.add(oprtotalreceiveqty).add(oprtotalwasteqty).add(oprtotalmaterialqty).add(oprtotalreworkqty).add(oprrepairedqty);
            opr.set("oprtotalreportqty", (Object)oprtotalreportqty);
            BigDecimal oprtotaljunkqty = oprtotalmaterialqty.add(oprtotalwasteqty);
            opr.set("oprtotaljunkqty", (Object)oprtotaljunkqty);
            Map<String, Object> manftechMap = ManuftechChangeImportUtils.getManftechMap(xmanftechBill, opr);
            BigDecimal oprtotalinbaseqty = ManuftechChangeImportUtils.getBaseQty(manftechMap, oprtotalinqty);
            opr.set("oprtotalinbaseqty", (Object)oprtotalinbaseqty);
            BigDecimal oprtotaloutbaseqty = ManuftechChangeImportUtils.getBaseQty(manftechMap, oprtotaloutqty);
            opr.set("oprtotaloutbaseqty", (Object)oprtotaloutbaseqty);
            BigDecimal pushreportbaseqty = ManuftechChangeImportUtils.getBaseQty(manftechMap, pushreportqty);
            opr.set("pushreportbaseqty", (Object)pushreportbaseqty);
            BigDecimal pushreworkreportbaseqty = ManuftechChangeImportUtils.getBaseQty(manftechMap, pushreworkreportqty);
            opr.set("pushreworkreportbaseqty", (Object)pushreworkreportbaseqty);
            BigDecimal oprtotalreportbaseqty = ManuftechChangeImportUtils.getBaseQty(manftechMap, oprtotalreportqty);
            opr.set("oprtotalreportbaseqty", (Object)oprtotalreportbaseqty);
            BigDecimal reworkreportbaseqty = ManuftechChangeImportUtils.getBaseQty(manftechMap, reworkreportqty);
            opr.set("reworkreportbaseqty", (Object)reworkreportbaseqty);
            BigDecimal oprtotalqualifiedbaseqty = ManuftechChangeImportUtils.getBaseQty(manftechMap, oprtotalqualifiedqty);
            opr.set("oprtotalqualifiedbaseqty", (Object)oprtotalqualifiedbaseqty);
            BigDecimal oprtotalreceivebaseqty = ManuftechChangeImportUtils.getBaseQty(manftechMap, oprtotalreceiveqty);
            opr.set("oprtotalreceivebaseqty", (Object)oprtotalreceivebaseqty);
            BigDecimal oprtotalwastebaseqty = ManuftechChangeImportUtils.getBaseQty(manftechMap, oprtotalwasteqty);
            opr.set("oprtotalwastebaseqty", (Object)oprtotalwastebaseqty);
            BigDecimal oprtotalmaterialbaseqty = ManuftechChangeImportUtils.getBaseQty(manftechMap, oprtotalmaterialqty);
            opr.set("oprtotalmaterialbaseqty", (Object)oprtotalmaterialbaseqty);
            BigDecimal oprtotaljunkbaseqty = ManuftechChangeImportUtils.getBaseQty(manftechMap, oprtotaljunkqty);
            opr.set("oprtotaljunkbaseqty", (Object)oprtotaljunkbaseqty);
            BigDecimal oprtotalreworkbaseqty = ManuftechChangeImportUtils.getBaseQty(manftechMap, oprtotalreworkqty);
            opr.set("oprtotalreworkbaseqty", (Object)oprtotalreworkbaseqty);
        }
    }

    private static BigDecimal getBaseQty(Map<String, Object> oprEntry, BigDecimal oprQty) {
        if (oprEntry != null && oprQty != null && BigDecimal.ZERO.compareTo(oprQty) != 0) {
            BigDecimal operationQty = (BigDecimal)oprEntry.get("oprentryentity.operationqty");
            BigDecimal headQty = (BigDecimal)oprEntry.get("oprentryentity.headqty");
            headQty = oprQty.multiply(headQty);
            BigDecimal bigDecimal = UnitConvertHelper.calculateNewQty((BigDecimal)headQty, (Long)((Long)oprEntry.get("baseunit")), (Long)((Long)oprEntry.get("oprentryentity.headunit")), (Long)((Long)oprEntry.get("material")), (StringBuilder)new StringBuilder());
            BigDecimal decimal = bigDecimal.divide(operationQty, (int)((Integer)oprEntry.get("baseunit.precision")), ManuftechChangeImportUtils.getPrecisionDeal((String)oprEntry.get("baseunit.precisionaccount")));
            return decimal;
        }
        return BigDecimal.ZERO;
    }

    private static int getPrecisionDeal(String precisionaccount) {
        int deal = 4;
        switch (precisionaccount) {
            case "1": {
                deal = 4;
                break;
            }
            case "2": {
                deal = 1;
                break;
            }
            case "3": {
                deal = 0;
                break;
            }
        }
        return deal;
    }

    private static Map<String, Object> getManftechMap(DynamicObject manTechicsInfo, DynamicObject techisInfo) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("baseunit", manTechicsInfo.getDynamicObject("baseunit").getPkValue());
        map.put("baseunit.precision", manTechicsInfo.getDynamicObject("baseunit").getInt("precision"));
        map.put("baseunit.precisionaccount", manTechicsInfo.getDynamicObject("baseunit").getString("precisionaccount"));
        map.put("material", manTechicsInfo.getDynamicObject("material") == null ? null : manTechicsInfo.getDynamicObject("material").getPkValue());
        map.put("oprentryentity.operationqty", techisInfo.getBigDecimal("operationqty"));
        map.put("oprentryentity.headqty", techisInfo.getBigDecimal("headqty"));
        map.put("oprentryentity.headunit", techisInfo.getDynamicObject("headunit").getPkValue());
        map.put("oprentryentity.oprunit.precision", techisInfo.getDynamicObject("oprunit").getInt("precision"));
        map.put("oprentryentity.oprunit.precisionaccount", techisInfo.getDynamicObject("oprunit").getString("precisionaccount"));
        return map;
    }

    private static BigDecimal toBigDecimal(Object obj) {
        if (obj == null) {
            return BigDecimal.ZERO;
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if (obj instanceof Integer) {
            return new BigDecimal(((Integer)obj).toString());
        }
        if (obj instanceof Long) {
            return new BigDecimal(((Long)obj).toString());
        }
        if (obj instanceof Double) {
            return new BigDecimal(obj.toString());
        }
        if (obj.toString() == null) {
            return BigDecimal.ZERO;
        }
        String str = obj.toString().trim();
        if (str.toLowerCase().indexOf(101) > -1) {
            try {
                return new BigDecimal(str);
            }
            catch (NumberFormatException e) {
                return BigDecimal.ZERO;
            }
        }
        if (str.matches("^[+-]?\\d+[\\.\\d]?\\d*+$")) {
            return new BigDecimal(str);
        }
        return BigDecimal.ZERO;
    }

    private static boolean isNull(Object obj) {
        if (obj instanceof String) {
            return obj == null || obj.toString().trim().length() == 0;
        }
        return obj == null;
    }
}

