/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.manuftech.utils;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.utils.MPDMCustFormulaFuntions;
import kd.bd.mpdm.common.utils.RegisterFuncUtil;
import kd.bd.mpdm.common.utils.UnitPrecisionUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.formula.platform.engine.FormulaEngine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.UnitConvertHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class ManuftechCreateBillUtil {
    private static final Log logger = LogFactory.getLog(ManuftechCreateBillUtil.class);

    public static Map<Object, DynamicObject> getOrderEntityMap(String entity, Set<Object> entryIds, Map<Object, DynamicObject> entrymap) {
        DynamicObject[] load;
        QFilter qFilter = new QFilter("treeentryentity.id", "in", entryIds);
        for (DynamicObject order : load = BusinessDataServiceHelper.load((String)entity, (String)"treeentryentity.id,treeentryentity.qty,treeentryentity.planbegintime,treeentryentity.planendtime,treeentryentity.material,treeentryentity.baseqty,treeentryentity.baseunit,treeentryentity.processroute,treeentryentity.expendbomtime", (QFilter[])new QFilter[]{qFilter})) {
            DynamicObjectCollection entry = order.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject entryrow : entry) {
                if (!entryIds.contains(entryrow.getPkValue())) continue;
                entrymap.put(entryrow.getPkValue(), entryrow);
            }
        }
        return entrymap;
    }

    public static Map<Object, DynamicObject> getSWSEntryEntityMap(Set<Long> entryIds) {
        DynamicObject[] load;
        HashMap<Object, DynamicObject> entryMap = new HashMap<Object, DynamicObject>(16);
        for (DynamicObject order : load = BusinessDataServiceHelper.load((String)"pom_mrosws", (String)"billentry.id,billentry.progroup,billentry.professiona,billentry.workhours,billentry.enworkhourunit", (QFilter[])new QFilter[]{new QFilter("billentry.id", "in", entryIds)})) {
            DynamicObjectCollection entry = order.getDynamicObjectCollection("billentry");
            for (DynamicObject entryrow : entry) {
                if (!entryIds.contains(entryrow.getPkValue())) continue;
                entryMap.put(entryrow.getPkValue(), entryrow);
            }
        }
        return entryMap;
    }

    public static Map<Object, DynamicObject> getMroOrderEntityMap(String entity, Set<Object> entryIds, Map<Object, DynamicObject> entrymap) {
        DynamicObject[] load;
        QFilter qFilter = new QFilter("treeentryentity.id", "in", entryIds);
        for (DynamicObject order : load = BusinessDataServiceHelper.load((String)entity, (String)"treeentryentity.id,treeentryentity.qty,treeentryentity.planbegintime,treeentryentity.planendtime,treeentryentity.material,treeentryentity.baseqty,treeentryentity.baseunit,treeentryentity.processroute,treeentryentity.workcard,treeentryentity.project,treeentryentity.pageseq,treeentryentity.sourcebilltype,treeentryentity.sourceentryseq,treeentryentity.workhourunit,treeentryentity.mulpaneldef", (QFilter[])new QFilter[]{qFilter})) {
            DynamicObjectCollection entry = order.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject entryrow : entry) {
                if (!entryIds.contains(entryrow.getPkValue())) continue;
                entrymap.put(entryrow.getPkValue(), entryrow);
            }
        }
        return entrymap;
    }

    public static void recalculateEntryQty(DynamicObject srcObj, DynamicObject orderEntryObj) {
        BigDecimal oldHeadQty = srcObj.getBigDecimal("headqty");
        BigDecimal oldEntryQty = srcObj.getBigDecimal("operationqty");
        BigDecimal newEntryQty = BigDecimal.ZERO;
        BigDecimal qty = orderEntryObj.getBigDecimal("baseqty");
        DynamicObject unitObj = srcObj.getDynamicObject("oprunit");
        long material = orderEntryObj.getDynamicObject("material").getDynamicObject("masterid").getLong("id");
        long baseUnitId = orderEntryObj.getDynamicObject("baseunit").getLong("id");
        long headUnitId = srcObj.getDynamicObject("headunit").getLong("id");
        qty = UnitConvertHelper.calculateNewQty((BigDecimal)qty, (Long)headUnitId, (Long)baseUnitId, (Long)material, (StringBuilder)new StringBuilder());
        int deal = UnitPrecisionUtils.getPrecisionDeal(unitObj.getString("precisionaccount"));
        newEntryQty = qty.multiply(oldEntryQty).divide(oldHeadQty, unitObj.getInt("precision"), deal);
        srcObj.set("oprstandardqty", (Object)newEntryQty);
        srcObj.set("oprqty", (Object)newEntryQty);
        BigDecimal divide = srcObj.getBigDecimal("upperratio").divide(new BigDecimal("100"), 10, 4);
        srcObj.set("upperqty", (Object)divide.add(BigDecimal.ONE).multiply(srcObj.getBigDecimal("oprqty")));
        BigDecimal decimal = srcObj.getBigDecimal("floorratio").divide(new BigDecimal("100"), 10, 4);
        srcObj.set("floorqty", (Object)BigDecimal.ONE.subtract(decimal).multiply(srcObj.getBigDecimal("oprqty")));
    }

    public static boolean runFormula(DynamicObject actentry) {
        return ManuftechCreateBillUtil.runFormula(actentry, "sfc_manftech");
    }

    public static boolean runFormula(DynamicObject actentry, String entity) {
        boolean success = false;
        DynamicObject actstandardformula = actentry.getDynamicObject("actstandardformula");
        if (actstandardformula != null) {
            String formulaStr = (actstandardformula = BusinessDataServiceHelper.loadSingleFromCache((Object)actstandardformula.getPkValue(), (String)"mpdm_processformula", (String)"formula")).getString("formula");
            if (StringUtils.isBlank((CharSequence)formulaStr)) {
                return success;
            }
            HashMap<String, DynamicObject> varValues = new HashMap<String, DynamicObject>();
            DynamicObjectCollection actentrys = new DynamicObjectCollection();
            DynamicObject oprentry = (DynamicObject)OrmUtils.clone((IDataEntityBase)((DynamicObject)actentry.getParent()), (boolean)false, (boolean)true);
            actentrys.add((Object)((DynamicObject)OrmUtils.clone((IDataEntityBase)actentry, (boolean)false, (boolean)true)));
            oprentry.set("actsubentryentity", (Object)actentrys);
            DynamicObject cloneSfcmanuftech = (DynamicObject)OrmUtils.clone((IDataEntityBase)((IDataEntityBase)((DynamicObject)actentry.getParent()).getParent()), (boolean)false, (boolean)true);
            DynamicObjectCollection dynamicObjectCollection = cloneSfcmanuftech.getDynamicObjectCollection("oprentryentity");
            dynamicObjectCollection.clear();
            dynamicObjectCollection.add((Object)oprentry);
            if (logger.isInfoEnabled()) {
                logger.info(String.format("\u516c\u5f0f\u8ba1\u7b97\u65f6\u51fa\u73b0\u5f02\u5e38 - \u62a5\u9519:\u53c2\u65701 %s  \u53c2\u65702", entity, cloneSfcmanuftech));
            }
            varValues.put(entity, cloneSfcmanuftech);
            try {
                RegisterFuncUtil.registerFunc(new MPDMCustFormulaFuntions());
                Object result = FormulaEngine.runFormula((String)formulaStr, varValues);
                if (result instanceof String) {
                    actentry.set("actplantotalqty", (Object)NumberUtils.toLong((String)result.toString().trim()));
                } else {
                    actentry.set("actplantotalqty", result);
                }
                success = true;
            }
            catch (Exception exp) {
                logger.warn(String.format("\u516c\u5f0f\u8ba1\u7b97\u65f6\u51fa\u73b0\u5f02\u5e38 - \u53c2\u65701 %s  \u53c2\u65702 !----!%s ", formulaStr, ((Object)varValues).toString()), (Throwable)exp);
                actentry.set("actplantotalqty", (Object)BigDecimal.ZERO);
            }
        }
        return success;
    }

    public static void setProEntryEntityValue(DynamicObject entryObj, DynamicObject orderEntryObj, DynamicObject newEntryObj) {
        if (entryObj != null) {
            newEntryObj.set("processseq", entryObj.get("processseq"));
            newEntryObj.set("processseqname", entryObj.get("processseqname"));
            newEntryObj.set("processseqtype", (Object)entryObj.getString("processseqtype"));
            newEntryObj.set("processremark", entryObj.get("processseqremark"));
            newEntryObj.set("sourceseqid", entryObj.getPkValue());
            newEntryObj.set("processreference", entryObj.get("reference"));
            newEntryObj.set("processrelation", entryObj.get("relation"));
            newEntryObj.set("processoutput", entryObj.get("output"));
            newEntryObj.set("processinput", entryObj.get("input"));
        }
        newEntryObj.set("processseqqty", (Object)(orderEntryObj.get("baseqty") == null ? BigDecimal.ZERO : orderEntryObj.getBigDecimal("baseqty")));
        newEntryObj.set("processplanbegintime", orderEntryObj.get("planbegintime"));
        newEntryObj.set("processplanendtime", orderEntryObj.get("planendtime"));
    }

    public static void setProEntryEntityValue(DynamicObject xManuFetchentry, DynamicObject manuFetchEntry) {
        if (xManuFetchentry != null) {
            manuFetchEntry.set("processseq", xManuFetchentry.get("processseq"));
            manuFetchEntry.set("processseqqty", xManuFetchentry.get("processseqqty"));
            manuFetchEntry.set("processseqname", xManuFetchentry.get("processseqname"));
            manuFetchEntry.set("processseqtype", (Object)xManuFetchentry.getString("processseqtype"));
            manuFetchEntry.set("processremark", xManuFetchentry.get("processremark"));
            manuFetchEntry.set("processrelation", xManuFetchentry.get("processrelation"));
            manuFetchEntry.set("processoutput", xManuFetchentry.get("processoutput"));
            manuFetchEntry.set("processinput", xManuFetchentry.get("processinput"));
            manuFetchEntry.set("processreference", xManuFetchentry.get("processreference"));
            manuFetchEntry.set("processoutputdesc", xManuFetchentry.get("processoutputdesc"));
            manuFetchEntry.set("processinputdesc", xManuFetchentry.get("processinputdesc"));
            manuFetchEntry.set("processplanbegintime", xManuFetchentry.get("processplanbegintime"));
            manuFetchEntry.set("processplanendtime", xManuFetchentry.get("processplanendtime"));
            manuFetchEntry.set("processplanouttime", xManuFetchentry.get("processplanouttime"));
            manuFetchEntry.set("processplanintime", xManuFetchentry.get("processplanintime"));
        }
    }

    public static void setPorValue(DynamicObject dataEntity, String filed) {
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("proentryentity");
        for (DynamicObject object : dynamicObjectCollection) {
            DynamicObjectCollection processEntry = dataEntity.getDynamicObjectCollection("oprentryentity");
            List collect = processEntry.stream().filter(var -> object.getString(filed).equals(var.get("oprparent"))).collect(Collectors.toList());
            Optional<DynamicObject> dynamicObject = collect.stream().min(Comparator.comparing(var -> var.getInt("oprno")));
            if (dynamicObject.isPresent()) {
                object.set("processseqqty", dynamicObject.get().get("oprqty"));
            }
            if ("A".equals(object.getString("processseqtype"))) continue;
            List oprparent = collect.stream().filter(var -> object.getString("processoutput").equals(var.getString("oprno"))).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(oprparent)) {
                return;
            }
            DynamicObject outPut = (DynamicObject)oprparent.get(0);
            object.set("processoutputdesc", outPut.get("oprdescription"));
            object.set("processplanouttime", outPut.get("oprplanfinishtime"));
            List collect1 = collect.stream().filter(var -> object.getString("processinput").equals(var.getString("oprno"))).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(collect1)) {
                return;
            }
            DynamicObject inPut = (DynamicObject)collect1.get(0);
            object.set("processinputdesc", inPut.get("oprdescription"));
            object.set("processplanintime", inPut.get("oprplanbegintime"));
        }
    }

    public static void setOprEntryEntityValue(DynamicObject entryObj, DynamicObject orderEntryObj, DynamicObject newEntryObj) {
        newEntryObj.set("oprparent", (Object)entryObj.getString("parent"));
        ManuftechCreateBillUtil.setOprEntryValue(entryObj, orderEntryObj, newEntryObj);
        if ("1002".equals(entryObj.getString("machiningtype"))) {
            newEntryObj.set("purchaseorg", (Object)entryObj.getDynamicObject("purchaseorg"));
        }
        newEntryObj.set("purchasegroup", (Object)entryObj.getDynamicObject("purchasegroup"));
        newEntryObj.set("purchaseperson", (Object)entryObj.getDynamicObject("purchaseperson"));
        newEntryObj.set("purchaser", (Object)entryObj.getDynamicObject("purchaser"));
        newEntryObj.set("supplier", (Object)entryObj.getDynamicObject("supplier"));
        newEntryObj.set("currencyfield", (Object)entryObj.getDynamicObject("currencyfield"));
        newEntryObj.set("taxrate", (Object)entryObj.getDynamicObject("taxrate"));
        newEntryObj.set("taxprice", (Object)entryObj.getString("taxprice"));
        newEntryObj.set("price", (Object)entryObj.getString("price"));
        newEntryObj.set("settlementunit", (Object)entryObj.getDynamicObject("settlementunit"));
        newEntryObj.set("settlementcoefficient", (Object)entryObj.getString("settlementcoefficient"));
        newEntryObj.set("entrymaterial", (Object)entryObj.getDynamicObject("entrymaterial"));
        newEntryObj.set("oprearliestbegintime", orderEntryObj.get("planbegintime"));
        newEntryObj.set("oprlatestbegintime", orderEntryObj.get("planbegintime"));
        newEntryObj.set("oprearliestfinishtime", orderEntryObj.get("planendtime"));
        newEntryObj.set("oprlatestfinishtime", orderEntryObj.get("planendtime"));
        newEntryObj.set("oprorg", (Object)entryObj.getDynamicObject("productionorg"));
        newEntryObj.set("oprsourcetype", (Object)"A");
        newEntryObj.set("oprissplit", (Object)entryObj.getBoolean("issplit"));
        newEntryObj.set("oprsuggestsplitqty", (Object)entryObj.getBigDecimal("splitqty"));
        newEntryObj.set("oprminworktime", (Object)entryObj.getBigDecimal("minworktime"));
        newEntryObj.set("oprtimeunit", (Object)entryObj.getString("timeunit"));
        newEntryObj.set("oprisprocessoverlap", (Object)entryObj.getBoolean("isprocessoverlap"));
        newEntryObj.set("oprminoverlaptime", (Object)entryObj.getBigDecimal("minoverlaptime"));
        newEntryObj.set("oproverlaptimeunit", (Object)entryObj.getString("overlaptimeunit"));
        newEntryObj.set("oproverlapqty", (Object)entryObj.getBigDecimal("overlapqty"));
        newEntryObj.set("overlapunit", (Object)entryObj.getDynamicObject("overlapunit"));
        newEntryObj.set("operationunit", (Object)entryObj.getDynamicObject("operationunit"));
        newEntryObj.set("storagepoint", entryObj.get("storagepoint"));
        DynamicObject parent = (DynamicObject)newEntryObj.getParent();
        if (parent != null && "sfc_manftech".equals(parent.getDataEntityType().getName())) {
            DynamicObject oprctrlstrategy;
            newEntryObj.set("firstinspection", entryObj.get("firstcheck"));
            if (((Boolean)entryObj.get("firstcheck")).booleanValue()) {
                newEntryObj.set("firstinspectioncontrol", (Object)"A");
            }
            if ((oprctrlstrategy = entryObj.getDynamicObject("oprctrlstrategy")) != null) {
                newEntryObj.set("beginworkbf", oprctrlstrategy.get("startbackflush"));
            }
        }
        newEntryObj.set("inspectiontype", entryObj.get("checktype"));
        newEntryObj.set("collaborative", entryObj.get("collaborative"));
        newEntryObj.set("ismilestoneprocess", entryObj.get("ismilestoneprocess"));
        newEntryObj.set("workstation", entryObj.get("workstation"));
        ManuftechCreateBillUtil.recalculateEntryQty(newEntryObj, orderEntryObj);
    }

    public static void setRestructureOprEntryEntityValue(DynamicObject processRouteEntryObj, DynamicObject pdmRouteEntry, DynamicObject newEntryObj) {
        newEntryObj.set("tosourcetype", (Object)"B");
        if (null != processRouteEntryObj) {
            String tochangetype = "";
            newEntryObj.set("tochangetype", (Object)tochangetype);
            newEntryObj.set("tooprno", (Object)processRouteEntryObj.getString("operationno"));
            newEntryObj.set("tooprparent", (Object)processRouteEntryObj.getString("parent"));
            newEntryObj.set("tooproperation", (Object)processRouteEntryObj.getDynamicObject("operation"));
            newEntryObj.set("tooprdescription", (Object)processRouteEntryObj.getString("operationdesc"));
            newEntryObj.set("tooprorg", (Object)processRouteEntryObj.getDynamicObject("productionorg"));
            newEntryObj.set("tooprworkshop", (Object)processRouteEntryObj.getDynamicObject("productionworkshop"));
            newEntryObj.set("tooprworkcenter", (Object)processRouteEntryObj.getDynamicObject("workcenter"));
            newEntryObj.set("tooprctrlstrategy", (Object)processRouteEntryObj.getDynamicObject("oprctrlstrategy"));
            newEntryObj.set("tomachiningtype", (Object)processRouteEntryObj.getString("machiningtype"));
            newEntryObj.set("toinspectiontype", processRouteEntryObj.get("checktype"));
            newEntryObj.set("tooprunit", (Object)processRouteEntryObj.getDynamicObject("operationunit"));
            newEntryObj.set("tostoragepoint", processRouteEntryObj.get("storagepoint"));
        }
        if (null != pdmRouteEntry) {
            newEntryObj.set("toprocessseqtype", pdmRouteEntry.get("processseqtype"));
            newEntryObj.set("toprocessseqname", pdmRouteEntry.get("processseqname"));
        }
    }

    public static void setPaneldefOprEntryEntityValue(DynamicObject technicsObj, Map<String, Object> oprInfo, DynamicObject orderEntryObj, DynamicObject newEntryObj) {
        newEntryObj.set("oprparent", (Object)"1");
        newEntryObj.set("oprstatus", (Object)"A");
        newEntryObj.set("oprproductionqty", (Object)technicsObj.getBigDecimal("qty"));
        newEntryObj.set("oprorg", (Object)technicsObj.getDynamicObject("org"));
        newEntryObj.set("oprprocessgroup", oprInfo.get("progroup"));
        newEntryObj.set("oprprofessiona", oprInfo.get("major"));
        newEntryObj.set("oprworkhourunit", orderEntryObj.get("workhourunit"));
        newEntryObj.set("oprworkhours", oprInfo.get("workhours"));
        newEntryObj.set("oprsourcetype", (Object)"C");
        newEntryObj.set("oprplanbegintime", orderEntryObj.get("planbegintime"));
        newEntryObj.set("oprplanfinishtime", orderEntryObj.get("planendtime"));
        newEntryObj.set("upperratio", (Object)BigDecimal.ZERO);
        newEntryObj.set("floorratio", (Object)BigDecimal.ZERO);
        newEntryObj.set("basebatchqty", (Object)BigDecimal.ONE);
        newEntryObj.set("headqty", (Object)BigDecimal.ONE);
        newEntryObj.set("operationqty", (Object)BigDecimal.ONE);
        newEntryObj.set("oprunit", orderEntryObj.get("workhourunit"));
        newEntryObj.set("headunit", orderEntryObj.get("workhourunit"));
        newEntryObj.set("upperqty", (Object)newEntryObj.getBigDecimal("oprqty"));
        newEntryObj.set("floorqty", (Object)newEntryObj.getBigDecimal("oprqty"));
    }

    public static void setSWSOprEntryEntityValue(DynamicObject technicsObj, DynamicObject entryObj, DynamicObject orderEntryObj, DynamicObject newEntryObj) {
        newEntryObj.set("seq", (Object)1);
        newEntryObj.set("oprparent", (Object)"1");
        newEntryObj.set("oprno", (Object)"10");
        newEntryObj.set("oprstatus", (Object)"A");
        newEntryObj.set("oprswsentryid", entryObj.getPkValue());
        newEntryObj.set("oprproductionqty", (Object)technicsObj.getBigDecimal("qty"));
        newEntryObj.set("oprorg", (Object)technicsObj.getDynamicObject("org"));
        newEntryObj.set("oprprocessgroup", (Object)entryObj.getDynamicObject("progroup"));
        newEntryObj.set("oprprofessiona", (Object)entryObj.getDynamicObject("professiona"));
        newEntryObj.set("oprworkhourunit", entryObj.get("enworkhourunit"));
        newEntryObj.set("oprworkhours", entryObj.get("workhours"));
        newEntryObj.set("oprcustomhours", entryObj.get("workhours"));
        newEntryObj.set("oprsourcetype", (Object)"C");
        newEntryObj.set("oprplanbegintime", orderEntryObj.get("planbegintime"));
        newEntryObj.set("oprplanfinishtime", orderEntryObj.get("planendtime"));
        newEntryObj.set("upperratio", (Object)BigDecimal.ZERO);
        newEntryObj.set("floorratio", (Object)BigDecimal.ZERO);
        newEntryObj.set("basebatchqty", (Object)BigDecimal.ONE);
        newEntryObj.set("headqty", (Object)BigDecimal.ONE);
        newEntryObj.set("operationqty", (Object)BigDecimal.ONE);
        newEntryObj.set("oprunit", entryObj.get("enworkhourunit"));
        newEntryObj.set("headunit", entryObj.get("enworkhourunit"));
        newEntryObj.set("upperqty", (Object)newEntryObj.getBigDecimal("oprqty"));
        newEntryObj.set("floorqty", (Object)newEntryObj.getBigDecimal("oprqty"));
    }

    public static void setCardOprEntryEntityValue(DynamicObject orderTechnicsObj, DynamicObject entryObj, DynamicObject orderEntryObj, DynamicObject newEntryObj) {
        newEntryObj.set("oprparent", (Object)"1");
        ManuftechCreateBillUtil.setOprEntryValue(entryObj, orderEntryObj, newEntryObj);
        newEntryObj.set("oprorg", (Object)orderTechnicsObj.getDynamicObject("org"));
        newEntryObj.set("oprprocessgroup", (Object)entryObj.getDynamicObject("processgroup"));
        newEntryObj.set("oprprofessiona", (Object)entryObj.getDynamicObject("professiona"));
        newEntryObj.set("oprworkhours", entryObj.get("standardhours"));
        newEntryObj.set("oprcustomhours", entryObj.get("customhours"));
        newEntryObj.set("oprsourcetype", (Object)"C");
        newEntryObj.set("oprremark", (Object)entryObj.getString("remark"));
        newEntryObj.set("oprpageseq", (Object)entryObj.getString("pageseq1"));
        BigDecimal divide = entryObj.getBigDecimal("upperratio").divide(new BigDecimal("100"), 10, 4);
        newEntryObj.set("upperqty", (Object)divide.add(BigDecimal.ONE).multiply(newEntryObj.getBigDecimal("oprqty")));
        BigDecimal decimal = entryObj.getBigDecimal("floorratio").divide(new BigDecimal("100"), 10, 4);
        newEntryObj.set("floorqty", (Object)BigDecimal.ONE.subtract(decimal).multiply(newEntryObj.getBigDecimal("oprqty")));
    }

    private static void setOprEntryValue(DynamicObject entryObj, DynamicObject orderEntryObj, DynamicObject newEntryObj) {
        newEntryObj.set("oprno", (Object)entryObj.getString("operationno"));
        newEntryObj.set("oprworkcenter", (Object)entryObj.getDynamicObject("workcenter"));
        newEntryObj.set("oprworkshop", (Object)entryObj.getDynamicObject("productionworkshop"));
        newEntryObj.set("oproperation", (Object)entryObj.getDynamicObject("operation"));
        newEntryObj.set("oprdescription", (Object)entryObj.getString("operationdesc"));
        newEntryObj.set("oprctrlstrategy", (Object)entryObj.getDynamicObject("oprctrlstrategy"));
        newEntryObj.set("machiningtype", (Object)entryObj.getString("machiningtype"));
        newEntryObj.set("oprunit", (Object)entryObj.getDynamicObject("operationunit"));
        newEntryObj.set("oprstatus", (Object)"A");
        newEntryObj.set("oprtotalsplitqty", (Object)BigDecimal.ZERO);
        newEntryObj.set("oprsourceentryid", entryObj.getPkValue());
        newEntryObj.set("oprplanbegintime", orderEntryObj.get("planbegintime"));
        newEntryObj.set("oprplanfinishtime", orderEntryObj.get("planendtime"));
        newEntryObj.set("upperratio", (Object)entryObj.getBigDecimal("upperratio"));
        newEntryObj.set("floorratio", (Object)entryObj.getBigDecimal("floorratio"));
        newEntryObj.set("headqty", (Object)entryObj.getBigDecimal("headqty"));
        newEntryObj.set("headunit", (Object)entryObj.getDynamicObject("headunit"));
        newEntryObj.set("operationqty", (Object)entryObj.getBigDecimal("operationqty"));
        newEntryObj.set("basebatchqty", (Object)entryObj.getBigDecimal("basebatchqty"));
    }

    public static void setOprEntryValue(DynamicObject xManuFetchentry, DynamicObject manuFetchEntry) {
        manuFetchEntry.set("oprparent", (Object)xManuFetchentry.getString("oprparent"));
        manuFetchEntry.set("oprno", (Object)xManuFetchentry.getString("oprno"));
        manuFetchEntry.set("oprorg", (Object)xManuFetchentry.getDynamicObject("oprorg"));
        manuFetchEntry.set("oprworkcenter", (Object)xManuFetchentry.getDynamicObject("oprworkcenter"));
        manuFetchEntry.set("oprworkshop", (Object)xManuFetchentry.getDynamicObject("oprworkshop"));
        manuFetchEntry.set("oproperation", (Object)xManuFetchentry.getDynamicObject("oproperation"));
        manuFetchEntry.set("oprdescription", (Object)xManuFetchentry.getString("oprdescription"));
        manuFetchEntry.set("oprctrlstrategy", (Object)xManuFetchentry.getDynamicObject("oprctrlstrategy"));
        manuFetchEntry.set("machiningtype", (Object)xManuFetchentry.getString("machiningtype"));
        manuFetchEntry.set("inspectiontype", (Object)xManuFetchentry.getString("inspectiontype"));
        manuFetchEntry.set("oprunit", (Object)xManuFetchentry.getDynamicObject("oprunit"));
        manuFetchEntry.set("oprplanbegintime", xManuFetchentry.get("oprplanbegintime"));
        manuFetchEntry.set("oprplanfinishtime", xManuFetchentry.get("oprplanfinishtime"));
        manuFetchEntry.set("oprstatus", (Object)xManuFetchentry.getString("oprstatus"));
        manuFetchEntry.set("oprsourcetype", (Object)xManuFetchentry.getString("oprsourcetype"));
        manuFetchEntry.set("upperratio", (Object)xManuFetchentry.getBigDecimal("upperratio"));
        manuFetchEntry.set("floorratio", (Object)xManuFetchentry.getBigDecimal("floorratio"));
        manuFetchEntry.set("upperqty", (Object)xManuFetchentry.getBigDecimal("upperqty"));
        manuFetchEntry.set("floorqty", (Object)xManuFetchentry.getBigDecimal("floorqty"));
        manuFetchEntry.set("oprstandardqty", (Object)xManuFetchentry.getBigDecimal("oprstandardqty"));
        manuFetchEntry.set("oprqty", (Object)xManuFetchentry.getBigDecimal("oprqty"));
        manuFetchEntry.set("storagepoint", xManuFetchentry.get("storagepoint"));
        manuFetchEntry.set("ismilestoneprocess", xManuFetchentry.get("ismilestoneprocess"));
        manuFetchEntry.set("collaborative", xManuFetchentry.get("collaborative"));
        manuFetchEntry.set("firstinspection", xManuFetchentry.get("firstinspection"));
        manuFetchEntry.set("oprearliestbegintime", xManuFetchentry.get("oprearliestbegintime"));
        manuFetchEntry.set("oprlatestbegintime", xManuFetchentry.get("oprlatestbegintime"));
        manuFetchEntry.set("oprearliestfinishtime", xManuFetchentry.get("oprearliestfinishtime"));
        manuFetchEntry.set("oprlatestfinishtime", xManuFetchentry.get("oprlatestfinishtime"));
        manuFetchEntry.set("firstinspectioncontrol", xManuFetchentry.get("firstinspectioncontrol"));
        manuFetchEntry.set("headqty", (Object)xManuFetchentry.getBigDecimal("headqty"));
        manuFetchEntry.set("headunit", (Object)xManuFetchentry.getDynamicObject("headunit"));
        manuFetchEntry.set("operationqty", (Object)xManuFetchentry.getBigDecimal("operationqty"));
        manuFetchEntry.set("basebatchqty", (Object)xManuFetchentry.getBigDecimal("basebatchqty"));
        manuFetchEntry.set("workstation", (Object)xManuFetchentry.getDynamicObject("workstation"));
        manuFetchEntry.set("purchaseorg", (Object)xManuFetchentry.getDynamicObject("purchaseorg"));
        manuFetchEntry.set("purchasegroup", (Object)xManuFetchentry.getDynamicObject("purchasegroup"));
        manuFetchEntry.set("purchaser", (Object)xManuFetchentry.getDynamicObject("purchaser"));
        manuFetchEntry.set("supplier", (Object)xManuFetchentry.getDynamicObject("supplier"));
        manuFetchEntry.set("opraccountingorg", (Object)xManuFetchentry.getDynamicObject("opraccountingorg"));
        manuFetchEntry.set("opriscrossesacctorg", xManuFetchentry.get("opriscrossesacctorg"));
    }

    public static void setActSubEntryEntityValue(DynamicObject xManuFetchentry, DynamicObject manuFetchEntry) {
        manuFetchEntry.set("actactivity", xManuFetchentry.get("actactivity"));
        manuFetchEntry.set("actunit", (Object)xManuFetchentry.getDynamicObject("actunit"));
        manuFetchEntry.set("actresources", xManuFetchentry.get("actresources"));
        manuFetchEntry.set("actqty", (Object)xManuFetchentry.getBigDecimal("actqty"));
        manuFetchEntry.set("actstandardformula", xManuFetchentry.get("actstandardformula"));
        manuFetchEntry.set("actstandardformula1", xManuFetchentry.get("actstandardformula1"));
        manuFetchEntry.set("biztype", xManuFetchentry.get("biztype"));
        if (xManuFetchentry.get("actactivity") != null) {
            manuFetchEntry.set("processstage", xManuFetchentry.getDynamicObject("actactivity").get("processstage"));
        }
        manuFetchEntry.set("actplanbegintime", xManuFetchentry.get("actplanbegintime"));
        manuFetchEntry.set("actplanfinishtime", xManuFetchentry.get("actplanfinishtime"));
        manuFetchEntry.set("actplantotalqty", xManuFetchentry.get("actplantotalqty"));
    }

    public static void setActSubEntryEntityValue(DynamicObject entryObj, DynamicObject orderEntryObj, DynamicObject newEntryObj) {
        ManuftechCreateBillUtil.setActSubEntryEntityValue(entryObj, orderEntryObj, newEntryObj, "sfc_manftech");
    }

    public static void setActSubEntryEntityValue(DynamicObject entryObj, DynamicObject orderEntryObj, DynamicObject newEntryObj, String entity) {
        DynamicObject newSubEntryObj;
        DynamicObject subEntryObj;
        int k;
        DynamicObjectCollection subEntryCol = entryObj.getDynamicObjectCollection("actentryentity");
        for (k = 0; k < subEntryCol.size(); ++k) {
            subEntryObj = (DynamicObject)subEntryCol.get(k);
            newSubEntryObj = newEntryObj.getDynamicObjectCollection("actsubentryentity").addNew();
            if (newSubEntryObj.containsProperty("seq") && subEntryObj.containsProperty("seq")) {
                newSubEntryObj.set("seq", subEntryObj.get("seq") != null ? subEntryObj.get("seq") : Integer.valueOf(k + 1));
            }
            newSubEntryObj.set("actactivity", subEntryObj.get("activity"));
            newSubEntryObj.set("actunit", subEntryObj.getDynamicObject("activity") == null ? null : subEntryObj.getDynamicObject("activity").getDynamicObject("unit"));
            newSubEntryObj.set("actresources", subEntryObj.get("actresource"));
            newSubEntryObj.set("actqty", (Object)subEntryObj.getBigDecimal("baseqty"));
            newSubEntryObj.set("actstandardformula", subEntryObj.get("standardformula"));
            newSubEntryObj.set("actminformula", subEntryObj.get("minformula"));
            newSubEntryObj.set("actstandardformula1", subEntryObj.get("standardformula1"));
            newSubEntryObj.set("actminformula1", subEntryObj.get("minformula1"));
            newSubEntryObj.set("biztype", subEntryObj.get("biztype"));
            if (subEntryObj.get("activity") != null) {
                newSubEntryObj.set("processstage", subEntryObj.getDynamicObject("activity").get("processstage"));
            }
            newSubEntryObj.set("sourceactid", subEntryObj.getPkValue());
            newSubEntryObj.set("actplanbegintime", orderEntryObj.get("planbegintime"));
            newSubEntryObj.set("actplanfinishtime", orderEntryObj.get("planendtime"));
            ManuftechCreateBillUtil.runFormula(newSubEntryObj, entity);
        }
        subEntryCol = entryObj.getDynamicObjectCollection("subentryentity");
        for (k = 0; k < subEntryCol.size(); ++k) {
            subEntryObj = (DynamicObject)subEntryCol.get(k);
            newSubEntryObj = newEntryObj.getDynamicObjectCollection("ressubentryentity").addNew();
            newSubEntryObj.set("schresource", subEntryObj.get("resource"));
            newSubEntryObj.set("sourceresid", subEntryObj.getPkValue());
        }
    }

    public static void setGroEntryEntityValue(DynamicObject object, Date date, long userId) {
        DynamicObjectCollection dynamicObjectCollection = object.getDynamicObjectCollection("oprentryentity");
        Map<DynamicObject, List<DynamicObject>> map = dynamicObjectCollection.stream().filter(x -> x.getDynamicObject("oprprocessgroup") != null).collect(Collectors.groupingBy(x -> x.getDynamicObject("oprprocessgroup")));
        HashMap<DynamicObject, List> result = new HashMap<DynamicObject, List>(16);
        map.forEach((k, v) -> result.put((DynamicObject)k, v.stream().map(x -> x.getString("oprstatus")).collect(Collectors.toList())));
        DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user", (String)"id");
        if (MapUtils.isNotEmpty(result)) {
            object.getDynamicObjectCollection("groentryentity").removeAll((Collection)object.getDynamicObjectCollection("groentryentity"));
            result.forEach((k, v) -> {
                DynamicObject newEntryObj = object.getDynamicObjectCollection("groentryentity").addNew();
                newEntryObj.set("groprocessgroup", k);
                newEntryObj.set("grogroupstatus", (Object)"A");
                newEntryObj.set("gromodifier", (Object)user);
                newEntryObj.set("gromodifytime", (Object)date);
            });
        }
    }

    public static void setOprEntryAccountingOrgValue(DynamicObject entity, Map<Long, Object> data, Map<Object, DynamicObject> orgMap) {
        DynamicObjectCollection oprEntry = entity.getDynamicObjectCollection("oprentryentity");
        for (DynamicObject opr : oprEntry) {
            if (opr.getDynamicObject("oprorg") == null) continue;
            opr.set("opraccountingorg", (Object)orgMap.get(data.get(opr.getDynamicObject("oprorg").getLong("id"))));
            opr.set("opriscrossesacctorg", (Object)(!Objects.equals(orgMap.get(data.get(entity.getDynamicObject("org").getLong("id"))), orgMap.get(data.get(opr.getDynamicObject("oprorg").getLong("id")))) ? 1 : 0));
        }
    }
}

