/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.mftorder.helper;

import java.math.BigDecimal;
import kd.bd.mpdm.common.mftorder.enums.PrecisionAccountEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class BillUnitAndQtytHelper {
    public static BigDecimal getDesQtyConv(DynamicObject material, DynamicObject srcUnit, BigDecimal srcQty, DynamicObject desUnit) {
        if (material != null && srcUnit != null && desUnit != null && srcQty != null && srcQty.compareTo(BigDecimal.ZERO) != 0) {
            if (srcUnit.getPkValue().equals(desUnit.getPkValue())) {
                return srcQty;
            }
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)((Long)material.getPkValue()), (Long)((Long)srcUnit.getPkValue()), (Long)((Long)desUnit.getPkValue()));
            if (muConv != null && muConv.getInt("numerator") != 0) {
                int precision = desUnit.getInt("precision");
                String precisionAccount = desUnit.getString("precisionaccount");
                if (StringUtils.isNotEmpty((CharSequence)precisionAccount)) {
                    return srcQty.multiply(new BigDecimal(muConv.getInt("numerator"))).divide(new BigDecimal(muConv.getInt("denominator")), precision, PrecisionAccountEnum.getEnumByVal(Integer.parseInt(precisionAccount)));
                }
            }
        }
        return BigDecimal.ZERO;
    }
}

