/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.mftorder.helper;

import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class MaterialHelper {
    private static final String BD_MATERIALMFTINFO = "bd_materialmftinfo";
    private static final String BD_MATERIALPURCHASEINFO = "bd_materialpurchaseinfo";
    private static final String BD_MATERIALSALINFO = "bd_materialsalinfo";
    private static final String BD_MATERIALINVENTORYINFO = "bd_materialinventoryinfo";

    private MaterialHelper() {
    }

    public static DynamicObject getMaterialByMatBiz(DynamicObject material) {
        DynamicObject newmaterial;
        if (material == null) {
            return null;
        }
        if (!(BD_MATERIALINVENTORYINFO.equals(material.getDataEntityType().getName()) || BD_MATERIALPURCHASEINFO.equals(material.getDataEntityType().getName()) || BD_MATERIALSALINFO.equals(material.getDataEntityType().getName()) || BD_MATERIALMFTINFO.equals(material.getDataEntityType().getName()))) {
            QFilter qFilter1 = new QFilter("id", "=", material.getPkValue());
            newmaterial = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_material", (QFilter[])new QFilter[]{qFilter1});
        } else {
            QFilter qFilter1 = new QFilter("id", "=", material.getDynamicObject("masterid").getPkValue());
            newmaterial = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_material", (QFilter[])new QFilter[]{qFilter1});
        }
        return newmaterial;
    }

    public static DynamicObject getMaterialBizUnit(DynamicObject material) {
        String entityName = material.getDataEntityType().getName();
        DynamicObject bizUnit = BD_MATERIALINVENTORYINFO.equals(entityName) ? material.getDynamicObject("inventoryunit") : (BD_MATERIALPURCHASEINFO.equals(entityName) ? material.getDynamicObject("purchaseunit") : (Objects.equals(BD_MATERIALSALINFO, entityName) ? material.getDynamicObject("salesunit") : (Objects.equals(BD_MATERIALMFTINFO, entityName) ? material.getDynamicObject("mftunit") : material.getDynamicObject("baseunit"))));
        return BusinessDataServiceHelper.loadSingleFromCache((Object)bizUnit.getPkValue(), (String)bizUnit.getDataEntityType().getName());
    }

    public static DynamicObject getMaterialPriceUnit(DynamicObject material) {
        DynamicObject bizUnit = BD_MATERIALINVENTORYINFO.equals(material.getDataEntityType().getName()) ? material.getDynamicObject("inventoryunit") : (BD_MATERIALPURCHASEINFO.equals(material.getDataEntityType().getName()) ? material.getDynamicObject("purchasepriceunit") : (Objects.equals(BD_MATERIALSALINFO, material.getDataEntityType().getName()) ? material.getDynamicObject("salesvalunit") : (Objects.equals(BD_MATERIALMFTINFO, material.getDataEntityType().getName()) ? material.getDynamicObject("mftunit") : material.getDynamicObject("baseunit"))));
        return bizUnit;
    }
}

