/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.mftorder.helper;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;

public class MergeBotpAutoFixLinkHelper {
    private static final Log logger = LogFactory.getLog(MergeBotpAutoFixLinkHelper.class);
    private String billType = null;

    public MergeBotpAutoFixLinkHelper() {
    }

    public MergeBotpAutoFixLinkHelper(String billtype) {
        this.billType = billtype;
    }

    public void fixRowLink(DynamicObject targetBillObj, String targetEntryKey, String srcBillType, Map<String, String> srcCustomParams, String srcEntryKey) {
        if (targetBillObj == null || StringUtils.isEmpty((CharSequence)targetEntryKey) || StringUtils.isEmpty((CharSequence)srcBillType) || StringUtils.isEmpty((CharSequence)srcEntryKey)) {
            return;
        }
        logger.info(String.format("\u4fee\u590d\u5173\u8054\u5173\u7cfb\uff1a%1$s", srcCustomParams));
        if (srcCustomParams == null || srcCustomParams.size() < 1) {
            return;
        }
        TableDefine targetTableDefine = EntityMetadataCache.loadTableDefine((String)targetBillObj.getDataEntityType().getName(), (String)targetEntryKey);
        TableDefine srcTableDefine = EntityMetadataCache.loadTableDefine((String)srcBillType, (String)srcEntryKey);
        this.createLinkEntity(targetTableDefine, targetBillObj, srcTableDefine, srcCustomParams);
    }

    private void createLinkEntity(TableDefine targetTableDefine, DynamicObject targetBillObj, TableDefine srcTableDefine, Map<String, String> srcCustomParams) {
        String srcId = srcCustomParams.get("srcBillId");
        String srcBillNo = srcCustomParams.get("srcBillNo");
        String srcBillEntryId = srcCustomParams.get("srcBillEntryId");
        String lkEntryKey = targetTableDefine.getEntityKey() + "_lk";
        Long srcTableId = srcTableDefine.getTableId();
        DynamicObjectCollection targetRows = targetBillObj.getDynamicObjectCollection(targetTableDefine.getEntityKey());
        if (targetRows.size() < 1) {
            String lkHeadKey = "billhead_lk";
            DynamicObjectCollection linkRows = targetBillObj.getDynamicObjectCollection(lkHeadKey);
            linkRows.clear();
            DynamicObject linkRow = new DynamicObject(linkRows.getDynamicObjectType());
            linkRows.add((Object)linkRow);
            linkRow.set((String)lkHeadKey + "_stableid", (Object)srcTableId);
            linkRow.set((String)lkHeadKey + "_sbillid", (Object)srcId);
            linkRow.set((String)lkHeadKey + "_sid", (Object)srcBillEntryId);
        } else {
            for (DynamicObject targetRow : targetRows) {
                DynamicObjectCollection linkRows = targetRow.getDynamicObjectCollection(lkEntryKey);
                if (!linkRows.isEmpty() || linkRows.getDynamicObjectType() == null) continue;
                DynamicObject linkRow = new DynamicObject(linkRows.getDynamicObjectType());
                linkRows.add((Object)linkRow);
                linkRow.set(lkEntryKey + "_stableid", (Object)srcTableId);
                linkRow.set(lkEntryKey + "_sbillid", (Object)srcId);
                linkRow.set(lkEntryKey + "_sid", (Object)srcBillEntryId);
            }
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"pom_mftorder");
        DynamicObject orderObject = new DynamicObject((DynamicObjectType)dataEntityType);
        DynamicObjectCollection dynamicObjectCollection = orderObject.getDynamicObjectCollection("treeentryentity");
        DynamicObject entryObject = new DynamicObject(dynamicObjectCollection.getDynamicObjectType());
        entryObject.set("id", (Object)Long.parseLong(srcBillEntryId));
        if (StringUtils.equals((CharSequence)this.billType, (CharSequence)"pom_mftstock")) {
            logger.info(String.format("\u4fee\u590d\u5173\u8054\u5173\u7cfb\u7ec4\u4ef6\u6e05\u5355\u8bbe\u7f6e\u5de5\u5355\u4fe1\u606f\uff1a%1$s", srcCustomParams));
            targetBillObj.set("orderentryid", (Object)entryObject);
            targetBillObj.set("orderid", (Object)srcId);
            targetBillObj.set("orderno", (Object)srcBillNo);
        } else {
            logger.info(String.format("\u4fee\u590d\u5173\u8054\u5173\u7cfb\u5de5\u5e8f\u8ba1\u5212\u8bbe\u7f6e\u5de5\u5355\u4fe1\u606f,\u6e90\u5de5\u5355\u5206\u5f55ID\uff1a%1$s", srcBillEntryId));
            targetBillObj.set("mftentryseq", (Object)entryObject);
            targetBillObj.set("manufactureorderid", (Object)srcId);
        }
    }
}

