/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.mftorder.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.common.utils.CommonUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class OrgHelper {
    private static final String KEY_BD_CURRENCY = "bd_currency";

    public static DynamicObject getCurrency(Long orgId) {
        if (orgId == null) {
            return null;
        }
        List idList = OrgUnitServiceHelper.getFromOrgs((String)"05", (Long)orgId, (String)"10");
        DynamicObject settlecurrency = null;
        if (idList != null && idList.size() > 0) {
            Map mapCur = BaseDataServiceHelper.getBaseAccountingInfo((Long)((Long)idList.get(0)));
            Object curId = null;
            if (mapCur != null && mapCur.size() != 0) {
                curId = mapCur.get("baseCurrencyID");
                settlecurrency = BusinessDataServiceHelper.loadSingle(curId, (String)KEY_BD_CURRENCY);
            }
        }
        return settlecurrency;
    }

    public static Long getMftOrgByUserOrg(Long userId, Long orgId, String entityNum, String appid) {
        int hasPermissin;
        if (OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"04") && (hasPermissin = PermissionServiceHelper.checkPermission((Long)userId, (Long)orgId, (String)"04", (String)appid, (String)entityNum, (String)"47150e89000000ac")) == 1) {
            return orgId;
        }
        List permOrgIds = PermissionServiceHelper.getUserHasPermOrgs((long)userId).getHasPermOrgs();
        List permProduceOrgIds = OrgUnitServiceHelper.filterOrgDuty((List)permOrgIds, (String)"04");
        if (permProduceOrgIds.size() > 0) {
            for (Long produceOrgId : permProduceOrgIds) {
                int hasPermissin2 = PermissionServiceHelper.checkPermission((Long)userId, (Long)produceOrgId, (String)"04", (String)appid, (String)entityNum, (String)"47150e89000000ac");
                if (hasPermissin2 != 1) continue;
                return produceOrgId;
            }
        }
        return null;
    }

    public static long getPurchaseOrg(long oprOrgId) {
        List allToOrg = OrgUnitServiceHelper.getAllToOrg((String)"", (String)"02", (Long)oprOrgId, (boolean)true);
        if (CollectionUtils.isNotEmpty((Collection)allToOrg)) {
            return (Long)allToOrg.get(0);
        }
        List orgIds = OrgUnitServiceHelper.getAllOrg((String)"02");
        return (Long)orgIds.get(0);
    }

    public static List<Long> getHasPermissionOrg(String entityName, String orgViewType) {
        List hasPermissionOrgs = OrgViewServiceHelper.getAllPermissionOrgs((String)entityName, (String)orgViewType);
        if (CommonUtils.isNull(hasPermissionOrgs)) {
            return null;
        }
        ArrayList<Long> orgs = new ArrayList<Long>(hasPermissionOrgs.size());
        for (Map tempOrg : hasPermissionOrgs) {
            Long tempOrgId = Long.valueOf((String)tempOrg.get("id"));
            orgs.add(tempOrgId);
        }
        return orgs;
    }

    public static Long getDefaultOrg(String entityName, String orgViewType) {
        long orgId = RequestContext.get().getOrgId();
        List<Long> orgs = OrgHelper.getHasPermissionOrg(entityName, orgViewType);
        if (orgs == null) {
            return null;
        }
        if (orgs.contains(orgId)) {
            return orgId;
        }
        return orgs.get(0);
    }
}

