/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.mftorder.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;

public class CalPickMaterialUtils {
    public static Map<String, BigDecimal> calPickPairs(List<DynamicObject> orderEntitys, boolean max) {
        HashMap<String, BigDecimal> entrysPickQty = new HashMap<String, BigDecimal>(orderEntitys.size());
        List orderIdList = orderEntitys.stream().map(k -> k.getString("id")).collect(Collectors.toList());
        List orderEntryIdList = orderEntitys.stream().flatMap(k -> k.getDynamicObjectCollection("treeentryentity").stream()).map(k -> k.getLong("id")).collect(Collectors.toList());
        List<Long> transactiontypeList = orderEntitys.stream().map(k -> k.getDynamicObject("transactiontype").getLong("id")).collect(Collectors.toList());
        QFilter filter = new QFilter("orderid", "in", orderIdList);
        filter.and(new QFilter("orderentryid", "in", orderEntryIdList));
        Map<String, List<Map<String, Object>>> stockMap = CalPickMaterialUtils.getStockMap(filter);
        Map<String, String> stockUnit = CalPickMaterialUtils.getStockUnit(stockMap);
        Map<String, DynamicObject> transactiontypeMap = CalPickMaterialUtils.getTransTypes(transactiontypeList);
        for (DynamicObject orderEntity : orderEntitys) {
            DynamicObjectCollection entrys = orderEntity.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject entry : entrys) {
                String key = orderEntity.getString("billno") + "@" + entry.getPkValue();
                BigDecimal qty = entry.getBigDecimal("qty");
                List<Map<String, Object>> stockCol = stockMap.get(key);
                if (!CollectionUtils.isNotEmpty(stockCol)) continue;
                BigDecimal pickQty = CalPickMaterialUtils.calPickQty(max, transactiontypeMap, orderEntity, stockCol, qty, stockUnit);
                entrysPickQty.put(key, pickQty);
            }
        }
        return entrysPickQty;
    }

    private static Map<String, DynamicObject> getTransTypes(List<Long> transactiontypeList) {
        QFilter[] filters1 = new QFilter[]{new QFilter("id", "in", transactiontypeList)};
        DynamicObject[] transList = BusinessDataServiceHelper.load((String)"mpdm_transactproduct", (String)"id,isvolcal,controlscope,isautoclose", (QFilter[])filters1);
        Map<String, DynamicObject> map = Stream.of(transList).collect(Collectors.toMap(trans -> trans.getPkValue().toString(), o -> o));
        return map;
    }

    private static BigDecimal calPickQty(boolean max, Map<String, DynamicObject> transactiontypeMap, DynamicObject manuBill, List<Map<String, Object>> stockentrys, BigDecimal qty, Map<String, String> stockUnit) {
        BigDecimal pickQty = BigDecimal.ZERO;
        if (stockentrys == null || stockentrys.size() < 1) {
            return pickQty;
        }
        String controlscope = CalPickMaterialUtils.getControlScope(manuBill, transactiontypeMap);
        Map<Long, List<Map>> groupedByGroupId = stockentrys.stream().filter(stockEntry -> max ? CalPickMaterialUtils.isCompletePairValid(stockEntry) : CalPickMaterialUtils.isPickPairValid(controlscope, stockEntry)).collect(Collectors.groupingBy(entry -> {
            long groupId = (Long)entry.get("replaceplanId") != 0L && (Long)entry.get("replacegroupid") == 0L ? (Long)entry.get("replaceplanId") : ((Long)entry.get("replacegroupid") != 0L ? ((Long)entry.get("replacegroupid")).longValue() : ((Long)entry.get("stockEntryId")).longValue());
            return groupId;
        }));
        HashMap minQuantityByPriorityInGroups = new HashMap(groupedByGroupId.size());
        for (Map.Entry<Long, List<Map>> groupEntry : groupedByGroupId.entrySet()) {
            Long groupId = groupEntry.getKey();
            List<Map> groupObjects = groupEntry.getValue();
            Map<Long, List<Map>> groupedByPriority = groupObjects.stream().collect(Collectors.groupingBy(map -> (Long)map.get("priority")));
            HashMap<Long, BigDecimal> quantityByPriority = new HashMap<Long, BigDecimal>(groupedByPriority.size());
            for (Map.Entry<Long, List<Map>> priorityEntry : groupedByPriority.entrySet()) {
                Long priority = priorityEntry.getKey();
                List<Map> priorityObjects = priorityEntry.getValue();
                Stream<BigDecimal> stream = priorityObjects.stream().map(stockEntry -> CalPickMaterialUtils.calPickQtyByEntry(controlscope, stockEntry, qty, stockUnit));
                Optional<BigDecimal> quantity = max ? stream.max(BigDecimal::compareTo) : stream.min(BigDecimal::compareTo);
                quantityByPriority.put(priority, quantity.orElse(BigDecimal.ZERO));
            }
            minQuantityByPriorityInGroups.put(groupId, quantityByPriority);
        }
        HashMap<Long, BigDecimal> groupFinalQuantities = new HashMap<Long, BigDecimal>(minQuantityByPriorityInGroups.size());
        for (Map.Entry groupEntry : minQuantityByPriorityInGroups.entrySet()) {
            Long groupId = (Long)groupEntry.getKey();
            Map minQuantityByPriority = (Map)groupEntry.getValue();
            BigDecimal finalQuantity = minQuantityByPriority.values().stream().reduce(BigDecimal.ZERO, BigDecimal::add);
            groupFinalQuantities.put(groupId, finalQuantity);
        }
        pickQty = max ? groupFinalQuantities.values().stream().max(BigDecimal::compareTo).orElse(BigDecimal.ZERO) : groupFinalQuantities.values().stream().min(BigDecimal::compareTo).orElse(BigDecimal.ZERO);
        return pickQty;
    }

    private static BigDecimal calPickQtyByEntry(String controlscope, Map<String, Object> stockentry, BigDecimal qty, Map<String, String> stockUnit) {
        BigDecimal pickQty = BigDecimal.ZERO;
        BigDecimal actissueqty = stockentry.get("actissueqty") == null ? BigDecimal.ZERO : (BigDecimal)stockentry.get("actissueqty");
        BigDecimal rejectedqty = stockentry.get("rejectedqty") == null ? BigDecimal.ZERO : (BigDecimal)stockentry.get("rejectedqty");
        BigDecimal feedingqty = stockentry.get("feedingqty") == null ? BigDecimal.ZERO : (BigDecimal)stockentry.get("feedingqty");
        BigDecimal scrapqty = stockentry.get("scrapqty") == null ? BigDecimal.ZERO : (BigDecimal)stockentry.get("scrapqty");
        BigDecimal demandqty = stockentry.get("demandqty") == null ? BigDecimal.ZERO : (BigDecimal)stockentry.get("demandqty");
        BigDecimal fixscrap = stockentry.get("fixscrap") == null ? BigDecimal.ZERO : (BigDecimal)stockentry.get("fixscrap");
        BigDecimal useratio = stockentry.get("useratio") == null ? BigDecimal.ZERO : ((BigDecimal)stockentry.get("useratio")).divide(new BigDecimal("100.0"), 4, 4);
        String unitId = (String)stockentry.get("materialunitid");
        String qtytype = (String)stockentry.get("qtytype");
        BigDecimal helpqty = actissueqty.add(feedingqty).subtract(rejectedqty).subtract(scrapqty);
        if ("B".equals(qtytype)) {
            if (helpqty.compareTo(demandqty) >= 0) {
                pickQty = qty.multiply(useratio);
            }
        } else {
            String precisionaccount;
            int precision;
            try {
                String[] split = stockUnit.get(unitId).split("@@");
                precision = Integer.parseInt(split[0]);
                precisionaccount = split[1];
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, new ErrorCode("unitcal", "stock materialunitid not exist"), new Object[0]);
            }
            int deal = 4;
            switch (precisionaccount) {
                case "2": {
                    deal = 1;
                    break;
                }
                case "3": {
                    deal = 0;
                    break;
                }
                default: {
                    deal = 4;
                }
            }
            if (demandqty.compareTo(fixscrap) != 0) {
                pickQty = helpqty.multiply(qty).multiply(useratio).divide(demandqty.subtract(fixscrap), precision, deal);
            }
        }
        return pickQty;
    }

    private static boolean isPickPairValid(String controlscope, Map<String, Object> stockEntry) {
        BigDecimal demandqty;
        boolean valid = true;
        String isbackflush = (String)stockEntry.get("isbackflush");
        boolean iskeypart = (Boolean)stockEntry.get("iskeypart");
        String issuemode = (String)stockEntry.get("issuemode");
        BigDecimal bigDecimal = demandqty = stockEntry.get("demandqty") == null ? BigDecimal.ZERO : (BigDecimal)stockEntry.get("demandqty");
        if ("C".equals(issuemode)) {
            valid = false;
        }
        if (demandqty.compareTo(BigDecimal.ZERO) == 0) {
            valid = false;
        }
        if ("A".equals(controlscope) && "B".equals(isbackflush)) {
            valid = false;
        }
        if ("B".equals(controlscope) && !iskeypart) {
            valid = false;
        }
        return valid;
    }

    private static boolean isCompletePairValid(Map<String, Object> stockEntry) {
        BigDecimal demandqty;
        boolean valid = true;
        String qtytype = (String)stockEntry.get("qtytype");
        String isbackflush = (String)stockEntry.get("isbackflush");
        String issuemode = (String)stockEntry.get("issuemode");
        BigDecimal bigDecimal = demandqty = stockEntry.get("demandqty") == null ? BigDecimal.ZERO : (BigDecimal)stockEntry.get("demandqty");
        if ("C".equals(issuemode)) {
            valid = false;
        }
        if ("B".equals(qtytype)) {
            valid = false;
        }
        if (demandqty.compareTo(BigDecimal.ZERO) == 0) {
            valid = false;
        }
        if (!"A".equals(isbackflush)) {
            valid = false;
        }
        return valid;
    }

    private static Map<String, List<Map<String, Object>>> getStockMap(QFilter filter) {
        HashMap<String, List<Map<String, Object>>> stockMap = new HashMap<String, List<Map<String, Object>>>();
        try (DataSet stockData = QueryServiceHelper.queryDataSet((String)"query_stockdata", (String)"pom_mftstock", (String)CalPickMaterialUtils.selectStockProperties(), (QFilter[])new QFilter[]{filter}, (String)" orderno,orderentryid");){
            for (Row row : stockData) {
                Map<String, Object> rowMap;
                List<Map<String, Object>> rowList;
                String billnoKey = row.getString("orderno");
                String stockMapkey = billnoKey + "@" + row.get("orderentryid");
                if (stockMap.containsKey(stockMapkey)) {
                    rowList = (List)stockMap.get(stockMapkey);
                    rowMap = CalPickMaterialUtils.getrowMap(row);
                    rowList.add(rowMap);
                    continue;
                }
                rowList = new ArrayList();
                rowMap = CalPickMaterialUtils.getrowMap(row);
                rowList.add(rowMap);
                stockMap.put(stockMapkey, rowList);
            }
        }
        return stockMap;
    }

    private static String selectStockProperties() {
        StringBuilder selector = new StringBuilder();
        selector.append("id");
        selector.append(",orderid");
        selector.append(",orderno");
        selector.append(",orderentryid");
        selector.append(",stockentry.qtytype");
        selector.append(",stockentry.wipqty");
        selector.append(",stockentry.id");
        selector.append(",stockentry.actissueqty");
        selector.append(",stockentry.feedingqty");
        selector.append(",stockentry.rejectedqty");
        selector.append(",stockentry.scrapqty");
        selector.append(",stockentry.demandqty");
        selector.append(",stockentry.standqty");
        selector.append(",stockentry.fixscrap");
        selector.append(",stockentry.unissueqty");
        selector.append(",stockentry.isbackflush");
        selector.append(",stockentry.iskeypart");
        selector.append(",stockentry.issuemode");
        selector.append(",stockentry.materialunitid");
        selector.append(",stockentry.useratio");
        selector.append(",stockentry.priority");
        selector.append(",stockentry.replacegroupid");
        selector.append(",stockentry.replaceplan");
        selector.append(",transactiontypeid");
        selector.append(",transactiontypeid.isconsiderloss");
        return selector.toString();
    }

    private static Map<String, Object> getrowMap(Row row) {
        HashMap<String, Object> rowMap = new HashMap<String, Object>(24);
        rowMap.put("actissueqty", row.getBigDecimal("stockentry.actissueqty"));
        rowMap.put("feedingqty", row.getBigDecimal("stockentry.feedingqty"));
        rowMap.put("rejectedqty", row.getBigDecimal("stockentry.rejectedqty"));
        rowMap.put("scrapqty", row.getBigDecimal("stockentry.scrapqty"));
        rowMap.put("demandqty", row.getBigDecimal("stockentry.demandqty"));
        rowMap.put("fixscrap", row.getBigDecimal("stockentry.fixscrap"));
        rowMap.put("qtytype", row.getString("stockentry.qtytype"));
        rowMap.put("isbackflush", row.getString("stockentry.isbackflush"));
        rowMap.put("issuemode", row.getString("stockentry.issuemode"));
        rowMap.put("iskeypart", row.getBoolean("stockentry.iskeypart"));
        rowMap.put("standqty", row.getBigDecimal("stockentry.standqty"));
        rowMap.put("materialunitid", row.getString("stockentry.materialunitid"));
        rowMap.put("useratio", row.getBigDecimal("stockentry.useratio"));
        rowMap.put("replacegroupid", row.getLong("stockentry.replacegroupid"));
        rowMap.put("priority", row.getLong("stockentry.priority"));
        rowMap.put("replaceplanId", row.getLong("stockentry.replaceplan"));
        rowMap.put("stockEntryId", row.getLong("stockentry.id"));
        return rowMap;
    }

    private static Map<String, String> getStockUnit(Map<String, List<Map<String, Object>>> stockMap) {
        HashSet<String> basunitList = new HashSet<String>(20);
        if (stockMap != null && CollectionUtils.isNotEmpty(stockMap.values())) {
            stockMap.values().forEach(stocks -> stocks.forEach(entry -> basunitList.add((String)entry.get("materialunitid"))));
        }
        return CalPickMaterialUtils.getMeasureunitData(basunitList);
    }

    private static String getControlScope(DynamicObject manuBill, Map<String, DynamicObject> transactiontypeMap) {
        DynamicObject transactiontype = manuBill.getDynamicObject("transactiontype");
        DynamicObject transtype = transactiontypeMap.get(transactiontype.getPkValue().toString());
        if (transtype != null) {
            return transtype.getString("controlscope");
        }
        return null;
    }

    private static Map<String, String> getMeasureunitData(Set<String> unitList) {
        HashMap<String, String> map = new HashMap<String, String>();
        int index = 0;
        StringBuilder msb = new StringBuilder();
        for (String unitId : unitList) {
            if (++index == unitList.size()) {
                msb.append(unitId);
                continue;
            }
            msb.append(unitId);
            msb.append(",");
        }
        String queryMainSql = "select fid,fprecision,fprecisiontype from T_bd_Measureunit where  fid in (" + msb + ") ";
        try (DataSet queryMainData = DB.queryDataSet((String)"queryMeasureunitData", (DBRoute)DBRoute.base, (String)queryMainSql);){
            for (Row row : queryMainData) {
                String fid = row.getString("fid");
                String precision = row.getString("fprecision");
                String precisiontype = row.getString("fprecisiontype");
                map.put(fid, precision + "@@" + precisiontype);
            }
        }
        return map;
    }
}

