/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.mftorder.utils;

import com.alibaba.fastjson.JSON;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.calendar.CalendarHelper;
import kd.bd.mpdm.common.utils.DateUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import org.apache.commons.collections4.CollectionUtils;

public class CalendarUtils {
    private static final Log logger = LogFactory.getLog(CalendarUtils.class);
    public static final String KEY_MFTDEFAULT = "fmm_defaultorg";
    public static final String KEY_CREATEORG = "createorg";
    public static final String KEY_ENABLE = "enable";
    public static final String KEY_STATUS = "status";
    private static final String KEY_CALENDARID = "calendar";
    public static final String KEY_CALENDAR = "mpdm_calendar";
    public static final String KEY_DEFAULTORG = "fmm_defaultorg";
    private static final ThreadLocal<Map<String, String>> queryThreadLocal = new ThreadLocal();
    private static final ThreadLocal<Map<String, Map<String, String>>> calendarInfoThreadLocal = new ThreadLocal();
    public static final int MAX_WORKDATE_ADD = 10;
    private static final ThreadLocal<Map<String, Map<String, Object>>> calendarDateThreadLocal = new ThreadLocal();

    private CalendarUtils() {
    }

    public static boolean isExistsCalendar(DynamicObject dept) {
        if (dept == null) {
            return false;
        }
        QFilter[] qfilters = new QFilter[]{new QFilter(KEY_CREATEORG, "=", dept.getPkValue()), new QFilter(KEY_ENABLE, "=", (Object)"1"), new QFilter(KEY_STATUS, "=", (Object)"C")};
        DynamicObjectCollection colByOrg = QueryServiceHelper.query((String)"fmm_defaultorg", (String)KEY_CALENDARID, (QFilter[])qfilters);
        return !colByOrg.isEmpty();
    }

    public static Date getRecentleWorkDate(String id, Date date) {
        Map<String, Map<String, String>> calendarInfoMap = calendarInfoThreadLocal.get();
        if (calendarInfoMap == null) {
            calendarInfoMap = new HashMap<String, Map<String, String>>();
            calendarInfoThreadLocal.set(calendarInfoMap);
        }
        int years = DateUtils.getYear(date);
        String keys = id + "_" + years;
        Map<String, String> map = calendarInfoMap.get(keys);
        if (map == null) {
            map = CalendarUtils.queryCacheWorkDate(id, date);
            calendarInfoMap.put(keys, map);
        }
        return CalendarUtils.getRecentleWorkDate(map, date);
    }

    public static Date getRecentleWorkDate(DynamicObject org, Date date, String oprNo) {
        String calendarId = CalendarUtils.getCalendarId(org);
        if (calendarId == null || "".equals(calendarId)) {
            return date;
        }
        return CalendarUtils.getRecentleWorkDate(calendarId, date);
    }

    public static Date getRecentleWorkDate(Map map, Date date) {
        if (map == null || map.isEmpty()) {
            return date;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        if (map.get(sdf.format(date)) == null) {
            return null;
        }
        if ("1".equals(map.get(sdf.format(date)))) {
            return date;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, 1);
        return CalendarUtils.getRecentleWorkDate(map, c.getTime());
    }

    public static Date getRecentleWorkDate(DynamicObject org, Date date) {
        return CalendarUtils.getRecentleWorkDateNew(org, date, new HashMap<String, Date>());
    }

    public static Date getRecentleWorkDateNew(DynamicObject org, Date date, Map<String, Date> calendarInfoMap) {
        Date recentleWorkDate = date;
        if (null == org || null == date || null == calendarInfoMap) {
            return recentleWorkDate;
        }
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        String dateStr = sf.format(date);
        Long orgId = org.getLong("id");
        String key = "orgid:" + orgId + "-date:" + dateStr;
        Date dateInMap = calendarInfoMap.get(key);
        if (null != dateInMap) {
            recentleWorkDate = dateInMap;
        } else {
            try {
                logger.info("kd.bd.mpdm.common.mftorder.utils.CalendarUtils.getRecentleWorkDate orgId:" + orgId + ";date:" + date);
                recentleWorkDate = CalendarHelper.getProductFirstWorkDateByOrgId(orgId, date, true);
                logger.info("kd.bd.mpdm.common.mftorder.utils.CalendarUtils.getRecentleWorkDate recentleWorkDate:" + recentleWorkDate);
            }
            catch (Exception e) {
                logger.info("kd.bd.mpdm.common.mftorder.utils.CalendarUtils.getRecentleWorkDate error:" + e.getMessage());
            }
            calendarInfoMap.put(key, recentleWorkDate);
        }
        return recentleWorkDate;
    }

    public static Date getToWorkDateToDate(int toDays, Date startDate, Long orgId) {
        Date result = null;
        try {
            logger.info("kd.bd.mpdm.common.mftorder.utils.CalendarUtils.getToWorkDateToDate orgId:" + orgId + ";startDate:" + startDate + ";toDays:" + toDays);
            result = CalendarHelper.getProductRecentlyWorkDateByOrgId(orgId, startDate, toDays);
            logger.info("kd.bd.mpdm.common.mftorder.utils.CalendarUtils.getToWorkDateToDate result:" + result);
        }
        catch (Exception e) {
            logger.info("kd.bd.mpdm.common.mftorder.utils.CalendarUtils.getToWorkDateToDate error:" + e.getMessage());
        }
        return result;
    }

    public static boolean compateDateAccurateDay(Date date, Date compareDate) {
        boolean result = false;
        if (null == date || null == compareDate) {
            return result;
        }
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        if (sf.format(date).equals(sf.format(compareDate))) {
            result = true;
        }
        return result;
    }

    public static Date getRecentleWorkDate(Object orgId, Date date) {
        String calendarId = CalendarUtils.getCalendarId(orgId);
        if (calendarId.isEmpty() || "0".equals(calendarId)) {
            return date;
        }
        return CalendarUtils.getRecentleWorkDate(calendarId, date);
    }

    public static String getCalendarId(Object orgId) {
        if (orgId == null) {
            return "";
        }
        QFilter[] qfilters = new QFilter[]{new QFilter(KEY_CREATEORG, "=", orgId), new QFilter(KEY_ENABLE, "=", (Object)"1"), new QFilter(KEY_STATUS, "=", (Object)"C")};
        DynamicObject calendarInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"fmm_defaultorg", (String)KEY_CALENDARID, (QFilter[])qfilters);
        if (calendarInfo != null && calendarInfo.getDynamicObject(KEY_CALENDARID) != null) {
            return calendarInfo.getDynamicObject(KEY_CALENDARID).getPkValue().toString();
        }
        return "";
    }

    public static String getCalendarId(DynamicObject dept) {
        String calendarId;
        if (dept == null) {
            return "";
        }
        Map<String, String> map = queryThreadLocal.get();
        if (map == null) {
            map = new HashMap<String, String>();
            queryThreadLocal.set(map);
        }
        if ((calendarId = map.get(dept.getPkValue().toString())) != null && !"".equals(calendarId) && !"0".equals(calendarId)) {
            return calendarId;
        }
        QFilter[] qfilters = new QFilter[]{new QFilter(KEY_CREATEORG, "=", dept.getPkValue()), new QFilter(KEY_ENABLE, "=", (Object)"1"), new QFilter(KEY_STATUS, "=", (Object)"C")};
        DynamicObject calendarInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"fmm_defaultorg", (String)KEY_CALENDARID, (QFilter[])qfilters);
        if (calendarInfo != null && calendarInfo.getDynamicObject(KEY_CALENDARID) != null) {
            map.put(dept.getPkValue().toString(), calendarInfo.getDynamicObject(KEY_CALENDARID).getPkValue().toString());
            return calendarInfo.getDynamicObject(KEY_CALENDARID).getPkValue().toString();
        }
        return "";
    }

    public static Map<Object, DynamicObject> getCalendarByOrgIds(Set<Object> orgIds) {
        HashMap<Object, DynamicObject> result = new HashMap<Object, DynamicObject>();
        if (CollectionUtils.isEmpty(orgIds)) {
            return result;
        }
        QFilter[] qfilters = new QFilter[]{new QFilter(KEY_CREATEORG, "in", orgIds), new QFilter(KEY_ENABLE, "=", (Object)"1"), new QFilter(KEY_STATUS, "=", (Object)"C")};
        Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"fmm_defaultorg", (String)"createorg,calendar", (QFilter[])qfilters);
        objectDynamicObjectMap.forEach((k, v) -> result.put(v.getDynamicObject(KEY_CREATEORG).getPkValue(), (DynamicObject)v));
        return result;
    }

    private static Map<String, String> queryCacheWorkDate(String id, Date queryDate) {
        Map maps;
        String keys;
        if (queryDate == null) {
            return null;
        }
        int years = DateUtils.getYear(queryDate);
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("mmc-mpdm-common");
        String cacheStr = (String)cache.get(keys = id + "_" + years);
        if (StringUtils.isEmpty((String)cacheStr)) {
            maps = CalendarUtils.queryWorkDateFromDB(id, years);
            cacheStr = maps != null && !maps.isEmpty() ? JSON.toJSONString((Object)maps) : "[]";
            cache.put(keys, (Object)cacheStr, 600);
        } else {
            if ("[]".equals(cacheStr)) {
                return Collections.emptyMap();
            }
            maps = (Map)JSON.parseObject((String)cacheStr, Map.class);
        }
        return maps;
    }

    private static Map<String, String> queryWorkDateFromDB(String id, int years) {
        Date minDate = DateUtils.getYearFirstDate(years);
        Date maxDate = DateUtils.getYearLastDate(years);
        maxDate = DateUtils.addDay(maxDate, 10);
        String selectFileds = "dateentry.workdate workdate ,dateentry.datetype datetype,issunrest,ismonrest,istuerest,iswedrest,isthurest,isfrirest,issatrest";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        HashMap<String, String> dateCalendarMap = new HashMap<String, String>(396);
        QFilter qFilter1 = new QFilter("id", "=", (Object)Long.valueOf(id));
        QFilter qFilter2 = new QFilter("dateentry.workdate", ">=", (Object)minDate);
        QFilter qFilter3 = new QFilter("dateentry.workdate", "<=", (Object)maxDate);
        QFilter qFilter = qFilter1.and(qFilter2).and(qFilter3);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-CalendarUtils-queryDates", (String)KEY_CALENDAR, (String)selectFileds, (QFilter[])new QFilter[]{qFilter}, (String)"dateentry.workdate");){
            boolean isfirest = true;
            while (ds.hasNext()) {
                Row arow = ds.next();
                if (isfirest) {
                    isfirest = false;
                    if (CalendarUtils.isAllWorkDay(arow)) {
                        Map<String, String> map = Collections.emptyMap();
                        return map;
                    }
                }
                dateCalendarMap.put(sdf.format(arow.getDate("workdate")), arow.getString("datetype"));
            }
        }
        return dateCalendarMap;
    }

    private static boolean isAllWorkDay(Row arow) {
        if (!(arow.getBoolean("issunrest").booleanValue() || arow.getBoolean("ismonrest").booleanValue() || arow.getBoolean("istuerest").booleanValue() || arow.getBoolean("iswedrest").booleanValue() || arow.getBoolean("isthurest").booleanValue() || arow.getBoolean("isfrirest").booleanValue() || arow.getBoolean("issatrest").booleanValue())) {
            return true;
        }
        return arow.getBoolean("issunrest") != false && arow.getBoolean("ismonrest") != false && arow.getBoolean("istuerest") != false && arow.getBoolean("iswedrest") != false && arow.getBoolean("isthurest") != false && arow.getBoolean("isfrirest") != false && arow.getBoolean("issatrest") != false;
    }
}

