/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.mftorder.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.mftorderbom.utils.BomBaseData;
import kd.bd.mpdm.common.query.helper.MaterialMftQueryHelper;
import kd.bd.mpdm.common.query.helper.MaterialQueryHelper;
import kd.bd.mpdm.common.query.helper.OrgQueryHelper;
import kd.bd.mpdm.common.query.helper.TransactionTypeQueryHelper;
import kd.bd.mpdm.common.query.mservice.helper.MsBomQueryHelper;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.mmc.business.query.helper.MmcCommonHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import org.apache.commons.collections.CollectionUtils;

public class ConfigBomToStockUtils {
    public static final String MATERIAL_CONFIGPROPERTIES = "configproperties";
    public static final String INTERFACE_MODEL = "model_pom";
    public static final String SUPERBOMEXPANDTYPE = "superbom";
    public static final String BOMTYPE_CHAR = "_bomtype";
    private static final Log logger = LogFactory.getLog(ConfigBomToStockUtils.class);
    private static final ThreadLocal<Map<String, Object>> queryThreadLocal = new ThreadLocal();

    public static boolean isConfigBomInterface(DynamicObject transactionType, DynamicObject orderEntry) {
        Map<String, Object> map = queryThreadLocal.get();
        if (map == null) {
            map = new HashMap<String, Object>();
            queryThreadLocal.set(map);
        }
        boolean chkSuperBom = false;
        String keyQueryString = "transactionTypeChkSuperBom_" + transactionType.getPkValue();
        if (map.containsKey(keyQueryString)) {
            chkSuperBom = (Boolean)map.get(keyQueryString);
        } else {
            chkSuperBom = ConfigBomToStockUtils.transactionTypeChkSuperBom(transactionType);
            map.put(keyQueryString, chkSuperBom);
        }
        if (!chkSuperBom) {
            return false;
        }
        DynamicObject configcode = ConfigBomToStockUtils.getOrderConfigCode(orderEntry);
        DynamicObject material = ConfigBomToStockUtils.getOrderMaterial(orderEntry);
        return ConfigBomToStockUtils.chkUsedConfigBomInterface(material, configcode);
    }

    public static boolean transactionTypeChkSuperBom(DynamicObject transactionType) {
        if (transactionType != null) {
            DynamicObjectCollection bomtypes;
            if (!transactionType.containsProperty("bomtypes")) {
                transactionType = ConfigBomToStockUtils.isWWTransactionType(transactionType) ? BusinessDataServiceHelper.loadSingleFromCache((Object)transactionType.getPkValue(), (String)transactionType.getDataEntityType().getName()) : TransactionTypeQueryHelper.getDataCacheByID(transactionType.getPkValue());
            }
            if (CollectionUtils.isNotEmpty((Collection)(bomtypes = transactionType.getDynamicObjectCollection("bomtypes")))) {
                ArrayList<Object> pkValues = new ArrayList<Object>(bomtypes.size());
                for (DynamicObject dyn : bomtypes) {
                    pkValues.add(dyn.get("fbasedataid_id"));
                }
                if (ConfigBomToStockUtils.containSuperBomType(pkValues)) {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isWWTransactionType(DynamicObject transactionType) {
        return "mpdm_transactout".equalsIgnoreCase(transactionType.getDataEntityType().getName());
    }

    public static boolean chkIsSuperBomType(DynamicObject bom) {
        if (bom == null) {
            return false;
        }
        DynamicObject bomType = bom.getDynamicObject("type");
        if (bomType == null) {
            bomType = MsBomQueryHelper.getDataCacheByID(bom.getPkValue()).getDynamicObject("type");
        }
        if (!bomType.containsProperty("purpose")) {
            bomType = BusinessDataServiceHelper.loadSingleFromCache((Object)bomType.getPkValue(), (String)"mpdm_bomtype", (String)"purpose");
        }
        return bomType.getString("purpose").equals("B");
    }

    public static boolean containSuperBomType(List<Object> bomTypeIDList) {
        QFilter qfilter = new QFilter("id", "in", bomTypeIDList);
        qfilter.and(new QFilter("purpose", "=", (Object)"B"));
        Map bomMap = BusinessDataServiceHelper.loadFromCache((String)"mpdm_bomtype", (String)"id", (QFilter[])new QFilter[]{qfilter});
        return bomMap != null && !bomMap.isEmpty();
    }

    public static boolean chkUsedConfigBomInterface(DynamicObject productMaterial, DynamicObject configCode) {
        return productMaterial != null && configCode != null && ConfigBomToStockUtils.materialIsConfig(productMaterial);
    }

    public static boolean materialIsConfig(DynamicObject productMaterial) {
        if (!productMaterial.containsProperty(MATERIAL_CONFIGPROPERTIES)) {
            productMaterial = MaterialQueryHelper.getDataCacheByID(productMaterial.getPkValue());
        }
        return "2".equals(productMaterial.get(MATERIAL_CONFIGPROPERTIES));
    }

    public static JSONObject getJsonObjectParam(Date searchTime, boolean isNeedProRoute, Long configCodeId, BigDecimal num, Long routId, String modelStr, Long masterid, Long orgId) {
        JSONObject configedCodeObject = new JSONObject();
        configedCodeObject.put(String.valueOf(configCodeId), (Object)String.valueOf(routId));
        JSONObject paramObject = new JSONObject();
        paramObject.put("org", (Object)orgId);
        paramObject.put("searchTime", (Object)searchTime);
        paramObject.put("isNeedProRoute", (Object)isNeedProRoute);
        paramObject.put("configCodeList", (Object)configedCodeObject);
        paramObject.put("model", (Object)modelStr);
        paramObject.put("matId", (Object)masterid);
        paramObject.put("bomVer", null);
        paramObject.put("num", (Object)num);
        paramObject.put("purchaseExpand", (Object)false);
        return paramObject;
    }

    public static DynamicObject getOrderConfigCode(DynamicObject orderEntry) {
        return orderEntry.getDynamicObject("configuredcode");
    }

    public static DynamicObject getOrderMaterial(DynamicObject orderEntry) {
        DynamicObject order = (DynamicObject)orderEntry.getParent();
        String orderName = order.getDataEntityType().getName();
        DynamicObject material = null;
        if ("pm_om_purorderbill".equals(orderName)) {
            material = orderEntry.getDynamicObject("materialmasterid");
        } else if ("pom_mftorder".equals(orderName) || "om_mftorder".equals(orderName)) {
            material = orderEntry.getDynamicObject("materielmasterid");
        }
        return material;
    }

    public static Date getOrderBomExpandTime(DynamicObject orderEntry) {
        return orderEntry.getDate("expendbomtime");
    }

    public static BigDecimal getOrderQty(DynamicObject orderEntry) {
        return orderEntry.getBigDecimal("qty");
    }

    public static Long getRouteId(DynamicObject orderEntry) {
        Object processroute;
        Long routeId = 0L;
        if (orderEntry.containsProperty("processroute") && (processroute = orderEntry.get("processroute")) instanceof DynamicObject) {
            routeId = (Long)((DynamicObject)processroute).getPkValue();
        }
        return routeId;
    }

    public static String getConfigBomFilterStrByOrderEntry(DynamicObject orderEntry, boolean isNeedProRoute, DynamicObject order) {
        DynamicObject configedCode = ConfigBomToStockUtils.getOrderConfigCode(orderEntry);
        if (configedCode == null) {
            return "";
        }
        Long orgId = (Long)order.getDynamicObject("org").getPkValue();
        Date expandtime = ConfigBomToStockUtils.getOrderBomExpandTime(orderEntry);
        BigDecimal qty = ConfigBomToStockUtils.getOrderQty(orderEntry);
        Long routId = ConfigBomToStockUtils.getRouteId(orderEntry);
        DynamicObject masterid = ConfigBomToStockUtils.getOrderMaterial(orderEntry);
        Long mid = 0L;
        if (masterid != null) {
            mid = (Long)masterid.getPkValue();
        }
        return ConfigBomToStockUtils.getConfigBomFilterStr(expandtime, configedCode.getLong("id"), qty, isNeedProRoute, routId, INTERFACE_MODEL, mid, orgId);
    }

    public static String getConfigBomFilterStr(Date expandtime, Long configedCodeId, BigDecimal qty, boolean isNeedProRoute, Long routId, String modelStr, Long masterid, Long orgId) {
        boolean isBomExpandTime = MmcCommonHelper.IsBomExpandTime();
        if (!isBomExpandTime) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            return configedCodeId + "-" + qty + "-" + sdf.format(expandtime) + "-" + isNeedProRoute + "-" + routId + "-" + modelStr + "-" + masterid + "-" + orgId;
        }
        return configedCodeId + "-" + qty + "-" + expandtime.getTime() + "-" + isNeedProRoute + "-" + routId + "-" + modelStr + "-" + masterid + "-" + orgId;
    }

    public static JSONObject expandConfigBom(Date searchTime, boolean isNeedProRoute, Long configCodeId, BigDecimal num, Long routId, String modelStr, Long masterid, Long orgId) {
        JSONObject paramObject = ConfigBomToStockUtils.getJsonObjectParam(searchTime, isNeedProRoute, configCodeId, num, routId, modelStr, masterid, orgId);
        JSONObject returnJsonObject = (JSONObject)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pdm", (String)"proConfigListQueryService", (String)"getConfigBomForWorkOrder", (Object[])new Object[]{paramObject.toString()});
        return returnJsonObject;
    }

    public static boolean isSuperBomExpand(DynamicObject orderEntry, Map<String, String> bomResultCacheMap, DynamicObject order) {
        String resStr = ConfigBomToStockUtils.getConfigBomFilterStrByOrderEntry(orderEntry, false, order);
        if (resStr == null || "".equals(resStr)) {
            return false;
        }
        String bomType = bomResultCacheMap.get(resStr + BOMTYPE_CHAR);
        return bomType != null && SUPERBOMEXPANDTYPE.equalsIgnoreCase(bomType);
    }

    public static JSONObject getExpandConfigBom(Date searchTime, boolean isNeedProRoute, Long configCodeId, BigDecimal qty, Long routedId, Map<String, String> bomResultCacheMap, String modelStr, Long masterid, Long orgId) {
        long startdate = System.currentTimeMillis();
        String resStr = ConfigBomToStockUtils.getConfigBomFilterStr(searchTime, configCodeId, qty, isNeedProRoute, routedId, modelStr, masterid, orgId);
        if (bomResultCacheMap == null) {
            bomResultCacheMap = new HashMap<String, String>(16);
        }
        bomResultCacheMap.put(resStr + BOMTYPE_CHAR, SUPERBOMEXPANDTYPE);
        String cacheValue = bomResultCacheMap.get(resStr);
        if (!StringUtils.isEmpty((String)cacheValue)) {
            long enddate = System.currentTimeMillis() - startdate;
            logger.info("mmc-getExpandConfigBom.....cost:" + enddate + "ms,from bomResultCacheMap");
            return JSONObject.parseObject((String)cacheValue);
        }
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("mmc-fmm-bomsearch");
        cacheValue = (String)cache.get(resStr);
        if (!StringUtils.isEmpty((String)cacheValue)) {
            bomResultCacheMap.put(resStr, cacheValue);
            long enddate = System.currentTimeMillis() - startdate;
            logger.info("mmc-getExpandConfigBom.....cost:" + enddate + "ms,from DistributeSessionlessCache");
            return JSONObject.parseObject((String)cacheValue);
        }
        JSONObject returnObject = ConfigBomToStockUtils.expandConfigBom(searchTime, isNeedProRoute, configCodeId, qty, routedId, modelStr, masterid, orgId);
        if (!"success".equalsIgnoreCase(returnObject.getString("status"))) {
            String errorInfo = returnObject.getString("msg");
            logger.info("-------------configBomExpad error:" + errorInfo + ",configCodeId=" + configCodeId);
            throw new KDBizException(new ErrorCode("configbomexpanderror", errorInfo), new Object[0]);
        }
        long enddate = System.currentTimeMillis() - startdate;
        logger.info("mmc-getExpandConfigBom.....cost:" + enddate + "ms,from mservice");
        JSONObject data = returnObject.getJSONObject("data").getJSONObject(String.valueOf(configCodeId));
        if ("failed".equalsIgnoreCase(data.getString("status"))) {
            String errorInfo = data.getString("errorMsg");
            logger.info("-------------configBomExpad errorInfo:" + errorInfo + ",configCodeId=" + configCodeId);
            logger.info("-------------configBomExpad stackTrace:" + data.getString("StackTrace"));
            throw new KDBizException(new ErrorCode("configbomexpanderror", errorInfo), new Object[0]);
        }
        bomResultCacheMap.put(resStr, data.toJSONString());
        cache.put(resStr, (Object)data.toJSONString(), 600);
        return data;
    }

    public static void initBomExpandResult(DynamicObject orderEntry, Map<String, String> bomResultCacheMap, DynamicObject order) {
        Long orgId = (Long)order.getDynamicObject("org").getPkValue();
        DynamicObject configedCode = ConfigBomToStockUtils.getOrderConfigCode(orderEntry);
        BigDecimal num = ConfigBomToStockUtils.getOrderQty(orderEntry);
        Long routedId = ConfigBomToStockUtils.getRouteId(orderEntry);
        DynamicObject masterid = ConfigBomToStockUtils.getOrderMaterial(orderEntry);
        Date expandBomTime = ConfigBomToStockUtils.getOrderBomExpandTime(orderEntry);
        Long mid = 0L;
        if (masterid != null) {
            mid = (Long)masterid.getPkValue();
        }
        Long configId = 0L;
        if (configedCode != null) {
            configId = configedCode.getLong("id");
        }
        ConfigBomToStockUtils.getExpandConfigBom(expandBomTime, false, configId, num, routedId, bomResultCacheMap, INTERFACE_MODEL, mid, orgId);
    }

    public static void setBbdList(String resStr, Set<Long> bomEntryIdSet, Map<Long, List<BomBaseData>> orderEntryBaseMap, Long orderEntryId, Map<String, String> bomResultCacheMap, boolean showJump, Long productOrgId) {
        String res = bomResultCacheMap.get(resStr);
        if (StringUtils.isEmpty((String)res)) {
            return;
        }
        ConfigBomToStockUtils.printlog(resStr, res);
        JSONObject resJsonObject = null;
        try {
            resJsonObject = JSONObject.parseObject((String)res);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            logger.info("setBbdList-JSONObject.parseObject is error,resStr=" + resStr + ",res=" + res);
            return;
        }
        JSONArray resArray = resJsonObject.getJSONArray("treeentryentity");
        ArrayList<BomBaseData> bbdList = new ArrayList<BomBaseData>(10);
        if (resArray != null) {
            int dataSize = resArray.size();
            HashSet<Long> materialMasterIdSet = new HashSet<Long>(16);
            for (int i = 0; i < dataSize; ++i) {
                JSONObject resJson = (JSONObject)resArray.get(i);
                if (resJson.getLong("pid").equals(0L)) continue;
                Long mftId = 0L;
                if (resJson.get((Object)"pmaterialmftifoid") != null) {
                    mftId = Long.parseLong(resJson.get((Object)"pmaterialmftifoid").toString());
                }
                if (mftId != null && !mftId.equals(0L)) continue;
                Long materialMasterId = Long.parseLong(resJson.get((Object)"pmaterial").toString());
                materialMasterIdSet.add(materialMasterId);
            }
            HashMap<Object, DynamicObject> mftCacheMap = new HashMap(16);
            if (!materialMasterIdSet.isEmpty()) {
                mftCacheMap = MaterialMftQueryHelper.getDataCacheByMaterialSet(materialMasterIdSet, productOrgId);
            }
            for (int i = 0; i < dataSize; ++i) {
                JSONObject resJson = (JSONObject)resArray.get(i);
                if (resJson.getLong("pid").equals(0L)) continue;
                BomBaseData bbd = ConfigBomToStockUtils.getBomBaseData(resJson, productOrgId);
                if (!showJump && bbd.getIsJump()) continue;
                bbd.setPMaterial(ConfigBomToStockUtils.getMaterialMftId(resJson, productOrgId, mftCacheMap));
                bbdList.add(bbd);
                bomEntryIdSet.add(resJson.getLong("superbomentryid"));
            }
            orderEntryBaseMap.put(orderEntryId, bbdList);
        }
    }

    public static BomBaseData getBomBaseData(JSONObject resJson, Long productOrgId) {
        BigDecimal workEntryQty;
        BigDecimal entryqty;
        BomBaseData bbd = new BomBaseData();
        bbd.setBomEntryId(resJson.getLong("superbomentryid"));
        bbd.setQtydenominator(resJson.get((Object)"entryqtydenominator"));
        bbd.setQtynumerator(resJson.get((Object)"entryqtynumerator"));
        bbd.setBomId(resJson.getLong("superbomid"));
        bbd.setQtytype(resJson.get((Object)"entryqtytype"));
        if (resJson.get((Object)"issolid") != null && "true".equals(resJson.get((Object)"issolid").toString())) {
            bbd.setQtytype("B");
        }
        bbd.setScraprate(resJson.get((Object)"entryscraprate"));
        bbd.setFixscrap(resJson.get((Object)"entryfixscrap"));
        if (resJson.get((Object)"entryisjumplevel") != null) {
            bbd.setIsJump((Boolean)resJson.get((Object)"entryisjumplevel"));
        }
        bbd.setConfigedCodeId(Long.parseLong(resJson.get((Object)"configcode").toString()));
        Long entryMaterialId = 0L;
        if (resJson.get((Object)"entrymaterial_id") != null) {
            entryMaterialId = Long.parseLong(resJson.get((Object)"entrymaterial_id").toString());
        }
        if (entryMaterialId == null || entryMaterialId.equals(0L)) {
            Long bomentryId = resJson.getLong("superbomentryid");
            QFilter qfilter = new QFilter("entry.id", "=", (Object)bomentryId);
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"pdm_mftbom", (String)"number,entry.seq seq", (QFilter[])new QFilter[]{qfilter});
            String bomnumber = ((DynamicObject)coll.get(0)).getString("number");
            String seq = ((DynamicObject)coll.get(0)).getString("seq");
            throw new KDBizException(new ErrorCode("getBomBaseData", String.format(ResManager.loadKDString((String)"BOM\u7f16\u7801\u201c%1$s\u201d\u4e0b\u5e8f\u53f7\u4e3a\u201c%2$s\u201d\u7684\u7ec4\u4ef6\u6570\u636e\uff0c\u65e0\u6cd5\u5339\u914d\u5230\u7279\u5f81\u7269\u6599\u4fe1\u606f\u3002(\u5bf9\u5e94\u7684BOM\u5206\u5f55ID=\u201c%3$s\u201d)", (String)"ConfigBomToStockUtils_02", (String)"bd-mpdm-common", (Object[])new Object[0]), bomnumber, seq, bomentryId)), new Object[0]);
        }
        bbd.setMaterilID(entryMaterialId);
        if (resJson.get((Object)"workcenter") != null) {
            bbd.setWorkCenterId(Long.parseLong(resJson.get((Object)"workcenter").toString()));
        }
        if (resJson.get((Object)"entryqty") != null && (entryqty = new BigDecimal(resJson.get((Object)"entryqty").toString())).compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal entryqtydenominator = (BigDecimal)resJson.get((Object)"entryqtydenominator");
            bbd.setQtynumerator(entryqty.multiply(entryqtydenominator));
        }
        if (resJson.get((Object)"workentryqty") != null && (workEntryQty = new BigDecimal(resJson.get((Object)"workentryqty").toString())).compareTo(BigDecimal.ZERO) != 0) {
            bbd.setQtynumerator(workEntryQty);
        }
        if (resJson.get((Object)"workstation") != null) {
            bbd.setWorkStationId(Long.parseLong(resJson.get((Object)"workstation").toString()));
        }
        return bbd;
    }

    private static void printlog(String resStr, String res) {
        int len = res.length();
        int maxlen = 10000;
        int times = len / maxlen;
        if (len % maxlen > 0) {
            ++times;
        }
        for (int i = 1; i <= times; ++i) {
            String resSub = String.valueOf(i);
            resSub = i < times ? resSub + " " + res.substring(maxlen * (i - 1), maxlen * i) : resSub + " " + res.substring(maxlen * (i - 1), len);
            logger.info("\u914d\u7f6eBOM\u5c55\u5f00\u540e\u7ed3\u679c resStr=" + resStr + ",res=:" + resSub);
        }
    }

    public static Long getMaterialMftId(JSONObject resJson, Long productOrgId, Map<Object, DynamicObject> mftCacheMap) {
        Long mftId = 0L;
        if (resJson.get((Object)"pmaterialmftifoid") != null) {
            mftId = Long.parseLong(resJson.get((Object)"pmaterialmftifoid").toString());
        }
        if (mftId == null || mftId.equals(0L)) {
            Long materialMasterId = Long.parseLong(resJson.get((Object)"pmaterial").toString());
            DynamicObject mft = null;
            if (mftCacheMap != null) {
                mft = mftCacheMap.get(materialMasterId);
            }
            if (mft == null) {
                mft = MaterialMftQueryHelper.getDataCacheByMaterialID(materialMasterId, productOrgId, null);
            }
            if (mft == null) {
                DynamicObject materialDy = MaterialQueryHelper.getDataCacheByID(materialMasterId);
                DynamicObject orgDy = OrgQueryHelper.getDataCacheByID(productOrgId);
                throw new KDBizException(new ErrorCode("valideMaterialMftInfo", String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u5728\u751f\u4ea7\u7ec4\u7ec7\u201c%2$s\u201d\u4e0b\u4e0d\u5b58\u5728\u7269\u6599\u751f\u4ea7\u4fe1\u606f\uff0c\u8bf7\u5148\u7ef4\u62a4\u597d\u57fa\u7840\u6570\u636e\u3002", (String)"ConfigBomToStockUtils_01", (String)"bd-mpdm-common", (Object[])new Object[0]), materialDy.getString("number"), orgDy.getString("number"))), new Object[0]);
            }
            mftId = mft.getLong("id");
        }
        return mftId;
    }
}

