/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.mftorder.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bd.mpdm.common.mftorder.entity.Promater;
import kd.bd.mpdm.common.mftorder.utils.CreateStockUtils;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bd.mpdm.common.mftorder.utils.OrderBaseData;
import kd.bd.mpdm.common.mftorderbom.utils.BomBaseData;
import kd.bd.mpdm.common.query.helper.MaterialMftQueryHelper;
import kd.bd.mpdm.common.query.helper.MaterialQueryHelper;
import kd.bd.mpdm.common.query.helper.TransactionTypeQueryHelper;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.mmc.business.query.helper.MmcCommonHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.math.NumberUtils;

public class CreateStockByBomUtils {
    private static final Log logger = LogFactory.getLog(CreateStockByBomUtils.class);

    private CreateStockByBomUtils() {
    }

    public static void expandBomStocks(List<DynamicObject> saveBomStocks, OrderBaseData baseData) {
        if (saveBomStocks.isEmpty()) {
            return;
        }
        JSONArray filterArrayNew = new JSONArray(16);
        HashMap<Long, String> orderEntryBomMap = new HashMap<Long, String>(16);
        Map<Long, List<BomBaseData>> orderEntryBaseMap = baseData.getOrderEntryBaseMap();
        HashSet<Long> bomEntryIdSet = new HashSet<Long>(16);
        HashMap<String, String> bomResultCacheMap = new HashMap<String, String>(saveBomStocks.size());
        CreateStockByBomUtils.setQueryData(filterArrayNew, orderEntryBomMap, baseData, saveBomStocks, bomResultCacheMap);
        if (filterArrayNew.size() > 0) {
            JSONArray result = JSON.parseArray((String)CreateStockByBomUtils.getQueryDataResMulType(filterArrayNew.toString()));
            JSONObject object = (JSONObject)result.get(0);
            if (result != null && StringUtils.equalsIgnoreCase((CharSequence)"false", (CharSequence)object.getString("success"))) {
                String errorInfo = object.getString("msg");
                logger.info("-------------BomExpad error:" + errorInfo);
                throw new KDBizException(new ErrorCode("bomexpanderror", errorInfo), new Object[0]);
            }
            if (result.toString().indexOf("true") >= 0) {
                CreateStockByBomUtils.addCacheToBomResultMap(saveBomStocks, orderEntryBomMap, bomResultCacheMap);
            }
        }
        if (!bomResultCacheMap.isEmpty()) {
            CreateStockByBomUtils.setResData(orderEntryBaseMap, bomEntryIdSet, baseData, saveBomStocks, orderEntryBomMap, bomResultCacheMap);
            baseData.setOrderEntryBaseMap(orderEntryBaseMap);
            CreateStockUtils.setBomEntryMapById(bomEntryIdSet, baseData);
            Map<Long, DynamicObject> bomEntryMap = baseData.getBomEntryMap();
            if (!bomEntryMap.isEmpty() && !saveBomStocks.isEmpty()) {
                ArrayList<DynamicObject> bomEntrys = new ArrayList<DynamicObject>(16);
                for (Map.Entry<Long, DynamicObject> entry : bomEntryMap.entrySet()) {
                    bomEntrys.add(entry.getValue());
                }
                HashSet<Long> ordIds = new HashSet<Long>(16);
                for (DynamicObject saveBomStock : saveBomStocks) {
                    DynamicObject org = saveBomStock.getDynamicObject("org");
                    if (org == null) continue;
                    Long orgId = (Long)org.getPkValue();
                    ordIds.add(orgId);
                }
                CreateStockByBomUtils.setBOMBaseData(bomEntrys, baseData, ordIds);
            }
            for (DynamicObject saveBomStock : saveBomStocks) {
                StringBuilder stringBuilder = new StringBuilder(200);
                Long orderEntryId = CreateStockByBomUtils.getOrderEntryIdByStock(saveBomStock);
                DynamicObject order = baseData.getOrderByEntryId(orderEntryId);
                DynamicObject orderEntry = baseData.getOrderEntry(orderEntryId);
                List<BomBaseData> bbdList = orderEntryBaseMap.get(orderEntryId);
                if (bbdList != null) {
                    StringBuilder materialName = new StringBuilder();
                    ArrayList<String> materialNameList = new ArrayList<String>(16);
                    DynamicObject transactproduct = CreateStockByBomUtils.getTransactionType(baseData, saveBomStock);
                    boolean showJump = CreateStockByBomUtils.isShowJump(transactproduct);
                    for (BomBaseData bbd : bbdList) {
                        String res;
                        Long bomEntryId = bbd.getBomEntryId();
                        DynamicObject bomEntry = bomEntryMap.get(bomEntryId);
                        if (!showJump && bbd.getIsJump() || bomEntry == null || "0".equals(res = CreateStockByBomUtils.createAndSetStockEntryValueByBom(order, orderEntry, saveBomStock, baseData, bomEntry, null, bbd)) || "1".equals(res)) continue;
                        materialNameList.add(res);
                    }
                    CreateStockByBomUtils.appendErrInfo(materialNameList, materialName);
                    if (materialName.length() > 0) {
                        CreateStockByBomUtils.appendErrInfoOrder(materialName, orderEntry, order, stringBuilder);
                    }
                }
                if ("".equals(stringBuilder.toString())) continue;
                CreateStockUtils.setErr(orderEntryId, baseData, stringBuilder.toString(), saveBomStock);
            }
        }
        CreateStockUtils.setStockWareHouse(saveBomStocks, baseData);
        CreateStockUtils.setIsStep(saveBomStocks);
        MPDMMftGenStocksUtils.updateRepPid(saveBomStocks);
        CreateStockByBomUtils.setPStockEntryId(saveBomStocks);
    }

    private static void addCacheToBomResultMap(List<DynamicObject> saveBomStocks, Map<Long, String> orderEntryBomMap, Map<String, String> bomResultMap) {
        for (DynamicObject saveBomStock : saveBomStocks) {
            Long orderEntryId = CreateStockByBomUtils.getOrderEntryIdByStock(saveBomStock);
            String resStr = orderEntryBomMap.get(orderEntryId);
            if (StringUtils.isEmpty((CharSequence)resStr)) continue;
            bomResultMap.put(resStr, CreateStockByBomUtils.getCacheValue(resStr));
        }
    }

    private static String getCacheValue(String resStr) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("mmc-fmm-bomsearch");
        return (String)cache.get(resStr);
    }

    public static String getQueryDataRes(String filterStr) {
        if (!"".equals(filterStr) && !"[]".equals(filterStr)) {
            Long startdate = System.currentTimeMillis();
            logger.info("\u8c03\u7528\u5fae\u670d\u52a1\uff08allLevelForwardSearch\uff09\u83b7\u53d6BOM\u6570\u636e\u5f00\u59cb,\u4f20\u5165\u53c2\u6570\uff1a" + filterStr);
            String bomResult = (String)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pdm", (String)"BOMSearchService", (String)"allLevelForwardSearch", (Object[])new Object[]{filterStr});
            Long enddate = System.currentTimeMillis() - startdate;
            logger.info("\u751f\u6210\u7ec4\u4ef6\u6e05\u5355\uff1a\u8c03\u7528\u5fae\u670d\u52a1\uff08allLevelForwardSearch\uff09\u83b7\u53d6BOM\u6570\u636e\u7ed3\u675f--------------cost:" + enddate + "ms");
            logger.info("\u8c03\u7528\u5fae\u670d\u52a1\uff08allLevelForwardSearch\uff09\u83b7\u53d6BOM result--------------:" + bomResult);
            return bomResult;
        }
        return "";
    }

    public static String getQueryDataResMulType(String filterStr) {
        if (!"".equals(filterStr) && !"[]".equals(filterStr)) {
            Long startdate = System.currentTimeMillis();
            boolean isInfo = logger.isInfoEnabled();
            if (isInfo) {
                logger.info("\u8c03\u7528\u5fae\u670d\u52a1\uff08bomExpandForMulType\uff09\u83b7\u53d6BOM\u6570\u636e\u5f00\u59cb,\u4f20\u5165\u53c2\u6570\uff1a" + filterStr);
            }
            String bomResult = (String)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pdm", (String)"BOMSearchService", (String)"bomExpandForMulType", (Object[])new Object[]{filterStr});
            if (isInfo) {
                Long enddate = System.currentTimeMillis() - startdate;
                logger.info("\u751f\u6210\u7ec4\u4ef6\u6e05\u5355\uff1a\u8c03\u7528\u5fae\u670d\u52a1\uff08bomExpandForMulType\uff09\u83b7\u53d6BOM\u6570\u636e\u7ed3\u675f--------------cost:" + enddate + "ms");
                logger.info("\u8c03\u7528\u5fae\u670d\u52a1\uff08bomExpandForMulType\uff09\u83b7\u53d6BOM result--------------:" + bomResult);
            }
            return bomResult;
        }
        return "";
    }

    private static void setResData(Map<Long, List<BomBaseData>> orderEntryBaseMap, Set<Long> bomEntryIdSet, OrderBaseData baseData, List<DynamicObject> saveBomStocks, Map<Long, String> orderEntryBomMap, Map<String, String> bomResultCacheMap) {
        for (DynamicObject saveBomStock : saveBomStocks) {
            Long orderEntryId = CreateStockByBomUtils.getOrderEntryIdByStock(saveBomStock);
            String resStr = orderEntryBomMap.get(orderEntryId);
            if (StringUtils.isEmpty((CharSequence)resStr)) continue;
            Long productOrgId = saveBomStock.getDynamicObject("org").getLong("id");
            CreateStockByBomUtils.setBbdList(resStr, bomEntryIdSet, orderEntryBaseMap, orderEntryId, bomResultCacheMap, productOrgId);
        }
    }

    private static void setBbdList(String resStr, Set<Long> bomEntryIdSet, Map<Long, List<BomBaseData>> orderEntryBaseMap, Long orderEntryId, Map<String, String> bomResultCacheMap, Long productOrgId) {
        String res = bomResultCacheMap.get(resStr);
        if (StringUtils.isEmpty((CharSequence)res)) {
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info("\u8c03\u7528\u5fae\u670d\u52a1\u83b7\u53d6BOM resStr = " + resStr + ",res--------------:" + res);
        }
        JSONArray resArray = JSONArray.parseArray((String)res);
        ArrayList<BomBaseData> bbdList = new ArrayList<BomBaseData>(10);
        if (resArray != null) {
            logger.info("\u8c03\u7528\u5fae\u670d\u52a1\u83b7\u53d6BOM resStr = " + resStr + ",res.size--------------:" + resArray.size());
            for (int i = 0; i < resArray.size(); ++i) {
                JSONObject resJson = (JSONObject)resArray.get(i);
                resJson.put("productOrgId", (Object)productOrgId);
                bbdList.add(CreateStockByBomUtils.getBomBaseData(resJson));
                bomEntryIdSet.add(resJson.getLong("entry_Id"));
            }
            orderEntryBaseMap.put(orderEntryId, bbdList);
        }
    }

    public static Long getOrderEntryIdByStock(DynamicObject saveBomStock) {
        Object orderEntryObj = saveBomStock.get("orderentryid");
        if (orderEntryObj != null) {
            Object newObj = orderEntryObj instanceof DynamicObject ? ((DynamicObject)orderEntryObj).getPkValue() : orderEntryObj;
            return NumberUtils.toLong((String)newObj.toString());
        }
        return 0L;
    }

    public static BomBaseData getBomBaseData(JSONObject resJson) {
        BigDecimal workEntryQty;
        BomBaseData bbd = new BomBaseData();
        bbd.setBomEntryId(resJson.getLong("entry_Id"));
        bbd.setBomId(resJson.getLong("id"));
        bbd.setQtydenominator(resJson.get((Object)"entryqtydenominator"));
        bbd.setQtynumerator(resJson.get((Object)"entryunitqty"));
        bbd.setQtytype(resJson.get((Object)"entryqtytype"));
        bbd.setMaterilID(resJson.getLong("entrymaterialId"));
        if ("true".equals(resJson.get((Object)"issolid"))) {
            bbd.setQtytype("B");
        }
        bbd.setScraprate(resJson.get((Object)"entryscraprate"));
        bbd.setFixscrap(resJson.get((Object)"entryfixscrap"));
        if (resJson.get((Object)"entryisjumplevel") != null) {
            bbd.setIsJump((Boolean)resJson.get((Object)"entryisjumplevel"));
        }
        if (resJson.get((Object)"materialInfo") != null) {
            bbd.setPMaterial(Long.parseLong(resJson.get((Object)"materialInfo").toString()));
        }
        if (resJson.get((Object)"workentryqty") != null && (workEntryQty = new BigDecimal(resJson.get((Object)"workentryqty").toString())).compareTo(BigDecimal.ZERO) != 0) {
            bbd.setQtynumerator(workEntryQty);
        }
        if (resJson.get((Object)"workcenter") != null) {
            bbd.setWorkCenterId(Long.parseLong(resJson.get((Object)"workcenter").toString()));
        }
        if (resJson.get((Object)"workstation") != null) {
            bbd.setWorkStationId(Long.parseLong(resJson.get((Object)"workstation").toString()));
        }
        if (resJson.containsKey((Object)"entryConfigCode")) {
            bbd.setConfigedCodeId(Long.parseLong(resJson.get((Object)"entryConfigCode").toString()));
        }
        return bbd;
    }

    private static void setQueryData(JSONArray filterArrayNew, Map<Long, String> orderEntryBomMap, OrderBaseData baseData, List<DynamicObject> saveBomStocks, Map<String, String> bomResultCacheMap) {
        long startWorkPlanIDMap = System.currentTimeMillis();
        Map<String, Long> workPlanIDMap = CreateStockByBomUtils.getWorkPlanIDMap(saveBomStocks, baseData);
        logger.info("\u67e5\u8be2\u5de5\u5355\u5bf9\u5e94\u7684\u5de5\u5e8f\u8ba1\u5212\u7684ID\u8017\u65f6--------------" + (System.currentTimeMillis() - startWorkPlanIDMap));
        for (DynamicObject saveBomStock : saveBomStocks) {
            DynamicObject orderEntry;
            String stockname = saveBomStock.getDataEntityType().getName();
            Long orderEntryId = CreateStockByBomUtils.getOrderEntryIdByStock(saveBomStock);
            DynamicObject order = baseData.getOrderByEntryId(orderEntryId);
            Long bomId = CreateStockByBomUtils.getBOMId(order, orderEntry = baseData.getOrderEntry(orderEntryId), saveBomStock, stockname, baseData, workPlanIDMap);
            if (bomId == 0L) continue;
            HashMap<String, Object> paramMap = CreateStockByBomUtils.getParamsMap(baseData, saveBomStock, order, orderEntry, bomId, 0L);
            JSONObject jsonParams = CreateStockByBomUtils.getMulBOMJsonObjectParam(paramMap);
            String resStr = CreateStockByBomUtils.getMulBomFilterStr(jsonParams);
            String res = CreateStockByBomUtils.getCacheValue(resStr);
            if (StringUtils.isEmpty((CharSequence)res) || "[]".equals(res)) {
                filterArrayNew.add((Object)jsonParams);
            }
            bomResultCacheMap.put(resStr, res);
            orderEntryBomMap.put(orderEntryId, resStr);
        }
    }

    private static HashMap<String, Object> getParamsMap(OrderBaseData baseData, DynamicObject saveBomStock, DynamicObject order, DynamicObject orderEntry, Long bomId, Long versionId) {
        String orderName = order.getDataEntityType().getName();
        DynamicObject material = null;
        Long orgId = 0L;
        if ("pm_om_purorderbill".equals(orderName)) {
            material = orderEntry.getDynamicObject("materialmasterid");
            orgId = CreateStockByBomUtils.getPkid(orderEntry.get("entryreqorg"));
        } else if ("pom_mftorder".equals(orderName) || "om_mftorder".equals(orderName)) {
            material = orderEntry.getDynamicObject("materielmasterid");
            orgId = CreateStockByBomUtils.getPkid(order.get("org"));
        }
        Long masterid = material == null ? 0L : material.getLong("id");
        Date expandtime = Objects.isNull(baseData.getExpendBomTime()) ? orderEntry.getDate("expendbomtime") : baseData.getExpendBomTime();
        DynamicObject configedCode = orderEntry.getDynamicObject("configuredcode");
        Long configCodeId = configedCode == null ? 0L : configedCode.getLong("id");
        BigDecimal num = orderEntry.getBigDecimal("qty");
        DynamicObject transactproduct = CreateStockByBomUtils.getTransactionType(baseData, saveBomStock);
        return CreateStockByBomUtils.getParamsMapByValue(bomId, masterid, expandtime, configCodeId, transactproduct, orgId, num);
    }

    public static HashMap<String, Object> getParamsMapByValue(Long bomId, Long masterid, Date expandtime, Long configCodeId, DynamicObject transactproduct, Long orgId, BigDecimal num) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(10);
        if (bomId != null && !bomId.equals(0L)) {
            paramMap.put("bomId", bomId);
        }
        paramMap.put("materialid", masterid);
        paramMap.put("searchDate", expandtime);
        paramMap.put("configcode", configCodeId);
        if (transactproduct.getDynamicObject("bomexpandconfig") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e8b\u52a1\u7c7b\u578b\u4e0a\u9762\u7684\u3010BOM\u5c55\u5f00\u5b9a\u4e49\u3011\u5b57\u6bb5\u503c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"CreateStockByBomUtils_7", (String)"bd-mpdm-common", (Object[])new Object[0]));
        }
        paramMap.put("expandConfig", transactproduct == null ? Long.valueOf(0L) : transactproduct.getDynamicObject("bomexpandconfig").getPkValue());
        paramMap.put("org", orgId);
        paramMap.put("num", num);
        paramMap.put("purexpand", false);
        paramMap.put("model", "model_pom");
        paramMap.put("showtype", "E");
        return paramMap;
    }

    public static String getBomFilterStrType(Long bomId, BigDecimal qty, Date expandtime, String type, Long routeId) {
        return CreateStockByBomUtils.getBomFilterStrNew(bomId, qty, expandtime) + "-" + type + "-" + routeId;
    }

    public static String getMulBomFilterStr(JSONObject jsonParams) {
        if (jsonParams == null) {
            return "";
        }
        String bomId = jsonParams.get((Object)"bomId") == null ? "" : jsonParams.getString("bomId");
        Date expandtime = jsonParams.get((Object)"searchDate") == null ? new Date() : jsonParams.getDate("searchDate");
        String configedCodeId = jsonParams.get((Object)"configcode") == null ? "" : jsonParams.getString("configcode");
        String qty = jsonParams.get((Object)"num") == null ? "" : jsonParams.getString("num");
        String showtype = (String)jsonParams.get((Object)"showtype");
        boolean isBomExpandTime = MmcCommonHelper.IsBomExpandTime();
        if (!isBomExpandTime) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            return bomId + "-" + configedCodeId + "-" + qty + "-" + sdf.format(expandtime) + "-" + showtype;
        }
        return bomId + "-" + configedCodeId + "-" + qty + "-" + expandtime.getTime() + "-" + showtype;
    }

    public static String getBomFilterStr(Long bomId, BigDecimal qty, Date expandtime) {
        return CreateStockByBomUtils.getBomFilterStrNew(bomId, qty, expandtime) + "-D-" + 0L;
    }

    public static String getBomFilterStrNew(Long bomId, BigDecimal qty, Date expandtime) {
        boolean isBomExpandTime = MmcCommonHelper.IsBomExpandTime();
        if (!isBomExpandTime) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            return bomId + "-" + qty + "-" + sdf.format(expandtime);
        }
        return bomId + "-" + qty + "-" + expandtime.getTime();
    }

    private static Long getBOMId(DynamicObject order, DynamicObject orderEntry, DynamicObject saveBomStock, String stockname, OrderBaseData baseData, Map<String, Long> workPlanIDMap) {
        Promater promater;
        int i;
        String orderName = order.getDataEntityType().getName();
        String bomId = "0";
        List<Promater> resultList = null;
        if ("pm_om_purorderbill".equals(orderName)) {
            bomId = orderEntry.get("bomid").toString();
        } else if ("pom_mftorder".equals(orderName) || "om_mftorder".equals(orderName) || "prop_mftorder".equals(orderName)) {
            bomId = orderEntry.get("bomid") == null ? "" : orderEntry.getDynamicObject("bomid").getPkValue().toString();
            DynamicObject transactproduct = saveBomStock.getDynamicObject("transactiontypeid");
            if (transactproduct != null && !transactproduct.getBoolean("isprocedure")) {
                resultList = null;
                logger.info("\u6ca1\u6709\u542f\u7528\u5de5\u5e8f\u7ba1\u7406\u4e0d\u53d6\u5de5\u5e8f\u7269\u6599\u5206\u914d\u3002");
            } else {
                resultList = MPDMMftGenStocksUtils.getPromaterResult(orderEntry, bomId, workPlanIDMap);
                logger.info("\u53d6\u5de5\u5e8f\u7269\u6599\u5206\u914d\u3002");
            }
        }
        if (resultList == null || resultList.isEmpty()) {
            return NumberUtils.toLong((String)bomId);
        }
        StringBuilder materialName = new StringBuilder();
        ArrayList<String> materialNameList = new ArrayList<String>(16);
        ArrayList<DynamicObject> bomEntrys = new ArrayList<DynamicObject>(16);
        for (i = 0; i < resultList.size(); ++i) {
            promater = resultList.get(i);
            bomEntrys.add(promater.getBomEntry());
            Map<Long, DynamicObject> bomEntryMap = baseData.getBomEntryMap();
            DynamicObject bomEntry = promater.getBomEntry();
            if (bomEntry == null) continue;
            bomEntryMap.put((Long)bomEntry.getPkValue(), bomEntry);
        }
        CreateStockByBomUtils.setBOMBaseData(bomEntrys, baseData, saveBomStock);
        for (i = 0; i < resultList.size(); ++i) {
            promater = resultList.get(i);
            String res = CreateStockByBomUtils.createAndSetStockEntryValueByBom(order, orderEntry, saveBomStock, baseData, promater.getBomEntry(), promater, null);
            if ("0".equals(res) || "1".equals(res)) continue;
            materialNameList.add(res);
        }
        CreateStockByBomUtils.appendErrInfo(materialNameList, materialName);
        StringBuilder errInfo = new StringBuilder();
        if (materialName.length() > 0) {
            CreateStockByBomUtils.appendErrInfoOrder(materialName, orderEntry, order, errInfo);
        }
        if (!"".equals(errInfo.toString())) {
            Long orderEntryId = CreateStockByBomUtils.getOrderEntryIdByStock(saveBomStock);
            CreateStockUtils.setErr(orderEntryId, baseData, errInfo.toString(), saveBomStock);
        }
        return 0L;
    }

    private static String createAndSetStockEntryValueByBom(DynamicObject order, DynamicObject orderEntry, DynamicObject saveBomStock, OrderBaseData baseData, DynamicObject bomEntry, Promater promater, BomBaseData bbd) {
        Long masterid;
        DynamicObject materialmftInfo;
        String stockName = saveBomStock.getDataEntityType().getName();
        DynamicObject org = saveBomStock.getDynamicObject("org");
        if (org == null) {
            String seq = orderEntry.getString("seq");
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5de5\u5355\uff08\u7f16\u53f7\uff1a%1$s\uff1b\u884c\u53f7\uff1a%2$s\uff09\u751f\u6210\u7684\u7ec4\u4ef6\u6e05\u5355\uff0c\u201c\u751f\u4ea7\u7ec4\u7ec7\u201d\u4e3a\u7a7a\u3002", (String)"CreateStockByBomUtils_2", (String)"bd-mpdm-common", (Object[])new Object[0]), order.getString("billno"), seq));
        }
        Long orgId = (Long)org.getPkValue();
        DynamicObject entrymaterial = CreateStockByBomUtils.getMaterialMftFromBom(bomEntry, bbd, baseData, orgId);
        if (entrymaterial == null) {
            logger.info("\u627e\u4e0d\u5230\u7269\u6599\u751f\u4ea7\u4fe1\u606f\uff1a\u53ef\u80fd\u662f\u8d85\u7ea7BOM\u672a\u914d\u7f6e\u7269\u6599\u751f\u4ea7\u4fe1\u606f,BOM\u5206\u5f55\u7684ID=" + bomEntry.getPkValue().toString());
            String bomNumber = ((DynamicObject)bomEntry.getParent()).getString("number");
            Long masterId = CreateStockByBomUtils.getMaterialId(bomEntry, bbd);
            if (masterId != null && !masterId.equals(0L)) {
                DynamicObject materialmftInfo2 = baseData.getOrgMaterialMftInfo(orgId, masterId);
                String materialmftInfoStr = "";
                materialmftInfoStr = materialmftInfo2 == null ? "0" : (materialmftInfo2.getPkValue() == null ? "1" : materialmftInfo2.getPkValue().toString());
                logger.info("\u627e\u4e0d\u5230\u7269\u6599\u751f\u4ea7\u4fe1\u606f\uff1a\u53ef\u80fd\u662f\u8d85\u7ea7BOM\u672a\u914d\u7f6e\u7269\u6599\u751f\u4ea7\u4fe1\u606f," + materialmftInfoStr);
                DynamicObject dataCacheByMaterialID = MaterialMftQueryHelper.getDataCacheByMaterialID(masterId, orgId, null);
                String dataCacheByMaterialIDStr = "";
                dataCacheByMaterialIDStr = dataCacheByMaterialID == null ? "0" : (dataCacheByMaterialID.getPkValue() == null ? "1" : dataCacheByMaterialID.getPkValue().toString());
                logger.info("\u627e\u4e0d\u5230\u7269\u6599\u751f\u4ea7\u4fe1\u606f\uff1a\u53ef\u80fd\u662f\u8d85\u7ea7BOM\u672a\u914d\u7f6e\u7269\u6599\u751f\u4ea7\u4fe1\u606f,\u91cd\u65b0\u67e5\u8be2\u7ed3\u679c" + dataCacheByMaterialIDStr);
            } else {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"BOM\u201c%1$s\u201d\u7684\u5206\u5f55\u5b58\u5728\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u4e3a\u7a7a\u7684\u6570\u636e\uff0c\u8bf7\u6838\u67e5\u3002", (String)"CreateStockByBomUtils_3", (String)"bd-mpdm-common", (Object[])new Object[0]), bomNumber));
            }
        }
        if ((materialmftInfo = baseData.getOrgMaterialMftInfo(orgId, masterid = CreateStockByBomUtils.getMaterialId(bomEntry, bbd))) == null || !materialmftInfo.getBoolean("enable") || !"C".equalsIgnoreCase(materialmftInfo.getString("status"))) {
            DynamicObject material = MaterialQueryHelper.getDataCacheByID(masterid);
            logger.info("\u627e\u4e0d\u5230\u7269\u6599\u751f\u4ea7\u4fe1\u606f\uff1a:" + material.getPkValue().toString());
            return material.getString("number") + "," + material.getString("name");
        }
        DynamicObjectCollection stockEntrys = saveBomStock.getDynamicObjectCollection("stockentry");
        DynamicObject stockEntry = stockEntrys.addNew();
        String orderName = order.getDataEntityType().getName();
        DynamicObject transactproduct = CreateStockUtils.getTran(saveBomStock, stockName, baseData);
        stockEntry.set("leadtime", bomEntry.get("entryleadtime"));
        if (bbd != null && bbd.getConfigedCodeId() != null && !bbd.getConfigedCodeId().equals(0L)) {
            stockEntry.set("entryconfiguredcode", (Object)bbd.getConfigedCodeId());
        } else {
            stockEntry.set("entryconfiguredcode", bomEntry.get("entryconfiguredcode"));
        }
        if ("pm_om_purorderbill".equals(orderName)) {
            BigDecimal leadtime = bomEntry.getBigDecimal("entryleadtime");
            Calendar c = Calendar.getInstance();
            c.setTime(orderEntry.getDate("deliverdate"));
            c.add(5, leadtime.intValue());
            stockEntry.set("demanddate", (Object)c.getTime());
        } else if ("pom_mftorder".equals(orderName) || "om_mftorder".equals(orderName) || "prop_mftorder".equals(orderName)) {
            Date planbegintime = orderEntry.getDate("planbegintime");
            Date planendtime = orderEntry.getDate("planendtime");
            stockEntry.set("demanddate", CreateStockByBomUtils.getDemandDate(org, planbegintime, stockEntry, planendtime));
        }
        boolean isconsiderloss = false;
        String materialsource = "A";
        Object backflushtime = null;
        if (transactproduct != null) {
            isconsiderloss = transactproduct.getBoolean("isconsiderloss");
            materialsource = transactproduct.getString("materialsource");
            backflushtime = transactproduct.get("backflushtime");
        }
        stockEntry.set("isbomextend", (Object)Boolean.TRUE);
        DynamicObject entryunit = MPDMMftGenStocksUtils.getEntryUnit(bomEntry, materialmftInfo);
        stockEntry.set("materialunitid", (Object)entryunit);
        stockEntry.set("materialid", (Object)materialmftInfo);
        stockEntry.set("materielmasterid", (Object)masterid);
        stockEntry.set("useratio", (Object)0);
        stockEntry.set("pid", (Object)1L);
        if (!bomEntry.getBoolean("entryisreplace")) {
            stockEntry.set("useratio", (Object)100);
            stockEntry.set("pid", (Object)0L);
        }
        if (promater != null) {
            stockEntry.set("qtytype", (Object)bomEntry.getString("entryqtytype"));
            stockEntry.set("qtynumerator", bomEntry.get("entryqtynumerator"));
            stockEntry.set("qtydenominator", bomEntry.get("entryqtydenominator"));
            stockEntry.set("fixscrap", bomEntry.get("entryfixscrap"));
            stockEntry.set("scraprate", bomEntry.get("entryscraprate"));
        } else {
            CreateStockByBomUtils.setQtyType(stockEntry, baseData, (Long)orderEntry.getPkValue(), (Long)bomEntry.getPkValue(), bbd);
        }
        stockEntry.set("standqty", (Object)MPDMMftGenStocksUtils.getStandQty(bomEntry, orderEntry, stockEntry));
        String wastagerateformula = "B";
        String orgMasterWast = baseData.getOrgMasterWast(orgId, masterid);
        if (orgMasterWast != null) {
            wastagerateformula = orgMasterWast;
        } else if (!isconsiderloss) {
            wastagerateformula = "";
        }
        stockEntry.set("wastagerateformula", (Object)wastagerateformula);
        stockEntry.set("demandqty", (Object)MPDMMftGenStocksUtils.getDemandQty(bomEntry, isconsiderloss, stockEntry, wastagerateformula));
        stockEntry.set("bomreversion", (Object)bomEntry.getDynamicObject("entryversion"));
        stockEntry.set("childauxpropertyid", bomEntry.get("entryauxproperty"));
        stockEntry.set("considerminbatch", materialmftInfo.get("considerminbatch"));
        Boolean isquotacontrol = materialmftInfo.get("isquotacontrol") == null ? false : materialmftInfo.getBoolean("isquotacontrol");
        if (isquotacontrol.booleanValue()) {
            stockEntry.set("overissuecontrl", (Object)"B");
            stockEntry.set("issinhighlimit", materialmftInfo.get("issinhighlimit"));
            stockEntry.set("extraratioqty", (Object)stockEntry.getBigDecimal("demandqty").multiply(BigDecimal.ONE.add(materialmftInfo.getBigDecimal("issinhighlimit").divide(BigDecimal.valueOf(100L), 4, 4))));
            stockEntry.set("issinlowlimit", materialmftInfo.get("issinlowlimit"));
            stockEntry.set("lackraitioqty", (Object)stockEntry.getBigDecimal("demandqty").multiply(BigDecimal.ONE.subtract(materialmftInfo.getBigDecimal("issinlowlimit").divide(BigDecimal.valueOf(100L), 4, 4))));
        } else {
            stockEntry.set("overissuecontrl", (Object)"A");
            stockEntry.set("extraratioqty", stockEntry.get("demandqty"));
            stockEntry.set("lackraitioqty", stockEntry.get("demandqty"));
        }
        stockEntry.set("bomentryid", bomEntry.getPkValue());
        stockEntry.set("cansendqty", MPDMMftGenStocksUtils.aculCanSendQty(stockEntry));
        stockEntry.set("unissueqty", MPDMMftGenStocksUtils.aculUnSendQty(stockEntry));
        stockEntry.set("priority", bomEntry.get("reppriority"));
        stockEntry.set("ismainreplace", bomEntry.get("entryisreplaceplanmm"));
        stockEntry.set("replaceplan", bomEntry.get("entryreplaceplan"));
        stockEntry.set("sourcetype", (Object)"A");
        Object bomParent = bomEntry.getParent();
        if (bomParent != null) {
            DynamicObject chilidBom = (DynamicObject)bomParent;
            if (CreateStockByBomUtils.hasProperties(stockEntry, "childbomid")) {
                stockEntry.set("childbomid", (Object)chilidBom);
            }
            if (CreateStockByBomUtils.hasProperties(stockEntry, "parentmaterial")) {
                stockEntry.set("parentmaterial", chilidBom.get("material"));
            }
        }
        if (bbd != null) {
            if (!CreateStockByBomUtils.isNullLong(bbd.getWorkStationId()) && CreateStockByBomUtils.hasProperties(stockEntry, "workstation")) {
                stockEntry.set("workstation", (Object)bbd.getWorkStationId());
            }
            if (!CreateStockByBomUtils.isNullLong(bbd.getWorkCenterId()) && CreateStockByBomUtils.hasProperties(stockEntry, "oprworkcenter")) {
                stockEntry.set("oprworkcenter", (Object)bbd.getWorkCenterId());
            }
        }
        if ("B".equals(materialsource)) {
            CreateStockUtils.setStockEntryByMftInfoExPandWarehouse(stockEntry, materialmftInfo);
        } else {
            CreateStockUtils.setStockEntryByBomInfoExPandWarehouse(stockEntry, bomEntry);
        }
        if ("pom_mftorder".equals(orderName) || "om_mftorder".equals(orderName)) {
            if (promater != null) {
                stockEntry.set("oprno", (Object)promater.getOprno());
                stockEntry.set("processseq", (Object)promater.getProcessseq());
                stockEntry.set("machiningtype", (Object)promater.getMachiningtype());
                stockEntry.set("workprocedureid", (Object)promater.getWorkprocedure());
                stockEntry.set("oprworkcenter", (Object)promater.getWorkcenter());
                stockEntry.set("outsupplier", (Object)promater.getOutsupply());
                stockEntry.set("workplanid", (Object)promater.getWorkplanid());
                stockEntry.set("promaterentryid", (Object)promater.getPromaterEntryid());
                stockEntry.set("operationdesc", (Object)promater.getOperationdesc());
            } else {
                stockEntry.set("oprno", bomEntry.get("entryoperationnumber"));
                stockEntry.set("processseq", bomEntry.get("entryprocessseq"));
            }
        }
        if (CreateStockByBomUtils.hasProperties(stockEntry, "isjumplevel")) {
            stockEntry.set("isjumplevel", bomEntry.get("entryisjumplevel"));
            if (stockEntry.getBoolean("isjumplevel")) {
                stockEntry.set("issuemode", (Object)"C");
            }
        }
        if (CreateStockByBomUtils.hasProperties(stockEntry, "pstockentryid")) {
            stockEntry.set("pstockentryid", (Object)0L);
        }
        if ("B".equals(stockEntry.get("isbackflush"))) {
            stockEntry.set("backflushtime", backflushtime);
        } else {
            stockEntry.set("backflushtime", null);
        }
        stockEntry.set("supplymode", bomEntry.get("entryownertype"));
        stockEntry.set("supplierid", bomEntry.get("entryowner"));
        return "0";
    }

    public static String getDymId(DynamicObject stockEntry, String keyEntryOutlocation) {
        Object keyObj = stockEntry.get(keyEntryOutlocation);
        if (keyObj != null) {
            Object newObj;
            Object object = newObj = keyObj instanceof DynamicObject ? ((DynamicObject)keyObj).getPkValue() : keyObj;
            if (StringUtils.isEmpty((CharSequence)newObj.toString())) {
                return "0";
            }
            return newObj.toString();
        }
        return "0";
    }

    public static Object getSupplyByBaseData(OrderBaseData baseData, Long orgfieldId) {
        if (baseData.getSupply(orgfieldId) == null) {
            Map<Long, Object> supplyMap = baseData.getSupplyMap();
            HashSet<Long> supplyOrgIdSet = new HashSet<Long>(16);
            supplyOrgIdSet.add(orgfieldId);
            CreateStockUtils.getSupplyMap(supplyMap, supplyOrgIdSet);
            baseData.setSupplyMap(supplyMap);
        }
        return baseData.getSupply(orgfieldId);
    }

    private static void setQtyType(DynamicObject stockEntry, OrderBaseData baseData, Long orderEntryId, Long bomEntryId, BomBaseData bbd) {
        CreateStockByBomUtils.setStockEntryQtyByBomBaseData(stockEntry, bbd);
    }

    public static void setStockEntryQtyByBomBaseData(DynamicObject stockEntry, BomBaseData bbd) {
        if (bbd != null) {
            stockEntry.set("qtytype", bbd.getQtytype());
            stockEntry.set("qtynumerator", bbd.getQtynumerator());
            stockEntry.set("qtydenominator", bbd.getQtydenominator());
            stockEntry.set("fixscrap", bbd.getFixscrap());
            stockEntry.set("scraprate", bbd.getScraprate());
            if (CreateStockByBomUtils.hasProperties(stockEntry, "oprworkcenter")) {
                stockEntry.set("oprworkcenter", (Object)bbd.getWorkCenterId());
            }
            if (CreateStockByBomUtils.hasProperties(stockEntry, "workstation")) {
                stockEntry.set("workstation", (Object)bbd.getWorkStationId());
            }
        }
    }

    public static Object getDemandDate(DynamicObject org, Date planbegintime, DynamicObject stockEntry, Date planendtime) {
        Date replanbegintime;
        BigDecimal leadtime = stockEntry.getBigDecimal("leadtime");
        Calendar c = Calendar.getInstance();
        c.setTime(planbegintime);
        if (leadtime != null) {
            c.add(5, leadtime.intValue());
        }
        if ((replanbegintime = c.getTime()) == null) {
            replanbegintime = planbegintime;
        } else if (replanbegintime.after(planendtime)) {
            replanbegintime = planendtime;
        }
        return replanbegintime;
    }

    private static void setBOMBaseData(List<DynamicObject> bomEntrys, OrderBaseData baseData, DynamicObject saveBomStock) {
        DynamicObject org = saveBomStock.getDynamicObject("org");
        if (org != null) {
            Long orgId = (Long)org.getPkValue();
            Map<Long, Object> orgMaterialMftInfoMap = baseData.getOrgMaterialMftInfoMap();
            Map<Long, Map<Long, DynamicObject>> orgMaterialPlanInfoMap = baseData.getOrgMaterialPlanInfoMap();
            Map<Long, Object> orgMasterWastMap = baseData.getOrgMasterWastMap();
            HashMap<Long, Set<Long>> orgMasterMap = new HashMap<Long, Set<Long>>(16);
            HashSet<Long> supplyOrgIdSet = new HashSet<Long>(16);
            HashSet<Long> masterSet = new HashSet<Long>(16);
            for (DynamicObject bomEntry : bomEntrys) {
                DynamicObject master;
                if (bomEntry == null || bomEntry.getDynamicObject("entrymaterial") == null || (master = bomEntry.getDynamicObject("entrymaterial").getDynamicObject("masterid")) == null) continue;
                masterSet.add((Long)master.getPkValue());
            }
            Map<Long, List<BomBaseData>> bomMap = baseData.getOrderEntryBaseMap();
            if (bomMap != null && !bomMap.isEmpty()) {
                for (Map.Entry<Long, List<BomBaseData>> bomMapEntrys : bomMap.entrySet()) {
                    List<BomBaseData> bbdList = bomMapEntrys.getValue();
                    if (bbdList == null || bbdList.isEmpty()) continue;
                    for (int i = 0; i < bbdList.size(); ++i) {
                        BomBaseData bbd = bbdList.get(i);
                        if (bbd.getMaterilID() == null || bbd.getMaterilID().equals(0L)) continue;
                        masterSet.add(bbd.getMaterilID());
                    }
                }
            }
            orgMasterMap.put(orgId, masterSet);
            CreateStockUtils.getInfoByMaster(orgId, orgMasterWastMap, orgMaterialMftInfoMap, orgMaterialPlanInfoMap, orgMasterMap, supplyOrgIdSet, baseData);
            baseData.setOrgMasterWastMap(orgMasterWastMap);
            baseData.setOrgMaterialMftInfoMap(orgMaterialMftInfoMap);
        }
    }

    private static void setBOMBaseData(List<DynamicObject> bomEntrys, OrderBaseData baseData, Set<Long> orgIds) {
        if (!orgIds.isEmpty()) {
            for (Long orgId : orgIds) {
                Map<Long, Object> orgMaterialMftInfoMap = baseData.getOrgMaterialMftInfoMap();
                Map<Long, Map<Long, DynamicObject>> orgMaterialPlanInfoMap = baseData.getOrgMaterialPlanInfoMap();
                Map<Long, Object> orgMasterWastMap = baseData.getOrgMasterWastMap();
                HashMap<Long, Set<Long>> orgMasterMap = new HashMap<Long, Set<Long>>(16);
                HashSet<Long> supplyOrgIdSet = new HashSet<Long>(16);
                HashSet<Long> masterSet = new HashSet<Long>(16);
                for (DynamicObject bomEntry : bomEntrys) {
                    DynamicObject master;
                    if (bomEntry == null || bomEntry.getDynamicObject("entrymaterial") == null || (master = bomEntry.getDynamicObject("entrymaterial").getDynamicObject("masterid")) == null) continue;
                    masterSet.add((Long)master.getPkValue());
                }
                Map<Long, List<BomBaseData>> bomMap = baseData.getOrderEntryBaseMap();
                if (bomMap != null && !bomMap.isEmpty()) {
                    for (Map.Entry<Long, List<BomBaseData>> bomMapEntrys : bomMap.entrySet()) {
                        List<BomBaseData> bbdList = bomMapEntrys.getValue();
                        if (bbdList == null || bbdList.isEmpty()) continue;
                        for (int i = 0; i < bbdList.size(); ++i) {
                            BomBaseData bbd = bbdList.get(i);
                            if (bbd.getMaterilID() == null || bbd.getMaterilID().equals(0L)) continue;
                            masterSet.add(bbd.getMaterilID());
                        }
                    }
                }
                orgMasterMap.put(orgId, masterSet);
                CreateStockUtils.getInfoByMaster(orgId, orgMasterWastMap, orgMaterialMftInfoMap, orgMaterialPlanInfoMap, orgMasterMap, supplyOrgIdSet, baseData);
                baseData.setOrgMasterWastMap(orgMasterWastMap);
                baseData.setOrgMaterialMftInfoMap(orgMaterialMftInfoMap);
            }
        }
    }

    private static void appendErrInfoOrder(StringBuilder materialName, DynamicObject orderEntry, DynamicObject order, StringBuilder errInfo) {
        String orderName = order.getDataEntityType().getName();
        String mtfOrgName = "";
        mtfOrgName = "pm_om_purorderbill".equals(orderName) ? orderEntry.getDynamicObject("entryreqorg").getString("name") : order.getDynamicObject("org").getString("name");
        errInfo.append(String.format(ResManager.loadKDString((String)"BOM\u5206\u5f55\u201c\u7ec4\u4ef6\u201d\u4e3a%1$s\u5728\u7ec4\u7ec7\u201c%2$s\u201d\u4e0d\u5b58\u5728\u53ef\u7528\u7684\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u3002", (String)"CreateStockByBomUtils_6", (String)"bd-mpdm-common", (Object[])new Object[0]), materialName, mtfOrgName));
    }

    private static void appendErrInfo(List<String> materialNameList, StringBuilder materialName) {
        if (!materialNameList.isEmpty()) {
            if (materialNameList.size() == 1) {
                materialName.append("\u3010");
                materialName.append(materialNameList.get(0));
                materialName.append("\u3011");
            } else if (materialNameList.size() > 1) {
                for (int i = 0; i < materialNameList.size(); ++i) {
                    if (i == materialNameList.size() - 1) {
                        materialName.append("\u3010");
                        materialName.append(materialNameList.get(i));
                        materialName.append("\u3011");
                        continue;
                    }
                    materialName.append("\u3010");
                    materialName.append(materialNameList.get(i));
                    materialName.append("\u3011");
                    materialName.append(",");
                }
            }
        }
    }

    public static JSONObject getBomFilterJson(Long bomId, BigDecimal qty, Date expendbomtime) {
        JSONObject filterJson = CreateStockByBomUtils.getBomFilterJsonNew(bomId, qty, expendbomtime, 0L);
        filterJson.put("type", (Object)"D");
        return filterJson;
    }

    public static JSONObject getBomFilterJsonNew(Long bomId, BigDecimal qty, Date expendbomtime, Long routeId) {
        JSONObject filterJson = new JSONObject();
        filterJson.put("id", (Object)bomId);
        filterJson.put("num", (Object)qty);
        filterJson.put("time", (Object)expendbomtime);
        filterJson.put("routeId", (Object)routeId);
        return filterJson;
    }

    public static JSONObject getBomFilterJsonType(Long bomId, BigDecimal qty, Date expendbomtime, String type, Long routeId) {
        JSONObject filterJson = CreateStockByBomUtils.getBomFilterJsonNew(bomId, qty, expendbomtime, routeId);
        filterJson.put("type", (Object)type);
        return filterJson;
    }

    public static JSONObject getMulBOMJsonObjectParam(HashMap<String, Object> paramMap) {
        JSONObject paramObject = new JSONObject(10);
        if (paramMap == null || paramMap.size() < 1) {
            return paramObject;
        }
        Object bomId = paramMap.get("bomId");
        if (bomId != null && !bomId.equals(0L)) {
            paramObject.put("bomId", bomId);
        }
        paramObject.put("materialid", paramMap.get("materialid"));
        paramObject.put("expandConfig", paramMap.get("expandConfig"));
        paramObject.put("searchDate", paramMap.get("searchDate"));
        paramObject.put("configcode", paramMap.get("configcode"));
        paramObject.put("version", paramMap.get("version"));
        paramObject.put("org", paramMap.get("org"));
        paramObject.put("num", paramMap.get("num"));
        paramObject.put("showtype", paramMap.get("showtype"));
        paramObject.put("purexpand", paramMap.get("purexpand"));
        paramObject.put("model", paramMap.get("model"));
        return paramObject;
    }

    public static Map<String, Long> getWorkPlanIDMap(List<DynamicObject> saveBomStocks, OrderBaseData baseData) {
        HashSet<Long> orderEntryIDSet = new HashSet<Long>(saveBomStocks.size());
        for (DynamicObject saveBomStock : saveBomStocks) {
            Long processrouteId;
            DynamicObject transactproduct;
            Long orderEntryId = CreateStockByBomUtils.getOrderEntryIdByStock(saveBomStock);
            DynamicObject order = baseData.getOrderByEntryId(orderEntryId);
            DynamicObject orderEntry = baseData.getOrderEntry(orderEntryId);
            String orderName = order.getDataEntityType().getName();
            if (!"pom_mftorder".equals(orderName) && !"om_mftorder".equals(orderName) || (transactproduct = saveBomStock.getDynamicObject("transactiontypeid")) != null && !transactproduct.getBoolean("isprocedure") || (processrouteId = Long.valueOf(orderEntry.get("processroute") != null ? Long.parseLong(orderEntry.getDynamicObject("processroute").getPkValue().toString()) : 0L)) == 0L) continue;
            orderEntryIDSet.add(orderEntryId);
        }
        HashMap<String, Long> workPlanMap = new HashMap<String, Long>(16);
        if (orderEntryIDSet == null || orderEntryIDSet.size() < 1) {
            return workPlanMap;
        }
        QFilter qfilter = new QFilter("mftentryseq", "in", orderEntryIDSet);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-createstockbybomutils-querytech", (String)"sfc_manftech", (String)"mftentryseq.id,oprentryentity.id,oprentryentity.oprparent,oprentryentity.oprno", (QFilter[])new QFilter[]{qfilter}, (String)"");){
            while (ds.hasNext()) {
                Row arow = ds.next();
                Long id = arow.getLong("mftentryseq.id");
                String oprno = arow.getString("oprentryentity.oprno");
                String oprparent = arow.getString("oprentryentity.oprparent");
                workPlanMap.put(id + "_" + oprparent + "_" + oprno, arow.getLong("oprentryentity.id"));
            }
        }
        return workPlanMap;
    }

    public static boolean isShowJump(DynamicObject transactionType) {
        if (transactionType == null) {
            return false;
        }
        String stockmaterials = "";
        if (CreateStockByBomUtils.isWWTransactionType(transactionType)) {
            if (!transactionType.containsProperty("feedtype") || !transactionType.containsProperty("showjump")) {
                transactionType = BusinessDataServiceHelper.loadSingleFromCache((Object)transactionType.getPkValue(), (String)transactionType.getDataEntityType().getName());
            }
            stockmaterials = transactionType.getString("feedtype");
        } else {
            if (!transactionType.containsProperty("stockmaterials") || !transactionType.containsProperty("showjump")) {
                transactionType = TransactionTypeQueryHelper.getDataCacheByID(transactionType.getPkValue());
            }
            stockmaterials = transactionType.getString("stockmaterials");
        }
        return transactionType.getBoolean("showjump") && "A".equals(stockmaterials);
    }

    private static boolean isWWTransactionType(DynamicObject transactionType) {
        return "mpdm_transactout".equalsIgnoreCase(transactionType.getDataEntityType().getName());
    }

    public static DynamicObject getTransactionType(OrderBaseData baseData, DynamicObject saveBomStock) {
        DynamicObject transactproduct = null;
        Object transObj = saveBomStock.get("transactiontypeid");
        if (transObj instanceof DynamicObject) {
            transactproduct = saveBomStock.getDynamicObject("transactiontypeid");
        } else if (transObj instanceof Long) {
            transactproduct = baseData.getWwTranMapById((Long)transObj);
        }
        return transactproduct;
    }

    private static DynamicObject getMaterialMftFromBom(DynamicObject bomEntry, BomBaseData bbd, OrderBaseData baseData, Long orgId) {
        Long masterid = CreateStockByBomUtils.getMaterialId(bomEntry, bbd);
        if (masterid == null || masterid.equals(0L)) {
            return null;
        }
        return baseData.getOrgMaterialMftInfo(orgId, masterid);
    }

    private static Long getMaterialId(DynamicObject bomEntry, BomBaseData bbd) {
        DynamicObject entrymaterial = bomEntry.getDynamicObject("entrymaterial");
        Long masterid = 0L;
        if (entrymaterial == null) {
            if (bbd != null) {
                masterid = bbd.getMaterilID();
            }
        } else {
            masterid = (Long)entrymaterial.getDynamicObject("masterid").getPkValue();
        }
        return masterid;
    }

    private static boolean isNullLong(Long data) {
        return data == null || data.equals(0L);
    }

    private static boolean isDynamicObjectEquals(DynamicObject data1, DynamicObject data2) {
        if (data1 == null && data2 == null) {
            return true;
        }
        if (data1 != null && data2 != null) {
            return data1.getPkValue().equals(data2.getPkValue());
        }
        return false;
    }

    private static boolean hasProperties(DynamicObject data, String propertiesNumber) {
        return data.getDataEntityType().getProperties().containsKey((Object)propertiesNumber);
    }

    public static void setPStockEntryId(List<DynamicObject> saveBomStocks) {
        for (DynamicObject saveBomStock : saveBomStocks) {
            CreateStockByBomUtils.setPStockEntryId(saveBomStock);
        }
    }

    public static void setPStockEntryId(DynamicObject saveBomStock) {
        CreateStockByBomUtils.setPStockEntryId(saveBomStock, null);
    }

    public static void setParentEntryId(List<DynamicObject> saveBomStocks, List<DynamicObject> stockEntryList) {
        for (DynamicObject saveBomStock : saveBomStocks) {
            CreateStockByBomUtils.setPStockEntryId(saveBomStock, stockEntryList);
        }
    }

    private static Set<Long> getStockEntryIdSet(List<DynamicObject> stockEntryList) {
        HashSet<Long> stockEntryIdSet = new HashSet<Long>(16);
        if (stockEntryList != null && !stockEntryList.isEmpty()) {
            for (DynamicObject stockEntry : stockEntryList) {
                stockEntryIdSet.add((Long)stockEntry.getPkValue());
            }
        }
        return stockEntryIdSet;
    }

    public static void setPStockEntryId(DynamicObject saveBomStock, List<DynamicObject> stockEntryList) {
        DynamicObject parentMaterial = saveBomStock.getDynamicObject("productid");
        DynamicObjectCollection stockEntrys = saveBomStock.getDynamicObjectCollection("stockentry");
        int isize = stockEntrys.size();
        Set<Long> stockEntryIdSet = CreateStockByBomUtils.getStockEntryIdSet(stockEntryList);
        for (int i = 0; i < isize; ++i) {
            DynamicObject stockEntry = (DynamicObject)stockEntrys.get(i);
            if (!stockEntryIdSet.isEmpty() && !stockEntryIdSet.contains((Long)stockEntry.getPkValue())) continue;
            if (!CreateStockByBomUtils.hasProperties(stockEntry, "pstockentryid") || !CreateStockByBomUtils.hasProperties(stockEntry, "parentmaterial")) {
                return;
            }
            if (!CreateStockByBomUtils.validateSourceType(stockEntry)) continue;
            DynamicObject entryParentMaterial = stockEntry.getDynamicObject("parentmaterial");
            if (entryParentMaterial == null || CreateStockByBomUtils.isDynamicObjectEquals(parentMaterial, entryParentMaterial)) {
                stockEntry.set("pstockentryid", (Object)0L);
                continue;
            }
            stockEntry.set("pstockentryid", (Object)CreateStockByBomUtils.findPStockEntryId(stockEntrys, entryParentMaterial, i));
        }
    }

    private static boolean validateSourceType(DynamicObject stockEntry) {
        return CreateStockByBomUtils.hasProperties(stockEntry, "sourcetype") && (stockEntry.getString("sourcetype").equals("A") || stockEntry.getString("sourcetype").equals("C"));
    }

    private static Long findPStockEntryId(DynamicObjectCollection stockEntrys, DynamicObject currentParentMaterial, int seq) {
        DynamicObject entryMaterial;
        DynamicObject stockEntry;
        int i;
        int isize = stockEntrys.size();
        if (seq > 0) {
            for (i = seq - 1; i >= 0; --i) {
                stockEntry = (DynamicObject)stockEntrys.get(i);
                entryMaterial = stockEntry.getDynamicObject("materialid");
                if (!CreateStockByBomUtils.validateSourceType(stockEntry) || !CreateStockByBomUtils.isDynamicObjectEquals(entryMaterial, currentParentMaterial)) continue;
                return (Long)stockEntry.getPkValue();
            }
        }
        if (seq < isize - 1) {
            for (i = seq + 1; i < isize; ++i) {
                stockEntry = (DynamicObject)stockEntrys.get(i);
                entryMaterial = stockEntry.getDynamicObject("materialid");
                if (!CreateStockByBomUtils.validateSourceType(stockEntry) || !CreateStockByBomUtils.isDynamicObjectEquals(entryMaterial, currentParentMaterial)) continue;
                return (Long)stockEntry.getPkValue();
            }
        }
        return 0L;
    }

    private static Long getPkid(Object obj) {
        Long objId = 0L;
        if (obj instanceof DynamicObject) {
            objId = ((DynamicObject)obj).getLong("id");
        }
        if (obj instanceof Long) {
            objId = (Long)obj;
        }
        return objId;
    }
}

