/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.mftorder.utils;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.mftorder.utils.CreateStockByBomUtils;
import kd.bd.mpdm.common.mftorder.utils.ICreateStockExpandPlugin;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bd.mpdm.common.mftorder.utils.OrderBaseData;
import kd.bd.mpdm.common.mftorder.utils.OrderOpUtils;
import kd.bd.mpdm.common.mftorder.utils.PlanScopeHelper;
import kd.bd.mpdm.common.mftorderbom.utils.CreateStockCardUtils;
import kd.bd.mpdm.common.mftorderbom.utils.InnerProStocksUtils;
import kd.bd.mpdm.common.programe.utils.ProgrameOperateStockUtils;
import kd.bd.mpdm.common.query.helper.MaterialMftQueryHelper;
import kd.bd.mpdm.common.query.helper.MaterialPlanQueryHelper;
import kd.bd.mpdm.common.query.helper.WorkcenterQueryHelper;
import kd.bd.mpdm.common.query.helper.WwTransactionTypeQueryHelper;
import kd.bd.mpdm.common.query.mservice.helper.MsBomQueryHelper;
import kd.bd.mpdm.common.stockchange.utils.EntityNameUtils;
import kd.bd.mpdm.common.utils.DynamicObjDataUtil;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.mmc.business.query.helper.BillTypeQueryHelper;
import kd.bos.ext.mmc.business.query.helper.MmcCommonHelper;
import kd.bos.ext.mmc.business.query.helper.OrgQueryHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import org.apache.commons.lang3.math.NumberUtils;

public class CreateStockUtils {
    private static final Log logger = LogFactory.getLog(CreateStockUtils.class);
    private static final String REPLACENO = "replaceno";
    private static final String BOMREPLACENONAME = "bomreplacenoname";
    private static final String ISQUOTACONTROL2 = "isquotacontrol";
    private static final String PRODUCTMASTERID = "productmasterid";
    public static final String PROGRAMME = "programme";

    public static OrderBaseData getStocks(List<DynamicObject> orderList, String operation, String stockname) {
        String orderName = EntityNameUtils.getEntityName(1, 0, stockname);
        OrderBaseData baseData = null;
        if ("save".equals(operation)) {
            long start = System.currentTimeMillis();
            baseData = CreateStockUtils.getOrderBasedataMap(orderList, stockname);
            logger.info("\u751f\u6210\u7ec4\u4ef6\u6e05\u5355\uff1a1\u3001\u83b7\u53d6\u7ec4\u4ef6\u6e05\u5355\u76f8\u5173\u57fa\u7840\u6570\u636e\u8017\u65f6--------------" + (System.currentTimeMillis() - start));
            CreateStockUtils.readDelOrderEntryIds(baseData, orderList, orderName);
            long startreadStocks = System.currentTimeMillis();
            CreateStockUtils.readStocks(baseData, stockname);
            logger.info("\u751f\u6210\u7ec4\u4ef6\u6e05\u5355\uff1a2\u3001\u5224\u65ad\u662f\u5426\u5df2\u751f\u6210\u7ec4\u4ef6\u6e05\u5355\u8017\u65f6--------------" + (System.currentTimeMillis() - startreadStocks));
            long startexpandStocks = System.currentTimeMillis();
            CreateStockUtils.expandStocks(baseData, stockname);
            logger.info("\u751f\u6210\u7ec4\u4ef6\u6e05\u5355\uff1a3\u3001\u7ec4\u4ef6\u6e05\u5355\u5c55\u5f00\u8017\u65f6--------------" + (System.currentTimeMillis() - startexpandStocks));
        } else if ("delete".equals(operation)) {
            baseData = new OrderBaseData();
            Set<Long> deleteOrderEntryIds = baseData.getDeleteOrderEntryIds();
            HashSet<Long> orderEntryids = new HashSet<Long>();
            for (DynamicObject order : orderList) {
                DynamicObjectCollection orderEntrys = order.getDynamicObjectCollection("billentry");
                for (DynamicObject orderEntry : orderEntrys) {
                    orderEntryids.add((Long)orderEntry.getPkValue());
                }
            }
            deleteOrderEntryIds.addAll(orderEntryids);
        }
        return baseData;
    }

    private static void expandStocks(OrderBaseData baseData, String stockname) {
        List<DynamicObject> saveStocks = baseData.getSaveStocks();
        if (saveStocks.isEmpty()) {
            return;
        }
        String srcbillentity = "sourcebilltype";
        String field = "stockmaterials";
        String bomField = "B";
        ArrayList<DynamicObject> saveMainStocks = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> saveBomStocks = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> savePlanStocks = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> saveGKStocks = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> saveProgrammeStocks = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> saveInnerProStocks = new ArrayList<DynamicObject>(16);
        if ("om_componentlist".equals(stockname)) {
            field = "feedtype";
            bomField = "E";
            srcbillentity = "srcbillentity";
            CreateStockUtils.putWWBaseData(saveStocks, baseData);
        } else if ("pom_mrostock".equals(stockname)) {
            field = "expandstock";
            bomField = "A";
        }
        for (DynamicObject saveStock : saveStocks) {
            DynamicObject tran = CreateStockUtils.getTran(saveStock, stockname, baseData);
            if (tran == null) {
                throw new KDBizException(new ErrorCode("PlanAutoGenerateStock", ResManager.loadKDString((String)"\u5de5\u5355\u4e8b\u52a1\u7c7b\u578b\u4e3a\u7a7a\u3002", (String)"CreateStockUtils_1", (String)"bd-mpdm-common", (Object[])new Object[0])), new Object[0]);
            }
            if ("D".equalsIgnoreCase(tran.getString(field))) {
                saveProgrammeStocks.add(saveStock);
                continue;
            }
            if ("expandstock".equals(field)) {
                if (!"A".equals(tran.getString(field))) continue;
                saveGKStocks.add(saveStock);
                continue;
            }
            boolean isInnerProcess = false;
            Long inStockorderEntryId = saveStock.getLong("orderentryid");
            DynamicObject orderEntry = baseData.getOrderEntry(inStockorderEntryId);
            if (("pom_mftstock".equals(stockname) || "om_mftstock".equals(stockname)) && orderEntry != null && orderEntry.containsProperty("noextendbom") && orderEntry.getBoolean("noextendbom")) continue;
            if ("pom_mftstock".equals(stockname) && orderEntry != null) {
                long srcorderentryid = orderEntry.getLong("srcorderentryid");
                long oprentryid = orderEntry.getLong("oprentryid");
                if (srcorderentryid != 0L && oprentryid != 0L) {
                    isInnerProcess = true;
                }
            }
            if (isInnerProcess) {
                saveInnerProStocks.add(saveStock);
                continue;
            }
            DynamicObject orderEntryDym = null;
            Map<Long, DynamicObject> orderEntryMap = baseData.getOrderEntryMap();
            if (null != orderEntryMap) {
                for (Map.Entry<Long, DynamicObject> entry : orderEntryMap.entrySet()) {
                    Long orderEntryIdInStock;
                    Long orderEntryId;
                    DynamicObject orderEntryDyn = entry.getValue();
                    if (null == orderEntryDyn || !(orderEntryId = Long.valueOf(orderEntryDyn.getLong("id"))).equals(orderEntryIdInStock = Long.valueOf(saveStock.getLong("orderentryid")))) continue;
                    orderEntryDym = orderEntryDyn;
                    break;
                }
            }
            String orderSrcbillentity = "";
            boolean materialspread = false;
            if (orderEntryDym != null) {
                orderSrcbillentity = orderEntryDym.getString(srcbillentity);
                materialspread = orderEntryDym.getBoolean("materialspread");
            }
            if (orderEntryDym != null && !materialspread && "mrp_planorder".equals(orderSrcbillentity)) {
                savePlanStocks.add(saveStock);
                continue;
            }
            if ("A".equals(tran.getString(field)) && !"pom_restructurbill".equals(orderSrcbillentity)) {
                saveBomStocks.add(saveStock);
                continue;
            }
            if (!bomField.equals(tran.getString(field)) || "pom_restructurbill".equals(orderSrcbillentity)) continue;
            saveMainStocks.add(saveStock);
        }
        long start = System.currentTimeMillis();
        if (!saveMainStocks.isEmpty()) {
            CreateStockUtils.getMainStocksBaseData(saveMainStocks, baseData);
            logger.info("\u83b7\u53d6\u7ec4\u4ef6\u6e05\u5355\u76f8\u5173\u57fa\u7840\u6570\u636e\u8017\u65f6(\u4e3b\u4ea7\u54c1\u5c55\u5f00)--------------" + (System.currentTimeMillis() - start));
            CreateStockUtils.expandMainStocks(saveMainStocks, baseData, stockname);
        }
        if (!saveBomStocks.isEmpty()) {
            logger.info("\u6309BOM\u5c55\u5f00");
            long startSaveBom = System.currentTimeMillis();
            CreateStockByBomUtils.expandBomStocks(saveBomStocks, baseData);
            logger.info("\u751f\u6210\u7ec4\u4ef6\u6e05\u5355\uff1a\u6309BOM\u5c55\u5f00\u8017\u65f6--------------" + (System.currentTimeMillis() - startSaveBom));
        }
        if (("B".equals(bomField) || "E".equals(bomField)) && !savePlanStocks.isEmpty()) {
            logger.info("\u6309\u8ba1\u5212\u8ba2\u5355\u5c55\u5f00");
            long startPlanStock = System.currentTimeMillis();
            CreateStockUtils.putPlanStockMap(baseData, stockname);
            CreateStockUtils.expandPlanStocks(savePlanStocks, baseData, stockname);
            logger.info("\u6309\u8ba1\u5212\u8ba2\u5355\u5c55\u5f00\u8017\u65f6--------------" + (System.currentTimeMillis() - startPlanStock));
        }
        if (!saveGKStocks.isEmpty()) {
            logger.info("\u6309\u5de5\u5361\u5c55\u5f00");
            CreateStockCardUtils.expandGKStocks(saveGKStocks, baseData, stockname);
        }
        if (!saveInnerProStocks.isEmpty()) {
            logger.info("\u5185\u534f\u52a0\u5de5\u7ec4\u4ef6\u6e05\u5355");
            InnerProStocksUtils.expandGKStocks(saveInnerProStocks, baseData, stockname);
        }
        if (!saveProgrammeStocks.isEmpty()) {
            logger.info("\u6309\u914d\u65b9\u5c55\u5f00");
            ProgrameOperateStockUtils.expandStocks(saveProgrammeStocks, baseData);
        }
    }

    private static void expandPlanStocks(List<DynamicObject> savePlanStocks, OrderBaseData baseData, String stockname) {
        Map<Long, DynamicObject> orderEntryMap = baseData.getOrderEntryMap();
        for (DynamicObject savePlanStock : savePlanStocks) {
            Long orderEntryId = savePlanStock.getLong("orderentryid");
            DynamicObject orderEntry = orderEntryMap.get(orderEntryId);
            if (orderEntry.getBoolean("materialspread") || !"om_componentlist".equals(stockname) && !"mrp_planorder".equals(orderEntry.getString("sourcebilltype"))) continue;
            CreateStockUtils.expandPlanStockentry(savePlanStock, orderEntry, baseData, stockname);
        }
        CreateStockUtils.setIsStep(savePlanStocks);
        MPDMMftGenStocksUtils.updateRepPid(savePlanStocks);
        CreateStockByBomUtils.setPStockEntryId(savePlanStocks);
    }

    private static void expandPlanStockentry(DynamicObject savePlanStock, DynamicObject orderEntry, OrderBaseData baseData, String stockname) {
        String planBillId;
        Map<Long, DynamicObject> planStockMap = baseData.getPlanStockMap();
        DynamicObject tran = null;
        if ("om_componentlist".equals(stockname)) {
            Long tranId = baseData.getOrderByEntryId((Long)orderEntry.getPkValue()).getLong("transactiontype");
            try {
                tran = WwTransactionTypeQueryHelper.getDataCacheByID(tranId);
            }
            catch (Exception e) {
                logger.info(e.getMessage());
            }
        } else {
            tran = baseData.getOrderByEntryId((Long)orderEntry.getPkValue()).getDynamicObject("transactiontype");
        }
        logger.info("\u8ba1\u5212\u5c55\u5f00\uff1a");
        String srcbillentryidStr = "sourceentryseq";
        if ("om_componentlist".equals(stockname)) {
            srcbillentryidStr = "srcbillentryid";
        }
        if ((planBillId = orderEntry.getString(srcbillentryidStr)) != null && !planBillId.isEmpty()) {
            DynamicObject stock = planStockMap.get(Long.parseLong(planBillId));
            boolean showjump = false;
            if (tran != null && tran.containsProperty("showjump")) {
                showjump = tran.getBoolean("showjump");
            }
            if (!showjump) {
                CreateStockUtils.removeJumpEntry(stock);
            }
            logger.info("\u8ba1\u5212\u5c55\u5f00\u7ec4\u4ef6\u6e05\u5355\u5355\u636e\u4f53\uff1a");
            savePlanStock.set("stockentry", stock.get("stockentry"));
            savePlanStock.set("sourcebillid", stock.get("sourcebillid"));
        }
        DynamicObject mtfOrg = savePlanStock.getDynamicObject("org");
        Long orgId = (Long)mtfOrg.getPkValue();
        Map<Long, DynamicObject> bomEntryMap = baseData.getBomEntryMap();
        DynamicObjectCollection stockEntrys = savePlanStock.getDynamicObjectCollection("stockentry");
        if (!CreateStockUtils.checkMterialErr(baseData, stockEntrys, orgId, savePlanStock)) {
            return;
        }
        for (DynamicObject stockEntry : stockEntrys) {
            DynamicObject orgfield;
            Map<String, DynamicObject> expandConfigMap;
            DynamicObject expandConfig;
            Long masterId = (Long)stockEntry.getDynamicObject("materielmasterid").getPkValue();
            DynamicObject orgMaterialMftInfo = baseData.getOrgMaterialMftInfo(orgId, masterId);
            if (orgMaterialMftInfo == null) continue;
            CreateStockUtils.setPlanQty(stockEntry, orgMaterialMftInfo);
            DynamicObject supplyorgid = stockEntry.getDynamicObject("supplyorgid");
            if (stockEntry.getBoolean("isbomextend")) {
                stockEntry.set("sourcetype", (Object)"A");
            } else {
                stockEntry.set("supplymode", (Object)"bos_org");
                stockEntry.set("sourcetype", (Object)"B");
            }
            String materialsource = "A";
            if (tran != null) {
                materialsource = tran.getString("materialsource");
            }
            DynamicObject entrysupplyorg = stockEntry.getDynamicObject("supplyorgid");
            DynamicObject entrywarehouse = stockEntry.getDynamicObject("warehouseid");
            DynamicObject entrylocation = stockEntry.getDynamicObject("location");
            DynamicObject bomEntry = bomEntryMap.get(stockEntry.getLong("bomentryid"));
            if ("B".equals(materialsource) || !stockEntry.getBoolean("isbomextend") || bomEntry == null) {
                CreateStockUtils.setStockEntryByMftInfoExPandWarehouse(stockEntry, orgMaterialMftInfo);
            } else {
                Object aux = stockEntry.get("childauxpropertyid");
                CreateStockUtils.setStockEntryByBomInfoExPandWarehouse(stockEntry, bomEntry);
                stockEntry.set("childauxpropertyid", aux);
            }
            if (stockEntry.getInt("priority") == 0) {
                stockEntry.set("pid", (Object)0L);
            } else {
                stockEntry.set("pid", (Object)1L);
            }
            if (supplyorgid != null) {
                stockEntry.set("supplyorgid", (Object)supplyorgid);
            }
            if ((expandConfig = (expandConfigMap = baseData.getExpandConfigMap()).get("ICreateStockExpandPlugin.setStockEntryByChild")) != null && !"".equals(expandConfig.getString("classpath"))) {
                try {
                    Class<?> clazz = Class.forName(expandConfig.getString("classpath"));
                    ICreateStockExpandPlugin newInstance = (ICreateStockExpandPlugin)clazz.newInstance();
                    newInstance.setStockEntryByChild(stockEntry, savePlanStock);
                }
                catch (Exception e) {
                    logger.info("\u7ec4\u4ef6\u6e05\u5355\u627e\u4e0d\u5230\u5b9e\u73b0\u7c7b");
                }
            }
            Object backflushtime = null;
            if (tran != null) {
                backflushtime = tran.get("backflushtime");
            }
            if ("B".equals(stockEntry.get("isbackflush"))) {
                stockEntry.set("backflushtime", backflushtime);
            } else {
                stockEntry.set("backflushtime", null);
            }
            if (PlanScopeHelper.isUsePlanscope() && !"om_componentlist".equals(stockname)) {
                if (stockEntry.getBoolean("isstockallot")) {
                    stockEntry.set("outorgunitid", (Object)entrysupplyorg);
                    stockEntry.set("outwarehouseid", (Object)entrywarehouse);
                    stockEntry.set("outlocation", (Object)entrylocation);
                }
                if (stockEntry.getBoolean("isstockallot") && !"om_mftstock".equals(stockname)) {
                    if ("B".equals(materialsource) || !stockEntry.getBoolean("isbomextend") || bomEntry == null) {
                        stockEntry.set("supplyorgid", (Object)orgMaterialMftInfo.getDynamicObject("supplyorgunitid"));
                        stockEntry.set("warehouseid", orgMaterialMftInfo.get("warehouse"));
                        stockEntry.set("location", orgMaterialMftInfo.get("location"));
                    } else {
                        stockEntry.set("supplyorgid", (Object)bomEntry.getDynamicObject("entrysupplyorg"));
                        stockEntry.set("warehouseid", bomEntry.get("entrywarehouse"));
                        stockEntry.set("location", bomEntry.get("entrylocation"));
                    }
                }
                if (stockEntry.getBoolean("isstockallot")) {
                    CreateStockUtils.setStockEntryWarehouse(mtfOrg, stockEntry, orderEntry, baseData);
                }
            } else if (stockEntry.get("warehouseid") == null) {
                if ("B".equals(materialsource) || !stockEntry.getBoolean("isbomextend") || bomEntry == null) {
                    stockEntry.set("supplyorgid", (Object)orgMaterialMftInfo.getDynamicObject("supplyorgunitid"));
                    stockEntry.set("warehouseid", orgMaterialMftInfo.get("warehouse"));
                    stockEntry.set("location", orgMaterialMftInfo.get("location"));
                } else {
                    stockEntry.set("supplyorgid", (Object)bomEntry.getDynamicObject("entrysupplyorg"));
                    stockEntry.set("warehouseid", bomEntry.get("entrywarehouse"));
                    stockEntry.set("location", bomEntry.get("entrylocation"));
                }
                CreateStockUtils.setStockEntryWarehouse(mtfOrg, stockEntry, orderEntry, baseData);
            }
            if (stockEntry.getDataEntityType().getProperties().containsKey((Object)"isjumplevel") && stockEntry.getBoolean("isjumplevel")) {
                stockEntry.set("issuemode", (Object)"C");
            }
            if (!"bos_org".equals(stockEntry.get("supplymode")) || (orgfield = (DynamicObject)stockEntry.get("supplyorgid")) == null) continue;
            stockEntry.set("supplierid", baseData.getSupply((Long)orgfield.getPkValue()));
        }
    }

    private static void removeJumpEntry(DynamicObject stock) {
        DynamicObjectCollection stockentrys = stock.getDynamicObjectCollection("stockentry");
        ArrayList<DynamicObject> stockentryList = new ArrayList<DynamicObject>(16);
        for (DynamicObject stockentry : stockentrys) {
            if (!stockentry.getBoolean("isjumplevel")) continue;
            stockentryList.add(stockentry);
        }
        if (!stockentryList.isEmpty()) {
            stockentrys.removeAll(stockentryList);
        }
    }

    public static boolean checkMterialErr(OrderBaseData baseData, DynamicObjectCollection stockEntrys, Long orgId, DynamicObject savePlanStock) {
        StringBuilder sb = new StringBuilder();
        for (DynamicObject stockEntry : stockEntrys) {
            DynamicObject orgMaterialMftInfo;
            DynamicObject master = stockEntry.getDynamicObject("materielmasterid");
            if (master == null || (orgMaterialMftInfo = baseData.getOrgMaterialMftInfo(orgId, (Long)master.getPkValue())) != null && orgMaterialMftInfo.getBoolean("enable") && "C".equalsIgnoreCase(orgMaterialMftInfo.getString("status"))) continue;
            if ("".equals(sb.toString())) {
                sb.append(master.getString("number"));
                continue;
            }
            sb.append(",");
            sb.append(master.getString("number"));
        }
        if (!"".equals(sb.toString())) {
            Long orderEntryId = CreateStockByBomUtils.getOrderEntryIdByStock(savePlanStock);
            CreateStockUtils.setErr(orderEntryId, baseData, String.format(ResManager.loadKDString((String)"\u751f\u6210\u7ec4\u4ef6\u6e05\u5355\u5931\u8d25\uff1a\u4e0d\u5b58\u5728\u7269\u6599\uff08\u7f16\u7801\uff1a%s\uff09\u53ef\u7528\u7684\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u3002", (String)"CreateStockUtils_8", (String)"bd-mpdm-common", (Object[])new Object[0]), sb.toString()), savePlanStock);
            return false;
        }
        return true;
    }

    private static void setPlanQty(DynamicObject stockEntry, DynamicObject orgMaterialMftInfo) {
        Boolean isquotacontrol = orgMaterialMftInfo.get(ISQUOTACONTROL2) != null && orgMaterialMftInfo.getBoolean(ISQUOTACONTROL2);
        if (isquotacontrol.booleanValue()) {
            stockEntry.set("overissuecontrl", (Object)"B");
            stockEntry.set("issinhighlimit", orgMaterialMftInfo.get("issinhighlimit"));
            stockEntry.set("extraratioqty", (Object)stockEntry.getBigDecimal("demandqty").multiply(BigDecimal.ONE.add(orgMaterialMftInfo.getBigDecimal("issinhighlimit").divide(BigDecimal.valueOf(100L), 4, 4))));
            stockEntry.set("issinlowlimit", orgMaterialMftInfo.get("issinlowlimit"));
            stockEntry.set("lackraitioqty", (Object)stockEntry.getBigDecimal("demandqty").multiply(BigDecimal.ONE.subtract(orgMaterialMftInfo.getBigDecimal("issinlowlimit").divide(BigDecimal.valueOf(100L), 4, 4))));
        } else {
            stockEntry.set("overissuecontrl", (Object)"A");
            stockEntry.set("extraratioqty", stockEntry.get("demandqty"));
            stockEntry.set("lackraitioqty", stockEntry.get("demandqty"));
        }
        stockEntry.set("cansendqty", MPDMMftGenStocksUtils.aculCanSendQty(stockEntry));
        stockEntry.set("unissueqty", MPDMMftGenStocksUtils.aculUnSendQty(stockEntry));
    }

    public static DynamicObject getTran(DynamicObject saveStock, String stockname, OrderBaseData baseData) {
        if ("om_componentlist".equals(stockname)) {
            return baseData.getWwTranMapById(saveStock.get("transactiontypeid"));
        }
        return saveStock.getDynamicObject("transactiontypeid");
    }

    public static void setIsStep(List<DynamicObject> saveBomStocks) {
        HashSet<Long> bomEntryIdSet = new HashSet<Long>(16);
        for (DynamicObject saveBomStock : saveBomStocks) {
            DynamicObjectCollection stockEntrys = saveBomStock.getDynamicObjectCollection("stockentry");
            for (DynamicObject stockEntry : stockEntrys) {
                bomEntryIdSet.add(stockEntry.getLong("bomentryid"));
            }
        }
        if (bomEntryIdSet == null || bomEntryIdSet.isEmpty()) {
            return;
        }
        Map<Long, DynamicObject> bomentryMap = MsBomQueryHelper.getBomEntryFromCache(bomEntryIdSet);
        HashMap<Long, Boolean> stepMap = new HashMap<Long, Boolean>(16);
        if (bomentryMap == null || bomentryMap.size() < 1) {
            return;
        }
        for (Map.Entry<Long, DynamicObject> entry : bomentryMap.entrySet()) {
            DynamicObject query = entry.getValue();
            if (!"C".equals(query.getString("entryqtytype"))) continue;
            stepMap.put(query.getLong("id"), Boolean.TRUE);
        }
        for (DynamicObject saveBomStock : saveBomStocks) {
            DynamicObjectCollection stockEntrys = saveBomStock.getDynamicObjectCollection("stockentry");
            for (DynamicObject stockEntry : stockEntrys) {
                if (stepMap != null && stepMap.containsKey(stockEntry.getLong("bomentryid"))) {
                    stockEntry.set("isstep", (Object)Boolean.TRUE);
                    continue;
                }
                stockEntry.set("isstep", (Object)Boolean.FALSE);
            }
        }
    }

    private static void getMainStocksBaseData(List<DynamicObject> saveMainStocks, OrderBaseData baseData) {
        HashSet<Long> orgIdSet = new HashSet<Long>(16);
        HashMap<Long, Set<Long>> orgMasterMap = new HashMap<Long, Set<Long>>(16);
        HashSet<Long> supplyOrgIdSet = new HashSet<Long>(16);
        for (DynamicObject saveMainStock : saveMainStocks) {
            DynamicObject org = saveMainStock.getDynamicObject("org");
            Long orgId = (Long)org.getPkValue();
            orgIdSet.add(orgId);
            HashSet<Long> masterSet = (HashSet<Long>)orgMasterMap.get(orgId);
            if (masterSet == null) {
                masterSet = new HashSet<Long>(16);
            }
            masterSet.add((Long)saveMainStock.getDynamicObject(PRODUCTMASTERID).getPkValue());
            orgMasterMap.put(orgId, masterSet);
        }
        HashMap<Long, Object> orgMasterWastMap = new HashMap<Long, Object>(orgIdSet.size());
        HashMap<Long, Object> orgMaterialMftInfoMap = new HashMap<Long, Object>(orgIdSet.size());
        Map<Long, Map<Long, DynamicObject>> orgMaterialPlanInfoMap = baseData.getOrgMaterialPlanInfoMap();
        for (Long orgId : orgIdSet) {
            CreateStockUtils.getInfoByMaster(orgId, orgMasterWastMap, orgMaterialMftInfoMap, orgMaterialPlanInfoMap, orgMasterMap, supplyOrgIdSet, baseData);
        }
        HashMap<Long, Object> supplyMap = new HashMap<Long, Object>(16);
        CreateStockUtils.getSupplyMap(supplyMap, supplyOrgIdSet);
        baseData.setOrgMasterWastMap(orgMasterWastMap);
        baseData.setOrgMaterialMftInfoMap(orgMaterialMftInfoMap);
        baseData.setSupplyMap(supplyMap);
    }

    public static void getInfoByMaster(Long orgId, Map<Long, Object> orgMasterWastMap, Map<Long, Object> orgMaterialMftInfoMap, Map<Long, Set<Long>> orgMasterMap, Set<Long> supplyOrgIdSet) {
        Set<Long> masterSet = orgMasterMap.get(orgId);
        Map<Object, DynamicObject> planMap = MaterialPlanQueryHelper.getDataCacheByMaterialSet(masterSet, orgId);
        HashMap<Long, String> masterWastagerateformulaMap = (HashMap<Long, String>)orgMasterWastMap.get(orgId);
        if (masterWastagerateformulaMap == null) {
            masterWastagerateformulaMap = new HashMap<Long, String>(16);
        }
        for (Map.Entry<Object, DynamicObject> loadMap : planMap.entrySet()) {
            DynamicObject load = loadMap.getValue();
            if (load == null) continue;
            masterWastagerateformulaMap.put((Long)load.getDynamicObject("masterid").getPkValue(), load.getString("wastagerateformula"));
        }
        Map<Object, DynamicObject> mftMap = MaterialMftQueryHelper.getDataCacheByMaterialSet(masterSet, orgId);
        HashMap<Long, DynamicObject> materialMftInfoMap = (HashMap<Long, DynamicObject>)orgMaterialMftInfoMap.get(orgId);
        if (materialMftInfoMap == null) {
            materialMftInfoMap = new HashMap<Long, DynamicObject>(16);
        }
        for (Map.Entry<Object, DynamicObject> loadMap : mftMap.entrySet()) {
            DynamicObject load = loadMap.getValue();
            if (load == null) continue;
            materialMftInfoMap.put((Long)load.getDynamicObject("masterid").getPkValue(), load);
            DynamicObject supply = load.getDynamicObject("supplyorgunitid");
            if (supply == null) continue;
            supplyOrgIdSet.add((Long)supply.getPkValue());
        }
        orgMasterWastMap.put(orgId, masterWastagerateformulaMap);
        orgMaterialMftInfoMap.put(orgId, materialMftInfoMap);
    }

    public static void getInfoByMaster(Long orgId, Map<Long, Object> orgMasterWastMap, Map<Long, Object> orgMaterialMftInfoMap, Map<Long, Map<Long, DynamicObject>> orgMaterialPlanInfoMap, Map<Long, Set<Long>> orgMasterMap, Set<Long> supplyOrgIdSet, OrderBaseData baseData) {
        CreateStockUtils.getMaterialPlanInfoByMaster(orgId, orgMasterWastMap, orgMaterialPlanInfoMap, orgMasterMap, baseData);
        CreateStockUtils.getMaterialMftInfoByMaster(orgId, orgMaterialMftInfoMap, orgMasterMap, supplyOrgIdSet);
    }

    private static void expandMainStocks(List<DynamicObject> saveMainStocks, OrderBaseData baseData, String stockname) {
        if (saveMainStocks.isEmpty()) {
            return;
        }
        ORM orm = ORM.create();
        Map<Long, DynamicObject> orderEntryMap = baseData.getOrderEntryMap();
        for (DynamicObject saveMainStock : saveMainStocks) {
            DynamicObjectCollection stockEntrys = saveMainStock.getDynamicObjectCollection("stockentry");
            Long orderEntryId = saveMainStock.getLong("orderentryid");
            DynamicObject stockEntry = CreateStockUtils.getNewDynamicObject(stockname + ".stockentry", orm);
            DynamicObject orderEntry = orderEntryMap.get(orderEntryId);
            stockEntrys.add((Object)stockEntry);
            CreateStockUtils.expandMainStockentry(stockEntry, saveMainStock, orderEntry, baseData, stockname);
            stockEntry.set("sourcetype", (Object)"B");
        }
        CreateStockUtils.setStockWareHouse(saveMainStocks, baseData);
    }

    private static Long getPkid(Object obj) {
        Long objId = 0L;
        if (obj instanceof DynamicObject) {
            objId = ((DynamicObject)obj).getLong("id");
        } else if (obj instanceof Long) {
            objId = (Long)obj;
        } else if (obj instanceof String) {
            objId = NumberUtils.toLong((String)obj.toString());
        }
        return objId;
    }

    public static DynamicObject getNewDynamicObject(String name, ORM orm) {
        return orm.newDynamicObject(name);
    }

    private static void expandMainStockentry(DynamicObject stockEntry, DynamicObject saveMainStock, DynamicObject orderEntry, OrderBaseData baseData, String stockname) {
        DynamicObject mtfOrg = saveMainStock.getDynamicObject("org");
        Long orgId = (Long)mtfOrg.getPkValue();
        DynamicObject tran = CreateStockUtils.getTran(saveMainStock, stockname, baseData);
        DynamicObject master = saveMainStock.getDynamicObject(PRODUCTMASTERID);
        DynamicObject entryunit = orderEntry.getDynamicObject("baseunit");
        Long masterId = (Long)master.getPkValue();
        if ("om_componentlist".equals(stockname)) {
            stockEntry.set("demanddate", orderEntry.get("deliverdate"));
            stockEntry.set("childauxpropertyid", orderEntry.get("auxpty"));
        } else {
            Date planbegintime = orderEntry.getDate("planbegintime");
            Date planendtime = orderEntry.getDate("planendtime");
            stockEntry.set("demanddate", (Object)MPDMMftGenStocksUtils.getDemandDate(mtfOrg, planbegintime, stockEntry, planendtime));
            if (orderEntry.getDynamicObject("bomid") == null) {
                stockEntry.set("bomreversion", null);
            } else {
                stockEntry.set("bomreversion", orderEntry.getDynamicObject("bomid").get("version"));
            }
            stockEntry.set("childauxpropertyid", orderEntry.get("auxproperty"));
            stockEntry.set("lot", orderEntry.get("lot"));
        }
        stockEntry.set("batchno", orderEntry.get("batchno"));
        String orgMasterWast = baseData.getOrgMasterWast(orgId, masterId);
        DynamicObject orgMaterialMftInfo = baseData.getOrgMaterialMftInfo(orgId, masterId);
        if (orgMaterialMftInfo == null || !orgMaterialMftInfo.getBoolean("enable") || !"C".equalsIgnoreCase(orgMaterialMftInfo.getString("status"))) {
            Long orderEntryId = (Long)orderEntry.getPkValue();
            CreateStockUtils.setErr(orderEntryId, baseData, String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7269\u6599\uff08\u7f16\u7801\uff1a%s\uff09\u53ef\u7528\u7684\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u3002", (String)"CreateStockUtils_7", (String)"bd-mpdm-common", (Object[])new Object[0]), master.getString("number")), saveMainStock);
            return;
        }
        boolean isconsiderloss = false;
        if (tran != null) {
            isconsiderloss = tran.getBoolean("isconsiderloss");
        }
        String wastagerateformula = "B";
        if (orgMasterWast != null) {
            wastagerateformula = orgMasterWast;
        } else if (!isconsiderloss) {
            wastagerateformula = "";
        }
        CreateStockUtils.setStockEntryByMftInfoExPandWarehouse(stockEntry, orgMaterialMftInfo);
        stockEntry.set("entryconfiguredcode", orderEntry.get("configuredcode"));
        stockEntry.set("supplymode", (Object)"bos_org");
        stockEntry.set("materielmasterid", (Object)master);
        stockEntry.set("materialunitid", (Object)entryunit);
        CreateStockUtils.setMainDefault(stockEntry);
        stockEntry.set("wastagerateformula", (Object)wastagerateformula);
        Object backflushtime = null;
        if (tran != null) {
            backflushtime = tran.get("backflushtime");
        }
        if ("B".equals(orgMaterialMftInfo.get("isbackflush"))) {
            stockEntry.set("backflushtime", backflushtime);
        } else {
            stockEntry.set("backflushtime", null);
        }
        CreateStockUtils.setMainQty(stockEntry, orderEntry, orgMaterialMftInfo, isconsiderloss);
    }

    public static void setErr(Long orderEntryId, OrderBaseData baseData, String format, DynamicObject saveBomStock) {
        DynamicObject order = baseData.getOrderByEntryId(orderEntryId);
        Map<Long, String> orderErrInfoMap = baseData.getOrderErrInfoMap();
        String err = orderErrInfoMap.get(order.getPkValue());
        err = err == null ? format : String.format("%s,%s", err, format);
        orderErrInfoMap.put((Long)order.getPkValue(), err);
        baseData.setOrderErrInfoMap(orderErrInfoMap);
        List<DynamicObject> saveStocks = baseData.getSaveStocks();
        saveStocks.remove(saveBomStock);
    }

    private static void setMainDefault(DynamicObject stockEntry) {
        stockEntry.set("seq", (Object)1);
        stockEntry.set("isbomextend", (Object)false);
        stockEntry.set("rework", (Object)Boolean.TRUE);
        stockEntry.set("qtytype", (Object)"A");
        stockEntry.set("useratio", (Object)100);
        stockEntry.set("qtynumerator", (Object)BigDecimal.ONE);
        stockEntry.set("qtydenominator", (Object)BigDecimal.ONE);
        stockEntry.set("fixscrap", (Object)BigDecimal.ZERO);
        stockEntry.set("scraprate", (Object)BigDecimal.ZERO);
    }

    public static void setMainQty(DynamicObject stockEntry, DynamicObject orderEntry, DynamicObject orgMaterialMftInfo, boolean isconsiderloss) {
        DynamicObject entryunit = orderEntry.getDynamicObject("baseunit");
        String wastagerateformula = stockEntry.getString("wastagerateformula");
        int precision = MPDMMftGenStocksUtils.getPrecision(entryunit);
        String qtyType = stockEntry.getString("qtytype");
        BigDecimal useratio = stockEntry.getBigDecimal("useratio").divide(BigDecimal.valueOf(100L), 4, 4);
        BigDecimal qtynumerator = stockEntry.getBigDecimal("qtynumerator");
        BigDecimal qtydenominator = stockEntry.getBigDecimal("qtydenominator");
        BigDecimal baseqty = orderEntry.getBigDecimal("baseqty");
        BigDecimal standqty = MPDMMftGenStocksUtils.calculateStandQty(entryunit, qtyType, useratio, baseqty, qtynumerator, qtydenominator);
        BigDecimal scraprate = stockEntry.getBigDecimal("scraprate");
        BigDecimal fixscrap = stockEntry.getBigDecimal("fixscrap");
        BigDecimal demandQty = MPDMMftGenStocksUtils.calculateDemadQty(precision, isconsiderloss, standqty, scraprate, fixscrap, wastagerateformula);
        stockEntry.set("standqty", (Object)standqty);
        stockEntry.set("demandqty", (Object)demandQty);
        Boolean isquotacontrol = orgMaterialMftInfo.get(ISQUOTACONTROL2) != null && orgMaterialMftInfo.getBoolean(ISQUOTACONTROL2);
        if (isquotacontrol.booleanValue()) {
            stockEntry.set("overissuecontrl", (Object)"B");
            stockEntry.set("issinhighlimit", orgMaterialMftInfo.get("issinhighlimit"));
            stockEntry.set("extraratioqty", (Object)stockEntry.getBigDecimal("demandqty").multiply(BigDecimal.ONE.add(orgMaterialMftInfo.getBigDecimal("issinhighlimit").divide(BigDecimal.valueOf(100L), 4, 4))));
            stockEntry.set("issinlowlimit", orgMaterialMftInfo.get("issinlowlimit"));
            stockEntry.set("lackraitioqty", (Object)stockEntry.getBigDecimal("demandqty").multiply(BigDecimal.ONE.subtract(orgMaterialMftInfo.getBigDecimal("issinlowlimit").divide(BigDecimal.valueOf(100L), 4, 4))));
        } else {
            stockEntry.set("overissuecontrl", (Object)"A");
            stockEntry.set("extraratioqty", stockEntry.get("demandqty"));
            stockEntry.set("lackraitioqty", stockEntry.get("demandqty"));
        }
        stockEntry.set("cansendqty", MPDMMftGenStocksUtils.aculCanSendQty(stockEntry));
        stockEntry.set("unissueqty", MPDMMftGenStocksUtils.aculUnSendQty(stockEntry));
    }

    public static void setStockEntryByMftInfo(DynamicObject stockEntry, DynamicObject orgMaterialMftInfo) {
        stockEntry.set("materialid", (Object)orgMaterialMftInfo);
        stockEntry.set("iskeypart", orgMaterialMftInfo.get("iskeypart"));
        stockEntry.set("considerminbatch", orgMaterialMftInfo.get("considerminbatch"));
        String issuemodestr = MPDMMftGenStocksUtils.getIssuemode(orgMaterialMftInfo.get("issuemode"));
        stockEntry.set("issuemode", (Object)issuemodestr);
        stockEntry.set("supplyorgid", (Object)orgMaterialMftInfo.getDynamicObject("supplyorgunitid"));
        stockEntry.set("warehouseid", orgMaterialMftInfo.get("warehouse"));
        stockEntry.set("location", orgMaterialMftInfo.get("location"));
        stockEntry.set("isbulkmaterial", orgMaterialMftInfo.get("isbulkmaterial"));
        stockEntry.set("isstockallot", orgMaterialMftInfo.get("isstockallot"));
        stockEntry.set("isbackflush", orgMaterialMftInfo.get("isbackflush"));
        stockEntry.set("outorgunitid", orgMaterialMftInfo.get("outstorageunit"));
        stockEntry.set("outwarehouseid", orgMaterialMftInfo.get("outwarehouse"));
        stockEntry.set("outorgunitid", orgMaterialMftInfo.get("outstorageunit"));
        stockEntry.set("outwarehouseid", orgMaterialMftInfo.get("outwarehouse"));
        stockEntry.set("outlocation", orgMaterialMftInfo.get("outwarelocation"));
        DataEntityPropertyCollection properties = stockEntry.getDataEntityType().getProperties();
        if (properties.containsKey((Object)"processseq")) {
            stockEntry.set("processseq", (Object)"1");
            stockEntry.set("oprno", (Object)"10");
        }
    }

    public static void setStockEntryByMftInfoExPandWarehouse(DynamicObject stockEntry, DynamicObject orgMaterialMftInfo) {
        stockEntry.set("materialid", (Object)orgMaterialMftInfo);
        stockEntry.set("iskeypart", orgMaterialMftInfo.get("iskeypart"));
        stockEntry.set("considerminbatch", orgMaterialMftInfo.get("considerminbatch"));
        String issuemodestr = MPDMMftGenStocksUtils.getIssuemode(orgMaterialMftInfo.get("issuemode"));
        stockEntry.set("issuemode", (Object)issuemodestr);
        stockEntry.set("isbulkmaterial", orgMaterialMftInfo.get("isbulkmaterial"));
        stockEntry.set("isstockallot", orgMaterialMftInfo.get("isstockallot"));
        stockEntry.set("isbackflush", orgMaterialMftInfo.get("isbackflush"));
        stockEntry.set("outorgunitid", orgMaterialMftInfo.get("outstorageunit"));
        stockEntry.set("outwarehouseid", orgMaterialMftInfo.get("outwarehouse"));
        stockEntry.set("outorgunitid", orgMaterialMftInfo.get("outstorageunit"));
        stockEntry.set("outwarehouseid", orgMaterialMftInfo.get("outwarehouse"));
        stockEntry.set("outlocation", orgMaterialMftInfo.get("outwarelocation"));
        DataEntityPropertyCollection properties = stockEntry.getDataEntityType().getProperties();
        if (properties.containsKey((Object)"processseq")) {
            stockEntry.set("processseq", (Object)"1");
            stockEntry.set("oprno", (Object)"10");
        }
    }

    public static void setStockEntryByBomInfo(DynamicObject stockEntry, DynamicObject bomEntry) {
        if (bomEntry == null) {
            logger.info("bom\u5206\u5f55id\u5bf9\u5e94\u7684bom\u4e3a\u7a7a\uff0c" + stockEntry.getLong("bomentryid"));
            return;
        }
        stockEntry.set("iskeypart", bomEntry.get("entryiskey"));
        String issuemodestr = MPDMMftGenStocksUtils.getIssuemode(bomEntry.get("entryissuemode"));
        stockEntry.set("issuemode", (Object)issuemodestr);
        stockEntry.set("isbulkmaterial", bomEntry.get("entryisbulkmaterial"));
        stockEntry.set("isstockallot", bomEntry.get("entryisstockalloc"));
        stockEntry.set("isbackflush", bomEntry.get("entryisbackflush"));
        stockEntry.set("supplyorgid", (Object)bomEntry.getDynamicObject("entrysupplyorg"));
        stockEntry.set("warehouseid", bomEntry.get("entrywarehouse"));
        stockEntry.set("location", bomEntry.get("entrylocation"));
        stockEntry.set("outorgunitid", bomEntry.get("entryoutorg"));
        stockEntry.set("outwarehouseid", bomEntry.get("entryoutwarehouse"));
        stockEntry.set("outlocation", bomEntry.get("entryoutlocation"));
        stockEntry.set("supplymode", bomEntry.get("entryownertype"));
        stockEntry.set("childauxpropertyid", bomEntry.get("entryauxproperty"));
        stockEntry.set("oprno", bomEntry.get("entryoperationnumber"));
        DataEntityPropertyCollection properties = stockEntry.getDataEntityType().getProperties();
        if (properties.containsKey((Object)"processseq")) {
            stockEntry.set("processseq", bomEntry.get("entryprocessseq"));
        }
    }

    public static void setStockEntryByBomInfoExPandWarehouse(DynamicObject stockEntry, DynamicObject bomEntry) {
        if (bomEntry == null) {
            logger.info("bom\u5206\u5f55id\u5bf9\u5e94\u7684bom\u4e3a\u7a7a\uff0c" + stockEntry.getLong("bomentryid"));
            return;
        }
        stockEntry.set("iskeypart", bomEntry.get("entryiskey"));
        String issuemodestr = MPDMMftGenStocksUtils.getIssuemode(bomEntry.get("entryissuemode"));
        stockEntry.set("issuemode", (Object)issuemodestr);
        stockEntry.set("isbulkmaterial", bomEntry.get("entryisbulkmaterial"));
        stockEntry.set("isstockallot", bomEntry.get("entryisstockalloc"));
        stockEntry.set("isbackflush", bomEntry.get("entryisbackflush"));
        stockEntry.set("outorgunitid", bomEntry.get("entryoutorg"));
        stockEntry.set("outwarehouseid", bomEntry.get("entryoutwarehouse"));
        stockEntry.set("outlocation", bomEntry.get("entryoutlocation"));
        stockEntry.set("supplymode", bomEntry.get("entryownertype"));
        stockEntry.set("supplierid", bomEntry.get("entryowner"));
        stockEntry.set("childauxpropertyid", bomEntry.get("entryauxproperty"));
        stockEntry.set("oprno", bomEntry.get("entryoperationnumber"));
        DataEntityPropertyCollection properties = stockEntry.getDataEntityType().getProperties();
        if (properties.containsKey((Object)"processseq")) {
            stockEntry.set("processseq", bomEntry.get("entryprocessseq"));
        }
    }

    public static OrderBaseData getOrderBasedataMap(List<DynamicObject> orderList, String stockname) {
        OrderBaseData baseData = new OrderBaseData();
        String orderName = EntityNameUtils.getEntityName(1, 0, stockname);
        ArrayList<String> orderIdList = new ArrayList<String>(orderList.size());
        for (DynamicObject order : orderList) {
            orderIdList.add(order.getPkValue().toString());
        }
        CreateStockUtils.putStockMap(orderIdList, baseData, stockname);
        CreateStockUtils.putOrderMap(orderList, baseData, stockname);
        CreateStockUtils.putStockCodeMap(orderList, baseData, stockname);
        QFilter orderfilter = new QFilter("order", "=", (Object)orderName);
        QFilter stockfilter = new QFilter("stock", "=", (Object)stockname);
        DynamicObject ordertostockDym = BusinessDataServiceHelper.loadSingleFromCache((String)"mpdm_ordertostock", (String)"otsentry,otsentry.entityname,otsentryentity,otsentryentity.orderident,otsentryentity.stockident", (QFilter[])new QFilter[]{orderfilter, stockfilter});
        baseData.setOrdertostockDym(ordertostockDym);
        baseData.setBilltypeObj(BillTypeQueryHelper.getBillTypesCache((String)stockname));
        baseData.setUser(UserServiceHelper.getCurrentUser((String)"id"));
        baseData.setNowDate(TimeServiceHelper.now());
        return baseData;
    }

    private static void putPlanStockMap(OrderBaseData baseData, String stockname) {
        Map<Long, DynamicObject> orderEntryMap = baseData.getOrderEntryMap();
        HashSet<Long> planIdList = new HashSet<Long>(10);
        for (Map.Entry<Long, DynamicObject> m : orderEntryMap.entrySet()) {
            String planBillId;
            DynamicObject orderEntry = m.getValue();
            if (orderEntry.getBoolean("materialspread") || !"om_componentlist".equals(stockname) && !"mrp_planorder".equals(orderEntry.getString("sourcebilltype"))) continue;
            String srcbillentryidStr = "sourceentryseq";
            if ("om_componentlist".equals(stockname)) {
                srcbillentryidStr = "srcbillentryid";
            }
            if ((planBillId = orderEntry.getString(srcbillentryidStr)) == null || planBillId.isEmpty()) continue;
            planIdList.add(Long.parseLong(planBillId));
        }
        if (!planIdList.isEmpty()) {
            Map<Long, DynamicObject> planStockMap = CreateStockUtils.planToStock(planIdList, stockname);
            baseData.setPlanStockMap(planStockMap);
            CreateStockUtils.setPlanStockBaseData(baseData);
        }
    }

    private static void setPlanStockBaseData(OrderBaseData baseData) {
        Map<Long, DynamicObject> planStockMap = baseData.getPlanStockMap();
        HashSet<Long> orgIdSet = new HashSet<Long>(16);
        HashMap<Long, Set<Long>> orgMasterMap = new HashMap<Long, Set<Long>>(16);
        HashSet<Long> supplyOrgIdSet = new HashSet<Long>(16);
        HashSet<Long> bomEntryIdSet = new HashSet<Long>(16);
        for (Map.Entry<Long, DynamicObject> r : planStockMap.entrySet()) {
            DynamicObject stock = r.getValue();
            DynamicObject org = stock.getDynamicObject("org");
            Long orgId = (Long)org.getPkValue();
            orgIdSet.add(orgId);
            HashSet<Long> masterSet = (HashSet<Long>)orgMasterMap.get(orgId);
            if (masterSet == null) {
                masterSet = new HashSet<Long>(16);
            }
            for (DynamicObject stockEntry : stock.getDynamicObjectCollection("stockentry")) {
                DynamicObject proMaster = stockEntry.getDynamicObject("materielmasterid");
                masterSet.add((Long)proMaster.getPkValue());
                bomEntryIdSet.add(stockEntry.getLong("bomentryid"));
            }
            orgMasterMap.put(orgId, masterSet);
        }
        Map<Long, Object> orgMasterWastMap = baseData.getOrgMasterWastMap();
        Map<Long, Object> orgMaterialMftInfoMap = baseData.getOrgMaterialMftInfoMap();
        Map<Long, Map<Long, DynamicObject>> orgMaterialPlanInfoMap = baseData.getOrgMaterialPlanInfoMap();
        for (Long orgId : orgIdSet) {
            CreateStockUtils.getInfoByMaster(orgId, orgMasterWastMap, orgMaterialMftInfoMap, orgMaterialPlanInfoMap, orgMasterMap, supplyOrgIdSet, baseData);
        }
        Map<Long, Object> supplyMap = baseData.getSupplyMap();
        CreateStockUtils.getSupplyMap(supplyMap, supplyOrgIdSet);
        CreateStockUtils.setBomEntryMapById(bomEntryIdSet, baseData);
        baseData.setOrgMasterWastMap(orgMasterWastMap);
        baseData.setOrgMaterialMftInfoMap(orgMaterialMftInfoMap);
        baseData.setSupplyMap(supplyMap);
    }

    public static void getSupplyMap(Map<Long, Object> supplyMap, Set<Long> supplyOrgIdSet) {
        if (!supplyOrgIdSet.isEmpty()) {
            Map loadFromCache = OrgQueryHelper.getOrgBySet(supplyOrgIdSet);
            for (Long supplyOrgId : supplyOrgIdSet) {
                List<Object> owners = MPDMMftGenStocksUtils.getOwners(supplyOrgId);
                DynamicObject supplyOrg = (DynamicObject)loadFromCache.get(supplyOrgId);
                if (((Boolean)supplyOrg.get("fisaccounting")).booleanValue()) {
                    owners.add(supplyOrg.getPkValue());
                }
                if (owners.isEmpty()) continue;
                supplyMap.put(supplyOrgId, owners.get(0));
            }
        }
    }

    public static void setBomEntryMapById(Set<Long> bomEntryIdSet, OrderBaseData baseData) {
        Map<Long, DynamicObject> bomEntryMap = baseData.getBomEntryMap();
        bomEntryMap = MsBomQueryHelper.getBomEntryFromCache(bomEntryIdSet);
        baseData.setBomEntryMap(bomEntryMap);
    }

    private static Map<Long, DynamicObject> planToStock(Set<Long> planIdList, String stockname) {
        HashMap<Long, DynamicObject> planStockMap = new HashMap<Long, DynamicObject>(1);
        String orderName = "mrp_planorder";
        PushArgs pushArgs = new PushArgs();
        pushArgs.setTargetEntityNumber(stockname);
        pushArgs.setHasRight(true);
        pushArgs.setRuleId("1361593636919432192");
        pushArgs.setBuildConvReport(true);
        if (stockname.equals("om_mftstock")) {
            pushArgs.setRuleId("1365917676513389568");
        } else if (StringUtils.equals((CharSequence)"om_componentlist", (CharSequence)stockname)) {
            pushArgs.setRuleId("1513758473144307712");
        }
        pushArgs.setSourceEntityNumber(orderName);
        ArrayList<ListSelectedRow> needPushRows = new ArrayList<ListSelectedRow>(16);
        for (Long planId : planIdList) {
            ListSelectedRow srcBill = new ListSelectedRow((Object)planId);
            needPushRows.add(srcBill);
        }
        pushArgs.setSelectedRows(needPushRows);
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)stockname);
        if (!pushResult.isSuccess()) {
            logger.info("\u8ba1\u5212\u8ba2\u5355\u4e0b\u63a8\u7ec4\u4ef6\u6e05\u5355\u5355\u5931\u8d25:" + MPDMMftGenStocksUtils.getErrByRes(pushResult));
            throw new KDBizException(new ErrorCode("PlanAutoGenerateStock", MPDMMftGenStocksUtils.getErrByRes(pushResult)), new Object[0]);
        }
        List targetBillObjs = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
        for (DynamicObject targetBillObj : targetBillObjs) {
            planStockMap.put(targetBillObj.getLong("sourcebillid"), targetBillObj);
        }
        return planStockMap;
    }

    private static void putWWBaseData(List<DynamicObject> stocks, OrderBaseData baseData) {
        HashSet<Object> tranList = new HashSet<Object>(stocks.size());
        for (DynamicObject stock : stocks) {
            Object orderEntryObj = stock.get("transactiontypeid");
            Object newObj = orderEntryObj instanceof DynamicObject ? ((DynamicObject)orderEntryObj).getPkValue() : orderEntryObj;
            tranList.add(newObj);
        }
        Map<Object, DynamicObject> wwtran = WwTransactionTypeQueryHelper.getDataCacheBySet(tranList);
        baseData.setWwTranMap(wwtran);
    }

    public static void putStockCodeMap(List<DynamicObject> orderList, OrderBaseData baseData, String stockname) {
        HashSet<String> orgIdSet = new HashSet<String>(16);
        for (DynamicObject order : orderList) {
            DynamicObject org = order.getDynamicObject("org");
            orgIdSet.add(org.getPkValue().toString());
        }
        ORM orm = ORM.create();
        DynamicObject orderStock = orm.newDynamicObject(stockname);
        HashMap<String, CodeRuleInfo> codeRuleInfoMap = new HashMap<String, CodeRuleInfo>(orgIdSet.size());
        for (String orgId : orgIdSet) {
            CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)stockname, (DynamicObject)orderStock, (String)orgId);
            codeRuleInfoMap.put(orgId, codeRuleInfo);
        }
        baseData.setCodeRuleInfoMap(codeRuleInfoMap);
    }

    public static void putOrderMap(List<DynamicObject> orderList, OrderBaseData baseData, String stockname) {
        HashMap<Long, DynamicObject> orderMap = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, DynamicObject> orderEntryMap = new HashMap<Long, DynamicObject>(16);
        ArrayList<Long> orderEntryList = new ArrayList<Long>(16);
        String orderName = EntityNameUtils.getEntityName(1, 0, stockname);
        String orderEntryName = CreateStockUtils.getOrderEntryName(orderName);
        HashSet<String> orgIdSet = new HashSet<String>(16);
        for (DynamicObject order : orderList) {
            DynamicObject org = order.getDynamicObject("org");
            orgIdSet.add(org.getPkValue().toString());
            DynamicObjectCollection entrys = order.getDynamicObjectCollection(orderEntryName);
            if (entrys == null) continue;
            for (DynamicObject entry : entrys) {
                DynamicObject linetype;
                String producttype;
                if (!"pm_om_purorderbill".equals(orderName) ? !StringUtils.equals((CharSequence)"C", (CharSequence)(producttype = entry.getString("producttype"))) : !(linetype = entry.getDynamicObject("linetype")).getBoolean("storage")) continue;
                Long pkValue = (Long)entry.getPkValue();
                orderMap.put(pkValue, order);
                orderEntryMap.put(pkValue, entry);
                orderEntryList.add(pkValue);
            }
        }
        HashMap<String, Object> warehouseOrgMap = new HashMap<String, Object>(orgIdSet.size());
        for (String orgId : orgIdSet) {
            Map<String, Object> pmAppParameterMap = MPDMMftGenStocksUtils.getPmAppParameterMap(Long.parseLong(orgId), stockname);
            Object warehousesource = pmAppParameterMap.get("fwarehousesource");
            warehouseOrgMap.put(orgId, warehousesource);
        }
        baseData.setWarehouseOrgMap(warehouseOrgMap);
        baseData.setOrderMap(orderMap);
        baseData.setOrderEntryMap(orderEntryMap);
        baseData.setOrderEntryList(orderEntryList);
    }

    private static String getOrderEntryName(String orderName) {
        String entryName = "treeentryentity";
        if ("pm_om_purorderbill".equals(orderName)) {
            entryName = "billentry";
        }
        return entryName;
    }

    public static void putStockMap(List<String> orderIdList, OrderBaseData baseData, String stockname) {
        String fixOrderEntryProp;
        HashMap<Long, DynamicObject> stockMap = new HashMap<Long, DynamicObject>(16);
        QFilter qf = new QFilter("orderid", "in", orderIdList);
        String stockEntity = EntityNameUtils.getEntityName(1, 0, stockname);
        String selectProp = MPDMMftGenStocksUtils.selectStockProperties(stockEntity);
        if (selectProp.contains(fixOrderEntryProp = ",orderentryid")) {
            selectProp = selectProp.replace(fixOrderEntryProp, "");
        }
        DynamicObject[] stocks = BusinessDataServiceHelper.load((String)stockname, (String)selectProp, (QFilter[])qf.toArray());
        DynamicObjectCollection mftStockHeadCol = QueryServiceHelper.query((String)stockname, (String)MPDMMftGenStocksUtils.selectStockHeadProp(stockname), (QFilter[])qf.toArray());
        Map<Long, List<DynamicObject>> mftStockHeadMap = mftStockHeadCol.stream().collect(Collectors.groupingBy(v -> v.getLong("id")));
        logger.info("---mftStockHeadMap--" + mftStockHeadMap);
        for (DynamicObject stock : stocks) {
            DynamicObject stockHead;
            Long orderentryid;
            Long stockId = stock.getLong("id");
            logger.info("---stockId---" + stockId);
            List<DynamicObject> stockHeadLst = mftStockHeadMap.get(stockId);
            if (stockHeadLst == null || stockHeadLst.size() <= 0 || (orderentryid = Long.valueOf((stockHead = stockHeadLst.get(0)).getLong("orderentryid"))) <= 0L) continue;
            stockMap.put(orderentryid, stock);
        }
        baseData.setMftStockHeadMap(mftStockHeadMap);
        baseData.setStockMap(stockMap);
    }

    private static void readStocks(OrderBaseData baseData, String stockname) {
        ORM orm = ORM.create();
        List<Long> orderEntryIdList = baseData.getOrderEntryList();
        Map<Long, DynamicObject> stockMap = baseData.getStockMap();
        Map<Long, List<DynamicObject>> stockHeadMap = baseData.getMftStockHeadMap();
        Map<Long, DynamicObject> orderEntryMap = baseData.getOrderEntryMap();
        Map<Long, DynamicObject> orderMap = baseData.getOrderMap();
        List<DynamicObject> saveStocks = baseData.getSaveStocks();
        List<DynamicObject> updateStocks = baseData.getUpdateStocks();
        Set<Long> deleteOrderEntryIds = baseData.getDeleteOrderEntryIds();
        for (Long orderEntryId : orderEntryIdList) {
            DynamicObject orderStock;
            DynamicObject stock = stockMap.get(orderEntryId);
            DynamicObject orderEntry = orderEntryMap.get(orderEntryId);
            List<DynamicObject> stockHeadLst = null;
            if (stockHeadMap != null && stock != null) {
                stockHeadLst = stockHeadMap.get(stock.getPkValue());
            }
            if (stock == null) {
                orderStock = CreateStockUtils.getNewDynamicObject(stockname, orm);
                CreateStockUtils.createHeadOfStockInfo(orderMap.get(orderEntryId), orderEntry, orderStock, baseData);
                stockMap.put(orderEntryId, orderStock);
                saveStocks.add(orderStock);
                continue;
            }
            if (CreateStockUtils.isUpdateStock(stock, orderEntry, stockname, stockHeadLst)) {
                CreateStockUtils.updateStock(orderMap.get(orderEntryId), orderEntry, stock, baseData);
                updateStocks.add(stock);
                continue;
            }
            deleteOrderEntryIds.add(orderEntryId);
            orderStock = CreateStockUtils.getNewDynamicObject(stockname, orm);
            CreateStockUtils.createHeadOfStockInfo(orderMap.get(orderEntryId), orderEntry, orderStock, baseData);
            stockMap.put(orderEntryId, orderStock);
            saveStocks.add(orderStock);
        }
        CreateStockUtils.batchSetBillNumber(baseData, stockname);
    }

    private static void updateStock(DynamicObject order, DynamicObject orderEntry, DynamicObject stock, OrderBaseData baseData) {
        if (order == null || orderEntry == null || stock == null) {
            return;
        }
        stock.set("modifytime", (Object)baseData.getNowDate());
        stock.set("modifier", (Object)baseData.getUser());
        stock.set("qty", orderEntry.get("qty"));
        stock.set("unitid", orderEntry.get("unit"));
        BigDecimal baseqty = orderEntry.getBigDecimal("baseqty");
        BigDecimal oldQty = stock.getBigDecimal("baseqty");
        stock.set("baseqty", (Object)baseqty);
        stock.set("baseunitid", orderEntry.get("baseunit"));
        stock.set("orderno", order.get("billno"));
        stock.set("configuredcode", orderEntry.get("configuredcode"));
        stock.set("tracknumber", orderEntry.get("tracknumber"));
        String orderName = order.getDataEntityType().getName();
        DynamicObject mtfOrg = null;
        DynamicObject transactiontype = stock.getDynamicObject("transactiontypeid");
        String feedtype = "";
        Boolean workCenter = false;
        DynamicObject stockHead = null;
        if (baseData.getMftStockHeadMap() != null) {
            List<DynamicObject> stockHeadLst = baseData.getMftStockHeadMap().get(stock.getPkValue());
            stockHead = stockHeadLst.get(0);
        }
        if ("pm_om_purorderbill".equals(orderName)) {
            stock.set(REPLACENO, orderEntry.get(BOMREPLACENONAME));
            stock.set("auxproperty", orderEntry.get("auxpty"));
            stock.set("billauxqty", orderEntry.get("auxqty"));
            stock.set("billauxunit", orderEntry.get("auxunit"));
            stock.set("supplier", order.get("supplier"));
            feedtype = transactiontype.getString("feedtype");
            if ("E".equals(feedtype)) {
                CreateStockUtils.updateStockEntry(orderEntry, stock, orderName);
            }
        } else if ("pom_mftorder".equals(orderName) || "om_mftorder".equals(orderName) || "prop_mftorder".equals(orderName)) {
            stock.set(REPLACENO, orderEntry.get(REPLACENO));
            if ("om_mftorder".equals(orderName)) {
                stock.set("planpreparetime", orderEntry.get("planpreparetime"));
            }
            stock.set("auxproperty", orderEntry.get("auxproperty"));
            stock.set("billauxqty", orderEntry.get("auxptyqty"));
            stock.set("billauxunit", orderEntry.get("auxptyunit"));
            stock.set("mftdeptorgid", orderEntry.get("producedept"));
            mtfOrg = order.getDynamicObject("org");
            feedtype = transactiontype.getString("stockmaterials");
            if ("B".equals(feedtype)) {
                CreateStockUtils.updateStockEntry(orderEntry, stock, orderName);
            }
            if ("prop_mftorder".equals(orderName)) {
                stock.set("productline", orderEntry.get("productline"));
            } else {
                Long oldWorkCenterId = 0L;
                if (stockHead != null) {
                    oldWorkCenterId = stockHead.getLong("orderentryid.workcenter");
                }
                DynamicObject newWorkCenter = orderEntry.getDynamicObject("workcenter");
                workCenter = (oldWorkCenterId == null ? 0L : oldWorkCenterId) == (newWorkCenter == null ? 0L : (Long)newWorkCenter.getPkValue());
            }
        } else if ("pom_mroorder".equals(orderName)) {
            stock.set("customer", orderEntry.get("customer"));
            stock.set("workcard", orderEntry.get("workcard"));
            stock.set("project", orderEntry.get("project"));
        }
        Boolean isQtyChange = true;
        if (oldQty.compareTo(baseqty) == 0) {
            isQtyChange = false;
        }
        CreateStockUtils.updateStockEntrys(stock, orderEntry, orderName, workCenter, mtfOrg, baseData, isQtyChange);
    }

    private static void updateStockEntrys(DynamicObject stock, DynamicObject orderEntry, String orderName, Boolean workCenter, DynamicObject mtfOrg, OrderBaseData baseData, Boolean isQtyChange) {
        DynamicObject transactiontype = stock.getDynamicObject("transactiontypeid");
        DynamicObjectCollection stockEntrys = stock.getDynamicObjectCollection("stockentry");
        HashSet<Long> bomentryIDSet = new HashSet<Long>(stockEntrys.size());
        for (DynamicObject stockEntry : stockEntrys) {
            if (!"pm_om_purorderbill".equals(orderName)) continue;
            bomentryIDSet.add(stockEntry.getLong("bomentryid"));
        }
        Map<Long, BigDecimal> bomLeadTimeMap = CreateStockUtils.getBomEntryLeadTimeMap(bomentryIDSet);
        for (DynamicObject stockEntry : stockEntrys) {
            if (!workCenter.booleanValue() && ("pom_mftorder".equals(orderName) || "om_mftorder".equals(orderName) || "prop_mftorder".equals(orderName)) && "A".equals(stock.getString("billstatus"))) {
                CreateStockUtils.setStockEntryWarehouse(mtfOrg, stockEntry, orderEntry, baseData);
            }
            if (stockEntry.getBoolean("isstep") && isQtyChange.booleanValue()) {
                MPDMMftGenStocksUtils.setQtyByType(stockEntry, stock, orderEntry);
            }
            if ("pm_om_purorderbill".equals(orderName)) {
                stockEntry.set("demanddate", (Object)CreateStockUtils.getLeadTimeByBomEntryId(stockEntry, orderEntry, bomLeadTimeMap));
                continue;
            }
            if (!"pom_mftorder".equals(orderName) && !"om_mftorder".equals(orderName)) continue;
            stockEntry.set("demanddate", (Object)MPDMMftGenStocksUtils.getDemandDate(mtfOrg, orderEntry.getDate("planbegintime"), stockEntry, orderEntry.getDate("planendtime")));
        }
        if (isQtyChange.booleanValue()) {
            CreateStockUtils.changeStockQtyByOrder(stock, orderEntry, transactiontype, orderName);
        }
    }

    private static Date getLeadTimeByBomEntryId(DynamicObject stockEntry, DynamicObject orderEntry, Map<Long, BigDecimal> bomLeadTimeMap) {
        Object bomentryid = stockEntry.get("bomentryid");
        BigDecimal leadtime = BigDecimal.ZERO;
        if (bomLeadTimeMap != null && bomLeadTimeMap.containsKey(bomentryid)) {
            leadtime = bomLeadTimeMap.get(bomentryid);
        }
        if (leadtime.intValue() == 0) {
            return orderEntry.getDate("deliverdate");
        }
        Calendar c = Calendar.getInstance();
        c.setTime(orderEntry.getDate("deliverdate"));
        c.add(5, leadtime.intValue());
        return c.getTime();
    }

    public static void setStockEntryWarehouse(DynamicObject mtfOrg, DynamicObject stockEntry, DynamicObject orderEntry, OrderBaseData baseData) {
        Object warehousesource;
        String stockName = ((DynamicObject)stockEntry.getParent()).getDataEntityType().getName();
        if ("A".equals(stockEntry.getString("isbackflush"))) {
            return;
        }
        Long pk = 0L;
        if (mtfOrg != null) {
            pk = (Long)mtfOrg.getPkValue();
        }
        HashMap<String, Object> cacheMap = new HashMap<String, Object>(16);
        if (baseData != null) {
            Map<String, Object> warehouseOrgMap = baseData.getWarehouseOrgMap();
            warehousesource = warehouseOrgMap.get(pk.toString());
        } else {
            Map<String, Object> pmAppParameterMap = MPDMMftGenStocksUtils.getPmAppParameterMap(pk, stockName);
            warehousesource = pmAppParameterMap.get("fwarehousesource");
        }
        if (warehousesource != null && "0".equals(warehousesource.toString())) {
            Long wcID;
            DynamicObject workCenter = null;
            if (orderEntry.containsProperty("workcenter")) {
                workCenter = orderEntry.getDynamicObject("workcenter");
            } else if (orderEntry.containsProperty("productline")) {
                workCenter = orderEntry.getDynamicObject("productline");
            }
            logger.info("orderEntry---\u5de5\u4f5c\u4e2d\u5fc3--" + workCenter);
            Long l = wcID = workCenter == null ? Long.valueOf("0") : (Long)workCenter.getPkValue();
            if (wcID != 0L) {
                if (baseData == null) {
                    if (cacheMap.containsKey("wh_" + wcID)) {
                        workCenter = (DynamicObject)cacheMap.get("wh_" + wcID);
                    } else {
                        workCenter = WorkcenterQueryHelper.getDataCacheByID(wcID);
                        cacheMap.put("wh_" + wcID, workCenter);
                    }
                } else {
                    workCenter = baseData.getWcBlackWHMap(wcID);
                }
            }
            Object workCenterEntry = null;
            if (stockEntry.containsProperty("oprworkcenter")) {
                workCenterEntry = stockEntry.get("oprworkcenter");
            }
            Long entryWcID = 0L;
            if (workCenterEntry != null) {
                entryWcID = workCenterEntry instanceof DynamicObject ? (Long)((DynamicObject)workCenterEntry).getPkValue() : (Long)workCenterEntry;
            }
            DynamicObject workCenterEntryDym = null;
            if (entryWcID != 0L) {
                if (baseData == null) {
                    if (cacheMap.containsKey("wh_" + entryWcID)) {
                        workCenterEntryDym = (DynamicObject)cacheMap.get("wh_" + entryWcID);
                    } else {
                        workCenterEntryDym = WorkcenterQueryHelper.getDataCacheByID(entryWcID);
                        cacheMap.put("wh_" + entryWcID, workCenterEntry);
                    }
                } else {
                    workCenterEntryDym = baseData.getWcBlackWHMap(entryWcID);
                }
            }
            if (workCenter != null && workCenter.get("warehouse") != null) {
                stockEntry.set("warehouseid", workCenter.get("warehouse"));
                stockEntry.set("location", workCenter.get("location"));
            } else if (workCenterEntryDym != null && workCenterEntryDym.get("warehouse") != null) {
                stockEntry.set("warehouseid", workCenterEntryDym.get("warehouse"));
                stockEntry.set("location", workCenterEntryDym.get("location"));
            } else {
                stockEntry.set("warehouseid", null);
                stockEntry.set("location", null);
            }
        }
    }

    private static void changeStockQtyByOrder(DynamicObject stock, DynamicObject orderEntry, DynamicObject transactiontype, String orderName) {
        boolean isconsiderloss = transactiontype.getBoolean("isconsiderloss");
        BigDecimal baseqty = orderEntry.getBigDecimal("baseqty");
        DynamicObjectCollection stockEntrys = stock.getDynamicObjectCollection("stockentry");
        for (DynamicObject stockEntry : stockEntrys) {
            DynamicObject unit = stockEntry.getDynamicObject("materialunitid");
            String wastagerateformula = (String)stockEntry.get("wastagerateformula");
            int precision = MPDMMftGenStocksUtils.getPrecision(unit);
            String qtyType = stockEntry.getString("qtytype");
            BigDecimal useratio = stockEntry.getBigDecimal("useratio").divide(BigDecimal.valueOf(100L), 4, 4);
            BigDecimal qtynumerator = stockEntry.getBigDecimal("qtynumerator");
            BigDecimal qtydenominator = stockEntry.getBigDecimal("qtydenominator");
            BigDecimal standqty = MPDMMftGenStocksUtils.calculateStandQty(unit, qtyType, useratio, baseqty, qtynumerator, qtydenominator);
            stockEntry.set("standqty", (Object)standqty);
            BigDecimal scraprate = stockEntry.getBigDecimal("scraprate");
            BigDecimal fixscrap = stockEntry.getBigDecimal("fixscrap");
            BigDecimal demandQty = MPDMMftGenStocksUtils.calculateDemadQty(precision, isconsiderloss, standqty, scraprate, fixscrap, wastagerateformula);
            stockEntry.set("demandqty", (Object)demandQty);
            stockEntry.set("extraratioqty", (Object)stockEntry.getBigDecimal("demandqty").multiply(BigDecimal.ONE.add(stockEntry.getBigDecimal("issinhighlimit").divide(BigDecimal.valueOf(100L), 4, 4))));
            stockEntry.set("lackraitioqty", (Object)stockEntry.getBigDecimal("demandqty").multiply(BigDecimal.ONE.subtract(stockEntry.getBigDecimal("issinlowlimit").divide(BigDecimal.valueOf(100L), 4, 4))));
            stockEntry.set("actissueqty", MPDMMftGenStocksUtils.aculActissueQty(stockEntry));
            stockEntry.set("cansendqty", MPDMMftGenStocksUtils.aculCanSendQty(stockEntry));
            stockEntry.set("unissueqty", MPDMMftGenStocksUtils.aculUnSendQty(stockEntry));
            stockEntry.set("useqty", (Object)MPDMMftGenStocksUtils.aculUseQty(stockEntry, orderEntry.getPkValue(), transactiontype, orderName));
            stockEntry.set("wipqty", (Object)MPDMMftGenStocksUtils.aculWIPQty(stockEntry));
        }
    }

    private static void createHeadOfStockInfo(DynamicObject manufactureOrder, DynamicObject orderEntry, DynamicObject orderStock, OrderBaseData baseData) {
        String orderEntryid = orderEntry.getPkValue().toString();
        orderStock.set("billstatus", (Object)"A");
        orderStock.set("orderentryid", (Object)orderEntryid);
        orderStock.set("orderid", (Object)manufactureOrder.getPkValue().toString());
        String orderName = manufactureOrder.getDataEntityType().getName();
        DynamicObject ordertostockDym = baseData.getOrdertostockDym();
        if (ordertostockDym != null) {
            CreateStockUtils.setStockFieldByDym(ordertostockDym, orderStock, orderEntry, manufactureOrder);
        }
        String masterName = "materielmasterid";
        switch (orderName) {
            case "pm_om_purorderbill": {
                DynamicObject material = orderEntry.getDynamicObject("material");
                if (null != material) {
                    orderStock.set("productid", (Object)material);
                }
                orderStock.set("org", orderEntry.get("entryreqorg"));
                orderStock.set("purorg", manufactureOrder.get("org"));
                masterName = "materialmasterid";
                break;
            }
            case "prop_mftorder": {
                orderStock.set(PROGRAMME, orderEntry.get(PROGRAMME));
                break;
            }
            default: {
                orderStock.set("processroute", orderEntry.get("processroute"));
            }
        }
        orderStock.set("billtype", (Object)baseData.getBilltypeObj());
        orderStock.set(PRODUCTMASTERID, (Object)orderEntry.getDynamicObject(masterName));
        orderStock.set("createtime", (Object)baseData.getNowDate());
        orderStock.set("modifytime", (Object)baseData.getNowDate());
        orderStock.set("creator", (Object)baseData.getUser());
        orderStock.set("modifier", (Object)baseData.getUser());
    }

    private static void setStockFieldByDym(DynamicObject ordertostockDym, DynamicObject orderStock, DynamicObject orderEntry, DynamicObject manufactureOrder) {
        DynamicObjectCollection otsentryDyms = ordertostockDym.getDynamicObjectCollection("otsentry");
        for (int i = 0; i < otsentryDyms.size(); ++i) {
            DynamicObject otsentryDym = (DynamicObject)otsentryDyms.get(i);
            DynamicObjectCollection otsentryentityDyms = otsentryDym.getDynamicObjectCollection("otsentryentity");
            for (int j = 0; j < otsentryentityDyms.size(); ++j) {
                if ("A".equals(otsentryDym.getString("entityname"))) {
                    orderStock.set(((DynamicObject)otsentryentityDyms.get(j)).getString("stockident"), manufactureOrder.get(((DynamicObject)otsentryentityDyms.get(j)).getString("orderident")));
                    continue;
                }
                if (!"B".equals(otsentryDym.getString("entityname"))) continue;
                orderStock.set(((DynamicObject)otsentryentityDyms.get(j)).getString("stockident"), orderEntry.get(((DynamicObject)otsentryentityDyms.get(j)).getString("orderident")));
            }
        }
    }

    private static String getFieldId(DynamicObject orderEntry, String orderName, String key) {
        DynamicObject field;
        String fieldId = "0";
        if ("pm_om_purorderbill".equals(orderName)) {
            if ("bomid".equals(key)) {
                fieldId = orderEntry.getString(key);
            }
        } else if (("pom_mftorder".equals(orderName) || "om_mftorder".equals(orderName) || "prop_mftorder".equals(orderName)) && (field = orderEntry.getDynamicObject(key)) != null) {
            fieldId = field.getPkValue().toString();
        }
        return fieldId;
    }

    public static Map<Long, String> unDoStock(DynamicObject srcBill, String stockname) {
        HashMap<Long, String> resultMap = new HashMap<Long, String>(16);
        HashMap<Long, DynamicObject> orderEntryMap = new HashMap<Long, DynamicObject>(16);
        DynamicObjectCollection orderEntryCollection = srcBill.getDynamicObjectCollection("treeentryentity");
        for (DynamicObject orderEntry : orderEntryCollection) {
            orderEntryMap.put(orderEntry.getLong("id"), orderEntry);
        }
        QFilter qFilter = new QFilter("orderentryid", "in", orderEntryMap.keySet());
        DynamicObject[] stocks = BusinessDataServiceHelper.load((String)stockname, (String)MPDMMftGenStocksUtils.selectStockProperties(EntityNameUtils.getEntityName(1, 0, stockname)), (QFilter[])qFilter.toArray());
        if (null != stocks) {
            for (DynamicObject stock : stocks) {
                Long stockOrderEntryId = stock.getDynamicObject("orderentryid").getLong("id");
                boolean isUpdateStock = CreateStockUtils.isUpdateStock(stock, (DynamicObject)orderEntryMap.get(stockOrderEntryId), stockname, null);
                String optionKey = "";
                if (!isUpdateStock) {
                    if (stock.getString("billstatus").equals("C")) {
                        optionKey = "audit";
                    }
                    if (stock.getString("billstatus").equals("B")) {
                        optionKey = "submit";
                    }
                }
                if (!StringUtils.isNotBlank((CharSequence)optionKey)) continue;
                resultMap.put(stockOrderEntryId, optionKey);
                String operateKey = "unaudit";
                String operateName = ResManager.loadKDString((String)"\u53cd\u5ba1\u6838", (String)"CreateStockUtils_10", (String)"bd-mpdm-common", (Object[])new Object[0]);
                if ("submit".equals(optionKey)) {
                    operateName = ResManager.loadKDString((String)"\u53cd\u63d0\u4ea4", (String)"CreateStockUtils_11", (String)"bd-mpdm-common", (Object[])new Object[0]);
                    operateKey = "unsubmit";
                }
                OperateOption option = OperateOption.create();
                option.setVariableValue("ignorewarn", String.valueOf(true));
                option.setVariableValue("ignoreinteraction", String.valueOf(true));
                option.setVariableValue("strictvalidation", String.valueOf(true));
                option.setVariableValue("stockchangecheckplanstatus", "false");
                OperationResult executeOperate = OperationServiceHelper.executeOperate((String)operateKey, (String)stockname, (Object[])new Object[]{stock.getPkValue()}, (OperateOption)option);
                if (executeOperate.isSuccess()) continue;
                throw new KDBizException(new ErrorCode("unDoStock", String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c%1$s\u7ec4\u4ef6\u6e05\u5355\u5f02\u5e38\uff1a%2$s", (String)"CreateStockUtils_12", (String)"bd-mpdm-common", (Object[])new Object[0]), operateName, OrderOpUtils.getErrDetail(executeOperate))), new Object[0]);
            }
        }
        return resultMap;
    }

    public static void reUnDoStock(DynamicObject srcBill, String stockname, Map<Long, String> map) {
        HashMap<Long, DynamicObject> orderEntryMap = new HashMap<Long, DynamicObject>(16);
        DynamicObjectCollection orderEntryCollection = srcBill.getDynamicObjectCollection("treeentryentity");
        for (DynamicObject orderEntry : orderEntryCollection) {
            orderEntryMap.put(orderEntry.getLong("id"), orderEntry);
        }
        QFilter qFilter = new QFilter("orderentryid", "in", orderEntryMap.keySet());
        DynamicObject[] stocks = BusinessDataServiceHelper.load((String)stockname, (String)MPDMMftGenStocksUtils.selectStockProperties(EntityNameUtils.getEntityName(1, 0, stockname)), (QFilter[])qFilter.toArray());
        if (null != stocks) {
            for (DynamicObject stock : stocks) {
                OperationResult auditOperate;
                Long stockOrderEntryId = stock.getDynamicObject("orderentryid").getLong("id");
                if (!map.containsKey(stockOrderEntryId)) continue;
                String operateKey = map.get(stockOrderEntryId);
                OperateOption option = OperateOption.create();
                option.setVariableValue("ignorewarn", String.valueOf(true));
                option.setVariableValue("ignoreinteraction", String.valueOf(true));
                option.setVariableValue("strictvalidation", String.valueOf(true));
                OperationResult executeOperate = OperationServiceHelper.executeOperate((String)"submit", (String)stockname, (Object[])new Object[]{stock.getPkValue()}, (OperateOption)option);
                if (!executeOperate.isSuccess()) {
                    throw new KDBizException(new ErrorCode("reUnDoStock", String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u63d0\u4ea4\u7ec4\u4ef6\u6e05\u5355\u5f02\u5e38\uff1a%1$s", (String)"CreateStockUtils_13", (String)"bd-mpdm-common", (Object[])new Object[0]), OrderOpUtils.getErrDetail(executeOperate))), new Object[0]);
                }
                if (!"audit".equals(operateKey) || (auditOperate = OperationServiceHelper.executeOperate((String)"audit", (String)stockname, (Object[])new Object[]{stock.getPkValue()}, (OperateOption)option)).isSuccess()) continue;
                throw new KDBizException(new ErrorCode("reUnDoStock", String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5ba1\u6838\u7ec4\u4ef6\u6e05\u5355\u5f02\u5e38\uff1a%1$s", (String)"CreateStockUtils_14", (String)"bd-mpdm-common", (Object[])new Object[0]), OrderOpUtils.getErrDetail(auditOperate))), new Object[0]);
            }
        }
    }

    private static boolean isUpdateStock(DynamicObject stock, DynamicObject orderEntry, String stockname, List<DynamicObject> stockHeadLst) {
        DynamicObject transactiontype;
        boolean expendBomTimeEquals = true;
        boolean manuversionEquals = true;
        String orderName = EntityNameUtils.getEntityName(1, 0, stockname);
        String newbomId = CreateStockUtils.getFieldId(orderEntry, orderName, "bomid");
        String newprocessrouteId = CreateStockUtils.getFieldId(orderEntry, orderName, "processroute");
        String newConfigedCodeId = CreateStockUtils.getFieldId(orderEntry, orderName, "configuredcode");
        String oldbomId = CreateStockUtils.getFieldId(stock, "bomid");
        String oldprocessrouteId = CreateStockUtils.getFieldId(stock, "processroute");
        String oldConfigedCodeId = CreateStockUtils.getFieldId(stock, "configuredcode");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        boolean isConfigBomEquals = true;
        if ("pom_mftorder".equals(orderName) || "om_mftorder".equals(orderName) || "prop_mftorder".equals(orderName)) {
            if (stockHeadLst == null || stockHeadLst.size() <= 0) {
                return true;
            }
            DynamicObject stockHead = stockHeadLst.get(0);
            Long oldExpendBomTime = stockHead.getDate("orderentryid.expendbomtime").getTime();
            Long newExpendBomTime = orderEntry.getDate("expendbomtime").getTime();
            if (!MmcCommonHelper.IsBomExpandTime().booleanValue()) {
                String expendBomTimeFM = sdf.format(stockHead.getDate("orderentryid.expendbomtime"));
                expendBomTimeEquals = sdf.format(orderEntry.getDate("expendbomtime")).equals(expendBomTimeFM);
            } else {
                expendBomTimeEquals = oldExpendBomTime.equals(newExpendBomTime);
            }
            String oldManuversion = stockHead.getString("orderentryid.manuversion");
            String oldManuversionStr = oldManuversion == null ? "0" : oldManuversion;
            String newManuversionStr = CreateStockUtils.getFieldId(orderEntry, orderName, "manuversion");
            manuversionEquals = oldManuversionStr.equals(newManuversionStr);
            isConfigBomEquals = newConfigedCodeId.equals(oldConfigedCodeId);
        } else if ("pom_mrostock".equals(stockname)) {
            DynamicObject oldCard = stock.getDynamicObject("workcard");
            DynamicObject newCard = orderEntry.getDynamicObject("workcard");
            Long oldCardId = oldCard == null ? Long.valueOf("0") : (Long)oldCard.getPkValue();
            Long newCardId = newCard == null ? Long.valueOf("0") : (Long)newCard.getPkValue();
            return oldCardId.equals(newCardId);
        }
        String field = "stockmaterials";
        if ("om_componentlist".equals(stockname)) {
            field = "feedtype";
        }
        String stockmaterials = (transactiontype = stock.getDynamicObject("transactiontypeid")).get(field) == null ? "A" : transactiontype.getString(field);
        logger.info("\u66f4\u65b0\u7ec4\u4ef6\u6e05\u5355" + expendBomTimeEquals + "/" + newbomId.equals(oldbomId) + "/" + newprocessrouteId.equals(oldprocessrouteId) + "/" + isConfigBomEquals);
        logger.info("\u66f4\u65b0\u7ec4\u4ef6\u6e05\u5355" + newbomId + "/" + oldbomId + "/" + newprocessrouteId + "/" + oldprocessrouteId + "/" + newConfigedCodeId + "/" + oldConfigedCodeId + "/" + stockmaterials);
        if ("A".equals(stockmaterials)) {
            return expendBomTimeEquals && newbomId.equals(oldbomId) && newprocessrouteId.equals(oldprocessrouteId) && isConfigBomEquals && manuversionEquals;
        }
        if ("D".equals(stockmaterials)) {
            Long newProgrammePk = DynamicObjDataUtil.getDynamicObjectPK(DynamicObjDataUtil.getDynamicObjectDynamicObjectData(orderEntry, PROGRAMME));
            Long oldProgrammePk = DynamicObjDataUtil.getDynamicObjectPK(DynamicObjDataUtil.getDynamicObjectDynamicObjectData(stock, PROGRAMME));
            return expendBomTimeEquals && Objects.equals(newProgrammePk, oldProgrammePk);
        }
        return true;
    }

    private static String getFieldId(DynamicObject stock, String key) {
        String fieldId = "0";
        DynamicObject field = stock.getDynamicObject(key);
        if (field != null) {
            fieldId = field.getPkValue().toString();
        }
        return fieldId;
    }

    private static void readDelOrderEntryIds(OrderBaseData baseData, List<DynamicObject> orderList, String orderName) {
        String orderEntryName = CreateStockUtils.getOrderEntryName(orderName);
        HashSet<Object> existsOrderEntryIds = new HashSet<Object>();
        for (DynamicObject order : orderList) {
            DynamicObjectCollection entrys = order.getDynamicObjectCollection(orderEntryName);
            if (entrys == null) continue;
            for (DynamicObject entry : entrys) {
                existsOrderEntryIds.add(entry.getPkValue());
            }
        }
        Set<Long> deleteOrderEntryIds = baseData.getDeleteOrderEntryIds();
        Map<Long, DynamicObject> stockMap = baseData.getStockMap();
        for (Map.Entry<Long, DynamicObject> map : stockMap.entrySet()) {
            Long key = map.getKey();
            if (existsOrderEntryIds.contains(key)) continue;
            deleteOrderEntryIds.add(key);
        }
    }

    private static void updateStockEntry(DynamicObject orderEntry, DynamicObject stock, String orderName) {
        DynamicObjectCollection stockEntrys = stock.getDynamicObjectCollection("stockentry");
        if (stockEntrys == null || stockEntrys.size() < 1) {
            return;
        }
        DynamicObject stockEntry = (DynamicObject)stockEntrys.get(0);
        DynamicObject mainMaterial = stock.getDynamicObject("productid");
        DynamicObject material = stockEntry.getDynamicObject("materialid");
        if (mainMaterial == null || material == null || !mainMaterial.getDynamicObject("masterid").getPkValue().equals(material.getDynamicObject("masterid").getPkValue())) {
            return;
        }
        if ("pm_om_purorderbill".equals(orderName)) {
            stockEntry.set("childauxpropertyid", orderEntry.get("auxpty"));
            stockEntry.set("batchno", orderEntry.get("batchno"));
            stockEntry.set("lot", orderEntry.get("lot"));
        } else if ("pom_mftorder".equals(orderName) || "om_mftorder".equals(orderName)) {
            stockEntry.set("childauxpropertyid", orderEntry.get("auxproperty"));
            stockEntry.set("batchno", orderEntry.get("batchno"));
            stockEntry.set("lot", orderEntry.get("lot"));
            stockEntry.set("entryconfiguredcode", orderEntry.get("configuredcode"));
        }
    }

    private static void batchSetBillNumber(OrderBaseData baseData, String stockname) {
        Long orgID;
        List<DynamicObject> saveStocks = baseData.getSaveStocks();
        HashMap<Long, DynamicObjectCollection> orgStockNumberMap = new HashMap<Long, DynamicObjectCollection>(16);
        DynamicObjectCollection coll = null;
        for (DynamicObject dynamicObject : saveStocks) {
            orgID = dynamicObject.getDynamicObject("org").getLong("id");
            if (dynamicObject.get("billno") != null && !"".equals(dynamicObject.get("billno")) && !" ".equals(dynamicObject.get("billno"))) continue;
            coll = orgStockNumberMap.containsKey(orgID) ? (DynamicObjectCollection)orgStockNumberMap.get(orgID) : new DynamicObjectCollection();
            coll.add((Object)dynamicObject);
            orgStockNumberMap.put(orgID, coll);
        }
        for (Map.Entry entry : orgStockNumberMap.entrySet()) {
            orgID = (Long)entry.getKey();
            coll = (DynamicObjectCollection)entry.getValue();
            String[] numbers = CodeRuleServiceHelper.getBatchNumber((String)stockname, (DynamicObject)((DynamicObject)coll.get(0)), (String)orgID.toString(), (int)coll.size());
            for (int i = 0; i < coll.size(); ++i) {
                DynamicObject orderStock = (DynamicObject)coll.get(i);
                if (numbers == null || numbers.length < i + 1 || numbers[i] == null) {
                    orderStock.set("billno", (Object)("mo_" + orderStock.get("orderentryid")));
                    continue;
                }
                orderStock.set("billno", (Object)numbers[i]);
            }
        }
    }

    private static Map<Long, BigDecimal> getBomEntryLeadTimeMap(Set<Long> bomentryIDSet) {
        if (bomentryIDSet == null || bomentryIDSet.size() < 1) {
            return null;
        }
        Map<Long, DynamicObject> entryMap = MsBomQueryHelper.getBomEntryFromCache(bomentryIDSet);
        HashMap<Long, BigDecimal> returnMap = new HashMap<Long, BigDecimal>(16);
        if (entryMap != null) {
            BigDecimal leadtime = BigDecimal.ZERO;
            for (Map.Entry<Long, DynamicObject> bomentrys : entryMap.entrySet()) {
                DynamicObject bomentry = bomentrys.getValue();
                leadtime = bomentry.getBigDecimal("entryleadtime");
                if (leadtime.compareTo(BigDecimal.ONE) == 0) continue;
                returnMap.put(bomentry.getLong("id"), leadtime);
            }
        }
        return returnMap;
    }

    private static String getStockWorkCenterId(DynamicObject stock) {
        if (stock == null) {
            return "0";
        }
        DynamicObject orderEntryF7 = stock.getDynamicObject("orderentryid");
        return CreateStockUtils.getFieldId(orderEntryF7, "workcenter");
    }

    public static void getStockWareHouse(DynamicObject stockEntry, DynamicObject orderEntry, DynamicObject org, String stockName) {
        Long orgId = CreateStockUtils.getPkid(org);
        Long masterid = CreateStockUtils.getPkid(stockEntry.get("materielmasterid"));
        HashSet<Long> masterSet = new HashSet<Long>(16);
        masterSet.add(masterid);
        Map<Object, DynamicObject> planMap = MaterialPlanQueryHelper.getDataCacheByMaterialSet(masterSet, orgId);
        HashMap<Long, Map<Long, DynamicObject>> orgMaterialPlanInfoMap = new HashMap<Long, Map<Long, DynamicObject>>(16);
        HashMap<Long, DynamicObject> planInfoMap = new HashMap<Long, DynamicObject>(16);
        for (Map.Entry<Object, DynamicObject> loadMap : planMap.entrySet()) {
            DynamicObject load = loadMap.getValue();
            if (load == null) continue;
            planInfoMap.put((Long)load.getDynamicObject("masterid").getPkValue(), load);
        }
        OrderBaseData baseData = new OrderBaseData();
        HashMap<String, Object> warehouseOrgMap = new HashMap<String, Object>(16);
        Map<String, Object> pmAppParameterMap = MPDMMftGenStocksUtils.getPmAppParameterMap(orgId, stockName);
        Object warehousesource = pmAppParameterMap.get("fwarehousesource");
        warehouseOrgMap.put(orgId.toString(), warehousesource);
        baseData.setWarehouseOrgMap(warehouseOrgMap);
        Map<Object, DynamicObject> supplynetworkMap = baseData.getSupplynetworkMap();
        supplynetworkMap.putAll(PlanScopeHelper.getSupplynetworkMap(planInfoMap.values()));
        orgMaterialPlanInfoMap.put(orgId, planInfoMap);
        baseData.setOrgMaterialPlanInfoMap(orgMaterialPlanInfoMap);
        HashMap<Long, Set<Long>> orgMasterSet = new HashMap<Long, Set<Long>>(16);
        CreateStockUtils.putMapSet(orgMasterSet, CreateStockUtils.getPkid(org), masterid);
        DynamicObject innerOrg = CreateStockUtils.getinnerOrg(baseData, orgId, masterid);
        if (innerOrg != null) {
            CreateStockUtils.putMapSet(orgMasterSet, CreateStockUtils.getPkid(innerOrg), masterid);
        }
        if (!orgMasterSet.isEmpty()) {
            CreateStockUtils.setBaseDataMftInfo(orgMasterSet, baseData);
        }
        boolean usePlanscope = PlanScopeHelper.isUsePlanscope();
        String materialsource = "B";
        if (usePlanscope && !"om_componentlist".equals(stockName) && !"om_xxcomponentlist".equals(stockName)) {
            HashMap<String, LinkedList<Object>> params = new HashMap<String, LinkedList<Object>>(16);
            CreateStockUtils.getSupplyParams(stockEntry, orderEntry, org, baseData, params);
            Map<String, Map<String, Long>> supplyInfos = null;
            if (params.size() > 0) {
                Long startdate = System.currentTimeMillis();
                logger.info("\u5f00\u59cb\u8c03\u7528\u6279\u91cf\u83b7\u53d6\u9ed8\u8ba4\u7684\u4f9b\u8d27\u4fe1\u606f\u8003\u8651\u5185\u534f CreateStockByBomUtils.expandBomStocks PlanScopeHelper.getBatchDefSupplierInfoConsiderInterAssist");
                supplyInfos = PlanScopeHelper.getBatchDefSupplierInfoConsiderInterAssist(params);
                logger.info("\u751f\u6210\u7ec4\u4ef6\u6e05\u5355\uff1a\u5f00\u59cb\u8c03\u7528\u6279\u91cf\u83b7\u53d6\u9ed8\u8ba4\u7684\u4f9b\u8d27\u4fe1\u606f\u8003\u8651\u5185\u534f CreateStockByBomUtils.expandBomStocks PlanScopeHelper.getBatchDefSupplierInfoConsiderInterAssist cost:" + (System.currentTimeMillis() - startdate));
                params.clear();
            }
            baseData.setSupplyInfos(supplyInfos);
            CreateStockUtils.setStockEntryWareHousePlanScopeAll(stockEntry, baseData, orderEntry, org, materialsource, stockName);
            logger.info("updateWareHouseBefore,warehouseid\uff1a" + stockEntry.get("warehouseid") + "\uff0coutwarehouseid\uff1a" + stockEntry.get("outwarehouseid"));
            CreateStockUtils.updateWareHouseFromPlanScope(stockEntry);
            logger.info("updateWareHouseAfter,warehouseid\uff1a" + stockEntry.get("warehouseid") + "\uff0coutwarehouseid\uff1a" + stockEntry.get("outwarehouseid"));
        } else {
            CreateStockUtils.setStockEntryWareHouseNoPlanScopeAll(stockEntry, baseData, orderEntry, org, materialsource, stockName);
        }
    }

    private static void updateWareHouseFromPlanScope(DynamicObject stockentry) {
        HashSet<Long> masteridSet = new HashSet<Long>(16);
        HashSet<Long> outorgidSet = new HashSet<Long>(16);
        HashSet<Long> warehouseIdSet = new HashSet<Long>(16);
        HashSet<Long> warehouseOrgIdSet = new HashSet<Long>(16);
        DynamicObject material = stockentry.getDynamicObject("materialid");
        if (stockentry.getBoolean("isstockallot") && material != null) {
            masteridSet.add((Long)material.getDynamicObject("masterid").getPkValue());
            CreateStockUtils.addSetValue(outorgidSet, warehouseIdSet, warehouseOrgIdSet, stockentry);
        }
        Map<Long, Map<Long, Set<Long>>> orgMasterIdPlanscopeMap = CreateStockUtils.getOrgMasterIdPlanscopeMap(outorgidSet, masteridSet);
        Map<String, Long> orgWarehousePlanscopeMap = CreateStockUtils.getOrgWarehousePlanscopeMap(warehouseIdSet, warehouseOrgIdSet);
        if (stockentry.getBoolean("isstockallot") && material != null) {
            Set<Long> planscopeSet;
            Long outorgunitId;
            Map<Long, Set<Long>> masterIdPlanscopeMap;
            Long masterid = (Long)material.getDynamicObject("masterid").getPkValue();
            Object outorgunit = stockentry.get("outorgunitid");
            if (outorgunit != null && !"0".equals(outorgunit.toString()) && (masterIdPlanscopeMap = orgMasterIdPlanscopeMap.get(outorgunitId = CreateStockUtils.getPkid(outorgunit))) != null && (planscopeSet = masterIdPlanscopeMap.get(masterid)) != null && CreateStockUtils.getIsNeedChange(stockentry, outorgunitId, orgWarehousePlanscopeMap, planscopeSet).booleanValue()) {
                stockentry.set("supplyorgid", stockentry.get("outorgunitid"));
                stockentry.set("warehouseid", stockentry.get("outwarehouseid"));
                stockentry.set("location", stockentry.get("outlocation"));
                if (stockentry.get("outwarehouseid") instanceof Long) {
                    stockentry.set("warehouseid_id", stockentry.get("outwarehouseid"));
                    stockentry.set("location_id", stockentry.get("outlocation"));
                }
            }
        }
    }

    public static void setStockWareHouse(List<DynamicObject> saveBomStocks, OrderBaseData baseData) {
        if (saveBomStocks == null || saveBomStocks.isEmpty()) {
            return;
        }
        if (baseData == null) {
            baseData = new OrderBaseData();
        }
        HashMap<Long, Set<Long>> orgMasterSet = new HashMap<Long, Set<Long>>(16);
        for (DynamicObject saveBomStock : saveBomStocks) {
            Long orgId = CreateStockUtils.getPkid(saveBomStock.get("org"));
            DynamicObjectCollection stockentrys = saveBomStock.getDynamicObjectCollection("stockentry");
            for (DynamicObject stockentry : stockentrys) {
                Long masterid = CreateStockUtils.getPkid(stockentry.get("materielmasterid"));
                DynamicObject innerOrg = CreateStockUtils.getinnerOrg(baseData, orgId, masterid);
                if (innerOrg == null) continue;
                CreateStockUtils.putMapSet(orgMasterSet, CreateStockUtils.getPkid(innerOrg), masterid);
            }
        }
        if (!orgMasterSet.isEmpty()) {
            CreateStockUtils.setBaseDataMftInfo(orgMasterSet, baseData);
        }
        boolean usePlanscope = PlanScopeHelper.isUsePlanscope();
        String stockName = saveBomStocks.get(0).getDataEntityType().getName();
        if (usePlanscope && !"om_componentlist".equals(stockName) && !"om_xxcomponentlist".equals(stockName)) {
            HashMap<String, LinkedList<Object>> params = new HashMap<String, LinkedList<Object>>(16);
            CreateStockUtils.getSupplyParams(saveBomStocks, baseData, params);
            Map<String, Map<String, Long>> supplyInfos = null;
            if (params.size() > 0) {
                Long startdate = System.currentTimeMillis();
                logger.info("\u5f00\u59cb\u8c03\u7528\u6279\u91cf\u83b7\u53d6\u9ed8\u8ba4\u7684\u4f9b\u8d27\u4fe1\u606f\u8003\u8651\u5185\u534f CreateStockByBomUtils.expandBomStocks PlanScopeHelper.getBatchDefSupplierInfoConsiderInterAssist");
                supplyInfos = PlanScopeHelper.getBatchDefSupplierInfoConsiderInterAssist(params);
                logger.info("\u751f\u6210\u7ec4\u4ef6\u6e05\u5355\uff1a\u5f00\u59cb\u8c03\u7528\u6279\u91cf\u83b7\u53d6\u9ed8\u8ba4\u7684\u4f9b\u8d27\u4fe1\u606f\u8003\u8651\u5185\u534f CreateStockByBomUtils.expandBomStocks PlanScopeHelper.getBatchDefSupplierInfoConsiderInterAssist cost:" + (System.currentTimeMillis() - startdate));
                params.clear();
            }
            baseData.setSupplyInfos(supplyInfos);
            for (DynamicObject saveBomStock : saveBomStocks) {
                DynamicObject org = saveBomStock.getDynamicObject("org");
                String materialsource = "B";
                DynamicObject transactproduct = CreateStockUtils.getTran(saveBomStock, stockName, baseData);
                if (transactproduct != null) {
                    materialsource = transactproduct.getString("materialsource");
                }
                Long orderEntryId = CreateStockUtils.getPkid(saveBomStock.get("orderentryid"));
                DynamicObject orderEntry = baseData.getOrderEntry(orderEntryId);
                DynamicObjectCollection stockentrys = saveBomStock.getDynamicObjectCollection("stockentry");
                for (DynamicObject stockEntry : stockentrys) {
                    DynamicObject orgfield;
                    CreateStockUtils.setStockEntryWareHousePlanScopeAll(stockEntry, baseData, orderEntry, org, materialsource, stockName);
                    if (!"bos_org".equals(stockEntry.get("supplymode")) || (orgfield = (DynamicObject)stockEntry.get("supplyorgid")) == null) continue;
                    Long orgfieldId = (Long)orgfield.getPkValue();
                    stockEntry.set("supplierid", CreateStockByBomUtils.getSupplyByBaseData(baseData, orgfieldId));
                }
            }
            CreateStockUtils.updateWareHouseFromPlanScope(saveBomStocks);
        } else {
            for (DynamicObject saveBomStock : saveBomStocks) {
                DynamicObject org = saveBomStock.getDynamicObject("org");
                String materialsource = "B";
                DynamicObject transactproduct = CreateStockUtils.getTran(saveBomStock, stockName, baseData);
                if (transactproduct != null) {
                    materialsource = transactproduct.getString("materialsource");
                }
                Long orderEntryId = CreateStockUtils.getPkid(saveBomStock.get("orderentryid"));
                DynamicObject orderEntry = baseData.getOrderEntry(orderEntryId);
                DynamicObjectCollection stockentrys = saveBomStock.getDynamicObjectCollection("stockentry");
                for (DynamicObject stockEntry : stockentrys) {
                    DynamicObject orgfield;
                    CreateStockUtils.setStockEntryWareHouseNoPlanScopeAll(stockEntry, baseData, orderEntry, org, materialsource, stockName);
                    if (!"bos_org".equals(stockEntry.get("supplymode")) || (orgfield = (DynamicObject)stockEntry.get("supplyorgid")) == null) continue;
                    Long orgfieldId = (Long)orgfield.getPkValue();
                    stockEntry.set("supplierid", CreateStockByBomUtils.getSupplyByBaseData(baseData, orgfieldId));
                }
            }
        }
    }

    private static void setStockEntryWareHouseNoPlanScopeAll(DynamicObject stockEntry, OrderBaseData baseData, DynamicObject orderEntry, DynamicObject org, String materialsource, String stockName) {
        DynamicObject materialmftInfo;
        Long orgId = CreateStockUtils.getPkid(org);
        Long masterid = CreateStockUtils.getPkid(stockEntry.get("materielmasterid"));
        DynamicObject bomOrProgRow = null;
        if (!"pom_mrostock".equals(stockName)) {
            Long bomEntryId = CreateStockUtils.getPkid(stockEntry.get("bomentryid"));
            Map<Long, DynamicObject> bomEntryMap = baseData.getBomEntryMap();
            bomOrProgRow = bomEntryMap.get(bomEntryId);
            if (null == bomOrProgRow && "prop_mftstock".equals(stockName)) {
                Long progentryid = CreateStockUtils.getPkid(stockEntry.get("progentryid"));
                bomOrProgRow = baseData.getProgEntryMap().get(progentryid);
            }
        }
        if ((materialmftInfo = baseData.getOrgMaterialMftInfo(orgId, masterid)) == null) {
            return;
        }
        DynamicObject innerOrg = CreateStockUtils.getinnerOrg(baseData, orgId, masterid);
        if (innerOrg == null) {
            CreateStockUtils.setWareHouseByMaterialSource(materialmftInfo, bomOrProgRow, materialsource, stockEntry);
            if ("pom_mftstock".equals(stockName) || "om_mftstock".equals(stockName) || "prop_mftstock".equals(stockName)) {
                CreateStockUtils.setStockEntryWarehouse(org, stockEntry, orderEntry, baseData);
            }
            CreateStockUtils.setOutWareHouseByMaterialSource(materialmftInfo, bomOrProgRow, materialsource, stockEntry);
        } else {
            DynamicObject innerMaterialmftInfo = baseData.getOrgMaterialMftInfo(CreateStockUtils.getPkid(innerOrg), masterid);
            if (innerMaterialmftInfo == null) {
                stockEntry.set("supplyorgid", (Object)innerOrg);
                stockEntry.set("warehouseid", null);
                stockEntry.set("location", null);
                if (stockEntry.getBoolean("isstockallot")) {
                    stockEntry.set("outorgunitid", (Object)innerOrg);
                    stockEntry.set("outwarehouseid", null);
                    stockEntry.set("outlocation", null);
                }
            }
            CreateStockUtils.setWareHouseByMaterialSource(innerMaterialmftInfo, bomOrProgRow, materialsource, stockEntry);
            if ("pom_mftstock".equals(stockName) || "om_mftstock".equals(stockName) || "prop_mftstock".equals(stockName)) {
                CreateStockUtils.setStockEntryWarehouse(org, stockEntry, orderEntry, baseData);
            }
            CreateStockUtils.setOutWareHouseByMaterialSource(innerMaterialmftInfo, bomOrProgRow, materialsource, stockEntry);
        }
    }

    private static void setStockEntryWareHousePlanScopeAll(DynamicObject stockEntry, OrderBaseData baseData, DynamicObject orderEntry, DynamicObject org, String materialsource, String stockName) {
        Long masterid = CreateStockUtils.getPkid(stockEntry.get("materielmasterid"));
        Long orgId = CreateStockUtils.getPkid(org);
        DynamicObject materialmftInfo = baseData.getOrgMaterialMftInfo(orgId, masterid);
        Long bomEntryId = CreateStockUtils.getPkid(stockEntry.get("bomentryid"));
        Map<Long, DynamicObject> bomEntryMap = baseData.getBomEntryMap();
        DynamicObject bomOrProgRow = bomEntryMap.get(bomEntryId);
        if (null == bomOrProgRow && "prop_mfstock".equals(stockName)) {
            Long progentryid = CreateStockUtils.getPkid(stockEntry.get("progentryid"));
            bomOrProgRow = baseData.getProgEntryMap().get(progentryid);
        }
        if (materialmftInfo == null) {
            return;
        }
        DynamicObject innerOrg = CreateStockUtils.getinnerOrg(baseData, orgId, masterid);
        if (innerOrg == null) {
            if (stockEntry.getBoolean("isstockallot")) {
                if ("om_mftstock".equals(stockName)) {
                    PlanScopeHelper.setStockEntryWarehouseByPlanScopeSer(baseData, stockEntry, orderEntry, org, materialmftInfo, bomOrProgRow);
                } else {
                    CreateStockUtils.setWareHouseByMaterialSource(materialmftInfo, bomOrProgRow, materialsource, stockEntry);
                }
                if ("pom_mftstock".equals(stockName) || "om_mftstock".equals(stockName) || "prop_mftstock".equals(stockName)) {
                    CreateStockUtils.setStockEntryWarehouse(org, stockEntry, orderEntry, baseData);
                }
                PlanScopeHelper.setStockEntryOutWarehouseByPlanScopeSer(baseData, stockEntry, orderEntry, org, materialmftInfo, bomOrProgRow);
            } else {
                PlanScopeHelper.setStockEntryWarehouseByPlanScopeSer(baseData, stockEntry, orderEntry, org, materialmftInfo, bomOrProgRow);
            }
        } else {
            DynamicObject innerMaterialmftInfo = baseData.getOrgMaterialMftInfo(CreateStockUtils.getPkid(innerOrg), masterid);
            if (innerMaterialmftInfo != null) {
                if (stockEntry.getBoolean("isstockallot")) {
                    if ("om_mftstock".equals(stockName)) {
                        PlanScopeHelper.setStockEntryWarehouseByPlanScopeSer(baseData, stockEntry, orderEntry, org, innerMaterialmftInfo, bomOrProgRow);
                    } else {
                        CreateStockUtils.setWareHouseByMaterialSource(innerMaterialmftInfo, bomOrProgRow, materialsource, stockEntry);
                    }
                    if ("pom_mftstock".equals(stockName) || "om_mftstock".equals(stockName) || "prop_mftstock".equals(stockName)) {
                        CreateStockUtils.setStockEntryWarehouse(org, stockEntry, orderEntry, baseData);
                    }
                    PlanScopeHelper.setStockEntryOutWarehouseByPlanScopeSer(baseData, stockEntry, orderEntry, org, innerMaterialmftInfo, bomOrProgRow);
                } else {
                    PlanScopeHelper.setStockEntryWarehouseByPlanScopeSer(baseData, stockEntry, orderEntry, org, innerMaterialmftInfo, bomOrProgRow);
                }
            } else {
                stockEntry.set("supplyorgid", (Object)innerOrg);
                stockEntry.set("warehouseid", null);
                stockEntry.set("location", null);
                if (stockEntry.getBoolean("isstockallot")) {
                    stockEntry.set("outorgunitid", (Object)innerOrg);
                    stockEntry.set("outwarehouseid", null);
                    stockEntry.set("outlocation", null);
                }
            }
        }
    }

    private static void setBaseDataMftInfo(Map<Long, Set<Long>> orgMasterSet, OrderBaseData baseData) {
        for (Map.Entry<Long, Set<Long>> m : orgMasterSet.entrySet()) {
            Map<Object, DynamicObject> mftMap = MaterialMftQueryHelper.getDataCacheByMaterialSet(m.getValue(), m.getKey());
            Map<Long, Object> orgMaterialMftInfoMap = baseData.getOrgMaterialMftInfoMap();
            HashMap<Long, DynamicObject> materialMftInfoMap = (HashMap<Long, DynamicObject>)orgMaterialMftInfoMap.get(m.getKey());
            if (materialMftInfoMap == null) {
                materialMftInfoMap = new HashMap<Long, DynamicObject>(16);
            }
            for (Map.Entry<Object, DynamicObject> loadMap : mftMap.entrySet()) {
                DynamicObject load = loadMap.getValue();
                if (load == null) continue;
                DynamicObject master = load.getDynamicObject("masterid");
                load.set("number", master.get("number"));
                materialMftInfoMap.put((Long)master.getPkValue(), load);
            }
            orgMaterialMftInfoMap.put(m.getKey(), materialMftInfoMap);
        }
    }

    private static void updateWareHouseFromPlanScope(List<DynamicObject> saveBomStocks) {
        HashSet<Long> masteridSet = new HashSet<Long>(16);
        HashSet<Long> outorgidSet = new HashSet<Long>(16);
        HashSet<Long> warehouseIdSet = new HashSet<Long>(16);
        HashSet<Long> warehouseOrgIdSet = new HashSet<Long>(16);
        for (DynamicObject data : saveBomStocks) {
            DynamicObjectCollection stockentrys = data.getDynamicObjectCollection("stockentry");
            for (DynamicObject stockentry : stockentrys) {
                DynamicObject material = stockentry.getDynamicObject("materialid");
                if (!stockentry.getBoolean("isstockallot") || material == null) continue;
                masteridSet.add((Long)material.getDynamicObject("masterid").getPkValue());
                CreateStockUtils.addSetValue(outorgidSet, warehouseIdSet, warehouseOrgIdSet, stockentry);
            }
        }
        Map<Long, Map<Long, Set<Long>>> orgMasterIdPlanscopeMap = CreateStockUtils.getOrgMasterIdPlanscopeMap(outorgidSet, masteridSet);
        Map<String, Long> orgWarehousePlanscopeMap = CreateStockUtils.getOrgWarehousePlanscopeMap(warehouseIdSet, warehouseOrgIdSet);
        for (DynamicObject data : saveBomStocks) {
            DynamicObjectCollection stockentrys = data.getDynamicObjectCollection("stockentry");
            for (DynamicObject stockentry : stockentrys) {
                Set<Long> planscopeSet;
                Long outorgunitId;
                Map<Long, Set<Long>> masterIdPlanscopeMap;
                DynamicObject material = stockentry.getDynamicObject("materialid");
                if (!stockentry.getBoolean("isstockallot") || material == null) continue;
                Long masterid = (Long)material.getDynamicObject("masterid").getPkValue();
                Object outorgunit = stockentry.get("outorgunitid");
                if (outorgunit == null || "0".equals(outorgunit.toString()) || (masterIdPlanscopeMap = orgMasterIdPlanscopeMap.get(outorgunitId = CreateStockUtils.getPkid(outorgunit))) == null || (planscopeSet = masterIdPlanscopeMap.get(masterid)) == null || !CreateStockUtils.getIsNeedChange(stockentry, outorgunitId, orgWarehousePlanscopeMap, planscopeSet).booleanValue()) continue;
                stockentry.set("supplyorgid", stockentry.get("outorgunitid"));
                stockentry.set("warehouseid", stockentry.get("outwarehouseid"));
                stockentry.set("location", stockentry.get("outlocation"));
                if (!(stockentry.get("outwarehouseid") instanceof Long)) continue;
                stockentry.set("warehouseid_id", stockentry.get("outwarehouseid"));
                stockentry.set("location_id", stockentry.get("outlocation"));
            }
        }
    }

    private static Boolean getIsNeedChange(DynamicObject stockentry, Long outorgunitId, Map<String, Long> orgWarehousePlanscopeMap, Set<Long> planscopeSet) {
        Boolean isneedChange = false;
        Long outwarehouseId = CreateStockUtils.getPkid(stockentry.get("outwarehouseid"));
        Long warehouseid = CreateStockUtils.getPkid(stockentry.get("warehouseid"));
        Long supplyorgid = CreateStockUtils.getPkid(stockentry.get("supplyorgid"));
        if (!("0".equals(Long.toString(outwarehouseId)) || "0".equals(Long.toString(warehouseid)) || "0".equals(Long.toString(supplyorgid)))) {
            Long outPlanId = orgWarehousePlanscopeMap.get(Long.toString(outorgunitId) + Long.toString(outwarehouseId));
            Long planId = orgWarehousePlanscopeMap.get(Long.toString(supplyorgid) + Long.toString(warehouseid));
            if (outPlanId != null && planId != null && !Long.toString(outPlanId).equals(Long.toString(planId)) && (planscopeSet.contains(outPlanId) || planscopeSet.contains(planId))) {
                isneedChange = true;
            }
            if (outPlanId == null && planId != null && planscopeSet.contains(planId)) {
                isneedChange = true;
            }
            if (planId == null && outPlanId != null && planscopeSet.contains(outPlanId)) {
                isneedChange = true;
            }
        }
        return isneedChange;
    }

    private static Map<String, Long> getOrgWarehousePlanscopeMap(Set<Long> warehouseIdSet, Set<Long> warehouseOrgIdSet) {
        HashMap<String, Long> orgWarehousePlanscopeMap = new HashMap<String, Long>(16);
        QFilter qFilter = new QFilter("createorg", "in", warehouseOrgIdSet);
        qFilter.and("warehouse", "in", warehouseIdSet);
        DynamicObjectCollection matplanscopDym = QueryServiceHelper.query((String)"msplan_planscope_whs", (String)"createorg.id,warehouse.id,planscope.id", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject matplanscop : matplanscopDym) {
            Long orgId = matplanscop.getLong("createorg.id");
            Long warehouseId = matplanscop.getLong("warehouse.id");
            Long planscopeId = matplanscop.getLong("planscope.id");
            orgWarehousePlanscopeMap.put(Long.toString(orgId) + Long.toString(warehouseId), planscopeId);
        }
        return orgWarehousePlanscopeMap;
    }

    private static void addSetValue(Set<Long> outorgidSet, Set<Long> warehouseIdSet, Set<Long> warehouseOrgIdSet, DynamicObject stockentry) {
        Object supplyorgid;
        Object warehouseid;
        Object outwarehouseid;
        Object outorgunitid = stockentry.get("outorgunitid");
        if (outorgunitid != null && !"0".equals(outorgunitid.toString())) {
            outorgidSet.add(CreateStockUtils.getPkid(outorgunitid));
            warehouseOrgIdSet.add(CreateStockUtils.getPkid(outorgunitid));
        }
        if ((outwarehouseid = stockentry.get("outwarehouseid")) != null && !"0".equals(outwarehouseid.toString())) {
            warehouseIdSet.add(CreateStockUtils.getPkid(outwarehouseid));
        }
        if ((warehouseid = stockentry.get("warehouseid")) != null && !"0".equals(warehouseid.toString())) {
            warehouseIdSet.add(CreateStockUtils.getPkid(warehouseid));
        }
        if ((supplyorgid = stockentry.get("supplyorgid")) != null && !"0".equals(supplyorgid.toString())) {
            warehouseOrgIdSet.add(CreateStockUtils.getPkid(supplyorgid));
        }
    }

    private static Map<Long, Map<Long, Set<Long>>> getOrgMasterIdPlanscopeMap(Set<Long> outorgidSet, Set<Long> masteridSet) {
        HashMap<Long, Map<Long, Set<Long>>> orgMasterIdPlanscopeMap = new HashMap<Long, Map<Long, Set<Long>>>(16);
        QFilter qFilter = new QFilter("entrymatplanscop.supplier_org", "in", outorgidSet);
        qFilter.and("material", "in", masteridSet);
        qFilter.and("entrymatplanscop.start_useing", "=", (Object)true);
        DynamicObjectCollection matplanscopDym = QueryServiceHelper.query((String)"msplan_matplanscop", (String)"material.id,entrymatplanscop.planscope.id,entrymatplanscop.supplier_org.id", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject matplanscop : matplanscopDym) {
            HashSet<Long> planscopeSet;
            Long supplierorgId = matplanscop.getLong("entrymatplanscop.supplier_org.id");
            Long masterId = matplanscop.getLong("material.id");
            Long planscopeId = matplanscop.getLong("entrymatplanscop.planscope.id");
            HashMap<Long, HashSet<Long>> masterIdPlanscopeMap = (HashMap<Long, HashSet<Long>>)orgMasterIdPlanscopeMap.get(supplierorgId);
            if (masterIdPlanscopeMap == null) {
                masterIdPlanscopeMap = new HashMap<Long, HashSet<Long>>(16);
            }
            if ((planscopeSet = (HashSet<Long>)masterIdPlanscopeMap.get(masterId)) == null) {
                planscopeSet = new HashSet<Long>(16);
            }
            planscopeSet.add(planscopeId);
            masterIdPlanscopeMap.put(masterId, planscopeSet);
            orgMasterIdPlanscopeMap.put(supplierorgId, masterIdPlanscopeMap);
        }
        return orgMasterIdPlanscopeMap;
    }

    private static void setOutWareHouseByMaterialSource(DynamicObject orgMaterialMftInfo, DynamicObject bomOrProgRow, String materialsource, DynamicObject stockEntry) {
        if (stockEntry.getBoolean("isstockallot")) {
            if ("B".equals(materialsource) || bomOrProgRow == null) {
                if (orgMaterialMftInfo != null) {
                    stockEntry.set("outorgunitid", orgMaterialMftInfo.get("outstorageunit"));
                    stockEntry.set("outwarehouseid", orgMaterialMftInfo.get("outwarehouse"));
                    stockEntry.set("outlocation", orgMaterialMftInfo.get("outwarelocation"));
                }
            } else {
                stockEntry.set("outorgunitid", bomOrProgRow.get("entryoutorg"));
                stockEntry.set("outwarehouseid", bomOrProgRow.get("entryoutwarehouse"));
                stockEntry.set("outlocation", bomOrProgRow.get("entryoutlocation"));
            }
        }
    }

    private static void setWareHouseByMaterialSource(DynamicObject innerMaterialmftInfo, DynamicObject bomOrProgEntry, String materialsource, DynamicObject stockEntry) {
        if ("B".equals(materialsource) || bomOrProgEntry == null) {
            if (innerMaterialmftInfo != null) {
                stockEntry.set("supplyorgid", (Object)innerMaterialmftInfo.getDynamicObject("supplyorgunitid"));
                stockEntry.set("warehouseid", innerMaterialmftInfo.get("warehouse"));
                stockEntry.set("location", innerMaterialmftInfo.get("location"));
            }
        } else {
            stockEntry.set("supplyorgid", bomOrProgEntry.get("entrysupplyorg"));
            stockEntry.set("warehouseid", bomOrProgEntry.get("entrywarehouse"));
            stockEntry.set("location", bomOrProgEntry.get("entrylocation"));
        }
    }

    private static DynamicObject getinnerOrg(OrderBaseData baseData, Long orgId, Long masterid) {
        DynamicObject supplynetwork;
        DynamicObject orgMaterialPlanInfo = baseData.getOrgMaterialPlanInfo(orgId, masterid);
        if (orgMaterialPlanInfo != null && "10060".equals(orgMaterialPlanInfo.getString("materialattr")) && orgMaterialPlanInfo.getDynamicObject("supplynetwork") != null && (supplynetwork = orgMaterialPlanInfo.getDynamicObject("supplynetwork")) != null) {
            DynamicObject supplynetworkQuery;
            Map<Object, DynamicObject> supplynetworkMap = baseData.getSupplynetworkMap();
            DynamicObject supplynetworkNew = supplynetworkMap.get(supplynetwork.getPkValue());
            if (supplynetworkNew == null && (supplynetworkQuery = BusinessDataServiceHelper.loadSingleFromCache((String)"mrp_definitionsupply", (String)"number,defsupplytype,orgentry.supplyorg,orgentry.supplyproportion,orgentry.supplyrule,orgentry.supplyorgtype", (QFilter[])new QFilter[]{new QFilter("id", "=", supplynetwork.getPkValue())})) != null) {
                logger.info("\u4f9b\u5e94\u7f51\u7edc\u672a\u505a\u6570\u636e\u51c6\u5907\u8bf7\u68c0\u67e5\u3002");
                supplynetworkNew = supplynetworkQuery;
                supplynetworkMap.put(supplynetworkQuery.getPkValue(), supplynetworkQuery);
            }
            if (supplynetworkNew != null) {
                DynamicObject defsupplytype = supplynetworkNew.getDynamicObject("defsupplytype");
                DynamicObjectCollection orgentrys = supplynetworkNew.getDynamicObjectCollection("orgentry");
                for (DynamicObject orgentry : orgentrys) {
                    DynamicObject supplyorgtype = orgentry.getDynamicObject("supplyorgtype");
                    DynamicObject supplyorg = orgentry.getDynamicObject("supplyorg");
                    String supplyrule = orgentry.getString("supplyrule");
                    if (defsupplytype == null || supplyorgtype == null || !defsupplytype.getPkValue().toString().equals(supplyorgtype.getPkValue().toString()) || !"A".equals(supplyrule)) continue;
                    return supplyorg;
                }
            }
        }
        return null;
    }

    private static void getSupplyParams(DynamicObject stockEntry, DynamicObject orderEntry, DynamicObject org, OrderBaseData baseData, Map<String, LinkedList<Object>> params) {
        DynamicObject manuVersiontInfo = orderEntry.getDynamicObject("manuversion");
        Long orgId = (Long)org.getPkValue();
        Long masterid = CreateStockUtils.getPkid(stockEntry.get("materielmasterid"));
        DynamicObject materialmftInfo = baseData.getOrgMaterialMftInfo(orgId, masterid);
        Long bomEntryId = CreateStockUtils.getPkid(stockEntry.get("bomentryid"));
        Object bomEntry = null;
        DynamicObject innerOrg = CreateStockUtils.getinnerOrg(baseData, orgId, masterid);
        if (innerOrg != null) {
            materialmftInfo = baseData.getOrgMaterialMftInfo(CreateStockUtils.getPkid(innerOrg), masterid);
        }
        Long entrymaterialId = materialmftInfo == null ? 0L : materialmftInfo.getLong("id");
        Long manuVersionId = manuVersiontInfo == null ? 0L : manuVersiontInfo.getLong("id");
        StringBuilder keystr = new StringBuilder(150);
        keystr.append(entrymaterialId).append(org.getPkValue()).append(manuVersionId).append(bomEntryId);
        LinkedList param = params.computeIfAbsent(keystr.toString(), k -> new LinkedList());
        param.add(bomEntry);
        param.add(materialmftInfo);
        param.add(org);
        param.add(manuVersiontInfo);
        param.add(innerOrg);
    }

    private static void getSupplyParams(List<DynamicObject> saveBomStocks, OrderBaseData baseData, Map<String, LinkedList<Object>> params) {
        Map<Long, DynamicObject> bomEntryMap = baseData.getBomEntryMap();
        for (DynamicObject saveBomStock : saveBomStocks) {
            DynamicObjectCollection stockEntrys = saveBomStock.getDynamicObjectCollection("stockentry");
            Long orderEntryId = CreateStockUtils.getPkid(saveBomStock.get("orderentryid"));
            DynamicObject orderEntry = baseData.getOrderEntry(orderEntryId);
            DynamicObject manuVersiontInfo = orderEntry.getDynamicObject("manuversion");
            DynamicObject org = saveBomStock.getDynamicObject("org");
            Long orgId = (Long)org.getPkValue();
            for (DynamicObject stockEntry : stockEntrys) {
                Long masterid = CreateStockUtils.getPkid(stockEntry.get("materielmasterid"));
                DynamicObject materialmftInfo = baseData.getOrgMaterialMftInfo(orgId, masterid);
                Long bomEntryId = CreateStockUtils.getPkid(stockEntry.get("bomentryid"));
                DynamicObject bomEntry = bomEntryMap.get(bomEntryId);
                DynamicObject innerOrg = CreateStockUtils.getinnerOrg(baseData, orgId, masterid);
                if (innerOrg != null) {
                    materialmftInfo = baseData.getOrgMaterialMftInfo(CreateStockUtils.getPkid(innerOrg), masterid);
                }
                Long entrymaterialId = materialmftInfo == null ? 0L : materialmftInfo.getLong("id");
                Long manuVersionId = manuVersiontInfo == null ? 0L : manuVersiontInfo.getLong("id");
                StringBuilder keystr = new StringBuilder(150);
                keystr.append(entrymaterialId).append(org.getPkValue()).append(manuVersionId).append(bomEntryId);
                LinkedList param = params.computeIfAbsent(keystr.toString(), k -> new LinkedList());
                param.add(bomEntry);
                param.add(materialmftInfo);
                param.add(org);
                param.add(manuVersiontInfo);
                param.add(innerOrg);
            }
        }
    }

    private static void putMapSet(Map<Long, Set<Long>> orgMasterSet, Long orgkey, Long masteridValue) {
        Set<Long> masteridSet = orgMasterSet.get(orgkey);
        if (masteridSet == null) {
            masteridSet = new HashSet<Long>(16);
        }
        masteridSet.add(masteridValue);
        orgMasterSet.put(orgkey, masteridSet);
    }

    public static void getMaterialMftInfoByMaster(Long orgId, Map<Long, Object> orgMaterialMftInfoMap, Map<Long, Set<Long>> orgMasterMap, Set<Long> supplyOrgIdSet) {
        Set<Long> masterSet = orgMasterMap.get(orgId);
        Map<Object, DynamicObject> mftMap = MaterialMftQueryHelper.getDataCacheByMaterialSet(masterSet, orgId);
        HashMap<Long, DynamicObject> materialMftInfoMap = (HashMap<Long, DynamicObject>)orgMaterialMftInfoMap.get(orgId);
        if (materialMftInfoMap == null) {
            materialMftInfoMap = new HashMap<Long, DynamicObject>(16);
        }
        for (Map.Entry<Object, DynamicObject> loadMap : mftMap.entrySet()) {
            DynamicObject load = loadMap.getValue();
            if (load == null) continue;
            DynamicObject master = load.getDynamicObject("masterid");
            load.set("number", master.get("number"));
            materialMftInfoMap.put((Long)master.getPkValue(), load);
            DynamicObject supply = load.getDynamicObject("supplyorgunitid");
            if (supply == null) continue;
            supplyOrgIdSet.add((Long)supply.getPkValue());
        }
        orgMaterialMftInfoMap.put(orgId, materialMftInfoMap);
    }

    public static void getMaterialPlanInfoByMaster(Long orgId, Map<Long, Object> orgMasterWastMap, Map<Long, Map<Long, DynamicObject>> orgMaterialPlanInfoMap, Map<Long, Set<Long>> orgMasterMap, OrderBaseData baseData) {
        Set<Long> masterSet = orgMasterMap.get(orgId);
        Map<Object, DynamicObject> planMap = MaterialPlanQueryHelper.getDataCacheByMaterialSet(masterSet, orgId);
        HashMap<Long, String> masterWastagerateformulaMap = (HashMap<Long, String>)orgMasterWastMap.get(orgId);
        if (masterWastagerateformulaMap == null) {
            masterWastagerateformulaMap = new HashMap<Long, String>(16);
        }
        Map materialPlanInfoMap = orgMaterialPlanInfoMap.computeIfAbsent(orgId, k -> new HashMap(16));
        for (Map.Entry<Object, DynamicObject> loadMap : planMap.entrySet()) {
            DynamicObject load = loadMap.getValue();
            if (load == null) continue;
            long materialmasterid = (Long)load.getDynamicObject("masterid").getPkValue();
            masterWastagerateformulaMap.put(materialmasterid, load.getString("wastagerateformula"));
            materialPlanInfoMap.put(materialmasterid, load);
        }
        Map<Object, DynamicObject> supplynetworkMap = baseData.getSupplynetworkMap();
        supplynetworkMap.putAll(PlanScopeHelper.getSupplynetworkMap(materialPlanInfoMap.values()));
        orgMasterWastMap.put(orgId, masterWastagerateformulaMap);
    }
}

