/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.mftorder.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bd.mpdm.common.mftorder.entity.Promater;
import kd.bd.mpdm.common.mftorder.enums.ManuBillBizStatusEnum;
import kd.bd.mpdm.common.mftorder.enums.ManuBillPickStatusEnum;
import kd.bd.mpdm.common.mftorder.enums.ManuBillPlanStatusEnum;
import kd.bd.mpdm.common.mftorder.enums.ManuBillTaskStatusEnum;
import kd.bd.mpdm.common.mftorder.helper.GetEntityNameHelper;
import kd.bd.mpdm.common.mftorder.helper.MaterialHelper;
import kd.bd.mpdm.common.mftorder.utils.CalendarUtils;
import kd.bd.mpdm.common.mftorder.utils.CreateStockByBomUtils;
import kd.bd.mpdm.common.mftorder.utils.CreateStockUtils;
import kd.bd.mpdm.common.mftorder.utils.OrderBaseData;
import kd.bd.mpdm.common.mftorder.utils.OrderOpUtils;
import kd.bd.mpdm.common.mftorder.utils.PlanScopeHelper;
import kd.bd.mpdm.common.mftorder.utils.StockCulUtils;
import kd.bd.mpdm.common.mftorderbom.utils.BomBaseData;
import kd.bd.mpdm.common.query.helper.WarehouseQueryHelper;
import kd.bd.mpdm.common.query.helper.WorkcenterQueryHelper;
import kd.bd.mpdm.common.query.mservice.helper.MsBomQueryHelper;
import kd.bd.mpdm.common.query.mservice.helper.MsProMaterdtbQueryHelper;
import kd.bd.mpdm.common.query.mservice.helper.MsProcessRouteQueryHelper;
import kd.bd.mpdm.common.stockchange.utils.EntityNameUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.mmc.business.query.helper.BillTypeQueryHelper;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.sequence.SequenceReader;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import org.apache.commons.lang3.math.NumberUtils;

public class MPDMMftGenStocksUtils {
    public static BigDecimal ONEHUNDRED = new BigDecimal("100");
    private static final ThreadLocal<Map<String, Map<String, Object>>> omOrderQtyThreadLocal = new ThreadLocal();
    private static final String BOMREPLACENONAME = "bomreplacenoname";
    private static final String TRANSACTIONTYPEID = "transactiontypeid";
    private static final String ENTRYUNIT2 = "entryunit";
    private static final String ENTRYMATERIAL = "entrymaterial";
    private static final String ENTRYINVALIDDATE2 = "entryinvaliddate";
    private static final String REPLACENO = "replaceno";
    private static final String ENTRYVALIDDATE2 = "entryvaliddate";
    private static final String ENTRYQTYTYPE = "entryqtytype";
    private static final String PRECISION2 = "precision";
    private static final String ISCONSIDERLOSS2 = "isconsiderloss";
    private static final String ENTRYQTYNUMERATOR = "entryqtynumerator";
    private static final String ENTRYQTYDENOMINATOR = "entryqtydenominator";
    private static final String ENTRY = "entry";
    public static final String KEY_ENTRY_REPLACEPLAN = "replaceplan";
    public static final String KEY_ENTRY_PRIORITY = "priority";
    public static final String KEY_ENTRY_ISMAINREPLAC = "ismainreplace";
    private static final Log logger = LogFactory.getLog(MPDMMftGenStocksUtils.class);
    private static final ThreadLocal<Map<String, Object>> queryThreadLocal = new ThreadLocal();
    private static final ThreadLocal<Map<String, Object>> demandDateThreadLocal = new ThreadLocal();

    public static List<Object> getOwners(Long orgId) {
        ArrayList<Object> array = new ArrayList<Object>();
        if (orgId == null) {
            return array;
        }
        List ownerOrgs = OrgUnitServiceHelper.getFromOrgs((String)"05", (Long)orgId, (String)"10", (boolean)false);
        if (ownerOrgs != null && !ownerOrgs.isEmpty()) {
            for (int i = 0; i < ownerOrgs.size(); ++i) {
                Long ownerOrgId = (Long)ownerOrgs.get(i);
                if (array.contains(ownerOrgId)) continue;
                array.add(ownerOrgs.get(i));
            }
        }
        return array;
    }

    public static DynamicObject getManuEntryByEntryID(DynamicObject manuorder, String entryid) {
        DynamicObjectCollection orderentrys = manuorder.getDynamicObjectCollection("treeentryentity");
        for (DynamicObject orderentry : orderentrys) {
            if (!StringUtils.equals((CharSequence)orderentry.getPkValue().toString(), (CharSequence)entryid)) continue;
            return orderentry;
        }
        return null;
    }

    public static StringBuilder manufactureSelectProperties() {
        StringBuilder selectPro = new StringBuilder();
        selectPro.append("id,billno,org,org.fisinventory,transactiontype,biztype,billdate,billstatus,treeentryentity,treeentryentity.seq,treeentryentity.material,");
        selectPro.append("treeentryentity.baseunit,treeentryentity.producedept,treeentryentity.unit,treeentryentity.qty,treeentryentity.planbegintime,");
        selectPro.append("treeentryentity.planendtime,treeentryentity.bomid,treeentryentity.bomid.version,treeentryentity.replaceno,treeentryentity.processroute,");
        selectPro.append("treeentryentity.producttype,treeentryentity.planstatus,treeentryentity.taskstatus,treeentryentity.pickstatus,treeentryentity.auxproperty,treeentryentity.expendbomtime,");
        selectPro.append("treeentryentity.planbegintime,treeentryentity.planendtime,treeentryentity.routeversion");
        return selectPro;
    }

    public static String getIssuemode(Object ismode) {
        String issuemode = "";
        if ("11010".equals(ismode)) {
            issuemode = "A";
        } else if ("11050".equals(ismode)) {
            issuemode = "B";
        } else if ("11040".equals(ismode)) {
            issuemode = "C";
        }
        return issuemode;
    }

    public static BigDecimal calculateStandQty(DynamicObject unit, String qtyType, BigDecimal useratio, BigDecimal orderQty, BigDecimal qtynumerator, BigDecimal qtydenominator) {
        BigDecimal standQty = BigDecimal.ZERO;
        if (qtydenominator.compareTo(BigDecimal.ZERO) == 0) {
            throw new KDBizException(new ErrorCode("stock", ResManager.loadKDString((String)"\u5206\u6bcd\u4e0d\u80fd\u4e3a\u96f6\u3002", (String)"MPDMMftGenStocksUtils_15", (String)"bd-mpdm-common", (Object[])new Object[0])), new Object[0]);
        }
        if (StringUtils.equals((CharSequence)qtyType, (CharSequence)"A") || StringUtils.equals((CharSequence)qtyType, (CharSequence)"C")) {
            standQty = orderQty.multiply(useratio).multiply(qtynumerator).divide(qtydenominator, MPDMMftGenStocksUtils.getPrecision(unit), MPDMMftGenStocksUtils.getRoundType(unit));
        } else if (StringUtils.equals((CharSequence)qtyType, (CharSequence)"B")) {
            standQty = useratio.multiply(qtynumerator).divide(qtydenominator, MPDMMftGenStocksUtils.getPrecision(unit), MPDMMftGenStocksUtils.getRoundType(unit));
        }
        return standQty;
    }

    public static int getPrecision(DynamicObject entryunit) {
        if (entryunit == null) {
            return 2;
        }
        return entryunit.get(PRECISION2) == null ? 2 : entryunit.getInt(PRECISION2);
    }

    public static BigDecimal calculateDemadQty(DynamicObject unit, boolean isconsiderloss, BigDecimal standqty, BigDecimal scraprate, BigDecimal fixscrap, String wastagerateformula) {
        BigDecimal demandQty = isconsiderloss ? ("A".equals(wastagerateformula) && scraprate.compareTo(BigDecimal.ONE) != 0 ? standqty.divide(BigDecimal.ONE.subtract(scraprate), MPDMMftGenStocksUtils.getPrecision(unit), MPDMMftGenStocksUtils.getRoundType(unit)).add(fixscrap) : ("B".equals(wastagerateformula) ? standqty.multiply(BigDecimal.ONE.add(scraprate)).add(fixscrap) : standqty)) : standqty;
        if (standqty.compareTo(BigDecimal.ZERO) == 0) {
            demandQty = BigDecimal.ZERO;
        }
        demandQty = demandQty.setScale(MPDMMftGenStocksUtils.getPrecision(unit), MPDMMftGenStocksUtils.getRoundType(unit));
        return demandQty;
    }

    public static Object aculCanSendQty(DynamicObject stockEntry) {
        if (stockEntry != null) {
            BigDecimal demand = stockEntry.getBigDecimal("extraratioqty");
            BigDecimal actissue = stockEntry.getBigDecimal("actissueqty");
            BigDecimal rejecte = stockEntry.getBigDecimal("rejectedqty");
            BigDecimal feeding = stockEntry.getBigDecimal("feedingqty");
            BigDecimal scrap = stockEntry.getBigDecimal("scrapqty");
            BigDecimal cansend = BigDecimal.ZERO;
            cansend = cansend.add(demand == null ? BigDecimal.ZERO : demand);
            cansend = cansend.add(rejecte == null ? BigDecimal.ZERO : rejecte);
            cansend = cansend.subtract(actissue == null ? BigDecimal.ZERO : actissue);
            cansend = cansend.subtract(feeding == null ? BigDecimal.ZERO : feeding);
            if ((cansend = cansend.subtract(scrap == null ? BigDecimal.ZERO : scrap)).compareTo(BigDecimal.ZERO) < 0) {
                cansend = BigDecimal.ZERO;
            }
            return cansend;
        }
        return null;
    }

    public static Object aculUnSendQty(DynamicObject stockEntry) {
        if (stockEntry != null) {
            BigDecimal demand = stockEntry.getBigDecimal("demandqty");
            BigDecimal actissue = stockEntry.getBigDecimal("actissueqty");
            BigDecimal rejecte = stockEntry.getBigDecimal("rejectedqty");
            BigDecimal feeding = stockEntry.getBigDecimal("feedingqty");
            BigDecimal scrap = stockEntry.getBigDecimal("scrapqty");
            BigDecimal cansend = BigDecimal.ZERO;
            cansend = cansend.add(demand == null ? BigDecimal.ZERO : demand);
            cansend = cansend.add(rejecte == null ? BigDecimal.ZERO : rejecte);
            cansend = cansend.subtract(actissue == null ? BigDecimal.ZERO : actissue);
            cansend = cansend.subtract(feeding == null ? BigDecimal.ZERO : feeding);
            cansend = cansend.subtract(scrap == null ? BigDecimal.ZERO : scrap);
            return cansend;
        }
        return null;
    }

    public static BigDecimal aculOMUseQty(DynamicObject stockEntry, Object orderEntryId, DynamicObject transactiontype) {
        if (stockEntry.getBoolean("iscannegative")) {
            return BigDecimal.ZERO;
        }
        String deduction = transactiontype.getString("deduction");
        if ("A".equals(deduction)) {
            return MPDMMftGenStocksUtils.aculOMUseQtyA(stockEntry, orderEntryId);
        }
        return BigDecimal.ZERO;
    }

    private static BigDecimal aculOMUseQtyA(DynamicObject stockEntry, Object orderEntryId) {
        Map<String, Object> orderMap = MPDMMftGenStocksUtils.getOmOrderQtyMap(orderEntryId);
        if (orderMap.isEmpty()) {
            return BigDecimal.ZERO;
        }
        BigDecimal orderBaseQty = BigDecimal.ONE;
        BigDecimal stockqty = BigDecimal.ZERO;
        stockqty = (BigDecimal)orderMap.get("invbaseqty");
        orderBaseQty = (BigDecimal)orderMap.get("baseqty");
        String qtytype = stockEntry.getString("qtytype");
        BigDecimal useQty = BigDecimal.ZERO;
        if (orderBaseQty.compareTo(BigDecimal.ZERO) == 0) {
            orderBaseQty = BigDecimal.ONE;
        }
        if ("A".equals(qtytype) || "C".equals(qtytype)) {
            BigDecimal demandBaseQty = stockEntry.getBigDecimal("demandqty");
            useQty = stockqty.multiply(demandBaseQty).divide(orderBaseQty, 8, 4);
        }
        if ("B".equals(qtytype)) {
            useQty = stockqty.compareTo(orderBaseQty) >= 0 ? stockEntry.getBigDecimal("demandqty") : BigDecimal.ZERO;
        }
        return useQty;
    }

    public static Object aculActissueQty(DynamicObject stockEntry) {
        if (stockEntry != null) {
            BigDecimal actissueQty = stockEntry.getBigDecimal("actissueqty");
            if (stockEntry.getBoolean("iscannegative")) {
                actissueQty = stockEntry.getBigDecimal("demandqty");
            }
            return actissueQty;
        }
        return null;
    }

    public static BigDecimal aculWIPQty(DynamicObject stockEntry) {
        BigDecimal actissueQty = stockEntry.getBigDecimal("actissueqty");
        BigDecimal feedingQty = stockEntry.getBigDecimal("feedingqty");
        BigDecimal rejectedQty = stockEntry.getBigDecimal("rejectedqty");
        BigDecimal useQty = stockEntry.getBigDecimal("useqty");
        return actissueQty.add(feedingQty).subtract(rejectedQty).subtract(useQty);
    }

    public static BigDecimal aculUseQty(DynamicObject stockEntry, Object orderEntryId, DynamicObject transactiontype, String orderName) {
        return StockCulUtils.culUseQty(stockEntry, orderEntryId, transactiontype, orderName);
    }

    public static BigDecimal getStandQty(DynamicObject unit, BigDecimal mm, String field, IDataModel model, int currentRow) {
        BigDecimal qtydenominator;
        BigDecimal qtynumerator;
        String qtyType = (String)model.getValue("qtytype", currentRow);
        BigDecimal useratio = ((BigDecimal)model.getValue("useratio", currentRow)).divide(ONEHUNDRED, 4, 4);
        BigDecimal orderQty = EntityNameUtils.getAllStockChangeName().contains(model.getDataEntityType().getName()) ? (BigDecimal)model.getValue("productbaseqty", currentRow) : (BigDecimal)model.getValue("baseqty");
        if (StringUtils.equals((CharSequence)"qtynumerator", (CharSequence)field)) {
            qtynumerator = mm;
            qtydenominator = (BigDecimal)model.getValue("qtydenominator", currentRow);
        } else if (StringUtils.equals((CharSequence)"qtydenominator", (CharSequence)field)) {
            qtynumerator = (BigDecimal)model.getValue("qtynumerator", currentRow);
            qtydenominator = mm;
        } else {
            qtynumerator = (BigDecimal)model.getValue("qtynumerator", currentRow);
            qtydenominator = (BigDecimal)model.getValue("qtydenominator", currentRow);
        }
        return MPDMMftGenStocksUtils.calculateStandQty(unit, qtyType, useratio, orderQty, qtynumerator, qtydenominator);
    }

    public static BigDecimal getDemandQty(BigDecimal standqty, DynamicObject unit, BigDecimal mm, String field, IDataModel model, int currentRow) {
        BigDecimal scraprate;
        BigDecimal fixscrap;
        String wastagerateformula = (String)model.getValue("wastagerateformula", currentRow);
        if (StringUtils.equals((CharSequence)"fixscrap", (CharSequence)field)) {
            fixscrap = mm;
            scraprate = (BigDecimal)model.getValue("scraprate", currentRow);
        } else if (StringUtils.equals((CharSequence)"scraprate", (CharSequence)field)) {
            scraprate = mm;
            fixscrap = (BigDecimal)model.getValue("fixscrap", currentRow);
        } else {
            fixscrap = (BigDecimal)model.getValue("fixscrap", currentRow);
            scraprate = (BigDecimal)model.getValue("scraprate", currentRow);
        }
        DynamicObject transactiontype = (DynamicObject)model.getValue(TRANSACTIONTYPEID);
        if (EntityNameUtils.getAllStockChangeName().contains(model.getDataEntityType().getName())) {
            BigDecimal qtynumerator;
            String stockbillid = (String)model.getValue("stockno", currentRow);
            if (StringUtils.isEmpty((CharSequence)stockbillid) && (qtynumerator = (BigDecimal)model.getValue("qtynumerator", currentRow)).compareTo(BigDecimal.ZERO) != 0) {
                model.setValue("qtynumerator", (Object)BigDecimal.ZERO, currentRow);
                return BigDecimal.ZERO;
            }
        } else if (transactiontype == null) {
            return BigDecimal.ZERO;
        }
        boolean isconsiderloss = transactiontype.getBoolean(ISCONSIDERLOSS2);
        return MPDMMftGenStocksUtils.calculateDemadQty(unit, isconsiderloss, standqty, scraprate, fixscrap, wastagerateformula);
    }

    public static void change4qtyRes(String field, BigDecimal newDecimal, IDataModel model, int changeIndex, int currentSelectIndex, IFormView view) {
        DynamicObject orderEntry;
        BigDecimal demandQty;
        BigDecimal standqty;
        BigDecimal standQty;
        DynamicObject unit = (DynamicObject)model.getValue("materialunitid", changeIndex);
        if (unit == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5206\u5f55\u57fa\u672c\u5355\u4f4d\u4e3a\u7a7a\u3002", (String)"MPDMMftGenStocksUtils_0", (String)"bd-mpdm-common", (Object[])new Object[0]));
            model.setValue(field, null, changeIndex);
            return;
        }
        String qtyType = (String)model.getValue("qtytype", changeIndex);
        if (StringUtils.isEmpty((CharSequence)qtyType)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7528\u91cf\u7c7b\u578b\u3002", (String)"MPDMMftGenStocksUtils_1", (String)"bd-mpdm-common", (Object[])new Object[0]));
            model.setValue(field, null, changeIndex);
            return;
        }
        if (StringUtils.equals((CharSequence)field, (CharSequence)"useratio")) {
            standQty = MPDMMftGenStocksUtils.getStandQty(unit, newDecimal, "useratio", model, changeIndex);
            model.setValue("standqty", (Object)standQty, changeIndex);
            model.setValue("demandqty", (Object)MPDMMftGenStocksUtils.getDemandQty(standQty, unit, null, null, model, changeIndex), changeIndex);
        } else if (StringUtils.equals((CharSequence)field, (CharSequence)"qtynumerator")) {
            standQty = MPDMMftGenStocksUtils.getStandQty(unit, newDecimal, "qtynumerator", model, changeIndex);
            model.setValue("standqty", (Object)standQty, changeIndex);
            model.setValue("demandqty", (Object)MPDMMftGenStocksUtils.getDemandQty(standQty, unit, null, null, model, changeIndex), changeIndex);
        } else if (StringUtils.equals((CharSequence)field, (CharSequence)"qtydenominator")) {
            standQty = MPDMMftGenStocksUtils.getStandQty(unit, newDecimal, "qtydenominator", model, changeIndex);
            model.setValue("standqty", (Object)standQty, changeIndex);
            model.setValue("demandqty", (Object)MPDMMftGenStocksUtils.getDemandQty(standQty, unit, null, null, model, changeIndex), changeIndex);
        } else if (StringUtils.equals((CharSequence)field, (CharSequence)"fixscrap")) {
            standqty = (BigDecimal)model.getValue("standqty", changeIndex);
            demandQty = MPDMMftGenStocksUtils.getDemandQty(standqty, unit, newDecimal, "fixscrap", model, changeIndex);
            model.setValue("demandqty", (Object)demandQty, changeIndex);
        } else if (StringUtils.equals((CharSequence)field, (CharSequence)"scraprate")) {
            standqty = (BigDecimal)model.getValue("standqty", changeIndex);
            demandQty = MPDMMftGenStocksUtils.getDemandQty(standqty, unit, newDecimal, "scraprate", model, changeIndex);
            model.setValue("demandqty", (Object)demandQty, changeIndex);
        } else if (StringUtils.equals((CharSequence)field, (CharSequence)"wastagerateformula")) {
            standqty = (BigDecimal)model.getValue("standqty", changeIndex);
            demandQty = MPDMMftGenStocksUtils.getDemandQty(standqty, unit, null, null, model, changeIndex);
            model.setValue("demandqty", (Object)demandQty, changeIndex);
        }
        boolean isShow = false;
        if (changeIndex == currentSelectIndex) {
            isShow = true;
        }
        MPDMMftGenStocksUtils.calHighQty(changeIndex, model, view, isShow);
        MPDMMftGenStocksUtils.calLowQty(changeIndex, model, view, isShow);
        MPDMMftGenStocksUtils.changeActissueQty(changeIndex, model, isShow);
        MPDMMftGenStocksUtils.aculCanSendQty(changeIndex, model, isShow);
        DynamicObject stockEntry = model.getEntryRowEntity("stockentry", changeIndex);
        if (stockEntry == null) {
            return;
        }
        String ordername = "";
        String modelName = model.getDataEntityType().getName();
        if (EntityNameUtils.getAllStockChangeName().contains(modelName)) {
            orderEntry = (DynamicObject)model.getValue("entryorderentryid", changeIndex);
            ordername = EntityNameUtils.getEntityName(3, 0, modelName);
        } else {
            orderEntry = (DynamicObject)model.getValue("orderentryid");
            ordername = EntityNameUtils.getEntityName(1, 0, modelName);
        }
        if (orderEntry == null) {
            return;
        }
        DynamicObject transactiontype = (DynamicObject)model.getValue(TRANSACTIONTYPEID);
        model.setValue("unissueqty", MPDMMftGenStocksUtils.aculUnSendQty(stockEntry), changeIndex);
        stockEntry.set("useqty", (Object)MPDMMftGenStocksUtils.aculUseQty(stockEntry, orderEntry.getPkValue(), transactiontype, ordername));
        model.setValue("useqty", stockEntry.get("useqty"), changeIndex);
        stockEntry.set("wipqty", (Object)MPDMMftGenStocksUtils.aculWIPQty(stockEntry));
        model.setValue("wipqty", stockEntry.get("wipqty"), changeIndex);
        if (isShow) {
            model.setValue("standqtyfield_qty", model.getValue("standqty"));
            model.setValue("demandqtyfield", model.getValue("demandqty"));
            model.setValue("useqtyfield", stockEntry.get("useqty"));
            model.setValue("wipqtyfield", stockEntry.get("wipqty"));
        }
    }

    public static void calHighQty(int index, IDataModel model, IFormView view, boolean isShow) {
        BigDecimal demandQty = (BigDecimal)model.getValue("demandqty", index);
        BigDecimal highlimit = (BigDecimal)model.getValue("issinhighlimit", index);
        DynamicObject mtfmaterial = (DynamicObject)model.getValue("materialid", index);
        if (mtfmaterial == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7ec4\u4ef6\u3002", (String)"MPDMMftGenStocksUtils_2", (String)"bd-mpdm-common", (Object[])new Object[0]));
            return;
        }
        BigDecimal extraratioqty = demandQty.multiply(BigDecimal.ONE.add(highlimit.divide(ONEHUNDRED, 4, 4)));
        if (isShow) {
            model.setValue("extraratioqtyfield", (Object)extraratioqty);
        }
        model.setValue("extraratioqty", (Object)extraratioqty, index);
    }

    public static void calHighLimit(int index, IDataModel model, IFormView view) {
        BigDecimal demandQty = (BigDecimal)model.getValue("demandqty");
        BigDecimal highQty = (BigDecimal)model.getValue("extraratioqtyfield");
        if (highQty.compareTo(demandQty) < 0) {
            model.setValue("issinhighlimitfield", (Object)BigDecimal.ZERO);
            model.setValue("issinhighlimit", (Object)BigDecimal.ZERO, index);
            model.setValue("extraratioqtyfield", (Object)demandQty);
            model.setValue("extraratioqty", (Object)demandQty, index);
        } else if (demandQty.compareTo(BigDecimal.ZERO) == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u9700\u6c42\u6570\u91cf\u4e0d\u80fd\u4e3a\u96f6\u3002", (String)"MPDMMftGenStocksUtils_3", (String)"bd-mpdm-common", (Object[])new Object[0]));
        } else {
            BigDecimal extraratioqty = highQty.divide(demandQty, 4, 4).subtract(BigDecimal.ONE).multiply(ONEHUNDRED);
            model.setValue("issinhighlimitfield", (Object)extraratioqty);
            model.setValue("issinhighlimit", (Object)extraratioqty, index);
        }
    }

    public static void calLowQty(int index, IDataModel model, IFormView view, boolean isShow) {
        BigDecimal demandQty = (BigDecimal)model.getValue("demandqty", index);
        BigDecimal highlimit = (BigDecimal)model.getValue("issinlowlimit", index);
        DynamicObject mtfmaterial = (DynamicObject)model.getValue("materialid", index);
        if (mtfmaterial == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7ec4\u4ef6\u3002", (String)"MPDMMftGenStocksUtils_2", (String)"bd-mpdm-common", (Object[])new Object[0]));
            return;
        }
        BigDecimal extraratioqty = demandQty.multiply(BigDecimal.ONE.subtract(highlimit.divide(ONEHUNDRED, 4, 4)));
        model.setValue("lackraitioqty", (Object)extraratioqty, index);
        if (isShow) {
            model.setValue("lackraitioqtyfield", (Object)extraratioqty);
        }
    }

    public static void calLowLimit(int index, IDataModel model, IFormView view) {
        BigDecimal demandQty = (BigDecimal)model.getValue("demandqty");
        BigDecimal lowQty = (BigDecimal)model.getValue("lackraitioqtyfield");
        if (lowQty.compareTo(demandQty) > 0) {
            model.setValue("issinlowlimitfield", (Object)BigDecimal.ZERO);
            model.setValue("issinlowlimit", (Object)BigDecimal.ZERO, index);
            model.setValue("lackraitioqtyfield", (Object)demandQty);
            model.setValue("lackraitioqty", (Object)demandQty, index);
        } else if (demandQty.compareTo(BigDecimal.ZERO) == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u9700\u6c42\u6570\u91cf\u4e0d\u80fd\u4e3a\u96f6\u3002", (String)"MPDMMftGenStocksUtils_3", (String)"bd-mpdm-common", (Object[])new Object[0]));
        } else {
            BigDecimal extraratioqty = BigDecimal.ONE.subtract(lowQty.divide(demandQty, 4, 4)).multiply(ONEHUNDRED);
            model.setValue("issinlowlimitfield", (Object)extraratioqty);
            model.setValue("issinlowlimit", (Object)extraratioqty, index);
        }
    }

    private static void changeActissueQty(int currentIndex, IDataModel model, boolean isShow) {
        DynamicObject stockEntry = model.getEntryRowEntity("stockentry", currentIndex);
        BigDecimal actissueQty = stockEntry.getBigDecimal("actissueqty");
        if (stockEntry.getBoolean("iscannegative")) {
            actissueQty = (BigDecimal)MPDMMftGenStocksUtils.aculActissueQty(stockEntry);
        }
        model.setValue("actissueqty", (Object)actissueQty, currentIndex);
        if (isShow) {
            model.setValue("actissueqtyfield", (Object)actissueQty);
        }
    }

    public static void aculCanSendQty(int currentIndex, IDataModel model, boolean isShow) {
        Object cansendQty = MPDMMftGenStocksUtils.aculCanSendQty(model.getEntryRowEntity("stockentry", currentIndex));
        model.setValue("cansendqty", cansendQty, currentIndex);
        if (isShow) {
            model.setValue("cansendqtyfield", cansendQty);
        }
    }

    public static void setbackflush(Object newObj, int currentIndex, IDataModel model, IFormView view, boolean isShow) {
        if (currentIndex == -1) {
            return;
        }
        if ("B".equals(newObj)) {
            DynamicObject trandym = (DynamicObject)model.getValue(TRANSACTIONTYPEID);
            String backflushtime = trandym.getString("backflushtime");
            if ("".equals(backflushtime)) {
                backflushtime = "A";
            }
            model.setValue("backflushtime", (Object)backflushtime, currentIndex);
            if (isShow) {
                if ("mpdm_transactout".equals(trandym.getDynamicObjectType().getName())) {
                    view.setEnable(Boolean.FALSE, new String[]{"backflushtimefield"});
                } else {
                    view.setEnable(Boolean.TRUE, new String[]{"backflushtimefield"});
                }
                model.setValue("backflushtimefield", (Object)backflushtime);
            }
        } else {
            model.setValue("backflushtime", (Object)" ", currentIndex);
            if (isShow) {
                model.setValue("backflushtimefield", (Object)" ");
                view.setEnable(Boolean.FALSE, new String[]{"backflushtimefield"});
            }
        }
    }

    public static void setUseratioEnable(IDataModel model, IFormView view) {
        DynamicObjectCollection entryEntity = model.getEntryEntity("stockentry");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            DynamicObject replacePlan = entry.getDynamicObject(KEY_ENTRY_REPLACEPLAN);
            if (replacePlan == null || "0".equals(entry.getString("pid"))) {
                view.setEnable(Boolean.FALSE, i, new String[]{"useratio"});
                continue;
            }
            view.setEnable(Boolean.TRUE, i, new String[]{"useratio"});
        }
    }

    public static void setMaterialEnable(IDataModel model, IFormView view) {
        if (!EntityNameUtils.getAllStockChangeName().contains(model.getDataEntityType().getName())) {
            DynamicObjectCollection entryEntity = model.getEntryEntity("stockentry");
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject entry = (DynamicObject)entryEntity.get(i);
                DynamicObject replacePlan = entry.getDynamicObject(KEY_ENTRY_REPLACEPLAN);
                Boolean isBomExtend = entry.getBoolean("isbomextend");
                boolean isProgramme = "F".equals(entry.getString("sourcetype"));
                if (replacePlan == null && !isBomExtend.booleanValue() && !isProgramme) {
                    view.setEnable(Boolean.TRUE, i, new String[]{"materialid"});
                    view.setEnable(Boolean.TRUE, i, new String[]{"qtytype"});
                    view.setEnable(Boolean.TRUE, i, new String[]{"bomreversion"});
                    view.setEnable(Boolean.TRUE, i, new String[]{"entryconfiguredcode"});
                    continue;
                }
                view.setEnable(Boolean.FALSE, i, new String[]{"materialid"});
                view.setEnable(Boolean.FALSE, i, new String[]{"qtytype"});
                view.setEnable(Boolean.FALSE, i, new String[]{"bomreversion"});
                view.setEnable(Boolean.FALSE, i, new String[]{"entryconfiguredcode"});
            }
        }
    }

    public static int getRoundType(DynamicObject unit) {
        if (unit == null) {
            return 4;
        }
        String precisionAccount = unit.getString("precisionaccount");
        int roundType = 0;
        switch (precisionAccount) {
            case "1": {
                roundType = 4;
                break;
            }
            case "2": {
                roundType = 1;
                break;
            }
            case "3": {
                roundType = 0;
                break;
            }
        }
        return roundType;
    }

    public static Map<String, Object> getPmAppParameterMap(Long orgId, String stockName) {
        if (EntityNameUtils.getAllOmStockName().contains(stockName)) {
            AppParam appParam = new AppParam("1/OY+A2+47UY", orgId, Long.valueOf(0L));
            return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        }
        if ("prop_mftstock".equals(stockName)) {
            AppParam appParam = new AppParam("4+6BUQ6OXI8F", orgId, Long.valueOf(0L));
            return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        }
        AppParam appParam = new AppParam("064+TL0DU6T9", orgId, Long.valueOf(0L));
        return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
    }

    public static void setStockEntryWarehouse(DynamicObject mtfOrg, String stockName, IDataModel model, int changeIndex) {
        Map<String, Object> pmAppParameterMap = MPDMMftGenStocksUtils.getPmAppParameterMap((Long)mtfOrg.getPkValue(), stockName);
        Object warehousesource = pmAppParameterMap.get("fwarehousesource");
        DynamicObject mftmaterialid = (DynamicObject)model.getValue("materialid", changeIndex);
        DynamicObject org = (DynamicObject)model.getValue("org");
        DynamicObject orderEntry = null;
        orderEntry = !EntityNameUtils.getAllStockChangeName().contains(stockName) ? (DynamicObject)model.getValue("orderentryid") : (DynamicObject)model.getValue("entryorderentryid", changeIndex);
        boolean usePlanscope = PlanScopeHelper.isUsePlanscope();
        if ((!usePlanscope || mftmaterialid.getBoolean("isstockallot")) && "0".equals(warehousesource.toString()) && !"A".equals(model.getValue("isbackflush", changeIndex))) {
            DynamicObject workCenter = orderEntry == null ? null : orderEntry.getDynamicObject("workcenter");
            workCenter = WorkcenterQueryHelper.getDataCacheByID(workCenter == null ? Long.valueOf(0L) : workCenter.getPkValue());
            DynamicObject workCenterEntry = (DynamicObject)model.getValue("oprworkcenter", changeIndex);
            workCenterEntry = WorkcenterQueryHelper.getDataCacheByID(workCenterEntry == null ? Long.valueOf(0L) : workCenterEntry.getPkValue());
            if (workCenter != null) {
                model.setValue("warehouseid", workCenter.get("warehouse"), changeIndex);
                model.setValue("location", workCenter.get("location"), changeIndex);
            } else if (workCenterEntry != null) {
                model.setValue("warehouseid", workCenterEntry.get("warehouse"), changeIndex);
                model.setValue("location", workCenterEntry.get("location"), changeIndex);
            } else {
                model.setValue("warehouseid", null, changeIndex);
                model.setValue("location", null, changeIndex);
            }
        }
        if (mftmaterialid != null && org != null && orderEntry != null && !mftmaterialid.getBoolean("isstockallot") && usePlanscope) {
            DynamicObject masterid = mftmaterialid.getDynamicObject("masterid");
            DynamicObject stockEntry = model.getEntryRowEntity("stockentry", changeIndex);
            PlanScopeHelper.setStockEntryWarehouseByPlanScopeSer(stockEntry, orderEntry, masterid.getLong("id"), org, mftmaterialid, null);
            if (stockEntry.getDynamicObject("supplyorgid") != null) {
                model.setValue("supplyorgid", stockEntry.get("supplyorgid"), changeIndex);
                Object warehouse = stockEntry.get("warehouseid");
                Long warehouseId = 0L;
                if (warehouse instanceof DynamicObject) {
                    warehouseId = (Long)((DynamicObject)warehouse).getPkValue();
                } else if (warehouse instanceof Long) {
                    warehouseId = (Long)warehouse;
                }
                model.setValue("warehouseid", (Object)WarehouseQueryHelper.getDataCacheByID(warehouseId), changeIndex);
                model.setValue("location", stockEntry.get("location"), changeIndex);
            }
        }
    }

    public static void genStocksNew(DynamicObject order, String operation, String entityType) {
        if (order == null) {
            return;
        }
        MPDMMftGenStocksUtils.batchGenStocks(new DynamicObject[]{order}, operation, entityType);
    }

    public static void batchGenStocks(DynamicObject[] orders, String operation, String entityType) {
        if (orders == null || orders.length == 0) {
            logger.info("\u7ec4\u4ef6\u6e05\u5355\u751f\u6210\u5931\u8d25\uff1aorders == null");
            return;
        }
        ArrayList<DynamicObject> orderList = new ArrayList<DynamicObject>(orders.length);
        for (DynamicObject order : orders) {
            orderList.add(order);
        }
        Long startdate = System.currentTimeMillis();
        logger.info("\u5f00\u59cb\u6279\u91cf\u751f\u6210\u7ec4\u4ef6\u6e05\u5355------------------------");
        OrderBaseData baseData = CreateStockUtils.getStocks(orderList, operation, entityType);
        List<DynamicObject> savedataEntities = baseData.getSaveStocks();
        List<DynamicObject> updatedataEntities = baseData.getUpdateStocks();
        Set<Long> deleteOrderEntryIds = baseData.getDeleteOrderEntryIds();
        Map<Long, String> orderErrInfoMap = baseData.getOrderErrInfoMap();
        for (DynamicObject order : orderList) {
            String err = orderErrInfoMap.get((Long)order.getPkValue());
            if (err == null) continue;
            ErrorCode ec = new ErrorCode("batchstock", err);
            throw new KDBizException(ec, new Object[0]);
        }
        OrderOpUtils.handleStock(entityType, savedataEntities, updatedataEntities, deleteOrderEntryIds, logger);
        Long enddate = System.currentTimeMillis() - startdate;
        logger.info("\u6279\u91cf\u751f\u6210\u7ec4\u4ef6\u6e05\u5355\u5b8c\u6bd5--------------" + enddate);
    }

    public static void updateRepPid(List<DynamicObject> savedataEntities) {
        if (savedataEntities.isEmpty()) {
            return;
        }
        IDataEntityType type = savedataEntities.get(0).getDataEntityType();
        DBRoute rt = new DBRoute(type.getDBRouteKey());
        SequenceReader seqReader = new SequenceReader(rt);
        seqReader.autoSetPrimaryKey(savedataEntities, type);
        for (DynamicObject savedataEntitie : savedataEntities) {
            HashMap<String, List<DynamicObject>> stockRepDym = new HashMap<String, List<DynamicObject>>(16);
            DynamicObjectCollection stockEntry = savedataEntitie.getDynamicObjectCollection("stockentry");
            if (stockEntry == null) continue;
            for (DynamicObject stockEntryDym : stockEntry) {
                ArrayList<DynamicObject> list;
                DynamicObject replacePlan = stockEntryDym.getDynamicObject(KEY_ENTRY_REPLACEPLAN);
                String replacePlanStr = "0";
                if (replacePlan != null) {
                    replacePlanStr = replacePlan.getPkValue().toString();
                }
                if ((list = (ArrayList<DynamicObject>)stockRepDym.get(replacePlanStr)) == null) {
                    list = new ArrayList<DynamicObject>(stockEntry.size());
                }
                if (!"0".equals(stockEntryDym.get(KEY_ENTRY_PRIORITY).toString())) {
                    stockEntryDym.set("pid", (Object)1L);
                }
                list.add(stockEntryDym);
                stockRepDym.put(replacePlanStr, list);
            }
            MPDMMftGenStocksUtils.updateRepSeq(stockRepDym);
        }
    }

    private static void updateRepSeq(Map<String, List<DynamicObject>> stockRepDym) {
        int seq = 1;
        for (Map.Entry<String, List<DynamicObject>> entry : stockRepDym.entrySet()) {
            String key = entry.getKey();
            List<DynamicObject> lists = entry.getValue();
            if (!"0".equals(key)) {
                lists = MPDMMftGenStocksUtils.updateRepList(lists);
            }
            for (DynamicObject stockDym : lists) {
                stockDym.set("seq", (Object)seq);
                ++seq;
            }
        }
    }

    private static List<DynamicObject> updateRepList(List<DynamicObject> lists) {
        ArrayList<DynamicObject> newLists = new ArrayList<DynamicObject>(lists.size());
        DynamicObject mainRepDym = null;
        ArrayList<DynamicObject> newRepLists = new ArrayList<DynamicObject>(lists.size());
        ArrayList<DynamicObject> newMainLists = new ArrayList<DynamicObject>(lists.size());
        for (DynamicObject stockDym : lists) {
            Boolean isMainRep = stockDym.getBoolean(KEY_ENTRY_ISMAINREPLAC);
            String pid = stockDym.get("pid").toString();
            if ("0".equals(pid) && isMainRep.booleanValue()) {
                mainRepDym = stockDym;
                newLists.add(stockDym);
                continue;
            }
            if (!"0".equals(pid) || isMainRep.booleanValue()) continue;
            newMainLists.add(stockDym);
        }
        for (DynamicObject stockDym : lists) {
            String pid = stockDym.get("pid").toString();
            if ("0".equals(pid)) continue;
            if (mainRepDym != null) {
                stockDym.set("pid", mainRepDym.getPkValue());
            }
            newRepLists.add(stockDym);
        }
        newLists.addAll(newRepLists);
        newLists.addAll(newMainLists);
        return newLists;
    }

    private static DynamicObjectCollection getOutStockEntry(DynamicObject orderStock) {
        return null;
    }

    public static void updateStock4ManuChangeBillChange(DynamicObject manufactureOrder, DynamicObject orderEntry, DynamicObject stock, boolean workCenter, boolean isNewSplitStock, List<DynamicObject> manftechInfos) {
        if (manufactureOrder == null || orderEntry == null || stock == null) {
            return;
        }
        String orderName = manufactureOrder.getDataEntityType().getName();
        if ("pm_om_purorderbill".equals(orderName)) {
            stock.set(REPLACENO, orderEntry.get(BOMREPLACENONAME));
        } else if ("pom_mftorder".equals(orderName) || "om_mftorder".equals(orderName)) {
            stock.set(REPLACENO, orderEntry.get(REPLACENO));
            if ("om_mftorder".equals(orderName)) {
                stock.set("planpreparetime", orderEntry.get("planpreparetime"));
            }
        }
        stock.set("modifytime", (Object)TimeServiceHelper.now());
        stock.set("modifier", (Object)UserServiceHelper.getCurrentUser((String)"id"));
        Date planbegintime = null;
        Date planendtime = null;
        DynamicObject mtfOrg = null;
        DynamicObject transactiontype = stock.getDynamicObject(TRANSACTIONTYPEID);
        String feedtype = "";
        if ("pm_om_purorderbill".equals(orderName)) {
            stock.set("auxproperty", orderEntry.get("auxpty"));
            stock.set("billauxqty", orderEntry.get("auxqty"));
            stock.set("billauxunit", orderEntry.get("auxunit"));
            feedtype = transactiontype.getString("feedtype");
            if ("E".equals(feedtype)) {
                MPDMMftGenStocksUtils.updateStockEntry(orderEntry, stock, orderName);
            }
        } else if ("pom_mftorder".equals(orderName) || "om_mftorder".equals(orderName)) {
            stock.set("auxproperty", orderEntry.get("auxproperty"));
            stock.set("billauxqty", orderEntry.get("auxptyqty"));
            stock.set("billauxunit", orderEntry.get("auxptyunit"));
            stock.set("mftdeptorgid", orderEntry.get("producedept"));
            planbegintime = orderEntry.getDate("planbegintime");
            planendtime = orderEntry.getDate("planendtime");
            mtfOrg = manufactureOrder.getDynamicObject("org");
            feedtype = transactiontype.getString("stockmaterials");
            if ("B".equals(feedtype)) {
                MPDMMftGenStocksUtils.updateStockEntry(orderEntry, stock, orderName);
            }
        }
        BigDecimal baseqty = orderEntry.getBigDecimal("baseqty");
        stock.set("qty", orderEntry.get("qty"));
        stock.set("unitid", orderEntry.get("unit"));
        Boolean isQtyChange = true;
        BigDecimal oldQty = stock.getBigDecimal("baseqty");
        if (oldQty.compareTo(baseqty) == 0) {
            isQtyChange = false;
        }
        stock.set("baseqty", (Object)baseqty);
        stock.set("baseunitid", orderEntry.get("baseunit"));
        stock.set("orderno", manufactureOrder.get("billno"));
        boolean isconsiderloss = transactiontype.getBoolean(ISCONSIDERLOSS2);
        DynamicObject orderentryidF7 = stock.getDynamicObject("orderentryid");
        long srcOrderEntryId = 0L;
        if (isNewSplitStock) {
            DynamicObject srcsplitbillseq = orderentryidF7.getDynamicObject("srcsplitbillseq");
            DynamicObject omsrcsplitbillseq = orderentryidF7.getDynamicObject("omsrcsplitbillseq");
            if (null != srcsplitbillseq) {
                srcOrderEntryId = srcsplitbillseq.getLong("id");
            } else if (null != omsrcsplitbillseq) {
                srcOrderEntryId = omsrcsplitbillseq.getLong("id");
            }
        } else {
            srcOrderEntryId = orderentryidF7.getLong("id");
        }
        DynamicObject techBill = null;
        for (DynamicObject manftechBill : manftechInfos) {
            DynamicObject mftentryseq = manftechBill.getDynamicObject("mftentryseq");
            if (srcOrderEntryId != mftentryseq.getLong("id")) continue;
            techBill = manftechBill;
            break;
        }
        DynamicObjectCollection stockEntrys = stock.getDynamicObjectCollection("stockentry");
        boolean isprocedure = transactiontype.getBoolean("isprocedure");
        ArrayList<DynamicObject> delRows = new ArrayList<DynamicObject>(10);
        for (DynamicObject stockEntry : stockEntrys) {
            boolean isStockSplit = false;
            if (null != techBill) {
                DynamicObjectCollection oprentrys = techBill.getDynamicObjectCollection("oprentryentity");
                for (DynamicObject oprentry : oprentrys) {
                    String oprparent = oprentry.getString("oprparent");
                    String oprno = oprentry.getString("oprno");
                    if (!StringUtils.equals((CharSequence)stockEntry.getString("oprno"), (CharSequence)oprno) || !StringUtils.equals((CharSequence)stockEntry.getString("processseq"), (CharSequence)oprparent) || Arrays.asList("F", "G").contains(oprentry.getString("oprstatus")) || oprentry.getBoolean("oprinvalid")) continue;
                    isStockSplit = true;
                }
            }
            String oprno = stockEntry.getString("oprno");
            String processseq = stockEntry.getString("processseq");
            if (!"om_mftorder".equals(orderName) && StringUtils.isNotBlank((CharSequence)oprno) && StringUtils.isNotBlank((CharSequence)processseq) && isprocedure && !isStockSplit) {
                if (!isNewSplitStock) continue;
                delRows.add(stockEntry);
                continue;
            }
            if (!workCenter && ("pom_mftorder".equals(orderName) || "om_mftorder".equals(orderName)) && "A".equals(stock.getString("billstatus"))) {
                MPDMMftGenStocksUtils.setStockEntryWarehouse(mtfOrg, stockEntry, orderEntry);
            }
            DynamicObject unit = stockEntry.getDynamicObject("materialunitid");
            String wastagerateformula = (String)stockEntry.get("wastagerateformula");
            int precision = MPDMMftGenStocksUtils.getPrecision(unit);
            String qtyType = stockEntry.getString("qtytype");
            BigDecimal useratio = stockEntry.getBigDecimal("useratio").divide(ONEHUNDRED, 4, 4);
            BigDecimal qtynumerator = BigDecimal.ONE;
            BigDecimal qtydenominator = BigDecimal.ONE;
            if (stockEntry.getBoolean("isstep") && isQtyChange.booleanValue()) {
                MPDMMftGenStocksUtils.setQtyByType(stockEntry, stock, orderEntry);
            }
            qtynumerator = stockEntry.getBigDecimal("qtynumerator");
            qtydenominator = stockEntry.getBigDecimal("qtydenominator");
            BigDecimal standqty = MPDMMftGenStocksUtils.calculateStandQty(unit, qtyType, useratio, baseqty, qtynumerator, qtydenominator);
            stockEntry.set("standqty", (Object)standqty);
            BigDecimal scraprate = stockEntry.getBigDecimal("scraprate");
            BigDecimal fixscrap = stockEntry.getBigDecimal("fixscrap");
            BigDecimal demandQty = MPDMMftGenStocksUtils.calculateDemadQty(precision, isconsiderloss, standqty, scraprate, fixscrap, wastagerateformula);
            stockEntry.set("demandqty", (Object)demandQty);
            stockEntry.set("extraratioqty", (Object)stockEntry.getBigDecimal("demandqty").multiply(BigDecimal.ONE.add(stockEntry.getBigDecimal("issinhighlimit").divide(ONEHUNDRED, 4, 4))));
            stockEntry.set("lackraitioqty", (Object)stockEntry.getBigDecimal("demandqty").multiply(BigDecimal.ONE.subtract(stockEntry.getBigDecimal("issinlowlimit").divide(ONEHUNDRED, 4, 4))));
            stockEntry.set("actissueqty", MPDMMftGenStocksUtils.aculActissueQty(stockEntry));
            stockEntry.set("cansendqty", MPDMMftGenStocksUtils.aculCanSendQty(stockEntry));
            stockEntry.set("unissueqty", MPDMMftGenStocksUtils.aculUnSendQty(stockEntry));
            stockEntry.set("useqty", (Object)MPDMMftGenStocksUtils.aculUseQty(stockEntry, orderEntry.getPkValue(), transactiontype, orderName));
            stockEntry.set("wipqty", (Object)MPDMMftGenStocksUtils.aculWIPQty(stockEntry));
            if ("pm_om_purorderbill".equals(orderName)) {
                Object bomentryid = stockEntry.get("bomentryid");
                BigDecimal leadtime = BigDecimal.ZERO;
                if (Objects.nonNull(bomentryid)) {
                    QFilter[] qfilters = new QFilter[]{new QFilter("entry.id", "=", bomentryid)};
                    try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryBomEntry", (String)"pdm_mftbom", (String)"entry.id,entry.entryleadtime", (QFilter[])qfilters, null);){
                        if (dataSet.hasNext()) {
                            Row next = dataSet.next();
                            leadtime = next.getBigDecimal("entry.entryleadtime");
                        }
                    }
                }
                Calendar c = Calendar.getInstance();
                c.setTime(orderEntry.getDate("deliverdate"));
                c.add(5, leadtime.intValue());
                stockEntry.set("demanddate", (Object)c.getTime());
                continue;
            }
            if (!"pom_mftorder".equals(orderName) && !"om_mftorder".equals(orderName)) continue;
            stockEntry.set("demanddate", (Object)MPDMMftGenStocksUtils.getDemandDate(mtfOrg, planbegintime, stockEntry, planendtime));
        }
        if (!delRows.isEmpty()) {
            stockEntrys.removeAll(delRows);
        }
    }

    private static void updateStockEntry(DynamicObject orderEntry, DynamicObject stock, String orderName) {
        DynamicObjectCollection stockEntrys = stock.getDynamicObjectCollection("stockentry");
        if (stockEntrys == null || stockEntrys.size() < 1) {
            return;
        }
        DynamicObject stockEntry = (DynamicObject)stockEntrys.get(0);
        DynamicObject mainMaterial = stock.getDynamicObject("productid");
        DynamicObject material = stockEntry.getDynamicObject("materialid");
        if (mainMaterial == null || material == null || mainMaterial.getPkValue() != material.getPkValue()) {
            return;
        }
        if ("pm_om_purorderbill".equals(orderName)) {
            stockEntry.set("childauxpropertyid", orderEntry.get("auxpty"));
            stockEntry.set("batchno", orderEntry.get("batchno"));
        } else if ("pom_mftorder".equals(orderName) || "om_mftorder".equals(orderName)) {
            stockEntry.set("childauxpropertyid", orderEntry.get("auxproperty"));
            stockEntry.set("batchno", orderEntry.get("batchno"));
            stockEntry.set("lot", orderEntry.get("lot"));
            stockEntry.set("entryconfiguredcode", orderEntry.get("configuredcode"));
        }
    }

    public static void aculUseQtyByOrderEntryId(List<Long> orderEntryIdList) {
        StockCulUtils.batchCulUseQtyByOrderEntryId(orderEntryIdList, "pom_mftorder");
    }

    private static Long getPkid(Object obj) {
        Long objId = 0L;
        if (obj instanceof DynamicObject) {
            objId = ((DynamicObject)obj).getLong("id");
        } else if (obj instanceof Long) {
            objId = (Long)obj;
        } else if (obj instanceof String) {
            objId = NumberUtils.toLong((String)obj.toString());
        }
        return objId;
    }

    public static void setQtyByType(DynamicObject stockEntry, DynamicObject stock, DynamicObject orderEntry) {
        DynamicObject bomDym = stock.getDynamicObject("bomid");
        if (bomDym != null && stockEntry.getBoolean("isbomextend")) {
            BigDecimal qty = orderEntry.getBigDecimal("qty");
            Date expendbomtime = orderEntry.getDate("expendbomtime");
            DynamicObject configedCode = orderEntry.getDynamicObject("configuredcode");
            Long configCodeId = configedCode == null ? 0L : configedCode.getLong("id");
            String bomFilterStr = null;
            JSONObject jsonParams = null;
            HashMap<String, Object> paramMap = CreateStockByBomUtils.getParamsMapByValue(MPDMMftGenStocksUtils.getPkid(bomDym), MPDMMftGenStocksUtils.getPkid(stock.get("productmasterid")), expendbomtime, configCodeId, stock.getDynamicObject(TRANSACTIONTYPEID), MPDMMftGenStocksUtils.getPkid(stock.get("org")), qty);
            jsonParams = CreateStockByBomUtils.getMulBOMJsonObjectParam(paramMap);
            bomFilterStr = CreateStockByBomUtils.getMulBomFilterStr(jsonParams);
            DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("mmc-fmm-bomsearch");
            String res = (String)cache.get(bomFilterStr);
            List<Object> bbdList = new ArrayList(16);
            if (res != null && !"".equals(res)) {
                bbdList = MPDMMftGenStocksUtils.getBBDList(res);
            } else {
                JSONArray filterArray = new JSONArray(1);
                filterArray.add((Object)jsonParams);
                JSONArray jSONArray = JSON.parseArray((String)CreateStockByBomUtils.getQueryDataResMulType(filterArray.toString()));
                if (jSONArray != null && jSONArray.size() > 0) {
                    res = (String)cache.get(bomFilterStr);
                    bbdList = MPDMMftGenStocksUtils.getBBDList(res);
                }
            }
            if (stockEntry.getBoolean("isbomextend")) {
                for (BomBaseData bomBaseData : bbdList) {
                    if (!stockEntry.get("bomentryid").equals(bomBaseData.getBomEntryId())) continue;
                    CreateStockByBomUtils.setStockEntryQtyByBomBaseData(stockEntry, bomBaseData);
                }
            }
        }
    }

    private static List<BomBaseData> getBBDList(String res) {
        ArrayList<BomBaseData> bbdList = new ArrayList<BomBaseData>(10);
        if (res != null && !"".equals(res)) {
            JSONArray resArray = JSONArray.parseArray((String)res);
            for (int i = 0; i < resArray.size(); ++i) {
                JSONObject resJson = (JSONObject)resArray.get(i);
                bbdList.add(CreateStockByBomUtils.getBomBaseData(resJson));
            }
        }
        return bbdList;
    }

    public static Long getDefalutBillType(String billName) {
        DynamicObject dy = BillTypeQueryHelper.getBillTypesCache((String)billName);
        return dy == null ? 0L : dy.getLong("id");
    }

    private static void setLocalFilterCache(String entityType, DynamicObject manufactureOrder, DynamicObject orderEntry, DynamicObject orderStock, DynamicObject bomEntry, Set<Long> mMftInfoIds) {
        Object materialmftInfo = bomEntry.get(ENTRYMATERIAL);
        if (materialmftInfo instanceof DynamicObject) {
            Long mftId = (Long)((DynamicObject)materialmftInfo).getPkValue();
            DynamicObject masterid = ((DynamicObject)materialmftInfo).getDynamicObject("masterid");
            QFilter filter = new QFilter("masterid", "=", masterid.getPkValue());
            filter.and(new QFilter("status", "=", (Object)"C"));
            filter.and(new QFilter("enable", "=", (Object)"1"));
            mMftInfoIds.add(mftId);
        }
    }

    public static DynamicObject getEntryUnit(DynamicObject bomEntry, DynamicObject materialmftInfo) {
        return bomEntry.getDynamicObject(ENTRYUNIT2) == null ? MaterialHelper.getMaterialBizUnit(materialmftInfo) : bomEntry.getDynamicObject(ENTRYUNIT2);
    }

    public static List<Promater> getPromaterResult(DynamicObject orderEntry, String bomId, Map<String, Long> workPlanIDMap) {
        if (orderEntry == null || StringUtils.isEmpty((CharSequence)bomId)) {
            return new ArrayList<Promater>();
        }
        Date expendbomtime = orderEntry.getDate("expendbomtime");
        logger.info("\u53d6\u5de5\u5e8f\u7269\u6599\u5206\u914d\uff0c\u5c55BOM\u65f6\u95f4\uff1a" + expendbomtime);
        ArrayList<Promater> resultList = new ArrayList<Promater>(10);
        Long processrouteId = orderEntry.get("processroute") != null ? Long.parseLong(orderEntry.getDynamicObject("processroute").getPkValue().toString()) : 0L;
        if (processrouteId != 0L) {
            DynamicObject processroute = orderEntry.getDynamicObject("processroute");
            DynamicObject promater = MPDMMftGenStocksUtils.getPromater(bomId, processrouteId);
            if (promater != null) {
                boolean isFreeDistribut = MPDMMftGenStocksUtils.isFreeDistribut(promater);
                boolean isShowJump = MPDMMftGenStocksUtils.isShowJumpFromOrder(orderEntry);
                Date effectdate = promater.getDate("effectdate");
                Date entryinvaliddate = promater.getDate("invaliddate");
                logger.info("\u53d6\u5de5\u5e8f\u7269\u6599\u5206\u914d\uff0c\u5b58\u5728\u53ef\u7528\u7684\u5de5\u5e8f\u7269\u6599\u5206\u914d\u3002");
                if (expendbomtime.compareTo(effectdate) <= 0 || expendbomtime.compareTo(entryinvaliddate) > 0) {
                    logger.info("\u53d6\u5de5\u5e8f\u7269\u6599\u5206\u914d\uff0c\u5c55BOM\u65f6\u95f4\u4e0d\u5728\u751f\u6548\u65e5\u671f\u4e4b\u5185\u3002\u5c55BOM\u65f6\u95f4\uff1a" + expendbomtime + "\u751f\u6548\u65f6\u95f4\uff1a" + effectdate + "\u5931\u6548\u65f6\u95f4\uff1a" + entryinvaliddate);
                    return null;
                }
                DynamicObjectCollection dtbmaterentrys = promater.getDynamicObjectCollection("dtbmaterentry");
                DynamicObjectCollection notallocatentrys = promater.getDynamicObjectCollection("notallocatentry");
                DynamicObject workprocedure = (DynamicObject)promater.getDynamicObjectCollection("workprocedure").get(0);
                if (isShowJump && isFreeDistribut && MPDMMftGenStocksUtils.checkExistXN(promater)) {
                    MPDMMftGenStocksUtils.getBomJumpData(bomId, orderEntry, resultList, workprocedure, processroute);
                }
                for (Object dtbmaterentry : dtbmaterentrys) {
                    Promater tpromater = MPDMMftGenStocksUtils.getAllocatRes((DynamicObject)dtbmaterentry, expendbomtime, "dtbmater", null, processroute, (Long)orderEntry.getPkValue(), workPlanIDMap);
                    if (tpromater == null || tpromater.getBomEntry() == null) continue;
                    resultList.add(tpromater);
                }
                boolean isExistsJumpData = false;
                if (isShowJump && !isFreeDistribut) {
                    for (Iterator notallocatentry : notallocatentrys) {
                        boolean nallocatisjumplevel = notallocatentry.getBoolean("nallocatisjumplevel");
                        if (!nallocatisjumplevel) continue;
                        Long parentid = notallocatentry.getLong("pid");
                        BigDecimal dtballocatqty = notallocatentry.getBigDecimal("nallocatmole");
                        BigDecimal dtballocatqtydeno = notallocatentry.getBigDecimal("nallocatdeno");
                        if (!parentid.equals(0L)) {
                            BigDecimal parentQty = MPDMMftGenStocksUtils.getparentQty(notallocatentrys, parentid);
                            dtballocatqty = dtballocatqty.multiply(parentQty);
                        }
                        notallocatentry.set("nallocatqty", dtballocatqty);
                        notallocatentry.set("nallocatqtydeno", dtballocatqtydeno);
                        isExistsJumpData = true;
                    }
                }
                ArrayList<Promater> sortList = new ArrayList<Promater>();
                for (DynamicObject notallocatentry : notallocatentrys) {
                    boolean nallocatisjumplevel;
                    Promater tpromater = MPDMMftGenStocksUtils.getAllocatRes(notallocatentry, expendbomtime, "notallocat", workprocedure, processroute, (Long)orderEntry.getPkValue(), workPlanIDMap);
                    if (tpromater == null || tpromater.getBomEntry() == null) continue;
                    if (isExistsJumpData && (nallocatisjumplevel = notallocatentry.getBoolean("nallocatisjumplevel"))) {
                        sortList.add(tpromater);
                        continue;
                    }
                    resultList.add(tpromater);
                }
                for (int i = sortList.size() - 1; i >= 0; --i) {
                    Promater tpromater = (Promater)sortList.get(i);
                    int childIndex = MPDMMftGenStocksUtils.getChildIndex(resultList, tpromater);
                    if (childIndex >= 0) {
                        resultList.add(childIndex, tpromater);
                        continue;
                    }
                    resultList.add(tpromater);
                }
            }
            logger.info("\u53d6\u5de5\u5e8f\u7269\u6599\u5206\u914d\uff0c\u5b58\u5728\u4e0d\u53ef\u7528\u7684\u5de5\u5e8f\u7269\u6599\u5206\u914d\u3002");
        }
        return resultList;
    }

    private static Promater getAllocatRes(DynamicObject allocatentry, Date expendbomtime, String typestr, DynamicObject workprocedure, DynamicObject processroute, Long orderentryid, Map<String, Long> workPlanIDMap) {
        Promater tpromater = new Promater();
        if ("dtbmater".equals(typestr)) {
            DynamicObject processEntry;
            BigDecimal dtballocatqty = allocatentry.getBigDecimal("dtballocatqty");
            BigDecimal dtballocatqtydeno = allocatentry.getBigDecimal("dtballocatqtydeno");
            DynamicObject bom = MPDMMftGenStocksUtils.getBOMByID(String.valueOf(allocatentry.getLong("dtballocatbomid")));
            DynamicObject bomEntryOld = MPDMMftGenStocksUtils.getBOMEntryByEntryID(bom, allocatentry.getLong("dtballocatbomentryid"));
            if (bomEntryOld == null) {
                return null;
            }
            DynamicObject bomEntry = MPDMMftGenStocksUtils.cloneBomEntry(bomEntryOld);
            Date entryvaliddate = bomEntry.getDate(ENTRYVALIDDATE2);
            Date entryinvaliddate = bomEntry.getDate(ENTRYINVALIDDATE2);
            if (expendbomtime.compareTo(entryvaliddate) <= 0 || expendbomtime.compareTo(entryinvaliddate) >= 0) {
                return null;
            }
            bomEntry.set(ENTRYQTYNUMERATOR, (Object)dtballocatqty);
            bomEntry.set(ENTRYQTYDENOMINATOR, (Object)dtballocatqtydeno);
            bomEntry.setParent((Object)bom);
            tpromater.setOprno(allocatentry.getString("dtballocatoperationno"));
            tpromater.setProcessseq(allocatentry.getString("dtballocatprocessseq"));
            tpromater.setMachiningtype(allocatentry.getString("dtballocatmachtype"));
            tpromater.setWorkprocedure(allocatentry.getDynamicObject("dtballocatoperationnum"));
            tpromater.setOperationdesc(allocatentry.getString("dtballocatoperaname"));
            tpromater.setPromaterEntryid(Long.parseLong(allocatentry.getPkValue().toString()));
            tpromater.setBomEntry(bomEntry);
            tpromater.setJumplevel(false);
            String processseq = tpromater.getProcessseq();
            if (!StringUtils.isEmpty((CharSequence)processseq) && processroute != null && tpromater.getOprno() != null && (processEntry = MPDMMftGenStocksUtils.getProcessEntry(processroute, processseq, tpromater.getOprno())) != null) {
                tpromater.setWorkcenter(processEntry.getDynamicObject("workcenter"));
                tpromater.setOutsupply(processEntry.getDynamicObject("supplier"));
            }
            long workPlanId = MPDMMftGenStocksUtils.getWorkPlanId(orderentryid, tpromater.getOprno(), tpromater.getProcessseq(), workPlanIDMap);
            tpromater.setWorkplanid(workPlanId);
        } else if ("notallocat".equals(typestr)) {
            BigDecimal dtballocatqty = allocatentry.getBigDecimal("nallocatqty");
            BigDecimal dtballocatqtydeno = allocatentry.getBigDecimal("nallocatqtydeno");
            boolean nallocatisjumplevel = allocatentry.getBoolean("nallocatisjumplevel");
            if (nallocatisjumplevel || dtballocatqty.compareTo(BigDecimal.ZERO) != 0) {
                DynamicObject processEntry;
                DynamicObject bom = MPDMMftGenStocksUtils.getBOMByID(String.valueOf(allocatentry.getLong("nallocatbomid")));
                DynamicObject bomEntryOld = MPDMMftGenStocksUtils.getBOMEntryByEntryID(bom, allocatentry.getLong("nallocatbomentryid"));
                if (bomEntryOld == null) {
                    return tpromater;
                }
                DynamicObject bomEntry = MPDMMftGenStocksUtils.cloneBomEntry(bomEntryOld);
                Date entryvaliddate = bomEntry.getDate(ENTRYVALIDDATE2);
                Date entryinvaliddate = bomEntry.getDate(ENTRYINVALIDDATE2);
                if (expendbomtime.compareTo(entryvaliddate) <= 0 || expendbomtime.compareTo(entryinvaliddate) >= 0) {
                    return null;
                }
                bomEntry.set(ENTRYQTYNUMERATOR, (Object)dtballocatqty);
                bomEntry.set(ENTRYQTYDENOMINATOR, (Object)dtballocatqtydeno);
                bomEntry.setParent((Object)bom);
                tpromater.setOprno(workprocedure.getString("operationno"));
                tpromater.setProcessseq(workprocedure.getString("processseq"));
                tpromater.setMachiningtype(workprocedure.getString("machtype"));
                tpromater.setWorkprocedure(workprocedure.getDynamicObject("operationnum"));
                tpromater.setPromaterEntryid(0L);
                tpromater.setBomEntry(bomEntry);
                tpromater.setJumplevel(nallocatisjumplevel);
                String processseq = tpromater.getProcessseq();
                if (!StringUtils.isEmpty((CharSequence)processseq) && processroute != null && tpromater.getOprno() != null && (processEntry = MPDMMftGenStocksUtils.getProcessEntry(processroute, processseq, tpromater.getOprno())) != null) {
                    tpromater.setWorkcenter(processEntry.getDynamicObject("workcenter"));
                    tpromater.setOutsupply(processEntry.getDynamicObject("supplier"));
                }
                long workPlanId = MPDMMftGenStocksUtils.getWorkPlanId(orderentryid, tpromater.getOprno(), tpromater.getProcessseq(), workPlanIDMap);
                tpromater.setWorkplanid(workPlanId);
            }
        }
        return tpromater;
    }

    private static DynamicObject cloneBomEntry(DynamicObject bomEntryOld) {
        DynamicObject bomEntry = new DynamicObject(bomEntryOld.getDynamicObjectType());
        DataEntityPropertyCollection properties = bomEntryOld.getDataEntityType().getProperties();
        for (IDataEntityProperty property : properties) {
            bomEntry.set(property, bomEntryOld.get(property));
        }
        return bomEntry;
    }

    private static Long getWorkPlanId(Long orderentryid, String oprno, String processseq, Map<String, Long> workPlanIDMap) {
        String keyStr = orderentryid + "_" + processseq + "_" + oprno;
        if (workPlanIDMap.containsKey(keyStr)) {
            return workPlanIDMap.get(keyStr);
        }
        Long returnID = 0L;
        QFilter qfilter = new QFilter("mftentryseq", "=", (Object)orderentryid);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-createstockbybomutils-querytech", (String)"sfc_manftech", (String)"mftentryseq.id,oprentryentity.id,oprentryentity.oprparent,oprentryentity.oprno", (QFilter[])new QFilter[]{qfilter}, (String)"");
        while (ds.hasNext()) {
            Row arow = ds.next();
            Long id = arow.getLong("mftentryseq.id");
            String oprno2 = arow.getString("oprentryentity.oprno");
            String oprparent2 = arow.getString("oprentryentity.oprparent");
            workPlanIDMap.put(id + "_" + oprparent2 + "_" + oprno2, arow.getLong("oprentryentity.id"));
            if (!oprno.equals(oprno2) || !processseq.equals(oprparent2)) continue;
            returnID = arow.getLong("oprentryentity.id");
        }
        ds.close();
        workPlanIDMap.put(keyStr, returnID);
        return returnID;
    }

    public static BigDecimal getStandQty(DynamicObject bomEntry, DynamicObject manufactureOrder, DynamicObject stockEntry) {
        if (bomEntry == null) {
            return BigDecimal.ZERO;
        }
        String qtyType = stockEntry.getString("qtytype");
        BigDecimal useratio = stockEntry.getBigDecimal("useratio").divide(ONEHUNDRED, 4, 4);
        BigDecimal orderQty = manufactureOrder.getBigDecimal("baseqty");
        BigDecimal qtynumerator = stockEntry.getBigDecimal("qtynumerator");
        BigDecimal qtydenominator = stockEntry.getBigDecimal("qtydenominator");
        DynamicObject entryunit = MPDMMftGenStocksUtils.getEntryUnit(bomEntry, stockEntry.getDynamicObject("materialid"));
        return MPDMMftGenStocksUtils.calculateStandQty(entryunit, qtyType, useratio, orderQty, qtynumerator, qtydenominator);
    }

    public static BigDecimal getDemandQty(DynamicObject bomEntry, boolean isconsiderloss, DynamicObject stockEntry, String wastagerateformula) {
        int precision = 2;
        if (bomEntry != null && bomEntry.getDynamicObject(ENTRYUNIT2) != null) {
            precision = bomEntry.getDynamicObject(ENTRYUNIT2).get(PRECISION2) == null ? 2 : bomEntry.getDynamicObject(ENTRYUNIT2).getInt(PRECISION2);
        }
        BigDecimal standqty = stockEntry.getBigDecimal("standqty");
        BigDecimal scraprate = stockEntry.getBigDecimal("scraprate");
        BigDecimal fixscrap = stockEntry.getBigDecimal("fixscrap");
        return MPDMMftGenStocksUtils.calculateDemadQty(precision, isconsiderloss, standqty, scraprate, fixscrap, wastagerateformula);
    }

    public static BigDecimal calculateDemadQty(int precision, boolean isconsiderloss, BigDecimal standqty, BigDecimal scraprate, BigDecimal fixscrap, String wastagerateformula) {
        BigDecimal demandQty = isconsiderloss ? ("A".equals(wastagerateformula) ? standqty.divide(BigDecimal.ONE.subtract(scraprate), precision, 4).add(fixscrap) : ("B".equals(wastagerateformula) ? standqty.multiply(BigDecimal.ONE.add(scraprate)).add(fixscrap) : standqty)) : standqty;
        if (standqty.compareTo(BigDecimal.ZERO) == 0) {
            demandQty = BigDecimal.ZERO;
        }
        demandQty = demandQty.setScale(precision, 4);
        return demandQty;
    }

    public static String getAutoNumber(DynamicObject stock, String orgID, String entityType) {
        CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)entityType, (DynamicObject)stock, (String)orgID);
        String number = null;
        if (codeRuleInfo != null) {
            number = CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)stock);
        }
        return number;
    }

    public static DynamicObject[] getManufactureOrderByIds(String mftorder, String[] ids) {
        if (StringUtils.isBlank((CharSequence)mftorder) || ids == null || ids.length == 0) {
            return new DynamicObject[0];
        }
        HashSet<String> selectFields = new HashSet<String>();
        if ("pm_om_purorderbill".equals(mftorder)) {
            selectFields.add("billno");
            selectFields.add("billstatus");
        } else {
            String[] keys;
            StringBuilder selectPro = MPDMMftGenStocksUtils.manufactureSelectProperties();
            for (String key : keys = StringUtils.split((String)selectPro.toString(), (String)",")) {
                if (!StringUtils.isNotBlank((CharSequence)key)) continue;
                selectFields.add(key);
            }
        }
        MainEntityType subType = (MainEntityType)EntityMetadataCache.getSubDataEntityType((String)mftorder, selectFields);
        Object[] pkIds = new Long[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            pkIds[i] = Long.parseLong(ids[i]);
        }
        return BusinessDataServiceHelper.load((Object[])pkIds, (DynamicObjectType)subType);
    }

    public static DynamicObject getProcessEntry(DynamicObject processroute, String processseq, String operationno) {
        StringBuilder keys = new StringBuilder("pdm_route");
        keys.append("_").append(processroute.getPkValue());
        Map<String, Object> map = queryThreadLocal.get();
        if (map == null) {
            map = new HashMap<String, Object>();
            queryThreadLocal.set(map);
        }
        DynamicObject processrouteobj = null;
        Object data = map.get(keys.toString());
        if (data instanceof DynamicObject) {
            processrouteobj = (DynamicObject)data;
        } else {
            if (map.containsKey(keys.toString())) {
                return null;
            }
            processrouteobj = MsProcessRouteQueryHelper.getDataCacheByID(processroute.getPkValue());
        }
        if (processrouteobj == null) {
            return null;
        }
        DynamicObjectCollection processentrys = processrouteobj.getDynamicObjectCollection("processentry");
        for (DynamicObject processentry : processentrys) {
            if (!StringUtils.equals((CharSequence)processentry.getString("parent"), (CharSequence)processseq) || !StringUtils.equals((CharSequence)processentry.getString("operationno"), (CharSequence)operationno)) continue;
            return processentry;
        }
        return null;
    }

    public static String selectStockProperties(String orderName) {
        StringBuilder selector = new StringBuilder(1550);
        selector.append("supplier,configuredcode,tracknumber,id,billno,productid,billstatus,orderno,orderid,qty,baseqty,billauxqty,mftdeptorgid,orderentryid,baseunitid,unitid,");
        selector.append("billauxunit,org,bomid,replaceno,modifytime,modifier,auxproperty,transactiontypeid,processroute,stockentry,stockentry.materialid,stockentry.qtytype,productmasterid,");
        switch (orderName) {
            case "om_mftorder": {
                selector.append("planpreparetime,stockentry.workstation,stockentry.parententryid,stockentry.childbomid,");
                break;
            }
            case "pom_mroorder": {
                selector.append("workcard,customer,project,");
                break;
            }
            case "pom_mftorder": {
                selector.append("stockentry.workstation,stockentry.parententryid,stockentry.childbomid,");
                break;
            }
            case "prop_mftorder": {
                selector.append("programme,productline,stockentry.progentryid,");
                break;
            }
        }
        selector.append("stockentry.productqty,stockentry.useratio,stockentry.qtynumerator,stockentry.oprno,stockentry.processseq,stockentry.wipqty,");
        selector.append("stockentry.qtydenominator,stockentry.fixscrap,stockentry.scraprate,stockentry.standqty,stockentry.demandqty,stockentry.actissueqty,stockentry.feedingqty,");
        selector.append("stockentry.rejectedqty,stockentry.scrapqty,stockentry.cansendqty,stockentry.unissueqty,stockentry.outsqty,stockentry.iscannegative,stockentry.operationdesc,");
        selector.append("stockentry.wastagerateformula,stockentry.isbackflush,stockentry.useqty,stockentry.iskeypart,stockentry.issuemode,stockentry.isbomextend,stockentry.childauxpropertyid,");
        selector.append("stockentry.materialid,stockentry.overissuecontrl,stockentry.issinhighlimit,stockentry.extraratioqty,stockentry.batchno,stockentry.considerminbatch,");
        selector.append("stockentry.issinlowlimit,stockentry.lackraitioqty,stockentry.oprworkcenter,stockentry.warehouseid,stockentry.location,").append("stockentry.bomentryid,stockentry.isstep,");
        selector.append("stockentry.leadtimeunit,stockentry.leadtime,stockentry.demanddate,stockentry.materialunitid,stockentry.promaterentryid,stockentry.entryconfiguredcode,");
        selector.append("stockentry.outlocation,stockentry.lot,stockentry.rework,stockentry.sourcetype,stockentry.supplyorgid,stockentry.materielinv");
        return selector.toString();
    }

    public static String selectStockHeadProp(String stockname) {
        StringBuilder selector = new StringBuilder(1550);
        selector.append("id,orderentryid,orderentryid.id");
        HashMap<String, String> propMap = new HashMap<String, String>(16);
        propMap.put("workcenter", "orderentryid.workcenter");
        propMap.put("expendbomtime", "orderentryid.expendbomtime");
        propMap.put("manuversion", "orderentryid.manuversion");
        MainEntityType stockEntityType = EntityMetadataCache.getDataEntityType((String)stockname);
        Map propStockMap = stockEntityType.getAllFields();
        IDataEntityProperty orderentryidProp = (IDataEntityProperty)propStockMap.get("orderentryid");
        BasedataProp orderBaseProp = null;
        Map propOrderMap = null;
        if (orderentryidProp instanceof BasedataProp) {
            orderBaseProp = (BasedataProp)orderentryidProp;
            String entityID = orderBaseProp.getBaseEntityId();
            MainEntityType orderBaseType = EntityMetadataCache.getDataEntityType((String)entityID);
            propOrderMap = orderBaseType.getAllFields();
        }
        for (Map.Entry propEntry : propMap.entrySet()) {
            String mftPropKey = (String)propEntry.getKey();
            String mftPropVal = (String)propEntry.getValue();
            if (propOrderMap == null || !propOrderMap.containsKey(mftPropKey)) continue;
            selector.append(",");
            selector.append(mftPropVal);
        }
        logger.info("selectStockHeadProp\uff1a" + selector);
        return selector.toString();
    }

    public static DynamicObject getOrderStock(Object orderid, Object orderEntryid, String entityType, String orderName) {
        QFilter filter1 = new QFilter("orderid", "=", (Object)(orderid != null ? orderid.toString() : "0"));
        QFilter filter2 = new QFilter("orderentryid", "=", (Object)(orderEntryid != null ? Long.parseLong(orderEntryid.toString()) : 0L));
        return BusinessDataServiceHelper.loadSingle((String)entityType, (String)MPDMMftGenStocksUtils.selectStockProperties(orderName), (QFilter[])new QFilter[]{filter1, filter2});
    }

    public static DynamicObject getOrderStock(Object orderid, Object orderEntryid, String entityType) {
        QFilter filter1 = new QFilter("orderid", "=", (Object)(orderid != null ? orderid.toString() : "0"));
        QFilter filter2 = new QFilter("orderentryid", "=", (Object)(orderEntryid != null ? Long.parseLong(orderEntryid.toString()) : 0L));
        return BusinessDataServiceHelper.loadSingle((String)entityType, (String)MPDMMftGenStocksUtils.selectStockProperties(""), (QFilter[])new QFilter[]{filter1, filter2});
    }

    public static DynamicObject getOrderStockBySelectProperties(Object orderid, Object orderEntryid, String entityType, String orderName, String selectProperties) {
        QFilter filter1 = new QFilter("orderid", "=", (Object)(orderid != null ? orderid.toString() : "0"));
        QFilter filter2 = new QFilter("orderentryid", "=", (Object)(orderEntryid != null ? Long.parseLong(orderEntryid.toString()) : 0L));
        return BusinessDataServiceHelper.loadSingle((String)entityType, (String)selectProperties, (QFilter[])new QFilter[]{filter1, filter2});
    }

    public static DynamicObject getOrderStockBySelectProperties(Object orderid, Object orderEntryid, String entityType, String selectProperties) {
        QFilter filter1 = new QFilter("orderid", "=", (Object)(orderid != null ? orderid.toString() : "0"));
        QFilter filter2 = new QFilter("orderentryid", "=", (Object)(orderEntryid != null ? Long.parseLong(orderEntryid.toString()) : 0L));
        return BusinessDataServiceHelper.loadSingle((String)entityType, (String)selectProperties, (QFilter[])new QFilter[]{filter1, filter2});
    }

    public static void deleteOrderStock(Set<Long> orderEntryidSet, String entityType) {
        String stockName = ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355", (String)"MPDMMftGenStocksUtils_17", (String)"bd-mpdm-common", (Object[])new Object[0]);
        if ("pom_mrotool".equals(entityType)) {
            stockName = ResManager.loadKDString((String)"\u68c0\u4fee\u5de5\u5177\u6e05\u5355", (String)"MPDMMftGenStocksUtils_18", (String)"bd-mpdm-common", (Object[])new Object[0]);
        }
        QFilter filter = new QFilter("orderentryid", "in", orderEntryidSet);
        String selectProperties = "id,billno,billstatus";
        DataSet ds = QueryServiceHelper.queryDataSet((String)"MMC-deleteOrderStock-QueryStocks", (String)entityType, (String)selectProperties, (QFilter[])new QFilter[]{filter}, (String)"");
        HashSet<Long> delStockIdtoOrderEntryIds = new HashSet<Long>(orderEntryidSet.size());
        ArrayList<String> stockBillno = new ArrayList<String>(16);
        while (ds.hasNext()) {
            Row arow = ds.next();
            delStockIdtoOrderEntryIds.add(arow.getLong("id"));
            if (arow.getString("billstatus").equals("A")) continue;
            stockBillno.add(arow.getString("billno"));
        }
        ds.close();
        if (stockBillno != null && stockBillno.size() > 0) {
            ErrorCode ec = new ErrorCode("save", String.format(ResManager.loadKDString((String)"%1$s%2$s\u4e0d\u662f\u6682\u5b58\u72b6\u6001\u3002", (String)"MPDMMftGenStocksUtils_26", (String)"bd-mpdm-common", (Object[])new Object[0]), stockName, StringUtils.strip((String)((Object)stockBillno).toString(), (String)"[]")));
            throw new KDBizException(ec, new Object[0]);
        }
        if (delStockIdtoOrderEntryIds.isEmpty()) {
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("ignorewarn", "true");
        option.setVariableValue("ignoreinteraction", "true");
        OperationResult executeOperate = OperationServiceHelper.executeOperate((String)"delete", (String)entityType, (Object[])delStockIdtoOrderEntryIds.toArray(new Long[delStockIdtoOrderEntryIds.size()]), (OperateOption)option);
        if (!executeOperate.isSuccess()) {
            throw new KDBizException(new ErrorCode("AutoGenerateStock3", String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25,\u81ea\u52a8\u5220\u9664%1$s\u5f02\u5e38\uff1a%2$s", (String)"MPDMMftGenStocksUtils_23", (String)"bd-mpdm-common", (Object[])new Object[0]), stockName, OrderOpUtils.getErrDetail(executeOperate))), new Object[0]);
        }
    }

    private static DynamicObject getBOMByID(String bomId) {
        Object data;
        logger.info("MftGenStocksUtils.getBOMByID" + bomId);
        StringBuilder keys = new StringBuilder("pdm_mftbom");
        keys.append("_").append(bomId);
        Map<String, Object> map = queryThreadLocal.get();
        if (map == null) {
            map = new HashMap<String, Object>();
            queryThreadLocal.set(map);
        }
        if ((data = map.get(keys.toString())) instanceof DynamicObject) {
            return (DynamicObject)data;
        }
        if (map.containsKey(keys.toString())) {
            return null;
        }
        DynamicObject loadData = MsBomQueryHelper.getDataCacheByID(bomId);
        map.put(keys.toString(), loadData);
        return loadData;
    }

    private static DynamicObject getBOMEntryByEntryID(DynamicObject bom, Long entryid) {
        if (bom != null) {
            DynamicObjectCollection bomentrys = bom.getDynamicObjectCollection(ENTRY);
            for (DynamicObject bomentry : bomentrys) {
                if (!StringUtils.equals((CharSequence)bomentry.getPkValue().toString(), (CharSequence)String.valueOf(entryid))) continue;
                return bomentry;
            }
        }
        return null;
    }

    public static DynamicObject getPromater(Object bomId, Long processroteid) {
        Object data;
        if (bomId == null || processroteid == null || processroteid == 0L) {
            return null;
        }
        StringBuilder keys = new StringBuilder("pdm_promaterdtb");
        keys.append("_").append(bomId);
        keys.append("_").append(processroteid);
        Map<String, Object> map = queryThreadLocal.get();
        if (map == null) {
            map = new HashMap<String, Object>(16);
            queryThreadLocal.set(map);
        }
        if ((data = map.get(keys.toString())) instanceof DynamicObject) {
            return (DynamicObject)data;
        }
        if (map.containsKey(keys.toString())) {
            return null;
        }
        DynamicObject loadData = MsProMaterdtbQueryHelper.getRoutMaterialDtbFromCache(Long.valueOf(bomId.toString()), processroteid);
        map.put(keys.toString(), loadData);
        return loadData;
    }

    public static String selectBOMPropertites() {
        StringBuilder string = new StringBuilder("replaceno,type,status,enable,iscoproduct,version,createorg,material,material.masterid,material.materialattr,id,number,entry,entry.seq,entry.entrymaterial,entry.entrymaterialattr,entry.entryunit,entry.entryunit.id,entry.entryunit.precision,entry.entryqtytype,entry.entryqtynumerator,entry.entryqtydenominator,entry.entryfixscrap,entry.entryscraprate,entry.entryremark,entry.entryleadtime,entry.entryoutlocation,entry.entryreplaceplan,entry.reppriority,entry.entryisreplaceplanmm,entry.entryisreplace,entry.entrytimeunit,entry.entrysupplyorg,entry.entrysupplymode,entry.entrywarehouse,entry.entryiskey,entry.entrylocation,entry.entryisbackflush,entry.entryprocessseq,entry.entryoperationnumber,entry.entryissuemode,entry.entryisbulkmaterial,entry.entryisstockalloc,entry.entryversion,entry.entryauxproperty,entry.qtyentry,qtyentry.qtyentrymaterial,entry.entryisjumplevel,entry.entryownertype,entry.entryoutorg,entry.entryoutwarehouse,entry.entryvaliddate,entry.entryinvaliddate,entry.entryecn,entry.entryecn.id,entry.entryecn.number,entry.entryecn.invaliddate,entry.entryecn.validdate,entry.entryowner,qtyentry.qtyentrybatchstartqty,qtyentry.qtyentrybatchendqty,qtyentry.qtyentryqtynumerator,qtyentry.qtyentryqtydenominator,qtyentry.qtyentryisstepfix,qtyentry.qtyentryfixscrap,qtyentry.qtyentryscraprate,entry.setupentry,setupentry.setupentrysetuplocation,setupentry.setupentryremark,setupentry.setupentryqty,entry.dateentry,dateentry.dateentrymaterial,dateentry.dateentryvaliddate,dateentry.dateentryinvaliddate,entry.entryconfiguredcode");
        return string.toString();
    }

    static Date getDemandDate(DynamicObject mtfOrg, Date planbegintime, DynamicObject stockEntry, Date planendtime) {
        BigDecimal leadtime = stockEntry.getBigDecimal("leadtime");
        Map<String, Object> map = demandDateThreadLocal.get();
        if (map == null) {
            map = new HashMap<String, Object>();
            demandDateThreadLocal.set(map);
        }
        StringBuilder keys = new StringBuilder();
        if (mtfOrg != null) {
            keys.append(mtfOrg.getPkValue());
        }
        if (planbegintime != null) {
            keys.append("##");
            keys.append(planbegintime.getTime());
        }
        if (leadtime != null) {
            keys.append("##");
            keys.append(leadtime.toString());
        }
        if (planendtime != null) {
            keys.append("##");
            keys.append(planendtime.getTime());
        }
        if (map.get(keys.toString()) != null) {
            return (Date)map.get(keys.toString());
        }
        Calendar c = Calendar.getInstance();
        c.setTime(planbegintime);
        if (leadtime != null) {
            c.add(5, leadtime.intValue());
        }
        Date replanbegintime = c.getTime();
        logger.info("----------------------------\u83b7\u53d6\u5de5\u4f5c\u65e5\u5386\u5f00\u59cb---------------------------------");
        Long startdate = System.currentTimeMillis();
        HashMap<String, Date> calendarInfoMap = new HashMap<String, Date>(16);
        replanbegintime = CalendarUtils.getRecentleWorkDateNew(mtfOrg, replanbegintime, calendarInfoMap);
        if (replanbegintime == null) {
            replanbegintime = planbegintime;
        } else if (replanbegintime.after(planendtime)) {
            replanbegintime = planendtime;
        }
        Long enddate = System.currentTimeMillis() - startdate;
        logger.info("----------------------------\u83b7\u53d6\u5de5\u4f5c\u65e5\u5386\u7ed3\u675f,\u8017\u65f6\uff1a" + enddate + "ms---------------------------------");
        map.put(keys.toString(), replanbegintime);
        return replanbegintime;
    }

    public static void updateMftStockEntry(DynamicObject stockBillEntry, DynamicObject load) {
        String name = load.getDataEntityType().getName();
        DynamicObjectCollection workPlanEntrys = load.getDynamicObjectCollection("oprentryentity");
        BigDecimal cansendqty = stockBillEntry.getBigDecimal("cansendqty");
        if (cansendqty.compareTo(BigDecimal.ZERO) > 0) {
            for (DynamicObject workPlanEntry : workPlanEntrys) {
                String seqStr = stockBillEntry.getString("processseq");
                int seqInt = NumberUtils.toInt((String)seqStr);
                String oprparent = workPlanEntry.getString("oprparent");
                boolean isProcessSeq = false;
                if ("prop_manftech".equals(name)) {
                    isProcessSeq = true;
                } else {
                    boolean bl = isProcessSeq = Integer.parseInt(oprparent) == seqInt;
                }
                if (oprparent.isEmpty() || !isProcessSeq || !StringUtils.equals((CharSequence)workPlanEntry.getString("oprno"), (CharSequence)stockBillEntry.getString("oprno"))) continue;
                stockBillEntry.set("oprno", workPlanEntry.get("oprno"));
                stockBillEntry.set("processseq", workPlanEntry.get("oprparent"));
                stockBillEntry.set("oprworkcenter", workPlanEntry.get("oprworkcenter"));
                stockBillEntry.set("machiningtype", workPlanEntry.get("machiningtype"));
                if (stockBillEntry.containsProperty("outsupplier")) {
                    stockBillEntry.set("outsupplier", workPlanEntry.get("supplier"));
                }
                stockBillEntry.set("workprocedureid", workPlanEntry.get("oproperation"));
                stockBillEntry.set("workstation", workPlanEntry.get("workstation"));
                stockBillEntry.set("operationdesc", workPlanEntry.get("oprdescription"));
                if ("sfc_manftech".equals(name)) {
                    stockBillEntry.set("beginworkbf", workPlanEntry.get("beginworkbf"));
                }
                BigDecimal leadTime = stockBillEntry.getBigDecimal("leadtime");
                Calendar c = Calendar.getInstance();
                c.setTime(workPlanEntry.getDate("oprplanbegintime"));
                c.add(5, leadTime.intValue());
                Date planFinishTime = workPlanEntry.getDate("oprplanfinishtime");
                stockBillEntry.set("demanddate", (Object)(c.getTime().getTime() > planFinishTime.getTime() ? planFinishTime : c.getTime()));
            }
        }
    }

    public static StringBuilder manftechSelectProperties() {
        StringBuilder selectPro = new StringBuilder();
        selectPro.append("id,mftentryseq,oprentryentity,oprentryentity.oprno,oprentryentity.oprparent,oprentryentity.oprworkcenter,");
        selectPro.append("oprentryentity.oprplanbegintime,oprentryentity.oprplanfinishtime,oprentryentity.machiningtype,oprentryentity.supplier,oprentryentity.oproperation,oprentryentity.workstation,oprentryentity.oprdescription,oprentryentity.beginworkbf,");
        selectPro.append("proentryentity,proentryentity.processseq,proentryentity.processseqtype");
        return selectPro;
    }

    public static void setStockEntryWarehouse(DynamicObject mtfOrg, DynamicObject stockEntry, DynamicObject orderEntry) {
        CreateStockUtils.setStockEntryWarehouse(mtfOrg, stockEntry, orderEntry, null);
    }

    public static void setStockEntryWarehouse(DynamicObject mtfOrg, DynamicObject stockEntry, DynamicObject orderEntry, OrderBaseData baseData) {
        CreateStockUtils.setStockEntryWarehouse(mtfOrg, stockEntry, orderEntry, baseData);
    }

    public static BigDecimal getUnitRateConvert(Long materialId, Long srcUnitId, Long desUnitId) {
        String message = String.format(ResManager.loadKDString((String)"\u5355\u4f4d\u8f6c\u6362 ---\u5355\u4f4d\u6362\u7b97-\u53c2\u6570 \u6e90\u5355\u4f4did:%1$s \u76ee\u6807\u5355\u4f4did:%2$s \u7269\u6599id\uff1a%3$s", (String)"MPDMMftGenStocksUtils_14", (String)"bd-mpdm-common", (Object[])new Object[0]), srcUnitId, desUnitId, materialId);
        BigDecimal unitRate = null;
        if (materialId == null || srcUnitId == null || desUnitId == null) {
            unitRate = BigDecimal.ZERO;
        } else if (srcUnitId.longValue() == desUnitId.longValue()) {
            unitRate = BigDecimal.ONE;
        } else {
            DynamicObject muConv = null;
            DynamicObject measureUnits = BusinessDataServiceHelper.loadSingleFromCache((Object)desUnitId, (String)"bd_measureunits");
            int type = MPDMMftGenStocksUtils.getUnitPrecisionAccount(measureUnits);
            try {
                muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnitId, (Long)desUnitId);
                if (muConv != null && muConv.getInt("denominator") != 0) {
                    BigDecimal numerator = muConv.getBigDecimal("numerator");
                    BigDecimal denominator = muConv.getBigDecimal("denominator");
                    unitRate = numerator.divide(denominator, measureUnits.getInt(PRECISION2), type);
                }
            }
            catch (ArithmeticException numerator) {
            }
            catch (Exception e) {
                throw new KDBizException(message);
            }
        }
        if (unitRate == null) {
            unitRate = BigDecimal.ZERO;
        }
        return unitRate;
    }

    public static int getUnitPrecisionAccount(DynamicObject measureUnits) {
        String precisionAccount = measureUnits.getString("precisionaccount");
        int type = 4;
        switch (precisionAccount) {
            case "1": {
                type = 4;
                break;
            }
            case "2": {
                type = 1;
                break;
            }
            case "3": {
                type = 0;
                break;
            }
            default: {
                type = 4;
            }
        }
        return type;
    }

    public static String getErrByRes(ConvertOperationResult pushResult) {
        StringBuilder errMessage = new StringBuilder().append(pushResult.getMessage());
        for (SourceBillReport billReport : pushResult.getBillReports()) {
            if (billReport.isFullSuccess()) continue;
            errMessage.append(billReport.getFailMessage());
        }
        return errMessage.toString();
    }

    public static void setOrderStatus(IDataModel model, IFormView view) {
        String stockName = model.getDataEntityType().getName();
        DynamicObject orderEntry = (DynamicObject)model.getValue("orderentryid");
        if (orderEntry == null) {
            return;
        }
        DynamicObject orderEntry1 = null;
        QFilter closestatus = new QFilter("treeentryentity.id", "=", orderEntry.getPkValue());
        DynamicObject manuorder = BusinessDataServiceHelper.loadSingle((String)EntityNameUtils.getEntityName(1, 0, stockName), (String)"id,name,billno,treeentryentity,treeentryentity.bizstatus,treeentryentity.planstatus,treeentryentity.taskstatus,treeentryentity.pickstatus", (QFilter[])new QFilter[]{closestatus});
        if (manuorder != null) {
            orderEntry1 = MPDMMftGenStocksUtils.getManuEntryByEntryID(manuorder, orderEntry.getPkValue().toString());
        }
        if (orderEntry1 != null) {
            String planstatus = orderEntry1.get("planstatus") == null ? "" : orderEntry1.getString("planstatus");
            String taskstatus = orderEntry1.get("taskstatus") == null ? "" : orderEntry1.getString("taskstatus");
            String bizstatus = orderEntry1.get("bizstatus") == null ? "" : orderEntry1.getString("bizstatus");
            String pickstatus = orderEntry1.get("pickstatus") == null ? "" : orderEntry1.getString("pickstatus");
            planstatus = ManuBillPlanStatusEnum.getName(planstatus);
            taskstatus = ManuBillTaskStatusEnum.getName(taskstatus);
            bizstatus = ManuBillBizStatusEnum.getName(bizstatus);
            pickstatus = ManuBillPickStatusEnum.getName(pickstatus);
            model.setValue("orderstatus", (Object)(planstatus + "/" + taskstatus + "/" + bizstatus + "/" + pickstatus));
            view.getModel().setDataChanged(false);
        }
    }

    private static Map<String, Object> getOmOrderQtyMap(Object orderEntryId) {
        Map<String, Object> dataMap;
        String orderKeys = String.valueOf(orderEntryId);
        Map<String, Map<String, Object>> orderQtyDataMap = omOrderQtyThreadLocal.get();
        if (orderQtyDataMap == null) {
            orderQtyDataMap = new HashMap<String, Map<String, Object>>();
            omOrderQtyThreadLocal.set(orderQtyDataMap);
        }
        if ((dataMap = orderQtyDataMap.get(orderKeys)) != null && !dataMap.isEmpty()) {
            return dataMap;
        }
        QFilter filter = new QFilter("billentry.id", "=", (Object)Long.valueOf(orderEntryId.toString()));
        dataMap = new HashMap<String, Object>(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-MPDMMftGenStocksUtils-getOmOrderQtyMap", (String)"pm_om_purorderbill", (String)"billentry.invbaseqty invbaseqty ,billentry.baseqty baseqty,billentry.returnbaseqty returnbaseqty  ", (QFilter[])new QFilter[]{filter}, (String)"");){
            while (ds.hasNext()) {
                Row dsRow = ds.next();
                dataMap.put("invbaseqty", dsRow.getBigDecimal("invbaseqty"));
                dataMap.put("baseqty", dsRow.getBigDecimal("baseqty"));
                dataMap.put("returnbaseqty", dsRow.getBigDecimal("returnbaseqty"));
            }
        }
        orderQtyDataMap.put(orderKeys, dataMap);
        return dataMap;
    }

    private static BigDecimal getparentQty(DynamicObjectCollection notallocatentrys, Long parentPKID) {
        BigDecimal returnValue = null;
        for (DynamicObject notallocatentry : notallocatentrys) {
            Long pkid = notallocatentry.getLong("id");
            if (!pkid.equals(parentPKID)) continue;
            BigDecimal dtballocatqty = notallocatentry.getBigDecimal("nallocatqty");
            BigDecimal dtballocatqtydeno = notallocatentry.getBigDecimal("nallocatqtydeno");
            if (dtballocatqty.compareTo(BigDecimal.ZERO) == 0) {
                dtballocatqty = notallocatentry.getBigDecimal("nallocatmole");
                dtballocatqtydeno = notallocatentry.getBigDecimal("nallocatdeno");
            }
            returnValue = dtballocatqty.divide(dtballocatqtydeno, 4, 4);
            break;
        }
        if (returnValue == null || returnValue.compareTo(BigDecimal.ZERO) == 0) {
            returnValue = BigDecimal.ONE;
        }
        return returnValue;
    }

    private static int getChildIndex(List<Promater> resultList, Promater tpromater) {
        DynamicObject bomEntryMaterial = tpromater.getBomEntry().getDynamicObject(ENTRYMATERIAL);
        if (bomEntryMaterial == null) {
            return -1;
        }
        int size = resultList.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject material;
            Promater listPromater = resultList.get(i);
            DynamicObject listBomEntry = listPromater.getBomEntry();
            Object bomObj = listBomEntry.getParent();
            if (bomObj == null || !(material = ((DynamicObject)bomObj).getDynamicObject("material")).getPkValue().equals(bomEntryMaterial.getPkValue())) continue;
            return i;
        }
        Object bomObj = tpromater.getBomEntry().getParent();
        if (bomObj != null) {
            DynamicObject material = ((DynamicObject)bomObj).getDynamicObject("material");
            for (int i = 0; i < size; ++i) {
                Promater listPromater = resultList.get(i);
                bomEntryMaterial = listPromater.getBomEntry().getDynamicObject(ENTRYMATERIAL);
                if (!material.getPkValue().equals(bomEntryMaterial.getPkValue())) continue;
                return i + 1;
            }
        }
        return 0;
    }

    private static boolean isFreeDistribut(DynamicObject promater) {
        return "1001".equals(promater.getString("distribut"));
    }

    private static boolean checkExistXN(DynamicObject promater) {
        Long bomID;
        DynamicObjectCollection dtbmaterentrys = promater.getDynamicObjectCollection("dtbmaterentry");
        DynamicObjectCollection notallocatentrys = promater.getDynamicObjectCollection("notallocatentry");
        Long mainBomid = promater.getDynamicObject("bom").getLong("id");
        for (DynamicObject dtbmaterentry : dtbmaterentrys) {
            Long bomennryID;
            bomID = dtbmaterentry.getLong("dtballocatbomid");
            if (mainBomid.equals(bomID) || (bomennryID = Long.valueOf(dtbmaterentry.getLong("dtballocatbomentryid"))) == null || bomennryID.equals(0L)) continue;
            return true;
        }
        for (DynamicObject notallocatentry : notallocatentrys) {
            Long bomennryID;
            bomID = notallocatentry.getLong("nallocatbomid");
            if (mainBomid.equals(bomID)) continue;
            boolean nallocatisjumplevel = notallocatentry.getBoolean("nallocatisjumplevel");
            if (nallocatisjumplevel) {
                return true;
            }
            BigDecimal dtballocatqty = notallocatentry.getBigDecimal("nallocatqty");
            if (dtballocatqty.compareTo(BigDecimal.ZERO) == 0 || (bomennryID = Long.valueOf(notallocatentry.getLong("nallocatbomentryid"))) == null || bomennryID.equals(0L)) continue;
            return true;
        }
        return false;
    }

    private static List<Promater> getBomJumpData(String mainBomId, DynamicObject orderEntry, List<Promater> resultList, DynamicObject workprocedure, DynamicObject processroute) {
        DistributeSessionlessCache cache;
        String res;
        JSONArray resArray;
        JSONArray filterArray = new JSONArray(16);
        Date expandtime = orderEntry.getDate("expendbomtime");
        String bomExpandType = "E";
        Long routeId = 0L;
        if (processroute != null) {
            routeId = (Long)processroute.getPkValue();
        }
        JSONObject jsobject = CreateStockByBomUtils.getBomFilterJsonType(Long.valueOf(mainBomId), orderEntry.getBigDecimal("qty"), expandtime, bomExpandType, routeId);
        filterArray.add((Object)jsobject);
        String result = CreateStockByBomUtils.getQueryDataRes(filterArray.toString());
        if (result.indexOf("true") >= 0 && (resArray = JSONArray.parseArray((String)(res = (String)(cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("mmc-fmm-bomsearch")).get(CreateStockByBomUtils.getBomFilterStrType(Long.valueOf(mainBomId), orderEntry.getBigDecimal("qty"), expandtime, bomExpandType, routeId))))) != null) {
            for (int i = 0; i < resArray.size(); ++i) {
                DynamicObject processEntry;
                JSONObject resJson = (JSONObject)resArray.get(i);
                BomBaseData bomdata = CreateStockByBomUtils.getBomBaseData(resJson);
                if (!bomdata.getIsJump()) continue;
                Long bomID = bomdata.getBomId();
                Long bomentryID = bomdata.getBomEntryId();
                Promater tpromater = new Promater();
                DynamicObject bom = MPDMMftGenStocksUtils.getBOMByID(String.valueOf(bomID));
                DynamicObject bomEntryOld = MPDMMftGenStocksUtils.getBOMEntryByEntryID(bom, bomentryID);
                if (bomEntryOld == null) continue;
                DynamicObject bomEntry = MPDMMftGenStocksUtils.cloneBomEntry(bomEntryOld);
                Date entryvaliddate = bomEntry.getDate(ENTRYVALIDDATE2);
                Date entryinvaliddate = bomEntry.getDate(ENTRYINVALIDDATE2);
                if (expandtime.compareTo(entryvaliddate) <= 0 || expandtime.compareTo(entryinvaliddate) >= 0) continue;
                bomEntry.set(ENTRYQTYNUMERATOR, bomdata.getQtynumerator());
                bomEntry.set(ENTRYQTYDENOMINATOR, bomdata.getQtydenominator());
                bomEntry.set(ENTRYQTYTYPE, bomdata.getQtytype());
                bomEntry.setParent((Object)bom);
                tpromater.setOprno(workprocedure.getString("operationno"));
                tpromater.setProcessseq(workprocedure.getString("processseq"));
                tpromater.setMachiningtype(workprocedure.getString("machtype"));
                tpromater.setWorkprocedure(workprocedure.getDynamicObject("operationnum"));
                tpromater.setPromaterEntryid(0L);
                tpromater.setBomEntry(bomEntry);
                tpromater.setJumplevel(true);
                String processseq = tpromater.getProcessseq();
                if (!StringUtils.isEmpty((CharSequence)processseq) && processroute != null && tpromater.getOprno() != null && (processEntry = MPDMMftGenStocksUtils.getProcessEntry(processroute, processseq, tpromater.getOprno())) != null) {
                    tpromater.setWorkcenter(processEntry.getDynamicObject("workcenter"));
                    tpromater.setOutsupply(processEntry.getDynamicObject("supplier"));
                }
                resultList.add(tpromater);
            }
        }
        return resultList;
    }

    public static boolean isShowJumpFromOrder(DynamicObject orderEntry) {
        if (orderEntry == null) {
            return false;
        }
        Object parent = orderEntry.getParent();
        if (parent instanceof DynamicObject) {
            DynamicObject order = (DynamicObject)parent;
            DynamicObject transactionType = order.getDynamicObject("transactiontype");
            return CreateStockByBomUtils.isShowJump(transactionType);
        }
        return false;
    }

    public static void aculUseQtyByOrderEntryId(List<Long> orderEntryIdList, String productiondomain) {
        String orderName = GetEntityNameHelper.getOrderEntityName(productiondomain);
        StockCulUtils.batchCulUseQtyByOrderEntryId(orderEntryIdList, orderName);
    }
}

