/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.common.mftorder.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.botp.ConvertBill;
import kd.bos.entity.botp.ConvertOpType;
import kd.bos.entity.botp.ConvertRuleCache;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.runtime.ConvertOpParameter;
import kd.bos.entity.botp.runtime.ConvertOpRule;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class MftOrderToProorderUtil {
    private static final Log logger = LogFactory.getLog(MftOrderToProorderUtil.class);

    public static Map<String, Long> getCurrencyAndExRateTable(Long orgId) {
        Map mapOrg;
        if (orgId != 0L && (mapOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)false, (Boolean)true)) != null && mapOrg.get("id") != null) {
            logger.info("\u901a\u8fc7\u63a5\u53e3\u83b7\u53d6\u9700\u6c42\u7ec4\u7ec7\u7684\u6838\u7b97\u4e3b\u4f53\uff1a" + mapOrg);
            Map map = BaseDataServiceHelper.getBaseAccountingInfo((Long)((Long)mapOrg.get("id")));
            if (map != null && map.size() != 0) {
                logger.info("\u901a\u8fc7\u63a5\u53e3\u83b7\u53d6\u6838\u7b97\u4e3b\u4f53\u7684\u672c\u4f4d\u5e01\u548c\u6c47\u7387\u8868\uff1a" + map);
                return map;
            }
        }
        return null;
    }

    public static ListSelectedRowCollection getStockSelectedRows(String pkid, Object entryid, String type) {
        DynamicObject stock = new DynamicObject();
        String selectProperties = "id,billstatus,stockentry.id,stockentry.wipqty";
        stock = StringUtils.equals((CharSequence)"pushpick", (CharSequence)type) || StringUtils.equals((CharSequence)"pushreturn", (CharSequence)type) ? MPDMMftGenStocksUtils.getOrderStockBySelectProperties(pkid, entryid, "pom_mftstock", selectProperties) : MPDMMftGenStocksUtils.getOrderStockBySelectProperties(pkid, entryid, "om_mftstock", "om_mftorder", selectProperties);
        ListSelectedRowCollection selectedRows = new ListSelectedRowCollection();
        if (null != stock && StringUtils.equals((CharSequence)"C", (CharSequence)stock.getString("billstatus"))) {
            DynamicObjectCollection stockentrys = stock.getDynamicObjectCollection("stockentry");
            for (int j = 0; j < stockentrys.size(); ++j) {
                ListSelectedRow row;
                DynamicObject dynamicObject = (DynamicObject)stockentrys.get(j);
                BigDecimal wipQty = dynamicObject.getBigDecimal("wipqty");
                if (StringUtils.equals((CharSequence)"ompushreq", (CharSequence)type) || StringUtils.equals((CharSequence)"pushpick", (CharSequence)type) || StringUtils.equals((CharSequence)"ompushpick", (CharSequence)type) || StringUtils.equals((CharSequence)"ompushtrans", (CharSequence)type)) {
                    row = new ListSelectedRow(stock.getPkValue());
                    row.setEntryEntityKey("stockentry");
                    row.setEntryPrimaryKeyValue(dynamicObject.getPkValue());
                    selectedRows.add((Object)row);
                    continue;
                }
                if (!StringUtils.equals((CharSequence)"pushreturn", (CharSequence)type) && !StringUtils.equals((CharSequence)"ompushreturn", (CharSequence)type) || wipQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                row = new ListSelectedRow(stock.getPkValue());
                row.setEntryEntityKey("stockentry");
                row.setEntryPrimaryKeyValue(dynamicObject.getPkValue());
                selectedRows.add((Object)row);
            }
        }
        return selectedRows;
    }

    public static ConvertOpParameter buildParameter(IFormView iListView, IBillView iBillView, String type) {
        ConvertOpParameter opParameter = new ConvertOpParameter();
        opParameter.setOpType(ConvertOpType.Push);
        opParameter.setAppId("pom");
        opParameter.setEntityNumber("pom_mftstock");
        List<Object> bills = MftOrderToProorderUtil.loadTargetBills(iListView, iBillView, type);
        if (StringUtils.equals((CharSequence)"pushreturn", (CharSequence)type)) {
            bills = bills.stream().filter(var -> "im_mdc_mftreturnorder".equals(var.getEntityNumber())).collect(Collectors.toList());
        } else if (StringUtils.equals((CharSequence)"pushpick", (CharSequence)type)) {
            bills = bills.stream().filter(var -> "im_mdc_mftproorder".equals(var.getEntityNumber())).collect(Collectors.toList());
        } else if (StringUtils.equals((CharSequence)"ompushreturn", (CharSequence)type)) {
            bills = bills.stream().filter(var -> "im_mdc_omreturnbill".equals(var.getEntityNumber())).collect(Collectors.toList());
            opParameter.setAppId("om");
            opParameter.setEntityNumber("om_mftstock");
        } else if (StringUtils.equals((CharSequence)"ompushpick", (CharSequence)type)) {
            bills = bills.stream().filter(var -> "im_mdc_omoutbill".equals(var.getEntityNumber())).collect(Collectors.toList());
            opParameter.setAppId("om");
            opParameter.setEntityNumber("om_mftstock");
        } else if (StringUtils.equals((CharSequence)"ompushtrans", (CharSequence)type)) {
            bills = bills.stream().filter(var -> "im_transdirbill".equals(var.getEntityNumber())).collect(Collectors.toList());
            opParameter.setAppId("om");
            opParameter.setEntityNumber("om_mftstock");
        } else if (StringUtils.equals((CharSequence)"ompushreq", (CharSequence)type)) {
            bills = bills.stream().filter(var -> "im_mdc_mftomreqapplybill".equals(var.getEntityNumber())).collect(Collectors.toList());
            opParameter.setAppId("om");
            opParameter.setEntityNumber("om_mftstock");
        }
        if (bills != null) {
            opParameter.getBills().addAll(bills);
        }
        if (null != iListView) {
            IListView listView = (IListView)iListView;
            opParameter.setSelectedRows(MftOrderToProorderUtil.getListSelectRow(listView.getSelectedRows(), type));
        } else {
            IBillModel billModel = (IBillModel)iBillView.getModel();
            opParameter.setSelectedRows(MftOrderToProorderUtil.getEditSelectRow(iBillView, billModel, type));
        }
        opParameter.setDefTargetBill("");
        opParameter.setDefRuleId("");
        opParameter.setHasRight(false);
        return opParameter;
    }

    private static ListSelectedRowCollection getListSelectRow(ListSelectedRowCollection selects, String type) {
        ListSelectedRowCollection resultSelect = new ListSelectedRowCollection();
        for (int i = 0; i < selects.size(); ++i) {
            ListSelectedRow row = selects.get(i);
            String pkid = row.getPrimaryKeyValue().toString();
            Object entryPk = row.getEntryPrimaryKeyValue();
            ListSelectedRowCollection resultsimple = MftOrderToProorderUtil.getStockSelectedRows(pkid, entryPk, type);
            resultSelect.addAll((Collection)resultsimple);
        }
        return resultSelect;
    }

    private static ListSelectedRowCollection getEditSelectRow(IBillView iBillView, IBillModel billModel, String type) {
        ListSelectedRowCollection resultSelect = new ListSelectedRowCollection();
        EntryGrid entryGrid = (EntryGrid)iBillView.getControl("treeentryentity");
        DynamicObject dataEntity = billModel.getDataEntity();
        String pkid = dataEntity.getPkValue().toString();
        for (int i = 0; i < entryGrid.getSelectRows().length; ++i) {
            DynamicObject entry = billModel.getEntryRowEntity("treeentryentity", entryGrid.getSelectRows()[i]);
            Object pkValue = entry.getPkValue();
            String producttype = entry.getString("producttype");
            if (!"C".equals(producttype)) continue;
            ListSelectedRowCollection resultsimple = MftOrderToProorderUtil.getStockSelectedRows(pkid, pkValue, type);
            resultSelect.addAll((Collection)resultsimple);
        }
        return resultSelect;
    }

    private static List<ConvertBill> loadTargetBills(IFormView iListView, IBillView iBillView, String type) {
        ArrayList<ConvertBill> list = new ArrayList<ConvertBill>(10);
        String sourceEntityNumber = "pom_mftstock";
        if (StringUtils.equals((CharSequence)"ompushreq", (CharSequence)type) || StringUtils.equals((CharSequence)"ompushreturn", (CharSequence)type) || StringUtils.equals((CharSequence)"ompushpick", (CharSequence)type) || StringUtils.equals((CharSequence)"ompushtrans", (CharSequence)type)) {
            sourceEntityNumber = "om_mftstock";
        }
        List bills = ConvertMetaServiceHelper.loadConvertBills((String)sourceEntityNumber, (ConvertOpType)ConvertOpType.Push);
        Set<Long> srcBillTypeIds = MftOrderToProorderUtil.getSrcBillTypeIds(iListView, iBillView);
        for (ConvertBill bill : bills) {
            List<ConvertOpRule> opRules = MftOrderToProorderUtil.filterRules(bill, srcBillTypeIds, sourceEntityNumber);
            if (opRules.isEmpty()) continue;
            bill.getRules().addAll(opRules);
            list.add(bill);
        }
        return list;
    }

    private static Set<Long> getSrcBillTypeIds(IFormView iListView, IBillView iBillView) {
        HashSet<Long> billTypeIds = new HashSet<Long>();
        if (null != iListView) {
            IListView listView = (IListView)iListView;
            for (ListSelectedRow row : listView.getSelectedRows()) {
                if (row.getBillTypeID() == null || Long.compare(0L, row.getBillTypeID()) == 0) continue;
                billTypeIds.add(row.getBillTypeID());
            }
        } else {
            DynamicObject billTypeObj;
            String billTypeKey = ((BillEntityType)iBillView.getModel().getDataEntityType()).getBillType();
            if (StringUtils.isNotBlank((CharSequence)billTypeKey) && (billTypeObj = (DynamicObject)iBillView.getModel().getValue(billTypeKey)) != null) {
                billTypeIds.add((Long)billTypeObj.getPkValue());
            }
        }
        return billTypeIds;
    }

    private static List<ConvertOpRule> filterRules(ConvertBill bill, Set<Long> srcBillTypeIds, String sourceEntityNumber) {
        ArrayList<ConvertOpRule> opRules = new ArrayList<ConvertOpRule>(10);
        List<ConvertRuleElement> rules = MftOrderToProorderUtil.loadRules(sourceEntityNumber, bill.getEntityNumber());
        if (rules.isEmpty()) {
            return opRules;
        }
        for (ConvertRuleElement rule : rules) {
            if (!rule.isEnabled()) continue;
            ConvertOpRule opRule = new ConvertOpRule(rule.getId(), rule.getName().toString());
            opRule.setVisibled(rule.isVisibled());
            opRules.add(opRule);
        }
        return opRules;
    }

    private static List<ConvertRuleElement> loadRules(String sourceEntityNumber, String targetEntityNumber) {
        List rules = ConvertRuleCache.loadRules((String)sourceEntityNumber, (String)targetEntityNumber);
        ArrayList<ConvertRuleElement> enableRules = new ArrayList<ConvertRuleElement>();
        for (ConvertRuleElement rule : rules) {
            if (!rule.isEnabled()) continue;
            enableRules.add(rule);
        }
        return enableRules;
    }
}

